//============================================================================================
/**
 * @file	talk_msg.c
 * @brief	bZ[W\
 * @author	Hiroyuki Nakamura
 * @date	2004.10.28
 */
//============================================================================================
#define TALK_MSG_H_GLOBAL

#include "common.h"
#include "fntsys.h"

#include "system/bmp_list.h"
#include "system/bmp_menu.h"
#include "system/pm_str.h"
#include "system/fontproc.h"
#include "system/arc_util.h"
#include "fld_bmp.h"
#include "system/lib_pack.h"
#include "system/pmfprint.h"
#include "system/window.h"

#include "talk_msg.h"
#include "fieldmap.h"
#include "system/palanm.h"


//============================================================================================
//	V{`
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================
extern u8 MsgSpeedGet(void);
extern u8 TalkWinNumGet(void);


//============================================================================================
//	O[oϐ
//============================================================================================




//--------------------------------------------------------------------------------------------
/**
 * bZ[W\VXe
 *
 * @param	type	pbg]^Cv
 * @param	init	bZ[WvgtO
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FieldMsgPrintInit( u32 type, u32 init )
{
	if( init == MSG_PRINT_INIT_ON ){
		MSG_PrintInit();
	}
	SystemFontPaletteLoad( type, FLD_MENU_WIN_PAL * 32, HEAPID_FIELD );
	TalkFontPaletteLoad( type, FLD_MSG_WIN_PAL * 32, HEAPID_FIELD );
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hbpBMP擾
 *
 * @param	ini		BGLf[^
 * @param	win		BMPf[^i[ꏊ
 * @param	frmnum	BGt[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FldTalkBmpAdd( GF_BGL_INI * ini, GF_BGL_BMPWIN * win, u32 frmnum )
{
	if( frmnum == FLD_MBGFRM_FONT ){
		GF_BGL_BmpWinAdd(
			ini, win, FLD_MBGFRM_FONT, FLD_MSG_WIN_PX, FLD_MSG_WIN_PY,
			FLD_MSG_WIN_SX, FLD_MSG_WIN_SY, FLD_MSG_WIN_PAL, FLD_MSG_WIN_CGX );
	}else{
		GF_BGL_BmpWinAdd(
			ini, win, FLD_SBGFRM_FONT, FLD_MSG_WIN_S_PX, FLD_MSG_WIN_S_PY,
			FLD_MSG_WIN_S_SX, FLD_MSG_WIN_S_SY, FLD_MSG_WIN_S_PAL, FLD_MSG_WIN_S_CGX );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hbEBhE\
 *
 * @param	win		BMPf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FldTalkWinPut( GF_BGL_BMPWIN * win )
{
	TalkWinGraphicSet(
		win->ini, GF_BGL_BmpWinGet_Frame( win ),
		TALK_WIN_CGX_NUM, TALK_WIN_PAL, TalkWinNumGet(), HEAPID_FIELD );

	GF_BGL_BmpWinDataFill( win, 15 );
	BmpTalkWinWrite( win, WINDOW_TRANS_ON, TALK_WIN_CGX_NUM, TALK_WIN_PAL );
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hbX^[g
 *
 * @param	win		BMPf[^
 * @param	msg		bZ[W
 * @param	skip	XLbvtO
 *
 * @return	bZ[WCfbNX
 */
//--------------------------------------------------------------------------------------------
u8 FldTalkMsgStart( GF_BGL_BMPWIN * win, STRBUF * msg, u8 skip )
{
	MsgPrintSkipFlagSet( skip );
	MsgPrintAutoFlagSet( MSG_SKIP_OFF );

	return GF_STR_PrintSimple( win, FONT_TALK, msg, 0, 0, MsgSpeedGet(), NULL );
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hbI҂
 *
 * @param	msg_index	bZ[WCfbNX
 *
 * @retval	"0 = b"
 * @retval	"1 = I"
 */
//--------------------------------------------------------------------------------------------
u8 FldTalkMsgEndCheck( u8 msg_index )
{
	if( GF_MSG_PrintEndCheck( msg_index ) == 0 ){
		return 1;
	}
	return 0;
}




//--------------------------------------------------------------------------------------------
/**
 * tB[hŔppBMP擾
 *
 * @param	ini		BGLf[^
 * @param	win		BMPf[^i[ꏊ
 * @param	type	Ŕ^Cv
 * @param	frmnum	BGt[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FldBoardBmpAdd( GF_BGL_INI * ini, GF_BGL_BMPWIN * win, u16 type, u16 frmnum )
{
	u16	px, sx;

	if( type == BOARD_TYPE_TOWN || type == BOARD_TYPE_ROAD ){
		px = FLD_BOARD_WIN_PX;
		sx = FLD_BOARD_WIN_SX;
	}else{
		px = FLD_MSG_WIN_PX;
		sx = FLD_MSG_WIN_SX;
	}

	if( frmnum == FLD_MBGFRM_FONT ){
		GF_BGL_BmpWinAdd(
			ini, win, FLD_MBGFRM_FONT, px, FLD_BOARD_WIN_PY,
			sx, FLD_BOARD_WIN_SY, FLD_BOARD_WIN_PAL, FLD_BOARD_WIN_CGX );
	}else{
		GF_BGL_BmpWinAdd(
			ini, win, FLD_SBGFRM_FONT, px, FLD_BOARD_WIN_S_PY,
			sx, FLD_BOARD_WIN_S_SY, FLD_BOARD_WIN_S_PAL, FLD_BOARD_WIN_S_CGX );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * tB[hŔEBhE\
 *
 * @param	win		BMPf[^
 * @param	type	Ŕ^Cv
 * @param	map		}bvԍ
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void FldBoardWinPut( GF_BGL_BMPWIN * win, u16 type, u16 map )
{
	BoardWinGraphicSet(
		win->ini, GF_BGL_BmpWinGet_Frame( win ),
		BOARD_WIN_CGX_NUM, BOARD_WIN_PAL, type, map, HEAPID_FIELD );

	GF_BGL_BmpWinDataFill( win, 15 );
	BmpBoardWinWrite( win, WINDOW_TRANS_ON, BOARD_WIN_CGX_NUM, BOARD_WIN_PAL, type );
}
