//============================================================================================
/**
 * @file	tr_card_setup.c
 * @bfief	g[i[J[hZbgAbv
 * @author	Nozomu Saito
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "field/field.h"
#include "system/mystatus.h"
#include "system/zukanwork.h"
#include "application/trainer_card.h"


static void MakeTrainerInfo(const u8 inBadgeBrushFlg,
							FIELDSYS_WORK *fsys, 
							TR_CARD_DATA *outTrCardData);

static void MakeBadgeInfo(TR_BADGE_DATA *outTrBadgeData);

void TRCSET_SetTrCardDataCommon(const u8 inBadgeBrushFlg,
								const u8 inVersion,
								const u8 inCardRank,
								TR_CARD_DATA *outTrCardDadta);

void TRCSET_SetTrCardDataFace(	const u16 inID,
								const u8  inSex,
								const STRCODE *inName,
								const u32 inMoney,
								const u32 inPokeBook,
								const u32 inScore,
								TR_CARD_DATA *outTrCardDadta);

void TRCSET_SetTrCardDataTime(	const u16 inPlay_h,
								const u8 inPlay_m,
								const u8 inPlay_s,
								const u16 inStart_h,
								const u8 inStart_m,
								const u8 inStart_s,
								const u16 inClear_h,
								const u8 inClear_m,
								const u8 inClear_s,
								TR_CARD_DATA *outTrCardDadta);

void TRCSET_SetTrCardDataBack(	const u32 inCommNum,
								const u32 CommBattleWin,
								const u32 CommBattleLose,
								const u32 CommTrade,
								TR_CARD_DATA *outTrCardDadta);
void TRCSET_SetTrCardDataBadge(	TR_CARD_DATA *outTrCardDadta );

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hWāAf[^쐬(ʐMp)
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void TRCSET_MakeTrainerInfo(const u8 inBadgeBrushFlg,
							FIELDSYS_WORK *fsys, 
							TR_CARD_DATA *outTrCardData)
{
	MYSTATUS *my_st;
	my_st = SaveData_GetMyStatus(GameSystem_GetSaveData(fsys));
	
	TRCSET_SetTrCardDataCommon( inBadgeBrushFlg, PM_VERSION, TR_CARD_RANK_NORMAL,
								outTrCardData);

	TRCSET_SetTrCardDataFace(	MyStatus_GetID_Low(my_st),
								MyStatus_GetMySex(my_st),
								MyStatus_GetMyName(my_st),
								MyStatus_GetGold(my_st),
								ZukanWork_GetPokeGetCount(SaveData_GetZukanWork(fsys->savedata)),
								999999,
								outTrCardData);
	
	TRCSET_SetTrCardDataTime(	MyStatus_GetPlayTimeHour(my_st),
								MyStatus_GetPlayTimeMinute(my_st),
								MyStatus_GetPlayTimeSecond(my_st),
								0,
								0,
								0,
								0,
								0,
								0,
								outTrCardData);
	
	TRCSET_SetTrCardDataBack(	0,
								0,
								0,
								0,
								outTrCardData);

	TRCSET_SetTrCardDataBadge( outTrCardData );

}

//--------------------------------------------------------------------------------------------
/**
 * obWf[^쐬
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MakeBadgeInfo(TR_BADGE_DATA *outTrBadgeData)
{
	u8 i;
#ifdef PM_DEBUG	
	for(i=0;i<8;i++){
		outTrBadgeData[i].GymReaderNo = i;			//W[_[ʃio[
		outTrBadgeData[i].BadgeType = i;			//obWʃio[
		outTrBadgeData[i].BadgeLevel = 0;			//obWx
		outTrBadgeData[i].BadgeHold = 1;			//obWtO
		outTrBadgeData[i].BadgeScruchCount = 0;		//
	}
#endif	
}

//--------------------------------------------------------------------------------------------
/**
 * g[i[J[hAP[V
 *
 * @param
 * @param
 *
 * @return	
 */
//--------------------------------------------------------------------------------------------
TR_CARD_DATA *TRCSET_AllocTrainerCardData( const u16 inHeapID )
{
	TR_CARD_DATA * tcd = sys_AllocMemory( inHeapID, sizeof(TR_CARD_DATA) );
	memset( tcd, 0, sizeof(TR_CARD_DATA) );

	return tcd; 
}

void TRCSET_FreeTrainerCardData( TR_CARD_DATA *outData )
{
	sys_FreeMemoryEz(outData);
}

void TRCSET_SetTrCardDataCommon(const u8 inBadgeBrushFlg,
								const u8 inVersion,
								const u8 inCardRank,
								TR_CARD_DATA *outTrCardDadta)
{
	//obWAvLtO
	outTrCardDadta->BrushValid = inBadgeBrushFlg;
	//\tgo[W
	outTrCardDadta->Version = inVersion;
	//J[hN;
	outTrCardDadta->CardRank = inCardRank;
}

void TRCSET_SetTrCardDataFace(	const u16 inID,
								const u8  inSex,
								const STRCODE *inName,
								const u32 inMoney,
								const u32 inPokeBook,
								const u32 inScore,
								TR_CARD_DATA *outTrCardDadta)
{
	//g[i[ID
	outTrCardDadta->TrainerID = inID;
	//
	outTrCardDadta->TrSex = inSex;
	//g[i[
	outTrCardDadta->TrainerName = inName;
	//Â
	outTrCardDadta->Money = inMoney;
	//
	outTrCardDadta->PokeBook = inPokeBook;
	//XRA
	outTrCardDadta->Score = inScore;
}

void TRCSET_SetTrCardDataTime(	const u16 inPlay_h,
								const u8 inPlay_m,
								const u8 inPlay_s,
								const u16 inStart_h,
								const u8 inStart_m,
								const u8 inStart_s,
								const u16 inClear_h,
								const u8 inClear_m,
								const u8 inClear_s,
								TR_CARD_DATA *outTrCardDadta)
{
	//vC
	outTrCardDadta->PlayTime_h = inPlay_h;
	outTrCardDadta->PlayTime_m = inPlay_m;
	outTrCardDadta->PlayTime_s = inPlay_s;
	//Jn
	outTrCardDadta->StartTime_h = inStart_h;
	outTrCardDadta->StartTime_m = inStart_m;
	outTrCardDadta->StartTime_s = inStart_s;
	//NA
	outTrCardDadta->ClearTime_h = inClear_h;
	outTrCardDadta->ClearTime_m = inClear_m;
	outTrCardDadta->ClearTime_s = inClear_s;
}

void TRCSET_SetTrCardDataBack(	const u32 inCommNum,
								const u32 CommBattleWin,
								const u32 CommBattleLose,
								const u32 CommTrade,
								TR_CARD_DATA *outTrCardDadta)
{
	//ʐM
	outTrCardDadta->CommNum = inCommNum;
	//ʐM퓬
	outTrCardDadta->CommBattleWin = CommBattleWin;
	outTrCardDadta->CommBattleLose = CommBattleLose;
	//ʐM
	outTrCardDadta->CommTrade = CommTrade;
}

void TRCSET_SetTrCardDataBadge(	TR_CARD_DATA *outTrCardDadta )
{
	//
	MakeBadgeInfo(outTrCardDadta->BadgeData);
}

