//============================================================================================
/**
 * @file	tr_card_setup.h
 * @bfief	g[i[J[hZbgAbv
 * @author	Nozomu Saito
 */
//============================================================================================
#ifndef __TR_CARD_SETUP_H__
#define __TR_CARD_SETUP_H__

#include "common.h"
#include "field_common.h"
#include "application/trainer_card.h"

extern TR_CARD_DATA *TRCSET_AllocTrainerCardData( const u16 inHeapID );
void TRCSET_FreeTrainerCardData( TR_CARD_DATA *outData );
extern void TRCSET_MakeTrainerInfo(	const u8 inBadgeBrushFlg,
									FIELDSYS_WORK *fsys, 
									TR_CARD_DATA *outTrCardData);
extern void TRCSET_SetTrCardDataCommon(	const u8 inBadgeBrushFlg,
										const u8 inVersion,
										const u8 inCardRank,
										TR_CARD_DATA *outTrCardDadta);

extern void TRCSET_SetTrCardDataFace(	const u16 inID,
										const u8  inSex,
										const STRCODE *inName,
										const u32 inMoney,
										const u32 inPokeBook,
										const u32 inScore,
										TR_CARD_DATA *outTrCardDadta);

extern void TRCSET_SetTrCardDataTime(	const u16 inPlay_h,
										const u8 inPlay_m,
										const u8 inPlay_s,
										const u16 inStart_h,
										const u8 inStart_m,
										const u8 inStart_s,
										const u16 inClear_h,
										const u8 inClear_m,
										const u8 inClear_s,
										TR_CARD_DATA *outTrCardDadta);

extern void TRCSET_SetTrCardDataBack(	const u32 inCommNum,
										const u32 CommBattleWin,
										const u32 CommBattleLose,
										const u32 CommTrade,
										TR_CARD_DATA *outTrCardDadta);

extern void TRCSET_SetTrCardDataBadge(	TR_CARD_DATA *outTrCardDadta );
#endif //__TR_CARD_SETUP_H__

