//============================================================================================
/**
 * @file	ug_attribute.c
 * @brief	np}gbNX֘A
 * @author	Nozomu Saito
 * @date	2006.02.17
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "worldmap.h"
#include "ug_attribute_def.h"

#include "system/arc_tool.h"

#define UG_MAP_SIZE			(15)

typedef struct UG_MATRIX_DATA_tag{
	u8 Matrix[UG_MAP_SIZE*UG_MAP_SIZE];
	u16 GroundAttr[GROUND_ATTR_SIZE];
}UG_MATRIX_DATA;

static void MakeUgMatrix(WORLD_MAP_PTR inWorld, UMD_PTR outUgMatrixData);
static const u8 AddUgArcList(const u16 inArcIndex, u16 *outList, u8 *ioListPos);

void SetUpUnderGroundAttr(FIELDSYS_WORK *fsys)
{
	int i;
	void *mem;	
	//AP[V
	if (fsys->UgMatData == NULL){
		fsys->UgMatData = sys_AllocMemory( HEAPID_WORLD, sizeof(UG_MATRIX_DATA) );
		//n}gNX쐬
		MakeUgMatrix(fsys->World, fsys->UgMatData);
		
	}
}

void FreeUnderGroundAttr(FIELDSYS_WORK *fsys)
{
	if (fsys->UgMatData != NULL){
		sys_FreeMemoryEz(  fsys->UgMatData );
		fsys->UgMatData = NULL;
	}
}

//--------------------------------------------------------------------------------------------
/**
 * nAgr[gubN擾
 *
 * @param	inBlockindex	ubNCfbNX 
 * @param	inUgMatrixData	n}gNXf[^
 *
 * @return	block_attr	ubNAgr[g擪|C^
 */
//--------------------------------------------------------------------------------------------
u16 const * GetUgBlockAttribute(const u32 inBlockindex, UMD_CONST_PTR inUgMatrixData)
{
	u16 const *block_attr;
	u8 list_idx;
	list_idx = inUgMatrixData->Matrix[inBlockindex];
	block_attr = (u16 const *)&(inUgMatrixData->GroundAttr[BLOCK_ATTR_SIZE*list_idx]);
	return block_attr;
}

//--------------------------------------------------------------------------------------------
/**
 * n}gNX쐬
 *
 * @param	inWorld			[h|C^
 * @param	outUgMatrixData	n}gNXf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void MakeUgMatrix(WORLD_MAP_PTR inWorld, UMD_PTR outUgMatrixData)
{
	u8 list_pos;
	u16 arc_idx;
	u8 list_idx;
	u16 idx;
	int i,j;
	int h,w;
	u16 list[UG_GROUND_MAP_NUM];
	void *mem;
	ARCHANDLE *arc_handle;

	list_pos = 0;

	//݃}bv}gNX擾
	w = GetWorldMapMatrixW(inWorld);
	h = GetWorldMapMatrixH(inWorld);

	//Agr[g擾pɃ}gNX쐬
	for(j=0;j<h;j++){
		for(i=0;i<w;i++){
			idx = j*w+i;
			arc_idx = GetArcIndexFromBlockIndex(idx,inWorld);
#ifdef DEBUG_ONLY_FOR_saitou			
			OS_Printf("local_print %d:UG_arc_idx:%d\n",idx,arc_idx);
#endif			
			//n}gbNX̃A[JCuCfbNXXgɒǉ
			list_idx = AddUgArcList(arc_idx, list, &list_pos);
			outUgMatrixData->Matrix[idx] = list_idx;
		}
	}
	//Agr[g܂Ƃ߂ă[h
	//A[JCunh̎擾
	arc_handle = ArchiveDataHandleOpen( ARC_FIELD_MAP_DATA, HEAPID_WORLD );

	for(i=0;i<UG_GROUND_MAP_NUM;i++){
		arc_idx = list[i];
		mem = &(outUgMatrixData->GroundAttr[BLOCK_ATTR_SIZE*i]);
		//Ƃ肠(͒n}bv16Ȃ̂)
		if (i>=16){
			break;;
		}
		//Agr[g̓A[JCuf[^̐擪ŒoCgTCYȂ̂ŁAItZbgATCY擾͏Ȃ
		ArchiveDataLoadOfsByHandle( arc_handle, arc_idx, 0x10, 0x800,  mem);
	}
	//A[JCunh̉
	ArchiveDataHandleClose( arc_handle );
}

static const u8 AddUgArcList(const u16 inArcIndex, u16 *outList, u8 *ioListPos)
{
	u8 i;
	//w肵A[JCuCfbNXXgɓo^ĂȂΒǉ
	for(i=0;i<(*ioListPos);i++){
		if (outList[i] == inArcIndex){
			return i;	//łɓo^ς
		}
	}
	//VKo^
	GF_ASSERT( i<UG_GROUND_MAP_NUM && "n}bv̐I[o[Ă܂" );
	outList[i] = inArcIndex;
	(*ioListPos)++;
	return i;
	
}
