//============================================================================================
/**
 * @file	ug_base_bmp.c
 * @brief	閧nBMPu
 * @author	saito
 * @date	2006.02.28
 *
 */
//============================================================================================
#include "ug_base_bmp.h"
#include "fieldsys.h"
#include "fld_bmp.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/window.h"

#include "include/msgdata/msg.naix"
#include "msgdata/msg_undergroundgoods.h"
#include "savedata/undergrounddata.h"

#include "msgdata/msg_uwedit.h"

#include "communication/comm_message.h"	//for window
#include "underground/ug_manager.h"		//for window

#define MENU_MAX	(4)
#define BASE_MENU_POSX    (19)
#define BASE_MENU_POSY    (1)
#define BASE_MENU_SIZE_X  (12)

#define BASE_MAIN_MENU_MAX	(3)

#define MENURETURN_EXIT		(BASE_MAIN_MENU_MAX)

#define BASE_GOODS_LIST_SIZE_X	(12)

#define BASE_SUB_WIN_POSX    (1)
#define BASE_SUB_WIN_POSY    (1)
#define BASE_SUB_WIN_SIZE_X  (7)
#define BASE_SUB_WIN_SIZE_Y  (1*2)

#define BASE_GOODS_INFO_SIZE_X	(8)
#define BASE_GOODS_INFO_SIZE_Y	(2*2)

#define GOODS_NUM_LEN	(6)

typedef enum {
	MENU_SEQ_INIT,
	MENU_SEQ_LOOP,
	MENU_SEQ_END,
}BASE_MAIN_MENU_SEQ;

typedef enum {
	LIST_SEQ_INIT,
	LIST_SEQ_LOOP,
	LIST_SEQ_END,
}BASE_GOODS_LIST_SEQ;

///ėpIj[̃Xg
static const BMPLIST_HEADER MenuListHeader = {
    NULL,			// \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,					// 
    MENU_MAX,	// Xgڐ
    MENU_MAX,	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,			// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL,                   // [N
};

typedef struct UG_BASE_MENU_tag
{
	FIELDSYS_WORK* fsys;
    GF_BGL_BMPWIN  Win;		// BMPEBhE[N
	GF_BGL_BMPWIN  SubWin;		// BMPTuEBhE[N
	BMPLIST_DATA*  MenuList;
	
    BMPLIST_WORK*  ListWork;		// BMPj[[N
	STRBUF* StrBuf;
	u8 Seq;
	u32 ReturnIdx;				//CCxgɕԂj[CfbNX
	
}_UG_BASE_MENU;

typedef struct UG_BASE_LIST_tag
{
	FIELDSYS_WORK* fsys;
    GF_BGL_BMPWIN  Win;		// BMPEBhE[N
	GF_BGL_BMPWIN  SubWin;		// BMPTuEBhE[N
	BMPLIST_DATA*  List;
	
    BMPLIST_WORK*  ListWork;		// BMPj[[N
	STRBUF* StrBuf;
	u8 GoodsCount;				//uĂObY
	u8 GoodsLimit;				//uObY
	u8 Seq;
	u32 ReturnIndex;				//XgCfbNX
	int Count;
	
}_UG_BASE_LIST;

static void CreateBaseMainMenu(UG_BASE_MENU *outMenu);
static void BaseMenuMain(UG_BASE_MENU *outMenu);
static void CloseMenu(UG_BASE_MENU *outMenu);

static void CreateBaseGoodsList(UG_BASE_LIST *outList);
static void BaseGoodsListMain(UG_BASE_LIST *outList);
static void CloseList(UG_BASE_LIST *outList);

//AP[V
UG_BASE_MENU * BMENU_AllocUgBaseMenu(void)
{
	UG_BASE_MENU *menu;

	menu = sys_AllocMemory(HEAPID_FIELD, sizeof(UG_BASE_MENU));

	return menu;
}

//
void BMENU_InitBaseMainMenu(UG_BASE_MENU *menu, FIELDSYS_WORK * fsys)
{
	menu->fsys = fsys;
	menu->Seq = MENU_SEQ_INIT;
	MenuWinGraphicSet(
        fsys->bgl, /*FLD_MBGFRM_FONT*/GF_BGL_FRAME3_M, MENU_WIN_CGX_NUM,
        MENU_WIN_PAL, 0, HEAPID_FIELD );
}

//
void BMENU_FreeUgBaseMenu(UG_BASE_MENU *menu)
{
	sys_FreeMemoryEz(menu);
}

const u32 BMENU_GetReturnIndex(UG_BASE_MENU *menu)
{
	return menu->ReturnIdx;
}

//Cj[CxgR[
BOOL BMENU_EditMainMenuControl(UG_BASE_MENU *outMenu)
{
	switch(outMenu->Seq){
	case MENU_SEQ_INIT:	//j[쐬
		CreateBaseMainMenu(outMenu);
		break;
	case MENU_SEQ_LOOP:	//j[
		BaseMenuMain(outMenu);
		break;
	case MENU_SEQ_END:	//I
		outMenu->Seq = MENU_SEQ_INIT;	//̂߂ɃV[PXĂ
		CloseMenu(outMenu);
		return TRUE;
	}

	return FALSE;
}

static void BaseMenuLineSelect(BMPLIST_WORK * wk,u32 param,u8 mode)
{
///    _START_WORK* pStart = (_START_WORK*)BmpListParamGet(wk, BMPLIST_ID_WORK);
///    int idx = param;
/**    
    if(param == BMPLIST_CANCEL){
        idx = 4;
    }
*/	
///    CommMsgTalkWindowAllWrite(CommUnderGetMsgUnderShop(),mes_uw_pers_06+idx,FALSE,NULL);
	
	const int mes_list[4] = {
		mes_uw_edit_06,
		mes_uw_edit_07,
		mes_uw_edit_08,
		mes_uw_edit_09,
	};
	
	//UgSecretBaseTalkStart(mes_list[param]);
	CommMsgTalkWindowAllWrite(CommUnderGetMsgUnderEdit(),mes_list[param],FALSE,NULL);
}

//j[쐬
static void CreateBaseMainMenu(UG_BASE_MENU *outMenu)
{
	BMPLIST_HEADER list_h;
	int menu_size, subwin_size;
    int count = BASE_MAIN_MENU_MAX;
    int line = MENU_MAX;

    //_startMenuEnd(pStart);
    //BMPEBhE
    outMenu->MenuList = BMP_MENULIST_Create( count+1, HEAPID_FIELD );

///    pStart->pStrBuf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
///    pStart->pStrBuf2 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
///    pStart->pWordSet = WORDSET_Create( HEAPID_FIELD );

	menu_size = BASE_MENU_SIZE_X * line * 2;
	subwin_size = BASE_SUB_WIN_SIZE_X * BASE_SUB_WIN_SIZE_Y;
    GF_BGL_BmpWinAdd(outMenu->fsys->bgl, &outMenu->Win,
                     GF_BGL_FRAME3_M, BASE_MENU_POSX, BASE_MENU_POSY,
                     BASE_MENU_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(menu_size));
	GF_BGL_BmpWinAdd(outMenu->fsys->bgl, &outMenu->SubWin,
                     GF_BGL_FRAME3_M, BASE_SUB_WIN_POSX, BASE_SUB_WIN_POSY,
                     BASE_SUB_WIN_SIZE_X, BASE_SUB_WIN_SIZE_Y, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(menu_size+subwin_size));

    BmpMenuWinWrite(&outMenu->Win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	BmpMenuWinWrite(&outMenu->SubWin, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );

	{
		MSGDATA_MANAGER* msgman;
		int i;
		const int msg_list[BASE_MAIN_MENU_MAX+1] = {
			mes_uw_edit_02,	//ObY
			mes_uw_edit_03,	//ObYǂ
			mes_uw_edit_04,	//ObŶǂ
			mes_uw_edit_05,	//߂
		};
		
		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_uwedit_dat, HEAPID_FIELD);
		//TuEBhE
		{
			STRBUF * strb;
			GF_BGL_BmpWinDataFill(&outMenu->SubWin, FBMP_COL_WHITE);
			strb = MSGMAN_AllocString( msgman, mes_uw_edit_01 );
			GF_STR_PrintSimple( &outMenu->SubWin, FONT_SYSTEM, strb, 0, 0, MSG_NO_PUT, NULL );
			STRBUF_Delete( strb );
		}
		//j[
		for(i = 0; i < count+1; i++){
			BMP_MENULIST_AddArchiveString( outMenu->MenuList, msgman, msg_list[i], i );
/**			
            WORDSET_RegisterUGItemName(pStart->pWordSet, 2, _underBagGetStoneID(i) );
            WORDSET_RegisterNumber(pStart->pWordSet, 6, _underBagGetStoneCarat(i), 2,
                                   NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
            MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderWorld()), UGBallMenuDef,
                              pStart->pStrBuf2 );
            WORDSET_ExpandStr( pStart->pWordSet,  pStart->pStrBuf1,
                               pStart->pStrBuf2 );
            BMP_MENULIST_AddString(pStart->menulist,  pStart->pStrBuf1, i);
*/			
		}
		MSGMAN_Delete(msgman);
	}
    
	list_h = MenuListHeader;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = outMenu->MenuList;
    list_h.win = &outMenu->Win;
	list_h.call_back = BaseMenuLineSelect;
    outMenu->ListWork = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);

	GF_BGL_BmpWinOn(&outMenu->Win);
	GF_BGL_BmpWinOn(&outMenu->SubWin);
    outMenu->Seq = MENU_SEQ_LOOP;
}

//j[C
static void BaseMenuMain(UG_BASE_MENU *outMenu)
{
    u32	ret;

    ret = BmpListMain(outMenu->ListWork);

    if(ret == MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
	
    switch(ret){
    case BMPLIST_NULL:
        return ;
    case BMPLIST_CANCEL:
		outMenu->ReturnIdx = ret;
        outMenu->Seq = MENU_SEQ_END;
        break;
    default:	//^[R[h̃Zbg
        {
			//CCxgɕԂ^[R[hZbg
			outMenu->ReturnIdx = ret;
            outMenu->Seq = MENU_SEQ_END;
        }
        break;
    }
    return ;
}

//j[N[Y
static void CloseMenu(UG_BASE_MENU *outMenu)
{
	CommMsgTalkWindowEnd(CommUnderGetMsgUnderEdit());
	BmpMenuWinClear( &outMenu->SubWin, WINDOW_TRANS_OFF );
	
    BmpListExit(outMenu->ListWork, NULL, NULL);	//j[̏ԂLȂ
    
    BmpMenuWinClear(&outMenu->Win, WINDOW_TRANS_OFF );
    GF_BGL_LoadScreenV_Req( outMenu->Win.ini, outMenu->Win.frmnum );
    GF_BGL_BmpWinDel(&outMenu->Win);
	GF_BGL_BmpWinDel(&outMenu->SubWin);
    BMP_MENULIST_Delete(outMenu->MenuList);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////
//PsƂ̃R[obN
static void	LineCallBack(BMPLIST_WORK * wk, u32 param, u8 y)
{
	//łɊnɂĂ邩`FbN
	u8 flg;
	flg = param & 0x01;
	if (flg){//zuĂȂ
		BmpListTmpColorChange( wk, FBMP_COL_BLACK, FBMP_COL_WHITE , FBMP_COL_BLK_SDW );
	}else{		//zuς
		BmpListTmpColorChange( wk, FBMP_COL_BLK_SDW, FBMP_COL_WHITE , FBMP_COL_BLK_SDW );
	}
}

//AP[V
UG_BASE_LIST * BMENU_AllocUgBaseGoodsList(void)
{
	UG_BASE_LIST *list;

	list = sys_AllocMemory(HEAPID_FIELD, sizeof(UG_BASE_LIST));

	return list;
}

//
void BMENU_InitBaseGoodsList(UG_BASE_LIST *list, FIELDSYS_WORK * fsys)
{
	list->fsys = fsys;
	list->Seq = LIST_SEQ_INIT;
	MenuWinGraphicSet(
        fsys->bgl, GF_BGL_FRAME3_M, MENU_WIN_CGX_NUM,
        MENU_WIN_PAL, 0, HEAPID_FIELD );
}

//ObYZbg
void BMENU_SetGoodsNumToList(UG_BASE_LIST *list, const u8 inNum, const u8 inLimit)
{
	list->GoodsCount = inNum;
	list->GoodsLimit = inLimit;
}

//
void BMENU_FreeUgBaseGoodsList(UG_BASE_LIST *list)
{
	sys_FreeMemoryEz(list);
}

const u32 BMENU_GetReturnListIdx(UG_BASE_LIST *list)
{
	return list->ReturnIndex;
}

//ObYXgCxgR[
BOOL BMENU_EditGoodsListControl(UG_BASE_LIST *outList)
{
	switch(outList->Seq){
	case LIST_SEQ_INIT:	//j[쐬
		CreateBaseGoodsList(outList);
		break;
	case LIST_SEQ_LOOP:	//j[
		BaseGoodsListMain(outList);
		break;
	case LIST_SEQ_END:	//I
		outList->Seq = LIST_SEQ_INIT;	//̂߂ɃV[PXĂ
		CloseList(outList);
		return TRUE;
	}
	return FALSE;
}

//ObYXgC
static void BaseGoodsListMain(UG_BASE_LIST *outList)
{
    u32	ret;
	u32 pos;

    ret = BmpListMain(outList->ListWork);

	pos = (ret>>1);
	
	if (outList->Count == pos){
		pos = BMPLIST_CANCEL;
	}
	
    switch(ret){
    case BMPLIST_NULL:
        return ;
    case BMPLIST_CANCEL:
		outList->ReturnIndex = LIST_CANCEL_CODE;	//ObYI
        outList->Seq = LIST_SEQ_END;
        break;
    default:	//^[R[h̃Zbg
        {
			outList->ReturnIndex = pos;
			outList->Seq = LIST_SEQ_END;
			//OS_Printf("%d:\n",pos);
        }
        break;
    }
    return ;
}

//ObYXg쐬
static void CreateBaseGoodsList(UG_BASE_LIST *outList)
{
	UNDERGROUNDDATA* pUGData;
	BMPLIST_HEADER list_h;
    int list_size, subwin_size;
	int count;
    int line;

	//ObY̐擾
	pUGData = SaveData_GetUnderGroundData(outList->fsys->savedata);
	count = UnderGroundGetNumGoodsPCItem(pUGData);
	outList->Count = count;
	line = count+1;
    //BMPEBhE
    outList->List = BMP_MENULIST_Create( count+1, HEAPID_FIELD );

	list_size = BASE_MENU_SIZE_X * line * 2;
	subwin_size = BASE_GOODS_INFO_SIZE_X * BASE_GOODS_INFO_SIZE_Y;
    GF_BGL_BmpWinAdd(outList->fsys->bgl, &outList->Win,
                     GF_BGL_FRAME3_M, BASE_MENU_POSX, BASE_MENU_POSY,
                     BASE_GOODS_LIST_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(list_size));
	GF_BGL_BmpWinAdd(outList->fsys->bgl, &outList->SubWin,
                     GF_BGL_FRAME3_M, BASE_SUB_WIN_POSX, BASE_SUB_WIN_POSY,
                     BASE_GOODS_INFO_SIZE_X, BASE_GOODS_INFO_SIZE_Y, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(list_size+subwin_size));
    BmpMenuWinWrite(&outList->Win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	BmpMenuWinWrite(&outList->SubWin, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
        MSGDATA_MANAGER* msgman;
		
        int i=0;
		int idx;
		BOOL check;
		int param;
		u8 flg;
        msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergroundgoods_dat, HEAPID_FIELD);
		
		//TuEBhE
		{
			MSGDATA_MANAGER* edit_msgman;
			STRBUF * strb_put_goods;
			STRBUF * strb_goods_num;
			STRBUF * strb_dst;
			WORDSET *wordset;

			edit_msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_uwedit_dat, HEAPID_FIELD);

			GF_BGL_BmpWinDataFill(&outList->SubWin, FBMP_COL_WHITE);
			strb_put_goods = MSGMAN_AllocString( edit_msgman, mes_uw_edit_10 );
			strb_goods_num = MSGMAN_AllocString( edit_msgman, mes_uw_edit_11 );
			strb_dst = STRBUF_Create( GOODS_NUM_LEN, HEAPID_FIELD );
			
			GF_STR_PrintSimple( &outList->SubWin, FONT_SYSTEM, strb_put_goods, 0, 0, MSG_NO_PUT, NULL );
			
			wordset = WORDSET_Create( HEAPID_FIELD );
			WORDSET_RegisterNumber(wordset, 0, outList->GoodsCount, 2,
					NUMBER_DISPTYPE_SPACE , NUMBER_CODETYPE_DEFAULT );	//uĂObY
			WORDSET_RegisterNumber(wordset, 1, outList->GoodsLimit, 2,
					NUMBER_DISPTYPE_SPACE , NUMBER_CODETYPE_DEFAULT );	//uObY
			
			WORDSET_ExpandStr( wordset, strb_dst, strb_goods_num );
			
			GF_STR_PrintSimple( &outList->SubWin, FONT_SYSTEM, strb_dst, 0, 16, MSG_NO_PUT, NULL );

			WORDSET_Delete( wordset );	
			STRBUF_Delete( strb_put_goods );
			STRBUF_Delete( strb_goods_num );
			STRBUF_Delete( strb_dst );

			MSGMAN_Delete(edit_msgman);
		}
		
        for(i=0; i < count ; i++)
        {
			idx = UnderGroundGetGoodsPCItem(pUGData,i);
			//łɊnɂĂ邩`FbN
			check = UnderGroundIsEntryGoodsPCItem(pUGData, i);
			if (!check){//zuĂȂ
				flg = 1;
			}else{		//zuς
				flg = 0;
			}
			param = (i<<1)+flg;
            BMP_MENULIST_AddArchiveString( outList->List, msgman, idx, param);
        }
		param = (i<<1)+1;
        BMP_MENULIST_AddArchiveString( outList->List, msgman, UGGoodsMenuEnd, param);
        MSGMAN_Delete(msgman);
    }
    
	list_h = MenuListHeader;
	list_h.icon = LineCallBack;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = outList->List;
    list_h.win = &outList->Win;
    outList->ListWork = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);

	GF_BGL_BmpWinOn(&outList->Win);
	GF_BGL_BmpWinOn(&outList->SubWin);
    outList->Seq = LIST_SEQ_LOOP;
}

//XgN[Y
static void CloseList(UG_BASE_LIST *outList)
{
	CommMsgTalkWindowEnd(CommUnderGetMsgUnderEdit());
	BmpMenuWinClear( &outList->SubWin, WINDOW_TRANS_OFF );	
    
	BmpListExit(outList->ListWork, NULL, NULL);	//j[̏ԂLȂ
    
    BmpMenuWinClear(&outList->Win, WINDOW_TRANS_OFF );
    GF_BGL_LoadScreenV_Req( outList->Win.ini, outList->Win.frmnum );
    GF_BGL_BmpWinDel(&outList->Win);
	GF_BGL_BmpWinDel(&outList->SubWin);
    BMP_MENULIST_Delete(outList->List);
}

