//============================================================================================
/**
 * @file	ug_base_layout.c
 * @brief	閧nɓۂ̃CAEg
 * @author	saito
 * @date	2006.03.03
 *
 */
//============================================================================================
#include "common.h"
#include "fieldsys.h"
#include "savedata/undergrounddata.h"
#include "underground/ug_manager.h"
#include "underground/ug_secretbase.h"
#include "goods_data.h"

void BaseLayout_SetupUGBaseGoodsObj(FIELDSYS_WORK * fsys)
{
	int i;
	int goods_no;
	SECRETBASEDATA *base_data;
	int block_x,block_z;
	int x,z;
	int w,d;
	VecFx32	trans;
	int obj_id;
	
	base_data = UgManUgSetupSecretBaseData(fsys->savedata);
	if (base_data==NULL){
		return;	//nƂ݂ȂA^[
	}
	
	//ItZbg擾
	block_x = UgManUgSetupSecretBaseBlockX();
	block_z = UgManUgSetupSecretBaseBlockZ();
	
	for(i=0;i<32;i++){
		goods_no = SecretBaseData_GetGoodsType(base_data, i);
		//ObYio[cTCY擾
		w = GOODS_GetGoodsSizeX(goods_no);
		d = GOODS_GetGoodsSizeZ(goods_no);
		if (goods_no != GOODS_INVALID){
			x = SecretBaseData_GetGoodsXPos(base_data, i);
			z = SecretBaseData_GetGoodsZPos(base_data, i);
			//Fx32^ɕϊ
			trans.x = x*(FX32_ONE*16);
			trans.z = z*(FX32_ONE*16);
			trans.y = FX32_ONE;	//ƂƂ
			//ItZbgt
			trans.x += (block_x*FX32_ONE*16*32);
			trans.z += (block_z*FX32_ONE*16*32);
			//TCYɂItZbgt
			trans.x += (w*FX32_ONE*8);
			trans.z += (d*FX32_ONE*8);
			//ObYio[zufIDɕϊ(Ƃ肠Œ)
			obj_id = 272;
			//OBJo^
			M3DO_SetMap3DObjExp(fsys->Map3DObjExp,
								fsys->MapResource,
								obj_id,			//Ƃ肠Œ
								&trans,			//
								fsys->field_3d_anime);
		}
	}
}
