//=============================================================================
/**
 * @file	ug_bag.c
 * @brief	n̂΂̒gǗNX
 * @author	Katsumi Ohno
 * @date    2005.12.21
 */
//=============================================================================

#include "common.h"

#include "../fieldsys.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/window.h"
#include "system/wipe.h"
#include "system/clact_tool.h"
#include "system/menu_gra.naix"

#include "../fld_bmp.h"

#include "msgdata/msg_underworld.h"
#include "msgdata/msg_undergroundtrap.h"
#include "msgdata/msg_undergrounditem.h"
#include "msgdata/msg_undergroundgoods.h"
#include "msgdata/msg_uwflag.h"
#include "msgdata/msg_uwbuy.h"
#include "msgdata/msg_uwpersonal.h"
#include "msgdata/msg.naix"

#include "communication/communication.h"
#include "ug_manager.h"

#include "../ev_mapchange.h"
#include "gflib/camera.h"
#include "../fieldmap.h"
#include "../fld_bmp.h"
#include "../field_clact.h"
#include "system/snd_tool.h"
#include "savedata/undergrounddata.h"


#include "ug_local.h"

extern u8 MsgSpeedGet(void);
extern u8 TalkWinNumGet(void);

//==============================================================================
//	萔`
//==============================================================================


#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY

#define	_SUB_MENU_MAX		( 7 )					// ڍő吔

#define	_TRAP_BAG_MAX      (20)
#define	_STONE_BAG_MAX     (20)
#define	_GOODS_BAG_MAX     (20)
#define	_TREASURE_BAG_MAX  (20)

#define _TRAP_COMPUTER_MAX      (200)
#define _STONE_COMPUTER_MAX     (200)
#define _GOODS_COMPUTER_MAX     (200)
#define _TREASURE_COMPUTER_MAX  (200)


//==============================================================================
//	\̒`
//==============================================================================

typedef struct{
    UNDERGROUNDDATA* pUGData; // nZ[uf[^
    u8 deleteIndex;   // ACeĂindex
    u8 deleteItem;    // ACeԍ
} _UNDER_ITEM;


static _UNDER_ITEM* _pUnderItem = NULL;


static const BMPWIN_DAT _yesNoBmpDat = {
    FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
    FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
    };

//==============================================================================
//	^錾
//==============================================================================
typedef void (*pStartFunc)(_START_WORK *);


//==============================================================================
//	static`
//==============================================================================

// ACR֘A
static void CellActDelete( _START_WORK * wk );
static void CellActAnm( _START_WORK * wk );
static void CursorMove( CLACT_WORK_PTR cwp, u32 cur_pos );
static void IconAnmChange( CLACT_WORK_PTR cwp, u16 anm, u16 pal );
static void MoveIconAnmChg( _START_WORK * wk, u16 old_pos, u16 new_pos );
static void SelectIconAnmCheck( CLACT_WORK_PTR cwp );

// j[֘A
static void _bagProcess(TCB_PTR tcb, void* work);
static BOOL _startMenuFunc(TCB_PTR tcb, void* work);
static void _cardStart(_START_WORK* pStart);
static void _startSendStart(_START_WORK* pStart, int no);
static void _trapSet( _START_WORK* pStart );
static void _trapMenuStart(_START_WORK* pStart);
static BOOL _trapMenuFunc(TCB_PTR tcb, void* work);
static void _stoneMenuStart(_START_WORK* pStart);
static BOOL _stoneMenuFunc(TCB_PTR tcb, void* work);

static void _treasureMenuStart(_START_WORK* pStart);
static BOOL _treasureMenuFunc(TCB_PTR tcb, void* work);
static void _itemDiamond( _START_WORK* pStart );
static void _itemPearl( _START_WORK* pStart );
static void _startExit( _START_WORK* pStart );
static void _underExit( _START_WORK* pStart );
static void _statusList( _START_WORK* pStart );

// j[֘A
static void _flagProcess(TCB_PTR tcb, void* work);

static void _goodsMenuStart(_START_WORK* pStart);
static BOOL _goodsMenuFunc(TCB_PTR tcb, void* work);
static BOOL _goodsMenuFuncSub(TCB_PTR tcb, void* work);

// nɖ߂
static void _exitTalkFunc(TCB_PTR tcb, void* work);
static void _exitTalkFunc2(TCB_PTR tcb, void* work);
static void _exitTalkFunc3(TCB_PTR tcb, void* work);
static void _exitTalkFunc4(TCB_PTR tcb, void* work);

static void _delEnd(TCB_PTR tcb, _START_WORK* pStart);

//==============================================================================
//	STARTj[Xgpf[^
//==============================================================================

static const struct {
	u32  str_id;
	u32  param;
}MenuParamList[] = {
    { UGStartMenu01, (u32)_goodsMenuStart_Bag },
    { UGStartMenu02, (u32)_treasureMenuStart_Bag },
    { UGStartMenu03, (u32)_stoneMenuStart_Bag },
    { UGStartMenu04, (u32)_trapMenuStart_Bag },
    { UGStartMenu05, (u32)_statusList },
    { UGStartMenu06, (u32)_underExit },
    { UGStartMenu07, (u32)_startExit },
};



///STARTIj[̃Xg
static const BMPLIST_HEADER StartMenuListHeader = {
    NULL,			// \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,					// 
    NELEMS(MenuParamList),	// Xgڐ
    NELEMS(MenuParamList),	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,				// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL,                   // [N
};

///ėpIj[̃Xg
static const BMPLIST_HEADER MenuListHeader = {
    NULL,			// \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,					// 
    _TRAP_BAG_MAX,	// Xgڐ
    _TRAP_BAG_MAX,	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,			// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL,                   // [N
};



static const TCATS_RESOURCE_FILE_LIST CatsFileList = {
	"data/fmenu_chr.resdat",	// LN^
	"data/fmenu_pal.resdat",	// pbg
	"data/fmenu_cell.resdat",	// Z
	"data/fmenu_canm.resdat",	// ZAj
	NULL,						// }`Z
	NULL,						// }`ZAj
	"data/fmenu_h.cldat"		// wb_[
};

#define	CLA_ID_ICON_START	( 1 )

enum {
	MENU_POS_ZUKAN = 0,
	MENU_POS_POKEMON,
	MENU_POS_BAG,
	MENU_POS_HERO,
	MENU_POS_REPORT,
	MENU_POS_CONFIG,
	MENU_POS_EXIT,
	MENU_POS_CHAT,
};
enum {
	ICON_ZUKAN,		// }ӃACR
	ICON_POKEMON,	// |PXgACR
	ICON_BAG,		// obOACR
	ICON_HERO,		// g[i[J[hACR
	ICON_REPORT,	// |[gACR
	ICON_CONFIG,	// ݒACR
	ICON_CLOSE,		// ACR
	ICON_BAG_F,		// obOij
	ICON_CHAT,		// `bg
};

// ZAN^[o^ꏊ
#define	CLA_SET_CURSOR	( 0 )	// IJ[\
#define	CLA_SET_ICON	( 1 )	// ACR

#define	CLA_CURSOR_PX	( 204 )
#define	CLA_CURSOR_PY	( 20 )
#define	CLA_ICON_PX		( 174 )
#define	CLA_ICON_PY		( 20 )
#define	CLA_ICON_SPC_Y	( 24 )

enum {
	ICON_ANM_STOP = 0,
	ICON_ANM_CHANGE,
	ICON_ANM_SELECT,
};

enum {
	FLDMENU_CLA_CHR_H_ID_CURSOR	= 13528,
	FLDMENU_CLA_CHR_H_ID_ICON,
};
enum {
	FLDMENU_CLA_PAL_H_ID = 13528,
};
enum {
	FLDMENU_CLA_CEL_H_ID_CURSOR	= 13528,
	FLDMENU_CLA_CEL_H_ID_ICON,
};
enum {
	FLDMENU_CLA_ANM_H_ID_CURSOR	= 13528,
	FLDMENU_CLA_ANM_H_ID_ICON,
};

static const TCATS_OBJECT_ADD_PARAM_S ActAddParam_S[] =
{
	{	// J[\
		CLA_CURSOR_PX, CLA_CURSOR_PY, 0,
		0, 1, 1, NNS_G2D_VRAM_TYPE_2DMAIN,
		{
			FLDMENU_CLA_CHR_H_ID_CURSOR, FLDMENU_CLA_PAL_H_ID,
			FLDMENU_CLA_CEL_H_ID_CURSOR, FLDMENU_CLA_ANM_H_ID_CURSOR, 0, 0,
		},
		0, 0
	},
	{	// ACRP
		CLA_ICON_PX, CLA_ICON_PY, 0,
		0, 0, 0, NNS_G2D_VRAM_TYPE_2DMAIN,
		{
			FLDMENU_CLA_CHR_H_ID_ICON, FLDMENU_CLA_PAL_H_ID,
			FLDMENU_CLA_CEL_H_ID_ICON, FLDMENU_CLA_ANM_H_ID_ICON, 0, 0,
		},
		0, 0
	},
};

#define	FLDMENU_CLA_CHR_RES_MAX		( 8 )
#define	FLDMENU_CLA_PAL_RES_MAX		( 1 )
#define	FLDMENU_CLA_CEL_RES_MAX		( 2 )
#define	FLDMENU_CLA_ANM_RES_MAX		( 2 )

//==============================================================================
// ֐
//==============================================================================

static void CellActSet( _START_WORK * wk, u8 * list, u32 max, u8 sex )
{
	TCATS_RESOURCE_NUM_LIST	crnl = {
		FLDMENU_CLA_CHR_RES_MAX, FLDMENU_CLA_PAL_RES_MAX,
		FLDMENU_CLA_CEL_RES_MAX, FLDMENU_CLA_ANM_RES_MAX, 0, 0
	};
	u32	i;

	FieldCellActSet_S( &wk->fcat, &crnl, _FLDMENU_CLACT_MAX, HEAPID_WORLD );

	FldClact_LoadResPlttArc(
		&wk->fcat, ARC_MENU_GRA,
		NARC_menu_gra_fmenu_obj_NCLR, 0, 2, NNS_G2D_VRAM_TYPE_2DMAIN, FLDMENU_CLA_PAL_H_ID );

	FldClact_LoadResCellArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_cur_NCER, 0, FLDMENU_CLA_CEL_H_ID_CURSOR );

	FldClact_LoadResCellAnmArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_cur_NANR, 0, FLDMENU_CLA_ANM_H_ID_CURSOR );

	FldClact_LoadResourceCharArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_cur_NCGR,
		0, NNS_G2D_VRAM_TYPE_2DMAIN, FLDMENU_CLA_CHR_H_ID_CURSOR );

	wk->cap[CLA_SET_CURSOR] = FieldCellActAdd_S( &wk->fcat, &ActAddParam_S[CLA_SET_CURSOR] );

	CursorMove( wk->cap[CLA_SET_CURSOR]->act, wk->pos );


	FldClact_LoadResCellArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_obj_NCER, 0, FLDMENU_CLA_CEL_H_ID_ICON );

	FldClact_LoadResCellAnmArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_obj_NANR, 0, FLDMENU_CLA_ANM_H_ID_ICON );

	FldClact_LoadResourceCharArc(
		&wk->fcat, ARC_MENU_GRA, NARC_menu_gra_fmenu_obj_NCGR,
		0, NNS_G2D_VRAM_TYPE_2DMAIN, FLDMENU_CLA_CHR_H_ID_ICON );

	for( i=0; i<max; i++ ){
		TCATS_OBJECT_ADD_PARAM_S	prm;

		prm = ActAddParam_S[CLA_SET_ICON];
		prm.y += CLA_ICON_SPC_Y * i;

		if( list[i] == MENU_POS_BAG && sex == 1 ){
			prm.anm = ICON_BAG_F * 3;
		}else{
			prm.anm = list[i] * 3;
		}

		wk->cap[CLA_SET_ICON+i] = FieldCellActAdd_S( &wk->fcat, &prm );

		{
			VecFx32 sca = { FX32_ONE, FX32_ONE, FX32_ONE };
			CLACT_SetScaleAffine( wk->cap[CLA_SET_ICON+i]->act, &sca, CLACT_AFFINE_NORMAL );
		}
	}
	IconAnmChange( wk->cap[CLA_SET_ICON+wk->pos]->act, ICON_ANM_SELECT, 1 );

	wk->clact_max = max + 1;

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
}

static void CellActDelete( _START_WORK * wk )
{
	u16	i;

	for( i=0; i<wk->clact_max; i++ ){
		CATS_ActorPointerDelete_S( wk->cap[i] );
	}
	FieldCellActDelete_S( &wk->fcat );
}

static void CellActAnm( _START_WORK * wk )
{
	u16	i;

	for( i=0; i<wk->clact_max; i++ ){
		CLACT_AnmFrameChg( wk->cap[i]->act, FX32_ONE );
	}
}

static void CursorMove( CLACT_WORK_PTR cwp, u32 cur_pos )
{
	VecFx32	act_pos;

	act_pos = *(CLACT_GetMatrix( cwp ));
	act_pos.y = ( CLA_CURSOR_PY + CLA_ICON_SPC_Y * cur_pos ) * FX32_ONE;
	CLACT_SetMatrix( cwp, &act_pos );
}


static void IconAnmChange( CLACT_WORK_PTR cwp, u16 anm, u16 pal )
{
	u32	now_anm = CLACT_AnmGet( cwp );

	CLACT_AnmChg( cwp, (now_anm/3)*3+anm );
	CLACT_PaletteNoChgAddTransPlttNo( cwp, pal );
}

static void MoveIconAnmChg( _START_WORK * wk, u16 old_pos, u16 new_pos )
{
	IconAnmChange( wk->cap[CLA_SET_ICON+old_pos]->act, ICON_ANM_STOP, 0 );
	IconAnmChange( wk->cap[CLA_SET_ICON+new_pos]->act, ICON_ANM_CHANGE, 1 );
}

static void SelectIconAnmCheck( CLACT_WORK_PTR cwp )
{
	if( CLACT_AnmGet( cwp ) != ICON_ANM_CHANGE ){
		return;
	}
	if( CLACT_AnmActiveCheck( cwp ) == FALSE ){
		IconAnmChange( cwp, ICON_ANM_SELECT, 1 );
	}
}



//============================================================================================

//==============================================================================
/**
 * p\RƎ̃obÖ̗m
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommUnderBagInitialize(UNDERGROUNDDATA* pUGData)
{
    _pUnderItem = sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_UNDER_ITEM));
    _pUnderItem->deleteIndex = 0;   // ACeĂindex
    _pUnderItem->deleteItem = 0;    // ACeԍ
    _pUnderItem->pUGData = pUGData;

}

//==============================================================================
/**
 * p\RƎ̃obÖ̗J
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommUnderBagFinalize(void)
{
    // Z[uKv
    sys_FreeMemoryEz(_pUnderItem);
}

//==============================================================================
/**
 * ̃obO㩂̐𓾂
 * @param   none
 * @retval  㩂̐
 */
//==============================================================================

static int _underBagGetTrapNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetNumTrapBagItem(pUGData);
}

//==============================================================================
/**
 * p\RTRAP̐𓾂
 * @param   work
 * @retval  TRAP̐
 */
//==============================================================================

static int _underPcGetTrapNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    
    return UnderGroundGetNumTrapPCItem(pUGData);
}

//==============================================================================
/**
 * p\RTRAPTYPEԂ
 * @param   index    ԖڂTRAP𓾂邩
 * @retval  TRAPTYPE
 */
//==============================================================================

int _underPcGetTrapType(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetTrapPCItem(pUGData,index);
}

//==============================================================================
/**
 * p\RGOODS̐𓾂
 * @param   work
 * @retval  GOODS̐
 */
//==============================================================================

static int _underPcGetGoodsNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    
    return UnderGroundGetNumGoodsPCItem(pUGData);
}

//==============================================================================
/**
 * p\RGOODSIDԂ
 * @param   index    ԖڂGOODS𓾂邩
 * @retval  goodsID
 */
//==============================================================================

int _underPcGetGoodsID(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetGoodsPCItem(pUGData,index);
}

//==============================================================================
/**
 * ̃obOGOODS̐𓾂
 * @param   none
 * @retval  GOODS̐
 */
//==============================================================================

static int _underBagGetGoodsNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    
    return UnderGroundGetNumGoodsBagItem(pUGData);
}

//==============================================================================
/**
 * ̃obOGOODSIDԂ
 * @param   index    ԖڂGOODS𓾂邩
 * @retval  goodsID
 */
//==============================================================================

int _underBagGetGoodsID(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    
    return UnderGroundGetGoodsBagItem(pUGData,index);
}

//--------------------------------------------------------------
/**
 * @brief   obOGOODS
 * @param   type   GOODSTYPE
 * @retval  none
 */
//--------------------------------------------------------------
void UgBagDeleteGoods(int type)
{
    GF_ASSERT(_pUnderItem->deleteItem == type);
    UnderGroundDelGoodsBagItem(_pUnderItem->pUGData, _pUnderItem->deleteIndex);
}

//==============================================================================
/**
 * ̃obÕ^}̐𓾂
 * @param   none
 * @retval  ܂̐
 */
//==============================================================================

static int _underBagGetStoneNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    
    return UnderGroundGetNumStoneBagItem(pUGData);
}

//==============================================================================
/**
 * ̃obOIDԂ
 * @param   index    Ԗڂ㩂𓾂邩
 * @retval  trapID
 */
//==============================================================================

int _underBagGetTrapID(int index,void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetTrapBagItem_List(pUGData, index);
}

//==============================================================================
/**
 * ̃obÕ^}IDԂ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  stoneID
 */
//==============================================================================

int _underBagGetStoneID(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetStoneBagItem(pUGData,index);
}

//==============================================================================
/**
 * ̃obÕ^}CaratԂ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  Carat
 */
//==============================================================================

int _underBagGetStoneCarat(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetStoneCaratBagItem(pUGData,index);
}

//==============================================================================
/**
 * p\R̃^}̐𓾂
 * @param   none
 * @retval  ܂̐
 */
//==============================================================================

static int _underPcGetStoneNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetNumStonePCItem(pUGData);
}

//==============================================================================
/**
 * p\R̃^}IDԂ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  stoneID
 */
//==============================================================================

int _underPcGetStoneType(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetStonePCItem(pUGData, index);
}

//==============================================================================
/**
 * p\R̃^}JbgԂ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  stoneID
 */
//==============================================================================

int _underPcGetStoneCarat(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetStoneCaratPCItem(pUGData, index);
}

//==============================================================================
/**
 * ̃obÔ̐𓾂
 * @param   none
 * @retval  ܂̐
 */
//==============================================================================

static int _underBagGetTreasureNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetNumTreasureBagItem(pUGData);
}

//==============================================================================
/**
 * ̃obÕ^}IDԂ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  stoneID
 */
//==============================================================================

int _underBagGetTreasureID(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetTreasureBagItem_List(pUGData,index);
}

//==============================================================================
/**
 * p\R̂̐𓾂
 * @param   work
 * @retval  GOODS̐
 */
//==============================================================================

static int _underPcGetTreasureNum(void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    
    return UnderGroundGetNumTreasurePCItem(pUGData);
}

//==============================================================================
/**
 * p\R̂typeԂ
 * @param   index    ԖڂGOODS𓾂邩
 * @retval  goodsID
 */
//==============================================================================

int _underPcGetTreasureType(int index, void* work)
{
    _START_WORK* pStart = work;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));

    return UnderGroundGetTreasurePCItem(pUGData,index);
}

//==============================================================================
/**
 * obOɂ܂
 * @param   no      ܃^Cv
 * @param   carat   Jbg
 * @retval  ܂ꂽTRUE
 */
//==============================================================================

BOOL CommUnderBagAddStone(int no, int carat)
{
    GF_ASSERT_RETURN(no < STONE_TYPE_MAX ,FALSE);
    return UnderGroundAddStoneBagItem(_pUnderItem->pUGData, no, carat);
}

//==============================================================================
/**
 * obOɓ
 * @param   no      ^Cv
 * @retval  ꂽTRUE
 */
//==============================================================================

BOOL CommUnderBagAddTreasure(int no)
{
    GF_ASSERT_RETURN(no < DIG_PARTS_TREASURE_MAX,FALSE);
    return UnderGroundAddTreasureBagItem(_pUnderItem->pUGData, no);
}

//==============================================================================
/**
 * 㩂΂ɒǉ
 * @param   no    㩃^Cvԍ
 * @retval  ǉłTRUE
 */
//==============================================================================

BOOL CommUnderBagAddTrap(int no)
{
    return UnderGroundAddTrapBagItem(_pUnderItem->pUGData, no);
}

//==============================================================================
/**
 * GOODS΂ɒǉ
 * @param   no    GOODS^Cvԍ
 * @retval  ǉłTRUE
 */
//==============================================================================

BOOL CommUnderBagAddGoods(int no)
{
    return UnderGroundAddGoodsBagItem(_pUnderItem->pUGData, no);
}

//==============================================================================
/**
 * nobO
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommUnderBagInit(pBagEndFunc func, FIELDSYS_WORK* pFSys)
{
    _START_WORK* pStart;
    BMPLIST_HEADER list_h;

    pStart = sys_AllocMemory(HEAPID_FIELD, sizeof(_START_WORK));
    MI_CpuFill8(pStart, 0, sizeof(_START_WORK));
    pStart->pFSys = pFSys;
    pStart->endfunc = func;
    pStart->seq = 0;
    pStart->pStrBuf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pStart->pStrBuf2 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pStart->pWordSet = WORDSET_Create( HEAPID_FIELD );


//	if( Player_MoveForceStopCheck( pFSys->player ) == TRUE ){
//		Player_MoveForceStop( pFSys->player, Player_DirGet(pFSys->player) );
//	}

    
    TCB_Add(_bagProcess, pStart, _MENU_UG_PRI);
}


//--------------------------------------------------------------------------------------------
/**
 * j[Xg쐬
 *
 * @param	event	tB[hCxgpp[^
 * @param	list	Xg쐬ꏊ
 *
 * @return	ڐ
 */
//--------------------------------------------------------------------------------------------
static u32 _menuListMake( u8 * list )
{
	u32	max = 0;

	list[max] = MENU_POS_ZUKAN;
	max++;
	list[max] = MENU_POS_POKEMON;
	max++;
	list[max] = MENU_POS_BAG;
	max++;
	list[max] = MENU_POS_HERO;
	max++;
    list[max] = MENU_POS_REPORT;
	max++;
	list[max] = MENU_POS_CONFIG;
	max++;
	list[max] = MENU_POS_EXIT;
	max++;

	return max;
}

//==============================================================================
/**
 * b̋Ns
 * @param   targetID   bINDEX
 * @retval  none
 */
//==============================================================================

static void _startMenuInit(_START_WORK* pStart)
{
//    BMPLIST_HEADER list_h;
    BMPMENU_HEADER	hed;
    const _MYNAME_MENUNUM = 4;
	u8	list[ _FIELD_MENU_MAX ];
    int max;

	max = _menuListMake( list );
    
    //FieldOBJSys_MoveStopAll( pStart->pFSys->fldobjsys );
    
    //BMPEBhE
    pStart->menulist = BMP_MENULIST_Create( NELEMS(MenuParamList), HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pStart->pFSys->bgl,&pStart->win,
                     GF_BGL_FRAME3_M, FLD_MENU_WIN_PX, FLD_MENU_WIN_PY, FLD_MENU_WIN_SX,
                     NELEMS(MenuParamList)*3, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(10*NELEMS(MenuParamList)*3));
	MenuWinGraphicSet(
        pStart->pFSys->bgl, FLD_MBGFRM_FONT, MENU_WIN_CGX_NUM,
        MENU_WIN_PAL, 0, HEAPID_FIELD );

    BmpMenuWinWrite(&pStart->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_underworld_dat, HEAPID_FIELD);
		for(i=0; i < NELEMS(MenuParamList); i++)
		{
            ///@@OOmystatus
            if(i == _MYNAME_MENUNUM){
                const MYSTATUS* pMy = SaveData_GetMyStatus( GameSystem_GetSaveData(pStart->pFSys) );
                STRBUF* pBuf = MyStatus_CreateNameString(pMy, HEAPID_FIELD);
                BMP_MENULIST_AddString( pStart->menulist, pBuf, MenuParamList[i].param );
                STRBUF_Delete(pBuf);
            }
            else{
                BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
                                               MenuParamList[i].str_id,
                                               MenuParamList[i].param );
            }
		}
		MSGMAN_Delete(msgman);
	}

	hed.menu  = pStart->menulist;
	hed.win   = &pStart->win;
	hed.font  = FONT_TALK;
	hed.x_max = 1;
	hed.y_max = NELEMS(MenuParamList);
	hed.line_spc = 8;
	hed.c_disp_f = 1;
	if( NELEMS(MenuParamList) >= 4 ){
		hed.loop_f = 1;
	}else{
		hed.loop_f = 0;
	}
	pStart->mw = BmpMenuAdd_NoTrans(
				&hed, 28, 4, pStart->pos, HEAPID_WORLD, PAD_BUTTON_CANCEL|PAD_BUTTON_START );
    pStart->lw = NULL;

	GF_BGL_BmpWinOnVReq( &pStart->win );

    
    CellActSet( pStart, list ,NELEMS(MenuParamList), MyStatus_GetMySex(SaveData_GetMyStatus(pStart->pFSys->savedata)) );
    FieldSystemProc_SeqHold();
}

//--------------------------------------------------------------
/**
 * @brief   b߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

typedef enum{
    _START_INIT,
    _START_MENU,
    _START_END,
    _START_ALL_END,
    _START_TRAP_WAIT,
    _START_STONE_WAIT,
    _START_TREASURE_WAIT,
    _START_GOODS_WAIT,
    _START_GOODS_WAIT_SUB,
    _START_STATUS_WAIT,
    _START_EXIT_WAIT,
    _START_EXIT_WAIT2,
    _START_EXIT_WAIT3,
    _START_EXIT_WAIT4,
};


static void _bagProcess(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    switch(pStart->seq){
      case _START_INIT:
        _startMenuInit(pStart);
        pStart->seq++;
        break;
      case _START_MENU:
        _startMenuFunc(tcb, work);
        break;
      case _START_END:
        _startMenuEnd(pStart);
        _delEnd(tcb,pStart);
        return;
      case _START_TRAP_WAIT:
        _trapMenuFunc(tcb, work);
        break;
      case _START_STONE_WAIT:
        _stoneMenuFunc(tcb, work);
        break;
      case _START_TREASURE_WAIT:
        _treasureMenuFunc(tcb, work);
        break;
      case _START_GOODS_WAIT:
        _goodsMenuFunc(tcb, work);
        break;
      case _START_GOODS_WAIT_SUB:
        _goodsMenuFuncSub(tcb, work);
        break;
      case _START_STATUS_WAIT:
        break;
      case _START_EXIT_WAIT:
        _exitTalkFunc(tcb,work);
        break;
      case _START_EXIT_WAIT2:
        _exitTalkFunc2(tcb,work);
        break;
      case _START_EXIT_WAIT3:
        _exitTalkFunc3(tcb,work);
        break;
      case _START_EXIT_WAIT4:
        _exitTalkFunc4(tcb,work);
        break;
    }
}


static BOOL _startMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;
	u16	cur;

	cur = BmpMenuCursorPosGet( pStart->mw );
	pStart->ret = BmpMenuMain( pStart->mw );
	pStart->pos = BmpMenuCursorPosGet( pStart->mw );

	if( cur != pStart->pos ){
		CursorMove( pStart->cap[CLA_SET_CURSOR]->act, pStart->pos );
		MoveIconAnmChg( pStart, cur, pStart->pos );
	}
	SelectIconAnmCheck( pStart->cap[CLA_SET_ICON+pStart->pos]->act );
    
    if(CommIsError()){  // G[̓LZɂ
        pStart->ret = BMPLIST_CANCEL;
    }
    CellActAnm( pStart );
    CLACT_Draw( pStart->fcat.cas );
    switch(pStart->ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _START_END;
        break;
    default:
        {
            pStartFunc func = (pStartFunc)pStart->ret;
            func(pStart);  // ֐Wv
        }
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   j[Xg
 * @param   tcb			TCBւ̃|C^
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

void _startMenuEnd(_START_WORK* pStart)
{
    if(pStart->lw){
        BmpListExit(pStart->lw, NULL, NULL);
        pStart->lw = NULL;
    }
    else if (pStart->clact_max){
        CellActDelete( pStart );
        BmpMenuExit( pStart->mw, NULL );
        pStart->clact_max = 0;
    }
    else{
        return;
    }
    BmpMenuWinClear(&pStart->win, WINDOW_TRANS_OFF );
    GF_BGL_LoadScreenV_Req( pStart->win.ini, pStart->win.frmnum );
   // GF_BGL_BmpWinOff(&pStart->win);
    GF_BGL_BmpWinDel(&pStart->win);
    BMP_MENULIST_Delete(pStart->menulist);
}

//--------------------------------------------------------------
/**
 * @brief   gbvj[㩂ꍇ̃R[obN
 * @param   type  gbv^Cv
 * @retval  none
 */
//--------------------------------------------------------------
void CommUnderBagDeleteTrap(int type)
{
    GF_ASSERT(_pUnderItem->deleteItem == type);
    // 㩂
    UnderGroundDelTrapBagItem(_pUnderItem->pUGData, _pUnderItem->deleteIndex);
}

//--------------------------------------------------------------
/**
 * @brief   gbvj[X^[g
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

#define _TRAPMENU_POSX    (19)
#define _TRAPMENU_POSY    (1)
#define _TRAPMENU_SIZE_X  (12)

void _trapMenuStart_Bag(_START_WORK* pStart )
{
    pStart->getNumFunc = _underBagGetTrapNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underBagGetTrapID;
    _trapMenuStart(pStart);
}

void _trapMenuStart_Pc(_START_WORK* pStart)
{
    pStart->getNumFunc = _underPcGetTrapNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underPcGetTrapType;
    _trapMenuStart(pStart);
}

static void _trapMenuStart(_START_WORK* pStart)
{
    pGetNumFunc getNumFunc = pStart->getNumFunc;
    pGetTypeFunc getTypeFunc = pStart->getTypeFunc;
    BMPLIST_HEADER list_h;
    int count = getNumFunc(pStart);
    int line = _FIELD_MENU_MAX;

    _startMenuEnd(pStart);
    //BMPEBhE
    pStart->menulist = BMP_MENULIST_Create( count+1, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pStart->pFSys->bgl,&pStart->win,
                     GF_BGL_FRAME3_M, _TRAPMENU_POSX, _TRAPMENU_POSY,
                     _TRAPMENU_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX - (10 * (line+2) * 2));
    BmpMenuWinWrite(&pStart->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i=0;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergroundtrap_dat, HEAPID_FIELD);
		for(i=0; i < count ; i++)
		{
			BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
                                           getTypeFunc(i,pStart), i );
		}
        BMP_MENULIST_AddArchiveString( pStart->menulist, msgman, UGTrapMenuEnd, _MENURETURN_EXIT);
		MSGMAN_Delete(msgman);
	}

    list_h = MenuListHeader;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = pStart->menulist;
    list_h.win = &pStart->win;
    list_h.call_back = pStart->pLineCallBack;
    list_h.work = pStart;
    pStart->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pStart->win);
    pStart->seq = _START_TRAP_WAIT;
}

//--------------------------------------------------------------
/**
 * @brief   gbvj[
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _trapMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _START_END;
        break;
    default:
        {
            pStart->seq = _START_END;
            _pUnderItem->deleteIndex = ret;   // ACeĂindex
            _pUnderItem->deleteItem = _underBagGetTrapID(ret,pStart);    // ACeԍ
            if( _pUnderItem->deleteItem == UG_TRAPTYPE_DRILL){  // h͔閧np
                CommSecretBaseDrillStart();
            }
            else{
                CommTrapInfoAddTrap(_underBagGetTrapID(ret,pStart));
            }
        }
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ܃j[Ő΂ꍇ̃R[obN
 * @param   type  ΃^Cv
 * @retval  none
 */
//--------------------------------------------------------------
void CommUnderBagDeleteStone(int type)
{
    GF_ASSERT(_pUnderItem->deleteItem == type);
    UnderGroundDelStoneBagItem(_pUnderItem->pUGData ,_pUnderItem->deleteIndex);
}


//--------------------------------------------------------------
/**
 * @brief   j[X^[g
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

#define _STONEMENU_POSX    (19)
#define _STONEMENU_POSY    (1)
#define _STONEMENU_SIZE_X  (12)

void _stoneMenuStart_Bag(_START_WORK* pStart)
{
    pStart->getNumFunc = _underBagGetStoneNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underBagGetStoneID;
    pStart->getCaratFunc =_underBagGetStoneCarat;
    _stoneMenuStart(pStart);
}

void _stoneMenuStart_Pc(_START_WORK* pStart)
{
    pStart->getNumFunc = _underPcGetStoneNum;
    pStart->getTypeFunc = _underPcGetStoneType;
    pStart->getCaratFunc =_underPcGetStoneCarat;
    _stoneMenuStart(pStart);
}

static void _stoneMenuStart(_START_WORK* pStart)
{
    pGetNumFunc getNumFunc = pStart->getNumFunc;
    pGetTypeFunc getTypeFunc = pStart->getTypeFunc;
    pGetCaratFunc getCaratFunc = pStart->getCaratFunc;
    BMPLIST_HEADER list_h;
    int count = getNumFunc(pStart);
    int line = _FIELD_MENU_MAX;

    _startMenuEnd(pStart);
    //BMPEBhE
    pStart->menulist = BMP_MENULIST_Create( count+1, HEAPID_FIELD );


    GF_BGL_BmpWinAdd(pStart->pFSys->bgl,&pStart->win,
                     GF_BGL_FRAME3_M, _STONEMENU_POSX, _STONEMENU_POSY,
                     _STONEMENU_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(10 * (line+2) * 2));
    BmpMenuWinWrite(&pStart->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergrounditem_dat, HEAPID_FIELD);
        for(i = 0; i < count; i++) {
            WORDSET_RegisterUGItemName(pStart->pWordSet, 2, getTypeFunc(i,pStart) );
            WORDSET_RegisterNumber(pStart->pWordSet, 6, getCaratFunc(i,pStart), 2,
                                   NUMBER_DISPTYPE_ZERO, NUMBER_CODETYPE_DEFAULT);
            MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderWorld()), UGBallMenuDef,
                              pStart->pStrBuf2 );
            WORDSET_ExpandStr( pStart->pWordSet,  pStart->pStrBuf1,
                               pStart->pStrBuf2 );
            BMP_MENULIST_AddString(pStart->menulist,  pStart->pStrBuf1, i);
		}
        BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
                                       UGItemEnd, _MENURETURN_EXIT );
		MSGMAN_Delete(msgman);
	}

    list_h = MenuListHeader;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = pStart->menulist;
    list_h.win = &pStart->win;
    list_h.call_back = pStart->pLineCallBack;
    list_h.work = pStart;
    pStart->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pStart->win);
    pStart->seq = _START_STONE_WAIT;
}

static BOOL _stoneMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _START_END;
        break;
    default:
        {
            _pUnderItem->deleteIndex = ret;   // ACeĂindex
            _pUnderItem->deleteItem = _underBagGetStoneID(ret,pStart);    // ACeԍ
            CommDigStoneAddStone( _pUnderItem->deleteItem,
                                   _underBagGetStoneCarat(ret,pStart));
            pStart->seq = _START_END;
        }
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   烁j[X^[g
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

#define _TREASUREMENU_POSX    (19)
#define _TREASUREMENU_POSY    (1)
#define _TREASUREMENU_SIZE_X  (12)

void _treasureMenuStart_Bag(_START_WORK* pStart)
{
    pStart->getNumFunc = _underBagGetTreasureNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underBagGetTreasureID;
    _treasureMenuStart(pStart);
}

void _treasureMenuStart_Pc(_START_WORK* pStart)
{
    pStart->getNumFunc = _underPcGetTreasureNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underPcGetTreasureType;
    _treasureMenuStart(pStart);
}

static void _treasureMenuStart(_START_WORK* pStart)
{
    pGetNumFunc getNumFunc = pStart->getNumFunc;
    pGetTypeFunc getTypeFunc = pStart->getTypeFunc;
    BMPLIST_HEADER list_h;
    int count = getNumFunc(pStart); //_underBagGetTreasureNum();
    int line = _FIELD_MENU_MAX;

    _startMenuEnd(pStart);
    //BMPEBhE
    pStart->menulist = BMP_MENULIST_Create( count+1, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pStart->pFSys->bgl,&pStart->win,
                     GF_BGL_FRAME3_M, _TREASUREMENU_POSX, _TREASUREMENU_POSY,
                     _TREASUREMENU_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX - (10* line * 2));
    BmpMenuWinWrite(&pStart->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i=0;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergrounditem_dat, HEAPID_FIELD);
        for(i=0; i < count ; i++){
			BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
                                           getTypeFunc(i, pStart), i );
		}
        BMP_MENULIST_AddArchiveString( pStart->menulist, msgman, UGItemEnd, _MENURETURN_EXIT);
		MSGMAN_Delete(msgman);
	}

    list_h = MenuListHeader;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = pStart->menulist;
    list_h.win = &pStart->win;
    list_h.call_back = pStart->pLineCallBack;
    list_h.work = pStart;
    pStart->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pStart->win);
    pStart->seq = _START_TREASURE_WAIT;
}

//--------------------------------------------------------------
/**
 * @brief   gbvj[
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _treasureMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
    default:
        pStart->seq = _START_END;
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   b߂
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _startExit( _START_WORK* pStart )
{
    pStart->seq = _START_END;
}

//--------------------------------------------------------------
/**
 * @brief   nɖ߂
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _underExit( _START_WORK* pStart )
{
    _startMenuEnd(pStart);
    
    pStart->msgIndex =
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                               msg_underworld_52, FALSE, NULL);
    pStart->seq = _START_EXIT_WAIT;
}

//--------------------------------------------------------------
/**
 * @brief   nɖ߂邩ǂYESNOŊmF
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _exitTalkFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;

    if( GF_MSG_PrintEndCheck( pStart->msgIndex ) == 0 ){
        pStart->pYesNoWork =
            BmpYesNoSelectInit( pStart->pFSys->bgl,
                                &_yesNoBmpDat,
                                MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        pStart->seq = _START_EXIT_WAIT2;
    }
}

//--------------------------------------------------------------
/**
 * @brief   nɖ߂邩ǂYESNOŊmF
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _exitTalkFunc2(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    int ret = BmpYesNoSelectMain(pStart->pYesNoWork, HEAPID_FIELD);
    if(ret == BMPMENU_NULL){  // ܂I
        return;
    }else if(ret == 0){ // ͂Iꍇ
        pStart->msgIndex =
            CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                   msg_underworld_53, FALSE, NULL);
        pStart->seq = _START_EXIT_WAIT3;
    }
    else{  // Iꍇ
        pStart->seq = _START_END;
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
    }
}

//--------------------------------------------------------------
/**
 * @brief   Z[ûmF
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _exitTalkFunc3(TCB_PTR tcb, void* work)
{    
        
    _START_WORK* pStart = work;

    if( GF_MSG_PrintEndCheck( pStart->msgIndex ) == 0 ){
        pStart->pYesNoWork =
            BmpYesNoSelectInit( pStart->pFSys->bgl,
                                &_yesNoBmpDat,
                                MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        pStart->seq = _START_EXIT_WAIT4;
    }
}

//--------------------------------------------------------------
/**
 * @brief   mFIĒnɖ߂
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _exitTalkFunc4(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    int ret = BmpYesNoSelectMain(pStart->pYesNoWork, HEAPID_FIELD);
    if(ret == BMPMENU_NULL){  // ܂I
        return;
    }else if(ret == 0){ // ͂Iꍇ
        FieldSystemProc_SeqHoldEnd();
        ChangeUnderGroundDirect(pStart->pFSys);
        pStart->seq = _START_END;
    }
    else{  // Iꍇ
        pStart->seq = _START_END;
    }
    CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
}

//--------------------------------------------------------------
/**
 * @brief   fobOpj[R[obN
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _stateEndCallBack(void* pWork)
{
    _START_WORK* pStart = pWork;
    pStart->seq = _START_END;
}

static void _statusList( _START_WORK* pStart )
{
    _startMenuEnd(pStart);

    UgRecordStatusListStart(pStart->pFSys->bgl,
                            SaveData_GetMyStatus(
                                GameSystem_GetSaveData(pStart->pFSys)),
                            _stateEndCallBack,pStart,TRUE);
    pStart->seq = _START_STATUS_WAIT;
}

//--------------------------------------------------------------
/**
 * @brief   ̏Ɋւ郁j[N
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------


typedef enum{
    _DELMSG_WAIT,
    _DEL_YESNO_WAIT,
    _DEL_END,
    _POINT_WAIT,
    _POINT_YESNO_WAIT,
    _POINT_DOWN,
    _POINT_DOWN_WAIT,

};


void CommUnderBagFlagStart(pBagEndFunc func, FIELDSYS_WORK* pFSys)
{
    _START_WORK* pStart;
    BMPLIST_HEADER list_h;

    pStart = sys_AllocMemory(HEAPID_FIELD, sizeof(_START_WORK));
    MI_CpuFill8(pStart, 0, sizeof(_START_WORK));
    pStart->pFSys = pFSys;
    pStart->endfunc = func;
    pStart->seq = _DELMSG_WAIT;
    pStart->pStrBuf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pStart->pStrBuf2 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pStart->pWordSet = WORDSET_Create( HEAPID_FIELD );

    // tB[h̓~߂
    FieldSystemProc_SeqHold();

    pStart->msgIndex =
        CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),mes_uw_flag_01,FALSE,NULL);

    TCB_Add(_flagProcess, pStart, _MENU_UG_PRI);
}


//==============================================================================
/**
 * b̋Ns
 * @param   targetID   bINDEX
 * @retval  none
 */
//==============================================================================

static void _delWait(_START_WORK* pStart)
{

    if( GF_MSG_PrintEndCheck( pStart->msgIndex ) == 0 ){
        // ͂EChEo
        pStart->pYesNoWork =
            BmpYesNoSelectInit( pStart->pFSys->bgl,
                                &_yesNoBmpDat,
                                MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        pStart->seq = _DEL_YESNO_WAIT;
    }
}

static void _delYesNoWait(_START_WORK* pStart)
{
    int ret = BmpYesNoSelectMain(pStart->pYesNoWork, HEAPID_FIELD);
    if(ret == BMPMENU_NULL){  // ܂I
        return;
    }else if(ret == 0){ // ͂Iꍇ
        CommMsgRegisterNumber2(CommUnderGetMsgUnderFlag(), abs(UNDER_FLAG_POINT_DEL));
        pStart->msgIndex =
            CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(), mes_uw_flag_04, FALSE, NULL);
        pStart->seq = _POINT_WAIT;
    }
    else{  // Iꍇ
        pStart->seq = _DEL_END;
    }
}

//==============================================================================
/**
 * b̋Ns
 * @param   targetID   bINDEX
 * @retval  none
 */
//==============================================================================

static void _pointWait(_START_WORK* pStart)
{

    if( GF_MSG_PrintEndCheck( pStart->msgIndex ) == 0 ){
        // ͂EChEo
        pStart->pYesNoWork =
            BmpYesNoSelectInit( pStart->pFSys->bgl,
                                &_yesNoBmpDat,
                                MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
        pStart->seq = _POINT_YESNO_WAIT;
    }
}



static void _pointYesNoWait(_START_WORK* pStart)
{
    int ret = BmpYesNoSelectMain(pStart->pYesNoWork, HEAPID_FIELD);
    if(ret == BMPMENU_NULL){  // ܂I
        return;
    }else if(ret == 0){ // ͂Iꍇ
        u8 state = UNDER_FLAG_DEL;
        
        CommSendFixSizeData(CF_FLAG_STATE,&state);// ͂ 
        pStart->msgIndex =
            CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                   mes_uw_flag_07, FALSE, NULL);
        pStart->seq = _POINT_DOWN;
    }
    else{  // Iꍇ
        pStart->seq = _DEL_END;
    }
}

//--------------------------------------------------------------
/**
 * @brief   _Ƃ\
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  \TRUE
 */
//--------------------------------------------------------------

static BOOL _pointDownDisp(_START_WORK* pStart)
{
    if( GF_MSG_PrintEndCheck( pStart->msgIndex ) == 0 ){
        CommMsgRegisterNumber2(CommUnderGetMsgUnderFlag(), abs(UNDER_FLAG_POINT_DEL));
        pStart->msgIndex =
            CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(), mes_uw_flag_08, FALSE, NULL);
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   EChE
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _delEnd(TCB_PTR tcb, _START_WORK* pStart)
{
    STRBUF_Delete(pStart->pStrBuf1);
    STRBUF_Delete(pStart->pStrBuf2);
    WORDSET_Delete(pStart->pWordSet);
    
    CommMsgTalkWindowEnd(CommUnderGetMsgUnderFlag());
    if(pStart->endfunc != NULL){
        pStart->endfunc(0);
    }
    sys_FreeMemoryEz(pStart);
    FieldSystemProc_SeqHoldEnd();
    TCB_Delete(tcb);
//    CommUnderResetMsgDataManager();
}

//--------------------------------------------------------------
/**
 * @brief   ̏Ɋւ郁j[̊ǗvZX
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _flagProcess(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;

    switch(pStart->seq){
      case _DELMSG_WAIT:
        _delWait(work);
        break;
      case _DEL_YESNO_WAIT:
        _delYesNoWait(work);
        break;
      case _DEL_END:
        _delEnd(tcb, work);
        return;
      case _POINT_WAIT:
        _pointWait(work);
        break;
      case _POINT_YESNO_WAIT:
        _pointYesNoWait(work);
        break;
      case _POINT_DOWN:
        if(_pointDownDisp(work)){
            pStart->seq = _POINT_DOWN_WAIT;
        }
        break;
      case _POINT_DOWN_WAIT:
        if( GF_MSG_PrintEndCheck( pStart->msgIndex ) == 0 ){
            if(sys.trg & PAD_BUTTON_DECIDE){
                pStart->seq = _DEL_END;
            }
        }
        break;
    }
}

//--------------------------------------------------------------
/**
 * @brief   ObYj[X^[g
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

void _goodsMenuStart_Bag(_START_WORK* pStart)
{
    pStart->getNumFunc = _underBagGetGoodsNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underBagGetGoodsID;
    _goodsMenuStart(pStart);
}

void _goodsMenuStart_Pc(_START_WORK* pStart)
{
    pStart->getNumFunc = _underPcGetGoodsNum; // BAGp擾֐Zbg
    pStart->getTypeFunc = _underPcGetGoodsID;
    _goodsMenuStart(pStart);
}

static void _goodsMenuStart(_START_WORK* pStart)
{
    pGetNumFunc getNumFunc = pStart->getNumFunc;
    pGetTypeFunc getTypeFunc = pStart->getTypeFunc;
    BMPLIST_HEADER list_h;
    int count = getNumFunc(pStart); //_underBagGetGoodsNum();
    int line = _FIELD_MENU_MAX;

    _startMenuEnd(pStart);
    //BMPEBhE
    pStart->menulist = BMP_MENULIST_Create( count+1, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pStart->pFSys->bgl,&pStart->win,
                     GF_BGL_FRAME3_M, _TRAPMENU_POSX, _TRAPMENU_POSY,
                     _TRAPMENU_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX - (10 * (line + 2) * 2));
    BmpMenuWinWrite(&pStart->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i=0;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergroundgoods_dat, HEAPID_FIELD);
		for(i=0; i < count ; i++)
		{
			BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
//                                           _underBagGetGoodsID(i), i );
                                           getTypeFunc(i,pStart), i);
		}
        BMP_MENULIST_AddArchiveString( pStart->menulist, msgman, UGGoodsMenuEnd, BMPLIST_CANCEL);
		MSGMAN_Delete(msgman);
	}

    list_h = MenuListHeader;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = pStart->menulist;
    list_h.win = &pStart->win;
    list_h.call_back = pStart->pLineCallBack;
    list_h.work = pStart;
    pStart->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pStart->win);
    pStart->seq = _START_GOODS_WAIT;
}

//--------------------------------------------------------------
/**
 * @brief   GOODSj[
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _goodsMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _START_END;
        break;
    default:
        pStart->seq = _START_END;
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   GOODSj[
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _goodsMenuFuncSub(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _START_END;
        break;
    default:
        {
            _startMenuEnd(pStart);
            if(pStart->endfunc != NULL){
                _pUnderItem->deleteIndex = ret;
                _pUnderItem->deleteItem = _underBagGetGoodsID(ret,pStart);
                pStart->endfunc(_pUnderItem->deleteItem);
                pStart->endfunc = NULL;
            }
            STRBUF_Delete(pStart->pStrBuf1);
            STRBUF_Delete(pStart->pStrBuf2);
            WORDSET_Delete(pStart->pWordSet);
            sys_FreeMemoryEz(pStart);
            TCB_Delete(tcb);
            return TRUE;
        }
        break;
    }
    return TRUE;
}

//==============================================================================
/**
 * nObYobO
 * @param   none
 * @retval  none
 */
//==============================================================================

void UgBagGoodsMenuStart(pBagEndFunc func, FIELDSYS_WORK* pFSys)
{
    _START_WORK* pStart;
    BMPLIST_HEADER list_h;

    pStart = sys_AllocMemory(HEAPID_FIELD, sizeof(_START_WORK));
    MI_CpuFill8(pStart, 0, sizeof(_START_WORK));
    pStart->pFSys = pFSys;
    pStart->endfunc = func;
    pStart->seq = 0;
    pStart->clact_max = 0;
    pStart->lw = NULL;
    pStart->pLineCallBack = NULL;
    pStart->pStrBuf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pStart->pStrBuf2 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pStart->pWordSet = WORDSET_Create( HEAPID_FIELD );
    _goodsMenuStart_Bag(pStart);
    pStart->seq = _START_GOODS_WAIT_SUB;
    TCB_Add(_bagProcess, pStart, _MENU_UG_PRI);
}


