//=============================================================================
/**
 * @file	comm_dig_fossil.c
 * @brief	΂ƃ~jQ[̃NX
 * @author	Katsumi Ohno
 * @date    2005.12.06
 */
//=============================================================================


#include <nitro/os.h>
#include "common.h"
//
//
//
#include "communication/communication.h"
#include "../comm_field_state.h"
#include "ug_manager.h"
#include "../fieldsys.h"
#include "system/arc_util.h"
#include "system/clact_util.h"
#include "system/render_oam.h"
#include "system/wipe.h"
#include "ug_fossil.naix"
#include "ug_parts.naix"
#include "ug_anim.naix"

#include "system/wordset.h"
#include "msgdata/msg_underworld.h"
#include "system/bmp_menu.h"  //yesno menu
#include "../fieldmap.h"   //yesno menu
#include "../fld_bmp.h"
#include "../talk_msg.h"

#include "system/particle.h"
#include "particledata/particledata.h"
#include "particledata/particledata.naix"


//==============================================================================
// `
//==============================================================================

#define _PICTTEST (0)

#define _FOSSIL_NUM_MAX  (250)  ///< ΃|Cg
#define _SETUP_NUM_MAX   (25)   ///< POgZbg

#define _PARTS_NUM_MAX   (16)          ///< ܂Ă̂̌E
#define _PARTS_TREASURE_NUM_MAX (4)  ///< ̌E c͍d
#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY

#define _DIGMAP_WIDTH    (13)    ///< 
#define _DIGMAP_HEIGHT   (10)    ///< 
#define _DIGMAP_INVALID  (0xff)   ///< @邱ƂłȂꏊ
#define _FRIEND_DIG_AREA  (10)   ///< ǂ̂炢߂Ύ`Ă̂

#define _DIG_GAUGE_START (200)   ///< @Q[W̃X^[g

#define _PUSH_START (2)

typedef enum {
    _HUMMER_BUTTON,
    _PIC_BUTTON,
    _END_BUTTON,
};

//#define _COST_HARD_DIG_HUMMER   (6)   ///< d̎̃n}[
//#define _COST_HARD_DIG_PIC   (2)   ///< d̎̃m~
#define _COST_DIG_HUMMER   (6)   ///< n}[̏
#define _COST_DIG_PIC   (2)   ///< m~̏

///퓬p[eBÑJjAݒ
#define BP_NEAR			(FX32_ONE)
///퓬p[eBÑJt@[ݒ
#define BP_FAR			(FX32_ONE * 900)

// CellActorɏ郊\[X}l[W̎ނ̐
#define CLACT_OBJ_NUM (4)
#define CLACT_RESOURCE_NUM		(  4*CLACT_OBJ_NUM )
#define SUB_LCD  (1)
#define MAIN_LCD  (0)
#define BOTH_LCD  (2)


#define _CLACT_HUMMER (0)  // ACTID
#define _CLACT_HIBI (1)  // ACTID
#define _CLACT_EFFECT (2) //
#define _CLACT_HIT (3) //

//==============================================================================
//	^錾
//==============================================================================

typedef struct{  // XN[pRECT\
    u8 lt_x;
    u8 lt_y;
    u8 rb_x;
    u8 rb_y;
} _SCR_RECT;


typedef struct{
    int seq;
    int subseq;
    int timer;
    BOOL fadeFlg;
    int _PARTS_TREASURE_NUM;
    FIELDSYS_WORK* pFSys;
} FossilEventTask;

typedef struct{
    u16 xpos;
    u16 zpos;
    u8 digCreatureNetID;
} FossilPoint;

typedef struct{
    void* attribute;     // Agr[gf[^ւ̃|C^  NULL
    u16 random;
    u8 width;
    u8 height;
    u8 partsType;           // p[c
    u16 ncg;
    u16 ncl;
} FossilParts;


typedef struct{
    FossilParts* pParts;  // f[^Qƃ|C^
    u8 partsType;           // p[c
    u8 x;
    u8 y;
    u8 dir;
    u8 bGetItem;
} FossilPartsData;


// ΑS
typedef struct{
    FIELDSYS_WORK* pFSys;   //
    GF_BGL_INI* bgl;   // ΃~jQ[pBGL

	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[4];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s[CLACT_OBJ_NUM];	// ZAN^[wb_[
    CLACT_WORK_PTR			clActWork[CLACT_OBJ_NUM];          // ZAN^[[N|C^z

    FossilPoint aFossilPoint[_FOSSIL_NUM_MAX];  //
    BMPMENU_WORK* pYesNoWork;
    FossilPoint* pEntryFossil[COMM_MACHINE_MAX]; ///< @\񒆂̉
    FossilPartsData aDeposit[_PARTS_NUM_MAX];  //  _partsData ̃|C^
/*  p[eBNgpȂȂ܂
    PTC_PTR ptc;  // p[eBNǗ|C^
   */
    void* pAlloc;  // AP[^[
    u8 friendDigPointX[COMM_MACHINE_MAX];
    u8 friendDigPointZ[COMM_MACHINE_MAX];
    u8 depositMap[ _DIGMAP_HEIGHT ][ _DIGMAP_WIDTH ];   // MAP  index+1 0͖ĂȂ
    u8 buildupMap[ _DIGMAP_HEIGHT ][ _DIGMAP_WIDTH ];   // ͐MAP
    int winIndex;
    u16 particleX;
    u16 particleY;
    u8 bPic;   // ݂̂ǂ
    u8 touchPanelRelease; // ^b`pl𗣂 1
    u8 touchButton;
    u8 digGauge;   // @Q[W
    u8 resObjCount;
} CommFossilWork;

//==============================================================================
// [N
//==============================================================================
// VOg
static CommFossilWork* _pCommFossilWork = NULL;

//==============================================================================
// static錾
//==============================================================================

// 邩ǂMAP  Ȃ̂Ŏ菑@ɖ͎̂lp`S

static u8 _attribute_keystone[8][8]={
    {'o','o','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','o','o'},
};


static u8 _attribute_bone[12][6]={
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
};

static u8 _attribute_bone90[6][12]={
    {'x','x','o','o','o','o','o','o','o','o','x','x'},
    {'x','x','o','o','o','o','o','o','o','o','x','x'},
    {'x','x','x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x','x','x'},
    {'x','x','o','o','o','o','o','o','o','o','x','x'},
    {'x','x','o','o','o','o','o','o','o','o','x','x'},
};

static u8 _attribute_honoo[8][8]={
    {'o','o','o','o','x','x','o','o'},
    {'o','o','o','o','x','x','o','o'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'o','o','x','x','o','o','o','o'},
    {'o','o','x','x','o','o','o','o'},
};

static u8 _attribute_iwa03[4][6]={
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
};

static u8 _attribute_iwa0390[6][4]={
    {'o','o','x','x'},
    {'o','o','x','x'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'o','o','x','x'},
    {'o','o','x','x'},
};

static u8 _attribute_iwa03180[4][6]={
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
};

static u8 _attribute_iwa03270[6][4]={
    {'x','x','o','o'},
    {'x','x','o','o'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'x','x','o','o'},
    {'x','x','o','o'},
};

static u8 _attribute_iwa04[4][6]={
    {'x','x','x','x','o','o'},
    {'x','x','x','x','o','o'},
    {'o','o','x','x','x','x'},
    {'o','o','x','x','x','x'},
};

static u8 _attribute_iwa0490[6][4]={
    {'o','o','x','x'},
    {'o','o','x','x'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'x','x','o','o'},
    {'x','x','o','o'},
};

static u8 _attribute_iwa05[4][6]={
    {'o','o','x','x','x','x'},
    {'o','o','x','x','x','x'},
    {'x','x','x','x','o','o'},
    {'x','x','x','x','o','o'},
};

static u8 _attribute_iwa0590[6][4]={
    {'x','x','o','o'},
    {'x','x','o','o'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'o','o','x','x'},
    {'o','o','x','x'},
};


static u8 _attribute_kai[8][8]={
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
};

static u8 _attribute_kai90[8][8]={
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
};

static u8 _attribute_kaminari[6][6]={
    {'o','o','x','x','x','x'},
    {'o','o','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','o','o'},
    {'x','x','x','x','o','o'},
};

static u8 _attribute_kohaku[8][8]={
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
};

static u8 _attribute_kohaku90[8][8]={
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
};

static u8 _attribute_koura[8][10]={
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','x','x','o','o'},
};

static u8 _attribute_mizu[6][6]={
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','o','o'},
    {'x','x','x','x','o','o'},
};

static u8 _attribute_moon[4][8]={
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
};

static u8 _attribute_moon90[8][4]={
    {'x','x','o','o'},
    {'x','x','o','o'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'x','x','x','x'},
    {'o','o','x','x'},
    {'o','o','x','x'},
};

static u8 _attribute_tsume[10][8]={
    {'o','o','o','o','x','x','x','x'},
    {'o','o','o','o','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','o','o','o','o'},
    {'x','x','x','x','o','o','o','o'},
};

static u8 _attribute_tsume90[8][10]={
    {'x','x','x','x','o','o','o','o','o','o'},
    {'x','x','x','x','o','o','o','o','o','o'},
    {'x','x','x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x','x','x'},
    {'o','o','o','o','x','x','x','x','x','x'},
    {'o','o','o','o','x','x','x','x','x','x'},
};

static u8 _attribute_tsume180[10][8]={
    {'o','o','o','o','x','x','x','x'},
    {'o','o','o','o','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','o','o'},
    {'x','x','x','x','o','o','o','o'},
    {'x','x','x','x','o','o','o','o'},
};

static u8 _attribute_tsume270[8][10]={
    {'x','x','x','x','x','x','o','o','o','o'},
    {'x','x','x','x','x','x','o','o','o','o'},
    {'x','x','x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x','x','x'},
    {'o','o','o','o','o','o','x','x','x','x'},
    {'o','o','o','o','o','o','x','x','x','x'},
};

static u8 _attribute_sun[6][6]={
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
};

static u8 _attribute_star[6][6]={
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
};

static u8 _attribute_reaf90[6][8]={
    {'o','o','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','o','o'},
};

static u8 _attribute_reaf[8][6]={
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'x','x','x','x','x','x'},
    {'o','o','x','x','o','o'},
    {'o','o','x','x','o','o'},
};

static u8 _attribute_nekko[10][10]={
    {'x','x','x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','o','o','x','x','x','x'},
    {'x','x','x','x','o','o','x','x','x','x'},
    {'o','o','o','o','o','o','x','x','x','x'},
    {'o','o','o','o','o','o','x','x','x','x'},
    {'o','o','o','o','x','x','x','x','o','o'},
    {'o','o','o','o','x','x','x','x','o','o'},
};

static u8 _attribute_nekko90[10][10]={
    {'o','o','o','o','x','x','x','x','x','x'},
    {'o','o','o','o','x','x','x','x','x','x'},
    {'o','o','o','o','x','x','x','x','x','x'},
    {'o','o','o','o','x','x','x','x','x','x'},
    {'x','x','o','o','o','o','x','x','x','x'},
    {'x','x','o','o','o','o','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','x','x','o','o'},
};

static u8 _attribute_nekko180[10][10]={
    {'o','o','x','x','x','x','o','o','o','o'},
    {'o','o','x','x','x','x','o','o','o','o'},
    {'x','x','x','x','o','o','o','o','o','o'},
    {'x','x','x','x','o','o','o','o','o','o'},
    {'x','x','x','x','o','o','x','x','x','x'},
    {'x','x','x','x','o','o','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x','x','x'},
    {'o','o','x','x','x','x','x','x','x','x'},
};


static u8 _attribute_nekko270[10][10]={
    {'o','o','x','x','x','x','x','x','o','o'},
    {'o','o','x','x','x','x','x','x','o','o'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','x','x','x','x','x','x'},
    {'x','x','x','x','o','o','o','o','x','x'},
    {'x','x','x','x','o','o','o','o','x','x'},
    {'x','x','x','x','x','x','o','o','o','o'},
    {'x','x','x','x','x','x','o','o','o','o'},
    {'x','x','x','x','x','x','o','o','o','o'},
    {'x','x','x','x','x','x','o','o','o','o'},
};


    
// ΃p[c
static FossilParts _partsData[]={
    //񂲂	kaseki_kongou_s    
    {NULL, 10, 4,4, DIG_PARTS_KONGOU_S,
        NARC_ug_parts_kaseki_kongou_s_NCGR,
        NARC_ug_parts_kaseki_kongou_NCLR},
    //炽	kaseki_siratama_s
    {NULL, 10, 4,4, DIG_PARTS_SIRATAMA_S,
        NARC_ug_parts_kaseki_siratama_s_NCGR,
        NARC_ug_parts_kaseki_siratama_NCLR},
    //
    {NULL, 10, 4,4, DIG_PARTS_RED_S,
        NARC_ug_parts_kaseki_akatama_s_NCGR,
        NARC_ug_parts_kaseki_akatama_NCLR},
    //
    {NULL, 10, 4,4,  DIG_PARTS_BLUE_S,
        NARC_ug_parts_kaseki_aotama_s_NCGR,
        NARC_ug_parts_kaseki_aotama_NCLR},
    //݂ǂ̂
    {NULL, 10, 4,4, DIG_PARTS_GREEN_S,
        NARC_ug_parts_kaseki_midotama_s_NCGR,
        NARC_ug_parts_kaseki_midotama_NCLR},
    //񂲂	kaseki_kongou_l
    {NULL,  5, 6,6, DIG_PARTS_KONGOU_L,
        NARC_ug_parts_kaseki_kongou_l_NCGR,
        NARC_ug_parts_kaseki_kongou_NCLR},
    //炽	kaseki_siratama_l
    {NULL,  5, 6,6, DIG_PARTS_SIRATAMA_L,
        NARC_ug_parts_kaseki_siratama_l_NCGR,
        NARC_ug_parts_kaseki_siratama_NCLR},
    //	kaseki_akatama_l
    {NULL,  5, 6,6, DIG_PARTS_RED_L,
        NARC_ug_parts_kaseki_akatama_l_NCGR,
        NARC_ug_parts_kaseki_akatama_NCLR},
    //	kaseki_aotama_l
    {NULL,  5, 6,6, DIG_PARTS_BLUE_L,
        NARC_ug_parts_kaseki_aotama_l_NCGR,
        NARC_ug_parts_kaseki_aotama_NCLR},
    //݂ǂ肽	kaseki_midotama_l
    {NULL,  5, 6,6, DIG_PARTS_GREEN_L,
        NARC_ug_parts_kaseki_midotama_l_NCGR,
        NARC_ug_parts_kaseki_midotama_NCLR},
    //܂܂	kaseki_manmaru
    {NULL,  5, 6,6, DIG_PARTS_CIRCLE,
        NARC_ug_parts_kaseki_manmaru_NCGR,
        NARC_ug_parts_kaseki_tamago_NCLR},
    //Ȃ	kaseki_kaname                              
    {_attribute_keystone,  5, 8,8, DIG_PARTS_KEYSTONE,
        NARC_ug_parts_kaseki_kaname_NCGR,
        NARC_ug_parts_kaseki_kaname_NCLR},
    //悤̂	kaseki_sun
    {_attribute_sun, 2, 6,6, DIG_PARTS_SUN,
        NARC_ug_parts_kaseki_sun_NCGR,
        NARC_ug_parts_kaseki_sun_NCLR},
    //ق̂	kaseki_star                            
    {_attribute_star, 2, 6,6, DIG_PARTS_STAR,
        NARC_ug_parts_kaseki_star_NCGR,
        NARC_ug_parts_kaseki_star_NCLR},
    //̂	kaseki_moon                            
    {_attribute_moon, 2, 8,4, DIG_PARTS_MOON,
        NARC_ug_parts_kaseki_moon_NCGR,
        NARC_ug_parts_kaseki_moon_NCLR},
    //̂90	kaseki_moon90
    {_attribute_moon90, 2, 4,8, DIG_PARTS_MOON,
        NARC_ug_parts_kaseki_moon90_NCGR,
        NARC_ug_parts_kaseki_moon_NCLR},
    //	kaseki_hard
    {NULL, 2, 4,4, DIG_PARTS_HARD,
        NARC_ug_parts_kaseki_hard_NCGR,
        NARC_ug_parts_kaseki_hard_NCLR},
    //݂Ȃ̂	kaseki_kaminari                   
    {_attribute_kaminari, 2, 6,6,DIG_PARTS_KAMINARI,
        NARC_ug_parts_kaseki_kaminari_NCGR,
        NARC_ug_parts_kaseki_kaminari_NCLR},
    //炸̂	kaseki_kawarazu
    {NULL, 2, 8,4, DIG_PARTS_KAWARAZU,
        NARC_ug_parts_kaseki_kawarazu_NCGR,
        NARC_ug_parts_kaseki_kawarazu_NCLR},
    //ق̂̂	kaseki_honoo                          ~
    {_attribute_honoo, 2, 8,8, DIG_PARTS_HONOO,
        NARC_ug_parts_kaseki_honoo_NCGR,
        NARC_ug_parts_kaseki_honoo_NCLR},
    //݂̂	kaseki_mizu
    {_attribute_mizu, 2, 6,6, DIG_PARTS_MIZU,
        NARC_ug_parts_kaseki_mizu_NCGR,
        NARC_ug_parts_kaseki_mizu_NCLR},
    //[t̂	kaseki_reaf                       x
    {_attribute_reaf, 2, 6,8, DIG_PARTS_REAF,
        NARC_ug_parts_kaseki_reaf_NCGR,
        NARC_ug_parts_kaseki_reaf_NCLR},
    //[t̂	kaseki_reaf
    {_attribute_reaf90, 2, 8,6, DIG_PARTS_REAF,
        NARC_ug_parts_kaseki_reaf90_NCGR,
        NARC_ug_parts_kaseki_reaf_NCLR},
    //̂	kaseki_gold
    {NULL, 2, 6,6, DIG_PARTS_GOLD,
        NARC_ug_parts_kaseki_gold_NCGR,
        NARC_ug_parts_kaseki_gold_NCLR},
    //̃JZL	kaseki_kai
    {_attribute_kai, 2, 8,8, DIG_PARTS_KAI,
        NARC_ug_parts_kaseki_kai_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //̃JZL	kaseki_kai90
    {_attribute_kai90, 2, 8,8, DIG_PARTS_KAI,
        NARC_ug_parts_kaseki_kai90_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //̃JZL	kaseki_kai180
    {_attribute_kai, 2, 8,8, DIG_PARTS_KAI,
        NARC_ug_parts_kaseki_kai180_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //̃JZL	kaseki_kai270
    {_attribute_kai90, 2, 8,8, DIG_PARTS_KAI,
        NARC_ug_parts_kaseki_kai270_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //̃JZL	kaseki_koura
    {_attribute_koura, 2, 10,8, DIG_PARTS_KOURA,
        NARC_ug_parts_kaseki_koura_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //c̃JZL	kaseki_tsume
    {_attribute_tsume, 2, 8,10, DIG_PARTS_TSUME,
        NARC_ug_parts_kaseki_tsume_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //c̃JZL	kaseki_tsume90
    {_attribute_tsume90, 2, 10,8, DIG_PARTS_TSUME,
        NARC_ug_parts_kaseki_tsume90_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //c̃JZL	kaseki_tsume180
    {_attribute_tsume180, 2, 8,10, DIG_PARTS_TSUME,
        NARC_ug_parts_kaseki_tsume180_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //c̃JZL	kaseki_tsume270
    {_attribute_tsume270, 2, 10,8, DIG_PARTS_TSUME,
        NARC_ug_parts_kaseki_tsume270_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //˂̃JZL	kaseki_nekko
    {_attribute_nekko, 2, 10,10, DIG_PARTS_NEKKO,
        NARC_ug_parts_kaseki_nekko_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //˂̃JZL	kaseki_nekko90
    {_attribute_nekko90, 2, 10,10, DIG_PARTS_NEKKO,
        NARC_ug_parts_kaseki_nekko90_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //˂̃JZL	kaseki_nekko180
    {_attribute_nekko180, 2, 10,10, DIG_PARTS_NEKKO,
        NARC_ug_parts_kaseki_nekko180_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //˂̃JZL	kaseki_nekko270
    {_attribute_nekko270, 2, 10,10, DIG_PARTS_NEKKO,
        NARC_ug_parts_kaseki_nekko270_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //Ђ݂̃RnN	kaseki_kohaku
    {_attribute_kohaku, 2, 8,8, DIG_PARTS_KOHAKU,
        NARC_ug_parts_kaseki_kohaku_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //Ђ݂̃RnN	kaseki_kohaku90
    {_attribute_kohaku90, 2, 8,8, DIG_PARTS_KOHAKU,
        NARC_ug_parts_kaseki_kohaku90_NCGR,
        NARC_ug_parts_kaseki_kaseki_NCLR},
    //ӂƂق	kaseki_bone                           
    {_attribute_bone, 2, 6,12, DIG_PARTS_BONE,
        NARC_ug_parts_kaseki_bone_NCGR,
        NARC_ug_parts_kaseki_bone_NCLR},
    //ӂƂق	kaseki_bone90
    {_attribute_bone90, 12, 12,6, DIG_PARTS_BONE,
        NARC_ug_parts_kaseki_bone90_NCGR,
        NARC_ug_parts_kaseki_bone_NCLR},
    //@Ȃ	kaseki_iwa01	ʐςS}X	_`̐^̐
    {NULL, 2, 8, 2, DIG_PARTS_NODIG1,
        NARC_ug_parts_kaseki_iwa01_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa01	ʐςS}X	_`̐^̐
    {NULL, 2, 2, 8, DIG_PARTS_NODIG1,
        NARC_ug_parts_kaseki_iwa0190_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa02	ʐςS}X	lp^̐^̐
    {NULL, 2, 4, 4, DIG_PARTS_NODIG2,
        NARC_ug_parts_kaseki_iwa02_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa03	ʐςS}X	T^̐^̐
    {_attribute_iwa03, 2, 6, 4, DIG_PARTS_NODIG3,
        NARC_ug_parts_kaseki_iwa03_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa0390	ʐςS}X	T^̐^̐
    {_attribute_iwa0390, 2, 4, 6, DIG_PARTS_NODIG3,
        NARC_ug_parts_kaseki_iwa0390_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa03180	ʐςS}X	T^̐^̐
    {_attribute_iwa03180, 2, 6, 4, DIG_PARTS_NODIG3,
        NARC_ug_parts_kaseki_iwa03180_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa03270	ʐςS}X	T^̐^̐
    {_attribute_iwa03270, 2, 4, 6, DIG_PARTS_NODIG3,
        NARC_ug_parts_kaseki_iwa03270_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa04	ʐςS}X	Z^̐^̐
    {_attribute_iwa04, 2, 6, 4, DIG_PARTS_NODIG4,
        NARC_ug_parts_kaseki_iwa04_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa0490	ʐςS}X	Z^̐^̐
    {_attribute_iwa0490, 2, 4, 6, DIG_PARTS_NODIG4,
        NARC_ug_parts_kaseki_iwa0490_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa05	ʐςS}X	S^̐^̐
    {_attribute_iwa05, 2, 6, 4, DIG_PARTS_NODIG5,
        NARC_ug_parts_kaseki_iwa05_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa0590	ʐςS}X	S^̐^̐
    {_attribute_iwa0590, 2, 4, 6, DIG_PARTS_NODIG5,
        NARC_ug_parts_kaseki_iwa0590_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa06	ʐςX}X	lp^̐^̐
    {NULL, 2, 6, 6, DIG_PARTS_NODIG6,
        NARC_ug_parts_kaseki_iwa06_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa07	ʐςW}X	_`̐^̐
    {NULL, 2, 4, 8, DIG_PARTS_NODIG7,
        NARC_ug_parts_kaseki_iwa07_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
    //@Ȃ	kaseki_iwa07	ʐςW}X	_`̐^̐
    {NULL, 2, 8, 4, DIG_PARTS_NODIG7,
        NARC_ug_parts_kaseki_iwa0790_NCGR,
        NARC_ug_parts_kaseki_iwa_NCLR},
};


static void _gaugeDisp(GF_BGL_INI* bgl);
static void _setSetup(MATHRandContext32* pRand);
static FossilPoint* _getFreeFossilPoint(void);
static FossilPoint* _searchFossilPoint(u16 xpos, u16 zpos);
static void _yesnoMenuFunc(TCB_PTR tcb, void* work);
static void _commFossilGameInitialize1(FossilEventTask* pFET);
static void _commFossilGameInitialize2(void);
static void _digFossilEventStart(FIELDSYS_WORK* pFSys);
static BOOL _isEnd(void);
static void _randomDeposit(GF_BGL_INI* bgl,int charByte,FossilEventTask* pFET);
static void _depositBGInit(int idx, GF_BGL_INI* bgl, int charByte,FossilEventTask* pFET);
static void _randomBuildup(GF_BGL_INI* bgl);
static void _buildupBGDraw(GF_BGL_INI* bgl);
static BOOL _gameProcess(FossilEventTask* pFET);
static void _touchButtonInitialize(GF_BGL_INI* bgl);
static void _touchButtonProcess(GF_BGL_INI* bgl,int x, int y, int level);
static BOOL _treasureCheck(FossilEventTask* pFET);
static BOOL _fossilGetMessage(FossilEventTask* pFET);
static void _initCellActor(void);
static void _setCellActor(void);
static void char_pltt_manager_init(void);
static void vBlankFunc(void * work);

static const BMPWIN_DAT _yesNoBmpDat = {
    FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
    FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
    };



//==============================================================================
// ֐
//==============================================================================

//==============================================================================
/**
 * Ό@Q[ɕKvȂ̂̏
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _initializeDigGame(void)
{
    int i;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        _pCommFossilWork->friendDigPointX[i] = _DIGMAP_INVALID;
        _pCommFossilWork->friendDigPointZ[i] = _DIGMAP_INVALID;
    }
    _pCommFossilWork->bPic = FALSE;
    _pCommFossilWork->touchPanelRelease = 0;
    _pCommFossilWork->digGauge = _DIG_GAUGE_START;

    for(i = 0 ; i < _PARTS_NUM_MAX; i++){
        _pCommFossilWork->aDeposit[i].pParts = NULL;
        _pCommFossilWork->aDeposit[i].bGetItem = FALSE;
    }
    for(i = 0 ; i < _DIGMAP_WIDTH * _DIGMAP_HEIGHT; i++){
        _pCommFossilWork->depositMap[i / _DIGMAP_WIDTH][i % _DIGMAP_WIDTH] = 0;
        _pCommFossilWork->buildupMap[i / _DIGMAP_WIDTH][i % _DIGMAP_WIDTH] = 2;
    }
/*  p[eBNgpȂȂ܂
    _pCommFossilWork->ptc = NULL;
   */
}

//==============================================================================
/**
 * Ό@Ǘ̏
 * @param   pWork   ƃ[
 * @retval  none
 */
//==============================================================================

void CommFossilInitialize(void* pWork, FIELDSYS_WORK* pFSys)
{
    int i;
    if(_pCommFossilWork){
        return;
    }
    _pCommFossilWork = pWork;
    _pCommFossilWork->pFSys = pFSys;
    for(i = 0; i < _FOSSIL_NUM_MAX; i++){
        _pCommFossilWork->aFossilPoint[i].digCreatureNetID = INVALID_NETID;
        _pCommFossilWork->aFossilPoint[i].xpos = COMM_UG_INVALID_GRID;
        _pCommFossilWork->aFossilPoint[i].zpos = COMM_UG_INVALID_GRID;
    }
    _initializeDigGame();

    _pCommFossilWork->winIndex = -1;
    
    // ftHgŉΔzu
    {
        MATHRandContext32 sRand;
        CommRandSeedInitialize(&sRand);
        for(i = 0; i < _SETUP_NUM_MAX; i++){
            _setSetup(&sRand);
        }
    }

}

//==============================================================================
/**
 * Ό@̃[NTCY𓾂
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommFossilGetWorkSize(void)
{
    return sizeof(CommFossilWork);
}

//==============================================================================
/**
 * Ό@̃Zbg
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFossilReset(void)
{
}

//==============================================================================
/**
 * Ό@̕A
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFossilReboot(void)
{
}

//==============================================================================
/**
 * Ό@̏I
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommFossilFinalize(void)
{
    if(_pCommFossilWork){
        sys_FreeMemoryEz(_pCommFossilWork);
        _pCommFossilWork = NULL;
    }
}

//==============================================================================
/**
 * ΂̃`FbN̏
 * @param   netID   netID
 * @param   pTouch    ʒu
 * @retval  ΂TRUE
 */
//==============================================================================

BOOL CommFossilCheck(int netID, Grid* pTouch)
{
    FossilPoint* pFP = _searchFossilPoint(pTouch->xpos, pTouch->zpos);
    u8 data;
    data = netID;

    if((pFP != NULL) && (pFP->digCreatureNetID==INVALID_NETID)){
        if(CommPlayerFlagDigCheck(netID)){   // ̊
            return TRUE;
        }
        OHNO_PRINT("܂@ĂȂꍇ M𑗂\n");
        CommSendData_ServerSide(CF_FIND_FOSSIL, &data, 1);
        _pCommFossilWork->pEntryFossil[netID] = pFP;
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * ΂𖄂߂Ăꏊǂ
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static BOOL _isFillUpPoint(FIELDSYS_WORK* pFSys, int xpos, int zpos)
{
    if(GetHitAttr(pFSys, xpos, zpos)){
        if(!GetHitAttr(pFSys, xpos, zpos+1)){
            return TRUE;
        }
        if(!GetHitAttr(pFSys, xpos, zpos-1)){
            return TRUE;
        }
        if(!GetHitAttr(pFSys, xpos+1, zpos)){
            return TRUE;
        }
        if(!GetHitAttr(pFSys, xpos-1, zpos)){
            return TRUE;
        }
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * ΂PZbgzu
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _setSetup(MATHRandContext32* pRand)
{
    int digNum,i,try;
    u16 xpos,xpos2,xbase;
    u16 zpos,zpos2,zbase;
    FossilPoint* pFP;

    xbase = (GetWorldMapMatrixW(_pCommFossilWork->pFSys->World)-2)*BLOCK_GRID_W;
    zbase = (GetWorldMapMatrixH(_pCommFossilWork->pFSys->World)-2)*BLOCK_GRID_H;
    do{  // JĂꏊ
        xpos = MATH_Rand32(pRand, xbase)+BLOCK_GRID_W;
        zpos = MATH_Rand32(pRand, zbase)+BLOCK_GRID_H*2;
    } while(_isFillUpPoint(_pCommFossilWork->pFSys, xpos, zpos)==FALSE);

    digNum = MATH_Rand32(pRand, 6) + 6;  // ΂񖄂߂鐔
    for(i = 0; i < digNum; i++){
        for(try = 0 ; try < 100; try++){
            xpos2 = MATH_Rand32(pRand, 20) + xpos - 10;
            zpos2 = MATH_Rand32(pRand, 20) + zpos - 10;
            if(_isFillUpPoint(_pCommFossilWork->pFSys, xpos2, zpos2)){
                break;
            }
        }
        if(_isFillUpPoint(_pCommFossilWork->pFSys, xpos2, zpos2)==TRUE){
            pFP = _getFreeFossilPoint();
            if( pFP == NULL){
                break;
            }
            pFP->xpos = xpos2;
            pFP->zpos = zpos2;
#if PM_DEBUG
            {
                static int debugMagic=0;
                if(debugMagic==0){
                    pFP->xpos = 47;
                    pFP->zpos = 384;
                    debugMagic++;
                }
            }
#endif
            OS_TPrintf("Δzu܂ %d %d\n",pFP->xpos, pFP->zpos);
        }
    }
}

//--------------------------------------------------------------
/**
 * JĂ鉻΍\̃AhXԂ
 * @param    none
 * @retval   ΍\̃AhX
 */
//--------------------------------------------------------------

static FossilPoint* _getFreeFossilPoint(void)
{
    int i;

    for(i = 0; i < _FOSSIL_NUM_MAX; i++){
        if((_pCommFossilWork->aFossilPoint[i].xpos == COMM_UG_INVALID_GRID) &&
           (_pCommFossilWork->aFossilPoint[i].zpos == COMM_UG_INVALID_GRID)){
            return &_pCommFossilWork->aFossilPoint[i];
        }
    }
    return NULL;
}

//--------------------------------------------------------------
/**
 * ̏ꏊɂ鉻΍\̃AhXԂ
 * @param    none
 * @retval   ΍\̃AhX
 */
//--------------------------------------------------------------

static FossilPoint* _searchFossilPoint(u16 xpos, u16 zpos)
{
    int i;

    for(i = 0; i < _FOSSIL_NUM_MAX; i++){
        if((_pCommFossilWork->aFossilPoint[i].xpos == xpos) &&
           (_pCommFossilWork->aFossilPoint[i].zpos == zpos)){
            OHNO_PRINT("Δ %d %d\n",xpos, zpos);
            return &_pCommFossilWork->aFossilPoint[i];
        }
    }
    return NULL;
}

//==============================================================================
/**
 * ΔNCAgɕ\{@邩ǂ₢킹
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvFind(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;

    OHNO_PRINT("CommFossilRecvFind\n");
    if(pBuff[0] == CommGetCurrentID()){
        _pCommFossilWork->winIndex =
            CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                   msg_underworld_20, FALSE, NULL);
        TCB_Add(_yesnoMenuFunc, _pCommFossilWork, 0);

        // tB[h̓~߂
        FieldSystemProc_SeqHold();

    }
}

//==============================================================================
/**
 * @邩ǂ₢킹
 * @param   tcb  ^XN|C^
 * @param   work  [N|C^
 * @retval  none
 */
//==============================================================================

static void _yesnoMenuFunc(TCB_PTR tcb, void* work)
{
    if(_pCommFossilWork==NULL){
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        TCB_Delete(tcb);
        return;
    }

    if(_pCommFossilWork->winIndex != -1){
        if( GF_MSG_PrintEndCheck( _pCommFossilWork->winIndex ) == 0 ){
            // ͂EChEo
            _pCommFossilWork->pYesNoWork =
                BmpYesNoSelectInit( _pCommFossilWork->pFSys->bgl,
                                    &_yesNoBmpDat,
                                    MENU_WIN_CGX_NUM, MENU_WIN_PAL,
                                    HEAPID_FIELD );
            _pCommFossilWork->winIndex = -1;
        }
    }
    else{
        int ret = BmpYesNoSelectMain(_pCommFossilWork->pYesNoWork, HEAPID_FIELD);
        if(ret == BMPMENU_NULL){  // ܂I
            return;
        }else if(ret == 0){ // ͂Iꍇ
            FieldSystemProc_SeqHoldEnd();
            CommSendFixData(CF_DIG_FOSSIL_START_REQ);  // T[o[ɊmF
        }
        else{  // Iꍇ
            FieldSystemProc_SeqHoldEnd();
        }
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        TCB_Delete(tcb);
    }
}

//==============================================================================
/**
 * ΔNCAgɕ\{@邩ǂ₢킹
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvDigStartReq(int netID, int size, void* pData, void* pWork)
{
    FossilPoint* pFP =_pCommFossilWork->pEntryFossil[netID];
    u8 id = netID;
    
    if(pFP->digCreatureNetID == INVALID_NETID){
        pFP->digCreatureNetID = netID;  // @Jn
        CommSendData_ServerSide(CF_DIG_FOSSIL_START, &id, 1);
    }
}

//==============================================================================
/**
 * Δ@Jn
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvDigStart(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    
    if(pBuff[0] == CommGetCurrentID()){
        _digFossilEventStart(_pCommFossilWork->pFSys);
    }
}

//==============================================================================
/**
 * Δ@Iq瑗Ă
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvDigEndReq(int netID, int size, void* pData, void* pWork)
{
    FossilPoint* pFP =_pCommFossilWork->pEntryFossil[netID];
    u8 id = netID;

    if(pFP==NULL){
        return;
    }
    
    if(pFP->digCreatureNetID != INVALID_NETID){
        _pCommFossilWork->pEntryFossil[netID]=NULL;
        pFP->digCreatureNetID = INVALID_NETID;
#if _PICTTEST
#else
        pFP->xpos = COMM_UG_INVALID_GRID;
        pFP->zpos = COMM_UG_INVALID_GRID;
#endif
        CommSendData_ServerSide(CF_DIG_FOSSIL_END, &id, 1);
    }
}


//==============================================================================
/**
 * Δ@I
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvDigEnd(int netID, int size, void* pData, void* pWork)
{
}

//==============================================================================
/**
 * Δ@̈ʒuĂ
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvDigPos(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 returnBuff[3];
    int i;

    returnBuff[0] = netID;
    returnBuff[1] = pBuff[0];
    returnBuff[2] = pBuff[1];
    CommSendFixSizeData_ServerSide(CF_DIG_FOSSIL_POS_RETURN, returnBuff);
}

//==============================================================================
/**
 * Δ@̈ʒu𑗂R}h̃TCY
 * @param   none
 * @retval  pPbgTCY
 */
//==============================================================================

int CommFossilGetDigPosSize(void)
{
    return 2;
}

//==============================================================================
/**
 * Δ@̈ʒuq@ɑĂ
 * @param   netID    MĂID
 * @retval  none
 */
//==============================================================================

void CommFossilRecvDigPosReturn(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 returnBuff[3];
    int i;

    if(pBuff[0] == CommGetCurrentID()){
        return;  // g
    }

    _pCommFossilWork->friendDigPointX[pBuff[0]] = pBuff[1];
    _pCommFossilWork->friendDigPointZ[pBuff[0]] = pBuff[2];
}

//==============================================================================
/**
 * Δ@̈ʒue@瑗ꍇ̃R}h̃TCY
 * @param   none
 * @retval  pPbgTCY
 */
//==============================================================================

int CommFossilGetDigPosReturnSize(void)
{
    return 3;
}

//--------------------------------------------------------------------------------------------
/**
 * BGݒ
 *
 * @param	ini		BGLf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void _fossilBgSet( GF_BGL_INI * ini )
{
    //VRAMݒ
	{
		GF_BGL_DISPVRAM vramSetTable = {
			GX_VRAM_BG_128_A,				// C2DGWBG
			GX_VRAM_BGEXTPLTT_NONE,			// C2DGWBGgpbg
			GX_VRAM_SUB_BG_32_H,			// Tu2DGWBG
			GX_VRAM_SUB_BGEXTPLTT_NONE,		// Tu2DGWBGgpbg
			GX_VRAM_OBJ_64_E,				// C2DGWOBJ
			GX_VRAM_OBJEXTPLTT_NONE,		// C2DGWOBJgpbg
			GX_VRAM_SUB_OBJ_16_I,			// Tu2DGWOBJ
			GX_VRAM_SUB_OBJEXTPLTT_NONE,	// Tu2DGWOBJgpbg
			GX_VRAM_TEX_01_BC,				// eNX`C[WXbg
			GX_VRAM_TEXPLTT_01_FG			// eNX`pbgXbg
		};
		GF_Disp_SetBank( &vramSetTable );
	}
	{	// BG SYSTEM
		GF_BGL_SYS_HEADER BGsys_data = {
			GX_DISPMODE_GRAPHICS, GX_BGMODE_0, GX_BGMODE_0, GX_BG0_AS_2D,
		};
		GF_BGL_InitBG( &BGsys_data );
	}

    {	// BASE
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe000, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_MAP, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_MAP, 32, 0, HEAPID_DIGFOSSIL);
		GF_BGL_ScrClear( ini, FLD_MBGFRM_MAP );
	}

	{	// PARTS
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xe800, GX_BG_CHARBASE_0x04000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_EFFECT1, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_EFFECT1, 32, 0, HEAPID_DIGFOSSIL);
		GF_BGL_ScrClear( ini, FLD_MBGFRM_EFFECT1 );
	}
	{	// GROUND
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf000, GX_BG_CHARBASE_0x08000, GX_BG_EXTPLTT_23,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_EFFECT2, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_EFFECT2, 32, 0, HEAPID_DIGFOSSIL);
		GF_BGL_ScrClear( ini, FLD_MBGFRM_EFFECT2 );
	}
	{	// MAIN DISPibZ[Wj
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0xf800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_23,
			3, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( ini, FLD_MBGFRM_FONT, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_BGL_ClearCharSet( FLD_MBGFRM_FONT, 32, 0, HEAPID_DIGFOSSIL);
		GF_BGL_ScrClear( ini, FLD_MBGFRM_FONT );
	}

    
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_S, 32, 0, HEAPID_DIGFOSSIL );
	GF_BGL_ClearCharSet( GF_BGL_FRAME0_M, 32, 0, HEAPID_DIGFOSSIL);
}

//--------------------------------------------------------------
/**
 * @brief   eNX`VRAMAhXԂ߂̃R[obN֐
 *
 * @param   size		eNX`TCY
 * @param   is4x4comp	4x4keNX`ł邩ǂ̃tO(TRUE=keNX`)
 *
 * @retval  ǂݍ݂JnVRAM̃AhX
 */
//--------------------------------------------------------------
/*
static u32 sAllocTex(u32 size, BOOL is4x4comp)
{
	u32 address;
	NNSGfdTexKey key;
	
	key = NNS_GfdAllocTexVram(size, is4x4comp, 0);
	GF_ASSERT(key != NNS_GFD_ALLOC_ERROR_TEXKEY);
	
	address = NNS_GfdGetTexKeyAddr(key);
	OS_TPrintf("vram=%d\n", address);
	return address;
}
*/

//--------------------------------------------------------------
/**
 * @brief	eNX`pbgVRAMAhXԂ߂̃R[obN֐
 *
 * @param	size		eNX`TCY
 * @param	is4pltt		4Fpbgł邩ǂ̃tO
 *
 * @retval	ǂݍ݂JnVRAM̃AhX
 *
 * direct`̃eNX`̏ꍇASPL_LoadTexPlttByCallbackFunction
 * R[obN֐Ăяo܂B
 */
//--------------------------------------------------------------
/*
static u32 sAllocTexPalette(u32 size, BOOL is4pltt)
{
	NNSGfdPlttKey key;
	u32 address;
	
	key = NNS_GfdAllocPlttVram(size, is4pltt, NNS_GFD_ALLOC_FROM_LOW);
	if(key == NNS_GFD_ALLOC_ERROR_PLTTKEY){
		GF_ASSERT(0 && "p[eBNŃpbg̊mۂo܂I\n");
	}
	address = NNS_GfdGetPlttKeyAddr(key);
	OS_TPrintf("vram=%d\n", address);
	return address;
}
*/
//--------------------------------------------------------------
/**
 * @brief   퓬pp[eBNVXeEC֐(vZE`揈Ȃǂs)
 *
 * @param   ptc		p[eBNVXe[Nւ̃|C^
 */
//--------------------------------------------------------------
static int TestParticle_Main(void)
{
/*
	int draw_num;
	const MtxFx43 *camera_ptr;
    void* heap;

    GF_G3X_Reset();
	if(Particle_GetActionNum() == 0){
        return FALSE;
	}
	draw_num = Particle_DrawAll();	//p[eBN`
	Particle_CalcAll();	//p[eBNvZ
    GF_G3_RequestSwapBuffers(GX_SORTMODE_MANUAL, GX_BUFFERMODE_Z);

   */
	return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ėp֐FG~b^̐WŨ|P̍Wɐݒ肷
 * @param   emit		G~b^ւ̃|C^
 */
//--------------------------------------------------------------
static void _digPosSet(EMIT_PTR emit)
{
    static int posTest = 0;
    int x,y;

    x = _pCommFossilWork->particleX - 128;
    x *= 180;
    y = _pCommFossilWork->particleY - 96;
    y = -y;
    y *= 180;
    
    SPL_SetEmitterPositionX(emit, x);
	SPL_SetEmitterPositionY(emit, y);
	SPL_SetEmitterPositionZ(emit, 300);
    posTest+=100;
}

//--------------------------------------------------------------
/**
 * @brief   p[eBNJn
 * @param   none
 * @return  none
 */
//--------------------------------------------------------------
static void _particleStart(int x,int y)
{
/*  p[eBNgpȂȂ܂
    void* heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
		VecFx32 tmpVex;

    // particleJn
    Particle_CreateEmitterCallback(_pCommFossilWork->ptc, 0, _digPosSet, NULL);
   */
}

//--------------------------------------------------------------
/**
 * @brief   n}[animJn
 * @param   none
 * @return  none
 */
//--------------------------------------------------------------
static void _hammerStart(int x,int y, BOOL bPic)
{
    void* heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
    VecFx32 tmpVex;

    // animJn
    if(bPic){
        CLACT_AnmChg( _pCommFossilWork->clActWork[0], 1 );
    }
    else{
        CLACT_AnmChg( _pCommFossilWork->clActWork[0], 0 );
    }
    CLACT_SetAnmFlag(_pCommFossilWork->clActWork[0],1);
    tmpVex.x = FX32_ONE * (x - 18);
    tmpVex.y = FX32_ONE * (y + 18);
    CLACT_SetMatrix(_pCommFossilWork->clActWork[0], &tmpVex);

    CLACT_AnmChg( _pCommFossilWork->clActWork[_CLACT_HIT], 0 );
    CLACT_SetAnmFlag(_pCommFossilWork->clActWork[_CLACT_HIT],1);
    tmpVex.x = FX32_ONE * (x - 18);
    tmpVex.y = FX32_ONE * (y + 18);
    CLACT_SetMatrix(_pCommFossilWork->clActWork[_CLACT_HIT], &tmpVex);

}

//--------------------------------------------------------------
/**
 * Ό@t[̏
 * @param    GF_BGL_INI bglԍ
 * @retval   none
 */
//--------------------------------------------------------------

static void _commFossilGameInitialize1(FossilEventTask* pFET)
{
    int charByte;
    GF_BGL_INI* bgl;
    void* heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
    int i;

    _initializeDigGame(); 

    GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
    GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
    GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
    GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );

    sys_CreateHeap( HEAPID_BASE_APP, HEAPID_DIGFOSSIL, 0x50000 );

//    simple_3DBGInit(HEAPID_DIGFOSSIL);
    
	bgl = GF_BGL_BglIniAlloc( HEAPID_DIGFOSSIL );
    _pCommFossilWork->bgl = bgl;
 	//VuN֐Zbg
	sys_VBlankFuncChange(vBlankFunc, bgl);

    CommMsgSetBgl(CommUnderGetMsgUnderWorld(),bgl);
    _fossilBgSet(bgl);

    // n 32+108+1
    ArcUtil_PalSet( ARC_UG_FOSSIL_GRA, NARC_ug_fossil_kaseki_board_NCLR,
                    PALTYPE_MAIN_BG, 0, 32*3,  HEAPID_DIGFOSSIL);
    charByte = ArcUtil_BgCharSet( ARC_UG_FOSSIL_GRA, NARC_ug_fossil_kaseki_board_NCGR,
                                  bgl, GF_BGL_FRAME0_M, 0, 0, 0, HEAPID_DIGFOSSIL);
    ArcUtil_ScrnSet( ARC_UG_FOSSIL_GRA, NARC_ug_fossil_kaseki_board_NSCR,
                     bgl, GF_BGL_FRAME0_M, 0,
                     0,
                     0, HEAPID_DIGFOSSIL);
    ArcUtil_ScrnSet( ARC_UG_FOSSIL_GRA, NARC_ug_fossil_kaseki_board1_NSCR,
                     bgl, GF_BGL_FRAME1_M, 0,
                     0,
                     0, HEAPID_DIGFOSSIL);

    _randomDeposit(bgl,charByte,pFET);  // zu𗐐Ō߂
}

//--------------------------------------------------------------
/**
 * Ό@t[̏
 * @param    GF_BGL_INI bglԍ
 * @retval   none
 */
//--------------------------------------------------------------

static void _commFossilGameInitialize2(void)
{
    int charByte;
    GF_BGL_INI* bgl;
    void* heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
    int i;

    _touchButtonInitialize(_pCommFossilWork->bgl);
    GF_BGL_LoadScreenReq(_pCommFossilWork->bgl, GF_BGL_FRAME1_M);

    _randomBuildup(_pCommFossilWork->bgl);  // ͐ϕ𗐐Ō߂

    ArcUtil_PalSet( ARC_UG_PARTS_GRA, NARC_ug_parts_kaseki_board_wall_NCLR,
                    PALTYPE_MAIN_BG, 14*32, 32,  HEAPID_DIGFOSSIL);
    ArcUtil_BgCharSet( ARC_UG_PARTS_GRA, NARC_ug_parts_kaseki_board_wall_NCGR,
                       _pCommFossilWork->bgl, GF_BGL_FRAME2_M, 1, 0, 0, HEAPID_DIGFOSSIL);
    _buildupBGDraw(_pCommFossilWork->bgl);

    GF_BGL_PrioritySet(GF_BGL_FRAME0_M , 3);  //͂
    GF_BGL_PrioritySet(GF_BGL_FRAME1_M , 2);   //  ڂ
    GF_BGL_PrioritySet(GF_BGL_FRAME2_M , 1);   // 
    GF_BGL_PrioritySet(GF_BGL_FRAME3_M , 0);  // bZ[W

    _initCellActor();
    _setCellActor();
    _gaugeDisp(_pCommFossilWork->bgl);//Q[Wŏ\

}

//--------------------------------------------------------------
/**
 * Ό@t[̊J
 * @param    GF_BGL_INI bglԍ
 * @retval   none
 */
//--------------------------------------------------------------

static void _commFossilGameFinalize(void)
{
    void* heap;
    int i;

    GF_BGL_BGControlExit( _pCommFossilWork->bgl, GF_BGL_FRAME0_M );
    GF_BGL_BGControlExit( _pCommFossilWork->bgl, GF_BGL_FRAME1_M );
	GF_BGL_BGControlExit( _pCommFossilWork->bgl, GF_BGL_FRAME2_M );
	GF_BGL_BGControlExit( _pCommFossilWork->bgl, GF_BGL_FRAME3_M );
	// ZAN^[\[X

	// L]}l[W[j
	CLACT_U_CharManagerDelete(_pCommFossilWork->resObjTbl[0]);
	CLACT_U_CharManagerDelete(_pCommFossilWork->resObjTbl[4]);
	CLACT_U_CharManagerDelete(_pCommFossilWork->resObjTbl[8]);
	CLACT_U_CharManagerDelete(_pCommFossilWork->resObjTbl[12]);
	// pbg]}l[W[j
	CLACT_U_PlttManagerDelete(_pCommFossilWork->resObjTbl[1]);
	CLACT_U_PlttManagerDelete(_pCommFossilWork->resObjTbl[5]);
	CLACT_U_PlttManagerDelete(_pCommFossilWork->resObjTbl[9]);
	CLACT_U_PlttManagerDelete(_pCommFossilWork->resObjTbl[13]);
		
	// LEpbgEZEZAj̃\[X}l[W[j }`͖
	for(i=0;i < 4;i++){
		CLACT_U_ResManagerDelete(_pCommFossilWork->resMan[i]);
	}
	// ZAN^[Zbgj
	CLACT_DestSet(_pCommFossilWork->clactSet);

	//OAM_[j
	REND_OAM_Delete();

    DeleteCharManager();
	DeletePlttManager();

    sys_VBlankFuncChange(NULL, NULL);
    
    sys_FreeMemoryEz( _pCommFossilWork->bgl );
    _pCommFossilWork->bgl = NULL;
    sys_DeleteHeap(HEAPID_DIGFOSSIL);
    CommMsgSetBgl(CommUnderGetMsgUnderWorld(),_pCommFossilWork->pFSys->bgl);
}

//--------------------------------------------------------------
/**
 * Ό@Cxg SEQ
 * @param    GMEVENT_CONTROL * event CxgRg[
 * @retval   ITRUE
 */
//--------------------------------------------------------------

typedef enum{
    _SEQ_START,
    _SEQ_RADAR_FADEOUT,
    _SEQ_FIELD_FADEOUT,
    _SEQ_GAME_INIT1,
    _SEQ_GAME_INIT2,
    _SEQ_GAME_FADE_IN,
    _SEQ_GAME_FADE_IN_WAIT,
    _SEQ_MESSAGE,
    _SEQ_MESSAGE_WAIT,
    _SEQ_GAME,
    _SEQ_KEY_WAIT,
    _SEQ_FAINALIZE,
    _SEQ_UG_REBOOT,
    _SEQ_UG_REBOOT_WAIT,
    _SEQ_END,

    
};



//static BOOL GMEVENT_DigFossil(GMEVENT_CONTROL * event)
static void GMEVENT_DigFossil(TCB_PTR tcb, void *work)
{
//    FossilEventTask* pFET = FieldEvent_GetSpecialWork(event);
//	FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    FossilEventTask* pFET = work;
    FIELDSYS_WORK * fsys = pFET->pFSys;

    switch (pFET->seq) {
      case _SEQ_START:
        UnderGround_RadarEnd(fsys->UnderGroundRadar);
        CommStateJumpUnderGround();   // ړꍇ̒ʐM֘A
		(pFET->seq) ++;
		break;
      case _SEQ_RADAR_FADEOUT:
		if (fsys->UnderGroundRadar == NULL){
            GameSystem_FinishFieldProc(fsys);
            pFET->fadeFlg=FALSE;
            WIPE_Start(WIPE_PATTERN_M,
                       WIPE_TYPE_FADEOUT,
                       WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK,COMM_BRIGHTNESS_SYNC,
                       1,HEAPID_COMMUNICATION,&(pFET->fadeFlg));
            (pFET->seq) ++;
        }
        break;
      case _SEQ_FIELD_FADEOUT:
        if(pFET->fadeFlg){
            if(!GameSystem_CheckFieldProcExists(fsys)){		// vbNChange
                (pFET->seq) ++;
            }
		}
		break;
      case _SEQ_GAME_INIT1:    // d̂ŕɕ
        _commFossilGameInitialize1(pFET);
        (pFET->seq) ++;
        break;
      case _SEQ_GAME_INIT2:
        _commFossilGameInitialize2();
        (pFET->seq) ++;
        break;
      case _SEQ_GAME_FADE_IN:
        pFET->fadeFlg = FALSE;
        WIPE_Start(WIPE_PATTERN_M,
                   WIPE_TYPE_FADEIN,
                   WIPE_TYPE_FADEIN, WIPE_FADE_BLACK,COMM_BRIGHTNESS_SYNC,
                   1,HEAPID_DIGFOSSIL,&(pFET->fadeFlg));
        GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
        GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
        GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
        GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_ON );
        (pFET->seq) ++;
        break;
      case _SEQ_GAME_FADE_IN_WAIT:
        if( pFET->fadeFlg ){
            (pFET->seq) ++;
        }
        break;
      case _SEQ_MESSAGE:
        CommMsgRegisterNumber1Index(CommUnderGetMsgUnderWorld(), 0, pFET->_PARTS_TREASURE_NUM);
        _pCommFossilWork->winIndex =
            CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                   msg_underworld_62, FALSE, NULL);
        pFET->timer = 0;
        (pFET->seq) ++;
        break;
      case _SEQ_MESSAGE_WAIT:
        pFET->timer++;
        if(pFET->timer  > 80){
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
            pFET->seq++;
        }
        break;
      case _SEQ_GAME:
#if PM_DEBUG
        if(sys.cont & PAD_BUTTON_B){
            GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
        }
        else{
            GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
        }
#endif
        // ΃Q[I҂
        if( !_gameProcess(pFET) ) {
//            return FALSE;
            return;
        }
        (pFET->seq) ++;
        break;
      case _SEQ_KEY_WAIT:
        // AL[orTouch҂
        if( GF_MSG_PrintEndCheck( _pCommFossilWork->winIndex ) == 0 ){
            if( sys.tp_trg || (sys.trg & PAD_BUTTON_A) ) {
                CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
                (pFET->seq) ++;
            }
        }
        break;
      case _SEQ_FAINALIZE:
        if(_fossilGetMessage(pFET)){
            (pFET->seq) --;
        }
        else{
            (pFET->seq) ++;
            _commFossilGameFinalize();
        }
        break;
      case _SEQ_UG_REBOOT:
        //tB[h}bvvZXA
        OHNO_PRINT("tB[h}bvvZXA\n");
        FieldEvent_Cmd_SetMapProc( fsys );
		(pFET->seq) ++;
        OHNO_PRINT("tB[h}bvvZXA\n");
		break;
      case _SEQ_UG_REBOOT_WAIT:
        //tB[h}bvvZXJn҂
        OHNO_PRINT("tB[h}bvvZXJn҂\n");
        if (FieldEvent_Cmd_WaitMapProcStart(fsys)) {
            (pFET->seq) ++;
			break;
		}
		break;
      case _SEQ_END:
        OHNO_PRINT("[_[Jn҂\n");
        CommStateJumpEndUnderGround(); // ړIꍇ̒ʐM֘A
        fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
		sys_FreeMemoryEz(pFET);
        CommSendFixData(CF_DIG_FOSSIL_END_REQ);  // ΖxIeɒʒm
        TCB_Delete(tcb);
        //		return TRUE;
	}
//	return FALSE;
}


//--------------------------------------------------------------
/**
 * Ό@CxgJn
 * @param    GF_BGL_INI bglԍ
 * @retval   none
 */
//--------------------------------------------------------------

static void _digFossilEventStart(FIELDSYS_WORK* pFSys)
{
    FossilEventTask* pFET;

    pFET = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(FossilEventTask));
    pFET->seq = 0;
    pFET->subseq = 0;
    pFET->fadeFlg = FALSE;
    pFET->pFSys = pFSys;

//    FieldEvent_Set(pFSys, GMEVENT_DigFossil, pFET);
    TCB_Add(GMEVENT_DigFossil, pFET,100);
}

static BOOL _isFreeDiposit(void)
{
    int i;

    for(i = 0; i < _PARTS_NUM_MAX; i++){
        if(_pCommFossilWork->aDeposit[i].pParts == NULL){
            return TRUE;
        }
    }
    return FALSE;
}


//--------------------------------------------------------------
/**
 * 󂫍\̂ɖ߂p[cf[^
 * @param    parts   p[c
 * @param    x  ׂʒu
 * @param    y  
 * @retval   肪ꍇTRUE  ꍇFALSE
 */
//--------------------------------------------------------------

static int _setDiposit(int partsIndex, int x, int y)
{
    int i;

    for(i = 0; i < _PARTS_NUM_MAX; i++){
        if(_pCommFossilWork->aDeposit[i].pParts == NULL){
            _pCommFossilWork->aDeposit[i].pParts = &_partsData[partsIndex];
            _pCommFossilWork->aDeposit[i].partsType = _partsData[partsIndex].partsType;
            _pCommFossilWork->aDeposit[i].x = x;
            _pCommFossilWork->aDeposit[i].y = y;
            _pCommFossilWork->aDeposit[i].bGetItem = FALSE;
            return i+1;
        }
    }
    GF_ASSERT(0 && "󂫊mFĂȂ");
    return 0;
}

//--------------------------------------------------------------
/**
 * 肪邩ǂ
 * @param    parts   p[c
 * @param    x  ׂʒu
 * @param    y  
 * @retval   肪ꍇTRUE  ꍇFALSE
 */
//--------------------------------------------------------------
static BOOL _isAttribute(FossilParts* pParts, int x, int y)
{
    u8* attr = pParts->attribute;

    if(attr==NULL){
        return TRUE;  // Sʂ̂
    }
    if(attr[ y * pParts->width + x] == 'o'){
        return FALSE;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * p[c𖄂߂idǂ֌WȂj
 * @param    partsIndex   ߂p[ce[uhmcdw
 * @param    x  X
 * @param    y  Y
 * @param    dir ㉺E ->  ]  
 * @retval   none
 */
//--------------------------------------------------------------

static BOOL _partsDeposit(int partsIndex, int x, int y)
{
    int i, j, xParts, yParts, idx;

    if(!_isFreeDiposit()){
        return FALSE;
    }

    xParts = _partsData[partsIndex].width / 2 + x;
    yParts = _partsData[partsIndex].height / 2 + y;


    if(xParts > _DIGMAP_WIDTH){  // ݂͂Ă܂
        return FALSE;
    }
    if(yParts > _DIGMAP_HEIGHT){  // ݂͂Ă܂
        return FALSE;
    }

    
    for(i = x; i < xParts; i++){
        for(j = y; j < yParts; j++){
            if(_isAttribute(&_partsData[partsIndex], (i - x) * 2, (j - y) * 2) ){
                if(_pCommFossilWork->depositMap[j][i]!=0){
                    return FALSE;
                }
            }
        }
    }
    idx = _setDiposit(partsIndex, x, y);
    for(i = x; i < xParts; i++){
        for(j = y; j < yParts; j++){
            // zul`o쐬
            if(_isAttribute(&_partsData[partsIndex], (i - x) * 2, (j - y) * 2) ){
                _pCommFossilWork->depositMap[j][i] = idx;
            }
        }
    }
    
    return TRUE;
}

//--------------------------------------------------------------
/**
 * 󕨂̏ovl
 * @param    none
 * @retval   󕨂̏ovl
 */
//--------------------------------------------------------------

static int _getTreasurePartsRandomMax(void)
{
    int i, treasureRand=0;

    for(i = 0; i < NELEMS(_partsData) ; i++){
        if(DIG_PARTS_NODIG1 == _partsData[i].partsType){
            break;
        }
        treasureRand += _partsData[i].random;
    }
    return treasureRand;
}

//--------------------------------------------------------------
/**
 * 󕨂̗ɂIo
 * @param    none
 * @retval   no
 */
//--------------------------------------------------------------

static int _getTreasurePartsRandom(int random)
{
    int i, treasureRand = random;

    for(i = 0; i < NELEMS(_partsData) ; i++){
        if(DIG_PARTS_NODIG1 == _partsData[i].partsType){
            break;
        }
        treasureRand -= _partsData[i].random;
        if(treasureRand <= 0){
            return i;
        }
    }
    GF_ASSERT(0 && "ɂ͂Ȃ͂ vC");
    return 0;
}

//--------------------------------------------------------------
/**
 * zuf[^قȂp[c̃f[^𓾂
 * @param    none
 * @retval   󕨂̏ovl
 */
//--------------------------------------------------------------

static int _getTreasurePartsNoDigNum(void)
{
    int i, j = 0;

    for(i = 0; i < NELEMS(_partsData) ; i++){
        if(_partsData[i].partsType >= DIG_PARTS_NODIG1){
            j++;
        }
    }
    return j;
}


#if _PICTTEST
//--------------------------------------------------------------
/**
 * ł邾p[c𖄂߂  G̊mFpfobO
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _randomDeposit(GF_BGL_INI* bgl, int charByte,FossilEventTask* pFET)
{
    MATHRandContext32 sRand;
    int i, treasureRand = _getTreasurePartsRandomMax();
    int rand, parts, x, y, limit=0, partsIndex;
    int noDigNum = _getTreasurePartsNoDigNum();
    static int dummy = 0;
    
    CommRandSeedInitialize(&sRand);

    pFET->_PARTS_TREASURE_NUM = _PARTS_TREASURE_NUM_MAX;
    for(i = dummy; i < dummy+_PARTS_TREASURE_NUM_MAX; ){
//        rand = MATH_Rand32(&sRand, treasureRand);  // ̉𖄂߂邩߂
        partsIndex = i;
        x = MATH_Rand32(&sRand, _DIGMAP_WIDTH);
        y = MATH_Rand32(&sRand, _DIGMAP_HEIGHT);
        if(_partsDeposit(partsIndex, x, y)){
            OHNO_PRINT("parts %d x=%d y=%d %d\n",partsIndex, x, y);
            i++;
        }
    }

    _depositBGInit(_PARTS_TREASURE_NUM_MAX, bgl, charByte, pFET);
    dummy+=_PARTS_TREASURE_NUM_MAX;
#if PM_DEBUG
    OHNO_PRINT("zuMAP \n");
    for(y = 0; y < _DIGMAP_HEIGHT; y++){
        for(x = 0; x < _DIGMAP_WIDTH ; x++){
            OHNO_PRINT("%2d ", _pCommFossilWork->depositMap[y][x]);
        }
        OHNO_PRINT(" \n");
    }
#endif
}
#else
//--------------------------------------------------------------
/**
 * ł邾p[c𖄂߂
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _randomDeposit(GF_BGL_INI* bgl, int charByte,FossilEventTask* pFET)
{
    MATHRandContext32 sRand;
    int i, treasureRand = _getTreasurePartsRandomMax();
    int rand, parts, x, y, limit=0, partsIndex;
    int noDigNum = _getTreasurePartsNoDigNum();
    
    CommRandSeedInitialize(&sRand);

    pFET->_PARTS_TREASURE_NUM = MATH_Rand32(&sRand, 3)+2;
    for(i = 0; i < pFET->_PARTS_TREASURE_NUM; ){
        rand = MATH_Rand32(&sRand, treasureRand);  // ̉𖄂߂邩߂
        partsIndex = _getTreasurePartsRandom(rand);
        x = MATH_Rand32(&sRand, _DIGMAP_WIDTH);
        y = MATH_Rand32(&sRand, _DIGMAP_HEIGHT);
        if(_partsDeposit(partsIndex, x, y)){
            OHNO_PRINT("parts %d x=%d y=%d %d\n",partsIndex, x, y);
            i++;
        }
    }
    for(limit = 0; limit < 100 ; limit++){
        partsIndex = MATH_Rand32(&sRand, noDigNum);  // זd΂𖄂߂
        partsIndex += NELEMS(_partsData) - noDigNum;
        x = MATH_Rand32(&sRand, _DIGMAP_WIDTH);
        y = MATH_Rand32(&sRand, _DIGMAP_HEIGHT);
        if(_partsDeposit(partsIndex, x, y)){
            OHNO_PRINT("parts %d x=%d y=%d %d\n",partsIndex, x, y);
            i++;
        }
        if(i > 12){
            break;
        }
    }
    _depositBGInit(i, bgl, charByte, pFET);

#if PM_DEBUG
    OHNO_PRINT("zuMAP \n");
    for(y = 0; y < _DIGMAP_HEIGHT; y++){
        for(x = 0; x < _DIGMAP_WIDTH ; x++){
            OHNO_PRINT("%2d ", _pCommFossilWork->depositMap[y][x]);
        }
        OHNO_PRINT(" \n");
    }
#endif
}
#endif

//--------------------------------------------------------------
/**
 * p[cɏ]L] + BG
 * @param    none
 * @retval   nextCharOffset
 */
//--------------------------------------------------------------
#define _PALLET_INDEX (3)

static int _depositBGInitParts(int idx, GF_BGL_INI* bgl, int charOffset,FossilEventTask* pFET)
{
    FossilPartsData* pFPD = &_pCommFossilWork->aDeposit[idx];
    u16* pScrAddr = GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME1_M );
    int xini = pFPD->x * 2;
    int yini = pFPD->y * 2;
    int xend = xini + pFPD->pParts->width;
    int yend = yini + pFPD->pParts->height;
    int y,x,scr,i=charOffset;
    u32 sendByte;
    int pidx = idx;

    if(idx >= pFET->_PARTS_TREASURE_NUM){   // d΂̐
        pidx = _PARTS_TREASURE_NUM_MAX;  // d΂̃pbgʒuɂȂ
    }
    ArcUtil_PalSet( ARC_UG_PARTS_GRA, pFPD->pParts->ncl, PALTYPE_MAIN_BG, (pidx + _PALLET_INDEX)*32, 32,  HEAPID_DIGFOSSIL);
    sendByte = ArcUtil_BgCharSet( ARC_UG_PARTS_GRA, pFPD->pParts->ncg, bgl,
                                  GF_BGL_FRAME1_M, charOffset, 0, 0, HEAPID_DIGFOSSIL);

    OHNO_PRINT("scr disp %d %d %d %d  %d \n",xini,yini,xend,yend,charOffset);

    for(y = yini; y < yend; y++){
        for(x = xini; x < xend; x++){
            i++;
            if(!_isAttribute( pFPD->pParts, x - xini, y - yini )){
                continue;
            }
            scr = x + ((y + 4) * 32);
            pScrAddr[scr] = ((pidx + _PALLET_INDEX)*0x1000) + i - 1;
        }
    }
    return sendByte;
}

//--------------------------------------------------------------
/**
 * p[cɏ]L] + BG
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _depositBGInit(int partsMax, GF_BGL_INI* bgl, int charByte, FossilEventTask* pFET)
{
    int i,charOffset = 512 + 24*3 + 32 + 1; //1 + charByte/32;
    u32 sendByte;

    for(i = 0 ; i < partsMax; i++){
        sendByte = _depositBGInitParts(i, bgl , charOffset, pFET);
        charOffset += sendByte/32;
    }
}

//--------------------------------------------------------------
/**
 * ͐ϕ𗐐Ō߂
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _randomBuildup(GF_BGL_INI* bgl)
{
    static const u8 B1MAX = 8;
    static const u8 B2MAX = 5;

    static u8 buildup1[B1MAX][B1MAX]={{0,0,4,4,4,4,0,0},{0,4,4,4,4,4,4,0},{4,4,4,4,4,4},{4,4,4,4,4,4},
        {4,4,4,4,4,4},{4,4,4,4,4,4},{0,4,4,4,4,4,4,0},{0,0,4,4,4,4,0,0}};
    static u8 buildup2[B2MAX][B2MAX]={{0,6,6,6,0},{6,6,6,6,6},{6,6,6,6,6},{6,6,6,6,6},{0,6,6,6,0}};
    MATHRandContext32 sRand;
    int rand, parts, x, y, xini, yini,i;
    BOOL bBuildup = TRUE;
    
    CommRandSeedInitialize(&sRand);
    for(i = 0; i < 10; i++){   // AyPOd˂
        xini = MATH_Rand32(&sRand, _DIGMAP_WIDTH+B1MAX)-B1MAX;
        yini = MATH_Rand32(&sRand, _DIGMAP_HEIGHT+B1MAX)-B2MAX;
        for(y = yini; y < yini+B1MAX; y++){
            if( (y >= _DIGMAP_HEIGHT) || (y < 0)){
                continue;
            }
            for(x = xini; x < xini+B1MAX; x++){
                if( (x >= _DIGMAP_WIDTH)  || (x < 0)){
                    continue;
                }
                if(buildup1[y-yini][x-xini]==0){
                    continue;
                }
                 _pCommFossilWork->buildupMap[y][x]=buildup1[y-yini][x-xini];
            }
        }
    }
    for(i = 0; i < 15; i++){   // By15d˂
        xini = MATH_Rand32(&sRand, _DIGMAP_WIDTH+B2MAX)-B2MAX;
        yini = MATH_Rand32(&sRand, _DIGMAP_HEIGHT+B2MAX)-B2MAX;
        bBuildup = TRUE;
        for(y = yini; y < yini+B2MAX; y++){
            if( (y >= _DIGMAP_HEIGHT) || (y < 0)){
                continue;
            }
            for(x = xini; x < xini+B2MAX; x++){
                if( (x >= _DIGMAP_WIDTH)  || (x < 0)){
                    continue;
                }
                if(buildup1[y-yini][x-xini]==0){
                    continue;
                }
                if(_pCommFossilWork->buildupMap[y][x]<4){
                    bBuildup = FALSE;
                    break;
                }
            }
            if(bBuildup == FALSE){
                break;
            }
        }
        if(!bBuildup){
            continue;
        }
        for(y = yini; y < yini+B2MAX; y++){
            if( (y >= _DIGMAP_HEIGHT) || (y < 0)){
                continue;
            }
            for(x = xini; x < xini+B2MAX; x++){
                if( (x >= _DIGMAP_WIDTH)  || (x < 0)){
                    continue;
                }
                if(buildup2[y-yini][x-xini]==0){
                    continue;
                }
                _pCommFossilWork->buildupMap[y][x]=buildup2[y-yini][x-xini];
            }
        }
    }


#if 1
    OHNO_PRINT("͐MAP \n");
    for(y = 0; y < _DIGMAP_HEIGHT; y++){
        for(x = 0; x < _DIGMAP_WIDTH ; x++){
            OHNO_PRINT("%2d ", _pCommFossilWork->buildupMap[y][x]);
        }
        OHNO_PRINT(" \n");
    }
#endif

}

//--------------------------------------------------------------
/**
 * y𐷂BG_O
 * @param    none
 * @retval   nextCharOffset
 */
//--------------------------------------------------------------

static void _buildupBGDraw(GF_BGL_INI* bgl)
{
    static u8 lv0[]={0xe,0xf,0x1e,0x1f};
    static u8 lv1[]={0xa,0xb,0x1a,0x1b};
    static u8 lv2[]={0x8,0x9,0x18,0x19};
    static u8 lv3[]={0x6,0x7,0x16,0x17};
    static u8 lv4[]={0x4,0x5,0x14,0x15};
    static u8 lv5[]={0x2,0x3,0x12,0x13};
    static u8 lv6[]={0x0,0x1,0x10,0x11};
    static u8* lvlTbl[]={lv0,lv1,lv2,lv3,lv4,lv5,lv6};
    u16* pScrAddr = GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME2_M );
    int y,x,scr;

    for(y = 0; y < _DIGMAP_HEIGHT; y++){
        for(x = 0; x < _DIGMAP_WIDTH ; x++){
            u8* pTbl = lvlTbl[_pCommFossilWork->buildupMap[y][x]];
            scr = x*2+((y*2+4)*32);
            pScrAddr[scr] =  pTbl[0]+0xe001;
            pScrAddr[scr+1] =  pTbl[1]+0xe001;
            pScrAddr[scr+32] =  pTbl[2]+0xe001;
            pScrAddr[scr+33] =  pTbl[3]+0xe001;
        }
    }
    GF_BGL_LoadScreenReq(bgl, GF_BGL_FRAME2_M);
}

//--------------------------------------------------------------
/**
 * d₩ǂH
 * @param    x,y   @ʒu
 * @retval   dTRUE
 */
//--------------------------------------------------------------

static BOOL _isHardStone(int x, int y)
{
    int idx = _pCommFossilWork->depositMap[y][x];
    if(idx==0){
        return FALSE;
    }
    if(_pCommFossilWork->aDeposit[idx-1].partsType >= DIG_PARTS_TREASURE_MAX){  //d
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * y@
 * @param    x,y   @ʒu
 * @param    bPic   @type
 * @retval   @RXg
 */
//--------------------------------------------------------------

static int _digWall(int x, int y,BOOL bPic)
{
    static s8 ham1X[]={1,-1,-1, 1};  // n}[@
    static s8 ham1Y[]={1,-1, 1,-1};
    static s8 picX[]={0,0,-1,1};   // n}[ȂQق
    static s8 picY[]={1,-1,0,0};
    int mapX,mapY,idx,i;

    // @MAPW֕ϊ
    mapX = x / 16;
    mapY = y / 16 - 2;

    if(mapX < 0){
        return 0;
    }
    if(mapX >= _DIGMAP_WIDTH){
        return 0;
    }
    if(mapY < 0){
        return 0;
    }
    if(mapY >= _DIGMAP_HEIGHT){
        return 0;
    }
    _hammerStart(x, y, bPic);
    if(_pCommFossilWork->buildupMap[mapY][mapX] != 0){
        _pCommFossilWork->buildupMap[mapY][mapX] -= 1;
    }
    if(_pCommFossilWork->buildupMap[mapY][mapX] != 0){
        _pCommFossilWork->buildupMap[mapY][mapX] -= 1;
    }

    if(_isHardStone(mapX, mapY) && (_pCommFossilWork->buildupMap[mapY][mapX]==0)){  //d΂̏ꍇ
        if(bPic){
            return _COST_DIG_PIC;
        }
        else{
            return _COST_DIG_HUMMER;
        }
    }
    _particleStart(x,y);
    if(!bPic){
        for(i = 0 ; i < 4; i++){
            int cy = mapY+ham1Y[i];
            int cx = mapX+ham1X[i];
            if((cy >= 0) && (cy < _DIGMAP_HEIGHT)){
                if((cx >= 0) && (cx < _DIGMAP_WIDTH)){
                    if(_pCommFossilWork->buildupMap[cy][cx] != 0){
                        _pCommFossilWork->buildupMap[cy][cx] -= 1;
                    }
                }
            }
        }
    }
    for(i = 0 ; i < 4; i++){
        int cy = mapY+picY[i];
        int cx = mapX+picX[i];
        if((cy >= 0) && (cy < _DIGMAP_HEIGHT)){
            if((cx >= 0) && (cx < _DIGMAP_WIDTH)){
                if(_pCommFossilWork->buildupMap[cy][cx] != 0){
                    _pCommFossilWork->buildupMap[cy][cx] -= 1;
                }
                if( !bPic ){
                    if(_pCommFossilWork->buildupMap[cy][cx] != 0){
                        _pCommFossilWork->buildupMap[cy][cx] -= 1;
                    }
                }
            }
        }
    }
    if(bPic){
        return _COST_DIG_PIC;
    }
    else{
        return _COST_DIG_HUMMER;
    }
}

//--------------------------------------------------------------
/**
 * w͈͂̃XN[^ꂽlő
 * @param    pScrTop    XN[̃|C^
 * @param    xIni,yIni,xEnd,yEnd  XN[̍W
 * @param    bPush  ̂̂
 * @retval   none
 */
//--------------------------------------------------------------

static void _scrDataChange(u16* pScrTop,_SCR_RECT* pRect,int changeNum, int plusNum)
{
    int scr,y,x,pos,i;

    for(y = pRect->lt_y, i = 0; y < pRect->rb_y; y++, i++){
        pos = plusNum * i + changeNum;
        for(x = pRect->lt_x; x < pRect->rb_x; x++){
            scr = x + (y * 32);
            pScrTop[scr] = (pScrTop[scr]&0xfc00) + pos;
            pos++;
        }
    }
}


//--------------------------------------------------------------
/**
 * Ẽ^b`pl{^
 * @param    none
 * @retval   nextCharOffset
 */
//--------------------------------------------------------------

static _SCR_RECT hummerPos[] ={ 0x1a,0x06,0x20,0x0e  };
static _SCR_RECT picPos[] ={ 0x1a,0x0f,0x20,0x17  };
static _SCR_RECT endPos[] ={ 0x1a,0x00,0x20,0x04  };


static void _touchButtonInitialize(GF_BGL_INI* bgl)
{
    u16* pScrAddr;

    _pCommFossilWork->touchButton = _HUMMER_BUTTON;
    _pCommFossilWork->bPic = FALSE;
    pScrAddr = GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME1_M );
    _scrDataChange(pScrAddr, hummerPos, 0x1e, 54);  // G
    // XN[ւ̓]͌ł܂Ƃ߂
}

static void _touchButtonProcess(GF_BGL_INI* bgl,int x, int y, int level)
{
    VecFx32 tmpVex;
    u8* pPos;
    u16* pScrAddr;

    if(level < _PUSH_START){
        return;
    }
    if(level == _PUSH_START){   // ꂽ͈ʒu{^ނ߂
        if((x > (0x1a*8+6)) &&  ((0x1f*8+4) > x)){
            if((y > (5*8+3)) && ((0xd*8+6) > y)){  //n}[
                _pCommFossilWork->touchButton = _HUMMER_BUTTON;
                _pCommFossilWork->bPic = FALSE;
            }
            if((y > (0xe*8+2)) && ((0x15*8+6) > y)){  //̂
                _pCommFossilWork->touchButton = _PIC_BUTTON;
                _pCommFossilWork->bPic = TRUE;
            }
            if((y > (6)) && ((0x3*8+6) > y)){  //
                _pCommFossilWork->touchButton = _END_BUTTON;
            }
        }
    }

    pScrAddr = GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME1_M );
    switch( _pCommFossilWork->touchButton ){
      case _HUMMER_BUTTON:
        if(_PUSH_START == level){
            _scrDataChange(pScrAddr, hummerPos, 0x18, 54);  // level1
            _scrDataChange(pScrAddr, picPos, 0x24, 54);  // ߂G
        }
        else if(_PUSH_START+1 == level){
            _scrDataChange(pScrAddr, hummerPos, 0x1e, 54);  // G
        }
        if(_PUSH_START == level){
            CLACT_AnmChg( _pCommFossilWork->clActWork[_CLACT_EFFECT], 0 );
            CLACT_SetAnmFlag(_pCommFossilWork->clActWork[_CLACT_EFFECT],1);
            tmpVex.x = FX32_ONE * (228);
            tmpVex.y = FX32_ONE * (82);
            CLACT_SetMatrix(_pCommFossilWork->clActWork[_CLACT_EFFECT], &tmpVex);
        }
        break;
      case _PIC_BUTTON:
        if(_PUSH_START == level){
            _scrDataChange(pScrAddr, hummerPos, 0x12, 54);  // ߂G
            _scrDataChange(pScrAddr, picPos, 0x2a, 54);  // G
        }
        else if(_PUSH_START+1 == level){
            _scrDataChange(pScrAddr, picPos, 0x30, 54);  // G
        }
        if(_PUSH_START == level){
            CLACT_AnmChg( _pCommFossilWork->clActWork[_CLACT_EFFECT], 0 );
            CLACT_SetAnmFlag(_pCommFossilWork->clActWork[_CLACT_EFFECT],1);
            tmpVex.x = FX32_ONE * (228);
            tmpVex.y = FX32_ONE * (154);
            CLACT_SetMatrix(_pCommFossilWork->clActWork[_CLACT_EFFECT], &tmpVex);
        }
        break;
      case _END_BUTTON:
        if(_PUSH_START == level){
            _scrDataChange(pScrAddr, endPos, 54*4+6, 54);  // G
            _scrDataChange(pScrAddr, hummerPos, 0x12, 54);  // ߂G
            _scrDataChange(pScrAddr, picPos, 0x24, 54);  // ߂G
        }
        else if(_PUSH_START+1 == level){
            _scrDataChange(pScrAddr, endPos, 54*4+12, 54);  // G
        }
        if(_PUSH_START == level){
            CLACT_AnmChg( _pCommFossilWork->clActWork[_CLACT_EFFECT], 1 );
            CLACT_SetAnmFlag(_pCommFossilWork->clActWork[_CLACT_EFFECT],1);
            tmpVex.x = FX32_ONE * (228);
            tmpVex.y = FX32_ONE * (34);
            CLACT_SetMatrix(_pCommFossilWork->clActWork[_CLACT_EFFECT], &tmpVex);
        }
        break;
    }
    GF_BGL_LoadScreenReq(bgl, GF_BGL_FRAME1_M);  // XN[ɍXV
}

//--------------------------------------------------------------
/**
 * ǌ@Q[W̕\
 * @param    none
 * @retval   nextCharOffset
 */
//--------------------------------------------------------------

static void _gaugeDisp(GF_BGL_INI* bgl)
{
    VecFx32 tmpVex;
    int gauge = _pCommFossilWork->digGauge;
    static int pri=0;

    gauge = gauge;
    tmpVex.x = FX32_ONE * (134 + gauge);
    tmpVex.y = FX32_ONE * (97);
    CLACT_BGPriorityChg( _pCommFossilWork->clActWork[_CLACT_HIBI], 3 );
    CLACT_SetMatrix(_pCommFossilWork->clActWork[_CLACT_HIBI], &tmpVex);
}

//--------------------------------------------------------------
/**
 * Fl̎`Ō@i߂
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _friendDig(void)
{
    BOOL bChange = FALSE;
    int i;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        if((_pCommFossilWork->friendDigPointX[i] != _DIGMAP_INVALID) &&
           (_pCommFossilWork->friendDigPointZ[i] != _DIGMAP_INVALID)){
            int x = CommPlayerGetGridX(CommGetCurrentID());
            int y = CommPlayerGetGridZ(CommGetCurrentID());
            if((CommPlayerGetGridX(i) > (x - _FRIEND_DIG_AREA)) && (CommPlayerGetGridX(i) < (x + _FRIEND_DIG_AREA))){
                if((CommPlayerGetGridZ(i) > (y - _FRIEND_DIG_AREA)) && (CommPlayerGetGridZ(i) < (y + _FRIEND_DIG_AREA))){
                    _pCommFossilWork->particleX = _pCommFossilWork->friendDigPointX[i]*8;
                    _pCommFossilWork->particleY = _pCommFossilWork->friendDigPointZ[i]*8;
                    _digWall(_pCommFossilWork->friendDigPointX[i],
                             _pCommFossilWork->friendDigPointZ[i],TRUE);
                    bChange = TRUE;
                    _pCommFossilWork->friendDigPointX[i] = _DIGMAP_INVALID;
                    _pCommFossilWork->friendDigPointZ[i] = _DIGMAP_INVALID;
                }
            }
        }
    }
    if(bChange){
        _buildupBGDraw(_pCommFossilWork->bgl);
    }
}

//--------------------------------------------------------------
/**
 * @̂obOɓ
 * @param    type   @
 * @retval   none
 */
//--------------------------------------------------------------

static void _bagAddFossil(int no)
{
    MATHRandContext32 sRand;
    int carat;
    int stone = no;
    SB_RECORD_DATA* pRec = SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommFossilWork->pFSys));
    
    CommRandSeedInitialize(&sRand);
    if(CommDigIsStone(stone)){
        carat = MATH_Rand32(&sRand, 10);
        if((stone == DIG_PARTS_KONGOU_L) || (stone == DIG_PARTS_SIRATAMA_L) ||
           (stone == DIG_PARTS_RED_L) || (stone == DIG_PARTS_BLUE_L) || (stone == DIG_PARTS_GREEN_L)){
            stone = stone - DIG_PARTS_KONGOU_L + STONE_TYPE_DIAMOND;
            carat = carat * carat * carat;
            carat /= 200;
            carat += 9;
        }
        else if((stone == STONE_TYPE_DIAMOND) || (stone == STONE_TYPE_PEARL)){
            carat = carat * carat * carat;
            carat /= 200;
        }
        else if((stone == STONE_TYPE_RED) || (stone == STONE_TYPE_BLUE)){
            carat = carat * carat * carat;
            carat /= 100;
        }
        carat += 1;
        CommUnderBagAddStone(stone, carat);
        SecretBaseRecordSetStoneNum(pRec ,1);
    }
    else{
        CommUnderBagAddTreasure(stone);
        if((stone >= DIG_PARTS_TYPE_FOSSIL_MIN) && (DIG_PARTS_TYPE_FOSSIL_MAX > stone)){
            SecretBaseRecordSetFossilNum(pRec ,1);
        }
        else{
            SecretBaseRecordSetTreasureNum(pRec ,1); //@ƂăJEg
        }
    }
}

//--------------------------------------------------------------
/**
 * Δ@  bZ[W͕ʂɏKv
 * @param    none
 * @retval   SقꂽꍇTRUE
 */
//--------------------------------------------------------------

static BOOL _treasureCheck(FossilEventTask* pFET)
{
    int y,x,i;
    BOOL bTreasure[_PARTS_TREASURE_NUM_MAX];

    //depositMap1_PARTS_TREASURE_NUM܂ł
    // ̔ԍ̏ɑ͐ϕ@ĂȂ
    for(i = 0; i < pFET->_PARTS_TREASURE_NUM; i++){
        bTreasure[i] = TRUE;
    }
    for(y = 0; y < _DIGMAP_HEIGHT; y++){
        for(x = 0; x < _DIGMAP_WIDTH; x++){
            i = _pCommFossilWork->depositMap[ y ][ x ];
            if((i <= pFET->_PARTS_TREASURE_NUM) && (i != 0)){   // MAP  index+1 0͖ĂȂ
                if(_pCommFossilWork->buildupMap[ y ][ x ] != 0){
                    bTreasure[i-1] = FALSE;
                }
            }
        }
    }

    for(i = 0; i < pFET->_PARTS_TREASURE_NUM; i++){
        if(!bTreasure[i]){
            return FALSE;
        }
        else{
            // @ꂽ
            _pCommFossilWork->aDeposit[i].bGetItem = TRUE;
        }
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * ΐʕbZ[W
 * @param    none
 * @retval   bZ[WꍇFALSE
 */
//--------------------------------------------------------------

static BOOL _fossilGetMessage(FossilEventTask* pFET)
{
    int i;
    
    for(i = 0; i < pFET->_PARTS_TREASURE_NUM; i++){
        if(_pCommFossilWork->aDeposit[i].bGetItem == TRUE){
            CommMsgRegisterUGItemName(CommUnderGetMsgUnderWorld(),
                                      _pCommFossilWork->aDeposit[i].partsType);
            _pCommFossilWork->winIndex =
                CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                       UGGetTreasure,FALSE,NULL);
            // ΂ɓ
            _bagAddFossil(_pCommFossilWork->aDeposit[i].partsType);
            _pCommFossilWork->aDeposit[i].bGetItem = FALSE;
            return TRUE;
        }
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * ~jQ[̃vZX
 * @param    none
 * @retval   nextCharOffset
 */
//--------------------------------------------------------------

#define _SPEED_TEST_FOSSIL (0)

static BOOL _gameProcess(FossilEventTask* pFET)
{
    u8 posBuff[2];
    int cost;

#if _SPEED_TEST_FOSSIL
	OS_SetTick(0);
#endif
    if(_pCommFossilWork->touchPanelRelease == 1){
        _pCommFossilWork->touchPanelRelease = 0;
    }
    if(sys.tp_trg){
        if((sys.tp_x < 2*8*_DIGMAP_WIDTH) && (sys.tp_y >= 4*8)){
            _pCommFossilWork->particleX = sys.tp_x;
            _pCommFossilWork->particleY = sys.tp_y;
            posBuff[0] = sys.tp_x;
            posBuff[1] = sys.tp_y;
            cost = _digWall(sys.tp_x, sys.tp_y,_pCommFossilWork->bPic);
            CommSendFixSizeData(CF_DIG_FOSSIL_POS, posBuff);
            if(_pCommFossilWork->digGauge > cost){
                _pCommFossilWork->digGauge-=cost;
            }
            else{
                _pCommFossilWork->digGauge=0;
            }
            _buildupBGDraw(_pCommFossilWork->bgl);
            _gaugeDisp(_pCommFossilWork->bgl);
        }
        else if(sys.tp_x >= (2*8*_DIGMAP_WIDTH)){
            _pCommFossilWork->touchPanelRelease = 2;
        }
    }
    _touchButtonProcess(_pCommFossilWork->bgl,
                        sys.tp_x, sys.tp_y, _pCommFossilWork->touchPanelRelease);  // {^
    if(_pCommFossilWork->touchPanelRelease >= 2){
        _pCommFossilWork->touchPanelRelease++;
    }
    if(!sys.tp_cont){
        if(_pCommFossilWork->touchPanelRelease > 5){
            _pCommFossilWork->touchPanelRelease = 1;
            if(_pCommFossilWork->touchButton == _END_BUTTON){
                _pCommFossilWork->winIndex =
                    CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                           UGExitFossil,FALSE,NULL);
                return TRUE;
            }
        }
    }
    _friendDig();
    TestParticle_Main();
	CLACT_Draw( _pCommFossilWork->clactSet );									// ZAN^[풓֐
    if(_treasureCheck(pFET) || (_pCommFossilWork->digGauge == 0)){  // S@AQ[WȂ
        _pCommFossilWork->winIndex =
                CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                           UGFinishFossil,FALSE,NULL);
        return TRUE;
    }

#if _SPEED_TEST_FOSSIL
    {   //xؗp
        int result = OS_TicksToMicroSeconds(OS_GetTick());

        result = (100*result)/((16700 * ( 192+262 )) / 262);
        OS_TPrintf("MAINSTRESS = %d\n",result);
    }
#endif
    return FALSE;
}

static void _setResObjTbl(CLACT_U_RES_OBJ_PTR pRes)
{
    _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount] = pRes;
    _pCommFossilWork->resObjCount++;
}

//------------------------------------------------------------------
/**
 * n}pZAN^[
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------
#define _CLACT_OAMNUM  (5)

static void _initCellActor(void)
{
    int i;

    _pCommFossilWork->resObjCount = 0;
    // OAM}l[W[̏
	NNS_G2dInitOamManagerModule();
	// LOAM}l[W쐬
	// _pOAM}l[W쐬
	// ō쐬OAM}l[W݂ȂŋL
	REND_OAMInit( 
			0, 124,		// COAMǗ̈
			0, 31,		// CʃAtBǗ̈
			0, 124,		// TuOAMǗ̈
			0, 31,		// TuʃAtBǗ̈
			HEAPID_DIGFOSSIL);
/*	REND_OAMInit(
			0, 128,		// COAMǗ̈
			0, 32,		// CʃAtBǗ̈
			0, 128,		// TuOAMǗ̈
			0, 32,		// TuʃAtBǗ̈
			HEAPID_DIGFOSSIL); */
    char_pltt_manager_init();
	// ZAN^[
	_pCommFossilWork->clactSet = CLACT_U_SetEasyInit( 26, &_pCommFossilWork->renddata, HEAPID_DIGFOSSIL );

    CLACT_U_SetSubSurfaceMatrix( &_pCommFossilWork->renddata, SUB_SURFACE_X, SUB_SURFACE_Y*2 );
    
	//\[X}l[W[
	for(i = 0; i < 4; i++){		//\[X}l[W[쐬
		_pCommFossilWork->resMan[i] = CLACT_U_ResManagerInit(CLACT_OBJ_NUM, i, HEAPID_DIGFOSSIL);
	}
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcChar(_pCommFossilWork->resMan[CLACT_U_CHAR_RES], 
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hammer_NCGR,
                                        0, _CLACT_HUMMER, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_DIGFOSSIL));
	// Chara]
	CLACT_U_CharManagerSet( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcPltt(_pCommFossilWork->resMan[CLACT_U_PLTT_RES],
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hammer_NCLR,
                                        0, _CLACT_HUMMER, NNS_G2D_VRAM_TYPE_2DMAIN, 1, HEAPID_DIGFOSSIL));
	// pbg]
	CLACT_U_PlttManagerSetCleanArea( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
	_setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELL_RES],
                                            ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hammer_NCER,
                                            0, _CLACT_HUMMER, CLACT_U_CELL_RES,HEAPID_DIGFOSSIL));
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELLANM_RES],
                                            ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hammer_NANR,
                                            0, _CLACT_HUMMER, CLACT_U_CELLANM_RES,HEAPID_DIGFOSSIL));
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcChar(_pCommFossilWork->resMan[CLACT_U_CHAR_RES], 
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hibi_NCGR, 0, _CLACT_HIBI, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_DIGFOSSIL));
	// Chara]
	CLACT_U_CharManagerSet( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcPltt(_pCommFossilWork->resMan[CLACT_U_PLTT_RES],
                                        ARC_UG_FOSSIL_GRA, NARC_ug_fossil_kaseki_board_NCLR, 0, _CLACT_HIBI, NNS_G2D_VRAM_TYPE_2DMAIN, 3, HEAPID_DIGFOSSIL));
	// pbg]
	CLACT_U_PlttManagerSetCleanArea( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELL_RES],
							ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hibi_NCER, 0, _CLACT_HIBI, CLACT_U_CELL_RES,HEAPID_DIGFOSSIL));
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELLANM_RES],
                                            ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hibi_NANR, 0, _CLACT_HIBI, CLACT_U_CELLANM_RES,HEAPID_DIGFOSSIL));

    _setResObjTbl(
        CLACT_U_ResManagerResAddArcChar(_pCommFossilWork->resMan[CLACT_U_CHAR_RES],
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_effect_NCGR,
                                        0, _CLACT_EFFECT, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_DIGFOSSIL));
	// Chara]
	CLACT_U_CharManagerSet( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcPltt(_pCommFossilWork->resMan[CLACT_U_PLTT_RES],
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_effect_NCLR,
                                        0, _CLACT_EFFECT, NNS_G2D_VRAM_TYPE_2DMAIN, 1, HEAPID_DIGFOSSIL));
	// pbg]
	CLACT_U_PlttManagerSetCleanArea( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELL_RES],
							ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_effect_NCER, 0, _CLACT_EFFECT, CLACT_U_CELL_RES,HEAPID_DIGFOSSIL));
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELLANM_RES],
                                            ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_effect_NANR, 0, _CLACT_EFFECT, CLACT_U_CELLANM_RES,HEAPID_DIGFOSSIL));

    
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcChar(_pCommFossilWork->resMan[CLACT_U_CHAR_RES],
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hit_NCGR,
                                        0, _CLACT_HIT, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_DIGFOSSIL));
	// Chara]
	CLACT_U_CharManagerSet( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcPltt(_pCommFossilWork->resMan[CLACT_U_PLTT_RES],
                                        ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hit_NCLR,
                                        0, _CLACT_HIT, NNS_G2D_VRAM_TYPE_2DMAIN, 1, HEAPID_DIGFOSSIL));
	// pbg]
	CLACT_U_PlttManagerSetCleanArea( _pCommFossilWork->resObjTbl[_pCommFossilWork->resObjCount-1] );
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELL_RES],
							ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hit_NCER, 0, _CLACT_HIT, CLACT_U_CELL_RES,HEAPID_DIGFOSSIL));
    _setResObjTbl(
        CLACT_U_ResManagerResAddArcKindCell(_pCommFossilWork->resMan[CLACT_U_CELLANM_RES],
                                            ARC_UG_ANIM_GRA, NARC_ug_anim_kaseki_hit_NANR, 0, _CLACT_HIT, CLACT_U_CELLANM_RES,HEAPID_DIGFOSSIL));
}

//------------------------------------------------------------------
/**
 * ZAN^[o^
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------
static void _setCellActor(void)
{
	// ZAN^[wb_쐬
    int i;
    //o^i[
    CLACT_ADD add;

    for(i = 0; i < CLACT_OBJ_NUM;i++){
        CLACT_U_MakeHeader(&_pCommFossilWork->clActHeader_s[i],
                           i, i, i, i,
                           CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
                           0, 0,
                           _pCommFossilWork->resMan[CLACT_U_CHAR_RES],
                           _pCommFossilWork->resMan[CLACT_U_PLTT_RES],
                           _pCommFossilWork->resMan[CLACT_U_CELL_RES],
                           _pCommFossilWork->resMan[CLACT_U_CELLANM_RES],
                           NULL,NULL);
		add.ClActSet	= _pCommFossilWork->clactSet;
		add.ClActHeader	= &_pCommFossilWork->clActHeader_s[i];

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINASUBj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 0;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_DIGFOSSIL;

		//ZAN^[\Jn

		// ʗp
        add.mat.x = FX32_ONE * 0;
        add.mat.y = FX32_ONE * 240;
        _pCommFossilWork->clActWork[i] = CLACT_Add(&add);
        CLACT_SetAnmFlag(_pCommFossilWork->clActWork[i],1);
	}
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,  VISIBLE_ON);	//OBJʂnm
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
	
}

//** CharManager PlttManagerp **//
#define _CHAR_CONT_NUM				(20)
#define _CHAR_VRAMTRANS_MAIN_SIZE		(2048*2)
#define _CHAR_VRAMTRANS_SUB_SIZE		(2048*2)
#define _PLTT_CONT_NUM				(20)


//-------------------------------------
//
//	LN^}l[W[
//	pbg}l[W[̏
//
//=====================================
static void char_pltt_manager_init(void)
{
	// LN^}l[W[
	{
		CHAR_MANAGER_MAKE cm = {
			_CHAR_CONT_NUM,
			_CHAR_VRAMTRANS_MAIN_SIZE,
			_CHAR_VRAMTRANS_SUB_SIZE,
			HEAPID_DIGFOSSIL
		};
		InitCharManagerReg(&cm, GX_OBJVRAMMODE_CHAR_1D_128K, GX_OBJVRAMMODE_CHAR_1D_128K );
	}
    // pbg}l[W[
	InitPlttManager(_PLTT_CONT_NUM, HEAPID_DIGFOSSIL);

	// ǂݍ݊Jnʒu
	CharLoadStartAll();
	PlttLoadStartAll();
}

//------------------------------------------------------------------
/**
 * @brief	tB[hpVBLANK֐
 * @param	work
 */
//------------------------------------------------------------------
static void vBlankFunc(void * work)
{
	GF_BGL_INI * bgl = work;

	// BG
	GF_BGL_VBlankFunc( bgl );

	// Vram]}l[W[s
	DoVramTransferManager();

	// _LOAM}l[WVram]
	REND_OAMTrans();	
}


//------------------------------------------------------------------
/**
 * @brief	΂邩ǂׂ
 * @param   ׂWXW
   @param   ׂWZW
 * @retval  ǂ
 */
//------------------------------------------------------------------
BOOL UGFossileCheck(int x,int z)
{
    if(_searchFossilPoint(x,z)){
        return TRUE;
    }
    return FALSE;
}
