//=============================================================================
/**
 * @file	ug_dig_stone.c
 * @brief	ʂǗNX
 * @author	Katsumi Ohno
 * @date    2005.10.26
 */
//=============================================================================


#include <nitro/os.h>
#include "common.h"

#include "../fieldsys.h"
#include "communication/communication.h"
#include "../comm_field_state.h"
#include "ug_manager.h"

#include "../worldmap.h"
#include "../fieldobj.h"
#include "../fld_bmp.h"
#include "system/pm_str.h"
#include "system/fontproc.h"
#include "system/bmp_list.h"
#include "system/window.h"
#include "system/wordset.h"
#include "msgdata/msg_underworld.h"

#include "system/snd_tool.h"

#include "../d_ohno.h"  // fobOp



//==============================================================================
// `
//==============================================================================

#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY

#define _RESULT_CMD_SIZE (2) // f[^M̌ʂԂ̃f[^oCg
#define _TOUCH_OBJ_MAX (3)  //Touchɕ\㩂̌E
#define _STONE_NUM_SINGLE_MAX (UG_STONE_PLACE_NUM_MAX)   // l̐
#define _STONE_NUM_MAX (_STONE_NUM_SINGLE_MAX * COMM_MACHINE_MAX)      //  Ƃ肠US

// 肦ȂID
#define _INVALID_ID  (0xff)


typedef enum{
    _DIGGING_STATE_NONE,
    _DIGGING_STATE_DISCOVERY,
    _DIGGING_STATE_DIG,
    _DIGGING_STATE_DIGGING,
    _DIGGING_STATE_DIGEND,
    _DIGGING_STATE_BRINGOUT,
    _DIGGING_STATE_END

} _DigState_e;


enum _result_e {
    _RESULT_NONE,
    _RESULT_OK,
    _RESULT_NG
};

//==============================================================================
//	^錾
//==============================================================================

typedef struct{
    u16 xpos;   // ΂̈ʒu
    u16 zpos;
    u8 carat;   // 傫=Jbg 1-99
    u8 type;     // 
    u8 order;   // ߂  (񖄂߂ƌÂ̂ĂĂ܂)
} _Stone;

typedef struct{
    _Stone stone;
    u8 netID;
    u8 result;
} _StoneResult;

typedef struct{
    _Stone stone[_STONE_NUM_MAX];    // 
    _Stone myStone[_STONE_NUM_SINGLE_MAX];    // ߂Ă鎩̐΁iZ[u\j
    _Stone* pStoneTbl[_STONE_NUM_MAX]; // pe[u
    u8 recvCounter[COMM_MACHINE_MAX];
    u8 recvCounterBackup[COMM_MACHINE_MAX];
    u8 diggerType[COMM_MACHINE_MAX];
    FIELDSYS_WORK* pFSys;
    u8 sendNum;
    u8 result;
} CommDigWork;

// VOg
static CommDigWork* _pCommWork = NULL;

//==============================================================================
//	static錾
//==============================================================================

static _Stone* _getOldOrderData(_Stone* pStoneTbl);
static _Stone* _addStone(int x, int y, _Stone* pStoneTbl, int stoneType, int carat);
static Grid* _getStoneTblPos(Grid* pGrid, int index);
static void _delStone(_Stone* pStone);
static int _getLastOrder(_Stone* pStoneTbl);
static void _resetOrderNo(_Stone* pStoneTbl);
static void _myStoneDel(_Stone* pStone);
static void _myStoneAdd(_Stone* pStone);

//--------------------------------------------------------------
/**
 * @brief   bZ[W\ꍇ̏IR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _msgEndCallBack(int num)
{
    FieldSystemProc_SeqHoldEnd();
}

//==============================================================================
/**
 * ΖbZ[W̕\
 * @param   type   ΃^Cv
 * @param   message   GMMbZ[WID
 * @retval  none
 */
//==============================================================================

static void _digStoneStartMessage(int type, int message)
{
    FieldSystemProc_SeqHold();
    CommMsgRegisterUGItemName(CommUnderGetMsgUnderWorld(), type);
    CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                               message, TRUE, _msgEndCallBack);
}

//==============================================================================
/**
 * Ό@Ǘ̏
 * @param   pWork   ƃ[
 * @retval  none
 */
//==============================================================================

void CommDigStoneInitialize(void* pWork, FIELDSYS_WORK* pFSys)
{
    int i;
    UNDERGROUNDDATA* pUGData;

    if(_pCommWork){
        return;
    }
    _pCommWork = pWork;
    _pCommWork->pFSys = pFSys;
    pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pFSys));
    
    for(i = 0; i < _STONE_NUM_MAX; i++){
        _pCommWork->stone[i].type = STONE_TYPE_NONE;
        _pCommWork->pStoneTbl[i] = NULL;
    }

    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        _pCommWork->myStone[i].type = UnderGroundGetStoneGroundItemType(pUGData,i);
        _pCommWork->myStone[i].xpos = UnderGroundGetStoneGroundItemX(pUGData,i);
        _pCommWork->myStone[i].zpos = UnderGroundGetStoneGroundItemZ(pUGData,i);
        _pCommWork->myStone[i].carat = UnderGroundGetStoneGroundItemCarat(pUGData,i);
        _pCommWork->myStone[i].order = UnderGroundGetStoneGroundItemOrder(pUGData,i);
    }
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        _pCommWork->diggerType[i];
    }

}


//==============================================================================
/**
 * 㩂obNAbv
 * @param   pTrap    㩃f[^
 * @retval  none
 */
//==============================================================================

static void _myStoneBackup(void)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(_pCommWork->pFSys));
    int i;
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        UnderGroundAddStoneGroundItem( pUGData, _pCommWork->myStone[i].type,i,
                                      _pCommWork->myStone[i].xpos,
                                      _pCommWork->myStone[i].zpos,
                                      _pCommWork->myStone[i].order,
                                      _pCommWork->myStone[i].carat );
    }
}

//==============================================================================
/**
 * Ό@̃[NTCY𓾂
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommDigStoneManagerGetWorkSize(void)
{
    return sizeof(CommDigWork);
}

//==============================================================================
/**
 * Ό@̃Zbg
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommDigStoneManagerReset(void)
{
}

//==============================================================================
/**
 * Ό@̕A
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommDigStoneManagerReboot(void)
{
}

//==============================================================================
/**
 * Ό@̏I
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommDigStoneFinalize(void)
{
    if(_pCommWork){
        sys_FreeMemoryEz(_pCommWork);
        _pCommWork = NULL;
    }
}

//==============================================================================
/**
 * Ό@̖t[
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommDigStoneStep(void)
{

}



//==============================================================================
/**
 * e[uɂ΂̈ʒuԂ
 * @param   pGrid  Ԃʒu
 * @param   index  index
 * @retval  noneTCY
 */
//==============================================================================

static Grid* _getStoneTblPos(Grid* pGrid, int index)
{
    if(_pCommWork->pStoneTbl[index]==NULL){
        return NULL;
    }
    pGrid->xpos = _pCommWork->pStoneTbl[index]->xpos;
    pGrid->zpos = _pCommWork->pStoneTbl[index]->zpos;
    return pGrid;
}

//==============================================================================
/**
 * e[uɐ΂}
 * @param   pGrid  Ԃʒu
 * @param   index  index
 * @retval  noneTCY
 */
//==============================================================================

static void _insertStoneTbl(_Stone* pStone)
{
    int ins,i;
    Grid grid;

    grid.xpos = pStone->xpos;
    grid.zpos = pStone->zpos;
    CommUnderItemSearchInitialize(_STONE_NUM_MAX, _getStoneTblPos);
    ins = CommUnderSearchItemTbl(&grid);
    
    GF_ASSERT_RETURN(ins < (_STONE_NUM_MAX-1),);

    for(i = _STONE_NUM_MAX - 2; i >= ins;i--){
        _pCommWork->pStoneTbl[ i + 1] = _pCommWork->pStoneTbl[ i ];
    }
    
/*    memmove(&_pCommWork->pStoneTbl[ins+1],
            &_pCommWork->pStoneTbl[ins],
            (_STONE_NUM_MAX - ins - 1)*sizeof(u32));*/
    _pCommWork->pStoneTbl[ins] = pStone;

}

//==============================================================================
/**
 * e[u
 * @param   netID     ID
 * @retval  _Stone*
 */
//==============================================================================

static void _delStoneTbl(_Stone* pStone)
{
    int match;
    Grid grid;
    int i;
    
    grid.xpos = pStone->xpos;
    grid.zpos = pStone->zpos;
    CommUnderItemSearchInitialize(_STONE_NUM_MAX, _getStoneTblPos);
    match = CommUnderMatchItemTbl(&grid);


    GF_ASSERT_RETURN(match != -1,);

    for(i = match; i < _STONE_NUM_MAX-1; i++){
        _pCommWork->pStoneTbl[ i ] = _pCommWork->pStoneTbl[ i+1 ];
    }

//    memmove(&_pCommWork->pStoneTbl[match],
//            &_pCommWork->pStoneTbl[match+1],
//            (_STONE_NUM_MAX - match - 1)*sizeof(u32));
    _pCommWork->pStoneTbl[_STONE_NUM_MAX-1] = NULL;
}

//==============================================================================
/**
 * Ă΃obt@Ԃ
 * @param   netID     ID
 * @retval  _Stone*
 */
//==============================================================================

static _Stone* _getFreeStone( _Stone* pStoneTbl )
{
    int i;
    
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        if(pStoneTbl->type == STONE_TYPE_NONE){
            return pStoneTbl;
        }
        pStoneTbl++;
    }
    return NULL;
}

//==============================================================================
/**
 * Ă΂indexԂ
 * @param   netID     ID
 * @retval  _Stone*
 */
//==============================================================================

static int _getFreeStoneIndex( _Stone* pStoneTbl )
{
    int i;
    
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        if(pStoneTbl->type == STONE_TYPE_NONE){
            return i;
        }
        pStoneTbl++;
    }
    return 0;
}


//==============================================================================
/**
 * ΂ǉ
 * @param   x,y ʒu
 * @param   pTrapTbl   ǉe[u
 * @param   stoneType  ΂̃^Cv
 * @param   carat      Jbg
 * @retval  ǉ
 */
//==============================================================================

static _Stone* _addStone(int x, int y, _Stone* pStoneTbl, int stoneType, int carat)
{
    int index = 0;
    _Stone* pFreeStone;

    if(CommUnderCheckPlace(x, y)){  // Ȃɂꍇ
       // zułȂ
        return NULL;
    }
    pFreeStone = _getFreeStone(pStoneTbl);
    if(pFreeStone == NULL){  // ꍇ
        pFreeStone = _getOldOrderData(pStoneTbl);
        _delStone(pFreeStone);  // Â̂
        pFreeStone = _getFreeStone(pStoneTbl);
    }
    pFreeStone->xpos = x;
    pFreeStone->zpos = y;
    pFreeStone->type = stoneType;
    pFreeStone->carat = carat;
    _insertStoneTbl(pFreeStone);
    // Ԃ𖄂ߍ
    pFreeStone->order = _getLastOrder(pStoneTbl) + 1;
    _resetOrderNo(pStoneTbl);  // ԍUȂ
    
  //  OHNO_PRINT("㩐ݒu %d %d\n",x,y);
    return pFreeStone;
}

//==============================================================================
/**
 * ΂̏
 * @param   TrapInfo* pTrap 
 * @retval  none
 */
//==============================================================================

static void _delStone(_Stone* pStone)
{
    u32 baseAddr = (u32)&_pCommWork->stone[0];
    u32 nowStone = (u32)pStone;
    u32 stoneNo = (nowStone-baseAddr)/sizeof(_Stone);
    u32 id = stoneNo / _STONE_NUM_SINGLE_MAX;
    
    pStone->type = STONE_TYPE_NONE;
    pStone->order = 0;
    _delStoneTbl(pStone);
    _resetOrderNo(&_pCommWork->stone[id]);
}



//--------------------------------------------------------------
/**
 * ΂̐Ԃ̍Ō߂
 * @param    netID  @ԍ
 * @retval   ԍ
 */
//--------------------------------------------------------------
static int _getLastOrder(_Stone* pStoneTbl)
{
    int i,order;
    order = 0;
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        if(pStoneTbl->order > order){
            order = pStoneTbl->order;
        }
        pStoneTbl++;
    }
    return order;
}

//--------------------------------------------------------------
/**
 * ŏɐ΂𓾂
 * @param    netID  @ԍ
 * @retval   ԍ
 */
//--------------------------------------------------------------
static _Stone* _getOldOrderData(_Stone* pStoneTbl)
{
    int i,order;
    _Stone* pRetStone=NULL;
    order = _STONE_NUM_SINGLE_MAX;
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        if(pStoneTbl->order < order){
            pRetStone = pStoneTbl;
            order = pStoneTbl->order;
        }
        pStoneTbl++;
    }
    return pRetStone;
}

//--------------------------------------------------------------
/**
 * ԍUȂ
 * @param    netID  @ԍ
 * @retval   none
 */
//--------------------------------------------------------------
static void _resetOrderNo(_Stone* pStoneTbl)
{
    int i,base,order,j;
    _Stone* pOrderStone[_STONE_NUM_SINGLE_MAX];
    _Stone* pTT = pStoneTbl;

    // e[u
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        pOrderStone[i] = NULL;
    }
    // ̏ԂŐ
    for(i = 1; i <= _STONE_NUM_SINGLE_MAX; i++){
        for(j = 0; j < _STONE_NUM_SINGLE_MAX; j++){
            if(pTT->order == i){
                pOrderStone[i-1] = pTT;
                break;
            }
            pTT++;
        }
    }
    // ԍUȂ
    base = 1;
    for(i = 0; i < _STONE_NUM_SINGLE_MAX; i++){
        if(pOrderStone[i]!=NULL){
            pOrderStone[i]->order = base;
            base++;
        }
    }
  //  OHNO_PRINT("ԐUȂ\n");
}

//==============================================================================
/**
 *  ΂ǂԂ
 * @param   ׂWXW
   @param   ׂWZW
 * @retval  
 */
//==============================================================================

static _Stone* _checkStone(int x, int z)
{
    Grid grid;
    int ret;

    grid.xpos = x;
    grid.zpos = z;
    CommUnderItemSearchInitialize(_STONE_NUM_MAX, _getStoneTblPos);
    ret = CommUnderMatchItemTbl(&grid);

    if(-1 == ret){
        return NULL;
    }
    return _pCommWork->pStoneTbl[ret];
}

//==============================================================================
/**
 *  ΂EăNCAgɑM
 * @param   netID    MĂID
 * @param   pTouch      ʒu
 * @retval  ꍇTRUE 
 */
//==============================================================================

BOOL CommDigStoneCheck(int netID, Grid* pTouch)
{
    int x,z;
    _Stone* pStone;
    _StoneResult stoneResult;

    stoneResult.netID = netID;

    x = CommPlayerGetGridSXDirAdd(netID);
    z = CommPlayerGetGridSZDirAdd(netID);

    pStone = _checkStone(x, z);
    if(pStone){       // ΂E
        if(CommPlayerFlagDigCheck(netID)){   // ̊
            return TRUE;
        }
        MI_CpuCopy8(pStone, &stoneResult.stone, sizeof(_Stone));
        CommSendFixSizeData_ServerSide(CF_DIG_STONE_PICKUP, &stoneResult);
        _delStone(pStone);  //΂
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 *  ΂EƂENCAgɕ\ CF_DIG_STONE_PICKUP
 * @param   netID    MĂID
 * @param   x,y      ʒu
 * @retval  ꍇTRUE 
 */
//==============================================================================

void CommDigStoneRecvPickUp(int netID, int size, void* pData, void* pWork)
{
    _StoneResult* pResult = pData;

    if(pResult->netID == CommGetCurrentID()){
        GF_ASSERT_RETURN(pResult->stone.type != STONE_TYPE_NONE,);
        GF_ASSERT_RETURN(pResult->stone.type < STONE_TYPE_MAX,);
        _digStoneStartMessage(pResult->stone.type, UGBallGet);
        CommUnderBagAddStone(pResult->stone.type, pResult->stone.carat);  // {[obOɒǉ
        _myStoneDel(&pResult->stone);
        _myStoneBackup();
    }
}

//==============================================================================
/**
 * ɋ߂܂WĂ
 * @param   none
 * @retval  none
 */
//==============================================================================

void NearHexInitialize(NearHexWork* pWork, int maxDist)
{
    pWork->maxDist = maxDist;
    pWork->iterater = 0;
}

//==============================================================================
/**
 * ɋ߂܂WĂ
 * @param   none
 * @retval  none
 */
//==============================================================================

BOOL NearHexGetHex(NearHexWork* pWork, NearHex* pHex)
{
    int i, ite, x, y;

    ite = pWork->iterater;

    for(i = 0 ; i <= pWork->maxDist; i++){
        if((ite - (i*4)) > 0){
            ite = ite - (i*4);
        }
        else{
            if(ite!=0){
                ite--;
            }
            if(ite < (i*2)){
                y = i - ite;
            }
            else{
                y = ite - i*3;
            }
            if(ite < (i)){
                x = ite;
            }
            else if(ite < (i*3)){
                x = i*3 - (ite + i);
            }
            else{
                x = -i + (ite - i*3);
            }
            pHex->xpos = x;
            pHex->zpos = y;
//            OHNO_PRINT("%d x=%d y=%d\n",pWork->iterater,x,y);
            pWork->iterater++;
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * q@΂̃f[^
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommDigSendStoneData(void)
{
    int netID = CommGetCurrentID();
    // L[ɂ߂
    CommSetSendQueue(CF_DIG_STONE_DATA,
                     &_pCommWork->myStone[0],
                     (sizeof(_Stone) * _STONE_NUM_SINGLE_MAX));
}

//==============================================================================
/**
 * ΂̃f[^TCYԂ
 * @param   none
 * @retval  none
 */
//==============================================================================

int CommDigGetStoneDataSize(void)
{
    return (sizeof(_Stone) * _STONE_NUM_SINGLE_MAX);
}

//==============================================================================
/**
 * ΂̃f[^q@炨Ă
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommDigRecvStoneData(int netID, int size, void* pData, void* pWork)
{
    _Stone* pStone = &_pCommWork->stone[netID * _STONE_NUM_SINGLE_MAX];
    int i;
    GF_ASSERT_RETURN((size % sizeof(_Stone)) == 0,);
    GF_ASSERT_RETURN(size == (sizeof(_Stone) * _STONE_NUM_SINGLE_MAX),);
    // f[^M

    for(i = 0; i< _STONE_NUM_SINGLE_MAX; i++){  // Ă̂
        if(pStone->type != STONE_TYPE_NONE){
            _delStone(pStone);
            OHNO_PRINT("΃f[^\n");
        }
        pStone++;
    }
    pStone = pData;  // Vo^
    for(i = 0; i< _STONE_NUM_SINGLE_MAX; i++){
        if(pStone->type != STONE_TYPE_NONE){
            _addStone(pStone->xpos, pStone->zpos,
                      &_pCommWork->stone[netID * _STONE_NUM_SINGLE_MAX],
                      pStone->type,pStone->carat);
            OHNO_PRINT("΃f[^M %d %d\n",pStone->xpos, pStone->zpos);
        }
        pStone++;
    }

}

//==============================================================================
/**
 *  ʂ𖄂߂
 * @param   type      ^}
 * @param   carat     Jbg
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

void CommDigStoneAddStone( int type, int carat )
{
    _StoneResult stoneResult;

    stoneResult.stone.type = type;
    stoneResult.stone.carat = carat;
    CommSendFixSizeData(CF_BURY_STONE_DATA,&stoneResult);
}


//==============================================================================
/**
 *  ʊ֘ÃR}h̃TCY
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

int CommDigStoneDataResultSize(void)
{
    return sizeof(_StoneResult);
}


//==============================================================================
/**
 *  ʂ𖄂߂郁bZ[WM CF_BURY_STONE_DATA
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

void CommDigStoneRecvBuryData(int netID, int size, void* pData, void* pWork)
{
    _StoneResult* pRecv = pData;
    int x = CommPlayerGetGridXDirAdd(netID);
    int z = CommPlayerGetGridZDirAdd(netID);
    _StoneResult stoneResult;

    _Stone* pStone = _addStone(x, z,
                               &_pCommWork->stone[netID * _STONE_NUM_SINGLE_MAX],
                               pRecv->stone.type, pRecv->stone.carat);
    stoneResult.netID = netID;
    if(pStone){
        OHNO_PRINT("΃f[^쐬 %d %d\n",pStone->xpos, pStone->zpos);
        MI_CpuCopy8( pStone, &stoneResult.stone, sizeof(_Stone));
        stoneResult.result = _RESULT_OK;
    }
    else{
        stoneResult.result = _RESULT_NG;
    }
    CommSendData_ServerSide(CF_BURY_STONE_DATA_RESULT,
                            &stoneResult, sizeof(_StoneResult));
}


//==============================================================================
/**
 *  ʂ߂ꂽǂʂԂĂ CF_BURY_STONE_DATA_RESULT
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

void CommDigStoneRecvBuryDataResult(int netID, int size, void* pData, void* pWork)
{
    _StoneResult* pStoneResult = pData;
    int idx;

    if((pStoneResult->netID == CommGetCurrentID()) &&
       (pStoneResult->result == _RESULT_OK) ){
        _digStoneStartMessage(pStoneResult->stone.type, msg_underworld_58);
        CommUnderBagDeleteStone(pStoneResult->stone.type);
        _myStoneAdd(&pStoneResult->stone);
    }
}


//==============================================================================
/**
 * ̐΂
 * @param   pStone    ΃f[^
 * @retval  none
 */
//==============================================================================

static void _myStoneDel(_Stone* pStone)
{
    _Stone* pFreeStone;
    int index = -1,i;

    for(i = 0; i< _STONE_NUM_SINGLE_MAX; i++){
        pFreeStone = &_pCommWork->myStone[i];
        if((pStone->xpos == pFreeStone->xpos) && (pStone->zpos == pFreeStone->zpos)){
            index = i;
            break;
        }
    }
    GF_ASSERT_RETURN(index != -1,);
    pFreeStone->type = STONE_TYPE_NONE;
}

//==============================================================================
/**
 * ̐΂ǉ
 * @param   pStone
 * @retval  none
 */
//==============================================================================

static void _myStoneAdd(_Stone* pStone)
{
    _Stone* pFreeStone = _getFreeStone(_pCommWork->myStone);
    int index;

    if(pFreeStone==NULL){
        pFreeStone = _getOldOrderData(_pCommWork->myStone);
        _myStoneDel(pFreeStone);  // Â̂
    }
    index = _getFreeStoneIndex(_pCommWork->myStone);
    MI_CpuCopy8( pStone, pFreeStone, sizeof(_Stone));

    _myStoneBackup();
}



//==============================================================================
/**
 *  @Ă󋵃bZ[WԂ
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================
BOOL CommDigGetActionMessage(STRBUF* pStrBuf)
{
    return FALSE;
}

//==============================================================================
/**
 *  ^}ǂԂ
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================
BOOL CommDigIsStone(int type)
{
    if((type != STONE_TYPE_NONE) && (type <= DIG_PARTS_SIRATAMA_L)){
        return TRUE;
    }
    return FALSE;
}


//==============================================================================
/**
 *  ΂ǂԂ
 * @param   ׂWXW
   @param   ׂWZW
 * @retval  ǂ
 */
//==============================================================================

BOOL UgStoneCheck(int x, int z)
{
    if(_checkStone(x,z)){
        return TRUE;
    }
    return FALSE;
}
