//=============================================================================
/**
 * @file	ug_manager.c
 * @brief	n̒ʐM֘ÃvO܂Ƃ߂NX
 * @author	Katsumi Ohno
 * @date    2005.11.18
 */
//=============================================================================

#include <nitro/os.h>
#include "common.h"
#include "gflib/blact.h"
#include "../map_tool.h"
#include "../floor_touch.h"
#include "../comm_command_field.h"
#include "ug_manager.h"

#include "../fieldobj.h"
#include "../eventdata.h"

#include "communication/communication.h"
#include "system/gamedata.h"
#include "system/pm_str.h"
#include "system/snd_tool.h"
#include "msgdata/msg.naix"
#include "system/wordset.h"
#include "msgdata/msg_underworld.h"

//============================================================================================
//	vg^Cv錾
//============================================================================================
///..MsgSpeedGet, TalkWinNumGeẗׂɉXincludeȂ̂ ɏ
extern u8 MsgSpeedGet(void);
extern u8 TalkWinNumGet(void);

#include "../field_effect.h"	//DEBUG_BLACT_NEW_HOOK

//==============================================================================
// `
//==============================================================================
enum _result_e {
    _RESULT_NONE,
    _RESULT_OK,
    _RESULT_NG
};

#define _TOUCH_INTERVAL_DOWN_TIME (3)  // ^b`plԊu
#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY
#define _TOUCH_OBJ_MAX (8)


typedef struct{
    FIELDSYS_WORK* pFSys;
    UNDER_RECORD* pUnderRecord;
    Grid TouchScr;
    Grid Touch;
    u8 touchBuff1[_TOUCH_OBJ_MAX];
    u8 touchBuff2[_TOUCH_OBJ_MAX];
    PTRCommSearchFunc searchFunc;
    COMM_MESSAGE* pCommMsgUW;
    COMM_MESSAGE* pCommMsgFlag;
    COMM_MESSAGE* pCommMsgShop;
    COMM_MESSAGE* pCommMsgEdit;
    int searchLimit;
    u16 touchIntervalDownTimer;
    u8 touchSize1;
    u8 touchSize2;
    u8 bHalt;
} _commUnder;


typedef struct{
    u8 bOpen;
    u8 netID;
    u8 targetID;
} _ugMenuOpen;

static _commUnder* _pCommUnder = NULL;


//==============================================================================
/**
 * 
 * @param   pWork _commUnder[N|C^
 * @retval  none
 */
//==============================================================================

static void _initialize(_commUnder* pWork,FIELDSYS_WORK* pFSys)
{
    _pCommUnder = pWork;
    _pCommUnder->pFSys = pFSys;
    _pCommUnder->touchIntervalDownTimer = 0;
    _pCommUnder->Touch.xpos=0;
    _pCommUnder->Touch.zpos=0;
    _pCommUnder->bHalt=FALSE;

    _pCommUnder->pCommMsgUW =
        CommMsgInitialize(NARC_msg_underworld_dat, HEAPID_UNDERGROUND, pFSys->bgl,
                          MsgSpeedGet(), TalkWinNumGet());
    _pCommUnder->pCommMsgFlag =
        CommMsgInitialize(NARC_msg_uwflag_dat, HEAPID_UNDERGROUND, pFSys->bgl,
                          MsgSpeedGet(), TalkWinNumGet());
    _pCommUnder->pCommMsgShop =
        CommMsgInitialize(NARC_msg_uwbuy_dat, HEAPID_UNDERGROUND, pFSys->bgl,
                          MsgSpeedGet(), TalkWinNumGet());
    _pCommUnder->pCommMsgEdit =
        CommMsgInitialize(NARC_msg_uwedit_dat, HEAPID_UNDERGROUND, pFSys->bgl,
                          MsgSpeedGet(), TalkWinNumGet());
}

//==============================================================================
/**
 * @brief J
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _finalize(void)
{
    CommMsgFinalize(_pCommUnder->pCommMsgUW);
    CommMsgFinalize(_pCommUnder->pCommMsgFlag);
    CommMsgFinalize(_pCommUnder->pCommMsgShop);
    CommMsgFinalize(_pCommUnder->pCommMsgEdit);
    sys_FreeMemoryEz(_pCommUnder);
    _pCommUnder = NULL;
}

//==============================================================================
/**
 * @brief   nėpbZ[W|C^Ԃ
 * @param   none
 * @retval  none
 */
//==============================================================================

COMM_MESSAGE* CommUnderGetMsgUnderWorld(void)
{
    return _pCommUnder->pCommMsgUW;
}

//==============================================================================
/**
 * @brief   ntbObZ[W|C^Ԃ
 * @param   none
 * @retval  none
 */
//==============================================================================

COMM_MESSAGE* CommUnderGetMsgUnderFlag(void)
{
    return _pCommUnder->pCommMsgFlag;
}

//==============================================================================
/**
 * @brief   nShopbZ[W|C^Ԃ
 * @param   none
 * @retval  none
 */
//==============================================================================

COMM_MESSAGE* CommUnderGetMsgUnderShop(void)
{
    return _pCommUnder->pCommMsgShop;
}

//==============================================================================
/**
 * @brief   nEditbZ[W|C^Ԃ
 * @param   none
 * @retval  none
 */
//==============================================================================

COMM_MESSAGE* CommUnderGetMsgUnderEdit(void)
{
    return _pCommUnder->pCommMsgEdit;
}

//==============================================================================
/**
 *  nɓĂ󋵃bZ[WԂ
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

static BOOL _underGetEnterMessage(STRBUF* pStrBuf)
{
    int i;
    WORDSET* pWordSetMain;  //[hZbg\
    STRBUF* tmp_buf1;

    if(!_pCommUnder){
        return FALSE;
    }
    
    for(i = 0; i< COMM_MACHINE_MAX; i++){
        if(CommInfoIsNewName( i )){
            pWordSetMain = WORDSET_Create(HEAPID_FIELD);
            tmp_buf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
            WORDSET_RegisterPlayerName( pWordSetMain, TARGET_PLAYER_WORD_IDX, CommInfoGetMyStatus(i));
            MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderWorld()), UGEnter, tmp_buf1 );
            WORDSET_ExpandStr( pWordSetMain, pStrBuf, tmp_buf1 );
            CommInfoSetMessageEnd( i );
            STRBUF_Delete( tmp_buf1 );
            WORDSET_Delete(pWordSetMain);
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * ɉuĂ邩ǂ
 * @param   x
 * @param   y
 * @retval  uĂꍇTRUE
 */
//==============================================================================

BOOL CommUnderCheckPlace(int x,int z)
{
    Grid pos;

    pos.xpos = x;
    pos.zpos = z;
    
    if(GetHitAttr(_pCommUnder->pFSys,x,z)){  // 肪ꍇ
       // zułȂ
        return TRUE;
    }

    if(CommTrapCheck(x,z)){
        return TRUE;
    }
    // q~cnuĂ邩ǂ

    // ܂܂Ă邩ǂ
    // ܂Ă邩ǂ

    // p\R邩ǂ
    if(CommUnderPCCheck(&pos) != INVALID_NETID){
        return TRUE;
    }
    
    return FALSE;
}

//==============================================================================
/**
 * ^b`plŃ^b`ʒu𑗐M
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _touchSignalSend(void)
{
    VecFx32 vec;
    FIELD_OBJ_PTR fldobj;
    int xGrid,yGrid;
    Grid pos;

    // ^b`plM
    if(sys.tp_trg && (!_pCommUnder->touchIntervalDownTimer)){
        vec = FTouch_CalcTpXYTo3D(sys.tp_x, sys.tp_y, _pCommUnder->pFSys->TpTo3DPtr);
        GetGridXZ(vec.x, vec.z, &xGrid, &yGrid);
        pos.xpos = xGrid;
        pos.zpos = yGrid;
        OHNO_PRINT("Touch %d %d\n", xGrid, yGrid);
        _pCommUnder->TouchScr.xpos = sys.tp_x;
        _pCommUnder->TouchScr.zpos = sys.tp_y;
        _pCommUnder->Touch.xpos = xGrid;
        _pCommUnder->Touch.zpos = yGrid;
        CommSendData(CF_TOUCH_GROUND, &pos, sizeof(Grid));
        _pCommUnder->touchIntervalDownTimer = _TOUCH_INTERVAL_DOWN_TIME;
    }
    else if(_pCommUnder->touchIntervalDownTimer!=0){
        _pCommUnder->touchIntervalDownTimer--;
    }
}


//==============================================================================
/**
 *  ^b`f[^T[o[ɓ͂̂Ł@^b`f[^Ԃ
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

static void _ugTouchCheck(int netID, Grid* pTouch)
{
    u8 resultBuff[_TOUCH_OBJ_MAX+1];
    NearHexWork work;
    NearHex hex;
    int j=1;
    int x,z,xp,zp;
    
    resultBuff[0] = netID;  // ɑԂ
    x = pTouch->xpos - 6;
    z = pTouch->zpos - 6;
    NearHexInitialize(&work, 6);
    while(NearHexGetHex(&work, &hex)){
        xp = pTouch->xpos + hex.xpos;
        zp = pTouch->zpos + hex.zpos;
        if(CommTrapCheck(xp, zp) || UgStoneCheck(xp, zp)){
            resultBuff[j] = (xp - x) + (zp - z) * 16;
            if(j == _TOUCH_OBJ_MAX){
                j++;
                break;
            }
            j++;
        }
    }
    CommSendData_ServerSide(CF_TOUCH_RESULT1, resultBuff, j);
    j = 1;
    NearHexInitialize(&work, 6);
    while(NearHexGetHex(&work, &hex)){
        xp = pTouch->xpos + hex.xpos;
        zp = pTouch->zpos + hex.zpos;
        if(UGFossileCheck(xp, zp)){
            resultBuff[j] = (xp - x) + (zp - z) * 16;
            if(j == _TOUCH_OBJ_MAX){
                j++;
                break;
            }
            j++;
        }
    }
    CommSendData_ServerSide(CF_TOUCH_RESULT2, resultBuff, j);
}


//==============================================================================
/**
 *  ^b`f[^T[o[ɓ͂̂Ł@㩂Ԃ  CF_TOUCH_GROUND
   PUl̑MʂlĂRɂ܂
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvTouch(int netID, int size, void* pData, void* pWork)
{
    Grid* pTouch = pData;

    // @@OOMobt@ς̏ꍇreturn
    if(!CommPlayerGetMoveControl(netID)){
        // głɖZꍇB͕̎ԎԂȂ
        return;
    }

    _ugTouchCheck(netID, pTouch);
    

}

//==============================================================================
/**
 *  ^b`f[^͕\f[^󂯎
 * @param   none
 * @retval  TCY
 */
//==============================================================================

void UgManagerRecvTouchResult1(int netID, int size, void* pData, void* pWork)
{
    int i;
    u8* pBuff = pData;
    Grid grid;

    if(CommGetCurrentID() != pBuff[0]){
        return;   // قȂq@͎󂯎Ȃ
    }
    MI_CpuCopy8(&pBuff[1],_pCommUnder->touchBuff1,size-1);
    _pCommUnder->touchSize1 = size-1;
}


//==============================================================================
/**
 *  ^b`f[^͕\f[^󂯎
 * @param   none
 * @retval  TCY
 */
//==============================================================================

void UgManagerRecvTouchResult2(int netID, int size, void* pData, void* pWork)
{
    int i;
    u8* pBuff = pData;
    Grid grid;

    if(CommGetCurrentID() != pBuff[0]){
        return;   // قȂq@͎󂯎Ȃ
    }
    MI_CpuCopy8(&pBuff[1],_pCommUnder->touchBuff2,size-1);
    _pCommUnder->touchSize2 = size-1;

    UgTouchRadarStart(_pCommUnder->pFSys,
                      _pCommUnder->Touch.xpos,_pCommUnder->Touch.zpos,
                      _pCommUnder->TouchScr.xpos,_pCommUnder->TouchScr.zpos,
                      _pCommUnder->touchBuff1,_pCommUnder->touchSize1,
                      _pCommUnder->touchBuff2,_pCommUnder->touchSize2);
}

#define _UG_BLOCK_MAX (30)

//==============================================================================
/**
 * itemxz̑傫]
 * @param   x
 * @param   y
 * @retval  uĂꍇTRUE
 */
//==============================================================================

static int _itemXZ(Grid* pGrid)
{
    if(pGrid==NULL){
        return _UG_BLOCK_MAX * _UG_BLOCK_MAX * BLOCK_GRID_W * BLOCK_GRID_H;
    }
    return pGrid->zpos * _UG_BLOCK_MAX * BLOCK_GRID_W + pGrid->xpos;
}

//==============================================================================
/**
 * itemmach邩ǂ
 * @param   pGrid ʒu
 * @retval  uĂꍇindex
 */
//==============================================================================

int CommUnderMatchItemTbl(Grid* pGrid)
{
    int mid;
    int left = 0;
    int right = _pCommUnder->searchLimit-1;
    int xIndex = _itemXZ(pGrid);
    Grid grid;
    PTRCommSearchFunc func = _pCommUnder->searchFunc;

    while(left < right){
        mid = (left + right) / 2;
        if(_itemXZ(func(&grid, mid)) < xIndex){
            left = mid+1;
        }
        else{
            right = mid;
        }
    }
    if(_itemXZ(func(&grid, left)) == xIndex){
        return left;
    }
    return -1;
}


//==============================================================================
/**
 * e[uw̃ACe
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommUnderSearchItemTbl(Grid* pGrid)
{
    int mid;
    int left = 0;
    int right = _pCommUnder->searchLimit-2;
    int xIndex = _itemXZ(pGrid);
    PTRCommSearchFunc func = _pCommUnder->searchFunc;
    Grid grid;

    right++;
    while(left < right){
        mid = (left + right) / 2;
        if(_itemXZ(func(&grid, mid)) < xIndex){
            left = mid + 1;
        }
        else{
            right = mid;
        }
    }
    return left;
}

//==============================================================================
/**
 * ACeꍇ̏
 * @param   limit   e[ǔE
 * @param   pFunc   e[uɃANZX邽߂̊֐
 * @retval  none
 */
//==============================================================================

void CommUnderItemSearchInitialize(int limit, PTRCommSearchFunc pFunc)
{
    _pCommUnder->searchFunc = pFunc;
    _pCommUnder->searchLimit = limit;
}

//==============================================================================
/**
 * nNPC邩ǂ̌
 * @param   limit   e[ǔE
 * @param   pFunc   e[uɃANZX邽߂̊֐
 * @retval  none
 */
//==============================================================================

BOOL UgNPCHitCheck(int x,int z)
{
    int num,i;
    const FIELD_OBJ_H* pFObj;

    if(!_pCommUnder){
        return FALSE;
    }
    num = EventData_GetNpcCount(_pCommUnder->pFSys);
    pFObj = EventData_GetNpcData(_pCommUnder->pFSys);
    for(i = 0; i < num; i++){
        if((pFObj[i].gx == x) && (pFObj[i].gz == z)){
            return TRUE;
        }
    }
    return FALSE;
}


//--------------------------------------------------------------
/**
 * @brief   q@A{^ꂽ̃R[obN
 * @param   netID
 * @param   size
 * @param   pData
 * @param   pWork
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderRecvCheckAbutton(int netID, int size, void* pData, void* pWork)
{
    _ugMenuOpen menuOpen;
    Grid pos;
    int targetID;

    pos.xpos = CommPlayerGetGridSXDirAdd(netID);
    pos.zpos = CommPlayerGetGridSZDirAdd(netID);

    if(!CommPlayerGetMoveControl(netID)){
        // głɖZꍇB̎A{^̕ԎԂȂ
        return;
    }
    
    // ڂ̑OɃv[[邩ǂ
    targetID = CommPlayerIsAlive(pos.xpos, pos.zpos);
    if(targetID != COMM_INVALID_ID){
        if(CommSecretBaseIsTraveling(targetID)){ // ړ̑ɂ͎ołȂ
        }
        else if(CommPlayerFlagTalkCheck(netID, targetID)){ // ĂȂɂȂ
        }
        else if(CommPlayerIsTrapBind(targetID)){  // 㩂ɂĂꍇ
            CommTrapSendRelease(netID,targetID);  // R}hM
        }
        else if(!CommPlayerGetMoveControl(netID)){
            // głɖZꍇB͕̎ԎԂȂ
        }
        else if(!CommPlayerGetMoveControl(targetID)){
            menuOpen.bOpen = _RESULT_NG;
            menuOpen.targetID = targetID;
            menuOpen.netID = netID;
            CommSendData_ServerSide(CF_RESULT_UGMENU_OPEN, &menuOpen, sizeof(menuOpen));
        }
        else{  // bj[
            menuOpen.bOpen = _RESULT_OK;
            menuOpen.targetID = targetID;
            menuOpen.netID = netID;
            if(CommPlayerGetMoveControl(targetID)){
                CommPlayerSetMoveControl_Server(netID, FALSE);
                CommPlayerSetMoveControl_Server(targetID, FALSE);
                CommPlayerSetLook_Server(netID, targetID);
                CommSendData_ServerSide(CF_RESULT_UGMENU_OPEN, &menuOpen, sizeof(menuOpen));
            }
        }
        return;
    }
    // ߂Δ
    if(CommDigStoneCheck(netID, &pos)){
        return;
    }
    // 㩌 ڂ̑O㩂ꍇ
    if(CommTrapFrontTrapDefuse(netID, &pos)){
        return;
    }
    if(CommFossilCheck(netID, &pos)){  // Δ
        return;
    }
    if(CommUnderPCCheckAndMessage(netID, &pos)){  // p\ȒO
        return;
    }
    if(UgSecretBaseGoodsCheck(netID, &pos)){  // ڂ̑OɃObY
        return;
    }

}

//==============================================================================
/**
 * n֘AT[rX
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommUnderProcess(void)
{
    if(CommGetCurrentID() == COMM_PARENT_ID){
        CommInfoSendArray_ServerSide();  // q@₢킹info𑗐M
    }

    if(!_pCommUnder->bHalt){
        if(CommPlayerIsMyMoveControl()){
            _touchSignalSend();
        }
    }
    CommTrapInfoProcess();  // 㩂1/256ŕ\ׂ̏

    if(!_pCommUnder->bHalt){  //  HALTɂ͓삵Ȃ
        UgTrapProcess(_pCommUnder->pFSys->bgl);   // 㩂ꍇ̎s
    }
}

//==============================================================================
/**
 * n֘AT[rX̏
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommUnderOptionInitialize(FIELDSYS_WORK* pFSys)
{
    void* pWork;

    if(_pCommUnder==NULL){
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, sizeof(_commUnder));
        _initialize(pWork,pFSys);
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommPlayerGetWorkSize());
        CommPlayerManagerInitialize(pWork, pFSys);
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommTrapInfoGetWorkSize());
        CommTrapInfoInitialize(pWork, pFSys);
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommSecretBaseInfoGetWorkSize());
        CommSecretBaseInfoInitialize(pWork, pFSys);
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommDigStoneManagerGetWorkSize());
        CommDigStoneInitialize(pWork, pFSys);
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, CommFossilGetWorkSize());
        CommFossilInitialize(pWork, pFSys);
        pWork = sys_AllocMemory(HEAPID_COMMUNICATION, UnderRecordGetWorkSize());
        UnderRecordInitialize(pWork, SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(pFSys)));
        CommUnderBagInitialize(SaveData_GetUnderGroundData(GameSystem_GetSaveData(pFSys)));
    }
}


void CommUnderOptionReset(void)
{
    if(_pCommUnder){
        CommDigStoneManagerReset();
        CommSecretBaseInfoReset();
        CommTrapInfoReset();
        CommPlayerManagerReset();
        CommFossilReset();
        _pCommUnder->bHalt=TRUE;
    }
}

void CommUnderOptionReboot(void)
{
    if(_pCommUnder){
        CommDigStoneManagerReboot();
        CommSecretBaseInfoReboot();
        CommTrapInfoReboot();
        CommPlayerManagerReboot();
        CommFossilReboot();
        _pCommUnder->bHalt=FALSE;
//        CommPlayerSetMoveControl(TRUE);
        FieldSystemProc_SeqHoldEnd();
        
    }
}


void CommUnderOptionFinalize(void)
{
    if(_pCommUnder!=NULL){
        CommSecretBaseInfoFinalize();
        CommTrapInfoFinalize();
        CommPlayerManagerFinalize();
        CommDigStoneFinalize();
        CommFossilFinalize();
        CommUnderBagFinalize();
        UnderRecordFinalize();
        _finalize();
    }
}

//==============================================================================
/**
 * @brief   ANV֌W̃bZ[WoB oȂȂ
 * @param   pMessage    bZ[Wi[̈|C^
 * @retval  ȂFALSE
 */
//==============================================================================

BOOL CommUnderGetActionMessage(STRBUF* pStrBuf)
{
    if(_underGetEnterMessage(pStrBuf)){
        return TRUE;
    }
    else if(CommTrapGetActionMessage(pStrBuf)){
        return TRUE;
    }
    else if(CommTrapSetActionMessage(pStrBuf)){
        return TRUE;
    }
    else if(CommSecretBaseInfoGetActionMessage(pStrBuf)){
        return TRUE;
    }
    else if(CommDigGetActionMessage(pStrBuf)){
        return TRUE;
    }
    return FALSE;
}

#if PM_DEBUG
extern BOOL CommUnderIsDebugStop(void);
BOOL CommUnderIsDebugStop(void)
{
    if(_pCommUnder){
        return _pCommUnder->bHalt;
    }
    return FALSE;
}
#endif



//  nI[o[ĈŁ@@̃ANZX֐ɂ

//==============================================================================
/**
 * @brief   ZbgAbv閧nObYf[^Ԃ
 * @param   sv  SAVEDATA*
 * @retval  SECRETBASEDATA*
 */
//==============================================================================

SECRETBASEDATA* UgManUgSetupSecretBaseData(SAVEDATA * sv)
{
    if(!_pCommUnder){
        return NULL;
    }
    return UgSetupSecretBaseData(sv);
}

//==============================================================================
/**
 * @brief   ZbgAbv閧nXubNԂ
 * @param   none
 * @retval  XObh
 */
//==============================================================================

int UgManUgSetupSecretBaseBlockX(void)
{
    if(!_pCommUnder){
        return 0;
    }
    OHNO_SP_PRINT("UgSetupSecretBaseBlockX %d\n",UgSetupSecretBaseBlockX());
    return UgSetupSecretBaseBlockX();
}

//==============================================================================
/**
 * @brief   ZbgAbv閧nZubNԂ
 * @param   none
 * @retval  ZObh
 */
//==============================================================================

int UgManUgSetupSecretBaseBlockZ(void)
{
    if(!_pCommUnder){
        return 0;
    }
    OHNO_SP_PRINT("UgSetupSecretBaseBlockZ %d\n",UgSetupSecretBaseBlockZ());
    return UgSetupSecretBaseBlockZ();
}

//==============================================================================
/**
 * @brief   nĂ邩ǂ
 * @param   none
 * @retval  ĂTRUE
 */
//==============================================================================

BOOL UgManagerIsInitialize(void)
{
    return (_pCommUnder!=NULL);
}

//==============================================================================
/**
 * @brief   閧nWɂ邩ǂԂ
 * @param   x,z    ׂXZW
 * @retval  閧nɂꍇTRUE
 */
//==============================================================================

BOOL UgSecretBaseIsSecretBasePlace(int x, int z)
{
    if((RADAR_SCOPE_XS < x) && (RADAR_SCOPE_ZS < z) && (RADAR_SCOPE_XE > x) && (RADAR_SCOPE_ZE > z)){ 			//W擾łȂWƍXV
        return FALSE;
    }
    return TRUE;
}

//==============================================================================
/**
 * NɒnNPC_zu郋[`
 * @param   fsys  FIELDSYS_WORK
 * @retval  none
 */
//==============================================================================

void UgManagerShopNpcRandomPlace(FIELDSYS_WORK * fsys)
{
    int i,xpos,zpos;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(fsys));
    MATHRandContext16 rand;

    MATH_InitRand16(&rand, UnderGroundGetDayRandSeed(pUGData));
    for(i = 0;i < EventData_GetNpcCount(fsys); i++){
        xpos = MATH_Rand16(&rand, RADAR_SCOPE_XE);
        zpos = MATH_Rand16(&rand, RADAR_SCOPE_ZE);

        if(UgSecretBaseIsSecretBasePlace(xpos,zpos)){
            i--;
            continue;
        }
        if(GetHitAttr(fsys,xpos,zpos)){
            i--;
            continue;
        }
        EventData_NpcDataPosChange(fsys, i, xpos, zpos );
        OS_TPrintf("NPCzuW %d %d\n", xpos, zpos);
    }
}

