//=============================================================================
/**
 * @file	ug_manager.h
 * @brief	ñT[rX𓝊NX
             PU~PU݂Ȃ̂ŁA̕mۂĂ܂
 * @author	Katsumi Ohno
 * @date    2005.09.28  -> 2006.02.07 comm_under疼OύX
 */
//=============================================================================

#ifndef __UG_MANAGER_H__
#define __UG_MANAGER_H__

#include "communication/communication.h"
#include "system/msgdata.h"
#include "gflib/strbuf.h"
#include "../field_common.h"
#include "savedata/undergrounddata.h"  //SECRETBASEDATA

#define COMM_UG_INVALID_GRID     (0xffff)

typedef struct{
    u16 xpos;
    u16 zpos;
} Grid;

// R[obN֐̏
typedef Grid* (*PTRCommSearchFunc)(Grid* pGrid, int index);

extern COMM_MESSAGE* CommUnderGetMsgUnderWorld(void);
extern COMM_MESSAGE* CommUnderGetMsgUnderFlag(void);
extern COMM_MESSAGE* CommUnderGetMsgUnderShop(void);
extern COMM_MESSAGE* CommUnderGetMsgUnderEdit(void);

extern void CommUnderOptionInitialize(FIELDSYS_WORK* pFSys);
extern void CommUnderOptionReset(void);
extern void CommUnderOptionReboot(void);
extern BOOL CommUnderCheckPlace(int x,int y);
extern void CommUnderProcess(void);
extern void CommUnderItemSearchInitialize(int limit, PTRCommSearchFunc pFunc);
extern int CommUnderMatchItemTbl(Grid* pGrid);
extern int CommUnderSearchItemTbl(Grid* pGrid);
extern void CommUnderRecvCheckAbutton(int netID, int size, void* pData, void* pWork);
extern BOOL CommUnderGetActionMessage(STRBUF* pStrBuf);
extern void CommUnderOptionFinalize(void);
extern BOOL UgNPCHitCheck(int x,int z);
extern BOOL UgManagerIsInitialize(void);
extern void UgManagerShopNpcRandomPlace(FIELDSYS_WORK * fsys);
///閧n͈͓ɂ邩ǂ
extern BOOL UgSecretBaseIsSecretBasePlace(int x, int z);

#include "../comm_command_field.h"
#include "../comm_player.h"
#include "../comm_player_condition.h"
#include "ug_talk.h"
#include "ug_trap.h"
#include "ug_goods.h"
#include "ug_dig_stone.h"
#include "ug_dig_fossil.h"
#include "ug_secretbase.h"
#include "ug_bag.h"
#include "ug_pc.h"
#include "ug_record.h"

// ZbgAbv閧nObYf[^Ԃ
extern SECRETBASEDATA* UgManUgSetupSecretBaseData(SAVEDATA * sv);
//   ZbgAbv閧nXubNԂ
extern int UgManUgSetupSecretBaseBlockX(void);
//   ZbgAbv閧nZubNԂ
extern int UgManUgSetupSecretBaseBlockZ(void);

extern void UgManagerRecvTouchResult1(int netID, int size, void* pData, void* pWork);
extern void UgManagerRecvTouchResult2(int netID, int size, void* pData, void* pWork);


#endif //__UG_MANAGER_H__

