//=============================================================================
/**
 * @file	ug_pc.c
 * @brief	np\RǗNX
 * @author	k.ohno
 * @date    2006.02.02
 */
//=============================================================================

#include "common.h"
#include "../fieldsys.h"
#include "communication/communication.h"
#include "ug_manager.h"

#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/window.h"
#include "system/clact_tool.h"
#include "system/snd_tool.h"
#include "system/wipe.h"
#include "system/brightness.h"

#include "../fld_bmp.h"
#include "../field_clact.h"

#include "msgdata/msg_uwflag.h"
#include "msgdata/msg_uwpersonal.h"
#include "msgdata/msg.naix"

#include "../ug_base.h"
#include "ug_local.h"

typedef struct {
    u8 accessNetID;     // ANZX
    u8 targetPCNetID;   // ^[Qbgp\R
    u8 bFlagGet;      // Ƃ
} _resultAccessCommand;


typedef struct{
    int seq;
    int index;
    BOOL bFade;
    u8 netID;
}_EVENT_EDITRAP_WORK;


#define _DEF_ALONE_X (15)   // p\R̈ʒu
#define _DEF_X (15+32)   // p\R̈ʒu
#define _DEF_Z (12)    // p\R̈ʒu
#define _ADD_X (32)   // p\RIDɂړʒu
#define _ADD_Z (32)   // p\RIDɂړʒu

//==============================================================================
/**
 * p\R̃`FbN̏
 * @param   pTouch    ʒu
 * @retval  INVALID_NETID  netID
 */
//==============================================================================

int CommUnderPCCheck(Grid* pTouch)
{
    int i;
    int x = pTouch->xpos;
    int z = pTouch->zpos;
    int add = 0;

    if(z == _DEF_Z){
        add = 0;
    }
    else if(z == (_DEF_Z + _ADD_Z)){
        add = 8;
    }
    else{
        return INVALID_NETID;
    }
    if((x == _DEF_ALONE_X) || (x == (_DEF_ALONE_X+1))){
        return 0;
    }
    for(i = 0; i < COMM_MACHINE_MAX / 2; i++){
        if((x == _DEF_X) || (x == (_DEF_X+1))){
            return i + add;
        }
        x -= _ADD_X;
    }
    return INVALID_NETID;
}

//==============================================================================
/**
 * nԍp\RXlԂ
 * @param   nԍ
 * @retval  Xl
 */
//==============================================================================

int UgPCGetPosX(int roomNo)
{
    if(CommMPIsConnectStalth()){
        return _DEF_ALONE_X;
    }
    if(roomNo < COMM_MACHINE_MAX){
        return _DEF_X + (_ADD_X * (roomNo % 8));
    }
    return _DEF_ALONE_X;
}

//==============================================================================
/**
 * nԍp\RZlԂ
 * @param   nԍ
 * @retval  Zl
 */
//==============================================================================

int UgPCGetPosZ(int roomNo)
{
    if(roomNo < COMM_MACHINE_MAX){
        return _DEF_Z + (_ADD_Z * (roomNo / 8));
    }
    return _DEF_Z;
}

//==============================================================================
/**
 * p\R̃`FbN̏
 * @param   netID   netID
 * @param   pTouch    ʒu
 * @retval  p\ȒOTRUE
 */
//==============================================================================

BOOL CommUnderPCCheckAndMessage(int netID, Grid* pTouch)
{
    int i;
    int x = pTouch->xpos;
    int z = pTouch->zpos;
    _resultAccessCommand ret;
    int id = CommUnderPCCheck(pTouch);

    if(id != INVALID_NETID){
        ret.targetPCNetID = id;
        ret.accessNetID = netID;
        ret.bFlagGet = FALSE;
        if(id != netID){  //l̃p\R
            if(CommPlayerGetFlag(netID, id)){   // ƂĂ݂
                ret.bFlagGet = TRUE;            // ͂GET
            }
            else{
                // ͂łɎĂ
            }
        }
        else{  // ̃p\R
            if(CommPlayerIsFlagData(netID)){   // Ă΂
                u8 state = UNDER_FLAG_DELIVERY;  // A
                CommPlayerRecvFlagState(netID, 1,&state, NULL);
                return TRUE;
            }
            else{
            }
        }
        CommSendFixSizeData_ServerSide(CF_PC_ACCESS,&ret);
        return TRUE;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W\ꍇ̏IR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _msgEndCallBack(int num)
{
    FieldSystemProc_SeqHoldEnd();
}

//==============================================================================
/**
 * p\Rւ̃ANZX  CF_PC_ACCESS
 * @param   netID   netID
 * @param   pTouch    ʒu
 * @retval  p\ȒOTRUE
 */
//==============================================================================

void CommUnderPCRecvAccess(int netID, int size, void* pData, void* pWork)
{
    _resultAccessCommand* pRet = pData;
    FIELDSYS_WORK* pFSys = pWork;
    
    if(pRet->accessNetID == CommGetCurrentID()){  // ̏
        FieldSystemProc_SeqHold();
        if(pRet->targetPCNetID == CommGetCurrentID()){ // ̃}V
            UgPcMenuInit(pFSys);  // p\Rj[
        }
        else{  // l̃}V  -- flagGet
            if(pRet->bFlagGet){
                CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),mes_uw_flag_13,TRUE,_msgEndCallBack);
                Snd_BgmPlay( SEQ_HATANIGE );
            }
            else{
                CommMsgTalkWindowStart(CommUnderGetMsgUnderFlag(),mes_uw_flag_14,TRUE,_msgEndCallBack);
            }
        }
    }
    else{  // l̃ANZX
    }
    if(pRet->bFlagGet){
        // ƂlɊ
        CommPlayerGetFlag(pRet->accessNetID, pRet->targetPCNetID);
    }
}

//==============================================================================
/**
 * p\Rւ̃ANZXR}h̃TCY
 * @param   none
 * @retval  size
 */
//==============================================================================

int CommUnderPCGetAccessSize(void)
{
    return sizeof(_resultAccessCommand);
}



//-------------------------------------------p\R

//==============================================================================
/**
 * 莝ObYp\Rɓ
 * @param   index    ԖڂGOODS𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underBagGoodsSendPC(int index,_START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type;

    type = UnderGroundGetGoodsBagItem(pUGData, index);
    if(UnderGroundAddGoodsPCItem(pUGData, type)){
        UnderGroundDelGoodsBagItem(pUGData,index);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * p\R̃ObYobOɓ
 * @param   index    ԖڂGOODS𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underPcGoodsSendBag(int index,_START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type;

    type = UnderGroundGetGoodsPCItem(pUGData, index);
    if(  CommUnderBagAddGoods(type) ){
        UnderGroundDelGoodsPCItem(pUGData, index);  // 
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * 莝^}p\Rɓ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underBagStoneSendPC(int index,_START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type,carat;

   
    type =  UnderGroundGetStoneBagItem(pUGData, index);
    carat = UnderGroundGetStoneCaratBagItem(pUGData, index);
    if(UnderGroundAddStonePCItem(pUGData, type, carat)){
        UnderGroundDelStoneBagItem(pUGData, index);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * ς^}obOɓ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underPcStoneSendBag(int index,_START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type,carat;

    type = _underPcGetStoneType(index, pStart);
    carat = _underPcGetStoneCarat(index, pStart);
    if(CommUnderBagAddStone(type, carat)){
        UnderGroundDelStonePCItem(pUGData, index);
        return TRUE;
    }
    return FALSE;
}


//==============================================================================
/**
 * 莝p\Rɓ
 * @param   index    Ԗڂ̂܂𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underBagTreasureSendPC(int index,_START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type,carat;

    type = UnderGroundGetTreasureBagItem_List(pUGData, index);
    if(UnderGroundAddTreasurePCItem(pUGData, type)){
        UnderGroundDelTreasureBagItem(pUGData, index);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * p\R̂莝ɓ
 * @param   index    Ԗڂ̂炩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underPcTreasureSendBag(int index,_START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type;

    type = UnderGroundGetTreasurePCItem(pUGData, index);
    if(  CommUnderBagAddTreasure(type)  ){
        UnderGroundDelTreasurePCItem(pUGData, index);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * p\R㩂Ăɓ
 * @param   index    ԖڂTRAP𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underPcTrapSendBag(int index, _START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type;

    type = UnderGroundGetTrapPCItem(pUGData, index);
    if(  CommUnderBagAddTrap(type) ){
        UnderGroundDelTrapPCItem(pUGData,index);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * 莝㩂p\Rɓ
 * @param   index    ԖڂGOODS𓾂邩
 * @retval  TRUE
 */
//==============================================================================

static BOOL _underBagTrapSendPC(int index, _START_WORK* pStart)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pStart->pFSys));
    int type;

    type = UnderGroundGetTrapBagItem_List(pUGData, index);
    if(UnderGroundAddTrapPCItem(pUGData, type)){
        UnderGroundDelTrapBagItem(pUGData, index);
        return TRUE;
    }
    return FALSE;
}

//---------------------------------------------
enum{
    _PC_START,
    _PC_START_WAIT,
    _PC_END,
    _PC_REMODELING,
    _PC_REMODELING_FADE,
    _PC_REMODELING_END,
    _PC_SEND_START,
    _PC_SEND_WAIT,
    _PC_RECV_START,
    _PC_RECV_WAIT,
    _PC_FLAG_START,
    _PC_FLAG_WAIT,

    _PC_SEND_GOODS_START,
    _PC_SEND_GOODS_WAIT,
    _PC_SEND_GOODS_END,
    _PC_SEND_TREASURE_START,
    _PC_SEND_TREASURE_WAIT,
    _PC_SEND_TREASURE_END,
    _PC_SEND_STONE_START,
    _PC_SEND_STONE_WAIT,
    _PC_SEND_STONE_END,
    _PC_SEND_TRAP_START,
    _PC_SEND_TRAP_WAIT,
    _PC_SEND_TRAP_END,
    _PC_RECV_GOODS_START,
    _PC_RECV_GOODS_WAIT,
    _PC_RECV_GOODS_END,
    _PC_RECV_TREASURE_START,
    _PC_RECV_TREASURE_WAIT,
    _PC_RECV_TREASURE_END,
    _PC_RECV_STONE_START,
    _PC_RECV_STONE_WAIT,
    _PC_RECV_STONE_END,
    _PC_RECV_TRAP_START,
    _PC_RECV_TRAP_WAIT,
    _PC_RECV_TRAP_END,
    
} PcSeq_e;


static void _pcTopMenuLineSelect(BMPLIST_WORK * wk,u32 param,u8 mode)
{
    _START_WORK* pStart = (_START_WORK*)BmpListParamGet(wk, BMPLIST_ID_WORK);
    int idx = param;
    
    if(param == BMPLIST_CANCEL){
        idx = 4;
    }
    CommMsgTalkWindowAllWrite(CommUnderGetMsgUnderShop(),mes_uw_pers_042+idx,FALSE,NULL);
}

//--------------------------------------------------------------
/**
 * @brief   p\RCj[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcTopMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    switch(ret){
      case BMPLIST_NULL:
        return FALSE;
      case BMPLIST_CANCEL:
        pStart->seq = _PC_END;
        break;
      case 0:  // ͗lւ
        pStart->seq = _PC_REMODELING;
        break;
      case 1:  // [_[
        pStart->seq = _PC_FLAG_START;
        break;
      case 2:  // 
        pStart->seq = _PC_FLAG_START;
        break;
      case 3:  // a
        pStart->seq = _PC_SEND_START;
        break;
      case 4:  // o
        pStart->seq = _PC_RECV_START;
        break;
      default:
        break;
    }
    return TRUE;
}



//--------------------------------------------------------------
/**
 * @brief   p\Ra郁j[X^[g
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

#define _PCMAIN_MENU_POSX    (17)
#define _PCMAIN_MENU_POSY    (1)
#define _PCMAIN_MENU_SIZE_X  (14)

static void _pcMenuStart(_START_WORK* pStart,int msgNo,int count,BOOL bCallBack)
{
    BMPLIST_HEADER list_h;
    int line = count + 1;

    _startMenuEnd(pStart);
    //BMPEBhE
    pStart->menulist = BMP_MENULIST_Create( count+1, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pStart->pFSys->bgl,&pStart->win,
                     GF_BGL_FRAME3_M, _PCMAIN_MENU_POSX, _PCMAIN_MENU_POSY,
                     _PCMAIN_MENU_SIZE_X, line * 2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX - (10 * (line + 3) * 2));
    BmpMenuWinWrite(&pStart->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i=0;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_uwpersonal_dat, HEAPID_FIELD);
		for(i = 0; i < line ; i++)
		{
            if(i == count){
                BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
                                               msgNo+i, BMPLIST_CANCEL );
            }
            else{
                BMP_MENULIST_AddArchiveString( pStart->menulist, msgman,
                                               msgNo+i, i );
            }
		}
		MSGMAN_Delete(msgman);
	}

    MI_CpuCopy8( CommMsgGetNormalBmpListHeader(), &list_h, sizeof(BMPLIST_HEADER));
//    list_h = MenuListHeader;
    list_h.count = count + 1;
    list_h.line = line;
    list_h.list = pStart->menulist;
    list_h.win = &pStart->win;
    if(bCallBack){
        list_h.call_back = _pcTopMenuLineSelect;
    }
    list_h.work = pStart;
    pStart->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pStart->win);
}

//--------------------------------------------------------------
/**
 * @brief   a郁j[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcSendMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    switch(ret){
      case BMPLIST_NULL:
        return FALSE;
      case BMPLIST_CANCEL:
        pStart->seq = _PC_START;
        break;
      case 0:  // GOODS
        pStart->seq = _PC_SEND_GOODS_START;
        break;
      case 1:  //
        pStart->seq = _PC_SEND_TREASURE_START;
        break;
      case 2:  // 
        pStart->seq = _PC_SEND_STONE_START;
        break;
      case 3:  //
        pStart->seq = _PC_SEND_TRAP_START;
        break;
    default:
        pStart->seq = _PC_END;
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   oj[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcRecvMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret;

    ret = BmpListMain(pStart->lw);
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_START;
        break;
      case 0:  // GOODS
        pStart->seq = _PC_RECV_GOODS_START;
        break;
      case 1:  //
        pStart->seq = _PC_RECV_TREASURE_START;
        break;
      case 2:  // 
        pStart->seq = _PC_RECV_STONE_START;
        break;
      case 3:  //
        pStart->seq = _PC_RECV_TRAP_START;
        break;
    default:
        pStart->seq = _PC_END;
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ObYa郁j[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcSendGoodsMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_SEND_START;
        break;
    default:
        type = _underBagGetGoodsID(ret, pStart);  //ObYԍ
        if(_underBagGoodsSendPC(ret, pStart)){  // p\Rɓ
            CommMsgRegisterUGGoodsName(CommUnderGetMsgUnderShop(), type);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(),mes_uw_pers_44,FALSE,NULL);
        }
        else{
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(),mes_uw_pers_45,FALSE,NULL);
        }
        pStart->seq = _PC_SEND_GOODS_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ObY炤j[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcRecvGoodsMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_RECV_START;
        break;
    default:
        type = _underPcGetGoodsID(ret, pStart);  // ObYԍ
        if(_underPcGoodsSendBag(ret, pStart)){  // obOɓ
            CommMsgRegisterUGGoodsName(CommUnderGetMsgUnderShop(), type);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(),mes_uw_pers_43,FALSE,NULL);
        }
        else{
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(),mes_uw_pers_46,FALSE,NULL);
        }
        pStart->seq = _PC_RECV_GOODS_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ܂a郁j[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcSendStoneMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type,carat;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_SEND_START;
        break;
    default:
        type = _underBagGetStoneID(ret, pStart);  // ܔԍ
        carat = _underBagGetStoneCarat(ret, pStart);  // ^}̑傫
        if(_underBagStoneSendPC(ret, pStart)){  // p\Rɓ
            CommMsgRegisterUGItemName(CommUnderGetMsgUnderShop(), type);
            CommMsgRegisterNumber2(CommUnderGetMsgUnderShop(), carat);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_47, FALSE, NULL);
        }
        else{  // p\RɓȂꍇ
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_45, FALSE, NULL);
        }
        pStart->seq = _PC_SEND_STONE_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ܂oj[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcRecvStoneMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type,carat;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_RECV_START;
        break;
    default:
        type = _underPcGetStoneType(ret,pStart);  // ܔԍ
        carat = _underPcGetStoneCarat(ret,pStart);  // ^}̑傫
        if(_underPcStoneSendBag(ret, pStart)){  // obOɓ
            CommMsgRegisterUGItemName(CommUnderGetMsgUnderShop(), type);
            CommMsgRegisterNumber2(CommUnderGetMsgUnderShop(), carat);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_48, FALSE, NULL);
        }
        else{  // p\RɓȂꍇ
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_46, FALSE, NULL);
        }
        pStart->seq = _PC_RECV_STONE_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}







//--------------------------------------------------------------
/**
 * @brief   a郁j[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcSendTreasureMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type,carat;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_SEND_START;
        break;
    default:
        type = _underBagGetTreasureID(ret, pStart);  // ԍ
        if(_underBagTreasureSendPC(ret, pStart)){  // p\Rɓ
            CommMsgRegisterUGItemName(CommUnderGetMsgUnderShop(), type);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_44, FALSE, NULL);
        }
        else{  // p\RɓȂꍇ
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_45, FALSE, NULL);
        }
        pStart->seq = _PC_SEND_TREASURE_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   oj[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcRecvTreasureMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type,carat;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_RECV_START;
        break;
    default:
        type = _underPcGetTreasureType(ret, pStart);  // ԍ
        if(_underPcTreasureSendBag(ret, pStart)){  // obOɓ
            CommMsgRegisterUGItemName(CommUnderGetMsgUnderShop(), type);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_43, FALSE, NULL);
        }
        else{  // ΂ɓȂꍇ
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_46, FALSE, NULL);
        }
        pStart->seq = _PC_RECV_TREASURE_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   㩂a郁j[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcSendTrapMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_SEND_START;
        break;
    default:
        type = _underBagGetTrapID(ret, pStart);  // 㩔ԍ
        if(_underBagTrapSendPC(ret, pStart)){  // p\Rɓ
            CommMsgRegisterUGTrapNameIndex(CommUnderGetMsgUnderShop(), 2, type);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_44, FALSE, NULL);
        }
        else{  // p\RɓȂꍇ
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_45, FALSE, NULL);
        }
        pStart->seq = _PC_SEND_TRAP_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   㩂oj[
 * @param   tcb         ^XN
 * @param   work		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _pcRecvTrapMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pStart = work;
    u32	ret,type;

    ret = BmpListMain(pStart->lw);
    if(ret == _MENURETURN_EXIT){
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        pStart->seq = _PC_RECV_START;
        break;
    default:
        type = _underPcGetTrapType(ret, pStart);  // 㩔ԍ
        if(_underPcTrapSendBag(ret, pStart)){  // p\Rɓ
            CommMsgRegisterUGTrapNameIndex(CommUnderGetMsgUnderShop(), 2, type);
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_43, FALSE, NULL);
        }
        else{  // p\RɓȂꍇ
            pStart->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(), mes_uw_pers_46, FALSE, NULL);
        }
        pStart->seq = _PC_RECV_TRAP_END;
        _startMenuEnd(pStart);
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   bZ[WI{L[҂
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _msgEndWait(_START_WORK* pPc)
{
    if( GF_MSG_PrintEndCheck( pPc->msgIndex ) == 0 ){
        if(sys.trg & PAD_BUTTON_DECIDE){
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderShop());
            return TRUE;
        }
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   J閧nɂA܂͖߂
 * @param   bCenter		^=TRUE
 * @retval  none
 */
//--------------------------------------------------------------

static void _camMove(BOOL bCenter, FIELDSYS_WORK* pFSys)
{
    VecFx32 pos;

    pos.y = 0;
    pos.x = 15*FX32_ONE*16 - Player_NowGPosXGet( pFSys->player )*FX32_ONE*16;
    pos.z = 17*FX32_ONE*16 - Player_NowGPosZGet( pFSys->player )*FX32_ONE*16;
    if(!bCenter){
        pos.x = -pos.x;
        pos.z = -pos.z;
    }
    //Jƒ_𓯎ɕsړ
   GFC_ShiftCamera(&pos, pFSys->camera_ptr);
}



//--------------------------------------------------------------
/**
 * @brief   FIELDEDITĂяo߂̃bp[Cxg
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

typedef enum{
    _RAP_START,
    _REMODELING_FADE,
    _REMODELING_END,
    _BACK_EDIT,
    _BACK_EDIT_END,
    _RAP_END,
};

static BOOL _GMEVENT_EditRap(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    _EVENT_EDITRAP_WORK * mdw = FieldEvent_GetSpecialWork(event);
    LOCATION_WORK locationWork;
    u32 ret;
    BOOL bExit = FALSE;
    int msgNo;

    switch (mdw->seq) {
      case _RAP_START:
        WIPE_Start(WIPE_PATTERN_FSAM,
                   WIPE_TYPE_FADEOUT,
                   WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK,COMM_BRIGHTNESS_SYNC,
                   1,HEAPID_FIELD,&(mdw->bFade));
        mdw->seq = _REMODELING_FADE;
        break;
      case _REMODELING_FADE:
        if(mdw->bFade){
            Player_DispON_OFF_Set(fsys->player,FALSE);
            //Jړ
            _camMove(TRUE, fsys);
            WIPE_Start(WIPE_PATTERN_FMAS,
                       WIPE_TYPE_FADEIN,
                       WIPE_TYPE_FADEIN, WIPE_FADE_BLACK,COMM_BRIGHTNESS_SYNC,
                       1,HEAPID_FIELD,&(mdw->bFade));
            mdw->seq = _REMODELING_END;
        }
        break;
      case _REMODELING_END:
        UGBase_CallBaseEditEvent(fsys, event);
        mdw->seq = _BACK_EDIT;
        break;
      case _BACK_EDIT:
        WIPE_Start(WIPE_PATTERN_FSAM,
                   WIPE_TYPE_FADEOUT,
                   WIPE_TYPE_FADEOUT, WIPE_FADE_BLACK,COMM_BRIGHTNESS_SYNC,
                   1,HEAPID_FIELD,&(mdw->bFade));
        mdw->seq = _BACK_EDIT_END;
        break;
      case _BACK_EDIT_END:
        if(mdw->bFade){
            //Jړ
            Player_DispON_OFF_Set(fsys->player,TRUE);
            _camMove(FALSE, fsys);
            WIPE_Start(WIPE_PATTERN_FMAS,
                       WIPE_TYPE_FADEIN,
                       WIPE_TYPE_FADEIN, WIPE_FADE_BLACK,COMM_BRIGHTNESS_SYNC,
                       1,HEAPID_FIELD,&(mdw->bFade));
            mdw->seq = _RAP_END;
        }
        break;
      case _RAP_END:
        if(mdw->bFade){
            FieldSystemProc_SeqHoldEnd();
            return TRUE;
        }
        break;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief   EChE
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _delEnd(TCB_PTR tcb, _START_WORK* pStart)
{
    STRBUF_Delete(pStart->pStrBuf1);
    STRBUF_Delete(pStart->pStrBuf2);
    WORDSET_Delete(pStart->pWordSet);
    
    if(pStart->endfunc != NULL){
        pStart->endfunc(0);
    }

    _startMenuEnd(pStart);
    CommMsgTalkWindowEnd(CommUnderGetMsgUnderShop());
    TCB_Delete(tcb);
    sys_FreeMemoryEz(pStart);
}


//--------------------------------------------------------------
/**
 * @brief   GOODSj[
 * @param   pStart		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _pcMenuFunc(TCB_PTR tcb, void* work)
{
    _START_WORK* pPc = work;
    u32	ret;
    _EVENT_EDITRAP_WORK * mdw;

    switch(pPc->seq){
      case _PC_START:
        _pcMenuStart(work, mes_uw_pers_01,5,TRUE);
        pPc->seq = _PC_START_WAIT;
        break;
      case _PC_START_WAIT:
        _pcTopMenuFunc(tcb, work);
        break;
      case _PC_END:
        FieldSystemProc_SeqHoldEnd();
        _delEnd(tcb, pPc);
        break;
      case _PC_FLAG_START:
        _startMenuEnd(work);
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderShop());
        pPc->pWork = UgRecordFlagListStart(pPc->pFSys->bgl,
                              SaveData_GetMyStatus(GameSystem_GetSaveData(pPc->pFSys)),
                              SaveData_GetUnderGroundData(GameSystem_GetSaveData(pPc->pFSys)),
                              NULL,NULL);
        pPc->seq = _PC_FLAG_WAIT;
        break;
      case _PC_FLAG_WAIT:
        if(sys.trg & PAD_BUTTON_DECIDE){
            UgRecordFlagListEnd(pPc->pWork);
            pPc->seq = _PC_START;
        }
        break;
      case _PC_REMODELING:
        // I CxgɈp
        if(pPc->pFSys->event==NULL){
            mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_EDITRAP_WORK));
            mdw->seq = _RAP_START;
            mdw->index = 0;
            FieldEvent_Set(pPc->pFSys, _GMEVENT_EditRap, mdw);
        }
        _delEnd(tcb, pPc);
        break;
      case _PC_SEND_START:
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderShop());
        _pcMenuStart(work, mes_uw_pers_22,4,FALSE);
        pPc->seq = _PC_SEND_WAIT;
        break;
      case _PC_SEND_WAIT:
        _pcSendMenuFunc(tcb, work);
        break;
      case _PC_RECV_START:
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderShop());
        _pcMenuStart(work, mes_uw_pers_27,4,FALSE);
        pPc->seq = _PC_RECV_WAIT;
        break;
      case _PC_RECV_WAIT:
        _pcRecvMenuFunc(tcb, work);
        break;
      case _PC_SEND_GOODS_START:
        _goodsMenuStart_Bag(work);
        pPc->seq = _PC_SEND_GOODS_WAIT;
        break;
      case _PC_SEND_GOODS_WAIT:
        _pcSendGoodsMenuFunc(tcb, work);
        break;
      case _PC_SEND_GOODS_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_SEND_GOODS_START;
        }
        break;
      case _PC_SEND_TREASURE_START:
        _treasureMenuStart_Bag(pPc);
        pPc->seq = _PC_SEND_TREASURE_WAIT;
        break;
      case _PC_SEND_TREASURE_WAIT:
        _pcSendTreasureMenuFunc(tcb, work);
        break;
      case _PC_SEND_TREASURE_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_SEND_TREASURE_START;
        }
        break;
      case _PC_SEND_STONE_START:
        _stoneMenuStart_Bag(pPc);
        pPc->seq = _PC_SEND_STONE_WAIT;
        break;
      case _PC_SEND_STONE_WAIT:
        _pcSendStoneMenuFunc(tcb, work);
        break;
      case _PC_SEND_STONE_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_SEND_STONE_START;
        }
        break;
      case _PC_SEND_TRAP_START:
        _trapMenuStart_Bag(pPc);
        pPc->seq = _PC_SEND_TRAP_WAIT;
        break;
      case _PC_SEND_TRAP_WAIT:
        _pcSendTrapMenuFunc(tcb, work);
        break;
      case _PC_SEND_TRAP_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_SEND_TRAP_START;
        }
        break;
      case _PC_RECV_GOODS_START:
        _goodsMenuStart_Pc(work);
        pPc->seq = _PC_RECV_GOODS_WAIT;
        break;
      case _PC_RECV_GOODS_WAIT:
        _pcRecvGoodsMenuFunc(tcb, work);
        break;
      case _PC_RECV_GOODS_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_RECV_GOODS_START;
        }
        break;
      case _PC_RECV_TREASURE_START:
        _treasureMenuStart_Pc(work);
        pPc->seq = _PC_RECV_TREASURE_WAIT;
        break;
      case _PC_RECV_TREASURE_WAIT:
        _pcRecvTreasureMenuFunc(tcb, work);
        break;
      case _PC_RECV_TREASURE_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_RECV_TREASURE_START;
        }
        break;
      case _PC_RECV_STONE_START:
        _stoneMenuStart_Pc(work);
        pPc->seq = _PC_RECV_STONE_WAIT;
        break;
      case _PC_RECV_STONE_WAIT:
        _pcRecvStoneMenuFunc(tcb, work);
        break;
      case _PC_RECV_STONE_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_RECV_STONE_START;
        }
        break;
      case _PC_RECV_TRAP_START:
        _trapMenuStart_Pc(work);
        pPc->seq = _PC_RECV_TRAP_WAIT;
        break;
      case _PC_RECV_TRAP_WAIT:
        _pcRecvTrapMenuFunc(tcb, work);
        break;
      case _PC_RECV_TRAP_END:
        if( _msgEndWait( pPc ) ){
            pPc->seq = _PC_RECV_TRAP_START;
        }
        break;

    }
}

//--------------------------------------------------------------
/**
 * @brief   p\Rj[J
 * @param   FIELDSYS_WORK   tB[hVXe[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

void UgPcMenuInit(FIELDSYS_WORK* pFSys)
{
    BMPLIST_HEADER list_h;
    _START_WORK* pPc;
    const int LISTMAX = 6;  // Xg̍ő

    
    pPc = sys_AllocMemory(HEAPID_FIELD, sizeof(_START_WORK));
    MI_CpuFill8(pPc, 0, sizeof(_START_WORK));
    pPc->pFSys = pFSys;
    CommMsgChangeMSGMAN(CommUnderGetMsgUnderShop(),NARC_msg_uwpersonal_dat);
    pPc->seq = _PC_START;
    pPc->pStrBuf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pPc->pStrBuf2 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pPc->pWordSet = WORDSET_Create( HEAPID_FIELD );
    TCB_Add(_pcMenuFunc, pPc, _MENU_UG_PRI);
}

