//=============================================================================
/**
 * @file	ug_secretbase.c
 * @brief	n̔閧nǗNX
            ̔閧n
            T[o[pS̔閧n
            ̔閧n
            16+1=17
 * @author	Katsumi Ohno
 * @date    2005.10.03
 */
//=============================================================================


#include <nitro/os.h>
#include "common.h"
#include "gflib/blact.h"

#include "communication/communication.h"
#include "../fieldsys.h"

#include "../field_event.h"
#include "../fld_bmp.h"
#include "system/bmp_menu.h"
#include "../ev_mapchange.h"
#include "../mapdefine.h"
#include "../comm_field_state.h"
#include "ug_manager.h"
#include "system/pm_str.h"
#include "system/gamedata.h"
#include "system/wordset.h"
#include "../field_effect.h"
#include "msgdata/msg_underworld.h"

#include "field/goods_data.h"
#include "savedata/undergrounddata.h"

//==============================================================================
// `
//==============================================================================

#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY
#define _SECRETBASE_NUM_MAX (17)  ///< 閧nobt@̍ő
#define _SECRETBASE_MY_ID (16)  ///< ̔閧ñf[^ĂID
#define _SECRETBASE_SPLIT_NUM (4)  ///< M₷邽߂̕

#define _SECRETBASE_ATTR_MAX (32)

#define _SECLET_INNER_BASE_X  (15)
#define _SECLET_INNER_BASE_Z  (24)
#define _SECLET_INNER_BASE_Z_PLUS (32)

#define _INVALID_BASE (0xff)
#define _PLAYER_INVALID_GRID  (0xfff)   // W͂PQBITMsߕςȐɂȂĂ


typedef enum {
    _SB_INCOMPLETION,  // 
    _SB_COMPLETION, // 

} SecretBaseState;

#define _GOODS_NUM_MAX  (15)   // uObY̐   p\R

#define DEBUG_BLACT_NEW_HOOK //r{[hdlύXɂCӏ

//==============================================================================
//	^錾
//==============================================================================

#define _SECLET_BASE_DATA_SIZE  (148)

// 閧n\̃f[^
typedef struct{
    u8 netID;
    u8 moveID;       //ړl
    u8 secretBaseDataBuff[_SECLET_BASE_DATA_SIZE];
} SecretBaseInfo;


typedef struct{
    u16 xpos;    // hÄʒu
    u16 zpos;
} _Pos;

typedef struct{
    u16 xpos;    // hÄʒu
    u16 zpos;
    u8 netID;    // Nړ邩
    u8 dir;  // ǂɓ̂
} _SendPos;


// 閧nS
typedef struct{
    FIELDSYS_WORK* pFSys;
    SecretBaseInfo secretBaseData[_SECRETBASE_NUM_MAX];  // 閧n\
    SecretBaseInfo* pNowMoveingBase;
    u32 aAttr[_SECRETBASE_NUM_MAX][32];  // 閧nf[^RQRQ
    _Pos secretHeaderData[COMM_MACHINE_MAX]; // hA\邽߂̃f[^
    EOA_PTR doorAct[ _SECRETBASE_NUM_MAX ];
    u8 travelBase[COMM_MACHINE_MAX]; // Ă閧n CLIENTf[^
    u8 travelingBase[COMM_MACHINE_MAX]; //ƂĂ閧n
    u8 travelingBaseMessage[COMM_MACHINE_MAX]; //ƂĂ閧n
    u8 sendBuff[COMM_MACHINE_MAX*3];    // ړʒu𑗂ׂ̃obt@
    u8 sbNum;       // e@󂯎閧n̐
    u8 bChildRecv;    // q@̃f[^MTRUE
    u8 bPosRecv;    // q@̈ʒuMTRUE
    u8 bHalt;      // T[rX~̏ꍇTRUE
} CommSecretBaseWork;


typedef struct {
    BMPMENU_WORK*  pYesNoWork;
    int seq;
    int subseq;
    int next_zone_id;
    int next_door_id;
    int next_x;
    int next_z;
    int nextDir;
    int index;
    u8 brightness;
    u8 netID;
    u8 moveID;
}EVENT_UGCHG_WORK;


typedef struct{
    BMPMENU_WORK*  pYesNoWork;
    int seq;
    int index;
    u8 netID;
}_EVENT_DRILL_WORK;

// VOg
static CommSecretBaseWork* _pCommSecretBaseWork = NULL;

//==============================================================================
// static錾
//==============================================================================

static void _makeAttr(SECRETBASEDATA* pSecret, u32* attr);
static void _sendSecretBasePosition(void);
static void _doorPictFinalize(void);
static void _doorPictAdd(int x, int z, int index);
static void _jumpMapForUG(FIELDSYS_WORK* pFSys, int x, int z, int dir, int netID);
static void _returnUGMapEvent(FIELDSYS_WORK* pFSys, int x, int z, int dir, int netID, int moveID);
static void _enterSecretBaseEvent(FIELDSYS_WORK* pFSys, int x, int z, int dir, int netID, int moveID);
static void _enterSecretBaseStart(int secretBaseNo, int playerID);
static void _returnUnderGroundStart(int secretBaseNo, int playerID);
static void _createSecretBase(void);


static const BMPWIN_DAT _yesNoBmpDat = {
    GF_BGL_FRAME3_M, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
    FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
    };


// IDɂ镔BLOCKʒu  ŌオOFFLINE
static u8 _blockToRoomX[]={1,2,3,4,5,6,7,8,1,2,3,4,5,6,7,8,0};
static u8 _blockToRoomZ[]={0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1,0};

//==============================================================================
// ֐
//==============================================================================

//==============================================================================
/**
 * 閧no̍W߂
 * @param   netID
 * @retval  none
 */
//==============================================================================

static void _getSecretBaseOutPos_local(int netID, _Pos* pPos)
{
    const _Pos base = {_SECLET_INNER_BASE_X, _SECLET_INNER_BASE_Z};
    const int plus = _SECLET_INNER_BASE_Z_PLUS;
    int id;

    if(CommMPIsConnectStalth()){   // ʐMؒfԂ̏ꍇ
        pPos->xpos = base.xpos;
        pPos->zpos = base.zpos;
        return;
    }
    id = netID;
    if(netID == _SECRETBASE_MY_ID){
        id = 0;
    }
    pPos->xpos = base.xpos + (id % 8) * plus + plus;
    pPos->zpos = base.zpos + (id / 8) * plus;
}

static void _getSecretBaseOutPos(int netID, _Pos* pPos)
{
    int id = netID;
    
    if(CommGetAloneMode()){
        id = _SECRETBASE_MY_ID;
    }
    _getSecretBaseOutPos_local(id, pPos);
}

//==============================================================================
/**
 * 閧n񏉊
 * @param   [N|C^
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoInitialize(void* pWork, FIELDSYS_WORK* pFSys)
{
    int i;
    SecretBaseInfo* pBase;
    SECRETBASEDATA* pSecret;


    if(_pCommSecretBaseWork){  // ̂Ƃ뉽x̂
        return;
    }

    OHNO_PRINT("_SECLET_BASE_DATA_SIZE 傫\ %d\n",SecretBaseData_GetWorkSize());
    GF_ASSERT(_SECLET_BASE_DATA_SIZE == SecretBaseData_GetWorkSize());

    _pCommSecretBaseWork = (CommSecretBaseWork*)pWork;
    _pCommSecretBaseWork->pFSys = pFSys;
    _pCommSecretBaseWork->bChildRecv = FALSE;
    _pCommSecretBaseWork->bPosRecv = FALSE;
    _pCommSecretBaseWork->bHalt = FALSE;
    _pCommSecretBaseWork->pNowMoveingBase = NULL;

    for(i = 0; i < COMM_MACHINE_MAX; i++){
        _pCommSecretBaseWork->secretHeaderData[i].xpos = _PLAYER_INVALID_GRID;
        _pCommSecretBaseWork->secretHeaderData[i].zpos = _PLAYER_INVALID_GRID;
        _pCommSecretBaseWork->travelingBase[i] = _INVALID_BASE;
        _pCommSecretBaseWork->travelBase[i] = _INVALID_BASE;
        // bZ[W\
        _pCommSecretBaseWork->travelingBaseMessage[i] = _INVALID_BASE;
    }

    for(i = 0; i < _SECRETBASE_NUM_MAX; i++){
        _pCommSecretBaseWork->doorAct[i] = NULL;
        pBase = &_pCommSecretBaseWork->secretBaseData[i];
        pSecret = (SECRETBASEDATA*)_pCommSecretBaseWork->secretBaseData[i].secretBaseDataBuff;
        SecretBaseData_Init(pSecret);
    }
    MI_CpuFill8(_pCommSecretBaseWork->aAttr, 0xff,  _SECRETBASE_NUM_MAX * _SECRETBASE_ATTR_MAX * (_SECRETBASE_ATTR_MAX/8) );
    
    pSecret = SaveData_GetSecretBaseData(GameSystem_GetSaveData(pFSys));
    MI_CpuCopy8(pSecret,_pCommSecretBaseWork->secretBaseData[_SECRETBASE_MY_ID].secretBaseDataBuff,_SECLET_BASE_DATA_SIZE);

    // 
    _makeAttr(pSecret,_pCommSecretBaseWork->aAttr[_SECRETBASE_MY_ID]);

}

//==============================================================================
/**
 * f[^ʂ
 * @param   [N|C^
 * @retval  none
 */
//==============================================================================
static void _attrBitOff(int xinit, int zinit,const u8* pBuff, u32* attr)
{
    int x,z;
    
    for(z = 0;z < 3; z++){
        if((zinit+z) < 32){
            for(x = 0;x < 3; x++){
                if(pBuff[z*3 + x]){
                    if((xinit+x) < 32){
                        attr[z+zinit] &= ~(0x1 << (xinit+x));
                    }
                }
            }
        }
    }
}


//==============================================================================
/**
 * f[^쐬
 * @param   [N|C^
 * @retval  none
 */
//==============================================================================

static void _makeAttr(SECRETBASEDATA* pSecret, u32* attr)
{
    int i,x,z;
    const u8* pBuff;
    u8 pcBuff[]={1,1,0,0,0,0,0,0,0};
    u8 blockBuff[]={1,1,0,1,1,0,0,0,0};
    
    for(i = 0; i < SECRETBASE_SETUPOBJ_NUM_MAX; i++){
        if(SecretBaseData_GetGoodsType(pSecret, i) == GOODS_INVALID){
            continue;
        }
        x = SecretBaseData_GetGoodsXPos(pSecret,i);
        z = SecretBaseData_GetGoodsZPos(pSecret,i);
        if(i == 0){
            pBuff = pcBuff;
        }
        else if(i < (SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX)){
            pBuff = GOODS_GetGoodsHitData(i);
        }
        else{
            pBuff = blockBuff;
        }
        _attrBitOff(x, z, pBuff, attr);
    }
#if 0
    for(i = 0; i < _SECRETBASE_ATTR_MAX; i++){
        OHNO_PRINT("ATTR>> %x \n",attr[i]);
    }
#endif
}

//==============================================================================
/**
 * ꎞIɉʂۂɌĂԃZbg֐
 * @param   [N|C^
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoReset(void)
{
    _doorPictFinalize();
    _pCommSecretBaseWork->bHalt = TRUE;
}

//==============================================================================
/**
 * ʂ𕜋AۂɌĂԊ֐
 * @param   [N|C^
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoReboot(void)
{
    int i;

    _pCommSecretBaseWork->bHalt = FALSE;
    for(i = 0; i < COMM_MACHINE_MAX;i++){
        _Pos* pHead = &_pCommSecretBaseWork->secretHeaderData[i];
        if((_PLAYER_INVALID_GRID != pHead->xpos) && (_PLAYER_INVALID_GRID != pHead->zpos)){
            _doorPictAdd(pHead->xpos, pHead->zpos, i);
        }
    }
}

//==============================================================================
/**
 * 閧n񏈗I
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoFinalize(void)
{
    _doorPictFinalize();
    if(_pCommSecretBaseWork){
        sys_FreeMemoryEz(_pCommSecretBaseWork);
    }
    _pCommSecretBaseWork = NULL;
}

//==============================================================================
/**
 * [NŜ̃TCYԂ
 * @param   none
 * @retval  󂢂ĂCommSecretBaseWork̃|C^
 */
//==============================================================================

int CommSecretBaseInfoGetWorkSize(void)
{
    return sizeof(CommSecretBaseWork);
}

//==============================================================================
/**
 * ʐMŔĂl̍폜s
 * @param   netID
 * @retval  none
 */
//==============================================================================

void UgSecretBaseDestroyPlayer(int netID)
{
    if(_pCommSecretBaseWork){
        _pCommSecretBaseWork->secretHeaderData[netID].xpos = _PLAYER_INVALID_GRID;
        _pCommSecretBaseWork->secretHeaderData[netID].zpos = _PLAYER_INVALID_GRID;
        if(_pCommSecretBaseWork->doorAct[netID]){
            EOA_Delete( _pCommSecretBaseWork->doorAct[netID] );
            _pCommSecretBaseWork->doorAct[netID] = NULL;
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W\ꍇ̏IR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _msgEndCallBack(int num)
{
    FieldSystemProc_SeqHoldEnd();
}

//==============================================================================
/**
 * 閧n̓邩ǂ閧n̂ǂ
 * @param   none
 * @retval  TRUE
 */
//==============================================================================

static BOOL _isSecretBaseDoorCheck(int netID)
{
    if(_pCommSecretBaseWork->secretHeaderData[netID].xpos != _PLAYER_INVALID_GRID){
        if(_pCommSecretBaseWork->secretHeaderData[netID].zpos != _PLAYER_INVALID_GRID){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * 閧n̓ꍇԂ
 * @param   none
 * @retval  IDԂ INVALID_NETID
 */
//==============================================================================

static int _getSecretBaseEnter(int x, int z)
{
    int i;
    
    for(i = 0; i < COMM_MACHINE_MAX; i++){
        SecretBaseInfo* pBase = &_pCommSecretBaseWork->secretBaseData[i];
        SECRETBASEDATA* pSecret = (SECRETBASEDATA*)_pCommSecretBaseWork->secretBaseData[i].secretBaseDataBuff;
        if(!SecretBaseIsSecretBaseMake(pSecret)){
            continue;
        }
        if((x == SecretBaseGetSecretBasePositionX(pSecret)) &&
           (z == SecretBaseGetSecretBasePositionZ(pSecret)) ){   // ʒuqbg
            return i;
        }
    }
    return INVALID_NETID;
}

//==============================================================================
/**
 * @brief   ʘH<>閧n̈ړCxgJn CF_SECRETBASE_EVENT_START
 * @param   R[obN
 * @retval  none
 */
//==============================================================================

typedef struct{
    u16 x;
    u16 z;
    u8 netID;   // ړl
    u8 baseID;  // ړꏊID
    u8 dir;
    u8 bEnterBase;
} _JumpEventPacket;


void UgSecretBaseRecvJumpEvent(int netID, int size, void* pData, void* pWork)
{
    _JumpEventPacket* pJump = pData;

    if(pJump->netID != CommGetCurrentID()){
        return;
    }
    if(pJump->bEnterBase){
        _enterSecretBaseEvent(_pCommSecretBaseWork->pFSys,
                              pJump->x, pJump->z, DIR_UP,
                              pJump->netID, pJump->baseID);
    }
    else{
        _returnUGMapEvent(_pCommSecretBaseWork->pFSys,
                          pJump->x, pJump->z, pJump->dir,
                          pJump->netID, pJump->baseID);
    }
}

//==============================================================================
/**
 * @brief   ʘH<>閧n̈ړCxgJñpPbgTCY
 * @param   none
 * @retval  pPbgTCY
 */
//==============================================================================

int UgSecretBaseRecvJumpEventSize(void)
{
    return sizeof(_JumpEventPacket);
}

//==============================================================================
/**
 * @brief   ʘH<>閧n̈ړCxǧʂԂ CF_SECRETBASE_EVENT_RES
 * @param   R[obN
 * @retval  none
 */
//==============================================================================

typedef struct {
    u8 baseNo;
    u8 bResult;
    u8 bBaseIn;
} _UgJumpEventResult;

void UgSecretBaseRecvJumpEventRes(int netID, int size, void* pData, void* pWork)
{
    _UgJumpEventResult* pRes = pData;

    if(pRes->bResult){
        if(pRes->bBaseIn){
            _enterSecretBaseStart(pRes->baseNo, netID);
        }
        else{
            _returnUnderGroundStart(pRes->baseNo, netID);
        }
    }
    else{
        _pCommSecretBaseWork->travelingBase[netID] = _INVALID_BASE;  // 閧nړ
    }
}

//==============================================================================
/**
 * @brief   ʘH<>閧n̈ړCxǧʂԂׂ̃R}h̃TCY
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int UgSecretBaseRecvJumpEventResSize(void)
{
    return sizeof(_UgJumpEventResult);
}

//==============================================================================
/**
 * ʘH閧nɓs֐
 * @param   secretBaseNo   閧nԍ
 * @param   playerID       v[[
 * @retval  ꍇTRUE
 */
//==============================================================================

static void _enterSecretBaseStart(int secretBaseNo, int playerID)
{
    _Pos outDoorPos;

    SecretBaseInfo* pBase = &_pCommSecretBaseWork->secretBaseData[secretBaseNo];
    _getSecretBaseOutPos(secretBaseNo, &outDoorPos);
    
    // 閧n𑊎ɑM
    pBase->moveID = playerID;
    CommSecretBaseInfoParentSendStart(secretBaseNo); // i̔閧nq@ɑM
    _pCommSecretBaseWork->travelingBase[playerID] = secretBaseNo;  // ji̔閧nɍsƂĂ
    
    CommPlayerBaseTeleportServer(playerID, outDoorPos.xpos, outDoorPos.zpos, DIR_UP);
    OHNO_PRINT("%d%d̔閧nֈړJn %d %d\n", playerID, secretBaseNo,
               CommPlayerGetGridSX(playerID),CommPlayerGetGridSZ(playerID) );
}

//==============================================================================
/**
 * 閧nʘHɖ߂s֐
 * @param   secretBaseNo   閧nԍ
 * @param   playerID       v[[
 * @retval  ꍇTRUE
 */
//==============================================================================

static void _returnUnderGroundStart(int secretBaseNo, int playerID)
{
    _SendPos sendPos;
    _Pos outDoorPos;
    int x,z,dir;
    SecretBaseInfo* pBase = &_pCommSecretBaseWork->secretBaseData[secretBaseNo];
    SECRETBASEDATA* pSecret = (SECRETBASEDATA*)pBase->secretBaseDataBuff;
    
    _getSecretBaseOutPos_local(secretBaseNo, &outDoorPos);
    _pCommSecretBaseWork->travelingBase[playerID] = secretBaseNo;  // ji̔閧nł悤ƂĂ
    x = SecretBaseGetSecretBasePositionX(pSecret);
    z = SecretBaseGetSecretBasePositionZ(pSecret);
    dir = SecretBaseGetSecretBasePositionDir(pSecret);
    CommPlayerBaseTeleportServer(playerID, x, z, dir);
    OHNO_PRINT("%d  閧n ǂ %d %d %d\n", playerID, x, z , dir);
    x += FieldOBJ_DirAddValueGX( dir);
    z += FieldOBJ_DirAddValueGZ( dir);
    sendPos.xpos = x;
    sendPos.zpos = z;
    sendPos.netID = playerID;
    sendPos.dir = dir;
    CommSendFixSizeData_ServerSide(CF_SECRETBASE_RETJUMP,&sendPos);
}

//==============================================================================
/**
 * 閧nt[  ʒumFĈړ
 * @param   playerID   v[[
 * @retval  ꍇTRUE
 */
//==============================================================================

BOOL CommSecretBaseSingleStepFunc(int playerID, int moveX, int moveZ)
{
    int secretBaseNo;
    _SendPos sendPos;
    _Pos outDoorPos;
    _JumpEventPacket jp;
    int x,z;

    if(!_pCommSecretBaseWork){
        return FALSE;
    }
    if((playerID != COMM_PARENT_ID) && !CommIsConnect(playerID) ){
        return FALSE;
    }
    if(_pCommSecretBaseWork->travelingBase[playerID] != _INVALID_BASE){ // łɈړ
        return TRUE;
    }
    secretBaseNo = _getSecretBaseEnter(moveX, moveZ);
    if(secretBaseNo != INVALID_NETID){
        _pCommSecretBaseWork->travelingBase[playerID] = secretBaseNo;  // ji̔閧ngo- 
        jp.bEnterBase = TRUE;
        jp.x = moveX;
        jp.z = moveZ;
        jp.dir = DIR_UP;
        jp.netID = playerID;
        jp.baseID = secretBaseNo;
        CommSendFixSizeData_ServerSide(CF_SECRETBASE_EVENT_START,&jp);
//        _enterSecretBaseEvent(_pCommSecretBaseWork->pFSys,
//                              moveX, moveZ, DIR_UP, playerID);
        return TRUE;
    }
    for(secretBaseNo = 0; secretBaseNo <= COMM_MACHINE_MAX; secretBaseNo++){   // ߂鎞̌́AςȏꏊɍsĂ悤ɔ閧n̑Sꏊ
        SecretBaseInfo* pBase = &_pCommSecretBaseWork->secretBaseData[secretBaseNo];
        SECRETBASEDATA* pSecret = (SECRETBASEDATA*)_pCommSecretBaseWork->secretBaseData[secretBaseNo].secretBaseDataBuff;
        if(!SecretBaseIsSecretBaseMake(pSecret)){
            continue;
        }
        _getSecretBaseOutPos_local(secretBaseNo, &outDoorPos);
        if((moveX == outDoorPos.xpos) && (moveZ == outDoorPos.zpos) ){   // ʒuqbg
            _pCommSecretBaseWork->travelingBase[playerID] = secretBaseNo;  // ji̔閧nł悤ƂĂ
            jp.bEnterBase = FALSE;
            jp.x = moveX;
            jp.z = moveZ;
            jp.dir = DIR_UP;
            jp.netID = playerID;
            jp.baseID = secretBaseNo;
            CommSendFixSizeData_ServerSide(CF_SECRETBASE_EVENT_START,&jp);
//            _returnUGMapEvent(_pCommSecretBaseWork->pFSys,
//                              pBase->xpos, pBase->zpos, pBase->dir, playerID);
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * 閧nYzɖ߂ۂ̃Cxg
 * @param   event CxgRg[
 * @retval  none
 */
//==============================================================================

typedef enum {
    _RETURN_START,
    _ONLINE_MSGWAIT,
    _ONLINE_YESNO_WAIT,
    _OFFLINE_MSGWAIT,
    _OFFLINE_YESNO_WAIT,
    _CONNECT_CHKMSG,
    _CONNECT_YESNO_WAIT,
    _RETURN_UG,
} ReturnMapCheck_e;


static BOOL GMEVENT_ReturnMapCheck(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
    LOCATION_WORK locationWork;
    int x=0,z=0,msgNo,ret, bClose = FALSE;
    _UgJumpEventResult ugJump;

    switch (mcw->seq) {
      case _RETURN_START:
        if(CommMPIsConnectStalth()){   // ʐMؒfԂ̏ꍇ
            msgNo = msg_underworld_47;
            mcw->seq = _OFFLINE_MSGWAIT;
        }
        else{
            msgNo = msg_underworld_50;
            mcw->seq = _ONLINE_MSGWAIT;
        }
        mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msgNo, FALSE, NULL);
        break;
      case _ONLINE_MSGWAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mcw->seq = _ONLINE_YESNO_WAIT;
        }
        break;
      case _ONLINE_YESNO_WAIT:
        ret = BmpYesNoSelectMain(mcw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mcw->seq = _RETURN_UG;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bClose = TRUE;
        }
        break;
      case _OFFLINE_MSGWAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mcw->seq = _OFFLINE_YESNO_WAIT;
        }
        break;
      case _OFFLINE_YESNO_WAIT:
        ret = BmpYesNoSelectMain(mcw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_48, FALSE, NULL);
            mcw->seq = _CONNECT_CHKMSG;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bClose = TRUE;
        }
        break;
      case _CONNECT_CHKMSG:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mcw->seq = _CONNECT_YESNO_WAIT;
        }
        break;
      case _CONNECT_YESNO_WAIT:
        ret = BmpYesNoSelectMain(mcw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mcw->seq = _RETURN_UG;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bClose = TRUE;
        }
        break;
      case _RETURN_UG:
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        ugJump.bResult = TRUE;
        ugJump.baseNo = mcw->moveID;
        ugJump.bBaseIn = FALSE;
        CommSendFixSizeData(CF_SECRETBASE_EVENT_RES, &ugJump);
//        _returnUnderGroundStart(mcw->moveID, mcw->netID);
        return TRUE;
        break;
    }

    if(bClose){
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
//        Ƃ߂[΂ɂ
        //_pCommSecretBaseWork->travelingBase[mcw->netID] = _INVALID_BASE; // 
        ugJump.bResult = FALSE;
        ugJump.baseNo = mcw->moveID;
        ugJump.bBaseIn = FALSE;
        CommSendFixSizeData(CF_SECRETBASE_EVENT_RES, &ugJump);
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * 閧nYzɖ߂ۂ̃CxgRXgN^̐
 * @param   pFSys tB[hVXe
 * @param   x,y,dir  ړ̈ʒu
 * @param   netID ړl
 * @retval  RXgN^
 */
//==============================================================================

static EVENT_UGCHG_WORK* _createFactoryUGCHG(FIELDSYS_WORK* pFSys, int x, int z, int dir, int netID, int moveID)
{
    //Wv
    EVENT_UGCHG_WORK * mcw = NULL;
    //Cxg
    if(pFSys->event==NULL){
        mcw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(EVENT_UGCHG_WORK));
        mcw->seq = 0;
        mcw->subseq = 0;
        mcw->next_door_id = DOOR_ID_JUMP_CODE;
        mcw->next_x = x;
        mcw->next_z = z;
        mcw->netID = netID;
        mcw->moveID = moveID;
        GF_ASSERT(pFSys->location->zone_id == ZONE_ID_UG); //n
        mcw->next_zone_id = ZONE_ID_UG;
        mcw->nextDir = dir;
    }
    return mcw;
}

//==============================================================================
/**
 * 閧nYzɖ߂ۂ̃Cxg
 * @param   pFSys tB[hVXe
 * @param   x,y,dir  ړ̈ʒu
 * @param   netID ړl
 * @retval  none
 */
//==============================================================================

static void _returnUGMapEvent(FIELDSYS_WORK* pFSys, int x, int z, int dir, int netID, int moveID)
{
    //Wv
    EVENT_UGCHG_WORK * mcw = _createFactoryUGCHG(pFSys, x, z, dir, netID, moveID);
    //Cxg
    GF_ASSERT_RETURN(mcw != NULL,);  // ȂƂƂ̓vO䂪
    
    FieldEvent_Set(pFSys, GMEVENT_ReturnMapCheck, mcw);
}

//==============================================================================
/**
 * ̔閧nɓĂl𒲂ׂ
 * @param   netID   
 * @retval  l
 */
//==============================================================================

static int _checkMySecretBaseEnterPlayersNum(int netID)
{
    int i,num=0;

    for(i = 0;i < COMM_MACHINE_MAX;i++){
        OHNO_PRINT("%d %dn \n",i,_pCommSecretBaseWork->travelBase[i]);
        if(_pCommSecretBaseWork->travelBase[i] == netID){
            num++;
        }
    }
    OHNO_PRINT("%dɓĂ̂%dlł \n",netID,num);
    return num;
}

//==============================================================================
/**
 * Yz閧nɓۂ̃Cxg l̂Ǝ̂ł͋Ⴄ
 * @param   event CxgRg[
 * @retval  none
 */
//==============================================================================

typedef enum {
    _ENTER_START,
    _TARGET_MSGWAIT,
    _TARGET_YESNO_WAIT,
    _TARGET_ENTER_SB_WAIT,
    _MY_MSGWAIT,
    _MY_YESNO_WAIT,
    _MYSB_CHANGE_WAIT,
    _MYSB_CHANGE_YESNO_WAIT,
    _ENTER_MYSB_CHANGE_WAIT,
    _ENTER_MYSB_CHANGE,
    _ENTER_SB,
} EnterBaseCheck_e;


static BOOL GMEVENT_EnterBaseCheck(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
    LOCATION_WORK locationWork;
    int x=0,z=0,msgNo,ret, bClose = FALSE;
    _UgJumpEventResult ugJump;

    switch (mcw->seq) {
      case _ENTER_START:
        if(mcw->moveID != mcw->netID){
            msgNo = msg_underworld_45;   //
            mcw->seq = _TARGET_MSGWAIT;
        }
        else{
            msgNo = msg_underworld_41;
            mcw->seq = _MY_MSGWAIT;
        }
        mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msgNo, FALSE, NULL);
        break;
      case _TARGET_MSGWAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mcw->seq = _TARGET_YESNO_WAIT;
        }
        break;
      case _TARGET_YESNO_WAIT:
        ret = BmpYesNoSelectMain(mcw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_46, FALSE, NULL);
            mcw->seq = _TARGET_ENTER_SB_WAIT;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bClose = TRUE;
        }
        break;
      case _TARGET_ENTER_SB_WAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->seq = _ENTER_SB;
        }
        break;
        // ̔閧nɓ
      case _MY_MSGWAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mcw->seq = _MY_YESNO_WAIT;
        }
        break;
      case _MY_YESNO_WAIT:
        ret = BmpYesNoSelectMain(mcw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            if(CommPlayerIsFlagData(mcw->moveID) || (_checkMySecretBaseEnterPlayersNum(mcw->moveID) > 0) ){  // Ă
                mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_44, FALSE, NULL);
                mcw->seq = _TARGET_ENTER_SB_WAIT;
            }
            else{
                mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_42, FALSE, NULL);
                mcw->seq = _MYSB_CHANGE_WAIT;
            }
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bClose = TRUE;
        }
        break;
      case _MYSB_CHANGE_WAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            mcw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mcw->seq = _MYSB_CHANGE_YESNO_WAIT;
        }
        break;
      case _MYSB_CHANGE_YESNO_WAIT:
        ret = BmpYesNoSelectMain(mcw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_43, FALSE, NULL);
            mcw->seq = _ENTER_MYSB_CHANGE_WAIT;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ ʂɓ
            mcw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_44, FALSE, NULL);
            mcw->seq = _TARGET_ENTER_SB_WAIT;
        }
        break;
      case _ENTER_MYSB_CHANGE_WAIT:
        if(GF_MSG_PrintEndCheck(mcw->index) == 0){
            // offline
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
            CommFieldStateStalthUnderGround();
            mcw->seq = _ENTER_MYSB_CHANGE;
        }
        break;
      case _ENTER_MYSB_CHANGE:
        if(CommMPIsConnectStalth() && (CommGetCurrentID() == COMM_PARENT_ID)){
            u8 bFlag = TRUE;
            // 閧n쐬T[o[ɑM Cxg͏I bN͂܂ łOFFLINE
            CommSendFixSizeData(CF_DRILL_START, &bFlag);
            OHNO_PRINT("ʐMؒfCxg  --  bZ[WH\n");
            return TRUE;
        }
        break;
      case _ENTER_SB:
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        // ʂɓ邾 ONLINE
        ugJump.bResult = TRUE;
        ugJump.baseNo = mcw->moveID;
        ugJump.bBaseIn = TRUE;
        CommSendFixSizeData(CF_SECRETBASE_EVENT_RES, &ugJump);
//        _enterSecretBaseStart(mcw->moveID, mcw->netID);
        return TRUE;
        break;
    }

    if(bClose){
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        ugJump.bResult = FALSE;
        ugJump.baseNo = mcw->moveID;
        ugJump.bBaseIn = FALSE;
        CommSendFixSizeData(CF_SECRETBASE_EVENT_RES, &ugJump);
//        Ƃ߂[΂ɂ
        //_pCommSecretBaseWork->travelingBase[mcw->netID] = _INVALID_BASE; // 
        return TRUE;
    }
    return FALSE;
}



//==============================================================================
/**
 * @brief Yz閧nɍsۂ̃Cxg
 *        ̔閧n̏ꍇCAEg邩ǂ
 * @param   pFSys tB[hVXe
 * @param   x,y,dir  ړ̈ʒu
 * @param   netID ړl
 * @retval  none
 */
//==============================================================================

static void _enterSecretBaseEvent(FIELDSYS_WORK* pFSys, int x, int z, int dir,
                                  int netID, int moveID)
{
    //Wv
    EVENT_UGCHG_WORK * mcw = _createFactoryUGCHG(pFSys, x, z, dir, netID, moveID);
    //Cxg
    GF_ASSERT_RETURN(mcw != NULL,);  // ȂƂƂ̓vO䂪
    
    FieldEvent_Set(pFSys, GMEVENT_EnterBaseCheck, mcw);
}

//==============================================================================
/**
 * 閧nړƂT[o[ɓ`R}h̃TCY
 * @param   none
 * @retval  R}hTCY
 */
//==============================================================================

int CommSecretBaseInfoGetRetJumpSize(void)
{
    return sizeof(_SendPos);
}

//==============================================================================
/**
 * 閧nړƂT[o[ɓ` CF_SECRETBASE_RETJUMP
 * @param   x   ʒu
 * @param   y
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoRecvRetJump(int netID, int size, void* pData, void* pWork)
{
    _SendPos* pSendPos = pData;


    _pCommSecretBaseWork->travelBase[pSendPos->netID] = _INVALID_BASE;
    OHNO_PRINT("_pCommSecretBaseWork->travelBase[] %d %d\n",pSendPos->netID,_INVALID_BASE);

    if(CommGetCurrentID() == pSendPos->netID){
        // ړJn
        _jumpMapForUG(_pCommSecretBaseWork->pFSys, pSendPos->xpos, pSendPos->zpos, pSendPos->dir, pSendPos->netID);
        OHNO_PRINT("閧nŖړJn\n");
        _pCommSecretBaseWork->pNowMoveingBase = NULL;
    }
    else{  // Lړ
        CommPlayerBaseTeleportClient(pSendPos->netID, pSendPos->xpos, pSendPos->zpos, pSendPos->dir);
    }
}

//==============================================================================
/**
 * 閧nړƂT[o[ɓ`
 * @param   x   ʒu
 * @param   y
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoJumpEnd(void)
{
    CommSendFixData(CF_SECRETBASE_JUMP_END);
}

//==============================================================================
/**
 * 閧nړ
 * @param   x   ʒu
 * @param   y
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoRecvJumpEnd(int netID, int size, void* pData, void* pWork)
{
    _pCommSecretBaseWork->travelingBase[netID] = _INVALID_BASE;
    CommPlayerManagerReboot();
}

//==============================================================================
/**
 * 閧nړsĂ邩ǂ
 * @param   netID v[[
 * @retval  ړĂTRUE
 */
//==============================================================================

BOOL CommSecretBaseIsTraveling(int netID)
{
    if(_pCommSecretBaseWork){
        if(_pCommSecretBaseWork->travelingBase[netID] != _INVALID_BASE){
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 * 閧nǉ
 * @param   x   ʒu
 * @param   y
 * @retval  none
 */
//==============================================================================

static void _insertBaseNetID(int x,int y, int dir, int netID)
{
    SecretBaseInfo* pWork = &_pCommSecretBaseWork->secretBaseData[netID];

    if(pWork){
        SECRETBASEDATA* pSecret = (SECRETBASEDATA*)pWork->secretBaseDataBuff;
        SecretBaseSetSecretBasePosition(pSecret,x,y,CommPlayerGetReverseDir(dir));
        pWork->netID = netID;
    }
}

// q@̃vO

//==============================================================================
/**
 * q@̃vO  e@ɔ閧n𑗂
 *  Ƃ肠̈
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoChildSendStart(void)
{
    SECRETBASEDATA* pSecret = (SECRETBASEDATA*)_pCommSecretBaseWork->secretBaseData[_SECRETBASE_MY_ID].secretBaseDataBuff;
    int i;
    u8 num=0;
    int id=CommGetCurrentID();

    /// ǃL[ɂł
    OHNO_PRINT("閧n𑗐M-------------------%d-\n", id);

    if(SecretBaseIsSecretBaseMake(pSecret)){
        
        OHNO_PRINT("閧nL[ɓꂽ----%d-\n", CF_SECRETBASE_DATA);
        CommSetSendQueue(CF_SECRETBASE_DATA,
                         &_pCommSecretBaseWork->secretBaseData[_SECRETBASE_MY_ID],
                         sizeof(SecretBaseInfo));
    }
}

// e@̃vO

//==============================================================================
/**
 * e@̃vO  q@Ɏw肳ꂽ閧n𑗂
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoParentSendStart(int netID)
{
    OHNO_PRINT("q@ɔ閧n𑗂܂ %d \n", netID);
    CommSetSendQueue_ServerSide(CF_SECRETBASE_DATA_SERVER,
                                &_pCommSecretBaseWork->secretBaseData[netID],
                                sizeof(SecretBaseInfo));
}

//==============================================================================
/**
 * q@̃vO  e@炫ړ閧nf[^ CF_SECRETBASE_DATA_SERVER
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoRecvDataServer(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    SecretBaseInfo* pBase = pData;
    _Pos outDoorPos;
    int id;

    if(!_pCommSecretBaseWork){
        return;
    }
    id = pBase->netID;
    OHNO_PRINT("ړ\   ---   閧nM %d\n",id);
    GF_ASSERT(id < _SECRETBASE_NUM_MAX);
    pBase = &_pCommSecretBaseWork->secretBaseData[id];
    MI_CpuCopy8(pData, pBase,  sizeof(SecretBaseInfo));

    _pCommSecretBaseWork->travelBase[pBase->moveID] = pBase->netID;
    OHNO_PRINT("_pCommSecretBaseWork->travelBase[pBase->moveID] %d %d\n",pBase->moveID,pBase->netID);
    // bZ[W\
    _pCommSecretBaseWork->travelingBaseMessage[pBase->moveID] = pBase->netID;

    // ړʒuvZ
    _getSecretBaseOutPos(pBase->netID, &outDoorPos);
    if(CommGetCurrentID() == pBase->moveID){
        // ړJn
        OHNO_PRINT("NCAg閧nړJn%d %d %d\n",pBase->netID, outDoorPos.xpos, outDoorPos.zpos);
        _jumpMapForUG(_pCommSecretBaseWork->pFSys, outDoorPos.xpos, outDoorPos.zpos , DIR_UP, pBase->moveID);
        _pCommSecretBaseWork->pNowMoveingBase = pBase;
    }
    else{  // Lړ
        CommPlayerBaseTeleportClient(pBase->moveID, outDoorPos.xpos, outDoorPos.zpos, DIR_UP);
    }
}


//==============================================================================
/**
 * e@̃vO  q@炫閧ni[ CF_SECRETBASE_DATA ̎󂯎葤
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoRecvData(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    SecretBaseInfo* pBase;
    SECRETBASEDATA* pSecret;

    if(!_pCommSecretBaseWork){
        return;
    }
    pBase = &_pCommSecretBaseWork->secretBaseData[netID];
    MI_CpuCopy8(pData,  pBase, sizeof(SecretBaseInfo));
    pBase->netID = netID;

    _pCommSecretBaseWork->bChildRecv = TRUE;  //q@f[^M
    OHNO_PRINT("e@閧n󂯎 %d\n", netID);
    OHNO_SP_PRINT("e@閧n󂯎 %d\n", netID);
    pSecret = (SECRETBASEDATA*)pBase->secretBaseDataBuff;

    // ʒuւĎq@ɕz
    _pCommSecretBaseWork->secretHeaderData[netID].xpos = SecretBaseGetSecretBasePositionX(pSecret);
    _pCommSecretBaseWork->secretHeaderData[netID].zpos = SecretBaseGetSecretBasePositionZ(pSecret);
    _sendSecretBasePosition();

    // f[^쐬
    _makeAttr(pSecret,_pCommSecretBaseWork->aAttr[netID]);
    
}

//==============================================================================
/**
 * 閧nf[^TCYԂ
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommSecretBaseInfoGetDataSize(void)
{
    return sizeof(SecretBaseInfo);
}

BOOL CommSecretBaseInfoIsChildRecv(void)
{
    return _pCommSecretBaseWork->bChildRecv;
}

void CommSecretBaseResetChildRecv(void)
{
    _pCommSecretBaseWork->bChildRecv = FALSE;
}

BOOL CommSecretBaseInfoIsPosRecv(void)
{
    return _pCommSecretBaseWork->bPosRecv;
}

void CommSecretBaseResetPosRecv(void)
{
    _pCommSecretBaseWork->bPosRecv = FALSE;
}

//==============================================================================
/**
 *  閧n̈ʒû݂RpNgđ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _sendSecretBasePosition(void)
{
    int i,j;

    j = 0;
    for(i = 0; i < COMM_MACHINE_MAX;i++){
        _Pos* pHead = &_pCommSecretBaseWork->secretHeaderData[i];
        _pCommSecretBaseWork->sendBuff[j] = pHead->xpos & 0xff;
        j++;
        _pCommSecretBaseWork->sendBuff[j] = ((pHead->xpos >> 8) & 0xf) + ((pHead->zpos >> 4) & 0xf0);
        j++;
        _pCommSecretBaseWork->sendBuff[j] = pHead->zpos & 0xff;
        j++;
    }
    CommSetSendQueue_ServerSide(CF_SECRETBASE_POS,
                                &_pCommSecretBaseWork->sendBuff,
                                sizeof(_pCommSecretBaseWork->sendBuff));
}

//==============================================================================
/**
 *  閧n̈ʒû݂M
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseInfoRecvPos(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = (u8*)pData;
    int i,j;
    if(!_pCommSecretBaseWork){
        return;
    }

    j = 0;
    for(i = 0; i < COMM_MACHINE_MAX;i++){
        _Pos* pHead = &_pCommSecretBaseWork->secretHeaderData[i];
        pHead->xpos = pBuff[j];
        j++;
        pHead->xpos += ((int)pBuff[j] << 8 & 0xf00);
        pHead->zpos = ((int)pBuff[j] << 4 & 0xf00);
        j++;
        pHead->zpos += pBuff[j];
        j++;
        if((_PLAYER_INVALID_GRID != pHead->xpos) && (_PLAYER_INVALID_GRID != pHead->zpos)){
            _doorPictAdd(pHead->xpos, pHead->zpos, i);
        }
    }
    _pCommSecretBaseWork->bPosRecv = TRUE;
    OHNO_PRINT("閧nʒuM\n");
}

//==============================================================================
/**
 *  閧n̈ʒuf[^̃TCYԂ
 * @param   none
 * @retval  none
 */
//==============================================================================

int CommSecretBaseInfoGetPosSize(void)
{
    return sizeof(_pCommSecretBaseWork->sendBuff);
}

//==============================================================================
/**
 * hA\ij{̓tB[hf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _doorPictAdd(int x, int z, int index)
{
    if(_pCommSecretBaseWork->bHalt){
        return;
    }

    if(_pCommSecretBaseWork->doorAct[index]){
        EOA_Delete(_pCommSecretBaseWork->doorAct[index]);
    }
    _pCommSecretBaseWork->doorAct[index] =
        FE_DbgOrnament_Add(_pCommSecretBaseWork->pFSys, x, z, -1);

}

//==============================================================================
/**
 * hA\ij{̓tB[hf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _doorPictDelete(int netID)
{
    if(_pCommSecretBaseWork->doorAct[netID]){
        EOA_Delete(_pCommSecretBaseWork->doorAct[netID]);
        _pCommSecretBaseWork->doorAct[netID] =NULL;
    }
}

//==============================================================================
/**
 * hAij{̓tB[hf
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _doorPictFinalize(void)
{
    int i;

    if(_pCommSecretBaseWork==NULL){
        return;
    }


    for(i = 0; i < _SECRETBASE_NUM_MAX; i++){
        if(_pCommSecretBaseWork->doorAct[i]){
            // KvȂ
            //            EOA_Delete( _pCommSecretBaseWork->doorAct[i] );
            _pCommSecretBaseWork->doorAct[i] = NULL;
        }
    }
}


//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL Sub_UgFadeOut(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);

    switch (mcw->subseq) {
      case 0:
        GameSystem_FinishFieldProc(fsys);
        (mcw->subseq) ++;
        break;
      case 1:
        if (!GameSystem_CheckFieldProcExists(fsys)) {
            mcw->subseq = 0;
            return TRUE;
        }
        break;
    }
    return FALSE;
}
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static BOOL Sub_UgFadeIn(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);

    switch (mcw->subseq) {
      case 0:
        GameSystem_CreateFieldProc(fsys);
        (mcw->subseq) ++;
        break;
      case 1:
        if (FieldEvent_Cmd_WaitMapProcStart(fsys)) {
            mcw->subseq = 0;
            return TRUE;
        }
        break;
    }
    return FALSE;
}


//==============================================================================
/**
 *  wʒuփWvCxg
 * @param   event CxgRg[[
 * @retval  none
 */
//==============================================================================

static BOOL GMEVENT_JumpMapForUG(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    EVENT_UGCHG_WORK * mcw = FieldEvent_GetSpecialWork(event);
    LOCATION_WORK locationWork;
    int x=0,z=0;

    switch (mcw->seq) {
      case 0:
        CommDisableSendMoveData();
        CommStateJumpUnderGround();   // ړꍇ̒ʐM֘A
        UnderGround_RadarEnd(fsys->UnderGroundRadar);
        (mcw->seq) ++;
        break;
      case 1:
        if (fsys->UnderGroundRadar == NULL){
            (mcw->seq) ++;
        }
        break;
      case 2:
        if(Sub_UgFadeOut(event)){		// vbNChange
            (mcw->seq) ++;
        }
        break;
      case 3:
        locationWork.zone_id = mcw->next_zone_id;
        locationWork.door_id = mcw->next_door_id;
        locationWork.grid_x = mcw->next_x;
        locationWork.grid_z = mcw->next_z;
        locationWork.dir = mcw->nextDir;
        //CommPlayerManagerReset();
        EventCmd_UgJumpByLocation(event, &locationWork);
        (mcw->seq) ++;
        break;
      case 4:
        if(Sub_UgFadeIn(event)){		// vbNChange
            //CommPlayerManagerReboot();
            (mcw->seq) ++;
        }
        break;
      case 5:
        if( CommMPIsConnectStalth() && !UgSecretBaseIsSecretBasePlace(mcw->next_x, mcw->next_z)){
            CommFieldStateUnderGroundReConnect();  // Đڑꍇ̏
        }
        else{
            CommStateJumpEndUnderGround(); // ړIꍇ̒ʐM֘A
        }
        CommEnableSendMoveData();
        fsys->UnderGroundRadar = UnderGround_RadarInit(fsys);		//Yz[_[ʂnm
        sys_FreeMemoryEz(mcw);
        OHNO_PRINT("CxgI\n");
        FieldSystemProc_SeqHoldEnd();
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 *  wʒuփWvCxgN
 * @param   pFSys  FIELDSYS_WORK*
 * @param   int x, int z, int dir  ړʒuƕ
 * @retval  none
 */
//==============================================================================

static void _jumpMapForUG(FIELDSYS_WORK* pFSys, int x, int z, int dir, int netID)
{
    EVENT_UGCHG_WORK * mcw = _createFactoryUGCHG(pFSys, x, z, dir, netID, netID);
    //Cxg
    GF_ASSERT_RETURN(mcw != NULL,);  // ȂƂƂ̓vO䂪
    
    FieldEvent_Set(pFSys, GMEVENT_JumpMapForUG, mcw);
}


//==============================================================================
/**
 *  hŔ閧n
 * @param   none
 * @retval  none
 */
//==============================================================================

typedef enum{
    _DRILL_ANIM,
    _HOLE_MODEL_PUT,
    _QUESTION_MSG,
    _NODIG_WAIT,
    _YESNO_MSG,
    _YESNO_WAIT,
    _SHUTDOWN_MSG,
    _SHUTDOWN_WAIT,
    _DISCONNECT_MSG_WAIT,
    _DISCONNECT_WAIT,
};

static BOOL _GMEVENT_Drill(GMEVENT_CONTROL * event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    _EVENT_DRILL_WORK * mdw = FieldEvent_GetSpecialWork(event);
    LOCATION_WORK locationWork;
    u32 ret;
    BOOL bExit = FALSE;
    int msgNo;

    switch (mdw->seq) {
      case _DRILL_ANIM:
        CommStateFieldDisableChange();
        FieldSystemProc_SeqHold();
        CommMsgRegisterUGTrapName(CommUnderGetMsgUnderWorld(), UG_TRAPTYPE_DRILL);
        mdw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_36, FALSE, NULL);
        mdw->seq = _HOLE_MODEL_PUT;
        break;
      case _HOLE_MODEL_PUT:
        if(GF_MSG_PrintEndCheck(mdw->index) == 0){
            int x = CommPlayerGetGridXDirAdd(CommGetCurrentID());
            int z = CommPlayerGetGridZDirAdd(CommGetCurrentID());
            mdw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_37, FALSE, NULL);
            _doorPictAdd(x, z, _SECRETBASE_MY_ID);  // Ǒ͊J܂
            mdw->seq = _QUESTION_MSG;
        }
        break;
      case _QUESTION_MSG:
        if(GF_MSG_PrintEndCheck(mdw->index) == 0){
            if(_checkMySecretBaseEnterPlayersNum(CommGetCurrentID())){
                msgNo = msg_underworld_57;
                mdw->seq = _NODIG_WAIT;
            }
            else if(_isSecretBaseDoorCheck(CommGetCurrentID())){
                msgNo = msg_underworld_39;
                mdw->seq = _YESNO_MSG;
            }
            else{
                msgNo = msg_underworld_38;
                mdw->seq = _YESNO_MSG;
            }
            mdw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msgNo, FALSE, NULL);
        }
        break;
      case _NODIG_WAIT:
        if(GF_MSG_PrintEndCheck(mdw->index) == 0){
            if(sys.trg & PAD_BUTTON_DECIDE){
                bExit = TRUE;
            }
        }
        break;
      case _YESNO_MSG:
        if(GF_MSG_PrintEndCheck(mdw->index) == 0){
            mdw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mdw->seq = _YESNO_WAIT;
        }
        break;
      case _YESNO_WAIT:
        ret = BmpYesNoSelectMain(mdw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mdw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_391, FALSE, NULL);
            mdw->seq = _SHUTDOWN_MSG;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bExit = TRUE;
        }
        break;
      case _SHUTDOWN_MSG:
        if(GF_MSG_PrintEndCheck(mdw->index) == 0){
            mdw->pYesNoWork = BmpYesNoSelectInit(fsys->bgl,
                                                 &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                 MENU_WIN_PAL, HEAPID_FIELD );
            mdw->seq = _SHUTDOWN_WAIT;
        }
        break;
      case _SHUTDOWN_WAIT:
        ret = BmpYesNoSelectMain(mdw->pYesNoWork, HEAPID_FIELD);
        if(ret == 0){ // ͂Iꍇ
            mdw->index = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                   msg_underworld_40, TRUE, _msgEndCallBack);
            mdw->seq = _DISCONNECT_MSG_WAIT;
        }
        else if(ret != BMPMENU_NULL){ // Iꍇ I
            bExit = TRUE;
        }
        break;
      case _DISCONNECT_MSG_WAIT:
        if(GF_MSG_PrintEndCheck(mdw->index) == 0){
            // offline̊nֈړ ʐMؒf
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
            CommStateFieldEnableChange();
            CommFieldStateStalthUnderGround();
            mdw->seq = _DISCONNECT_WAIT;
        }
        break;
      case _DISCONNECT_WAIT:
        if(CommMPIsConnectStalth() && (CommGetCurrentID() == COMM_PARENT_ID)){
            u8 bFlag = TRUE;
            // 閧n쐬T[o[ɑM Cxg͏I bN͂܂ łOFFLINE
            _createSecretBase();  // VK쐬
            CommSendFixSizeData(CF_DRILL_START, &bFlag);
            CommStateFieldEnableChange();
            return TRUE;
        }
        break;
    }
/*    if(mdw->seq  < _DISCONNECT_WAIT){
        if(mdw->netID != CommGetCurrentID()){  // JnۂID ꂪH狭I
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
            FieldSystemProc_SeqHoldEnd();
            CommStateFieldEnableChange();
            return TRUE;
        }
    }  */
    if(bExit){
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                               msg_underworld_56, TRUE, _msgEndCallBack);
        if(_pCommSecretBaseWork->doorAct[_SECRETBASE_MY_ID]){
            EOA_Delete(_pCommSecretBaseWork->doorAct[_SECRETBASE_MY_ID]);
            _pCommSecretBaseWork->doorAct[_SECRETBASE_MY_ID]=NULL;
        }
        CommStateFieldEnableChange();
        return TRUE;
    }
    return FALSE;
}

//==============================================================================
/**
 * @brief   閧ň@
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommSecretBaseDrillStart(void)
{
    u8 bFlag = FALSE;
    CommSendFixSizeData(CF_DRILL_START, &bFlag);   // ܂͌@Ăǂ₢킹
}

//==============================================================================
/**
 * @brief   閧ň@ CF_DRILL_START
 * @param   none
 * @retval  none
 */
//==============================================================================

typedef struct{
    u8 netID;
    u8 result;
} _resultStruct;

typedef enum{
    _SB_CREATE_NG,
    _SB_CREATE_START,
    _SB_CREATED,
    _SB_CREATE_FAILED,
};


int CommSecretBaseDrillStartResultSize(void)
{
    return sizeof(_resultStruct);
}

void CommSecretBaseRecvDrillStart(int netID, int size, void* pData, void* pWork)
{
    u8* pCreateFlag = pData;
    int x = CommPlayerGetGridSXDirAdd(netID);
    int z = CommPlayerGetGridSZDirAdd(netID);
    int dir = CommPlayerGetSDir(netID);
    _resultStruct ret;
    int id;

    ret.netID = netID;
    if(pCreateFlag[0] == FALSE){
        ret.result = _SB_CREATE_NG;
    }
    else{
        ret.result = _SB_CREATE_FAILED;
    }
    id = _getSecretBaseEnter(x, z);
    if(id != INVALID_NETID){   // N̔閧nꍇȂ
    }
    else if(UgSecretBaseIsSecretBasePlace(x, z)){  // 閧n̏ꍇقȂ
    }
    else if(GetHitAttr(_pCommSecretBaseWork->pFSys,x,z)){  // 肠ꍇ
        if(pCreateFlag[0] == FALSE){    // CxgJnĂ𑗐M
            ret.result = _SB_CREATE_START;
        }
        else{
//            _Pos outDoorPos;
            _insertBaseNetID(x, z, dir, _SECRETBASE_MY_ID);  // 쐬
            _enterSecretBaseStart(_SECRETBASE_MY_ID,netID);  // Wv
            OHNO_PRINT("CF_DRILL_START ړJnbZ[W %d\n",netID);
            ret.result = _SB_CREATED;
        }
    }
    CommSendFixSizeData_ServerSide(CF_DRILL_START_RESULT, &ret);
}

//==============================================================================
/**
 * @brief   閧ň@ T[o[̖߂   CF_DRILL_START_RESULT
 * @param   none
 * @retval  none
 */
//==============================================================================


void CommSecretBaseRecvDrillStartResult(int netID, int size, void* pData, void* pWork)
{
    _resultStruct* pRet = pData;
    SB_RECORD_DATA* pRec = SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCommSecretBaseWork->pFSys));

    if(pRet->netID != CommGetCurrentID()){
        return;
    }
    if(pRet->result == _SB_CREATE_NG){
        FieldSystemProc_SeqHold();
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_54, TRUE, _msgEndCallBack);
    }
    else if(pRet->result == _SB_CREATE_START){
        // ǂɌ鉉oJn
        _EVENT_DRILL_WORK * mdw;
        if(_pCommSecretBaseWork->pFSys->event==NULL){
            mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_DRILL_WORK));
            mdw->seq = _DRILL_ANIM;
            mdw->index = 0;
            mdw->netID = CommGetCurrentID();  // JnۂID ꂪH狭I
            FieldEvent_Set(_pCommSecretBaseWork->pFSys, _GMEVENT_Drill, mdw);
        } 
    }
    else if(pRet->result == _SB_CREATE_FAILED){  //̌łقȂ
        FieldSystemProc_SeqHoldEnd();
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_55, TRUE, _msgEndCallBack);
    }
    else{ //    // MAPCHANGE     // ʐMؒf
        _Pos outDoorPos;
        int x = CommPlayerGetGridXDirAdd(pRet->netID);
        int z = CommPlayerGetGridZDirAdd(pRet->netID);
        int dir = CommPlayerGetDir(pRet->netID);
        _insertBaseNetID(x, z, dir, pRet->netID);        // 쐬
        _insertBaseNetID(x, z, dir, _SECRETBASE_MY_ID);  // 쐬
        SecretBaseRecordSetRelocateNum(pRec);  // z񐔃JEg
    }
}


//==============================================================================
/**
 * @brief   閧nɍs󋵃bZ[WԂ
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

BOOL CommSecretBaseInfoGetActionMessage(STRBUF* pStrBuf)
{
    int i;
    WORDSET* pWordSetMain;  //[hZbg\
    STRBUF* tmp_buf1;
    BOOL bRet = FALSE;

    if(!_pCommSecretBaseWork){
        return bRet;
    }
    for(i = 0; i< COMM_MACHINE_MAX; i++){
        if(_pCommSecretBaseWork->travelingBaseMessage[i] != _INVALID_BASE){
            pWordSetMain = WORDSET_Create(HEAPID_FIELD);
            tmp_buf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
            WORDSET_RegisterPlayerName(  pWordSetMain, CURRENT_PLAYER_WORD_IDX, CommInfoGetMyStatus(i));
            WORDSET_RegisterPlayerName(  pWordSetMain, CURRENT_PLAYER_WORD_IDX, CommInfoGetMyStatus(i));  //
            MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderWorld()), UGSecretBaseIn01, tmp_buf1 );
            WORDSET_ExpandStr( pWordSetMain, pStrBuf, tmp_buf1 );
            _pCommSecretBaseWork->travelingBaseMessage[i] = _INVALID_BASE;
            STRBUF_Delete( tmp_buf1 );
            WORDSET_Delete(pWordSetMain);
            bRet = TRUE;
        }
    }
    return bRet;
}

//==============================================================================
/**
 * @brief   ZbgAbv閧nObYf[^Ԃ
 * @param   sv  SAVEDATA*
 * @retval  SECRETBASEDATA*
 */
//==============================================================================

SECRETBASEDATA* UgSetupSecretBaseData(SAVEDATA * sv)
{
    if(_pCommSecretBaseWork){
        if(_pCommSecretBaseWork->pNowMoveingBase){
            return (SECRETBASEDATA*)_pCommSecretBaseWork->pNowMoveingBase->secretBaseDataBuff;
        }
//        return SaveData_GetSecretBaseData(sv);
    }
    return NULL;
}

//==============================================================================
/**
 * @brief   ZbgAbv閧nXubNԂ
 * @param   none
 * @retval  XObh
 */
//==============================================================================

int UgSetupSecretBaseBlockX(void)
{
    if(_pCommSecretBaseWork){
        if(_pCommSecretBaseWork->pNowMoveingBase){
            return _blockToRoomX[_pCommSecretBaseWork->pNowMoveingBase->netID];
        }
    }
    return 0;
}

//==============================================================================
/**
 * @brief   ZbgAbv閧nZubNԂ
 * @param   none
 * @retval  ZObh
 */
//==============================================================================

int UgSetupSecretBaseBlockZ(void)
{
    if(_pCommSecretBaseWork){
        if(_pCommSecretBaseWork->pNowMoveingBase){
            return _blockToRoomZ[_pCommSecretBaseWork->pNowMoveingBase->netID];
        }
    }
    return 0;
}

//==============================================================================
/**
 * @brief   閧nObYɓĂȂǂ
 * @param   x,z ʒu
 * @retval  ꍇTRUE
 */
//==============================================================================

BOOL UgSecretBaseMoveing(int x, int z)
{
    int blockX,blockZ,i;

    if(!_pCommSecretBaseWork){
        return TRUE;
    }
    if(z >= (_SECRETBASE_ATTR_MAX*2)){
        return TRUE;
    }
    blockX = x / _SECRETBASE_ATTR_MAX;
    blockZ = z / _SECRETBASE_ATTR_MAX;
    
    for(i = 0; i < _SECRETBASE_NUM_MAX;i++){
        if((blockX == _blockToRoomX[i]) &&
           (blockZ == _blockToRoomZ[i])){
            blockX = x % _SECRETBASE_ATTR_MAX;
            blockZ = z % _SECRETBASE_ATTR_MAX;
            if(_pCommSecretBaseWork->aAttr[i][blockZ] & (0x1 << blockX)){
                return TRUE;
            }
            else{
                return FALSE;
            }
        }
    }
    return TRUE;
}

//==============================================================================
/**
 * @brief   VKɕꍇ₾炯ɂ
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _createSecretBase(void)
{
    SECRETBASEDATA* pSBData = SaveData_GetSecretBaseData(GameSystem_GetSaveData(_pCommSecretBaseWork->pFSys));
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(_pCommSecretBaseWork->pFSys));
    int px = CommPlayerGetGridSXDirAdd(COMM_PARENT_ID);
    int pz = CommPlayerGetGridSZDirAdd(COMM_PARENT_ID);
    int dir = CommPlayerGetSDir(COMM_PARENT_ID);
    int i, ansX, ansZ, bOk, chk;
    const int x1 = 10,x2 = 18,z = 12, xMod = 5, zMod=6;
    MATHRandContext32 sRand;
    int add[SECRETBASE_LOCK_NUM_MAX+1][2];

    add[0][0] = 16; // p\RƂԂʒu
    add[0][1] = 12;

    SecretBaseData_Init(pSBData);  // zuĂȂԂɂ
    UnderGroundTrashAllGoodsPCItem(pUGData);

    CommRandSeedInitialize(&sRand);
    for(i = 0; i < SECRETBASE_LOCK_NUM_MAX; i++){
        ansX = MATH_Rand32(&sRand, xMod);
        if(ansX < 2){
            ansX = ansX * 2 + x1;
        }
        else{
            ansX = (ansX-3) * 2 + x2;
        }
        ansZ = MATH_Rand32(&sRand, zMod) * 2 + z;
        OHNO_PRINT(" %d %d\n",ansX,ansZ);
        bOk=TRUE;
        for(chk = 0; chk <= i; chk++){
            if((add[chk][0] == ansX) && (add[chk][1] == ansZ)){
                bOk = FALSE;
                break;
            }
        }
        if(!bOk){
            i--;
            continue;
        }
        SecretBaseData_ChangeGoodsPosition(pSBData,
                                           SECRETBASE_GOODS_NUM_MAX + SECRETBASE_PC_NUM_MAX+i,
                                           ansX, ansZ);
        add[i+1][0] = ansX;
        add[i+1][1] = ansZ;
    }

    MI_CpuFill8(_pCommSecretBaseWork->aAttr, 0xff,  _SECRETBASE_NUM_MAX * _SECRETBASE_ATTR_MAX * (_SECRETBASE_ATTR_MAX/8) );
    SecretBaseSetSecretBasePosition(pSBData,px,pz,CommPlayerGetReverseDir(dir));
    MI_CpuCopy8(pSBData,_pCommSecretBaseWork->secretBaseData[_SECRETBASE_MY_ID].secretBaseDataBuff,_SECLET_BASE_DATA_SIZE);
    // 
    _makeAttr(pSBData,_pCommSecretBaseWork->aAttr[_SECRETBASE_MY_ID]);
}

//--------------------------------------------------------------
/**
 * @brief   悤bZ[WJn
 * @param   messageNo   gmmx
 * @retval  bZ[WCfbNX
 */
//--------------------------------------------------------------

int UgSecretBaseTalkStart(int messageNo)
{
    return CommMsgTalkWindowStart(CommUnderGetMsgUnderEdit(),messageNo,FALSE,NULL);

}

//--------------------------------------------------------------
/**
 * @brief   悤̉bI
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void UgSecretBaseTalkEnd(void)
{
    CommMsgTalkWindowEnd(CommUnderGetMsgUnderEdit());
}

//--------------------------------------------------------------
/**
 * @brief   ObY̖ObZ[Wɕ\ꍇ̊֐
 * @param   type     ObY^Cv = gmmԍ
 * @retval  none
 */
//--------------------------------------------------------------

void UgSecretBaseTalkRegisterGoodsName(int type)
{
    CommMsgRegisterUGGoodsNameIndex(CommUnderGetMsgUnderEdit(),0,type);
}

//--------------------------------------------------------------
/**
 * @brief   Q̐bZ[Wɕ\ꍇ̊֐
 * @param   number     
 * @param   index      bZ[WɏĂԍ
 * @retval  none
 */
//--------------------------------------------------------------

void UgSecretBaseTalkRegisterNum2(int number,int index)
{
    CommMsgRegisterNumber2Index(CommUnderGetMsgUnderEdit(),index,number);
}

//--------------------------------------------------------------
/**
 * @brief   ObYڂ̑Oɂ邩ǂ
 * @param   type     ObY^Cv = gmmԍ
 * @retval  none
 */
//--------------------------------------------------------------

BOOL UgSecretBaseGoodsCheck(int netID, Grid* pTouch)
{
    int x = pTouch->xpos;
    int z = pTouch->zpos;

    if(UgSecretBaseMoveing(x,z) == FALSE){
        u8 id = netID;
        CommSendFixSizeData_ServerSide(CF_SECRETBASE_GOODS_CHECK,&id);
        return TRUE;
    }
    return FALSE;


}

//--------------------------------------------------------------
/**
 * @brief   ObYڂ̑Oɂ̂ŒʐMĂ CF_SECRETBASE_GOODS_CHECK
 * @param   R[obN
 * @retval  none
 */
//--------------------------------------------------------------

void UgSecretBaseRecvGoodsCheck(int netID, int size, void* pData, void* pWork)
{
    SECRETBASEDATA* pSecret = (SECRETBASEDATA*)_pCommSecretBaseWork->pNowMoveingBase->secretBaseDataBuff;
    SB_RECORD_DATA* pRec = SecretBaseGetSecretBaseRecord(pSecret);

    UgRecordRandomMessage(pRec);
}

