//=============================================================================
/**
 * @file	ug_shop.c
 * @brief	n̂X̒gǗNX
 * @author	Katsumi Ohno
 * @date    2006.3.9
 */
//=============================================================================

#include "common.h"

#include "../fieldsys.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/window.h"
#include "system/wipe.h"
#include "system/clact_tool.h"
#include "system/menu_gra.naix"

#include "../fld_bmp.h"

#include "msgdata/msg_underworld.h"
#include "msgdata/msg_undergroundtrap.h"
#include "msgdata/msg_undergrounditem.h"
#include "msgdata/msg_undergroundgoods.h"
#include "msgdata/msg_uwflag.h"
#include "msgdata/msg_uwbuy.h"
#include "msgdata/msg_uwpersonal.h"
#include "msgdata/msg.naix"

#include "communication/communication.h"
#include "ug_manager.h"

#include "../ev_mapchange.h"
#include "gflib/camera.h"
#include "../fieldmap.h"
#include "../fld_bmp.h"
#include "../field_clact.h"
#include "system/snd_tool.h"
#include "savedata/undergrounddata.h"

#include "../../fielddata/base_goods/goods_id_def.h"
#include "ug_trapshopdata.h"
#include "../goods_data.h"
#include "ug_local.h"

extern u8 MsgSpeedGet(void);
extern u8 TalkWinNumGet(void);

//==============================================================================
//	萔`
//==============================================================================

#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY

#define	_SUB_MENU_MAX		( 7 )					// ڍő吔

#define	_TRAP_BAG_MAX      (20)
#define	_STONE_BAG_MAX     (20)
#define	_GOODS_BAG_MAX     (20)
#define	_TREASURE_BAG_MAX  (20)

#define _TRAP_COMPUTER_MAX      (200)
#define _STONE_COMPUTER_MAX     (200)
#define _GOODS_COMPUTER_MAX     (200)
#define _TREASURE_COMPUTER_MAX  (200)


//==============================================================================
//	\̒`
//==============================================================================



//==============================================================================
//	^錾
//==============================================================================


//==============================================================================
//	static`
//==============================================================================

static const BMPWIN_DAT _yesNoBmpDat = {
    FLD_MBGFRM_FONT, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
    FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
    };

static void _shopStoneDispWindow(_START_WORK* pShop);
static void _shopHandInfoDispWindow(_START_WORK* pShop,int msg);
static void _shopHandInfoDispWindowDel(_START_WORK* pShop);
static void _ugMenuShopEnd(_START_WORK* pShop);


//==============================================================================
/**
 * Ȃ̏ij[쐬
 * @param   pShop   [Nj[|C^
 * @retval  void
 */
//==============================================================================

static void _trapShopListCreate(_START_WORK* pShop,int personal)
{
    MATHRandContext16 rand;
    int type,max,min,j,i;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pShop->pFSys));
    
    MATH_InitRand16(&rand, UnderGroundGetDayRandSeed(pUGData) + personal);

    for(i = 0;i < _SHOP_BUY_LIST_MAX; i++){
        type = MATH_Rand16(&rand,UG_TRAPTYPE_MAX-1)+1;
        for(j = 0;j < i; j++){
            if(pShop->item[j] == type){
                type = UG_TRAPTYPE_NONE;
            }
        }
        if(type == UG_TRAPTYPE_NONE){
            i--;
            continue;
        }
        pShop->item[i] = type;
        pShop->stone[i] = TrapShopGetChangeStoneType(type);
        if(pShop->stone[i] == STONE_TYPE_MAX){  // _
            pShop->stone[i] = MATH_Rand16(&rand,STONE_TYPE_MAX-1)+1;
        }
        min = TrapShopGetChangeStoneCaratMin(type);
        max = TrapShopGetChangeStoneCaratMax(type);
        pShop->carat[i] = MATH_Rand16(&rand, max-min)+min;
    }

}

//==============================================================================
/**
 * ObY̏ij[쐬
 * @param   pShop   [Nj[|C^
 * @retval  void
 */
//==============================================================================

static void _goodsShopListCreate(_START_WORK* pShop,int personal)
{
    MATHRandContext16 rand;
    int type,max,min,j,i;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pShop->pFSys));
    
    MATH_InitRand16(&rand, UnderGroundGetDayRandSeed(pUGData) + personal);

    for(i = 0;i < _SHOP_BUY_LIST_MAX; i++){
        type = MATH_Rand16(&rand,GOODS_TYPE_MAX-1)+1;
        for(j = 0;j < i; j++){
            if(pShop->item[j] == type){
                type = GOODS_NONE;
            }
        }
        if(type == GOODS_NONE){
            i--;
            continue;
        }
        pShop->item[i] = type;
        pShop->stone[i] = GOODS_GetGoodsChangeStoneType(type);
        if(pShop->stone[i] == STONE_TYPE_NONE){  // Xł͔ĂȂ̂
            i--;
            continue;
        }
        else if(pShop->stone[i] == STONE_TYPE_MAX){  // _
            pShop->stone[i] = MATH_Rand16(&rand,STONE_TYPE_MAX-1)+1;
        }
        min = GOODS_GetGoodsChangeStoneCaratMin(type);
        max = GOODS_GetGoodsChangeStoneCaratMax(type);
        pShop->carat[i] = MATH_Rand16(&rand, max-min)+min;
    }
}

//==============================================================================
/**
 * ܂ƕ̌
 * @param   pShop   [Nj[|C^
 * @retval  void
 */
//==============================================================================

static int _shopExec(_START_WORK* pShop, int selectIndex,int stoneIndex)
{
    BOOL result = FALSE;
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pShop->pFSys));
    
    if(pShop->stone[selectIndex] != _underBagGetStoneID(stoneIndex, pShop)){
        return UG_SHOP_MISS_SELECT;
    }
    if(pShop->carat[selectIndex] > _underBagGetStoneCarat(stoneIndex, pShop)){
        return UG_SHOP_CARAT_SMALL;
    }
    if(pShop->bTrapShop){
        result = UnderGroundAddTrapBagItem(pUGData, pShop->item[selectIndex]);
    }
    else{
        result = UnderGroundAddGoodsBagItem(pUGData, pShop->item[selectIndex]);
    }
    if(result){   // ܂Ƃ
        UnderGroundDelStoneBagItem(pUGData ,stoneIndex);
    }
    else{
        return UG_SHOP_BAG_FULL;
    }
    return pShop->item[selectIndex];
}

//==============================================================================
/**
 * ȂObỸj[o
 * @param   pTalk   [Nj[|C^
 * @retval  [N|C^
 */
//==============================================================================

#define _TRAPMENU_POSX    (19)
#define _TRAPMENU_POSY    (1)
#define _TRAPMENU_SIZE_X  (12)

static void* _shopSelectMenuInit( _START_WORK* pShop )
{
    BMPLIST_HEADER list_h;
    const int LISTMAX = 3;  // Xg̍ő

    _startMenuEnd(pShop);
    //BMPEBhE
    pShop->menulist = BMP_MENULIST_Create( LISTMAX, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pShop->pFSys->bgl, &pShop->win,
                     GF_BGL_FRAME3_M, _TRAPMENU_POSX, _TRAPMENU_POSY, _TRAPMENU_SIZE_X, LISTMAX*2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(14*LISTMAX*2));
    BmpMenuWinWrite(&pShop->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		int i,msg;

        if(pShop->bTrapShop){
            msg = mes_uw_buy_13;
            _trapShopListCreate(pShop,pShop->personal);
        }
        else{
            msg = mes_uw_buy_16;
            _goodsShopListCreate(pShop,pShop->personal);
        }
        BMP_MENULIST_AddArchiveString( pShop->menulist, CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), msg, 0 );
        BMP_MENULIST_AddArchiveString( pShop->menulist, CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), msg+1, 1 );
        BMP_MENULIST_AddArchiveString( pShop->menulist, CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), msg+2, BMPLIST_CANCEL  );
	}
    MI_CpuCopy8( CommMsgGetNormalBmpListHeader(), &list_h, sizeof(BMPLIST_HEADER));
    list_h.list = pShop->menulist;
    list_h.win = &pShop->win;
    list_h.count = LISTMAX;
    list_h.line = LISTMAX;
    pShop->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pShop->win);
    Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
    return pShop;
}

//==============================================================================
/**
 * J[\ɂ܂̃bZ[Wς
 * @param   pTalk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _cursorChangeDisp(BMPLIST_WORK * wk,u32 param,u8 mode)
{
    _START_WORK* pShop = (_START_WORK*)BmpListParamGet(wk, BMPLIST_ID_WORK);
    int idx = param;
    if(param == BMPLIST_CANCEL){
        return;
    }
	GF_BGL_BmpWinDataFill( &pShop->winSub, FBMP_COL_WHITE );
    
    MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), mes_uw_buy_23 + pShop->bBuy, pShop->pStrBuf1 );   // ID
    GF_STR_PrintSimple(&pShop->winSub, FONT_SYSTEM,
                       pShop->pStrBuf1, 1, 1, 0, NULL);


    WORDSET_RegisterUGItemName(pShop->pWordSet, 2, pShop->stone[idx] );
    WORDSET_RegisterNumber(pShop->pWordSet, 6,
                           pShop->carat[idx], 2,
                           NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
    MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), mes_uw_buy_25, pShop->pStrBuf1 );   // ID
    WORDSET_ExpandStr(pShop->pWordSet, pShop->pStrBuf2, pShop->pStrBuf1 );
    GF_STR_PrintSimple(&pShop->winSub, FONT_SYSTEM, pShop->pStrBuf2, 1, 17, 0, NULL);

}

//==============================================================================
/**
 * J[\ɂ܂̃bZ[Wς
 * @param   pTalk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _recycleShopDisp(BMPLIST_WORK * wk,u32 param,u8 mode)
{
    MATHRandContext16 rand;
    _START_WORK* pShop = (_START_WORK*)BmpListParamGet(wk, BMPLIST_ID_WORK);
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pShop->pFSys));
    int idx = param,min,max;
    int type, stone, carat;
    
    if(param == BMPLIST_CANCEL){
        return;
    }
	GF_BGL_BmpWinDataFill( &pShop->winSub, FBMP_COL_WHITE );
    
    if(pShop->bTrapShop){
        type = _underBagGetTrapID(idx, pShop);
        MATH_InitRand16(&rand, UnderGroundGetDayRandSeed(pUGData) + pShop->personal + type);
        stone = TrapShopGetChangeStoneType(type);
        if(stone == STONE_TYPE_MAX){  // _
            stone= MATH_Rand16(&rand,STONE_TYPE_MAX-1)+1;
        }
        min = TrapShopGetChangeStoneCaratMin(type);
        max = TrapShopGetChangeStoneCaratMax(type);
        carat = MATH_Rand16(&rand, max-min)+min;
    }
    else{
        type = _underBagGetGoodsID(idx, pShop);
        MATH_InitRand16(&rand, UnderGroundGetDayRandSeed(pUGData) + pShop->personal + type);
        stone = GOODS_GetGoodsChangeStoneType(type);
        if(stone == STONE_TYPE_MAX){  // _
            stone= MATH_Rand16(&rand,STONE_TYPE_MAX-1)+1;
        }
        min = GOODS_GetGoodsChangeStoneCaratMin(type);
        max = GOODS_GetGoodsChangeStoneCaratMax(type);
        carat = MATH_Rand16(&rand, max-min)+min;
    }

    if(stone != STONE_TYPE_NONE){ 

        WORDSET_RegisterUGItemName(pShop->pWordSet, 2, stone );
        WORDSET_RegisterNumber(pShop->pWordSet, 6,
                               carat, 2,
                               NUMBER_DISPTYPE_SPACE, NUMBER_CODETYPE_DEFAULT);
        MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), mes_uw_buy_25, pShop->pStrBuf1 );   // ID
        WORDSET_ExpandStr(pShop->pWordSet, pShop->pStrBuf2, pShop->pStrBuf1 );
        GF_STR_PrintSimple(&pShop->winSub, FONT_SYSTEM, pShop->pStrBuf2, 1, 17, 0, NULL);
    }
    else{
        MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), mes_uw_buy_26, pShop->pStrBuf1 );   // ܂
        GF_STR_PrintSimple(&pShop->winSub, FONT_SYSTEM, pShop->pStrBuf1, 1, 17, 0, NULL);
    }
    pShop->stone[0] = stone;
    pShop->carat[0] = carat;

    MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), mes_uw_buy_23 + pShop->bBuy, pShop->pStrBuf1 );   // ID
    GF_STR_PrintSimple(&pShop->winSub, FONT_SYSTEM,
                       pShop->pStrBuf1, 1, 1, 0, NULL);


}

//==============================================================================
/**
 * X̃j[o
 * @param   pTalk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _shopMenuInit( _START_WORK* pShop)
{
    BMPLIST_HEADER list_h;
    const int LISTMAX = _SHOP_BUY_LIST_MAX + 1;  // Xg̍ő

    _startMenuEnd(pShop);
    //BMPEBhE
    pShop->menulist = BMP_MENULIST_Create( LISTMAX, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pShop->pFSys->bgl, &pShop->win,
                     GF_BGL_FRAME3_M, _TRAPMENU_POSX, _TRAPMENU_POSY, _TRAPMENU_SIZE_X, LISTMAX*2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(14*LISTMAX*2));
    BmpMenuWinWrite(&pShop->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i;

        if(pShop->bTrapShop){
            msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergroundtrap_dat, HEAPID_FIELD);
        }
        else{
            msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undergroundgoods_dat, HEAPID_FIELD);
        }
        for(i = 0 ; i < LISTMAX-1 ; i++) {
            BMP_MENULIST_AddArchiveString( pShop->menulist, msgman, pShop->item[i], i );
        }
        BMP_MENULIST_AddArchiveString( pShop->menulist, msgman, 0, BMPLIST_CANCEL );
		MSGMAN_Delete(msgman);
	}
    MI_CpuCopy8( CommMsgGetNormalBmpListHeader(), &list_h, sizeof(BMPLIST_HEADER));
    list_h.list = pShop->menulist;
    list_h.win = &pShop->win;
    list_h.count = LISTMAX;
    list_h.line = LISTMAX;
    list_h.call_back = _cursorChangeDisp;
    list_h.work = pShop;
    pShop->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pShop->win);
    Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
}

//--------------------------------------------------------------
/**
 * @brief   n̂X̃j[I
 * @param   none
 * @retval  noen
 */
//--------------------------------------------------------------
static void  _shopMenuEnd(_START_WORK* pShop, BOOL bSubWin)
{
    if(bSubWin){
        BmpMenuWinClear(&pShop->winSub, WINDOW_TRANS_OFF );
        GF_BGL_BmpWinDel(&pShop->winSub);
    }
    _startMenuEnd(pShop);
}

//--------------------------------------------------------------
/**
 * @brief   邩̊mFj[o
 * @param   index  Iꏊ
 * @retval  none
 */
//--------------------------------------------------------------

static void _yesNoWindowOpen(int index, _START_WORK* pShop)
{
    int type;

    if(pShop->bTrapShop){
        type = _underBagGetTrapID(index, pShop);
        UgShopTalkRegisterTrapName(2,type);
    }
    else{
        type = _underBagGetGoodsID(index, pShop);
        UgShopTalkRegisterGoodsName(2,type);
    }
    UgShopTalkRegisterItemName(4,pShop->stone[0]);
    pShop->msgIndex = UgShopTalkStart(mes_uw_buy_10);
}

//--------------------------------------------------------------
/**
 * @brief   s
 * @param   pShop  ̃j[̃[N|C^
 * @retval  ʂ̔ԍ
 */
//--------------------------------------------------------------

static u32 _sellExec(_START_WORK* pShop)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pShop->pFSys));

    if(CommUnderBagAddStone(pShop->stone[0],pShop->carat[0])){
        if(pShop->bTrapShop){
            UnderGroundDelTrapBagItem(pUGData, pShop->work);
        }
        else{
            UnderGroundDelGoodsBagItem(pUGData, pShop->work);
        }
        return pShop->stone[0];
    }
    return UG_SHOP_BAG_FULL;
}

//--------------------------------------------------------------
/**
 * @brief   n̂X̃j[̏Ԃ𓾂
 * @param   pWork  ̃j[̃[N|C^
 * @retval  ʂ̔ԍ UgShopReturnCode_e
 */
//--------------------------------------------------------------

enum{
    _SHOP_SELECT_OPEN,
    _SHOP_SELECT_FUNC,
    _SHOP_MENU_OPEN,
    _SHOP_MENU_FUNC,
    _STONE_MENU_OPEN,
    _STONE_MENU_FUNC,
    _DESIDE_MSG_WAIT,
    _BAG_MENU_OPEN,
    _BAG_MENU_FUNC,
    _YESNO_CHECK,
    _YESNO_CHECK_WAIT,
    _SELL_MESSAGE_WAIT,
};

int UgShopMenuFuncAndCheck(void* pWork)
{
    _START_WORK* pShop = pWork;
    u32	ret = UG_SHOP_NONE;
    u32	retcode = UG_SHOP_NONE;

    switch(pShop->seq){
      case _SHOP_SELECT_OPEN:
        _shopSelectMenuInit(pShop);
        pShop->seq = _SHOP_SELECT_FUNC;
        break;
      case _SHOP_SELECT_FUNC:
        ret = BmpListMain(pShop->lw);
        switch(ret){
          case BMPLIST_CANCEL:
            OHNO_PRINT("LZ---------------\n");
            _shopMenuEnd(pShop,FALSE);
            _ugMenuShopEnd(pShop);
            return UG_SHOP_CANCEL;
          case BMPLIST_NULL:
            break;
          default:
            pShop->bBuy = ret;
            if(ret == 0){  // 
                pShop->seq = _SHOP_MENU_OPEN;
            }
            else{  // 
                pShop->seq = _BAG_MENU_OPEN;
            }
            break;
        }
        break;
      case _SHOP_MENU_OPEN:
        _shopStoneDispWindow(pShop);
        _shopMenuInit(pShop);
        pShop->seq = _SHOP_MENU_FUNC;
        break;
      case _SHOP_MENU_FUNC:
        ret = BmpListMain(pShop->lw);
        switch(ret){
          case BMPLIST_CANCEL:
            BmpMenuWinClear(&pShop->winSub, WINDOW_TRANS_OFF );
            GF_BGL_BmpWinDel(&pShop->winSub);
            _startMenuEnd(pShop);
            pShop->seq = _SHOP_SELECT_OPEN;
            break;
          case BMPLIST_NULL:
            break;
          default:
            pShop->seq = _STONE_MENU_OPEN;
            pShop->work = ret;  // pShop->itemindexĂ
            OHNO_PRINT("΃j[J\n");
            break;
        }
        break;
      case _STONE_MENU_OPEN:
        _startMenuEnd(pShop);
        _stoneMenuStart_Bag(pShop);
        _shopHandInfoDispWindow(pShop,mes_uw_buy_19);
        pShop->msgIndex = UgShopTalkStart(mes_uw_buy_02);
        pShop->seq = _STONE_MENU_FUNC;
        break;
      case _STONE_MENU_FUNC:
        if( GF_MSG_PrintEndCheck( pShop->msgIndex ) == 0 ){
            ret = BmpListMain(pShop->lw);
            switch(ret){
              case BMPLIST_CANCEL:
                _shopHandInfoDispWindowDel(pShop);
                pShop->seq = _SHOP_MENU_OPEN;
                break;
              case BMPLIST_NULL:
                break;
              default:
                ret = _shopExec(pShop,pShop->work,ret);
                _shopMenuEnd(pShop,TRUE);
                _shopHandInfoDispWindowDel(pShop);
                if(ret & 0x8000){
                    _ugMenuShopEnd(pShop);
                    retcode = ret;
                }
                else{
                    pShop->work = ret;
                    UgShopTalkStart(mes_uw_buy_03);
                    pShop->seq = _DESIDE_MSG_WAIT;
                }
                break;
            }
        }
        break;
      case _DESIDE_MSG_WAIT:
        if( GF_MSG_PrintEndCheck( pShop->msgIndex ) == 0 ){
            if(sys.trg & PAD_BUTTON_DECIDE){
                if(pShop->bTrapShop){
                    UgShopTalkRegisterTrapName(2,pShop->work);
                }
                else{
                    UgShopTalkRegisterGoodsName(2,pShop->work);
                }
                UgShopTalkStart(mes_uw_buy_07_1);
                _ugMenuShopEnd(pShop);
                retcode = pShop->work;
            }
        }
        break;
      case _BAG_MENU_OPEN:
        _shopStoneDispWindow(pShop);
        pShop->pLineCallBack = _recycleShopDisp;
        if(pShop->bTrapShop){
            _trapMenuStart_Bag(pShop);
            _shopHandInfoDispWindow(pShop,mes_uw_buy_20);
        }
        else{
            _goodsMenuStart_Bag(pShop);
            _shopHandInfoDispWindow(pShop,mes_uw_buy_21);
        }
        pShop->seq = _BAG_MENU_FUNC;
        break;
      case _BAG_MENU_FUNC:
        ret = BmpListMain(pShop->lw);
        switch(ret){
          case BMPLIST_CANCEL:
            BmpMenuWinClear(&pShop->winSub, WINDOW_TRANS_OFF );
            GF_BGL_BmpWinDel(&pShop->winSub);
            _shopHandInfoDispWindowDel(pShop);
            _startMenuEnd(pShop);
            pShop->seq = _SHOP_SELECT_OPEN;
            break;
          case BMPLIST_NULL:
            break;
          default:
            pShop->work = ret;  // pShop->itemindexĂ
            _shopMenuEnd(pShop,TRUE);
            _shopHandInfoDispWindowDel(pShop);
            _yesNoWindowOpen(ret, pShop);
            pShop->seq = _YESNO_CHECK;
            break;
        }
        break;
      case _YESNO_CHECK:
        if( GF_MSG_PrintEndCheck( pShop->msgIndex ) == 0 ){
            pShop->pYesNoWork =
                BmpYesNoSelectInit( pShop->pFSys->bgl,
                                    &_yesNoBmpDat,
                                    MENU_WIN_CGX_NUM, MENU_WIN_PAL, HEAPID_FIELD );
            pShop->seq = _YESNO_CHECK_WAIT;
        }
        break;
      case _YESNO_CHECK_WAIT:
        ret = BmpYesNoSelectMain(pShop->pYesNoWork, HEAPID_FIELD);
        if(ret == BMPMENU_NULL){  // ܂I
            return retcode;
        }else if(ret == 0){ // ͂Iꍇ
            ret = _sellExec(pShop);
            if(ret & 0x8000){
                retcode = ret;
            }
            else{
                UgShopTalkStart(mes_uw_buy_11);
                pShop->seq = _SELL_MESSAGE_WAIT;
                break;
            }
        }
        else{  // Iꍇ
            retcode = UG_SHOP_CANCEL;
        }
        _ugMenuShopEnd(pShop);
//        UgShopTalkEnd();
        break;
      case _SELL_MESSAGE_WAIT:
        if( GF_MSG_PrintEndCheck( pShop->msgIndex ) == 0 ){
            if(sys.trg & PAD_BUTTON_DECIDE){
                CommMsgRegisterNumber2(CommUnderGetMsgUnderShop(),pShop->carat[0]);
                UgShopTalkRegisterItemName(2,pShop->stone[0]);
                UgShopTalkStart(mes_uw_buy_07_2);
                _ugMenuShopEnd(pShop);
                retcode = pShop->work;
            }
        }
      default:
        OHNO_PRINT("Wvԍ %d \n",pShop->seq);
        break;
    }
    return retcode;
}

//--------------------------------------------------------------
/**
 * @brief   J
 * @param   pShop   [N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _ugMenuShopEnd(_START_WORK* pShop)
{
    STRBUF_Delete(pShop->pStrBuf1);
    STRBUF_Delete(pShop->pStrBuf2);
    WORDSET_Delete(pShop->pWordSet);
    sys_FreeMemoryEz(pShop);
}

//--------------------------------------------------------------
/**
 * @brief   X̏ij[J
 * @param   bTrapShop   㩂̂X̏ꍇTRUE ObY̏ꍇFALSE
 * @param   FIELDSYS_WORK   tB[hVXe[N|C^
 * @retval  ̃j[̃[N|C^
 */
//--------------------------------------------------------------

void* UgShopMenuInit(BOOL bTrapShop, FIELDSYS_WORK* pFSys)
{
    BMPLIST_HEADER list_h;
    _START_WORK* pShop;
    const int LISTMAX = 6;  // Xg̍ő

    pShop = sys_AllocMemory(HEAPID_FIELD, sizeof(_START_WORK));
    MI_CpuFill8(pShop, 0, sizeof(_START_WORK));
    pShop->pFSys = pFSys;
    pShop->bTrapShop = bTrapShop;
    pShop->personal = 0;   // @@OOXNvg󂯎
    pShop->pStrBuf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pShop->pStrBuf2 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
    pShop->pWordSet = WORDSET_Create( HEAPID_FIELD );
    _shopSelectMenuInit(pShop);
    pShop->seq = _SHOP_SELECT_FUNC;
    return pShop;
}

//--------------------------------------------------------------
/**
 * @brief   X̉bJn
 * @param   messageNo   gmmx
 * @retval  bZ[WCfbNX
 */
//--------------------------------------------------------------

int UgShopTalkStart(int messageNo)
{
    CommMsgChangeMSGMAN(CommUnderGetMsgUnderShop(),NARC_msg_uwbuy_dat);
    return CommMsgTalkWindowStart(CommUnderGetMsgUnderShop(),messageNo,FALSE,NULL);

}

//--------------------------------------------------------------
/**
 * @brief   X̉bI
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void UgShopTalkEnd(void)
{
    CommMsgTalkWindowEnd(CommUnderGetMsgUnderShop());
}

//--------------------------------------------------------------
/**
 * @brief   ACe̖OX̉bɓo^
 * @param   index    Ԃregist̂
 * @param   type     gmmԍ
 * @retval  none
 */
//--------------------------------------------------------------

void UgShopTalkRegisterItemName(int index,int type)
{
    CommMsgRegisterUGItemNameIndex(CommUnderGetMsgUnderShop(),index,type);
}

//--------------------------------------------------------------
/**
 * @brief   㩂̖OX̉bɓo^
 * @param   index    Ԃregist̂
 * @param   type     gmmԍ
 * @retval  none
 */
//--------------------------------------------------------------

void UgShopTalkRegisterTrapName(int index,int type)
{
    CommMsgRegisterUGTrapNameIndex(CommUnderGetMsgUnderShop(),index,type);
}

//--------------------------------------------------------------
/**
 * @brief   ObY̖OX̉bɓo^
 * @param   index    Ԃregist̂
 * @param   type     gmmԍ
 * @retval  none
 */
//--------------------------------------------------------------

void UgShopTalkRegisterGoodsName(int index,int type)
{
    CommMsgRegisterUGGoodsNameIndex(CommUnderGetMsgUnderShop(),index,type);
}

//==============================================================================
/**
 * 炦^} Kvȃ^} EChE
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _shopStoneDispWindow(_START_WORK* pShop)
{

    //BMPEBhE
    GF_BGL_BmpWinAdd(pShop->pFSys->bgl, &pShop->winSub,
                     GF_BGL_FRAME3_M, 1, 12, 12, 4, FLD_SYSFONT_PAL, 1);
    BmpMenuWinWrite(&pShop->winSub, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );

	GF_BGL_BmpWinDataFill( &pShop->winSub, FBMP_COL_WHITE );
    GF_BGL_BmpWinOn(&pShop->winSub);

}

//==============================================================================
/**
 * Ă̂  EChE
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _shopHandInfoDispWindow(_START_WORK* pShop, int msg)
{
    //BMPEBhE
    GF_BGL_BmpWinAdd(pShop->pFSys->bgl, &pShop->winSub2,
                     GF_BGL_FRAME3_M, 1, 1, 7, 4, FLD_SYSFONT_PAL, 51);
    BmpMenuWinWrite(&pShop->winSub2, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );

	GF_BGL_BmpWinDataFill( &pShop->winSub2, FBMP_COL_WHITE );
    GF_BGL_BmpWinOn(&pShop->winSub2);

    MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderShop()), msg, pShop->pStrBuf1 );   // ID
    GF_STR_PrintSimple(&pShop->winSub2, FONT_SYSTEM, pShop->pStrBuf1, 1, 1, 0, NULL);

}

//==============================================================================
/**
 * Ă̂  EChE
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _shopHandInfoDispWindowDel(_START_WORK* pShop)
{
    BmpMenuWinClear(&pShop->winSub2, WINDOW_TRANS_OFF );
    GF_BGL_BmpWinDel(&pShop->winSub2);
}

