//=============================================================================
/**
 * @file	ug_talk.c
 * @brief	nbǗNX
 * @author	Katsumi Ohno
 * @date    2005.12.19
 */
//=============================================================================


#include "common.h"

#include "../fieldsys.h"
#include "system/bmp_menu.h"
#include "system/bmp_list.h"
#include "system/fontproc.h"
#include "system/window.h"
#include "system/snd_tool.h"

#include "../fld_bmp.h"
#include "system/wordset.h"

#include "msgdata/msg_underworld.h"
#include "msgdata/msg_undersecretquestion.h"
#include "msgdata/msg_undersecretanswer.h"
#include "msgdata/msg.naix"

#include "communication/communication.h"
#include "ug_manager.h"



//==============================================================================
//	萔`
//==============================================================================

#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY
#define _MENU_UG_PRI  (10000)   // j[̃^XNpriorty

#define _QUESTION_LIST_NUM   (4)   // \鎿␔
#define _QUESTION_LIST_MAX   (12)   // ő
#define _QUESTION_LIST_BOTH  (50)    // I񂾏ꍇ
#define _QUESTION_LIST_CANCEL  (51)  // ɓȂꍇ


typedef enum{
    _TALK_SEQ_NONE,
    _TALK_INIT,            // b
    _TALK_MENU,            // j[oĂ
    _MSG_PLUS_TALK_END,    // bZ[WoāAb߂
    _TALK_END,             // b߂
    _TALK_CARD_WAIT,       // J[hĂ炨Ƒҋ@
    _TALK_REJECT_CARD,     // J[ĥ
    _TALK_TALKCHEKCEND,    // b̏I҂ďI
    _TALK_CANCELASKER_END,  // p̂ŏIꍇ
    _TALK_CARD_DISP,
    _TALK_CARD_DISP_WAIT,
    _TALK_CARD_DISP_FIN,
    _TALK_CARD_FIN_WAIT,
    _TALK_CARD_CALLBACK_WAIT,
    _TALK_NEXT,
    _TALK_WAIT_NEXT,
    _TALK_ITEMMENU_OPEN,
    _TALK_ITEMMENU_WAIT,
    _TALK_ITEMMENU_END,
    _TALK_ITEM_SEND_CHECK,
    _TALK_ITEM_SEND_CHECK_WAIT,
    _TALK_ITEM_SEND_ASK_WAIT,
    _TALK_ITEM_SEND_OK,
    _TALK_ITEM_SEND_NO,
    _TALK_ITEM_SEND_OK_ZINGLE,
    _TALK_ITEMEND_TIMING,
    _TALK_QES_CATEGORY,  // JeS[I
    _TALK_QES_CATEGORY_LIST,    // j[
    _TALK_QES_CATEGORY_LIST_WAIT,  // I
    _TALK_QES_CATEGORY_WAIT,
    _TALK_QES_CATEGORY_RECV,
    _TALK_CATCH_ANSWER,
    _TALK_ANSWER_LIST_INIT,
    _TALK_ANSWER_LIST_WAIT,
    _TALK_QES_END_WAIT,
    _TALK_QES_END_WAIT2,
    _TALK_QES_END_WAIT3,
};

typedef enum{
    _ASK_SEQ_NONE,
    _ASK_INIT,             // bꂽ
    _ASK_WAIT,             // bꒆ
    _MSG_PLUS_ASK_END,    
    _ASK_END,
    _ASK_CARD,
    _ASK_CARD_WAIT,        // J[h悤v
    _ASK_CARD_YESNO_WAIT,
    _ASK_CANCELTALK_END,
    _ASK_TALKCHEKCEND,   // b̏I҂ďI
    _ASK_CARD_DISP,
    _ASK_CARD_DISP_WAIT,
    _ASK_CARD_DISP_FIN,
    _ASK_CARD_FIN_WAIT,
    _ASK_CARD_CALLBACK_WAIT,
    _ASK_NEXT,
    _ASK_WAIT_NEXT,
    _ASK_RECV_ITEM,
    _ASK_RECV_ITEM_YESNO_WAIT,
    _ASK_ITEM_RECVED,
    _ASK_ITEM_RECVED_WAIT,
    _ASK_ITEM_RECVED_WAIT_END,

    _ASK_QES_START,
    _ASK_QES_RECV_WAIT,
    _ASK_QES_CATEGORY_MSG,
    _ASK_QES_ANSWER_LIST,
    _ASK_ANSWERED_WAIT,
    _ASK_ANSERED_RETURN,
    _ASK_ANSERED_RETURN_WAIT,
    _ASK_SECRET_TALK_END,
    _ASK_SECRET_TALK_END2,
};


typedef enum{
    _QUESTION_TALK,
    _ANSWER_ASK,
    _ANSWER_TALK,
} QuestionType_e;

//==============================================================================
//	\̒`
//==============================================================================

typedef struct{
    u8 netID;
    u8 seq;
} _SEQ_COMMAND;


typedef struct{
    u8 no;
    u8 targetID;
    u8 questionType;
} _SECRET_QUESTION_COMMAND;


typedef struct{
    u8 netID;
    u8 itemType;
    u8 itemNo;
} _ITEMSEND_COMMAND;


// b󋵍\
typedef struct{
    FIELDSYS_WORK* pFSys;
    GF_BGL_BMPWIN  win;		// BMPEBhE[N
	BMPLIST_DATA*  menulist;
    BMPLIST_WORK*  lw;		// BMPj[[N
    BMPMENU_WORK*  pYesNoWork;
    _ITEMSEND_COMMAND sendItem;  // 󂯎\̃ACe
    pEndFunc endfunc;
    u16 connectIndex;  // Ȃe@INDEX
    int msgIndex;
    u8 list_id;
    u8 list_ans;
    u8 waitMode;
    u8 endState;
    u8 work;
    u8 seq;        // ̃V[PX
    u8 reqSeq;     // 肩痈V[PX
} _TALK_WORK;


static _TALK_WORK* _pTalkWork = NULL;

// b󋵍\
typedef struct{
    TCB_PTR tcb;
    FIELDSYS_WORK* pFSys;
    GF_BGL_BMPWIN  win;		// BMPEBhE[N
	BMPLIST_DATA*  menulist;
    BMPLIST_WORK*  lw;		// BMPj[[N
    BMPMENU_WORK*  pYesNoWork;
    _ITEMSEND_COMMAND recvItem;  // 󂯎\̃ACe
    pEndFunc endfunc;
    u16 connectIndex;  // Ȃe@INDEX
    int msgIndex;
    u8 list_id;
    u8 list_ans;
    u8 waitMode;
    u8 endState;
    u8 work;
    u8 seq;        // ̃V[PX
    u8 reqSeq;     // 肩痈V[PX
} _ASK_WORK;


static _ASK_WORK* _pAskWork = NULL;


//==============================================================================
//	^錾
//==============================================================================
typedef void (*pTalkFunc)(_TALK_WORK *);

//==============================================================================
//	static`
//==============================================================================

static void _mainFunc(TCB_PTR tcb, void* work);
static BOOL _talkMenuFunc(TCB_PTR tcb, void* work);
static void _talkMenuEnd(TCB_PTR tcb, _TALK_WORK* pTalk);
static void _cardStart(_TALK_WORK* pTalk);
static void _trapSet( _TALK_WORK* pTalk );
static void _questionStart( _TALK_WORK* pTalk );
static void _sendItem( _TALK_WORK* pTalk );
static void _talkExit( _TALK_WORK* pTalk );


//==============================================================================
//	bj[Xgpf[^
//==============================================================================

static const struct {
	u32  str_id;
	u32  param;
}MenuParamList[] = {
    { msg_underworld_04, (u32)_cardStart },
    { msg_underworld_05, (u32)_questionStart },
    { msg_underworld_06, (u32)_sendItem },
    { msg_underworld_07, (u32)_talkExit },
};

///͂ȂIj[̃Xg
static const BMPLIST_HEADER TalkMenuListHeader = {
    NULL,			// \f[^|C^
    NULL,					// J[\ړƂ̃R[obN֐
    NULL,					// \Ƃ̃R[obN֐
    NULL,					// 
    NELEMS(MenuParamList),	// Xgڐ
    NELEMS(MenuParamList),	// \ő區ڐ
    0,						// x\wW
    8,						// ڕ\wW
    0,						// J[\\wW
    0,						// \xW
    FBMP_COL_BLACK,			// F
    FBMP_COL_WHITE,			// wiF
    FBMP_COL_BLK_SDW,		// eF
    0,						// Ԋuw
    16,						// Ԋux
    BMPLIST_LRKEY_SKIP,		// y[WXLbv^Cv
    FONT_SYSTEM,				// w
    0,						// afJ[\(allow)\tO(0:ON,1:OFF)
    NULL,                   // [N
};

//==============================================================================
//	YesNoj[Xgpf[^
//==============================================================================
static const BMPWIN_DAT _yesNoBmpDat = {
    GF_BGL_FRAME3_M, FLD_YESNO_WIN_PX, FLD_YESNO_WIN_PY,
    FLD_YESNO_WIN_SX, FLD_YESNO_WIN_SY, FLD_YESNO_WIN_PAL, FLD_YESNO_WIN_CGX
    };


//==============================================================================
// ֐
//==============================================================================

//--------------------------------------------------------------
/**
 * @brief   bɃR}h𑗐M
 * @param   netID  bID
 * @param   seq    
 * @retval  none
 */
//--------------------------------------------------------------

static void _seqTalkCommandSend(_ASK_WORK* pWork, int seq)
{
    _SEQ_COMMAND seqComm;

    seqComm.netID = pWork->connectIndex;
    seqComm.seq = seq;
    CommSendFixSizeData(CF_TALKSEQ_SET, &seqComm);
}

//--------------------------------------------------------------
/**
 * @brief   bꑤɃR}h𑗐M
 * @param   netID  bꑤID
 * @param   seq    
 * @retval  none
 */
//--------------------------------------------------------------

static void _seqAskCommandSend(_TALK_WORK* pWork, int seq)
{
    _SEQ_COMMAND seqComm;

    seqComm.netID = pWork->connectIndex;
    seqComm.seq = seq;
    CommSendFixSizeData(CF_ASKSEQ_SET, &seqComm);
}

//--------------------------------------------------------------
/**
 * @brief   b
 * @param   pWork  [N|C^
 * @param   no     bԍ
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkTalk(_TALK_WORK* pWork,int no)
{
    pWork->msgIndex =
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), no, FALSE, NULL);
}

//--------------------------------------------------------------
/**
 * @brief   b
 * @param   pWork  [N|C^
 * @param   no     bԍ
 * @retval  none
 */
//--------------------------------------------------------------

static void _askTalk(_ASK_WORK* pWork,int no)
{
    pWork->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                             no, FALSE, NULL);
}

//--------------------------------------------------------------
/**
 * @brief   bbJn
 * @param   targetID  bꑤID
 * @param   func      IɌĂяo
 * @param   pFSys     tB[hVXe|C^
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkInit(int targetID, pEndFunc func, FIELDSYS_WORK* pFSys)
{
    _TALK_WORK* pTalk;
    BMPLIST_HEADER list_h;

    pTalk = sys_AllocMemory(HEAPID_UNDERGROUND, sizeof(_TALK_WORK));
    MI_CpuFill8(pTalk, 0, sizeof(_TALK_WORK));
    _pTalkWork = pTalk;
    pTalk->pFSys = pFSys;
    pTalk->endfunc = func;
    pTalk->connectIndex = targetID;   // bIDۑ
    pTalk->seq = _TALK_INIT;
    pTalk->reqSeq = _TALK_SEQ_NONE;
    pTalk->sendItem.itemType = 0;
    pTalk->sendItem.itemNo = 0;
    pTalk->sendItem.netID = pTalk->connectIndex;

    _talkTalk(pTalk, msg_underworld_01);
    TCB_Add(_mainFunc, pTalk, _MENU_UG_PRI);
    SecretBaseRecordSetTalkNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(pFSys)),targetID); // bJn
}

//==============================================================================
/**
 * b̃j[o
 * @param   pTalk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _talkMenuInit(_TALK_WORK* pTalk)
{
    BMPLIST_HEADER list_h;

    //BMPEBhE
    pTalk->menulist = BMP_MENULIST_Create( NELEMS(MenuParamList), HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pTalk->pFSys->bgl,&pTalk->win,
                     GF_BGL_FRAME3_M, 1, 1, 10, NELEMS(MenuParamList)*2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(10*NELEMS(MenuParamList)*2));
    BmpMenuWinWrite(&pTalk->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i;

		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_underworld_dat, HEAPID_FIELD);
		for(i=0; i<NELEMS(MenuParamList); i++)
		{
			BMP_MENULIST_AddArchiveString( pTalk->menulist, msgman, MenuParamList[i].str_id, MenuParamList[i].param );
		}
		MSGMAN_Delete(msgman);
	}

    MI_CpuCopy8( CommMsgGetNormalBmpListHeader(), &list_h, sizeof(BMPLIST_HEADER));
    list_h.list = pTalk->menulist;
    list_h.win = &pTalk->win;
    list_h.count = NELEMS(MenuParamList);
    list_h.line = NELEMS(MenuParamList);
    
    pTalk->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pTalk->win);
    FieldSystemProc_SeqHold();
    Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
}

//--------------------------------------------------------------
/**
 * @brief   bԏI
 * @param   tcb			TCBւ̃|C^
 * @param   pTalk		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkEnd(TCB_PTR tcb, _TALK_WORK* pTalk)
{
    _talkMenuEnd(tcb, pTalk);
    if(pTalk->endfunc){
        pTalk->endfunc(0);
    }
    sys_FreeMemoryEz(pTalk);
    FieldSystemProc_SeqHoldEnd();
    TCB_Delete(tcb);
//    sys_DeleteHeap(HEAPID_UNDERGROUND);
    _pTalkWork = NULL;
}


//==============================================================================
/**
 * R[i[ WI
 * @param   pTalk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _categoryMenuInit(_TALK_WORK* pTalk)
{
    BMPLIST_HEADER list_h;

    //BMPEBhE
    pTalk->menulist = BMP_MENULIST_Create( _QUESTION_LIST_NUM, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pTalk->pFSys->bgl,&pTalk->win,
                     GF_BGL_FRAME3_M, 1, 1, 16, _QUESTION_LIST_NUM*2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(16*_QUESTION_LIST_NUM*2));
    BmpMenuWinWrite(&pTalk->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i, j;
        u8 sList[_QUESTION_LIST_NUM];
		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undersecretquestion_dat, HEAPID_FIELD);
		for(i = 0; i < _QUESTION_LIST_NUM; i++) {
            u32 rand = gf_mtRand() % _QUESTION_LIST_MAX;
            for(j = 0; j < i; j++) {
                if((sList[j] == rand)){
                    break;
                }
            }
            if(j==i){
                sList[i] = rand;
                BMP_MENULIST_AddArchiveString( pTalk->menulist, msgman,
                                               msg_uw_ask_que_01 + rand, rand );
            }
            else{
                i--;
            }
		}
		MSGMAN_Delete(msgman);
	}

    list_h = TalkMenuListHeader;
    list_h.list = pTalk->menulist;
    list_h.win = &pTalk->win;
    pTalk->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pTalk->win);
    Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
}

//--------------------------------------------------------------
/**
 * @brief   JeS[߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _categoryMenuFunc(TCB_PTR tcb, void* work)
{
    _TALK_WORK* pTalk = work;
    u32	ret;

    ret = BmpListMain(pTalk->lw);
    if(CommIsError()){  // G[̓LZɂ
        pTalk->seq = _MSG_PLUS_TALK_END;
        _talkMenuEnd(tcb, pTalk);
        return TRUE;
    }
    switch(ret){
    case BMPLIST_CANCEL:
    case BMPLIST_NULL:
        return FALSE;
        break;
    default:
        {
            _SECRET_QUESTION_COMMAND comm;
            comm.no = ret;
            comm.targetID = pTalk->connectIndex;
            comm.questionType = _QUESTION_TALK;
            CommSendFixSizeData(CF_SECRET_QUESTION, &comm);
            pTalk->list_id = ret; // j[
            pTalk->seq = _TALK_QES_CATEGORY_WAIT;
            _talkMenuEnd(tcb, pTalk);
        }
        break;
    }
    return TRUE;
}

//==============================================================================
/**
 * R[i[ WI
 * @param   pAsk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _talkReturnAnswerListInit(_TALK_WORK* pTalk)
{
    BMPLIST_HEADER list_h;

    //BMPEBhE
    pTalk->menulist = BMP_MENULIST_Create( _QUESTION_LIST_NUM, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pTalk->pFSys->bgl,&pTalk->win,
                     GF_BGL_FRAME3_M, 1, 1, 16, _QUESTION_LIST_NUM*2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(16*_QUESTION_LIST_NUM*2));
    BmpMenuWinWrite(&pTalk->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i;
		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undersecretanswer_dat, HEAPID_FIELD);
		for(i = 0; i < _QUESTION_LIST_NUM; i++) {
            u32 ans = _QUESTION_LIST_NUM * pTalk->list_id + i;
			BMP_MENULIST_AddArchiveString( pTalk->menulist, msgman,
                                           msg_uw_ask_ans_01_01 + ans, i );
		}
		MSGMAN_Delete(msgman);
	}

    list_h = TalkMenuListHeader;
    list_h.list = pTalk->menulist;
    list_h.win = &pTalk->win;
    pTalk->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pTalk->win);
    Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
}

//--------------------------------------------------------------
/**
 * @brief   JeS[߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _talkReturnAnswerListFunc(TCB_PTR tcb, void* work)
{
    _TALK_WORK* pTalk = work;
    u32	ret;
    _SECRET_QUESTION_COMMAND comm;

    ret = BmpListMain(pTalk->lw);
    if(CommIsError()){  // G[͏ɏI
        _talkMenuEnd(tcb, pTalk);
        pTalk->seq = _MSG_PLUS_TALK_END;
        return TRUE;
    }
    switch(ret){
    case BMPLIST_NULL:
    case BMPLIST_CANCEL:   //LZ
        return FALSE;
    default:
        _talkMenuEnd(tcb, pTalk);
        comm.no = (ret + pTalk->list_id * _QUESTION_LIST_NUM);
        comm.targetID = pTalk->connectIndex;
        comm.questionType = _ANSWER_TALK;
        CommSendFixSizeData(CF_SECRET_QUESTION , &comm);
        if(pTalk->list_ans == comm.no){
            // 
            _talkTalk(pTalk, msg_uw_ask_06);
        }
        else{
            CommMsgRegisterSecretAnswerName(CommUnderGetMsgUnderWorld(), comm.no);
            _talkTalk(pTalk, msg_uw_ask_05);
        }
        pTalk->seq = _TALK_QES_END_WAIT;
        _seqAskCommandSend(pTalk, _ASK_ANSERED_RETURN);// 
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   ACebZ[W\
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkItemSendedTalk(_TALK_WORK* pTalk)
{
    CommMsgRegisterTargetName(CommUnderGetMsgUnderWorld(), CommInfoGetMyStatus(pTalk->connectIndex));
    CommMsgRegisterUGGoodsName(CommUnderGetMsgUnderWorld(), pTalk->sendItem.itemNo);
    pTalk->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                             msg_underworld_15 ,FALSE, NULL);
    SecretBaseRecordSetSendItemNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(pTalk->pFSys))); //= ACe
    UgBagDeleteGoods(pTalk->sendItem.itemNo);

}

//--------------------------------------------------------------
/**
 * @brief   nACeI
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _sendItemTalk(_TALK_WORK* pTalk, int itemNo)
{
    CommMsgRegisterUGGoodsName(CommUnderGetMsgUnderWorld(), itemNo);
    pTalk->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                             msg_underworld_13 ,FALSE, NULL);
}

//--------------------------------------------------------------
/**
 * @brief   ACe邩ǂŏImF
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _sendItemYesNoCheck(TCB_PTR tcb, _TALK_WORK* pTalk)
{
    u32	ret;
    
    ret = BmpYesNoSelectMain(pTalk->pYesNoWork, HEAPID_FIELD);
    if(ret == 0){ // ͂Iꍇ
        //̕Ԏ҂
        // @@OO Ƀj[lKv
//        pTalk->sendItem.itemType = 0;
//        pTalk->sendItem.itemNo = 0;
        pTalk->sendItem.netID = pTalk->connectIndex;
        CommSendFixSizeData(CF_SEND_ITEM, &pTalk->sendItem);
        pTalk->seq = _TALK_ITEM_SEND_ASK_WAIT;
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        // A܂ǂł[
        _talkTalk(pTalk, msg_underworld_12);
        // ͓ɕωȂ
        pTalk->seq = _TALK_WAIT_NEXT;
    }
}

//--------------------------------------------------------------
/**
 * @brief   b߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _talkMenuFunc(TCB_PTR tcb, void* work)
{
    _TALK_WORK* pTalk = work;
    u32	ret;

    ret = BmpListMain(pTalk->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:
        _talkExit(pTalk);
        _talkMenuEnd(tcb, pTalk);
        break;
    default:
        {
            pTalkFunc func = (pTalkFunc)ret;
            func(pTalk);  // ֐Wv
            _talkMenuEnd(tcb, pTalk);
        }
        break;
    }
    return TRUE;
}

//--------------------------------------------------------------
/**
 * @brief   bIj[Xg
 * @param   tcb			TCBւ̃|C^
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkMenuEnd(TCB_PTR tcb, _TALK_WORK* pTalk)
{
    if(pTalk->menulist){
        BmpMenuWinClear(&pTalk->win, WINDOW_TRANS_ON );
        BmpListExit(pTalk->lw, NULL, NULL);
        GF_BGL_BmpWinOff(&pTalk->win);
        GF_BGL_BmpWinDel(&pTalk->win);
        BMP_MENULIST_Delete(pTalk->menulist);
        pTalk->menulist=NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   b\X^[g
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _cardStart(_TALK_WORK* pTalk)
{
    _seqAskCommandSend(pTalk, _ASK_CARD);
    _talkTalk(pTalk, msg_underworld_08);
    pTalk->seq = _TALK_CARD_WAIT;
}

//--------------------------------------------------------------
/**
 * @brief   㩐ݒu
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _questionStart( _TALK_WORK* pTalk )
{
    _seqAskCommandSend(pTalk, _ASK_QES_START);
    pTalk->seq = _TALK_QES_CATEGORY;
}

//--------------------------------------------------------------
/**
 * @brief   ACe
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _sendItem( _TALK_WORK* pTalk )
{
    pTalk->seq = _TALK_ITEMMENU_OPEN;
}

//--------------------------------------------------------------
/**
 * @brief   ObYj[I
 * @param   selectNo  IObY̔ԍ
 * @retval  none
 */
//--------------------------------------------------------------
static void _goodsMenuEndFunc(int selectNo)
{
    _pTalkWork->sendItem.itemNo = selectNo;
    _pTalkWork->seq = _TALK_ITEMMENU_END;
}

//--------------------------------------------------------------
/**
 * @brief   J[hIۂɌĂ΂R[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _talkCardDispCallback(void* pWork)
{
    _TALK_WORK* pTalk = pWork;
    pTalk->seq = _TALK_CARD_DISP_FIN;
}

//--------------------------------------------------------------
/**
 * @brief   bV[PXC
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _mainFunc(TCB_PTR tcb, void* work)
{
    _TALK_WORK* pTalk = work;
    u32	ret;

    if (pTalk->seq != _TALK_ITEMMENU_WAIT){
        if(!CommIsConnect(pTalk->connectIndex)){
            OHNO_PRINT("b̉ؒf\n");
            pTalk->seq = _TALK_END;
        }
    }
    
    switch(pTalk->seq){
      case _TALK_INIT:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            _talkMenuInit(pTalk);
            pTalk->seq++;
        }
        break;
      case _TALK_MENU:
        _talkMenuFunc(tcb, work);
        break;
      case _MSG_PLUS_TALK_END:
      case _TALK_END:
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        _talkEnd(tcb, pTalk);
        break;
      case _TALK_CARD_WAIT:
        // ̕Ԏ҂
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if(pTalk->reqSeq  == _TALK_CARD_DISP){
                pTalk->seq = _TALK_CARD_DISP;
                UgRecordSendMyData(pTalk->connectIndex);
            }
            if(pTalk->reqSeq == _TALK_REJECT_CARD){
                pTalk->seq = _TALK_REJECT_CARD;
            }
        }
        break;
      case _TALK_CANCELASKER_END:
        _talkTalk(pTalk, msg_underworld_17);
        pTalk->seq = _TALK_TALKCHEKCEND;
        break;
      case _TALK_REJECT_CARD:
        _talkTalk(pTalk, msg_underworld_09);
        pTalk->seq = _TALK_TALKCHEKCEND;
        break;
      case _TALK_TALKCHEKCEND:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if(PAD_BUTTON_DECIDE & sys.trg){
                pTalk->seq = _TALK_END;
            }
        }
        break;
      case _TALK_CARD_DISP:
        if(UgRecordIsTargetRecord()){
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
            UgRecordStatusListStart(pTalk->pFSys->bgl,
                                    CommInfoGetMyStatus(pTalk->connectIndex),
                                    _talkCardDispCallback,
                                    pTalk, FALSE);
            pTalk->seq = _TALK_CARD_DISP_WAIT;
        }
        break;
      case _TALK_CARD_DISP_WAIT:
        break;
      case _TALK_CARD_DISP_FIN:
        // g[i[J[h{I
        UgRecordResetTargetRecord();
        _talkTalk(pTalk, msg_underworld_10);
        pTalk->seq = _TALK_CARD_FIN_WAIT;
        break;
      case _TALK_CARD_FIN_WAIT:  // MSGEND҂
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            _seqAskCommandSend(pTalk, _ASK_CARD_CALLBACK_WAIT);  // ɏI𑗐M
            pTalk->seq = _TALK_CARD_CALLBACK_WAIT;
        }
        break;
      case _TALK_CARD_CALLBACK_WAIT:  // 肩̗v҂
        if( pTalk->reqSeq ==  _TALK_CARD_CALLBACK_WAIT){
            pTalk->seq = _TALK_NEXT;
        }
        break;
      case _TALK_NEXT:
        _talkTalk(pTalk, msg_underworld_11);  // قɂȂɂH
        pTalk->seq = _TALK_INIT;
        break;
      case _TALK_WAIT_NEXT:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if(PAD_BUTTON_DECIDE & sys.trg){
                pTalk->seq = _TALK_NEXT;
            }
        }
        break;
      case _TALK_ITEMMENU_OPEN:
        UgBagGoodsMenuStart(_goodsMenuEndFunc, pTalk->pFSys);
        pTalk->seq = _TALK_ITEMMENU_WAIT;
        break;
      case _TALK_ITEMMENU_WAIT:
        ///--------------------------------j[I ʐMG[łЂ炫ςȂ
        break;
      case _TALK_ITEMMENU_END:
        ///-------------------------------ACej[I
        if(_pTalkWork->sendItem.itemNo != UG_GOODS_NONE){
            _sendItemTalk(pTalk, _pTalkWork->sendItem.itemNo);  // ACe鎖ɂ
            pTalk->seq = _TALK_ITEM_SEND_CHECK;
        }
        else{
            _talkTalk(pTalk, msg_underworld_12);
            pTalk->seq = _TALK_WAIT_NEXT;
        }
        break;
      case _TALK_ITEM_SEND_CHECK:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            pTalk->pYesNoWork = BmpYesNoSelectInit(pTalk->pFSys->bgl,
                                                   &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                   MENU_WIN_PAL, HEAPID_FIELD );
            pTalk->seq = _TALK_ITEM_SEND_CHECK_WAIT;
        }
        break;
      case _TALK_ITEM_SEND_CHECK_WAIT:
        _sendItemYesNoCheck(tcb, pTalk);
        pTalk->reqSeq = _TALK_INIT;
        break;
      case _TALK_ITEM_SEND_ASK_WAIT:   // ACe𑊎ɑMAԎ҂
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if(pTalk->reqSeq  == _TALK_ITEM_SEND_OK){
                pTalk->seq = _TALK_ITEM_SEND_OK;
            }
            if(pTalk->reqSeq == _TALK_ITEM_SEND_NO){
                pTalk->seq = _TALK_ITEM_SEND_NO;
            }
        }
        break;
      case _TALK_ITEM_SEND_NO:  // ǂς󂯎Ȃ
        _talkTalk(pTalk, msg_underworld_14);
        pTalk->seq = _TALK_ITEMEND_TIMING;
        break;
      case _TALK_ITEM_SEND_OK:  // ACe𑊎肪ǉ
        _talkItemSendedTalk(pTalk);
        pTalk->seq = _TALK_ITEMEND_TIMING;
        break;
      case _TALK_ITEM_SEND_OK_ZINGLE:
        // @@OOŃACeWO炷
        pTalk->seq = _TALK_ITEMEND_TIMING;
        break;
      case _TALK_ITEMEND_TIMING:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if(pTalk->reqSeq == _TALK_WAIT_NEXT){
                pTalk->seq = _TALK_NEXT;
            }
        }
        break;
      case _TALK_QES_CATEGORY:
        _talkTalk(pTalk, msg_uw_ask_01);   // Ȃɂ́H
        pTalk->seq = _TALK_QES_CATEGORY_LIST;
        break;
      case _TALK_QES_CATEGORY_LIST:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            _categoryMenuInit(pTalk);
            pTalk->seq = _TALK_QES_CATEGORY_LIST_WAIT;
        }
        break;
      case _TALK_QES_CATEGORY_LIST_WAIT:
        _categoryMenuFunc(tcb, work);
        break;
      case _TALK_QES_CATEGORY_WAIT:
        CommMsgRegisterSecretQuestionName(CommUnderGetMsgUnderWorld(), pTalk->list_id);
        _talkTalk(pTalk, msg_uw_ask_02);
        pTalk->seq = _TALK_QES_CATEGORY_RECV;
        break;
      case _TALK_QES_CATEGORY_RECV:  //҂
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if( pTalk->reqSeq ==  _TALK_CATCH_ANSWER){
                pTalk->seq = _TALK_CATCH_ANSWER;
            }
        }
        break;
      case _TALK_CATCH_ANSWER:
        if(_QUESTION_LIST_CANCEL == pTalk->list_ans){
            _talkTalk(pTalk, msg_uw_ask_04);
            pTalk->reqSeq = 0;
            pTalk->seq = _TALK_WAIT_NEXT;
        }
        else{
            CommMsgRegisterSecretAnswerName(CommUnderGetMsgUnderWorld(), pTalk->list_ans);
            _talkTalk(pTalk, msg_uw_ask_03);
            pTalk->seq = _TALK_ANSWER_LIST_INIT;
        }
        break;
      case _TALK_ANSWER_LIST_INIT:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            _talkReturnAnswerListInit(pTalk);
            pTalk->seq = _TALK_ANSWER_LIST_WAIT;
        }
        break;
      case _TALK_ANSWER_LIST_WAIT:
        _talkReturnAnswerListFunc(tcb, work);
        break;
      case _TALK_QES_END_WAIT:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            _talkTalk(pTalk, msg_uw_ask_07);
            pTalk->seq = _TALK_QES_END_WAIT2;
        }
        break;
      case _TALK_QES_END_WAIT2:
        if( GF_MSG_PrintEndCheck( pTalk->msgIndex ) == 0 ){
            if(pTalk->reqSeq == _TALK_QES_END_WAIT2){
                _seqAskCommandSend(pTalk, _ASK_SECRET_TALK_END);  // ɏI𑗐M
                pTalk->seq = _TALK_QES_END_WAIT3;
            }
        }
        break;
      case _TALK_QES_END_WAIT3:
        if(pTalk->reqSeq == _TALK_QES_END_WAIT3){
            pTalk->seq = _TALK_NEXT;
        }
        break;
    }
    if(pTalk->reqSeq == _TALK_CANCELASKER_END){  // ً}~߂͑s
        pTalk->seq = _TALK_CANCELASKER_END;
        pTalk->reqSeq = _TALK_SEQ_NONE;
    }
}

//--------------------------------------------------------------
/**
 * @brief   b߂
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _talkExit( _TALK_WORK* pTalk )
{
    _talkTalk(pTalk,msg_underworld_16);
    _seqAskCommandSend(pTalk, _ASK_CANCELTALK_END);
    pTalk->seq = _TALK_TALKCHEKCEND;
}

//--------------------------------------------------------------
/**
 * @brief   J[h邩ǂ
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _selectCardInfoYesNoCheck(TCB_PTR tcb, _ASK_WORK* pAsk)
{
    u32	ret;
    
    ret = BmpYesNoSelectMain(pAsk->pYesNoWork, HEAPID_FIELD);
    if(ret == 0){ // ͂Iꍇ
        //npg[i[P[X̉ʂɂ
        _seqTalkCommandSend(pAsk, _TALK_CARD_DISP);
        UgRecordSendMyData(pAsk->connectIndex);// ɃR[h𑗂
        pAsk->seq = _ASK_CARD_DISP;
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        // I
        _seqTalkCommandSend(pAsk, _TALK_REJECT_CARD);
        pAsk->seq = _ASK_CANCELTALK_END;
    }
}


//--------------------------------------------------------------
/**
 * @brief   ACe炤ǂ
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _recvItemYesNoCheck(TCB_PTR tcb, _ASK_WORK* pAsk)
{
    u32	ret;
    
    ret = BmpYesNoSelectMain(pAsk->pYesNoWork, HEAPID_FIELD);
    if(ret == 0){ // ͂Iꍇ
        // ACeǉ
        // ACeǉKv
        CommUnderBagAddGoods(pAsk->recvItem.itemNo);
        SecretBaseRecordSetItemRecvNum(SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(pAsk->pFSys)));  // ACe
        _seqTalkCommandSend(pAsk, _TALK_ITEM_SEND_OK);
        pAsk->seq = _ASK_ITEM_RECVED;
    }
    else if(ret != BMPMENU_NULL){ // Iꍇ
        // I
        _seqTalkCommandSend(pAsk, _TALK_ITEM_SEND_NO);
        _askTalk(pAsk, msg_underworld_32);
        pAsk->seq = _ASK_ITEM_RECVED_WAIT_END;
    }
}

//--------------------------------------------------------------
/**
 * @brief   bԏI
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _askEnd(TCB_PTR tcb, _ASK_WORK* pAsk)
{
    if(pAsk->endfunc){
        pAsk->endfunc(0);
    }
    sys_FreeMemoryEz(pAsk);
    FieldSystemProc_SeqHoldEnd();
    TCB_Delete(tcb);
//    sys_DeleteHeap(HEAPID_UNDERGROUND);
    _pAskWork = NULL;
}

//--------------------------------------------------------------
/**
 * @brief   bIj[Xg
 * @param   tcb			TCBւ̃|C^
 * @param   pTalk		[N|C^
 * @retval  none
 */
//--------------------------------------------------------------

static void _askMenuEnd(TCB_PTR tcb, _ASK_WORK* pAsk)
{
    if(pAsk->menulist){
        BmpMenuWinClear(&pAsk->win, WINDOW_TRANS_ON );
        BmpListExit(pAsk->lw, NULL, NULL);
        GF_BGL_BmpWinOff(&pAsk->win);
        GF_BGL_BmpWinDel(&pAsk->win);
        BMP_MENULIST_Delete(pAsk->menulist);
        pAsk->menulist=NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   lexpandăbZ[W\
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _askNamePlusTalk(_ASK_WORK* pAsk, int targetID, int no)
{
    CommMsgRegisterTargetName(CommUnderGetMsgUnderWorld(), CommInfoGetMyStatus(targetID));
    pAsk->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                                no,FALSE,NULL);
}

//--------------------------------------------------------------
/**
 * @brief   ACebZ[W\
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _askItemRecvedTalk(_ASK_WORK* pAsk)
{
    CommMsgRegisterTargetName(CommUnderGetMsgUnderWorld(), CommInfoGetMyStatus(pAsk->connectIndex));
    CommMsgRegisterUGGoodsName(CommUnderGetMsgUnderWorld(), pAsk->recvItem.itemNo);
    pAsk->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                                msg_underworld_34 ,FALSE,NULL);

}

//==============================================================================
/**
 * R[i[ WI
 * @param   pAsk   [Nj[|C^
 * @retval  none
 */
//==============================================================================

static void _askQuestionListInit(_ASK_WORK* pAsk)
{
    BMPLIST_HEADER list_h;

    const int menuNum = _QUESTION_LIST_NUM + 1;
    
    //BMPEBhE
    pAsk->menulist = BMP_MENULIST_Create( menuNum, HEAPID_FIELD );
    GF_BGL_BmpWinAdd(pAsk->pFSys->bgl,&pAsk->win,
                     GF_BGL_FRAME3_M, 1, 1, 16, menuNum*2, FLD_SYSFONT_PAL,
                     FLD_MSG_WIN_CGX-(16*menuNum*2));
    BmpMenuWinWrite(&pAsk->win, WINDOW_TRANS_OFF, MENU_WIN_CGX_NUM, MENU_WIN_PAL );
	{
		MSGDATA_MANAGER* msgman;
		int i;
		msgman = MSGMAN_Create(MSGMAN_TYPE_NORMAL, ARC_MSG, NARC_msg_undersecretanswer_dat, HEAPID_FIELD);
		for(i = 0; i < _QUESTION_LIST_NUM; i++) {
            u32 ans = _QUESTION_LIST_NUM * pAsk->list_id + i;
			BMP_MENULIST_AddArchiveString( pAsk->menulist, msgman,
                                           msg_uw_ask_ans_01_01 + ans, i );
		}
        BMP_MENULIST_AddArchiveString( pAsk->menulist, msgman,
                                       msg_uw_ask_ans_cancel, _QUESTION_LIST_CANCEL );
		MSGMAN_Delete(msgman);
	}

    list_h = TalkMenuListHeader;
    list_h.list = pAsk->menulist;
    list_h.win = &pAsk->win;
	list_h.count = menuNum;		//Xgڐ
	list_h.line = menuNum;		//\ő區ڐ
    pAsk->lw = BmpListSet(&list_h, 0, 0, HEAPID_FIELD);
    GF_BGL_BmpWinOn(&pAsk->win);
    Snd_SePlay( SEQ_SE_DP_WIN_OPEN );
}

//--------------------------------------------------------------
/**
 * @brief   JeS[߂郁j[s
 * @param   tcb			TCBւ̃|C^
 * @param   work		[Nf[^̃|C^
 * @retval  none
 */
//--------------------------------------------------------------

static BOOL _askQuestionListFunc(TCB_PTR tcb, void* work)
{
    _ASK_WORK* pAsk = work;
    u32	ret;
    _SECRET_QUESTION_COMMAND comm;

    ret = BmpListMain(pAsk->lw);
    if(CommIsError()){  // G[̓LZɂ
        ret = BMPLIST_CANCEL;
    }
    switch(ret){
    case BMPLIST_NULL:
        return FALSE;
    case BMPLIST_CANCEL:   //
        ret = _QUESTION_LIST_CANCEL;
    default:
        _askMenuEnd(tcb, pAsk);
        if(ret != _QUESTION_LIST_CANCEL){
            pAsk->list_ans = (ret + pAsk->list_id * _QUESTION_LIST_NUM); // 
            pAsk->seq = _ASK_ANSWERED_WAIT;
            CommMsgRegisterSecretAnswerName(CommUnderGetMsgUnderWorld(), pAsk->list_ans);
            _askTalk(pAsk, msg_uw_ask_11);
        }
        else{
            pAsk->list_ans = _QUESTION_LIST_CANCEL;
            pAsk->seq = _ASK_WAIT_NEXT;
            _askTalk(pAsk, msg_uw_ask_10);
        }
        comm.no = pAsk->list_ans;
        comm.targetID = pAsk->connectIndex;
        comm.questionType = _ANSWER_ASK;
        CommSendFixSizeData(CF_SECRET_QUESTION , &comm);
        _seqTalkCommandSend(pAsk, _TALK_CATCH_ANSWER);
        break;
    }
    return TRUE;
}


//--------------------------------------------------------------
/**
 * @brief   J[hIۂɌĂ΂R[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _askCardDispCallback(void* pWork)
{
    _ASK_WORK* pAsk = pWork;
    pAsk->seq = _ASK_CARD_DISP_FIN;
}

//--------------------------------------------------------------
/**
 * @brief   bԊǗ
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

static void _askTask(TCB_PTR tcb, void* pWork)
{
    _ASK_WORK* pAsk = pWork;

    if(!CommIsConnect(pAsk->connectIndex)){
        OHNO_PRINT("b̉ؒf\n");
        pAsk->seq = _ASK_END;
    }
    switch(pAsk->seq){
      case _ASK_END:
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        _askEnd(tcb, pAsk);
        break;
      case _ASK_WAIT:
        pAsk->list_id = _QUESTION_LIST_MAX;
        if (sys.trg & PAD_BUTTON_B) {
            _seqTalkCommandSend(pAsk, _TALK_CANCELASKER_END);
            pAsk->seq = _ASK_CANCELTALK_END;
        }
        else if( pAsk->reqSeq ==  _ASK_CARD ){
            pAsk->seq = _ASK_CARD;
        }
        else if(pAsk->reqSeq ==  _ASK_QES_START ){
            pAsk->seq = _ASK_QES_START;
        }
        break;
      case _ASK_CARD:
        _askTalk(pAsk, msg_underworld_27);
        pAsk->seq = _ASK_CARD_WAIT;
        break;
      case _ASK_CARD_WAIT:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            pAsk->seq = _ASK_CARD_YESNO_WAIT;
            pAsk->pYesNoWork = BmpYesNoSelectInit(pAsk->pFSys->bgl,
                                                  &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                  MENU_WIN_PAL, HEAPID_FIELD );
        }
        break;
      case _ASK_CARD_YESNO_WAIT:
        _selectCardInfoYesNoCheck(tcb, pAsk);
        break;
      case _ASK_CANCELTALK_END:
        _askTalk(pAsk, msg_underworld_28);
        pAsk->seq = _ASK_TALKCHEKCEND;
        break;
      case _ASK_TALKCHEKCEND:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            if(PAD_BUTTON_DECIDE & sys.trg){
                pAsk->seq = _ASK_END;
            }
        }
        break;
      case _ASK_CARD_DISP:
        if(UgRecordIsTargetRecord()){
            CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
            UgRecordStatusListStart(pAsk->pFSys->bgl,
                                    CommInfoGetMyStatus(pAsk->connectIndex),
                                    _askCardDispCallback,
                                    pAsk, FALSE);
            pAsk->seq = _ASK_CARD_DISP_WAIT;
        }
        break;
      case _ASK_CARD_DISP_WAIT:
        break;
      case _ASK_CARD_DISP_FIN:
        // g[i[J[h{I
        UgRecordResetTargetRecord();
        _askNamePlusTalk(pAsk, pAsk->connectIndex, msg_underworld_29);
        pAsk->seq = _ASK_CARD_FIN_WAIT;
        break;
      case _ASK_CARD_FIN_WAIT:  // MSGEND҂
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            _seqTalkCommandSend(pAsk, _TALK_CARD_CALLBACK_WAIT);  // ɏI𑗐M
            pAsk->seq = _ASK_CARD_CALLBACK_WAIT;
        }
        break;
      case _ASK_CARD_CALLBACK_WAIT:  // 肩̗v҂
        if( pAsk->reqSeq ==  _ASK_CARD_CALLBACK_WAIT ){
            pAsk->seq = _ASK_NEXT;
        }
        break;
      case _ASK_NEXT:
        _askTalk(pAsk, msg_underworld_30);  // ́c
        pAsk->seq = _ASK_WAIT;
        break;
      case _ASK_WAIT_NEXT:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            if(PAD_BUTTON_DECIDE & sys.trg){
                pAsk->seq = _ASK_NEXT;
            }
        }
        break;
      case _ASK_RECV_ITEM:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            pAsk->seq = _ASK_RECV_ITEM_YESNO_WAIT;
            pAsk->pYesNoWork = BmpYesNoSelectInit(pAsk->pFSys->bgl,
                                                  &_yesNoBmpDat, MENU_WIN_CGX_NUM,
                                                  MENU_WIN_PAL, HEAPID_FIELD );
        }
        break;
      case _ASK_RECV_ITEM_YESNO_WAIT:
        _recvItemYesNoCheck(tcb, pAsk);
        break;
      case _ASK_ITEM_RECVED:
        _askItemRecvedTalk(pAsk);
        pAsk->seq = _ASK_ITEM_RECVED_WAIT;
        break;
      case _ASK_ITEM_RECVED_WAIT:
        // 󂯎WO}
        pAsk->seq = _ASK_ITEM_RECVED_WAIT_END;
        break;
      case _ASK_ITEM_RECVED_WAIT_END:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            if(PAD_BUTTON_DECIDE & sys.trg){
                _seqTalkCommandSend(pAsk, _TALK_WAIT_NEXT);
                pAsk->seq = _ASK_NEXT;
            }
        }
        break;
      case _ASK_QES_START:
        _askTalk(pAsk, msg_uw_ask_08);  // ˂
        pAsk->seq++;
        break;
      case _ASK_QES_RECV_WAIT:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            if(pAsk->list_id != _QUESTION_LIST_MAX){   // MĂ
                CommMsgRegisterSecretQuestionName(CommUnderGetMsgUnderWorld(), pAsk->list_id);
                _askTalk(pAsk, msg_uw_ask_09); 
                pAsk->seq = _ASK_QES_CATEGORY_MSG;
            }
        }
        break;
      case _ASK_QES_CATEGORY_MSG:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            _askQuestionListInit( pAsk );
            pAsk->seq = _ASK_QES_ANSWER_LIST;
        }
        break;
      case _ASK_QES_ANSWER_LIST:
        _askQuestionListFunc(tcb, pAsk);
        break;
      case _ASK_ANSWERED_WAIT:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            if( pAsk->reqSeq ==  _ASK_ANSERED_RETURN){
                _seqTalkCommandSend(pAsk, _TALK_QES_END_WAIT2);
                pAsk->seq = _ASK_ANSERED_RETURN;
            }
        }
        break;
      case _ASK_ANSERED_RETURN:
        if(pAsk->list_ans == _QUESTION_LIST_BOTH){
            _askTalk(pAsk, msg_uw_ask_13); 
        }
        else{
            CommMsgRegisterSecretAnswerName(CommUnderGetMsgUnderWorld(), pAsk->list_ans);
            _askTalk(pAsk, msg_uw_ask_12); 
        }
        pAsk->seq = _ASK_ANSERED_RETURN_WAIT;
        break;
      case _ASK_ANSERED_RETURN_WAIT:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            _askTalk(pAsk, msg_uw_ask_14);
            pAsk->seq = _ASK_SECRET_TALK_END;
        }
        break;
      case _ASK_SECRET_TALK_END:
        if( GF_MSG_PrintEndCheck( pAsk->msgIndex ) == 0 ){
            _seqTalkCommandSend(pAsk, _TALK_QES_END_WAIT3);  // ɏI𑗐M
            pAsk->seq = _ASK_SECRET_TALK_END2;
        }
        break;
      case _ASK_SECRET_TALK_END2:
        if(pAsk->reqSeq == _ASK_SECRET_TALK_END){   // 肩̏I҂
            pAsk->seq = _ASK_NEXT;
        }
        break;
    }
    if(pAsk->reqSeq == _ASK_CANCELTALK_END){  // ً}~߂͑s
        pAsk->seq = _ASK_CANCELTALK_END;
        pAsk->reqSeq = _ASK_SEQ_NONE;
    }
}


//--------------------------------------------------------------
/**
 * @brief   bԃR}h
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkBind(int askID, int talkID, FIELDSYS_WORK* pFSys)
{
    _ASK_WORK* pAsk;

    if(_pAskWork){
        CommMsgTalkWindowEnd(CommUnderGetMsgUnderWorld());
        _askEnd(_pAskWork->tcb, _pAskWork);
    }

    pAsk = sys_AllocMemory(HEAPID_UNDERGROUND, sizeof(_ASK_WORK));
    MI_CpuFill8(pAsk, 0, sizeof(_ASK_WORK));
    _pAskWork = pAsk;
    pAsk->pFSys = pFSys;
    pAsk->connectIndex = talkID;   // bIDۑ
    pAsk->seq = _ASK_WAIT;
    pAsk->reqSeq = _ASK_SEQ_NONE;
    pAsk->list_id = _QUESTION_LIST_MAX;
    pAsk->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                            msg_underworld_25 ,FALSE,NULL);
    FieldSystemProc_SeqHold();
    // bԂɂȂ
    pAsk->tcb = TCB_Add(_askTask, pAsk, _MENU_UG_PRI);
}

//--------------------------------------------------------------
/**
 * @brief   b̃V[PXύX閽߂
 * @command CF_ASKSEQ_SET
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkRecvAskSeq(int netID, int size, void* pData, void* pWork)
{
    CommSendFixSizeData_ServerSide(CF_ASKSEQ_SET_CALL,pData); // _CNgԐM
}

//--------------------------------------------------------------
/**
 * @brief   b̃V[PXύX閽߂
 * @command CF_TALKSEQ_SET
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkRecvTalkSeq(int netID, int size, void* pData, void* pWork)
{
    CommSendFixSizeData_ServerSide(CF_TALKSEQ_SET_CALL,pData); // _CNgԐM
}

//--------------------------------------------------------------
/**
 * @brief   b̃V[PXύX閽߂
 * @command CF_ASKSEQ_SET_CALL
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkRecvAskSeqCall(int netID, int size, void* pData, void* pWork)
{
    _SEQ_COMMAND* pSeq = pData;

    OHNO_PRINT("CommUnderTalkRecvAskSeqCall %d %d \n",pSeq->netID,pSeq->seq);

    if((CommGetCurrentID() == pSeq->netID) && (_pAskWork)){
        GF_ASSERT(size == sizeof(_SEQ_COMMAND));
        _pAskWork->reqSeq = pSeq->seq;
    }
}

//--------------------------------------------------------------
/**
 * @brief   b̃V[PXύX閽߂
 * @command CF_TALKSEQ_SET_CALL
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkRecvTalkSeqCall(int netID, int size, void* pData, void* pWork)
{
    _SEQ_COMMAND* pSeq = pData;

    if((CommGetCurrentID() == pSeq->netID) && (_pTalkWork)){
        GF_ASSERT(size == sizeof(_SEQ_COMMAND));
        GF_ASSERT(_pTalkWork!=NULL);
        OHNO_PRINT("TALKR}hĂ  %d \n",pSeq->seq);
        _pTalkWork->reqSeq = pSeq->seq;
    }
}

//--------------------------------------------------------------
/**
 * @brief   V[PXύX閽߂̃TCY
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

int CommUnderTalkGetSeqCommandSize(void)
{
    return sizeof(_SEQ_COMMAND);
}


//--------------------------------------------------------------
/**
 * @brief   ACe閽߂
 * @command CF_SEND_ITEM
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkRecvSendItem(int netID, int size, void* pData, void* pWork)
{
    CommSendFixSizeData_ServerSide(CF_SEND_ITEM_CALL,pData);
}

//--------------------------------------------------------------
/**
 * @brief   ACe閽߂
 * @command CF_SEND_ITEM_CALL
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void CommUnderTalkRecvSendItemCall(int netID, int size, void* pData, void* pWork)
{
    _ASK_WORK* pAsk = _pAskWork;
    _ITEMSEND_COMMAND* pSend = pData;

    if(CommGetCurrentID() != pSend->netID){
        return;
    }
    GF_ASSERT(_pAskWork!=NULL);
    if(pAsk->seq != _ASK_WAIT){   // ҋ@ԂłȂ΂ Bl
        _seqTalkCommandSend(pAsk, _TALK_CANCELASKER_END);  // ɏI𑗐M
        pAsk->seq = _ASK_CANCELTALK_END;
        return;
    }

    pAsk->recvItem.netID = pSend->netID;
    pAsk->recvItem.itemType = pSend->itemType;
    pAsk->recvItem.itemNo = pSend->itemNo;
    pAsk->seq = _ASK_RECV_ITEM;
    
    CommMsgRegisterUGGoodsName(CommUnderGetMsgUnderWorld(), pSend->itemNo);
    pAsk->msgIndex = CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(),
                                            msg_underworld_31 ,FALSE, NULL);
}

//--------------------------------------------------------------
/**
 * @brief   ACe閽߂̃TCY
 * @param   none
 * @retval  pPbgTCY
 */
//--------------------------------------------------------------

int CommUnderTalkGetSendItemSize(void)
{
    return sizeof(_ITEMSEND_COMMAND);
}

//--------------------------------------------------------------
/**
 * @brief   閧̎Ɋւ閽߂
 * @command CF_SECRET_QUESTION
 * @param   R[obNp[^
 * @retval  none
 */
//--------------------------------------------------------------

void UgTalkRecvSecretQ(int netID, int size, void* pData, void* pWork)
{
    CommSendFixSizeData_ServerSide(CF_SECRET_QUESTION_CALL, pData);
}

//--------------------------------------------------------------
/**
 * @brief   閧̎Ɋւ閽߂
 * @command CF_SECRET_QUESTION_CALL
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------

void UgTalkRecvSecretQCall(int netID, int size, void* pData, void* pWork)
{
    _ASK_WORK* pAsk = _pAskWork;
    _TALK_WORK* pTalk = _pTalkWork;
    _SECRET_QUESTION_COMMAND* pSQC = pData;

    if(pSQC->targetID == CommGetCurrentID()){
        switch(pSQC->questionType){
          case _QUESTION_TALK:
            pAsk->list_id = pSQC->no;  // ⍀
            break;
          case _ANSWER_ASK:
            pTalk->list_ans = pSQC->no;  // ⍀
            break;
          case _ANSWER_TALK:
            if(pAsk->list_ans == pSQC->no){
                pAsk->list_ans = _QUESTION_LIST_BOTH;  // ⍀
            }
            else{
                pAsk->list_ans = pSQC->no;
            }
            break;
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief   閧̎ʐMTCY
 * @param   none
 * @retval  pPbgTCY
 */
//--------------------------------------------------------------

int UgTalkGetSecretQSize(void)
{
    return sizeof(_SECRET_QUESTION_COMMAND);
}

