//=============================================================================
/**
 * @file	ug_trap.c
 * @brief	n㩏ۑNX
 * @author	Katsumi Ohno
 * @date    2005.09.28
 */
//=============================================================================


#include <nitro/os.h>
#include "common.h"
#include "../map_tool.h"
#include "../floor_touch.h"

#include "communication/communication.h"
#include "ug_manager.h"

#include "system/gamedata.h"
#include "system/pm_str.h"
#include "system/snd_tool.h"
#include "system/wordset.h"
#include "system/wipe.h"
#include "msgdata/msg_underworld.h"

#include "../field_effect.h"
#include "system/arc_util.h"
#include "system/clact_util.h"
#include "system/render_oam.h"
#include "ug_trap.naix"

#include "system/snd_tool.h";

#include "system/brightness.h"

//==============================================================================
// `
//==============================================================================

#define _TRAP_NUM_NATURE   (60)   ///< VR̃gbv
#define _TRAP_ID_NATURE  (COMM_MACHINE_MAX)  // VRgbv̓}Vԍȍ~ɂ
#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY

#define _TRAP_NUM_SINGLE_MAX (TRAP_NUM_SINGLE_MAX)       ///< l̏ꍇ̃gbvő吔
#define _TRAP_NUM_MAX (_TRAP_NUM_SINGLE_MAX * COMM_MACHINE_MAX + _TRAP_NUM_NATURE )  ///< gbvő吔
#define _TRAP_TYEP_INVALID (0)    ///< sȃgbv^Cv
#define _TRAP_INDEX_INVALID (-1)    ///< sȃgbvCfbNX

enum _result_e {
    _RESULT_NONE,
    _RESULT_OK,
    _RESULT_OK2,
    _RESULT_NG
};

enum _trapInfo_e {
    _TRAP_INFO_NONE,
    _TRAP_INFO_START,
    _TRAP_INFO_END
};

#define _RESULT_CMD_SIZE (2) // 㩃f[^M̌ʂԂ̃f[^oCg
#define _INTERVAL_OBJ_MAX  (12)  // I㩂\
#define _INTERVAL_TRAPDISP  (12)  // 㩕\
#define _TOUCH_OBJ_MAX (8)  //Touchɕ\㩂̌E

#define _TRAP_START_PAUSE_TIME  (15)  // 㩂ɂĂɒ~鎞
#define _GIDDY_STEP_NUM  (50)
#define _REVERSE_STEP_NUM  (20)
#define _HOLE_STEP_NUM (10)
#define _BIGHOLE_STEP_NUM (20)


#define _MIC_BLOW_VOL (100)

// CellActorɏ郊\[X}l[W̎ނ̐
#define CLACT_RESOURCE_NUM		(  4 )
#define _CLACT_BLOSSOMS_OAMNUM             (32)   // ʂɏoOAM
#define _CLACT_BUBBLE_OAMNUM             (20)   // ʂɏoBUBBLEOAM
#define _CLACT_TOUCHRADAR_OAMNUM      (17)
#define _CLACT_OAMNUM             (_CLACT_BLOSSOMS_OAMNUM)   // ʂɏoOAM  MAX
#define SUB_LCD  (1)
#define MAIN_LCD  (0)
#define BOTH_LCD  (2)


#define _BLOW_FRAME   (40)   // Ԃтt[
#define _TRAP_DIRTYBLOSSOMS_BRIGHTNESS_LV   (-4)   // Ԃт̕tF[hx -16Ő^

typedef void (*PTRStateFunc)(GF_BGL_INI* bgl);

//==============================================================================
//	^錾
//==============================================================================

// 㩂̍\̃f[^
typedef struct{
    u16 xpos;
    u16 zpos;
    u8 trapType;
    u8 order;  // 
} TrapInfo;


typedef struct{
    TrapInfo trap;
    u8 victimNetID;
    u8 assailantNetID;
    u8 message;
} _HitTrap;

typedef struct{
    TrapInfo trap;
    u8 netID;
    u8 result;
} _TrapResult;


typedef struct{
    int index;
    int distance;
} _TouchScan;

typedef struct{
    fx32 xpos;
    fx32 zpos;
} GridFX32;


// 㩑S
typedef struct{
    FIELDSYS_WORK* pFSys;
    
	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CLACT_RESOURCE_NUM];				// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[2][CLACT_RESOURCE_NUM];// \[XIuWFe[u
	CLACT_HEADER			clActHeader_m;							// ZAN^[wb_[
	CLACT_HEADER			clActHeader_s;							// ZAN^[wb_[
	CLACT_WORK_PTR			clActWork[_CLACT_OAMNUM];				// ZAN^[[N|C^z
	CLACT_WORK_PTR			SubLCDIconActWork[4];

    GMEVENT_CONTROL* pTouchEvent;  // ^b`ɊւẴCxgǗ
    GMEVENT_CONTROL* pEvent;  // 㩂̒gCxgǗ
    void* pTCBWork;   // Cxgł͑g߂Ȃړn̊Ǘ
    PTRStateFunc trapProc;   // 㩎s֐iNCAgj
    TrapInfo myTrapData[_TRAP_NUM_SINGLE_MAX];  //g̃gbvf[^
    EOA_PTR myTrapPic[_TRAP_NUM_SINGLE_MAX];
    TrapInfo trapData[_TRAP_NUM_MAX];
    TrapInfo* pTrapTbl[_TRAP_NUM_MAX];  // ̂߂̃e[u
    TrapInfo myTrap;    // 点邽߂TRAPf[^
    _HitTrap hitTrap[COMM_MACHINE_MAX];
    u8 debugTrapSet[COMM_MACHINE_MAX];   //fobOp@㩐ݒu
    u8 debugTrapDefuse[COMM_MACHINE_MAX];  //fobOp 㩉
    u16 intervalTimer;  // Iɐeq㩏𑗐M^C}[
    u16 oldCell;
    u16 oldXpos;
    u16 oldZpos;
    s8 mic;  // }CN
    u8 nowTrapType;   // 쒆̃gbv^Cv
    u8 nowTrapTypeServer[COMM_MACHINE_MAX];   // 쒆̃gbv^Cv
    u8 touchIntervalDownTimer;
    u8 intervalActCount;  // intervalAct𐔂
    u8 result;  // f[^ꂽ1AG[ł2ɂȂ
    u8 bSmogScreen;  // œ܂ĂꍇP
    u8 bHalt;    // @\~
} CommTrapWork;


typedef struct{
    BOOL fadeFlg;
    Grid oamGrid[_CLACT_OAMNUM];
    int seq;
    u8 blowRing[_BLOW_FRAME];   // 30t[ŊO~
    u8 blowPos[_CLACT_OAMNUM];  // tς~Ă鎞ɂ̈ʒuL x[XC炱̈ʒuɑLV˂
    u8 blowBase;   // CNĝ
} _EVENT_DIRTYBLOSSOMS_WORK;


typedef struct{
    BOOL fadeFlg;
    int seq;
    u8 size[_CLACT_BUBBLE_OAMNUM];
    u16 dirIdx[_CLACT_BUBBLE_OAMNUM];
    GridFX32 oamGrid[_CLACT_BUBBLE_OAMNUM];
    BOOL bEnd[_CLACT_BUBBLE_OAMNUM];
    VecFx32 scaleVex[_CLACT_BUBBLE_OAMNUM];
} _EVENT_BUBBLE_WORK;


typedef struct{
    u8* pTouchBuff[2];
    int touchSize[2];
    int seq;
    int touchXpos;
    int touchZpos;
    int scrXpos;
    int scrZpos;
    int timer;
} _EVENT_TOUCHRADAR_WORK;

typedef struct{
    BOOL bRev;
    int seq;
    int startTime;
} _EVENT_GIDDY_WORK;


typedef struct{
    BOOL bBig;
    int seq;
    int startTime;
    EOA_PTR eoa;  // 
} _EVENT_HOLE_WORK;

// VOg
static CommTrapWork* _pCTW = NULL;

//==============================================================================
// static錾
//==============================================================================

static void _myTrapAdd(TrapInfo* pTrap);
static int _getTrapNetID(TrapInfo* pTrap);
static TrapInfo* _addTrap(int x, int y, TrapInfo* pTrapTbl, int trapType);

static void _turnAroundSignalSend(void);

static TrapInfo* _checkTrap(int x, int z);

static EOA_PTR _trapPictAdd(int x, int z, int liveTime);

static void _intervalTrapPictAdd(int x, int z);
static void _touchTrapPictAdd(int x, int z, int index);
static void _trapPictWrite( void );
static void _trapPictDel( int index );
static void _myTrapDel(TrapInfo* pTrap);
static void _trapPictFinalize( void );


static void _trapServerStart(int victimNetID, int trapType);
static void _trapServerExit(int victimNetID, int trapType);
static void _startServerReverse(int victimNetID);
static void _startServerGiddy(int victimNetID);
static void _startServerSmog(int victimNetID);
static void _startServerDirtyBlossoms(int victimNetID);
static void _startServerBigDirRight(int victimNetID);
static void _startServerBigDirLeft(int victimNetID);
static void _startServerBigDirUp(int victimNetID);
static void _startServerBigDirDown(int victimNetID);
static void _startServerDirRight(int victimNetID);
static void _startServerDirLeft(int victimNetID);
static void _startServerDirUp(int victimNetID);
static void _startServerDirDown(int victimNetID);
static void _startServerDrill(int victimNetID);

static void _trapClientStart(int victimNetID, int trapType);
static void _startClientReverse(int victimNetID);
static void _startClientGiddy(int victimNetID);
static void _startClientSmog(int victimNetID);
static void _startClientBigDirRight(int victimNetID);
static void _startClientBigDirLeft(int victimNetID);
static void _startClientBigDirUp(int victimNetID);
static void _startClientBigDirDown(int victimNetID);
static void _startClientDirRight(int victimNetID);
static void _startClientDirLeft(int victimNetID);
static void _startClientDirUp(int victimNetID);
static void _startClientDirDown(int victimNetID);
static void _startClientDrill(int victimNetID);
static void _startClientDirtyBlossoms(int victimNetID);
static int _getLastOrder(TrapInfo* pTrapTbl);

static void _endClientSmog(int victimNetID);
static void _endClientDirtyBlossoms(int victimNetID);
static void _endClientGiddy(int netID);


static TrapInfo* _getOldOrderData(TrapInfo* pTrapTbl);
static void _resetOrderNo(TrapInfo* pTrapTbl);

static void _commTrapSmogDelete(int xpos, int zpos, u8* pScrAddr);
static void _procSmog(GF_BGL_INI* bgl);
static void _smogTouchNone(void);

static void _trapGiddyInitialize(BOOL bRev);

static void _dirtyBlossomsInitialize(GF_BGL_INI * bgl);
static BOOL _procDirtyBlossoms(GF_BGL_INI * bgl,_EVENT_DIRTYBLOSSOMS_WORK * mdw);
static void _dartyBlossomsStart(int x,int y);

static void _initCellActor(void);
static void _endCellActor(int oamNum);
static void _setCellActor(void);




static void _bubbleAddPetal(_EVENT_BUBBLE_WORK* mdw);
static BOOL _GMEVENT_Bubble(GMEVENT_CONTROL* event);
static void _bubbleInitialize(GF_BGL_INI * bgl);
static void _setCellActorBubble(_EVENT_BUBBLE_WORK* mdw);
static void _bubblePos(int index, _EVENT_BUBBLE_WORK* mdw);
static BOOL _procBubble(GF_BGL_INI * bgl, _EVENT_BUBBLE_WORK* mdw);
static void _startClientBubble(int victimNetID);
static void _startServerBubble(int victimNetID);
static void _endClientBubble(int victimNetID);

static void _exitServerDir(int victimNetID);
static void _exitServerGiddy(int victimNetID);


static void _priEndClientHole(int victimNetID);
static void _endClientHole(int netID);
static void _startClientBigHole(int victimNetID);
static void _startClientHole(int victimNetID);
static void _exitServerHole(int victimNetID);
static void _startServerBigHole(int victimNetID);
static void _startServerHole(int victimNetID);


typedef void (*ClientTrapFunc)(int victimNetID);
typedef void (*ServerTrapFunc)(int victimNetID);


static const ClientTrapFunc _clientTrapExit[] = {
    NULL,                    //UG_TRAPTYPE_NONE = 0,
    CommPlayerBlowAnimStop,       //UG_TRAPTYPE_DIR_UP,
    CommPlayerBlowAnimStop,     //UG_TRAPTYPE_DIR_DOWN,
    CommPlayerBlowAnimStop,     //UG_TRAPTYPE_DIR_LEFT,
    CommPlayerBlowAnimStop,    //UG_TRAPTYPE_DIR_RIGHT,
    CommPlayerBlowAnimStop,    //UG_TRAPTYPE_BIGDIR_UP,
    CommPlayerBlowAnimStop,  //UG_TRAPTYPE_BIGDIR_DOWN,
    CommPlayerBlowAnimStop,  //UG_TRAPTYPE_BIGDIR_LEFT,
    CommPlayerBlowAnimStop, //UG_TRAPTYPE_BIGDIR_RIGHT,
    NULL,                    //UG_TRAPTYPE_WARP,
    NULL,                    //UG_TRAPTYPE_TELEPORT,
    _endClientHole,                    //UG_TRAPTYPE_HOLE,
    _endClientHole,                    //UG_TRAPTYPE_BIG_HOLE,
    _endClientGiddy,                    //UG_TRAPTYPE_REVERSE,
    _endClientGiddy,       //UG_TRAPTYPE_GIDDY,
    NULL,                    //UG_TRAPTYPE_RUNNING,
    NULL,                    //UG_TRAPTYPE_INVISIBLE,
    NULL,                    //UG_TRAPTYPE_SLOW,
    _endClientSmog,        //UG_TRAPTYPE_SMOG, 
    _endClientSmog,        //UG_TRAPTYPE_BIG_SMOG,  
    NULL,                    //UG_TRAPTYPE_ROCK, 
    NULL,                    //UG_TRAPTYPE_RACKFALL, 
    NULL,                    //UG_TRAPTYPE_SUDS
    _endClientBubble,                    //UG_TRAPTYPE_BUBBLE, 
    NULL,                    //UG_TRAPTYPE_PARALYZE, 
    NULL,                    //UG_TRAPTYPE_ELECTROMAGNETIC_WAVE, 
    NULL,                    //UG_TRAPTYPE_ALARM, 
    NULL,                    //UG_TRAPTYPE_SIREN, 
    NULL,                    //UG_TRAPTYPE_LEAF, 
    _endClientDirtyBlossoms,                    //UG_TRAPTYPE_DIRTY_BLOSSOMS, 
    NULL,                    //UG_TRAPTYPE_FIRE,
    NULL,                    //UG_TRAPTYPE_BLAZE,
    NULL,                    //UG_TRAPTYPE_RADAR, 
    NULL,        //UG_TRAPTYPE_DRILL, 
    NULL,                    //UG_TRAPTYPE_MAX, 
};


static const ClientTrapFunc _clientTrapFunc[] = {
    NULL,                    //UG_TRAPTYPE_NONE = 0,
    _startClientDirUp,       //UG_TRAPTYPE_DIR_UP,
    _startClientDirDown,     //UG_TRAPTYPE_DIR_DOWN,
    _startClientDirLeft,     //UG_TRAPTYPE_DIR_LEFT,
    _startClientDirRight,    //UG_TRAPTYPE_DIR_RIGHT,
    _startClientBigDirUp,    //UG_TRAPTYPE_BIGDIR_UP,
    _startClientBigDirDown,  //UG_TRAPTYPE_BIGDIR_DOWN,
    _startClientBigDirLeft,  //UG_TRAPTYPE_BIGDIR_LEFT,
    _startClientBigDirRight, //UG_TRAPTYPE_BIGDIR_RIGHT,
    NULL,                    //UG_TRAPTYPE_WARP,
    NULL,                    //UG_TRAPTYPE_TELEPORT,
    _startClientHole,        //UG_TRAPTYPE_HOLE,
    _startClientBigHole,     //UG_TRAPTYPE_BIG_HOLE,
    _startClientReverse,     //UG_TRAPTYPE_REVERSE,
    _startClientGiddy,       //UG_TRAPTYPE_GIDDY,
    NULL,                    //UG_TRAPTYPE_RUNNING,
    NULL,                    //UG_TRAPTYPE_INVISIBLE,
    NULL,                    //UG_TRAPTYPE_SLOW,
    _startClientSmog,        //UG_TRAPTYPE_SMOG, 
    _startClientSmog,        //UG_TRAPTYPE_BIG_SMOG,  
    NULL,                    //UG_TRAPTYPE_ROCK, 
    NULL,                    //UG_TRAPTYPE_RACKFALL, 
    NULL,                    //UG_TRAPTYPE_SUDS
    _startClientBubble,      //UG_TRAPTYPE_BUBBLE, 
    NULL,                    //UG_TRAPTYPE_PARALYZE, 
    NULL,                    //UG_TRAPTYPE_ELECTROMAGNETIC_WAVE, 
    NULL,                    //UG_TRAPTYPE_ALARM, 
    NULL,                    //UG_TRAPTYPE_SIREN, 
    NULL,                    //UG_TRAPTYPE_LEAF, 
    _startClientDirtyBlossoms, //UG_TRAPTYPE_DIRTY_BLOSSOMS, 
    NULL,                    //UG_TRAPTYPE_FIRE,
    NULL,                    //UG_TRAPTYPE_BLAZE,
    NULL,                    //UG_TRAPTYPE_RADAR, 
    _startClientDrill,        //UG_TRAPTYPE_DRILL, 
    NULL,                    //UG_TRAPTYPE_MAX, 
};

static const ServerTrapFunc _serverTrapFunc[] = {
    NULL,                    //UG_TRAPTYPE_NONE = 0,
    _startServerDirUp,       //UG_TRAPTYPE_DIR_UP,
    _startServerDirDown,     //UG_TRAPTYPE_DIR_DOWN,
    _startServerDirLeft,     //UG_TRAPTYPE_DIR_LEFT,
    _startServerDirRight,    //UG_TRAPTYPE_DIR_RIGHT,
    _startServerBigDirUp,    //UG_TRAPTYPE_BIGDIR_UP,
    _startServerBigDirDown,  //UG_TRAPTYPE_BIGDIR_DOWN,
    _startServerBigDirLeft,  //UG_TRAPTYPE_BIGDIR_LEFT,
    _startServerBigDirRight, //UG_TRAPTYPE_BIGDIR_RIGHT,
    NULL,                    //UG_TRAPTYPE_WARP,
    NULL,                    //UG_TRAPTYPE_TELEPORT,
    _startServerHole,                    //UG_TRAPTYPE_HOLE,
    _startServerBigHole,                    //UG_TRAPTYPE_BIG_HOLE,
    _startServerReverse,                    //UG_TRAPTYPE_REVERSE,
    _startServerGiddy,       //UG_TRAPTYPE_GIDDY,
    NULL,                    //UG_TRAPTYPE_RUNNING,
    NULL,                    //UG_TRAPTYPE_INVISIBLE,
    NULL,                    //UG_TRAPTYPE_SLOW,
    _startServerSmog,        //UG_TRAPTYPE_SMOG, 
    _startServerSmog,        //UG_TRAPTYPE_BIG_SMOG,  
    NULL,                    //UG_TRAPTYPE_ROCK, 
    NULL,                    //UG_TRAPTYPE_RACKFALL,
    NULL,                    //UG_TRAPTYPE_SUDS
    _startServerBubble,      //UG_TRAPTYPE_BUBBLE, 
    NULL,                    //UG_TRAPTYPE_PARALYZE, 
    NULL,                    //UG_TRAPTYPE_ELECTROMAGNETIC_WAVE, 
    NULL,                    //UG_TRAPTYPE_ALARM, 
    NULL,                    //UG_TRAPTYPE_SIREN, 
    NULL,                    //UG_TRAPTYPE_LEAF, 
    _startServerDirtyBlossoms,                    //UG_TRAPTYPE_DIRTY_BLOSSOMS, 
    NULL,                    //UG_TRAPTYPE_FIRE,
    NULL,                    //UG_TRAPTYPE_BLAZE,
    NULL,                    //UG_TRAPTYPE_RADAR, 
    _startServerDrill,       //UG_TRAPTYPE_DRILL, 
    NULL,                    //UG_TRAPTYPE_MAX, 
};

static const ServerTrapFunc _serverTrapExit[] = {
    NULL,                    //UG_TRAPTYPE_NONE = 0,
    _exitServerDir,          //UG_TRAPTYPE_DIR_UP,
    _exitServerDir,          //UG_TRAPTYPE_DIR_DOWN,
    _exitServerDir,          //UG_TRAPTYPE_DIR_LEFT,
    _exitServerDir,          //UG_TRAPTYPE_DIR_RIGHT,
    _exitServerDir,          //UG_TRAPTYPE_BIGDIR_UP,
    _exitServerDir,          //UG_TRAPTYPE_BIGDIR_DOWN,
    _exitServerDir,          //UG_TRAPTYPE_BIGDIR_LEFT,
    _exitServerDir,          //UG_TRAPTYPE_BIGDIR_RIGHT,
    NULL,                    //UG_TRAPTYPE_WARP,
    NULL,                    //UG_TRAPTYPE_TELEPORT,
    _exitServerHole,                    //UG_TRAPTYPE_HOLE,
    _exitServerHole,                    //UG_TRAPTYPE_BIG_HOLE,
    _exitServerGiddy,        //UG_TRAPTYPE_REVERSE,
    _exitServerGiddy,        //UG_TRAPTYPE_GIDDY,
    NULL,                    //UG_TRAPTYPE_RUNNING,
    NULL,                    //UG_TRAPTYPE_INVISIBLE,
    NULL,                    //UG_TRAPTYPE_SLOW,
    NULL,        //UG_TRAPTYPE_SMOG, 
    NULL,        //UG_TRAPTYPE_BIG_SMOG,  
    NULL,                    //UG_TRAPTYPE_ROCK, 
    NULL,                    //UG_TRAPTYPE_RACKFALL,
    NULL,                    //UG_TRAPTYPE_SUDS
    NULL,      //UG_TRAPTYPE_BUBBLE, 
    NULL,                    //UG_TRAPTYPE_PARALYZE, 
    NULL,                    //UG_TRAPTYPE_ELECTROMAGNETIC_WAVE, 
    NULL,                    //UG_TRAPTYPE_ALARM, 
    NULL,                    //UG_TRAPTYPE_SIREN, 
    NULL,                    //UG_TRAPTYPE_LEAF, 
    NULL,                    //UG_TRAPTYPE_DIRTY_BLOSSOMS, 
    NULL,                    //UG_TRAPTYPE_FIRE,
    NULL,                    //UG_TRAPTYPE_BLAZE,
    NULL,                    //UG_TRAPTYPE_RADAR, 
    NULL,       //UG_TRAPTYPE_DRILL, 
    NULL,                    //UG_TRAPTYPE_MAX, 
};


static const PTRStateFunc _trapProc[]= {
    NULL,                    //UG_TRAPTYPE_NONE = 0,
    NULL,       //UG_TRAPTYPE_DIR_UP,
    NULL,     //UG_TRAPTYPE_DIR_DOWN,
    NULL,     //UG_TRAPTYPE_DIR_LEFT,
    NULL,    //UG_TRAPTYPE_DIR_RIGHT,
    NULL,    //UG_TRAPTYPE_BIGDIR_UP,
    NULL,  //UG_TRAPTYPE_BIGDIR_DOWN,
    NULL,  //UG_TRAPTYPE_BIGDIR_LEFT,
    NULL, //UG_TRAPTYPE_BIGDIR_RIGHT,
    NULL,                    //UG_TRAPTYPE_WARP,
    NULL,                    //UG_TRAPTYPE_TELEPORT,
    NULL,                    //UG_TRAPTYPE_HOLE,
    NULL,                    //UG_TRAPTYPE_BIG_HOLE,
    NULL,                    //UG_TRAPTYPE_REVERSE,
    NULL,       //UG_TRAPTYPE_GIDDY,
    NULL,                    //UG_TRAPTYPE_RUNNING,
    NULL,                    //UG_TRAPTYPE_INVISIBLE,
    NULL,                    //UG_TRAPTYPE_SLOW,
    _procSmog,               //UG_TRAPTYPE_SMOG, 
    _procSmog,               //UG_TRAPTYPE_BIG_SMOG,  
    NULL,                    //UG_TRAPTYPE_ROCK, 
    NULL,                    //UG_TRAPTYPE_RACKFALL,
    NULL,                    //UG_TRAPTYPE_SUDS
    NULL,                    //UG_TRAPTYPE_BUBBLE, 
    NULL,                    //UG_TRAPTYPE_PARALYZE, 
    NULL,                    //UG_TRAPTYPE_ELECTROMAGNETIC_WAVE, 
    NULL,                    //UG_TRAPTYPE_ALARM, 
    NULL,                    //UG_TRAPTYPE_SIREN, 
    NULL,                    //UG_TRAPTYPE_LEAF, 
    NULL,      //UG_TRAPTYPE_PETAL, 
    NULL,                    //UG_TRAPTYPE_FIRE,
    NULL,                    //UG_TRAPTYPE_BLAZE,
    NULL,                    //UG_TRAPTYPE_RADAR, 
    NULL,        //UG_TRAPTYPE_DRILL, 
    NULL,                    //UG_TRAPTYPE_MAX, 
};


//==============================================================================
// [N
//==============================================================================

//==============================================================================
// ֐
//==============================================================================


//==============================================================================
/**
 * gbv񏉊
 * @param   [N|C^
 * @param   tB[hVXẽ|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoInitialize(void* pWork, FIELDSYS_WORK* pFSys)
{
    int i;
    UNDERGROUNDDATA* pUGData;

    if(_pCTW){  // ̂Ƃ뉽x̂
        return;
    }
    _pCTW = (CommTrapWork*)pWork;
    MI_CpuFill8(_pCTW,0,sizeof(CommTrapWork));
    
    _pCTW->pFSys = pFSys;
    pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(pFSys));

    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        _pCTW->myTrapData[i].trapType = UnderGroundGetTrapGroundItemType(pUGData,i);
        _pCTW->myTrapData[i].xpos = UnderGroundGetTrapGroundItemX(pUGData,i);
        _pCTW->myTrapData[i].zpos = UnderGroundGetTrapGroundItemZ(pUGData,i);
        _pCTW->myTrapData[i].order = UnderGroundGetTrapGroundItemOrder(pUGData,i);
        if(_pCTW->myTrapData[i].trapType != UG_TRAPTYPE_NONE){
            _pCTW->myTrapPic[i] = _trapPictAdd(_pCTW->myTrapData[i].xpos, _pCTW->myTrapData[i].zpos, -1); //G\
        }
    }

    pFSys->TpTo3DPtr = FTouch_AllocUnderGroundTP(pFSys->camera_ptr);
    
}

//==============================================================================
/**
 * gbvZbg ʂ؂ւۂɊG̏SĎ̂ĂKv
 *   ʐM̂͊JȂ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommTrapInfoReset(void)
{
    FTouch_FreeUnderGroundTP(&(_pCTW->pFSys->TpTo3DPtr));
    _trapPictFinalize();
    _pCTW->bHalt = TRUE;
}

//==============================================================================
/**
 * gbvu[g G̏𕜋A
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommTrapInfoReboot(void)
{
    _pCTW->pFSys->TpTo3DPtr = FTouch_AllocUnderGroundTP(_pCTW->pFSys->camera_ptr);
    _pCTW->bHalt = FALSE;
}

//==============================================================================
/**
 * gbvJ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommTrapInfoFinalize(void)
{
    _trapPictFinalize();
    FTouch_FreeUnderGroundTP(&(_pCTW->pFSys->TpTo3DPtr));
    if(_pCTW){
        sys_FreeMemoryEz(_pCTW);
    }
    else{
        OHNO_PRINT("mۂĂȂ̂ɊJꂽ %s %d \n",__FILE__,__LINE__);
    }
    _pCTW=NULL;
}

//--------------------------------------------------------------
/**
 * @brief   bZ[W\ꍇ̏IR[obN
 * @param   none
 * @retval  none
 */
//--------------------------------------------------------------
static void _msgEndCallBack(int num)
{
    FieldSystemProc_SeqHoldEnd();
}

//==============================================================================
/**
 * gbvǗpf[^TCYԂ
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommTrapInfoGetWorkSize(void)
{
    return sizeof(CommTrapWork);
}

//==============================================================================
/**
 * ʐMp㩃f[^TCYԂ
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommTrapInfoGetTrapDataSize(void)
{
    return sizeof(TrapInfo)*_TRAP_NUM_SINGLE_MAX;
}

//==============================================================================
/**
 * e[uɂ㩂̈ʒuԂ
 * @param   pGrid  Ԃʒu
 * @param   index  index
 * @retval  noneTCY
 */
//==============================================================================

static Grid* _getTrapTblPos(Grid* pGrid, int index)
{
    if(_pCTW->pTrapTbl[index]==NULL){
        return NULL;
    }
    pGrid->xpos = _pCTW->pTrapTbl[index]->xpos;
    pGrid->zpos = _pCTW->pTrapTbl[index]->zpos;
    return pGrid;
}

//==============================================================================
/**
 * e[u㩂}
 * @param   pGrid  Ԃʒu
 * @param   index  index
 * @retval  noneTCY
 */
//==============================================================================

static void _insertTrapTbl(TrapInfo* pTrap)
{
    int ins,j;
    TrapInfo* pBigTrap;
    Grid grid;

    grid.xpos = pTrap->xpos;
    grid.zpos = pTrap->zpos;
    CommUnderItemSearchInitialize(_TRAP_NUM_MAX, _getTrapTblPos);
    ins = CommUnderSearchItemTbl(&grid);
    
    GF_ASSERT_RETURN(ins < (_TRAP_NUM_MAX-1),);

    for(j = _TRAP_NUM_MAX - 2; j >= ins; j--){
        _pCTW->pTrapTbl[j+1] = _pCTW->pTrapTbl[j];
    }
/*    memmove(&_pCTW->pTrapTbl[ins+1],
            &_pCTW->pTrapTbl[ins],
            (_TRAP_NUM_MAX - ins - 1) * sizeof(u32)); */
    _pCTW->pTrapTbl[ins] = pTrap;

}

static void _delTrapTbl(TrapInfo* pTrap)
{
    int match,j;
    Grid grid;
    
    grid.xpos = pTrap->xpos;
    grid.zpos = pTrap->zpos;
    CommUnderItemSearchInitialize(_TRAP_NUM_MAX, _getTrapTblPos);
    match = CommUnderMatchItemTbl(&grid);


    GF_ASSERT_RETURN(match != -1,);

    for(j = match; j < _TRAP_NUM_MAX - 2; j++){
        _pCTW->pTrapTbl[j] = _pCTW->pTrapTbl[j+1];
    }
/*  memmove(&_pCTW->pTrapTbl[match],
            &_pCTW->pTrapTbl[match+1],
            (_TRAP_NUM_MAX - match - 1)*sizeof(u32));
   */
    _pCTW->pTrapTbl[_TRAP_NUM_MAX-1] = NULL;
}


//==============================================================================
/**
 * Ă㩃obt@Ԃ
 * @param   netID     ID
 * @retval  TrapInfo*
 */
//==============================================================================

static TrapInfo* _getFreeTrap( TrapInfo* pTrapTbl )
{
    int i;
    
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        if(pTrapTbl->trapType == _TRAP_TYEP_INVALID){
            return pTrapTbl;
        }
        pTrapTbl++;
    }
    return NULL;
}

//==============================================================================
/**
 * Ă㩃obt@indexԂ
 * @param   netID     ID
 * @retval  TrapInfo*
 */
//==============================================================================

static int _getFreeTrapIndex( TrapInfo* pTrapTbl )
{
    int i;
    
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        if(pTrapTbl->trapType == _TRAP_TYEP_INVALID){
            return i;
        }
        pTrapTbl++;
    }
    return -1;
}

//==============================================================================
/**
 * 㩂̏
 * @param   TrapInfo* pTrap 
 * @retval  none
 */
//==============================================================================

static void _delTrap(TrapInfo* pTrap)
{
    u32 baseAddr = (u32)&_pCTW->trapData[0];
    u32 nowTrap = (u32)pTrap;
    u32 trapNo = (nowTrap-baseAddr)/sizeof(TrapInfo);
    u32 id = trapNo / _TRAP_NUM_SINGLE_MAX;
    
    pTrap->trapType = _TRAP_TYEP_INVALID;
    pTrap->order = 0;
    _delTrapTbl(pTrap);
    _resetOrderNo(&_pCTW->trapData[id]);
 //   OHNO_PRINT("㩂܂ id=%d no=%d\n", id,trapNo);
}

//==============================================================================
/**
 * 㩂ǉ
 * @param   netID     ID
 * @param   trapIndex 㩔ԍ
 * @retval  none
 */
//==============================================================================

static TrapInfo* _addTrap(int x, int y, TrapInfo* pTrapTbl, int trapType)
{
    int index = 0;
    TrapInfo* pFreeTrap;

    if(GetHitAttr(_pCTW->pFSys,x,y)){  // 肪ꍇ
       // zułȂ
        return NULL;
    }
    pFreeTrap = _getFreeTrap(pTrapTbl); //netID);
    if(pFreeTrap == NULL){  // ꍇ
        return NULL;
    }
    pFreeTrap->xpos = x;
    pFreeTrap->zpos = y;
    pFreeTrap->trapType = trapType;
    _insertTrapTbl(pFreeTrap);
    // Ԃ𖄂ߍ
    pFreeTrap->order = _getLastOrder(pTrapTbl) + 1;
    _resetOrderNo(pTrapTbl);  // ԍUȂ
    
    //OHNO_PRINT("㩐ݒu %d %d\n",x,y);
    return pFreeTrap;
}

//==============================================================================
/**
 * 㩂ǉ
 * @param   trapType 㩎
 * @param   func     ǉɌĂ΂R[obN
 * @retval  none
 */
//==============================================================================

void CommTrapInfoAddTrap(u8 trapType)
{
    CommSendFixSizeData(CF_TRAP_DATA,&trapType);
}

//==============================================================================
/**
 * 㩂
 * @param   netID     ID
 * @param   trapIndex 㩔ԍ
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRemoveTrap(int netID, int trapIndex)
{
    int base;
    base = netID * _TRAP_NUM_SINGLE_MAX;
    _pCTW->trapData[(base + trapIndex)].trapType = _TRAP_TYEP_INVALID;
}

//==============================================================================
/**
 *  t[s
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommTrapInfoProcess(void)
{
    int i;
    
    _turnAroundSignalSend();// e@Ȃ256Ńf[^]

    //_trapPictWrite();// G̕\
}


//==============================================================================
/**
 * e@̃vO
 *    㩂̈ʒu1/512őM
 *    q@ł͂̏ɒnʂLƕ\
 * @param   none
 * @retval  none
 */
//==============================================================================

static void _turnAroundSignalSend(void)
{

    VecFx32 vec;
    FIELD_OBJ_PTR fldobj;
    int xGrid,yGrid;
    Grid pos;

    
    // e@Ȃ256Ńf[^]
    if(CommGetCurrentID()==COMM_PARENT_ID){
        TrapInfo* pTrap = &_pCTW->trapData[_pCTW->intervalTimer];
    
        if(pTrap->trapType != _TRAP_TYEP_INVALID){    // IɃL[ɓ
            CommSetSendQueue_ServerSide(CF_TRAP_SERVER_DATA,
                                        pTrap, sizeof(pTrap->xpos)+sizeof(pTrap->zpos));
            _pCTW->myTrap.xpos = pTrap->xpos;
            _pCTW->myTrap.zpos = pTrap->zpos;
            _pCTW->myTrap.trapType = pTrap->trapType;
        }
        _pCTW->intervalTimer++;
        if(_pCTW->intervalTimer == _TRAP_NUM_MAX){
            _pCTW->intervalTimer = 0;
        }
    }
}

//==============================================================================
/**
 * e@̃vO
     ʒuf[^M̍ۂ̃TCYԂ
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommTrapInfoGetTrapPosSize(void)
{
    TrapInfo trap;
    
    return sizeof(trap.xpos)+sizeof(trap.zpos);
}


// q@̃vO

//==============================================================================
/**
 * q@̃vO  e@㩂𑗂
 * @param   netID   ŌɐڑĂq@ID
 * @retval  none
 */
//==============================================================================

void CommTrapInfoChildSendStart(void)
{
    int i;
    u8 num=0;

    /// ܂Ƃ߂đM
    CommSetSendQueue(CF_TRAP_ARRAY_DATA,
                     &_pCTW->myTrapData[0] ,
                     sizeof(TrapInfo)*_TRAP_NUM_SINGLE_MAX);
}

//==============================================================================
/**
 * 㩂ǉR}hM   CF_TRAP_DATA
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvTrapData(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = (u8*)pData;
    int gx,gy;
    TrapInfo* pFreeTrap;
    _TrapResult trapResult;

    if(_pCTW==NULL){
        return;
    }

    trapResult.netID = netID;
    trapResult.result = _RESULT_NG;
    gx = CommPlayerGetGridSXDirAdd(netID);
    gy = CommPlayerGetGridSZDirAdd(netID);

    //ɉȂƂ
    OHNO_PRINT("ɉȂƂ\n");

    if(COMM_INVALID_ID != CommPlayerIsAlive(gx,gy)){
        OHNO_PRINT("ڂ̑Oɐl  %d %d %d\n", CommPlayerIsAlive(gx,gy),gx,gy);
        // ʂԂ
        CommSendData_ServerSide(CF_TRAP_DATA_RESULT,&trapResult,sizeof(_TrapResult));
        return;
    }
    if(FALSE == CommUnderCheckPlace(gx,gy)){
        pFreeTrap = _getFreeTrap(&_pCTW->trapData[netID*_TRAP_NUM_SINGLE_MAX]);
        if(pFreeTrap == NULL){
            pFreeTrap = _getOldOrderData(&_pCTW->trapData[netID*_TRAP_NUM_SINGLE_MAX]);
            _delTrap(pFreeTrap);  // Â̂
        }
        
        if(pFreeTrap = _addTrap(gx, gy,
                                &_pCTW->trapData[netID*_TRAP_NUM_SINGLE_MAX], pBuff[0])){
            trapResult.result = _RESULT_OK;
            MI_CpuCopy8( pFreeTrap, &trapResult.trap, sizeof(TrapInfo));
        }
    }
    // ʂԂ
    CommSendData_ServerSide(CF_TRAP_DATA_RESULT,&trapResult,sizeof(_TrapResult));
}

//==============================================================================
/**
 * 㩂ǉR}ȟʃR}h̃oCgԂ
 * @param   none
 * @retval  oCg
 */
//==============================================================================

int CommTrapInfoGetTrapDataResultSize(void)
{
    return sizeof(_TrapResult);
}

//==============================================================================
/**
 * 㩂obNAbv
 * @param   pTrap    㩃f[^
 * @retval  none
 */
//==============================================================================

static void _myTrapBackup(void)
{
    UNDERGROUNDDATA* pUGData = SaveData_GetUnderGroundData(GameSystem_GetSaveData(_pCTW->pFSys));
    int i;
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        UnderGroundAddTrapGroundItem( pUGData, _pCTW->myTrapData[i].trapType,i,
                                      _pCTW->myTrapData[i].xpos,
                                      _pCTW->myTrapData[i].zpos,
                                      _pCTW->myTrapData[i].order);
    }
}

//==============================================================================
/**
 * 㩂ǉ+Gǉ
 * @param   pTrap    㩃f[^
 * @retval  none
 */
//==============================================================================

static void _myTrapAdd(TrapInfo* pTrap)
{
    TrapInfo* pFreeTrap = _getFreeTrap(_pCTW->myTrapData);
    int index;

    if(pFreeTrap==NULL){
        pFreeTrap = _getOldOrderData(_pCTW->myTrapData);
        _myTrapDel(pFreeTrap);  // Â̂
    }
    index = _getFreeTrapIndex(_pCTW->myTrapData);
    MI_CpuCopy8( pTrap, pFreeTrap, sizeof(TrapInfo));

    _myTrapBackup();
    _pCTW->myTrapPic[index] = _trapPictAdd(pFreeTrap->xpos, pFreeTrap->zpos, -1);
}

//==============================================================================
/**
 * 㩂+G
 * @param   pTrap    㩃f[^
 * @retval  none
 */
//==============================================================================

static void _myTrapDel(TrapInfo* pTrap)
{
    TrapInfo* pFreeTrap;
    int index = -1,i;

    OHNO_PRINT("Ԃ̂ƂՂ\n");
    for(i = 0; i< _TRAP_NUM_SINGLE_MAX; i++){
        pFreeTrap = &_pCTW->myTrapData[i];
        if((pTrap->xpos == pFreeTrap->xpos) && (pTrap->zpos == pFreeTrap->zpos)){
            index = i;
            break;
        }
    }
    GF_ASSERT_RETURN(index != -1,);
    pFreeTrap->trapType = _TRAP_TYEP_INVALID;
    if(_pCTW->myTrapPic[index]!=NULL){
        EOA_Delete(_pCTW->myTrapPic[index]);
        _pCTW->myTrapPic[index]=NULL;
    }
}

//==============================================================================
/**
 * 㩂ǉR}ȟʂM CF_TRAP_DATA_RESULT
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvTrapDataResult(int netID, int size, void* pData, void* pWork)
{
    _TrapResult* pTrapResult = (_TrapResult*)pData;
    int index;
    TrapInfo* pFreeTrap;

    GF_ASSERT_RETURN((pTrapResult->netID < COMM_MACHINE_MAX),);
    if(CommGetCurrentID() == pTrapResult->netID){
        if(pTrapResult->result == _RESULT_OK){
            FieldSystemProc_SeqHold();
            // T[o[̓𓾂Ă玩̃obt@Ɋi[
            _myTrapAdd(&pTrapResult->trap);
            CommUnderBagDeleteTrap(pTrapResult->trap.trapType);
            CommMsgRegisterUGTrapName(CommUnderGetMsgUnderWorld(),pTrapResult->trap.trapType);
            CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), mes_uw_item_08, TRUE, _msgEndCallBack);
        }
        else {
            FieldSystemProc_SeqHold();
            CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_59, TRUE, _msgEndCallBack);
        }
    }
}

//==============================================================================
/**
 *  㩂R}hM
 * @param   sendDSID        ĂDSID
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvTrapDataDel(int netID, int size, void* pData, void* pWork)
{
    u16* pBuff = pData;
    int index = pBuff[0];

    _delTrap(&_pCTW->trapData[index]);

}

int CommTrapInfoGetTrapDataDelSize(void)
{
    return 2;
}

//==============================================================================
/**
 *  㩃f[^ARRAY DATA
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvArrayData(int netID, int size, void* pData, void* pWork)
{
    u8 resultBuff[_RESULT_CMD_SIZE];
    TrapInfo* pTrap = &_pCTW->trapData[netID * _TRAP_NUM_SINGLE_MAX];
    int i;

    if(CommGetCurrentID() != COMM_PARENT_ID){
        return;
    }
    
    GF_ASSERT_RETURN(size == (sizeof(TrapInfo) * _TRAP_NUM_SINGLE_MAX),);
    // f[^M
    for(i = 0; i< _TRAP_NUM_SINGLE_MAX; i++){  // Ă̂
        if(pTrap->trapType != _TRAP_TYEP_INVALID){
            _delTrap(pTrap);
            OHNO_PRINT("΃f[^\n");
        }
        pTrap++;
    }
    pTrap = pData;  // Vo^
    for(i = 0; i< _TRAP_NUM_SINGLE_MAX; i++){
        if(pTrap->trapType != _TRAP_TYEP_INVALID){
            _addTrap(pTrap->xpos, pTrap->zpos,
                      &_pCTW->trapData[netID * _TRAP_NUM_SINGLE_MAX],
                      pTrap->trapType);
        }
        pTrap++;
    }
    resultBuff[0] = netID;
    resultBuff[1] = _RESULT_OK;
    CommSendData_ServerSide(CF_TRAP_ARRAY_RESULT,resultBuff,_RESULT_CMD_SIZE);
}


//==============================================================================
/**
 *  㩃f[^ʒuĂ
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvServerPosData(int netID, int size, void* pData, void* pWork)
{
    // ʒuRs[
    if(_pCTW){
        FIELD_OBJ_PTR pField;
        TrapInfo* pTrap = &_pCTW->myTrap;
        
        MI_CpuCopy8(pData, pTrap,  size);
        pTrap->trapType = UG_TRAPTYPE_GIDDY;  //̃f[^Ă

        // Aj\
        _intervalTrapPictAdd(pTrap->xpos, pTrap->zpos);  //_trapPictAdd(166,784);
    }
}

//==============================================================================
/**
 *  q@㩏eɑMłԂĂ
 * @param   none
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvResult(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = (u8*)pData;

    if(CommGetCurrentID() == pBuff[0]){
        _pCTW->result = pBuff[1];
    }
}

//==============================================================================
/**
 *  q@㩏eɑMłԂR}h̃TCY
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommTrapInfoGetResultSize(void)
{
    return _RESULT_CMD_SIZE;
}

//==============================================================================
/**
 *  Młǂ
 * @param   none
 * @retval  TCY
 */
//==============================================================================

BOOL CommTrapInfoIsParentRecv(void)
{
    return (_pCTW->result == _RESULT_OK);
}

//==============================================================================
/**
 *  ʂZbg
 * @param   none
 * @retval  TCY
 */
//==============================================================================

void CommTrapInfoResetParentRecv(void)
{
    _pCTW->result = _RESULT_NONE;
}

//==============================================================================
/**
 *  ^b`f[^̑MTCYԂ
 * @param   none
 * @retval  TCY
 */
//==============================================================================

int CommTrapInfoGetTouchSize(void)
{
    return sizeof(Grid);
}

//==============================================================================
/**
 *  㩂ڂ̑Oɂ
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @retval  㩂ĉ=TRUE
 */
//==============================================================================

BOOL CommTrapFrontTrapDefuse(int netID, Grid* pTouch)
{
    int x,z;
    u8 result = netID;
    TrapInfo* pTrap;
    _HitTrap hitTrap;

    x = CommPlayerGetGridSXDirAdd(netID);
    z = CommPlayerGetGridSZDirAdd(netID);

    pTrap = _checkTrap(x, z);
    if(pTrap){

        if(CommPlayerFlagDigCheck(netID)){   // ̊
            return TRUE;
        }

        hitTrap.victimNetID = netID;                 // ꂪ̂
        hitTrap.assailantNetID = _getTrapNetID(pTrap);  // ̂Ȃɂ
        MI_CpuCopy8(pTrap, &hitTrap.trap, sizeof(TrapInfo)); 

        OHNO_PRINT("㩉R}hM\n");
        //㩉R}hM
        CommSendData_ServerSide(CF_TRAP_DEFUSE, &hitTrap, sizeof(_HitTrap));
        _delTrap(pTrap);  //㩂
        return TRUE;
    }
    return FALSE;
}

int CommTrapInfoRecvTrapDefuseSize(void)
{
    return sizeof(_HitTrap);
}

//==============================================================================
/**
 *  㩉Ă
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @param   pWork    ɓn[N|C^
 * @retval  none
 */
//==============================================================================

void CommTrapInfoRecvTrapDefuse(int netID, int size, void* pData, void* pWork)
{
    _HitTrap* pHitTrap = (_HitTrap*)pData;

    OHNO_PRINT("㩉--\n");
    GF_ASSERT_RETURN(pHitTrap->victimNetID < COMM_MACHINE_MAX,);
//    GF_ASSERT_RETURN(pHitTrap->assailantNetID < COMM_MACHINE_MAX,);  // VR
    _pCTW->debugTrapDefuse[pHitTrap->victimNetID] = _RESULT_OK;

    if(CommGetCurrentID() == pHitTrap->assailantNetID){
        _myTrapDel(&pHitTrap->trap);
        _myTrapBackup();

        FieldSystemProc_SeqHold();
        CommMsgRegisterMyName(CommUnderGetMsgUnderWorld(),CommInfoGetMyStatus(pHitTrap->victimNetID));
        CommMsgRegisterUGTrapName(CommUnderGetMsgUnderWorld(),pHitTrap->trap.trapType);
        CommMsgTalkWindowStart(CommUnderGetMsgUnderWorld(), msg_underworld_19, TRUE, _msgEndCallBack);
    }
}

//==============================================================================
/**
 *  㩂NETIDtЂ
 * @param   ׂpTrap
 * @retval  netID
 */
//==============================================================================

static int _getTrapNetID(TrapInfo* pTrap)
{
    int i;
    
    for(i = 0; i < _TRAP_NUM_MAX; i++){
        if( pTrap == &_pCTW->trapData[i]){
            return i / _TRAP_NUM_SINGLE_MAX;
        }
    }
    GF_ASSERT(0 && "Ȃ㩂");
    return 0;  // ɂĂ͂
}

//==============================================================================
/**
 *  㩂ɈǂԂ
 * @param   ׂWXW
   @param   ׂWZW
 * @retval  
 */
//==============================================================================

static TrapInfo* _checkTrap(int x, int z)
{
    Grid grid;
    int ret;

    grid.xpos = x;
    grid.zpos = z;
    CommUnderItemSearchInitialize(_TRAP_NUM_MAX, _getTrapTblPos);
    ret = CommUnderMatchItemTbl(&grid);

    if(-1 == ret){
        return NULL;
    }
    return _pCTW->pTrapTbl[ret];
}

//==============================================================================
/**
 *  㩂ɈǂԂ
 * @param   ׂWXW
   @param   ׂWZW
 * @retval  ꍇTRUE
 */
//==============================================================================

BOOL CommTrapCheck(int x,int z)
{
    if(_checkTrap(x, z)==NULL){
        return FALSE;
    }
    return TRUE;
}

//==============================================================================
/**
 *  㩂Ɉꍇ̒ʐMTCYԂ
 * @param   none
 * @retval  size
 */
//==============================================================================

int CommTrapGetStartSize(void)
{
    return sizeof(_HitTrap);
}

//==============================================================================
/**
 *  㩂ɈꍇʐMbZ[W𑗐M
 * @param   邩ǂׂID
 * @retval  none
 */
//==============================================================================

static BOOL _checkAndSendMessage(int netID)
{
    _HitTrap hitTrap;
    TrapInfo* pTrap = _checkTrap( CommPlayerGetGridSX(netID), CommPlayerGetGridSZ(netID));

    if(!pTrap){
        return FALSE;
    }

    if(_pCTW->nowTrapTypeServer[netID] != _TRAP_TYEP_INVALID){
        _trapServerExit(netID,_pCTW->nowTrapTypeServer[netID]);
    }
    _trapServerStart(netID, pTrap->trapType);// 㩏
    hitTrap.victimNetID = netID;                 // ꂪ
    hitTrap.assailantNetID = _getTrapNetID(pTrap);  // ̂Ȃɂ
    MI_CpuCopy8(pTrap, &hitTrap.trap, sizeof(TrapInfo));
    OHNO_PRINT("Ȃɂ[[[ \n");
    CommSendData_ServerSide(CF_TRAP_START, &hitTrap, sizeof(_HitTrap)); // M
    _pCTW->nowTrapTypeServer[netID]=pTrap->trapType;
    // 㩂
    pTrap->trapType = _TRAP_TYEP_INVALID;
    _delTrapTbl(pTrap);
    return TRUE;
}

//==============================================================================
/**
 *  㩂Ɉꍇ̊Ǘ
 * @param   邩ǂׂID
 * @retval  none
 */
//==============================================================================

BOOL CommTrapCheckAndSendMessage(int netID)
{
    if(_pCTW){
        return _checkAndSendMessage(netID);
    }
    return FALSE;
}

//==============================================================================
/**
 *  㩂ɈƂM  CF_TRAP_START
 * @param   netID    lbgID
 * @param   size     f[^TCY
 * @param   *pData   f[^
 * @retval  none     
 */
//==============================================================================

void CommTrapRecvStart(int netID, int size, void* pData, void* pWork)
{
    _HitTrap* pHitTrap = (_HitTrap*)pData;
    SB_RECORD_DATA* pRec = SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCTW->pFSys));
    
    if(!_pCTW){
        return;
    }
    // 㩃GtFNg\
    OHNO_PRINT("Ȃ܂ %d %d\n", pHitTrap->victimNetID,
               pHitTrap->assailantNetID);
    Snd_SePlay( SEQ_SE_E );
    MI_CpuCopy8(pHitTrap, &_pCTW->hitTrap[pHitTrap->victimNetID],
           sizeof(_HitTrap));
    _pCTW->hitTrap[pHitTrap->victimNetID].message = 1;

    if(CommGetCurrentID() == pHitTrap->victimNetID){
        _trapClientStart(pHitTrap->victimNetID, pHitTrap->trap.trapType);
    }
    CommPlayerSetFEExclamationAdd(pHitTrap->victimNetID);
    if(CommGetCurrentID() == pHitTrap->victimNetID){
        SecretBaseRecordSetTrapTumbleNum(pRec);  // 㩂ɂƂJEg
    }
    if(CommGetCurrentID() == pHitTrap->assailantNetID){
        if(pHitTrap->assailantNetID != pHitTrap->victimNetID){
            SecretBaseRecordSetTrapConquerNum(pRec);  // 㩂ɂƂJEg
        }
        _myTrapDel(&pHitTrap->trap);
        _myTrapBackup();
    }
}


//==============================================================================
/**
 *  㩂Ɉ󋵃bZ[WԂ
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

BOOL CommTrapGetActionMessage(STRBUF* pStrBuf)
{
    int i,msgNo;

    if(!_pCTW){
        return FALSE;
    }
    
    for(i = 0; i< COMM_MACHINE_MAX; i++){
        if(_pCTW->hitTrap[i].message == 1){
            CommMsgRegisterTargetName(CommUnderGetMsgUnderWorld(), CommInfoGetMyStatus(i));
            if(_pCTW->hitTrap[i].assailantNetID >= _TRAP_ID_NATURE){
                msgNo = UGDecoyNatural;
            }
            else{
                CommMsgRegisterMyName(CommUnderGetMsgUnderWorld(),
                                      CommInfoGetMyStatus(_pCTW->hitTrap[i].assailantNetID));
                msgNo = UGDecoy01;
            }
            STRBUF_Copy(pStrBuf ,CommMsgGetExpandStrBuf(CommUnderGetMsgUnderWorld(), msgNo));
            _pCTW->hitTrap[i].message = 2;
            return TRUE;
        }
        if(_pCTW->hitTrap[i].message == 2){
            STRBUF_Copy(pStrBuf ,CommMsgGetExpandStrBuf(CommUnderGetMsgUnderWorld(), UGDecoy02));
            _pCTW->hitTrap[i].trap.trapType = _TRAP_TYEP_INVALID;
            _pCTW->hitTrap[i].message = 0;
            return TRUE;
        }
    }
    return FALSE;
}

//==============================================================================
/**
 *  㩐ݒu󋵃bZ[WԂifobOpj
 * @param   message   bZ[W
 * @retval  bZ[WꍇTRUE
 */
//==============================================================================

BOOL CommTrapSetActionMessage(STRBUF* pStrBuf)
{
    int i;
    WORDSET* pWordSetMain=NULL;  //[hZbg\
    STRBUF* tmp_buf1=NULL;
    BOOL bRet = FALSE;

    if(!_pCTW){
        return bRet;
    }
    for(i = 0; i< COMM_MACHINE_MAX; i++){
        if(_pCTW->debugTrapDefuse[i] == _RESULT_OK){
            pWordSetMain = WORDSET_Create(HEAPID_FIELD);
            tmp_buf1 = STRBUF_Create( _EVWIN_MSG_BUF_SIZE, HEAPID_FIELD );
            WORDSET_RegisterPlayerName(  pWordSetMain, CURRENT_PLAYER_WORD_IDX, CommInfoGetMyStatus(i));
            MSGMAN_GetString( CommMsgGetMsgManager(CommUnderGetMsgUnderWorld()), UGTrapFind02, tmp_buf1 );
            WORDSET_ExpandStr( pWordSetMain, pStrBuf, tmp_buf1 );
            _pCTW->debugTrapDefuse[i] = _RESULT_NONE;
            bRet = TRUE;
            break;
        }
    }
    if(tmp_buf1)
        STRBUF_Delete( tmp_buf1 );
    if(pWordSetMain)
        WORDSET_Delete(pWordSetMain);
    return bRet;
}

//==============================================================================
/**
 * 㩏Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _trapServerStart(int victimNetID, int trapType)
{
    ServerTrapFunc pFunc = _serverTrapFunc[trapType];
    OHNO_PRINT("T[o[㩋N %d \n",trapType);
    if(pFunc){
        pFunc( victimNetID );
    }
}

static void _trapServerExit(int victimNetID, int trapType)
{
    ServerTrapFunc pFunc = _serverTrapExit[trapType];
    if(pFunc){
        pFunc( victimNetID );
    }
}

//==============================================================================
/**
 * 㩃GtFNgJn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _trapClientStart(int victimNetID, int trapType)
{
    ClientTrapFunc pFunc;

    if(_pCTW->nowTrapType!=UG_TRAPTYPE_NONE){  // 㩂̉
        pFunc = _clientTrapExit[_pCTW->nowTrapType];
        if(pFunc){
            pFunc( victimNetID );
        }
        _pCTW->trapProc = NULL;
    }

    pFunc = _clientTrapFunc[trapType];
    if(pFunc){
        pFunc( victimNetID );  // 
        _pCTW->trapProc = _trapProc[trapType];  // ֐Zbg
        _pCTW->nowTrapType = trapType;   // 쒆̃gbv^Cv
        OHNO_PRINT("NCAg㩋N %d \n",_pCTW->nowTrapType);
    }
}

//==============================================================================
/**
 * ͂Ă㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startServerReverse(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    CommPlayerSetGiddyStep(victimNetID,_REVERSE_STEP_NUM);
}

//==============================================================================
/**
 * 㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startServerGiddy(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    CommPlayerSetGiddyStep(victimNetID,_GIDDY_STEP_NUM);
}


static void _exitServerGiddy(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_NONE);
    CommPlayerResetGiddyStep(victimNetID);
}

//==============================================================================
/**
 * 㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startServerSmog(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_SMOG);
}

//==============================================================================
/**
 * Ԃт̕Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startServerDirtyBlossoms(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_SMOG);
}



//==============================================================================
/**
 * ΂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startServerDirUp(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_UP, FALSE);
}
static void _startServerDirDown(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_DOWN, FALSE);
}
static void _startServerDirLeft(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_LEFT, FALSE);
}
static void _startServerDirRight(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_RIGHT, FALSE);
}
static void _startServerBigDirUp(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_UP, TRUE);
}
static void _startServerBigDirDown(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_DOWN, TRUE);
}
static void _startServerBigDirLeft(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_LEFT, TRUE);
}
static void _startServerBigDirRight(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_FORCE_MOVE);
    CommPlayerBlowStart(victimNetID, DIR_RIGHT, TRUE);
}

static void _exitServerDir(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_NONE);
    CommPlayerBlowExit(victimNetID);
}

//==============================================================================
/**
 * hŌ@
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startServerDrill(int victimNetID)
{
    // T[o[͂ł͉Ȃ
}

//==============================================================================
/**
 * ]㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientReverse(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    if(CommGetCurrentID() == victimNetID){
        _trapGiddyInitialize(TRUE);
    }
}

//==============================================================================
/**
 * 㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientGiddy(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    if(CommGetCurrentID() == victimNetID){
        _trapGiddyInitialize(FALSE);
    }
}

//==============================================================================
/**
 * 㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientSmog(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_SMOG);
    if(CommGetCurrentID() == victimNetID){
        CommTrapSmogInitialize(_pCTW->pFSys->bgl);
    }
}

//==============================================================================
/**
 * Ԃт̕㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientDirtyBlossoms(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_SMOG);
    if(CommGetCurrentID() == victimNetID){
        _dirtyBlossomsInitialize(_pCTW->pFSys->bgl);
    }
}

//==============================================================================
/**
 * NCAg΂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientDirUp(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_UP, FALSE);
}
static void _startClientDirDown(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_DOWN, FALSE);
}
static void _startClientDirLeft(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_LEFT, FALSE);

}
static void _startClientDirRight(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_RIGHT, FALSE);
    
}
static void _startClientBigDirUp(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_UP, TRUE);
}
static void _startClientBigDirDown(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_DOWN, TRUE);
}
static void _startClientBigDirLeft(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_LEFT, TRUE);
}
static void _startClientBigDirRight(int victimNetID)
{
    CommPlayerBlowAnimStart(victimNetID, DIR_RIGHT, TRUE);
}

//==============================================================================
/**
 * hŌ@
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientDrill(int victimNetID)
{
    // łȂ
}


//--------------------------------------------------------------
/**
 * 㩊Go
 * @param
 * @retval
 */
//--------------------------------------------------------------
static EOA_PTR _trapPictAdd(int x, int z, int liveTime)
{
	EOA_PTR eoa;
	
    if(!_pCTW->bHalt){
        eoa = FE_Trap_Add(_pCTW->pFSys, x, z, liveTime);
        return( eoa );
    }
    return NULL;
}

//--------------------------------------------------------------
/**
 * ԊuŐe@瑗M㩊Go
 * @param
 * @retval
 */
//--------------------------------------------------------------
static void _intervalTrapPictAdd(int x, int z)
{
    _trapPictAdd(x, z, _INTERVAL_TRAPDISP);
}

//--------------------------------------------------------------
/**
 * ^b`plŉꂽ㩊G
 * @param
 * @retval
 */
//--------------------------------------------------------------
static void _touchTrapPictAdd(int x, int z, int index)
{
    _trapPictAdd(x, z, _INTERVAL_TRAPDISP);
}

//--------------------------------------------------------------
/**
 * 㩊G`
 * @param
 * @retval
 */
//--------------------------------------------------------------
static void _trapPictWrite( void )
{
    int i,ret;
	
}

//--------------------------------------------------------------
/**
 * 㩊G̏I
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------
static void _trapPictFinalize( void )
{
}

//--------------------------------------------------------------
/**
 * 㩂̐Ԃ̍Ō߂
 * @param    netID  @ԍ
 * @retval   ԍ
 */
//--------------------------------------------------------------
static int _getLastOrder(TrapInfo* pTrapTbl)
{
    int i,order;
    order = 0;
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        if(pTrapTbl->order > order){
            order = pTrapTbl->order;
        }
        pTrapTbl++;
    }
    return order;
}

//--------------------------------------------------------------
/**
 * ŏɐ㩂𓾂
 * @param    netID  @ԍ
 * @retval   ԍ
 */
//--------------------------------------------------------------
static TrapInfo* _getOldOrderData(TrapInfo* pTrapTbl)
{
    int i,base,order;
    TrapInfo* pRetTrap=NULL;
    
    order = _TRAP_NUM_SINGLE_MAX;
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        if(pTrapTbl->order < order){
            pRetTrap = pTrapTbl;
            order = pTrapTbl->order;
        }
        pTrapTbl++;
    }
    return pRetTrap;
}

//--------------------------------------------------------------
/**
 * ԍUȂ
 * @param    netID  @ԍ
 * @retval   none
 */
//--------------------------------------------------------------
static void _resetOrderNo(TrapInfo* pTrapTbl)
{
    int i,base,order,j;
    TrapInfo* pOrderTrap[_TRAP_NUM_SINGLE_MAX];
    TrapInfo* pTT = pTrapTbl;

    // e[u
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        pOrderTrap[i] = NULL;
    }
    // ̏ԂŐ
    for(i = 1; i <= _TRAP_NUM_SINGLE_MAX; i++){
        for(j = 0; j < _TRAP_NUM_SINGLE_MAX; j++){
            if(pTT->order == i){
                pOrderTrap[i-1] = pTT;
                break;
            }
            pTT++;
        }
    }
    // ԍUȂ
    base = 1;
    for(i = 0; i < _TRAP_NUM_SINGLE_MAX; i++){
        if(pOrderTrap[i]!=NULL){
            pOrderTrap[i]->order = base;
            base++;
        }
    }
  //  OHNO_PRINT("ԐUȂ\n");
}

//--------------------------------------------------------------
/**
 * XbO㩂̏
 * @param    GF_BGL_INI bglԍ
 * @retval   none
 */
//--------------------------------------------------------------


void CommTrapSmogInitialize(GF_BGL_INI* bgl)
{
    ArcUtil_PalSet(    ARC_UG_TRAP_GRA, NARC_ug_trap_t_kemuri_NCLR, PALTYPE_MAIN_BG, 0, 32,  HEAPID_FIELD);
	ArcUtil_BgCharSet( ARC_UG_TRAP_GRA, NARC_ug_trap_t_kemuri_NCGR, bgl, GF_BGL_FRAME2_M, 0, 8*6*6, 0, HEAPID_FIELD);
    // @@OOXN[͂SލĂ炤
    ArcUtil_ScrnSet(   ARC_UG_TRAP_GRA, NARC_ug_trap_t_kemuri_NSCR, bgl, GF_BGL_FRAME2_M, 0, 32*24*2, 0, HEAPID_FIELD);

    GF_BGL_PrioritySet(GF_BGL_FRAME2_M , 0);
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
    _pCTW->bSmogScreen = TRUE;
    _smogTouchNone();

}

//--------------------------------------------------------------
/**
 * XbO㩂삵Ă邩ǂ
 * @param    none
 * @retval   쒆TRUE
 */
//--------------------------------------------------------------

BOOL CommTrapIsSmogTouch(void)
{
    return _pCTW->bSmogScreen;
}


static void _drawLine(int x0, int y0, int x1, int y1,u8* pScrAddr){

	int E, x=x0, y=y0, dx, dy, wx=abs(x0-x1), wy=abs(y1-y0);

	dx=(x0<x1)?1:-1;
	dy=(y0<y1)?1:-1;

	if(wx >= wy){ /* X1菬H */
		E = -wx;  /* Ȅ */
		while(x != x1){
			_commTrapSmogDelete(x,y,pScrAddr);
			x += dx;
			E += 2*wy;
			if(E >= 0){
				E -= 2*wx;
				y += dy;
			}
		}
	}else{ /* X1傫ꍇ(or-1菬ꍇ) */
		E = -wy;  /* Ȅ */
		while(y != y1){
			_commTrapSmogDelete(x,y,pScrAddr);
			y += dy;
			E += 2*wx;
			if(E >= 0){
				E -= 2*wy;
				x += dx;
			}
		}
	}
}

//--------------------------------------------------------------
/**
 * XbO㩂I点
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

static void _endClientSmog(int victimNetID)
{
    int i;
    u8* pScrAddr = GF_BGL_ScreenAdrsGet( _pCTW->pFSys->bgl, GF_BGL_FRAME2_M );
    
    if(_pCTW->trapProc){
        _pCTW->trapProc = NULL;  // gbvI
        _pCTW->bSmogScreen = FALSE;
        for(i = 0; i< 0x800; i+=2 ){
            pScrAddr[i] = 0;
        }
        GF_BGL_PrioritySet(GF_BGL_FRAME2_M , 3);
        GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
    }
}

//--------------------------------------------------------------
/**
 * XbO㩂삵Ă邩ǂ
 * @param    none
 * @retval   쒆TRUE
 */
//--------------------------------------------------------------

void CommTrapSmogTouch(Grid* pGrid, GF_BGL_INI * bgl)
{
    int i,cnt=0;
    u8* pScrAddr = GF_BGL_ScreenAdrsGet( bgl, GF_BGL_FRAME2_M );

    if(pScrAddr==NULL){
        OHNO_PRINT("߂񂠂ǂꂷƂȂ \n");
        return;
    }
    if((_pCTW->oldXpos != 0xffff)&&(_pCTW->oldZpos != 0xffff)){
        _drawLine(pGrid->xpos, pGrid->zpos,
                  _pCTW->oldXpos,_pCTW->oldZpos,
                  pScrAddr);
        // Ƃ肠S]
        GF_BGL_LoadScreenReq(bgl, GF_BGL_FRAME2_M);
    }
    _pCTW->oldXpos = pGrid->xpos;
    _pCTW->oldZpos = pGrid->zpos;

    // ʌvZ
    for(i = 0; i< 0x800; i+=2 ){
        if(pScrAddr[i] != 0){
            cnt++;
        }
    }
    if( cnt < 13 ){
        u8 bRet = TRUE;
        CommSendFixSizeData(CF_TRAP_END,&bRet);
    }
}


//--------------------------------------------------------------
/**
 * ӏ
 * @param    xpos,zpos  W
 * @retval   none
 */
//--------------------------------------------------------------

static void _commTrapSmogDelete(int xpos, int zpos, u8* pScrAddr)
{
    u16 cell = (xpos/8 + zpos/8 * (256/8)) *2;
    s32 bothDeleteTbl[]={-66,-64,-62,-2,0,2,62,64,66};   // ɏCELL    ̃e[u
    int i;
    
    if(cell > 0x800){
        return;
    }
    for(i = 0; i < sizeof(bothDeleteTbl)/sizeof(s32); i++){
        s32 bothCell = cell + bothDeleteTbl[i];
        if((bothCell < 0x800) && (bothCell >= 0)  &&(pScrAddr[bothCell]!=0)){
            switch(i){
              case 4:
                pScrAddr[bothCell] = pScrAddr[bothCell] + 5;
                break;
              case 1:
              case 3:
              case 5:
              case 7:
                pScrAddr[bothCell] = pScrAddr[bothCell] + 5;
                break;
              default:
                pScrAddr[bothCell] = pScrAddr[bothCell] + 1;
                break;
            }
            if(pScrAddr[bothCell] > 5){
                pScrAddr[bothCell] = 0;
            }
        }
    }
}



//--------------------------------------------------------------
/**
 * XbO㩂삵Ă邩ǂ
 * @param    none
 * @retval   쒆TRUE
 */
//--------------------------------------------------------------

static void _smogTouchNone(void)
{
    _pCTW->oldXpos=0xffff;
    _pCTW->oldZpos=0xffff;
}

//--------------------------------------------------------------
/**
 * @brief     s
 * @param   bgl  GF_BGL_INI
 * @retval  none
 */
//--------------------------------------------------------------

static void _procSmog(GF_BGL_INI* bgl)
{
    if(CommTrapIsSmogTouch() && sys.tp_cont){  // 
        Grid grid;
        grid.xpos = sys.tp_x;
        grid.zpos = sys.tp_y;
        CommTrapSmogTouch(&grid, bgl );
    }
    else{
        _smogTouchNone();  // W
    }
}

//--------------------------------------------------------------
/**
 * gbvIR}h̃TCY
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

typedef struct {
    u8 netID;
    u8 bResult;  //TRUE FALSE I
} TrapEndResult_t;


int CommTrapGetEndResultSize(void)
{
    return sizeof(TrapEndResult_t);
}


//--------------------------------------------------------------
/**
 * gbvIq@瑗Ă  CF_TRAP_END
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @param   pWork    gp[N
 * @retval   none
 */
//--------------------------------------------------------------

void CommTrapRecvEnd(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    u8 id = netID;
    TrapEndResult_t ret;

    CommPlayerResetCondition(netID);
    _trapServerExit(netID,_pCTW->nowTrapTypeServer[netID]);
    _pCTW->nowTrapTypeServer[netID] = _TRAP_TYEP_INVALID;
    ret.netID = netID;
    ret.bResult = pBuff[0];
    CommSendFixSizeData_ServerSide(CF_TRAP_END_RESULT,&ret);
}

//--------------------------------------------------------------
/**
 * gbvIe@瑗Ă  CF_TRAP_END_RESULT
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @param   pWork    gp[N
 * @retval   none
 */
//--------------------------------------------------------------

void CommTrapRecvEndResult(int netID, int size, void* pData, void* pWork)
{
    TrapEndResult_t *pRet = pData;
    int trapType = _pCTW->nowTrapType;   // 쒆̃gbv^Cv
    ClientTrapFunc pFunc;

    if(pRet->bResult){
        CommPlayerSetFEOkAdd( pRet->netID );
    }
    else{
        CommPlayerSetFENoneAdd( pRet->netID );
    }
    pFunc = _clientTrapExit[trapType];
    if(pFunc){
        pFunc( pRet->netID );
    }
    _pCTW->nowTrapType = UG_TRAPTYPE_NONE;
}

//--------------------------------------------------------------
/**
 * T[o[牉õ^C~O킹Ŕł閽 ̏HOLÊ
 * @param   
 * @retval  none
 */
//--------------------------------------------------------------

void CommTrapRecvPriEnd(int netID, int size, void* pData, void* pWork)
{
    u8* pBuff = pData;
    int trapType = _pCTW->nowTrapType;   // 쒆̃gbv^Cv

    if((trapType == UG_TRAPTYPE_HOLE) || (trapType == UG_TRAPTYPE_BIG_HOLE)){
        _priEndClientHole(pBuff[0]);
    }
}

//--------------------------------------------------------------
/**
 * gbvf
 * @param   netID    fl
 * @param   targetID    㩂ɂĂl
 * @retval  none
 */
//--------------------------------------------------------------

typedef struct{
    u8 netID;
    u8 targetID;
} _TrapRelease;

void CommTrapSendRelease(int netID, int targetID)
{
    _TrapRelease tr;


    CommPlayerResetCondition(netID);
    _trapServerExit(netID,_pCTW->nowTrapTypeServer[netID]);
    _pCTW->nowTrapTypeServer[netID] = _TRAP_TYEP_INVALID;

    tr.targetID = targetID;
    tr.netID = netID;
    OHNO_PRINT("---㩏  %d %d \n",netID,targetID);
    CommSendFixSizeData_ServerSide(CF_TRAP_RELEASE, &tr);

}


//--------------------------------------------------------------
/**
 * gbve@瑗Ă   CF_TRAP_RELEASE
 * @param   netID    MĂID
 * @param   size     Ăf[^TCY
 * @param   pData    f[^{̂̃|C^
 * @param   pWork    gp[N
 * @retval   none
 */
//--------------------------------------------------------------

void CommTrapRecvRelease(int netID, int size, void* pData, void* pWork)
{
    _TrapRelease* pTr = pData;
    SB_RECORD_DATA* pRec = SaveData_GetSecretBaseRecord(GameSystem_GetSaveData(_pCTW->pFSys));

    OHNO_PRINT("++++㩏  %d %d %d %d \n",pTr->netID,pTr->targetID,CommGetCurrentID(),_pCTW->nowTrapType);

    CommPlayerSetFEOkAdd( pTr->targetID );

    if(pTr->netID == CommGetCurrentID()){
        SecretBaseRecordSetTrapRescueNum(pRec);   // 㩂[
        // @@OObZ[W
    }
    if((pTr->targetID == CommGetCurrentID()) && (_pCTW->nowTrapType != UG_TRAPTYPE_NONE)){
        int trapType = _pCTW->nowTrapType;   // 쒆̃gbv^Cv
        ClientTrapFunc pFunc = _clientTrapExit[trapType];
        if(pFunc){
            pFunc( pTr->targetID );
        }
        _pCTW->trapProc = NULL;
        OHNO_PRINT("CommTrapRecvRelease\n");
    }
    _pCTW->nowTrapType = UG_TRAPTYPE_NONE;
}

//--------------------------------------------------------------
/**
 * R}h̃TCYԂ
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

int CommTrapGetReleaseSize(void)
{
    return sizeof(_TrapRelease);
}

//--------------------------------------------------------------
/**
 * ̃gbv̈ʒuXW𓾂
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

int CommTrapGetMyTrapX(int index)
{
    if(_pCTW  &&
       (_pCTW->myTrapData[index].trapType != _TRAP_TYEP_INVALID) ){
        return _pCTW->myTrapData[index].xpos;
    }
    return 0;
}

//--------------------------------------------------------------
/**
 * ̃gbv̈ʒuXW𓾂
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

int CommTrapGetMyTrapZ(int index)
{
    if(_pCTW  &&
       (_pCTW->myTrapData[index].trapType != _TRAP_TYEP_INVALID) ){
        return _pCTW->myTrapData[index].zpos;
    }
    return 0;
}

///---------------------diggy

enum{
    _GIDDY_INIT,
    _GIDDY_FUNC,
    _GIDDY_END,
};

//--------------------------------------------------------------
/**
 * @brief    E͂ĂI点֐
 * @param    event  CxgRg[[
 * @retval   ITRUE
 */
//--------------------------------------------------------------

static void _endClientGiddy(int netID)
{
    if(CommGetCurrentID() == netID){
        if(_pCTW->pTCBWork){
            _EVENT_GIDDY_WORK * mdw = _pCTW->pTCBWork;
            mdw->seq = _GIDDY_END;
            _pCTW->pTCBWork = NULL;
        }
    }
}

//--------------------------------------------------------------
/**
 * @brief    E͂ẴCxg֐
 * @param    event  CxgRg[[
 * @retval   ITRUE
 */
//--------------------------------------------------------------

static void _GMEVENT_Giddy(TCB_PTR tcb, void *work)
{
    _EVENT_GIDDY_WORK * mdw = work;
    int i;

    switch(mdw->seq){
      case _GIDDY_INIT:
        mdw->startTime++;
        if(_TRAP_START_PAUSE_TIME < mdw->startTime){
            mdw->seq = _GIDDY_FUNC;
            if(mdw->bRev){
                CommSetKeyReverseMode();
            }
            else{
                CommSetKeyRandMode();
            }
            FieldSystemProc_SeqHoldEnd();
        }
        break;
      case _GIDDY_FUNC:
        // ̓T[o[ŊǗ
        break;
      case _GIDDY_END:
        CommResetKeyRandMode();
        sys_FreeMemoryEz(work);
        TCB_Delete(tcb);
   //     return TRUE;
        break;
    }
    //return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief    E͂Ă㩏
 * @param    bRev   ]ȂTRUE
 * @retval   none
 */
//--------------------------------------------------------------

static void _trapGiddyInitialize(BOOL bRev)
{
    int i;
    _EVENT_GIDDY_WORK* mdw;

    mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_GIDDY_WORK));
    mdw->seq = 0;
    mdw->bRev = bRev;  // ]̃tO
    mdw->startTime = 0;
    _pCTW->pTCBWork = mdw;
    TCB_Add(_GMEVENT_Giddy,mdw,1);
    FieldSystemProc_SeqHold();
}

///---------------------hole

enum{
    _HOLE_INIT,
    _HOLE_FUNC,
    _HOLE_ENDING,
    _HOLE_END,
};

//--------------------------------------------------------------
/**
 * @brief    ȂI点֐
 * @param    event  CxgRg[[
 * @retval   ITRUE
 */
//--------------------------------------------------------------

static void _endClientHole(int netID)
{
    if(CommGetCurrentID() == netID){
        if(_pCTW->pTCBWork){
            _EVENT_HOLE_WORK * mdw = _pCTW->pTCBWork;
            mdw->seq = _HOLE_END;
            _pCTW->pTCBWork = NULL;
        }
    }
}


//==============================================================================
/**
 * Ȃ㩂I̊Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _priEndClientHole(int victimNetID)
{
    if(CommGetCurrentID() == victimNetID){
        if(_pCTW->pTCBWork){
            _EVENT_HOLE_WORK * mdw = _pCTW->pTCBWork;
            mdw->seq = _HOLE_ENDING;
        }
    }
}


//--------------------------------------------------------------
/**
 * @brief    Ȃ̃Cxg֐
 * @param    event  CxgRg[[
 * @retval   ITRUE
 */
//--------------------------------------------------------------

static void _GMEVENT_Hole(TCB_PTR tcb, void *work)
{
    _EVENT_HOLE_WORK * mdw = work;
    int i,xpos,zpos;
    const s8 jumpTbl[]={-1,3,7,11,15,14,13,12,11,9,7,5,3,1,-10};

    switch(mdw->seq){
      case _HOLE_INIT:
        mdw->startTime++;
        if(_TRAP_START_PAUSE_TIME < mdw->startTime){
            mdw->seq = _HOLE_FUNC;
            xpos = Player_NowGPosXGet( _pCTW->pFSys->player );
            zpos = Player_NowGPosZGet( _pCTW->pFSys->player );
            mdw->eoa = FE_Hole_Add(_pCTW->pFSys,xpos,zpos,0);
            if(!mdw->bBig){
                Player_VecPosYSet( _pCTW->pFSys->player, -2*FX32_ONE);  // 
            }
            else{
                Player_VecPosYSet( _pCTW->pFSys->player, -4*FX32_ONE);
            }
        }
        break;
      case _HOLE_FUNC:
        // ̓T[o[ŊǗ
        mdw->startTime=0;
        break;
      case _HOLE_ENDING:
        if(-10 != jumpTbl[mdw->startTime]){
            Player_VecPosYSet( _pCTW->pFSys->player,jumpTbl[mdw->startTime]*FX32_ONE);
            mdw->startTime++;
            if(mdw->startTime == 5){
                EOA_Delete(mdw->eoa);
            }
        }
        else{
        }
        break;
      case _HOLE_END:
        Player_VecPosYSet( _pCTW->pFSys->player,0);
        sys_FreeMemoryEz(work);
        TCB_Delete(tcb);
        break;
    }
}

//--------------------------------------------------------------
/**
 * @brief    Ȃ㩏
 * @param    bBig   ȂȂTRUE
 * @retval   none
 */
//--------------------------------------------------------------

static void _trapHoleInitialize(BOOL bBig)
{
    int i;
    _EVENT_HOLE_WORK* mdw;

    mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_HOLE_WORK));
    mdw->seq = 0;
    mdw->bBig = bBig;  // 傫ǂ
    mdw->startTime = 0;
    _pCTW->pTCBWork = mdw;
    TCB_Add(_GMEVENT_Hole,mdw,1);
//    FieldSystemProc_SeqHold();
}


//==============================================================================
/**
 * Ȃ㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientHole(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    if(CommGetCurrentID() == victimNetID){
        _trapHoleInitialize(FALSE);
    }
}

//==============================================================================
/**
 * Ȃ㩂Jn
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _startClientBigHole(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    if(CommGetCurrentID() == victimNetID){
        _trapHoleInitialize(TRUE);
    }
}

//==============================================================================
/**
 * Ȃ㩂I
 * @param   none
 * @retval  TCY
 */
//==============================================================================

static void _exitServerHole(int victimNetID)
{
    CommPlayerResetCondition(victimNetID);
    CommPlayerResetHole(victimNetID);
}



static void _startServerHole(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    if(CommGetCurrentID() == victimNetID){
        CommPlayerSetHole(victimNetID,_HOLE_STEP_NUM);
    }
}

static void _startServerBigHole(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_GIDDY);
    if(CommGetCurrentID() == victimNetID){
        CommPlayerSetHole(victimNetID,_BIGHOLE_STEP_NUM);
    }
}




//---------------blossoms

//--------------------------------------------------------------
/**
 * Ԃтuꏊe[uƗŌ߂
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

static u8 _pictureTableA[]={2,3,3,2,2,4,4,2,2,3,3,2};
static u8 _pictureTableB[]={3,2,2,3,3,2,2,3,4,2,2,4};
static u8 _pictureTableC[]={3,2,3,3,2,3,2,3,3,3,3,2};

static void _dirtyBlossomsAddPetal(_EVENT_DIRTYBLOSSOMS_WORK * mdw)
{
    int i, j , index, x,z;
    u8* pTable=NULL;
    MATHRandContext32 sRand;
    const int _WIDTH = 64;
    const int _HEIGHT = 60;

    CommRandSeedInitialize(&sRand);
    switch(MATH_Rand32(&sRand, 2)){
      case 0:
        pTable = _pictureTableA;
        break;
      case 1:
        pTable = _pictureTableB;
        break;
      case 2:
        pTable = _pictureTableC;
        break;
    }
    
    index = 0;
    for(i = 0; i < 12; i++){
        x = i % 4;
        z = i / 4;
        for(j = 0; j < pTable[i]; j++){
            mdw->oamGrid[index].xpos = MATH_Rand32(&sRand, _WIDTH) + x * _WIDTH;
            mdw->oamGrid[index].zpos = MATH_Rand32(&sRand, _HEIGHT) + z * _HEIGHT;
            index++;
        }
    }
}

//--------------------------------------------------------------
/**
 * Ԃт̕Cxgs
 * @param    
 * @retval   XW
 */
//--------------------------------------------------------------


typedef enum{
    _INIT,
    _CHAR_READ,
    _PAL_READ,
    _CELL_READ,
    _ANIM_READ,
    _SET_CLACT,
    _FUNC,
    _ENDCMD,
    _END,
    _END2 = 25,
};

static BOOL _GMEVENT_DirtyBlossoms(GMEVENT_CONTROL* event)
{
    FIELDSYS_WORK * fsys = FieldEvent_GetFieldSysWork(event);
    _EVENT_DIRTYBLOSSOMS_WORK * mdw = FieldEvent_GetSpecialWork(event);
    int i;

    switch(mdw->seq){
      case _INIT:
        _initCellActor();
//        mdw->eoa = FE_Exclamation_Add(Player_FieldOBJGet(fsys->player));
        // wipeɂłȂ̂ł̂܂
        ChangeBrightnessRequest(COMM_BRIGHTNESS_SYNC,_TRAP_DIRTYBLOSSOMS_BRIGHTNESS_LV,BRIGHTNESS_NORMAL,
                                PLANEMASK_BG0|PLANEMASK_BG3|PLANEMASK_OBJ,MASK_MAIN_DISPLAY);
        mdw->seq++;
        break;
      case _CHAR_READ: 	//chrǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] =
            CLACT_U_ResManagerResAddArcChar(_pCTW->resMan[CLACT_U_CHAR_RES], 
                                           ARC_UG_TRAP_GRA, NARC_ug_trap_blossoms_NCGR,
                                            0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_FIELD);
        mdw->seq++;
        break;
      case _PAL_READ: 	//palǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] =
            CLACT_U_ResManagerResAddArcPltt(_pCTW->resMan[CLACT_U_PLTT_RES],
                                            ARC_UG_TRAP_GRA, NARC_ug_trap_blossoms_NCLR,
                                            0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 7, HEAPID_FIELD);
        mdw->seq++;
        break;
      case _CELL_READ:	//cellǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] =
            CLACT_U_ResManagerResAddArcKindCell(_pCTW->resMan[CLACT_U_CELL_RES],
                                                ARC_UG_TRAP_GRA, NARC_ug_trap_blossoms_NCER,
                                                0, 0, CLACT_U_CELL_RES,HEAPID_FIELD);
        mdw->seq++;
        break;
      case _ANIM_READ:	//֐animǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] =
            CLACT_U_ResManagerResAddArcKindCell(_pCTW->resMan[CLACT_U_CELLANM_RES],
                                                ARC_UG_TRAP_GRA, NARC_ug_trap_blossoms_NANR,
                                                0, 0, CLACT_U_CELLANM_RES,HEAPID_FIELD);
        mdw->seq++;
        break;
      case _SET_CLACT:
        // \[X}l[W[]
        // Chara]
        CLACT_U_CharManagerSetCharModeAdjustAreaCont( _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
        // pbg]  CLACT_U_PlttManagerSetCleanArea
        CLACT_U_PlttManagerSetCleanArea( _pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
        _setCellActor();
        _dirtyBlossomsAddPetal(mdw); // zuvZ
        mdw->seq++;
      case _FUNC:
        if(_procDirtyBlossoms(fsys->bgl,mdw)){
            BOOL bRet = TRUE;
            CommSendFixSizeData(CF_TRAP_END, &bRet);    // gbvI
            mdw->seq = _ENDCMD;
        }
        break;
      case _ENDCMD:
        break;
      case _END:
		ChangeBrightnessRequest(COMM_BRIGHTNESS_SYNC,BRIGHTNESS_NORMAL,_TRAP_DIRTYBLOSSOMS_BRIGHTNESS_LV,
                                PLANEMASK_BG0|PLANEMASK_BG3|PLANEMASK_OBJ,MASK_MAIN_DISPLAY);
        _endCellActor(_CLACT_OAMNUM);
        mdw->seq++;
        break;
      default:
        if(_END2 <= mdw->seq){
            return TRUE;
        }
        else{
            mdw->seq++;
        }
        break;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * @brief    Ԃт̕I
 * @param    victimNetID 
 * @retval   none
 */
//--------------------------------------------------------------

static void _endClientDirtyBlossoms(int victimNetID)
{
    if(_pCTW->pEvent){
        _EVENT_DIRTYBLOSSOMS_WORK * mdw = FieldEvent_GetSpecialWork(_pCTW->pEvent);
        if(victimNetID == CommGetCurrentID()){
            mdw->seq = _END;
        }
        _pCTW->pEvent = NULL;
    }
}

//--------------------------------------------------------------
/**
 * Ԃт̕
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

static void _dirtyBlossomsInitialize(GF_BGL_INI * bgl)
{
    int i;
    _EVENT_DIRTYBLOSSOMS_WORK* mdw;

    mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_DIRTYBLOSSOMS_WORK));
    mdw->seq = 0;
    mdw->blowBase = 0;
    MI_CpuFill8(mdw->blowPos, 0, _CLACT_OAMNUM);
    MI_CpuFill8(mdw->blowRing, 0, _BLOW_FRAME);

    _pCTW->pEvent = FieldEvent_Set(_pCTW->pFSys, _GMEVENT_DirtyBlossoms, mdw);
}

//------------------------------------------------------------------
/**
 * 㩗pZAN^[
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------

static void _initCellActor(void)
{
	int i;
	// ZAN^[
	_pCTW->clactSet = CLACT_U_SetEasyInit( _CLACT_OAMNUM, &_pCTW->renddata, HEAPID_FIELD );

    CLACT_U_SetSubSurfaceMatrix( &_pCTW->renddata, SUB_SURFACE_X, SUB_SURFACE_Y*2 );
    
	//\[X}l[W[
	for(i=0;i<CLACT_RESOURCE_NUM;i++){		//\[X}l[W[쐬
		_pCTW->resMan[i] = CLACT_U_ResManagerInit(2, i, HEAPID_FIELD);
	}
}

//------------------------------------------------------------------
/**
 * 㩗pZAN^[I
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------

static void _endCellActor(int oamNum)
{
    int i;
    
    for(i = 0; i < oamNum ; i++){
        if(_pCTW->clActWork[i]!=NULL)
            CLACT_Delete(_pCTW->clActWork[i]);
    }
    // L]}l[W[j
    if(_pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES])
        CLACT_U_CharManagerDelete(_pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES]);
    // pbg]}l[W[j
    CLACT_U_PlttManagerDelete(_pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES]);
    // LEpbgEZEZAj̃\[X}l[W[j
    for(i=0;i < CLACT_RESOURCE_NUM ; i++){
        CLACT_U_ResManagerDelete(_pCTW->resMan[i]);
    }
    // ZAN^[Zbgj
    CLACT_DestSet(_pCTW->clactSet);
}

//------------------------------------------------------------------
/**
 * 㩃ZAN^[o^
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------
static void _setCellActor(void)
{
	// ZAN^[wb_쐬
    
	CLACT_U_MakeHeader(&_pCTW->clActHeader_s,
                       0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	_pCTW->resMan[CLACT_U_CHAR_RES],
	_pCTW->resMan[CLACT_U_PLTT_RES],
	_pCTW->resMan[CLACT_U_CELL_RES],
	_pCTW->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	{
		//o^i[
		CLACT_ADD add;
		int i;

		add.ClActSet	= _pCTW->clactSet;
		add.ClActHeader	= &_pCTW->clActHeader_s;

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINHASUBHj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 0;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_FIELD;

		//ZAN^[\Jn

		// ʗp
		for(i = 0; i < _CLACT_OAMNUM ; i++){
			add.mat.x = FX32_ONE*300;
			add.mat.y = FX32_ONE*300;
			_pCTW->clActWork[i] = CLACT_Add(&add);
            CLACT_AnmChg( _pCTW->clActWork[i], 0 );
            CLACT_SetAnmFlag(_pCTW->clActWork[i],1);
            CLACT_AnmFrameSet(_pCTW->clActWork[i],i);  // X^[gʒu𒲐
		}
	}	
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,  VISIBLE_ON);	//OBJʂnm
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
}

//--------------------------------------------------------------
/**
 * @brief   CELLACTORp[c
 * @param   index   
 * @return  none
 */
//--------------------------------------------------------------

static void _delCellActor(int index)
{
    
    if(_pCTW->clActWork[index]){
        CLACT_Delete(_pCTW->clActWork[index]);
        _pCTW->clActWork[index] = NULL;
    }
}

//--------------------------------------------------------------
/**
 * @brief   Ԃтanimʒu
 * @param   none
 * @return  none
 */
//--------------------------------------------------------------
static void _dartyBlossomsPos(int index,int x,int y)
{
    void* heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
    VecFx32 tmpVex;

    if(_pCTW->clActWork[index]){
        tmpVex.x = FX32_ONE * (x);
        tmpVex.y = FX32_ONE * (y);
        CLACT_SetMatrix(_pCTW->clActWork[index], &tmpVex);
    }
}

//------------------------------------------------------------------
/**
 * @brief   }CN蓮擾̃R[obN
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------

static s8 _mic ATTRIBUTE_ALIGN(32);  // ACg؂ĂȂƂȂ

static void _micCallBack( MICResult result, void* arg )
{
    if(result == MIC_RESULT_SUCCESS){
        _pCTW->mic = _mic;
    }
}

//--------------------------------------------------------------
/**
 * @brief    Ԃт̕
 * @param    bgl    GF_BGL_INI
 * @param    mdw    _EVENT_DIRTYBLOSSOMS_WORK
 * @retval   =TRUE
 */
//--------------------------------------------------------------

static BOOL _procDirtyBlossoms(GF_BGL_INI * bgl, _EVENT_DIRTYBLOSSOMS_WORK* mdw)
{
    int i;
    int pow=0,pos, ans,delCnt,powPos;
    fx32 x,z,alpha;
    
    // 蓮TvO
    Snd_MicManualSampling(MIC_SAMPLING_TYPE_SIGNED_8BIT,&_mic,_micCallBack,NULL);


    for(i = 0; i < _CLACT_OAMNUM; i++){
        _dartyBlossomsPos(i, mdw->oamGrid[i].xpos, mdw->oamGrid[i].zpos);
    }
#if 1
    {  // ̗ ߂
        pow = abs(_pCTW->mic) / 33;  // RRłĂ
        GF_ASSERT(pow < 4);
        mdw->blowRing[ mdw->blowBase ] = pow;
    }

    for(i = 0; i < _CLACT_OAMNUM;i++){
        if(_pCTW->clActWork[i]){
            break;
        }
    }
    if(i == _CLACT_OAMNUM){  // 
        return TRUE;
    }
    for(i = 0; i < _CLACT_OAMNUM;i++){// ɂړ
        // ړ
        if((mdw->oamGrid[i].xpos <= 0) || (mdw->oamGrid[i].xpos >= 256) ||
           (mdw->oamGrid[i].zpos <= 0) || (mdw->oamGrid[i].zpos >= 192)){
            _delCellActor(i);
            continue;
        }
        powPos = mdw->blowBase - mdw->blowPos[ i ];
        if(powPos < 0){
            powPos += _BLOW_FRAME;
        }
        pow = mdw->blowRing[ powPos ];
        x = mdw->oamGrid[i].xpos - 128;
        z = mdw->oamGrid[i].zpos - 96;
        x *= FX32_ONE;
        z *= FX32_ONE;
        alpha = FX_Mul(x , x) + FX_Mul(z , z);
        alpha = FX_Sqrt(alpha);

        
        if(pow == 0){   // ~  ʒuo
            x = FX_Mul( FX_Div( alpha, (160 * FX32_ONE)), (_BLOW_FRAME-2) * FX32_ONE);
            mdw->blowPos[ i ] = FX_Whole(x);
        }
        else{
            fx32 x = mdw->oamGrid[i].xpos - 128;
            fx32 z = mdw->oamGrid[i].zpos - 96;
            if(z == 0){
                if(x < 0){
                    mdw->oamGrid[i].xpos -= pow;
                }
                else{
                    mdw->oamGrid[i].xpos += pow;
                }
            }
            else if(x == 0){
                if(z < 0){
                    mdw->oamGrid[i].zpos -= pow;
                }
                else{
                    mdw->oamGrid[i].zpos += pow;
                }
            }
            else{
                {
                    u16 radIdx = FX_Atan2Idx(z , x);
                    alpha += pow*FX32_ONE;
                    ans = FX_Whole(FX_Mul(FX_SinIdx(radIdx) , alpha));
                    mdw->oamGrid[i].zpos = ans + 96;
                    ans = FX_Whole(FX_Mul(FX_CosIdx(radIdx) , alpha));
                    mdw->oamGrid[i].xpos = ans + 128;
                }
            }
        }
    }
    mdw->blowBase++;
    if(mdw->blowBase >= _BLOW_FRAME){
        mdw->blowBase = 0;
    }
    
#endif



	CLACT_Draw( _pCTW->clactSet );									// ZAN^[풓֐
    return FALSE;
}

//--------------------------------------------------------------
/**
 * 㩓실ʎs֐
 * @param    bgl  GF_BGL_INI
 * @retval   none
 */
//--------------------------------------------------------------

void UgTrapProcess(GF_BGL_INI* bgl)
{

    if(_pCTW->trapProc){
        _pCTW->trapProc(bgl);
    }
}







//--------------------------------------bubble
//--------------------------------------------------------------
/**
 * Auꏊe[uƗŌ߂
 * @param    none
 * @retval   none
 */
//--------------------------------------------------------------

//static u8 _pictureTableA_Bubble[]={2,2,1,2,1,2,2,2,2,1,2,1};
static const int _BUBBLE_HALFSIZE[]={32,24,16};

static void _bubbleAddPetal(_EVENT_BUBBLE_WORK* mdw)
{
    int index, x,z,bigNum,middleNum,size;
    MATHRandContext32 sRand;
    const int _WIDTH = 256;
    const int _HEIGHT = 192;

    CommRandSeedInitialize(&sRand);
    
    bigNum = MATH_Rand32(&sRand,2)+1;
    middleNum = MATH_Rand32(&sRand,3) + bigNum + 5;
    
    for(index = 0; index < _CLACT_BUBBLE_OAMNUM; index++){
        if( index < bigNum){
            mdw->size[index] = 0;
        }
        else if(index < middleNum){
            mdw->size[index] = 1;
        }
        else{
            mdw->size[index] = 2;
        }
        size = _BUBBLE_HALFSIZE[mdw->size[index]];
        x = _WIDTH - size*2;
        z = _HEIGHT - size*2;
        mdw->oamGrid[index].xpos = (MATH_Rand32(&sRand, x) + size) * FX32_ONE;
        mdw->oamGrid[index].zpos = (MATH_Rand32(&sRand, z) + size) * FX32_ONE;
        mdw->dirIdx[index] = MATH_Rand32(&sRand,0xffff);
    }
}

//--------------------------------------------------------------
/**
 * BUBBLECxgs
 * @param    
 * @retval   XW
 */
//--------------------------------------------------------------

static BOOL _GMEVENT_Bubble(GMEVENT_CONTROL* event)
{
    FIELDSYS_WORK* fsys = FieldEvent_GetFieldSysWork(event);
    _EVENT_BUBBLE_WORK* mdw = FieldEvent_GetSpecialWork(event);
    int i;

    switch(mdw->seq){
      case _INIT:
        _initCellActor();
//        mdw->eoa = FE_Exclamation_Add(Player_FieldOBJGet(fsys->player));
        ChangeBrightnessRequest(COMM_BRIGHTNESS_SYNC,_TRAP_DIRTYBLOSSOMS_BRIGHTNESS_LV,BRIGHTNESS_NORMAL,
                                PLANEMASK_BG0|PLANEMASK_BG3|PLANEMASK_OBJ,MASK_MAIN_DISPLAY);
        mdw->seq++;
        break;
      case _CHAR_READ: 	//chrǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] =
            CLACT_U_ResManagerResAddArcChar(_pCTW->resMan[CLACT_U_CHAR_RES], 
                                           ARC_UG_TRAP_GRA, NARC_ug_trap_bubble_NCGR,
                                            0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_FIELD);
        mdw->seq++;
        break;
      case _PAL_READ: 	//palǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] =
            CLACT_U_ResManagerResAddArcPltt(_pCTW->resMan[CLACT_U_PLTT_RES],
                                            ARC_UG_TRAP_GRA, NARC_ug_trap_bubble_NCLR,
                                            0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 7, HEAPID_FIELD);
        mdw->seq++;
        break;
      case _CELL_READ:	//cellǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] =
            CLACT_U_ResManagerResAddArcKindCell(_pCTW->resMan[CLACT_U_CELL_RES],
                                                ARC_UG_TRAP_GRA, NARC_ug_trap_bubble_NCER,
                                                0, 0, CLACT_U_CELL_RES,HEAPID_FIELD);
        mdw->seq++;
        break;
      case _ANIM_READ:	//֐animǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] =
            CLACT_U_ResManagerResAddArcKindCell(_pCTW->resMan[CLACT_U_CELLANM_RES],
                                                ARC_UG_TRAP_GRA, NARC_ug_trap_bubble_NANR,
                                                0, 0, CLACT_U_CELLANM_RES,HEAPID_FIELD);
        mdw->seq++;
        break;
      case _SET_CLACT:
        _bubbleAddPetal(mdw); // zuvZ
        _setCellActorBubble(mdw);
        mdw->seq++;
      case _FUNC:
        if(_procBubble(fsys->bgl,mdw)){
            BOOL bRet = TRUE;
            CommSendFixSizeData(CF_TRAP_END, &bRet);    // gbvI
            mdw->seq = _ENDCMD;
        }
        break;
      case _ENDCMD:
        break;
      case _END:
        ChangeBrightnessRequest(COMM_BRIGHTNESS_SYNC,BRIGHTNESS_NORMAL,_TRAP_DIRTYBLOSSOMS_BRIGHTNESS_LV,
                                PLANEMASK_BG0|PLANEMASK_BG3|PLANEMASK_OBJ,MASK_MAIN_DISPLAY);
        _endCellActor(_CLACT_BUBBLE_OAMNUM);
        mdw->seq++;
        break;
      default:
        if(_END2 <= mdw->seq){
            return TRUE;
        }
        else{
            mdw->seq++;
        }
        break;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * bubble
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

static void _bubbleInitialize(GF_BGL_INI * bgl)
{
    int i;
    _EVENT_BUBBLE_WORK* mdw;

    mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_BUBBLE_WORK));
    MI_CpuFill8(mdw,0,sizeof(_EVENT_BUBBLE_WORK));

    _pCTW->pEvent = FieldEvent_Set(_pCTW->pFSys, _GMEVENT_Bubble, mdw);
}

//------------------------------------------------------------------
/**
 * 㩃ZAN^[o^
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------
static void _setCellActorBubble(_EVENT_BUBBLE_WORK* mdw)
{
    // \[X}l[W[]
    // Chara]
    CLACT_U_CharManagerSetCharModeAdjustAreaCont( _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
    // pbg]  CLACT_U_PlttManagerSetCleanArea
    CLACT_U_PlttManagerSetCleanArea( _pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
	// ZAN^[wb_쐬
    CLACT_U_MakeHeader(&_pCTW->clActHeader_s,
                       0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
	0, 0,
	_pCTW->resMan[CLACT_U_CHAR_RES],
	_pCTW->resMan[CLACT_U_PLTT_RES],
	_pCTW->resMan[CLACT_U_CELL_RES],
	_pCTW->resMan[CLACT_U_CELLANM_RES],
	NULL,NULL);

	{
		//o^i[
		CLACT_ADD add;
		int i;

		add.ClActSet	= _pCTW->clactSet;
		add.ClActHeader	= &_pCTW->clActHeader_s;

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINHASUBHj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 0;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_FIELD;

		//ZAN^[\Jn

		// ʗp
		for(i = 0; i < _CLACT_BUBBLE_OAMNUM ; i++){
			add.mat.x = FX32_ONE*300;
			add.mat.y = FX32_ONE*300;
			_pCTW->clActWork[i] = CLACT_Add(&add);
            CLACT_SetAffineParam(_pCTW->clActWork[i],CLACT_AFFINE_DOUBLE);
            CLACT_AnmChg( _pCTW->clActWork[i], (mdw->size[i]*2));
            CLACT_SetAnmFlag(_pCTW->clActWork[i],1);
            CLACT_AnmFrameSet(_pCTW->clActWork[i],i%2);
		}
	}	
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,  VISIBLE_ON);	//OBJʂnm
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
}

//--------------------------------------------------------------
/**
 * @brief   ouʒu
 * @param   none
 * @return  none
 */
//--------------------------------------------------------------
static void _bubblePos(int i,_EVENT_BUBBLE_WORK* mdw)
{
    void* heap;
	GF_CAMERA_PTR camera_ptr;
	void *resource;
    VecFx32 tmpVex;

    
    if(_pCTW->clActWork[i]){
        tmpVex.x = mdw->oamGrid[i].xpos;
        tmpVex.y = mdw->oamGrid[i].zpos;
        CLACT_SetMatrix(_pCTW->clActWork[i], &tmpVex);
    }
}

//--------------------------------------------------------------
/**
 * @brief    BUBBLE
 * @param    bgl    GF_BGL_INI
 * @param    mdw    _EVENT_BUBBLE_WORK
 * @retval   =TRUE
 */
//--------------------------------------------------------------

static BOOL _procBubble(GF_BGL_INI * bgl, _EVENT_BUBBLE_WORK* mdw)
{
    int i;
    int pow=0,pos, delCnt,powPos,size,zint,xint;
    fx32 x,z,alpha,ans;
 
    delCnt=0;
    for(i = 0; i < _CLACT_BUBBLE_OAMNUM; i++){
        if(mdw->bEnd[i]==FALSE){
            _bubblePos(i, mdw);
        }
        else{
            delCnt++;
        }
    }
    if(delCnt == _CLACT_BUBBLE_OAMNUM){  // 
        return TRUE;
    }

    if(sys.tp_trg){
        for(i = _CLACT_BUBBLE_OAMNUM-1; i >= 0 ;i--){ // Č ̂D
            if(mdw->bEnd[i]){
                continue;
            }
            x = sys.tp_x * FX32_ONE - mdw->oamGrid[i].xpos;
            z = sys.tp_y * FX32_ONE - mdw->oamGrid[i].zpos;
            ans = FX_Mul(x,x)+FX_Mul(z,z);
            ans = FX_Sqrt(ans);
            if((_BUBBLE_HALFSIZE[mdw->size[i]] * FX32_ONE) > ans){
                CLACT_AnmChg( _pCTW->clActWork[i], mdw->size[i]*2+1); // AjύX
                mdw->bEnd[i]=TRUE;
                break;
            }
        }
    }
    for(i = 0; i < _CLACT_BUBBLE_OAMNUM;i++){// ӂӂړ
        if(mdw->bEnd[i]){
            continue;
        }
        // ړ
        ans = FX_SinIdx(mdw->dirIdx[i]);
        mdw->oamGrid[i].zpos -= ans;
        ans = FX_CosIdx(mdw->dirIdx[i]);
        mdw->oamGrid[i].xpos += ans;
        size = _BUBBLE_HALFSIZE[mdw->size[i]];
        if(mdw->oamGrid[i].zpos < ((0+size)*FX32_ONE)){
            mdw->dirIdx[i] = 0xffff - mdw->dirIdx[i];
        }
        else if(mdw->oamGrid[i].zpos >= ((192-size)*FX32_ONE)){
            mdw->dirIdx[i] = 0xffff - mdw->dirIdx[i];
        }
        if(mdw->oamGrid[i].xpos < ((0+size)*FX32_ONE)){
            mdw->dirIdx[i] = 0xffff - (mdw->dirIdx[i] - 0x8000);
        }
        else if(mdw->oamGrid[i].xpos >= ((256-size)*FX32_ONE) ){
            mdw->dirIdx[i] = 0xffff - (mdw->dirIdx[i] - 0x8000);
        }
    }


    CLACT_Draw( _pCTW->clactSet );									// ZAN^[풓֐
    return FALSE;
}

//==============================================================================
/**
 * bubble㩂Jn
 * @param   victimNetID  㩔Q
 * @retval  none
 */
//==============================================================================

static void _startClientBubble(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_SMOG);
    if(CommGetCurrentID() == victimNetID){
        _bubbleInitialize(_pCTW->pFSys->bgl);
    }
}

//--------------------------------------------------------------
/**
 * BUBBLET[o[Jn
 * @param   victimNetID   㩔Q
 * @retval  none
 */
//--------------------------------------------------------------

static void _startServerBubble(int victimNetID)
{
    CommPlayerSetCondition(victimNetID, PLAYER_COND_SMOG);
}

//--------------------------------------------------------------
/**
 * @brief    babbleI
 * @param    victimNetID 
 * @retval   none
 */
//--------------------------------------------------------------

static void _endClientBubble(int victimNetID)
{
    if(_pCTW->pEvent){
        _EVENT_BUBBLE_WORK* mdw = FieldEvent_GetSpecialWork(_pCTW->pEvent);
        if(victimNetID == CommGetCurrentID()){
            mdw->seq = _END;
        }
        _pCTW->pEvent = NULL;
    }
}

///-----------------------touch

//--------------------------------------------------------------
/**
 * @brief    BUBBLE
 * @param    bgl    GF_BGL_INI
 * @param    mdw    _EVENT_BUBBLE_WORK
 * @retval   =TRUE
 */
//--------------------------------------------------------------

#define ONE_GRID_SIZE	(16)

static BOOL _procTouchRadar(GF_BGL_INI * bgl, _EVENT_TOUCHRADAR_WORK* mdw)
{
    int i,j;
    VecFx32 tmpVex;
    int x,z,efX,efZ;

    tmpVex.x = mdw->scrXpos * FX32_ONE;
    tmpVex.y = mdw->scrZpos * FX32_ONE;
    CLACT_SetMatrix(_pCTW->clActWork[0], &tmpVex);

    for(j = 0; j < 2;j++){
        for(i = 0; i < mdw->touchSize[j]; i++){
            efZ = mdw->pTouchBuff[j][i] / 16;
            efX = mdw->pTouchBuff[j][i] % 16;
            
            tmpVex.x = (mdw->touchXpos - 6 + efX) * FX32_ONE * ONE_GRID_SIZE + (FX32_ONE*ONE_GRID_SIZE/2);
            tmpVex.y = 0;
            tmpVex.z = (mdw->touchZpos - 6 + efZ) * FX32_ONE * ONE_GRID_SIZE + (FX32_ONE*ONE_GRID_SIZE/2);
            
            NNS_G3dWorldPosToScrPos(&tmpVex, &x, &z);
            
            tmpVex.x = x * FX32_ONE;
            tmpVex.y = z * FX32_ONE;
            CLACT_SetMatrix(_pCTW->clActWork[i+1+j*8], &tmpVex);
        }
    }
    mdw->timer++;
    if(mdw->timer > 30){
        return TRUE;
    }
    CLACT_Draw( _pCTW->clactSet );									// ZAN^[풓֐
    return FALSE;
}


//------------------------------------------------------------------
/**
 * ZAN^[o^
 * @param   none
 * @retval  none		
 */
//------------------------------------------------------------------
static void _setCellActorTouchRadar(_EVENT_TOUCHRADAR_WORK* mdw)
{
    // \[X}l[W[]
    // Chara]
    CLACT_U_CharManagerSetCharModeAdjustAreaCont( _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] );
    // pbg]  CLACT_U_PlttManagerSetCleanArea
    CLACT_U_PlttManagerSetCleanArea( _pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] );
	// ZAN^[wb_쐬
    CLACT_U_MakeHeader(&_pCTW->clActHeader_s,
                       0, 0, 0, 0, CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
                       0, 0,
                       _pCTW->resMan[CLACT_U_CHAR_RES],
                       _pCTW->resMan[CLACT_U_PLTT_RES],
                       _pCTW->resMan[CLACT_U_CELL_RES],
                       _pCTW->resMan[CLACT_U_CELLANM_RES],
                       NULL,NULL);

	{
		//o^i[
		CLACT_ADD add;
		int i;

		add.ClActSet	= _pCTW->clactSet;
		add.ClActHeader	= &_pCTW->clActHeader_s;

		add.mat.x		= FX32_CONST(32) ;
		add.mat.y		= FX32_CONST(96) ;		//ʂ͏㉺AĂiMAINHASUBHj
		add.mat.z		= 0;
		add.sca.x		= FX32_ONE;
		add.sca.y		= FX32_ONE;
		add.sca.z		= FX32_ONE;
		add.rot			= 0;
		add.pri			= 0;
		add.DrawArea	= NNS_G2D_VRAM_TYPE_2DMAIN;
		add.heap		= HEAPID_FIELD;

		//ZAN^[\Jn

		// ʗp
		for(i = 0; i < _CLACT_TOUCHRADAR_OAMNUM ; i++){
			add.mat.x = FX32_ONE*300;
			add.mat.y = FX32_ONE*300;
			_pCTW->clActWork[i] = CLACT_Add(&add);
            if(i == 0){
                CLACT_SetAffineParam(_pCTW->clActWork[i],CLACT_AFFINE_DOUBLE);
                CLACT_AnmChg( _pCTW->clActWork[i], 0);
            }
            else if (i < 9){
                CLACT_AnmChg( _pCTW->clActWork[i], 1);
            }
            else{
                CLACT_AnmChg( _pCTW->clActWork[i], 2);
            }
            CLACT_SetAnmFlag(_pCTW->clActWork[i],1);
            CLACT_AnmFrameSet(_pCTW->clActWork[i],0);
		}
	}	
	GF_Disp_GX_VisibleControl(GX_PLANEMASK_OBJ,  VISIBLE_ON);	//OBJʂnm
	GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
}

//--------------------------------------------------------------
/**
 * BUBBLECxgs
 * @param    
 * @retval   XW
 */
//--------------------------------------------------------------

static BOOL _GMEVENT_Touch(GMEVENT_CONTROL* event)
{
    FIELDSYS_WORK* fsys = FieldEvent_GetFieldSysWork(event);
    _EVENT_TOUCHRADAR_WORK* mdw = FieldEvent_GetSpecialWork(event);
    int i;

    switch(mdw->seq){
      case _INIT:
        _initCellActor();
        mdw->seq++;
        break;
      case _CHAR_READ: 	//chrǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CHAR_RES] =
            CLACT_U_ResManagerResAddArcChar(_pCTW->resMan[CLACT_U_CHAR_RES], 
                                           ARC_UG_TRAP_GRA, NARC_ug_trap_touchcircle_NCGR,
                                            0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, HEAPID_FIELD);
        mdw->seq++;
        break;
      case _PAL_READ: 	//palǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_PLTT_RES] =
            CLACT_U_ResManagerResAddArcPltt(_pCTW->resMan[CLACT_U_PLTT_RES],
                                            ARC_UG_TRAP_GRA, NARC_ug_trap_touchcircle_NCLR,
                                            0, 0, NNS_G2D_VRAM_TYPE_2DMAIN, 7, HEAPID_FIELD);
        mdw->seq++;
        break;
      case _CELL_READ:	//cellǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CELL_RES] =
            CLACT_U_ResManagerResAddArcKindCell(_pCTW->resMan[CLACT_U_CELL_RES],
                                                ARC_UG_TRAP_GRA, NARC_ug_trap_touchcircle_NCER,
                                                0, 0, CLACT_U_CELL_RES,HEAPID_FIELD);
        mdw->seq++;
        break;
      case _ANIM_READ:	//֐animǂݍ
        _pCTW->resObjTbl[MAIN_LCD][CLACT_U_CELLANM_RES] =
            CLACT_U_ResManagerResAddArcKindCell(_pCTW->resMan[CLACT_U_CELLANM_RES],
                                                ARC_UG_TRAP_GRA, NARC_ug_trap_touchcircle_NANR,
                                                0, 0, CLACT_U_CELLANM_RES,HEAPID_FIELD);
        mdw->seq++;
        break;
      case _SET_CLACT:
        _setCellActorTouchRadar(mdw);
        mdw->seq++;
      case _FUNC:
        if(_procTouchRadar(fsys->bgl,mdw)){
            mdw->seq = _END;
        }
        break;
      case _END:
        _endCellActor(_CLACT_TOUCHRADAR_OAMNUM);
        return TRUE;
      default:
        break;
    }
    return FALSE;
}

//--------------------------------------------------------------
/**
 * touchiȂł͂Ȃjs
 * @param    index
 * @retval   XW
 */
//--------------------------------------------------------------

void UgTouchRadarStart(FIELDSYS_WORK* pFSys,int xpos,int zpos,int scrxpos,int scrzpos,
                       u8* touchBuff1,int size1,u8* touchBuff2,int size2)
{
    int i;
    _EVENT_TOUCHRADAR_WORK* mdw;

    mdw = sys_AllocMemoryLo(HEAPID_WORLD, sizeof(_EVENT_TOUCHRADAR_WORK));
    MI_CpuFill8(mdw, 0, sizeof(_EVENT_TOUCHRADAR_WORK));

    mdw->timer = 0;
    mdw->touchXpos = xpos;
    mdw->touchZpos = zpos;
    mdw->scrXpos = scrxpos;
    mdw->scrZpos = scrzpos;
    mdw->pTouchBuff[0] = touchBuff1;
    mdw->pTouchBuff[1] = touchBuff2;
    mdw->touchSize[0] = size1;
    mdw->touchSize[1] = size2;

    _pCTW->pTouchEvent = FieldEvent_Set(pFSys, _GMEVENT_Touch , mdw);
}


