//=============================================================================
/**
 * @file	ug_trap.h
 * @brief	n㩏ۑNX
             PU~PU݂Ȃ̂ŁA̕mۂĂ܂
 * @author	Katsumi Ohno
 * @date    2005.09.28
 */
//=============================================================================

#ifndef __UG_TRAP_H__
#define __UG_TRAP_H__


#include "gflib/bg_system.h"
#include "savedata/undergrounddata.h"

#define TRAP_NUM_SINGLE_MAX (UG_TRAP_PLACE_NUM_MAX)      ///< l̏ꍇ̃gbvő吔

#include "field/ug_itemtype.h"

extern void CommTrapInfoInitialize(void* pWork, FIELDSYS_WORK* pFSys);
extern void CommTrapInfoReset(void);
extern void CommTrapInfoReboot(void);
extern void CommTrapInfoFinalize(void);
extern int CommTrapInfoGetWorkSize(void);
extern int CommTrapInfoGetTrapDataSize(void);
extern void CommTrapInfoAddTrap(u8 trapType);
extern void CommTrapInfoRemoveTrap(int netID, int trapIndex);
extern int CommTrapInfoGetTrapPosSize(void);
extern void CommTrapInfoProcess(void);
extern void CommTrapInfoChildSendStart(void);
extern void CommTrapInfoRecvTrapDefuse(int netID, int size, void* pData, void* pWork);
extern void CommTrapInfoRecvTrapData(int netID, int size, void* pData, void* pWork);
extern int CommTrapInfoGetTrapDataResultSize(void);
extern void CommTrapInfoRecvTrapDataResult(int netID, int size, void* pData, void* pWork);
extern void CommTrapInfoRecvTrapDataDel(int netID, int size, void* pData, void* pWork);
extern int CommTrapInfoGetTrapDataDelSize(void);
extern void CommTrapInfoRecvArrayStart(int netID, int size, void* pData, void* pWork);
extern void CommTrapInfoRecvArrayData(int netID, int size, void* pData, void* pWork);
extern void CommTrapInfoRecvServerPosData(int netID, int size, void* pData, void* pWork);
extern void CommTrapInfoRecvArrayEnd(int netID, int size, void* pData, void* pWork);

extern void CommTrapInfoRecvResult(int netID, int size, void* pData, void* pWork);
extern int CommTrapInfoGetResultSize(void);
extern BOOL CommTrapInfoIsParentRecv(void);
extern void CommTrapInfoResetParentRecv(void);
extern int CommTrapInfoGetTouchSize(void);
extern void CommTrapInfoRecvTouch(int netID, int size, void* pData, void* pWork);
extern void CommTrapInfoRecvTouchResult(int netID, int size, void* pData, void* pWork);


extern BOOL CommTrapCheck(int x,int z);
extern int CommTrapGetStartSize(void);
extern BOOL CommTrapCheckAndSendMessage(int netID);
extern void CommTrapRecvStart(int netID, int size, void* pData, void* pWork);

extern BOOL CommTrapGetActionMessage(STRBUF* pStrBuf);
extern BOOL CommTrapSetActionMessage(STRBUF* pStrBuf);

extern BOOL CommTrapFrontTrapDefuse(int netID, Grid* pTouch);
extern void CommTrapTouch(int netID, Grid* pTouch);
extern int CommTrapInfoRecvTrapDefuseSize(void);

extern void CommTrapDirBreak(int netID);  // QŒf
extern void CommTrapRecvDirBreak(int netID, int size, void* pData, void* pWork);

extern void CommTrapSmogInitialize(GF_BGL_INI* bgl);
extern BOOL CommTrapIsSmogTouch(void);
/// ^b`pl^b`Ăꍇ̂
extern void CommTrapSmogTouch(Grid* pGrid, GF_BGL_INI * bgl);

extern void CommTrapSendRelease(int netID, int targetID);
extern int CommTrapGetEndResultSize(void);
extern void CommTrapRecvEnd(int netID, int size, void* pData, void* pWork);
extern void CommTrapRecvEndResult(int netID, int size, void* pData, void* pWork);
extern void CommTrapRecvRelease(int netID, int size, void* pData, void* pWork);
extern int CommTrapGetReleaseSize(void);

/// 㩂̏ꏊ𓾂
extern int CommTrapGetMyTrapX(int index);
extern int CommTrapGetMyTrapZ(int index);

// 㩎s֐
extern void UgTrapProcess(GF_BGL_INI* bgl);
extern void CommTrapRecvPriEnd(int netID, int size, void* pData, void* pWork);

extern void UgTouchRadarStart(FIELDSYS_WORK* pFSys,int xpos,int zpos,int scrxpos,int scrzpos,
                              u8* touchBuff1,int size1,u8* touchBuff2,int size2);


#endif // __UG_TRAP_H__

