//=============================================================================
/**
 * @file	comm_union_beacon.c
 * @brief	jI[r[R
 * @author	Akito Mori
 * @date    	2006.03.16
 */
//=============================================================================
#include "common.h"

#include "gflib/strbuf.h"
#include "system/wordset.h"
#include "fieldobj_code.h"
#include "msgdata/msg_trtype.h"

// jI[ŕ\g[i[̃^CvځOe[u
static const int UnionViewTable[][2]={

	{ BABYBOY1,		MSG_TRTYPE_BOY},		///< |Pg[i[
	{ BOY1,			MSG_TRTYPE_TANPAN},		///< ς񂱂
	{ BOY2,			MSG_TRTYPE_CAMPB},		///< Lv{[C
	{ MAN1,			MSG_TRTYPE_ELITEM},		///< G[gg[i[
	{ MAN2,			MSG_TRTYPE_SWIMMERM},	///< ς낤
	{ MIDDLEMAN1,	MSG_TRTYPE_VETERAN},	///< xeg[i[
	{ MOUNT,		MSG_TRTYPE_MOUNT},		///< ܂Ƃ
	{ OLDMAN1,		MSG_TRTYPE_GENTLE},		///< WFg}

	{ BABYGIRL1,	MSG_TRTYPE_SCHOOLG},	///< キ
	{ GIRL1,		MSG_TRTYPE_MINI},		///< ~jXJ[g
	{ GIRL2,		MSG_TRTYPE_PRINCESS},	///< 傤
	{ WOMAN1,		MSG_TRTYPE_AROMA},		///< A}Ȃ˂
	{ WOMAN2,		MSG_TRTYPE_ELITEW},		///< G[gg[i[
	{ MIDDLEWOMAN1,	MSG_TRTYPE_DAISUKIW},	///< Nu
	{ WOMAN3,		MSG_TRTYPE_WAITRESS},	///< EFCgX
	{ OLDWOMAN1,	MSG_TRTYPE_MADAM},		///< }_

};

// ڕύX₶p̃e[uiIDWŊ܂ɑΉj
static const int UnionViewNameTable[][4]={
	{0,1,2,3,},
	{1,6,7,0,},

	{2,3,4,5,},
	{3,0,5,6,},

	{4,1,2,7,},
	{5,2,7,0,},

	{6,3,4,1,},
	{7,4,5,6,},
};

#define UNION_VIEW_SELECT_NUM	( 4 )
#define UNION_VIEW_SELECT_TYPE	( 8 )

//==============================================================================
/**
 * $brief   IDƐʂIłS̃g[i[^Cv̕i[
 *
 * @param   id			[U[ID
 * @param   sex			
 * @param   wordset		i[obt@
 *
 * @retval  none		
 */
//==============================================================================
void UnionView_SetUpTrainerTypeSelect( u32 id, int sex, WORDSET *wordset )
{
	int key    = id%8;
	int i;

	key = 0;
	// IDWŊ]ŁAΉ4̑I𐫕ʂƂɗpӂ

	for(i=0; i<UNION_VIEW_SELECT_NUM; i++){
		int patern = UnionViewNameTable[key][i] + UNION_VIEW_SELECT_TYPE * sex;
		WORDSET_RegisterTrTypeName( 	  wordset, i, UnionViewTable[patern][1] );
	}


}


//==============================================================================
/**
 * $brief   Iʂ猈肵g[i[^Cv̔ԍ̂̂Zo
 *
 * @param   id			[U[ID
 * @param   sex			
 * @param   select		Iʁi0-3)
 *
 * @retval  int		
 */
//==============================================================================
int UnionView_GetTrainerType( u32 id, int sex, u32 select )
{
	int key    = id%8;
	int patern = UnionViewNameTable[key][select] + UNION_VIEW_SELECT_TYPE * sex;

	return UnionViewTable[patern][0];
}
