
//===========================================================================
/**
 *
 *@file		union_board.c
 *@brief	jI[f\iTuʁj
 *@author	Akito Mori
 *@data		2006.02.03
 *
 */
//===========================================================================

#define DEBUG_UNION_BOARD	0


#include "common.h"
#include "gflib/touchpanel.h"

#include "system/lib_pack.h"
#include "system/arc_tool.h"
#include "system/arc_util.h"

#include "system/clact_util.h"
#include "system/render_oam.h"
#include "system/pm_str.h"
#include "gflib/strbuf_family.h"

#include "system/bmp_menu.h"
#include "system/bmp_tool.h"
#include "system/window.h"
#include "system/fontproc.h"
#include "system/pms_word.h"

#include "fld_bmp.h"
#include "fieldmap.h"
#include "fieldsys.h"
#include "talk_msg.h"

#include "communication/communication.h"
#include "underground/ug_manager.h"
#include "comm_player.h"
#include "unionroom.naix"
#include "union_board.h"

#include "comm_union.h"
#include "comm_union_view.h"
#include "comm_union_view_def.h"
#include "comm_union_beacon.h"

//========================================================================================
// 萔錾
//========================================================================================

#define UNION_BOARD_RESOURCE_ID	( 999 ) // ʂ̃\[XhcՓ˂Ȃ悤ɂ邽߂1000Ƃ


// CellActorɏ郊\[X}l[W̐i}`ZE}`ZAj͎gpȂj
#define CELL_ANIME_RESOURCE_NUM		(4)

// jI{[hɕ\OBJ̐
#define UNION_BOARD_OBJ_PARTS_NUM	(3)	

// Yz[_[̃^XN̗D揇ʁiʐM͉ɂKvƂƎv̂Łj
#define UNION_BOARD_TCB_PRIORITY	(4)

// ʂɕ\ȈՉb̐
#define UNION_BOARD_CARD_NUM		( 3 )

#define UNION_BOARD_CLACT_MAX			( 10 )

#define MESSAGE_NONE		( 0 )
#define MESSAGE_WAIT		( 1 )
#define MESSAGE_END			( 2 )


#define UNION_CHAT_MAX		( 30 )

#define _EVWIN_MSG_BUF_SIZE		(50*2)			//bZ[Wobt@TCY
#define TRAINER_NAME_SIZE		( 8 ) 

// -----Yz[_[̃V[PX`---------
enum{
	UNIONBOARD_INIT_BG = 0,
	UNIONBOARD_INIT_ACTOR,
	UNIONBOARD_MAIN,
	UNIONBOARD_END,
};



static const STRCODE d_names[][8]={
	{a_,ki_,to_,EOM_},
	{hu_,mi_,no_,ri_,EOM_},
	{ti_,e_,mi_,EOM_},
};

//========================================================================================
// \̐錾
//========================================================================================
typedef struct{
	u16 max;
	u16 old_max;
	u16 now;
	u16 barflag;
}UNION_SCROLL;

typedef struct{
	STRBUF		*name;
    STRBUF		*message;
	u32			id;
	int			sex;
	PMS_DATA	PmsData;
}UNION_CHAT;

typedef struct{
	UNION_CHAT mes[UNION_CHAT_MAX];
	int 		  num;
	int			  start;
}UNION_CHAT_RINGBUF;

typedef struct{
	GF_BGL_BMPWIN	bName;							// O`rbg}bv
	GF_BGL_BMPWIN	bMessage;						// ȈՉb`rbg}bv
}UNION_BOARD_BMP;

struct UNION_BOARD_WORK{
	int           	mode;								//[_[J

	COMM_UNIONROOM_VIEW *cuv;
	COMM_UNIONROOM_WORK     *union_work;
	FIELDSYS_WORK 	*fsys;							// tB[hpVXe|C^
	MYSTATUS		*mystatus;
	GF_BGL_INI    	*bgl;								// tB[hpafVXe|C^
	

	u16			  	 *Bg1ScrenData;					// BG1pXN[f[^
	NNSG2dScreenData *BoardScreen;					// BG1pXN[f[^AhX

	CLACT_SET_PTR 			clactSet;								// ZAN^[Zbg
	CLACT_U_EASYRENDER_DATA	renddata;								// ȈՃ_[f[^
	CLACT_U_RES_MANAGER_PTR	resMan[CELL_ANIME_RESOURCE_NUM];		// \[X}l[W
	CLACT_U_RES_OBJ_PTR 	resObjTbl[CELL_ANIME_RESOURCE_NUM];		// \[XIuWFe[u
	CLACT_HEADER			clActHeader;							// ZAN^[wb_[

	CLACT_WORK_PTR			clActWork[COMM_MACHINE_MAX];			// ZAN^[[N|C^z(lj
	int						MesIndex;								// bZ[WCfbNX
	int						TalkMode;
	int						Wait;

	UNION_BOARD_BMP			UnionBmp[3];
	UNION_CHAT_RINGBUF		UnionChatRingBuf;
	int 					MesStart;

	UNION_SCROLL			Scroll;
	int						old_scrollpoint;

	BOOL					BgTransReq;

};


//========================================================================================
// vg^Cv錾
//========================================================================================
static void InitWork( UNION_BOARD_WORK *ubw );
static void destBG(GF_BGL_INI* bgl);
static void initBG( GF_BGL_INI *bgl );
static void InitCellActor(UNION_BOARD_WORK *ubw);
static void SetCellActor( UNION_BOARD_WORK *ubw );

static void BmpWinInit( GF_BGL_INI *bgl, UNION_BOARD_BMP *UnionBmp);
static void BmpWinDelete( UNION_BOARD_BMP *UnionBmp );

extern void FieldMsgPrintInitSub(void);
extern void FldTalkBmpAddSub( GF_BGL_INI * ini, GF_BGL_BMPWIN * win );


static void UnionChatInit( UNION_CHAT *chat);
static void UnionChatAllocInit( UNION_CHAT_RINGBUF *chatbuf);
static void UnionChatFree(UNION_CHAT *chat);
static void UnionChatAllFree( UNION_CHAT_RINGBUF *chatbuf);

static void BoardWriteFunc( UNION_BOARD_WORK *ubw );
static void UnionChat_Print( UNION_BOARD_WORK *ubw, int no,  UNION_CHAT *mes);
static void TouchPanelFunc( UNION_BOARD_WORK *ubw );
static void ScrollControl( UNION_BOARD_WORK *ubw );
static void SetScrollBar_PosY( CLACT_WORK_PTR act, int y );
static void GetUnionChat( UNION_BOARD_WORK *ubw );
static void AddUnionChatPmsData( UNION_CHAT_RINGBUF *chatbuf, u32 id, PMS_DATA *pms, MYSTATUS *mystatus );
static int UnionChatRegisterCheck(UNION_BOARD_WORK *ubw, PMS_DATA *pms, int id);
static int AddUnionChatRingBufPos( UNION_CHAT_RINGBUF *chatbuf, int pos );
static int GetUnionBoardPrintPoint( int start, int now );

static void UnionBoardReWriteOn( UNION_BOARD_WORK *ubw);
static void UnionBoard_AddChatSub( UNION_BOARD_WORK *ubw, MYSTATUS *status, PMS_DATA *pms, u32 id );

//------------------------------------------------------------------
/**
 * Yz[_[Ci^XN֐j
 *
 * @param   tcb		^XN|C^
 * @param   wk		[N|C^(UG_RADAR_WORKƂăLXgĎgj
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionRoom_BoardFunc(TCB_PTR tcb, void *wk)
{
	UNION_BOARD_WORK *ubw = wk;
	GF_BGL_INI       *bgl = ubw->bgl;
	int i;

	switch(ubw->mode){
	case UNIONBOARD_INIT_BG:
		// BGEVRAM]
		OS_Printf("start underground = %ld\n",sys_GetHeapFreeSize(HEAPID_FIELD));
		OS_Printf("underground  work= %ld\n",sizeof(UNION_BOARD_WORK));

		initBG( bgl );

		// [_[pz񏉊
		InitWork( ubw );
		UnionChatAllocInit( &ubw->UnionChatRingBuf );
	
		ubw->mode++;
		break;
	case UNIONBOARD_INIT_ACTOR:

		InitCellActor(ubw);
		SetCellActor(ubw);

		BmpWinInit( ubw->bgl, ubw->UnionBmp );

		GF_Disp_GXS_VisibleControl(GX_PLANEMASK_OBJ, VISIBLE_ON);	//OBJʂnm
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_ON );
		ubw->mode++;
		break;
	// CV[PX
	case UNIONBOARD_MAIN:
		GetUnionChat( ubw );
		ScrollControl( ubw );
		TouchPanelFunc( ubw );

//		if(sys.cont&PAD_BUTTON_A){
//			ubw->UnionChatRingBuf.num++;
//			UnionBoardReWriteOn( ubw );
//		}

		BoardWriteFunc( ubw );

		CLACT_Draw( ubw->clactSet );									// ZAN^[풓֐
		break;

	case UNIONBOARD_END:
		// L]}l[W[j
		CLACT_U_CharManagerDelete(ubw->resObjTbl[CLACT_U_CHAR_RES]);

		// pbg]}l[W[j
		CLACT_U_PlttManagerDelete(ubw->resObjTbl[CLACT_U_PLTT_RES]);
		
		// LEpbgEZEZAj̃\[X}l[W[j
		for(i=0;i<CELL_ANIME_RESOURCE_NUM;i++){
			CLACT_U_ResManagerDelete(ubw->resMan[i]);
		}
		// ZAN^[Zbgj
		CLACT_DestSet(ubw->clactSet);

		//BmpWin
		BmpWinDelete( ubw->UnionBmp );				

		GF_BGL_BGControlExit(bgl, GF_BGL_FRAME3_S);				//bEChEpobt@
		destBG(bgl);											// BG0,BG1pobt@

		UnionChatAllFree( &ubw->UnionChatRingBuf);
		sys_FreeMemoryEz( ubw->Bg1ScrenData );

		PMDS_taskDel( tcb );

		break;

	}

}

#define NAME_BMPWIN_W	( 10 )
#define NAME_BMPWIN_H	(  2 )

#define NAME_BMPWIN_POSX	(  1 )
#define NAME0_BMPWIN_POSY	(  1 )

#define MESSAGE_BMPWIN_W	( 28 )
#define MESSAGE_BMPWIN_H	(  4 )

#define MESSAGE_BMPWIN_POSX	(  2 )
#define MESSAGE0_BMPWIN_POSY	(  3 )

#define UNION_BOARD_BGCHAR_OFFSET	( 32*9 )
#define UNION_NAME_BMP_SIZE         ( NAME_BMPWIN_W*NAME_BMPWIN_H )
#define UNION_BOARD_NAMECHAR_OFFSET ( UNION_BOARD_BGCHAR_OFFSET + UNION_NAME_BMP_SIZE*3 )
#define UNION_CHAT_BMP_SIZE      ( MESSAGE_BMPWIN_W*MESSAGE_BMPWIN_H )
//------------------------------------------------------------------
/**
 * jI{[h[N
 *
 * @param   pos[][POS_XZ]			
 * @param   view[][POS_XZ_TIME]		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitWork( UNION_BOARD_WORK *ubw )
{
	int i;
	ubw->BgTransReq = FALSE;

	ubw->Scroll.max     = 0;
	ubw->Scroll.old_max = 0;
	ubw->Scroll.now     = 0;
	ubw->Scroll.barflag = 0;

	gf_srand(sys.vsync_counter);
	for(i=0;i<UNION_CHAT_MAX;i++){
//		PMSDAT_SetDebug( &ubw->UnionChatRingBuf.mes[i].PmsData );
		PMSDAT_SetDebugRandom( &ubw->UnionChatRingBuf.mes[i].PmsData );
	}

	

	// HpBG1f[^ǂݍ
	ubw->Bg1ScrenData = ArcUtil_ScrnDataGet(ARC_UNIONROOM_GRA, NARC_unionroom_unionbg1_lz_nscr, 1, &(ubw->BoardScreen), HEAPID_FIELD);
	OS_Printf( "bg1srcreen data adrs = %08x\n",ubw->BoardScreen);


}


//------------------------------------------------------------------
/**
 * $brief   BMPWINm
 *
 * @param   bgl		
 * @param   UnionBmp		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BmpWinInit( GF_BGL_INI *bgl, UNION_BOARD_BMP *UnionBmp)
{
	// ʃ{^pBMPm
	int i;
	OS_Printf("heap remain = %d\n",sys_GetHeapFreeSize( HEAPID_FIELD ));

	// O
	for(i=0;i<UNION_BOARD_CARD_NUM;i++){
		GF_BGL_BmpWinAdd(bgl, &UnionBmp[i].bName, GF_BGL_FRAME0_S,	
			NAME_BMPWIN_POSX, 
			NAME0_BMPWIN_POSY+i*8, 
			NAME_BMPWIN_W, 
			NAME_BMPWIN_H, 
			FLD_MESFONT_PAL,  UNION_BOARD_BGCHAR_OFFSET + i * UNION_NAME_BMP_SIZE);
		GF_BGL_BmpWinDataFill( &UnionBmp[i].bName, 0x0000 );

		GF_BGL_BmpWinOn( &UnionBmp[i].bName );
	}

	// ȈՉb
	for(i=0;i<UNION_BOARD_CARD_NUM;i++){
		GF_BGL_BmpWinAdd(bgl, &UnionBmp[i].bMessage, GF_BGL_FRAME0_S,	
			MESSAGE_BMPWIN_POSX, 
			MESSAGE0_BMPWIN_POSY+i*8, 
			MESSAGE_BMPWIN_W, 
			MESSAGE_BMPWIN_H, 
			FLD_MESFONT_PAL,  UNION_BOARD_NAMECHAR_OFFSET + i * UNION_CHAT_BMP_SIZE);
		GF_BGL_BmpWinDataFill( &UnionBmp[i].bMessage, 0x0000 );
		GF_BGL_BmpWinOn( &UnionBmp[i].bMessage );
	}

}

//------------------------------------------------------------------
/**
 * $brief   BMPWIN
 *
 * @param   UnionBmp		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BmpWinDelete( UNION_BOARD_BMP *UnionBmp )
{
	int i;
	for(i=0;i<UNION_BOARD_CARD_NUM;i++){
		GF_BGL_BmpWinDel( &UnionBmp[i].bMessage );
		GF_BGL_BmpWinDel( &UnionBmp[i].bName );
	}
}


//==============================================================================
/**
 * Yz[_[֐i^XNo^j
 *
 * @param   fsys		FIELDSYS_WORK̃|C^
 *
 * @retval  none		
 */
//==============================================================================
UNION_BOARD_WORK *UnionRoom_BoardInit( FIELDSYS_WORK *fsys )
{
	UNION_BOARD_WORK *ubw;
	TCB_PTR       tcb;

	//Yz[_[^XNǉ
	tcb           = PMDS_taskAdd(UnionRoom_BoardFunc, sizeof(UNION_BOARD_WORK), UNION_BOARD_TCB_PRIORITY, HEAPID_FIELD);
	ubw           = TCB_GetWork(tcb);
	ubw->fsys     = fsys;
	ubw->bgl      = fsys->bgl;
	ubw->cuv      = fsys->union_view;
	ubw->union_work = fsys->union_work;
	ubw->mystatus = SaveData_GetMyStatus(fsys->savedata);
	ubw->mode     = 0;

	return ubw;
}

//==============================================================================
/**
 * [_[ʏIʒm
 *
 * @param   fsys		FieldSys̃|C^
 *
 * @retval  none		
 */
//==============================================================================
void UnionRoom_BoardEnd(UNION_BOARD_WORK *ubw)
{
	// [_[̃V[PX`IɕύX
	if(ubw->mode==UNIONBOARD_MAIN){
		ubw->mode = UNIONBOARD_END;
	}else{
		GF_ASSERT("[_[IȂɏIĂяo܂");
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief nʂɓ˓܂ł̃Tuʂaf̃VXej
 *
 *@param	bgl		BGLVXe\̂̃|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void destBG(GF_BGL_INI* bgl)
{
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME0_S);
	GF_BGL_BGControlExit(bgl, GF_BGL_FRAME1_S);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	BGRg[ݒ
 *
 *@param	bgl	BGLVXẽ|C^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBG( GF_BGL_INI* bgl )
{
	// ܂ł̔j
	destBG(bgl);

	// TuBGOCP,3̃Rg[ݒ
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x7000, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			1, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( bgl, GF_BGL_FRAME0_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_OFF );
	}
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x7800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			2, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( bgl, GF_BGL_FRAME1_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG1, VISIBLE_OFF );
	}
#if 0
	{
		GF_BGL_BGCNT_HEADER TextBgCntDat = {
			0, 0, 0x800, 0, GF_BGL_SCRSIZ_256x256, GX_BG_COLORMODE_16,
			GX_BG_SCRBASE_0x6800, GX_BG_CHARBASE_0x00000, GX_BG_EXTPLTT_01,
			0, 0, 0, FALSE
		};
		GF_BGL_BGControlSet( bgl, GF_BGL_FRAME3_S, &TextBgCntDat, GF_BGL_MODE_TEXT );
		GF_Disp_GXS_VisibleControl( GX_PLANEMASK_BG3, VISIBLE_OFF );
	}
#endif

	// pbg]
	ArcUtil_PalSet(    ARC_UNIONROOM_GRA, NARC_unionroom_unionbg_nclr, PALTYPE_SUB_BG, 0, 0x20*2,  HEAPID_FIELD);

	// L]
	ArcUtil_BgCharSet( ARC_UNIONROOM_GRA, NARC_unionroom_unionbg_lz_ncgr, bgl, GF_BGL_FRAME1_S, 0, 32*9*0x20, 1, HEAPID_FIELD);

	// XN[]
	ArcUtil_ScrnSet(   ARC_UNIONROOM_GRA, NARC_unionroom_unionbg1_base_lz_nscr, bgl, GF_BGL_FRAME1_S, 0, 32*24*2, 1, HEAPID_FIELD);

	FieldMsgPrintInit(PALTYPE_SUB_BG, MSG_PRINT_NO_INIT);				// TuVRAMɃtHgƃpbg]

}



//------------------------------------------------------------------
/**
 * [_[ʗpZAN^[
 *
 * @param   ubw		[_[\̂̃|C^
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void InitCellActor(UNION_BOARD_WORK *ubw)
{
	int i;
	// ZAN^[
	ubw->clactSet = CLACT_U_SetEasyInit( UNION_BOARD_CLACT_MAX, &ubw->renddata, HEAPID_FIELD );
	
	//\[X}l[W[
	for(i=0;i<CELL_ANIME_RESOURCE_NUM;i++){		//\[X}l[W[쐬
		ubw->resMan[i] = CLACT_U_ResManagerInit(1, i, HEAPID_FIELD);
	}

	
	//charaǂݍ
	ubw->resObjTbl[CLACT_U_CHAR_RES] = CLACT_U_ResManagerResAddArcChar(ubw->resMan[CLACT_U_CHAR_RES], 
			ARC_UNIONROOM_GRA, NARC_unionroom_unionobj_lz_ncgr, 1, UNION_BOARD_RESOURCE_ID, NNS_G2D_VRAM_TYPE_2DSUB, HEAPID_FIELD);

	//palǂݍ
	ubw->resObjTbl[CLACT_U_PLTT_RES] = CLACT_U_ResManagerResAddArcPltt(ubw->resMan[CLACT_U_PLTT_RES],
			ARC_UNIONROOM_GRA, NARC_unionroom_unionobj_nclr, 0, UNION_BOARD_RESOURCE_ID, NNS_G2D_VRAM_TYPE_2DSUB, 1, HEAPID_FIELD);

	//cellǂݍ
	ubw->resObjTbl[CLACT_U_CELL_RES] = CLACT_U_ResManagerResAddArcKindCell(ubw->resMan[CLACT_U_CELL_RES],
			ARC_UNIONROOM_GRA, NARC_unionroom_unionobj_lz_ncer, 1, UNION_BOARD_RESOURCE_ID, CLACT_U_CELL_RES,HEAPID_FIELD);

	//֐animǂݍ
	ubw->resObjTbl[CLACT_U_CELLANM_RES] = CLACT_U_ResManagerResAddArcKindCell(ubw->resMan[CLACT_U_CELLANM_RES],
			ARC_UNIONROOM_GRA, NARC_unionroom_unionobj_lz_nanr, 1, UNION_BOARD_RESOURCE_ID, CLACT_U_CELLANM_RES,HEAPID_FIELD);

	// Chara]
	CLACT_U_CharManagerSet( ubw->resObjTbl[CLACT_U_CHAR_RES] );

	// pbg]
	CLACT_U_PlttManagerSet( ubw->resObjTbl[CLACT_U_PLTT_RES] );

}

#define UNION_ARROW_X			(256-16)
#define UNION_ARROW_UP_Y		(     0)
#define UNION_ARROW_DOWN_Y		(192-8*4)
#define UNION_ARROW_SCROLL_Y	(192/2)

static const int obj_parts_table_y[]={
		UNION_ARROW_UP_Y	,
		UNION_ARROW_DOWN_Y	,
		UNION_ARROW_SCROLL_Y,
};


//------------------------------------------------------------------
/**
 * $brief   ZAN^[zu
 *
 * @param   ubw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetCellActor( UNION_BOARD_WORK *ubw )
{
	int i;
		// ZAN^[wb_쐬
		CLACT_U_MakeHeader(&ubw->clActHeader, 
							UNION_BOARD_RESOURCE_ID,
							UNION_BOARD_RESOURCE_ID,
							UNION_BOARD_RESOURCE_ID,
							UNION_BOARD_RESOURCE_ID,
							CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
							0, 0,
							ubw->resMan[CLACT_U_CHAR_RES],
							ubw->resMan[CLACT_U_PLTT_RES],
							ubw->resMan[CLACT_U_CELL_RES],
							ubw->resMan[CLACT_U_CELLANM_RES],
							NULL,NULL);

		{
			//o^i[
			CLACT_ADD add;

			add.ClActSet	= ubw->clactSet;
			add.ClActHeader	= &ubw->clActHeader;

			add.mat.z		= 0;
			add.sca.x		= FX32_ONE;
			add.sca.y		= FX32_ONE;
			add.sca.z		= FX32_ONE;
			add.rot			= 0;
			add.pri			= 0;
			add.DrawArea	= NNS_G2D_VRAM_TYPE_2DSUB;
			add.heap		= HEAPID_FIELD;

			//ZAN^[\Jn

			// ㉺XN[o[o^
			for(i=0;i<UNION_BOARD_OBJ_PARTS_NUM;i++){
				add.mat.x		= FX32_CONST( UNION_ARROW_X ) ;
				add.mat.y		= FX32_CONST( obj_parts_table_y[i] ) + SUB_SURFACE_Y;		//ʂ͏㉺AĂiMAINASUBj
				ubw->clActWork[i] = CLACT_Add(&add);
				CLACT_SetAnmFlag(ubw->clActWork[i],1);
				CLACT_AnmChg( ubw->clActWork[i], i );	//eX̎p
			}
//			CLACT_SetDrawFlag(ubw->clActWork[2], 0);	//XN[o[͔\
			
		}	

}



//------------------------------------------------------------------
/**
 * jIbZ[W
 *
 * @param   fifo	UNION_CHAT\̂̃|C^
 *
 * @retval  none	
 */
//------------------------------------------------------------------
static void UnionChatInit(UNION_CHAT *chat)
{
	chat->name    = STRBUF_Create( TRAINER_NAME_SIZE, HEAPID_FIELD );
	chat->message = NULL;
	PMSDAT_Init( &chat->PmsData, 0 );
	chat->sex     = 0;
	chat->id      = 0;
}

//------------------------------------------------------------------
/**
 * $brief   ܂Ƃ߂ď
 *
 * @param   chatbuf 
 *
 * @retval  none
 */
//------------------------------------------------------------------
static void UnionChatAllocInit( UNION_CHAT_RINGBUF *chatbuf)
{
	int i;
	for(i=0;i<UNION_CHAT_MAX;i++){
		UnionChatInit( &chatbuf->mes[i] );
	}
	chatbuf->num   = 0;
	chatbuf->start = 0;
}


//------------------------------------------------------------------
/**
 * $brief   bZ[WpSTRBUF
 *
 * @param   message		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionChatFree(UNION_CHAT *chat)
{
	// Ö͕KmۂĂ̂ŉ
	sys_FreeMemoryEz( chat->name );

	// obt@mۂĂꍇ͉
	if(chat->message!=NULL){
		STRBUF_Delete(chat->message);
	}
}

//------------------------------------------------------------------
/**
 * $brief   jI`bgOobt@܂Ƃ߂ĉ
 *
 * @param   messages		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionChatAllFree( UNION_CHAT_RINGBUF *chatbuf)
{
	int i;
	
	for(i=0;i<UNION_CHAT_MAX;i++){
		UnionChatFree( &chatbuf->mes[i] );
	}
	
}

//------------------------------------------------------------------
/**
 * $brief   Oobt@ŎQƓ_̑Zs
 *
 * @param   chatbuf		
 * @param   pos		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int AddUnionChatRingBufPos( UNION_CHAT_RINGBUF *chatbuf, int pos )
{
	pos++;
	if(pos==UNION_CHAT_MAX){
		pos = 0;
	}

	return pos;
}

//------------------------------------------------------------------
/**
 * $brief   Oobt@l`bg\Jnʒu擾
 *
 * @param   start		
 * @param   now		
 *
 * @retval  int		
 */
//------------------------------------------------------------------
static int GetUnionBoardPrintPoint( int start, int now )
{
	int result = start+now;
	if(result>=UNION_CHAT_MAX){
		result -= UNION_CHAT_MAX;
	}
	return result;
}
//------------------------------------------------------------------
/**
 * $brief   OȈՉb`
 *
 * @param   ubw		
 * @param   no		
 * @param   mes		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionChat_Print( UNION_BOARD_WORK *ubw, int no, UNION_CHAT *mes)
{

	// BMPpobt@NA
	GF_BGL_BmpWinDataFill( &ubw->UnionBmp[no].bName, 0x0000 );
	GF_BGL_BmpWinDataFill( &ubw->UnionBmp[no].bMessage, 0x0000 );
	
	// `
	GF_STR_PrintSimple( &ubw->UnionBmp[no].bName,    FONT_TALK, mes->name,    0, 0, MSG_NO_PUT, NULL );
	GF_STR_PrintSimple( &ubw->UnionBmp[no].bMessage, FONT_TALK, mes->message, 0, 2, MSG_NO_PUT, NULL );

	// VRAMvBlankɓ]
	GF_BGL_BmpWinOnVReq( &ubw->UnionBmp[no].bName    );
	GF_BGL_BmpWinOnVReq( &ubw->UnionBmp[no].bMessage );
}

//------------------------------------------------------------------
/**
 * $brief   jI{[h`풓֐
 *
 * @param   ubw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void BoardWriteFunc( UNION_BOARD_WORK *ubw )
{
	int i,r;
	int pos = GetUnionBoardPrintPoint( ubw->UnionChatRingBuf.start, ubw->Scroll.now );
	int max = ubw->UnionChatRingBuf.num;
	
	if(max>3){
		max = 3;
	}

	// XN[o[̈ʒuĂꍇ͍ĕ`
	if(ubw->Scroll.now!=ubw->old_scrollpoint){
		UnionBoardReWriteOn( ubw );
		ubw->old_scrollpoint = ubw->Scroll.now;
	}

	// ȈՉb`
	if(ubw->BgTransReq==TRUE){
		int top = ubw->MesStart;
		
//		OS_Printf( "pos=%d, bufnum=%d bufstart=%d now=%d",pos, ubw->UnionChatRingBuf.num, ubw->UnionChatRingBuf.start, ubw->Scroll.now);
		
		GF_BGL_ScreenBufSet( ubw->bgl, GF_BGL_FRAME1_S, ubw->BoardScreen->rawData, 32*8*2*max );
		GF_BGL_LoadScreen(	ubw->bgl, GF_BGL_FRAME1_S, GF_BGL_ScreenAdrsGet( ubw->bgl, GF_BGL_FRAME1_S ), 32*24*2, 0 );

		
		for(i=0;i<max;i++){
			UnionChat_Print(ubw, i, &ubw->UnionChatRingBuf.mes[pos]);
			pos = AddUnionChatRingBufPos(&ubw->UnionChatRingBuf,pos);
		}

		ubw->BgTransReq = FALSE;

	}

}

// ʗp{^ʒu`
#define SUB_BUTTON1_POSX		( 256-16   )
#define SUB_BUTTON1_POSY		( 0        )
#define SUB_BUTTON2_POSX		( 256-16   )
#define SUB_BUTTON2_POSY		( 192-8*4  )
#define SUB_BUTTON_W			( 8*2 )
#define SUB_BUTTON_H			( 8*4 )
#define SUB_SCROLLBAR_POSX		( 256-16   )
#define SUB_SCROLLBAR_POSY		( 8*4+16  )
#define SUB_SCROLLBAR_W			( 16  )
#define SUB_SCROLLBAR_H			( 192-8*8-16*2  )

#define SUB_CHAT_POSX			(  0 )
#define SUB_CHAT1_POSY			(  0 )
#define SUB_CHAT2_POSY			( 8*8)
#define SUB_CHAT3_POSY			(16*8)
#define SUB_CHAT_W				(30*8)
#define SUB_CHAT_H				( 8*8)


static const RECT_HIT_TBL sub_button_hittbl[]={
	{SUB_BUTTON1_POSY, SUB_BUTTON1_POSY+SUB_BUTTON_H, SUB_BUTTON1_POSX, SUB_BUTTON1_POSX+SUB_BUTTON_W},
	{SUB_BUTTON2_POSY, SUB_BUTTON1_POSY+SUB_BUTTON_H, SUB_BUTTON2_POSX, SUB_BUTTON1_POSX+SUB_BUTTON_W},
	{SUB_CHAT1_POSY, SUB_CHAT1_POSY+SUB_CHAT_H, SUB_CHAT_POSX, SUB_CHAT_POSX+SUB_CHAT_W},
	{SUB_CHAT2_POSY, SUB_CHAT2_POSY+SUB_CHAT_H, SUB_CHAT_POSX, SUB_CHAT_POSX+SUB_CHAT_W},
	{SUB_CHAT3_POSY, SUB_CHAT3_POSY+SUB_CHAT_H, SUB_CHAT_POSX, SUB_CHAT_POSX+SUB_CHAT_W},
	{RECT_HIT_END,0,0,0},		// If[^
};

static const RECT_HIT_TBL sub_scroll_hittbl[]={
	{SUB_SCROLLBAR_POSY, SUB_SCROLLBAR_POSY+SUB_SCROLLBAR_H, SUB_SCROLLBAR_POSX, SUB_SCROLLBAR_POSX+SUB_SCROLLBAR_W},
	{RECT_HIT_END,0,0,0},		// If[^
};

//------------------------------------------------------------------
/**
 * $brief   XN[o[̍Wݒ肷
 *
 * @param   act		AN^[̃|C^
 * @param   y		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void SetScrollBar_PosY( CLACT_WORK_PTR act, int y )
{
	VecFx32 mat;

	mat.x = FX32_CONST( SUB_SCROLLBAR_POSX );
	mat.y = FX32_CONST( y ) + SUB_SURFACE_Y;
	mat.z = 0;
	CLACT_SetMatrix( act, &mat);

}

//------------------------------------------------------------------
/**
 * $brief   XN[o[̏
 *
 * @param   ubw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void ScrollControl( UNION_BOARD_WORK *ubw )
{

	ubw->Scroll.max = ubw->UnionChatRingBuf.num;
#if 0
	if(sys.trg&PAD_KEY_UP){
		if(ubw->Scroll.max<30){
			ubw->Scroll.max++;
		}
		OS_Printf("bZ[W@%d\n",ubw->Scroll.max);
	}
	if(sys.trg&PAD_KEY_DOWN){
		if(ubw->Scroll.max!=0){
			ubw->Scroll.max--;
		}
		OS_Printf("bZ[W@%d\n",ubw->Scroll.max);
	}
#endif

	// ڐSȏɂȂXN[o[\(鎖͂Ȃ낤ǁj
	if(ubw->Scroll.max > 3 && ubw->Scroll.old_max<=3){
		ubw->Scroll.barflag = 1;
		ubw->Scroll.now            = 0;
	}
	CLACT_SetDrawFlag(ubw->clActWork[2], ubw->Scroll.barflag);	//XN[o[\
	
	if( ubw->Scroll.barflag ){
		if(!GF_TP_GetCont()){
			int haba,y;
			haba = SUB_SCROLLBAR_H / (ubw->Scroll.max-3);
			y    = ubw->Scroll.now * haba + SUB_SCROLLBAR_POSY;
			SetScrollBar_PosY( ubw->clActWork[2],y );
//			OS_Printf("y=%d, haba=%d, now=%d max=%d\n",y,haba,ubw->Scroll.now, ubw->Scroll.max);
		}
	}
	ubw->Scroll.old_max = ubw->Scroll.max;
}	
//------------------------------------------------------------------
/**
 * $brief   ^b`pl
 *
 * @param   ubw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void TouchPanelFunc( UNION_BOARD_WORK *ubw )
{
	int button,i,listpos;
	WMBssDesc         *beacon;
	_GF_BSS_DATA_INFO *gfinfo;
	
	button=GF_TP_RectHitTrg( sub_button_hittbl );
	if( button != RECT_HIT_NONE ){
		switch(button){
		// ɃEChEPXN[
		case 0:
			CLACT_AnmChg( ubw->clActWork[button], button+4 );	//eX̎p
			if(ubw->Scroll.now!=0){
				ubw->Scroll.now--;
			}
			break;
		// ɃEChEPXN[
		case 1:
			CLACT_AnmChg( ubw->clActWork[button], button+4 );	//eX̎p
			if(ubw->Scroll.now<ubw->Scroll.max-3){
				ubw->Scroll.now++;
			}
			break;

		// ʃo[T[`iEChEGƏŐԂgj
		case 2:	case 3:	case 4:
			listpos = GetUnionBoardPrintPoint( ubw->UnionChatRingBuf.start, ubw->Scroll.now )+button-2;


			// r[RIDvāAɒnʂɗĂȂ΃GtFNgON
			
			// POl̐e@r[R
			for(i=0;i<10;i++){
				beacon = CommMPGetWMBssDesc(i);	
				if(beacon!=NULL){		// r[RȂX[
					gfinfo = (_GF_BSS_DATA_INFO*)&beacon->gameInfo.userGameInfo;
					// r[RIDvāAɒnʂɗĂȂ΃GtFNgON
//					OS_Printf("appear=%d, pokeID=%d, RingBufID=%d\n",ubw->cuv->objwork[i].appear,gfinfo->pokeID,ubw->UnionChatRingBuf.mes[listpos].id);
					if((ubw->cuv->objwork[i].appear==OBJ_OK) && (gfinfo->pokeID == ubw->UnionChatRingBuf.mes[listpos].id)){
						ubw->cuv->objwork[i].effect = 1;
						break;
					}
				}
			}
			break;
		}
	}
	
	// XCho[
	button=GF_TP_RectHitCont( sub_scroll_hittbl );
	if( button != RECT_HIT_NONE ){
		u32 x, y;

		// ^b`ĂWɃXCho[Wݒ
		GF_TP_GetPointCont( &x, &y );
		SetScrollBar_PosY( ubw->clActWork[2],y );
		
		// ԋ߂bZ[WʒũA^擾Ă
		if(ubw->Scroll.max>3){
			int haba,i;

			haba = SUB_SCROLLBAR_H / (ubw->Scroll.max-2);
			for(i=0;i<ubw->Scroll.max-2;i++){
				if( (y >= SUB_SCROLLBAR_POSY+haba*i) && (y < SUB_SCROLLBAR_POSY+haba*(i+1))){
					ubw->Scroll.now =i;
					break;
				}
			}
		}
	}

}

//------------------------------------------------------------------
/**
 * $brief   UnionChat\̂ɐVf[^o^
 *
 * @param   union_mes		
 * @param   id		
 * @param   pms		
 * @param   mystatus		
 * @param   no		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void AddUnionChatPmsData( UNION_CHAT_RINGBUF *chatbuf, u32 id, PMS_DATA *pms, MYSTATUS *mystatus )
{
	int *pos;

	// `bgOobt@̍ő吔܂łĂꍇ̓X^[gʒu炵ĂiOobt@j
	if(chatbuf->num==UNION_CHAT_MAX){
		pos = &chatbuf->start;
	}else{
		pos = &chatbuf->num;
	}
	
	// ɕobt@mۂĂꍇ͉
	if(chatbuf->mes[*pos].message!=NULL){
		STRBUF_Delete(chatbuf->mes[*pos].message);
	}
	
	// OEIDEȈՉbEȈՉb̓o^
	STRBUF_SetStringCode( chatbuf->mes[*pos].name, MyStatus_GetMyName(mystatus));
	chatbuf->mes[*pos].PmsData = *pms;
	chatbuf->mes[*pos].id      = id;
	chatbuf->mes[*pos].message = PMSDAT_ToString( pms, HEAPID_FIELD );
	
	// ̓o^ʒuɂ炷
	(*pos)++;

	// X^[gʒuő܂łꍇ͍ŏɖ߂
	if(chatbuf->start==UNION_CHAT_MAX){
		chatbuf->start = 0;
	}
}

#if DEBUG_UNION_BOARD
static int debugcount=0;
#endif

//------------------------------------------------------------------
/**
 * $brief   `bgf[^o^邩ǂ`FbN
 *
 * @param   ubw		
 * @param   pms		
 * @param   id		
 *
 * @retval  int		0͓o^ς 1Ȃo^ĂȂVo[ 
 */
//------------------------------------------------------------------
static int UnionChatRegisterCheck(UNION_BOARD_WORK *ubw, PMS_DATA *pms, int id)
{
	int r;

#if DEBUG_UNION_BOARD	
	debugcount++;
	
	if(debugcount==100){
		debugcount = 0;
		return 1;
	}
#endif	
	// ȈՉb͗LȓeH
	if(!PMSDAT_IsEnabled(pms)){
		return 0;
	}

	// ɕ\ς݂̓e`FbN
	for(r=0;r<ubw->UnionChatRingBuf.num;r++){
		if( id==ubw->UnionChatRingBuf.mes[r].id 
		&& PMSDAT_Compare( pms, &ubw->UnionChatRingBuf.mes[r].PmsData)){
			break;
		}
	}

	// ɓo^ς݂H( o^O̎͐Γo^)
	if(r!=ubw->UnionChatRingBuf.num && ubw->UnionChatRingBuf.num!=0){
		return 0;
	}

	return 1;
	
}



//------------------------------------------------------------------
/**
 * $brief   VKȈՉbo^ilEΉj
 *
 * @param   ubw		
 * @param   mystatus		
 * @param   pms		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionBoard_AddChatSub( UNION_BOARD_WORK *ubw, MYSTATUS *status, PMS_DATA *pms, u32 id )
{
	// vȂ̂œo^
	AddUnionChatPmsData( &ubw->UnionChatRingBuf, id, pms, status );
	// XN[o[ԉɂ鎞͉ɂÂ悤Ɂ{P
	if(ubw->Scroll.barflag){
		if(ubw->UnionChatRingBuf.num!=UNION_CHAT_MAX && ubw->Scroll.now!=UNION_CHAT_MAX-1){
			ubw->Scroll.now++;
		}
	}
	UnionBoardReWriteOn( ubw );

}


static _GF_BSS_DATA_INFO* d_gfinfo;
static PMS_DATA* d_pms;

//------------------------------------------------------------------
/**
 * $brief   r[Rf[^V`bgf[^擾
 *
 * @param   ubw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void GetUnionChat( UNION_BOARD_WORK *ubw )
{
//	GetWMBssDesc_toPmsData(ubw->UnionChat);
	int i,r;
	WMBssDesc 			*beacon;
	_GF_BSS_DATA_INFO   *gfinfo;
	PMS_DATA			*pms;
	MYSTATUS			*status;
	PMS_DATA			debugpms;
	status = MyStatus_AllocWork(HEAPID_FIELD);
	
	for(i=0;i<16;i++){
		beacon = CommMPGetWMBssDesc(i);
		
		// r[R݂Ă遁jI[̐l
		if(beacon!=NULL){
			gfinfo = (_GF_BSS_DATA_INFO*)&beacon->gameInfo.userGameInfo;
			pms    = (PMS_DATA*)&gfinfo->pmsData;
			d_gfinfo = (_GF_BSS_DATA_INFO*)&beacon->gameInfo.userGameInfo;
			d_pms    = (PMS_DATA*)&gfinfo->pmsData;
			MyStatus_Copy((MYSTATUS*)gfinfo->myStatusBuff, status);

			// `bgf[^͓o^ς݁H
			if(UnionChatRegisterCheck(ubw, pms, gfinfo->pokeID)){
				// vȂ̂œo^
				CommMPGetParentName( i, status );						// 擾
				UnionBoard_AddChatSub( ubw, status, pms, gfinfo->pokeID );	// ȈՉbo^
				
			}
		}
	}

	// ̃f[^fڃNGXg󂯂ĂȂH
	if((pms=Union_GetMyPmsData( ubw->union_work ))!=NULL){
		u32 id = MyStatus_GetID( ubw->mystatus );
		UnionBoard_AddChatSub( ubw, ubw->mystatus, pms, id  );	// ȈՉbo^
	}
	
	sys_FreeMemoryEz(status);
}


//------------------------------------------------------------------
/**
 * $brief   BMPʂ̍ĕ`惊NGXgs
 *
 * @param   ubw		
 *
 * @retval  none		
 */
//------------------------------------------------------------------
static void UnionBoardReWriteOn( UNION_BOARD_WORK *ubw)
{
	ubw->BgTransReq = TRUE;

}