//============================================================================================
/**
 * @file	vm.h
 * @bfief	zC^[v^}V@C(XNvgR}hsɎgp)
 * @author	Sousuke Tamada
 * @date	01.11.07
 *
 * 03.04.15	Satoshi Nohara
 * 05.04.25 Hiroyuki Nakamura
 *
 * Gh̃t@Cx[X ( R/S -> FR/LG -> EME -> D/P )
 */
//============================================================================================
#ifndef __VM_H
#define __VM_H

#undef GLOBAL
#ifdef __VM_H_GLOBAL
#define GLOBAL /*	*/
#else
#define GLOBAL extern
#endif


//#define OLD_MSG_SYS				//bZ[WVXe(script.c,scrcmd.c,vm.h)

#include "field_common.h"			//FIELDSYS_WORK

#ifndef OLD_MSG_SYS
#include "system\msgdata.h"			//MSGDATA_MANAGER
#endif

//============================================================================================
//	`
//============================================================================================
typedef	u8	VM_CODE;				// XNvgACxgf[^̌^錾

//-------------------------------------------------------------------------
// z}V\̐錾
//-------------------------------------------------------------------------

#define VM_STACK_MAX	( 20 )	// z}ṼX^bN̐[
#define	VM_REG_MAX		( 4 )	// z}ṼWX^̐
//#define	VM_WORK_MAX		( 16 )	// z}Ṽ[N̐

typedef struct VM_MACHINE_ST VM_MACHINE;
typedef BOOL ( * VM_CMD)(VM_MACHINE *);
typedef BOOL (*VM_WAIT_FUNC)(VM_MACHINE *);

struct VM_MACHINE_ST{
	u8	SP;									// X^bN|C^
	u8	status;								// 
	u8	cmp_flag;							// vZʃtO
	VM_WAIT_FUNC routine;					// EFCg֐
	const VM_CODE * PC;						// ݂̃XNvgAhX
	const VM_CODE * array[VM_STACK_MAX];	// X^bN
	const VM_CMD * command_table;			// XNvgR}he[uJnʒu
	const VM_CMD * command_table_end;		// XNvgR}he[uIʒu
	u32 reg[VM_REG_MAX];					// ėpWX^
	void * event_work;						// R}hȂǂŎQƂ郏[Ñ|C^

#ifdef OLD_MSG_SYS
	u16 * pMsg;								// [hbZ[W
#else
	MSGDATA_MANAGER* msgman;				// bZ[W}l[W[
#endif
	VM_CODE * pScript;						// [hXNvg

	FIELDSYS_WORK* fsys;					//

	//script.c EV_SCRIPT_WORKֈړ
	//u16 scr_work[VM_WORK_MAX];			// [N(ANSWORK,TMPWORKȂǂ̑)
	//
	//̂悤Ɏg
	//core->scr_work[SCRIPT_WK_ANSWER] = 0;
	//
	//TMPWORKɒlZbgāA
	//ʃXNvgɓn̂ŁA
	//VMƂɃ[NȂ悤ɂ(050901)
};

// u8TCỸf[^擾邽߂̃}N
#define VMGetU8(core)	(*((core)->PC++))


//============================================================================================
//	O[oϐ
//============================================================================================
#ifndef __VM_H_GLOBAL
#endif

//============================================================================================
//	֐vg^Cv
//============================================================================================

//********************************************************************************************
//	z}Vp
//********************************************************************************************

//--------------------------------------------------------------------------------------------
/**
 * z}V
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	start		߃e[uJnAhX
 * @param	end			߃e[uIAhX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VM_Init( VM_MACHINE * core, const VM_CMD * start, const VM_CMD * end );

//--------------------------------------------------------------------------------------------
/**
 * z}VɃR[hݒ
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	start		sR[h̊JnAhX
 *
 * @return	TRUE
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 VM_Start( VM_MACHINE * core, const VM_CODE * start );

//--------------------------------------------------------------------------------------------
/**
 * z}VEFCgԂɐݒ
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	func		EFCg֐
 *
 * @return	none
 *
 * @li	TRUEԂĂ܂ŃEFCg֐𖈉Ăт
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VM_SetWait( VM_MACHINE * core, VM_WAIT_FUNC func );

//--------------------------------------------------------------------------------------------
/**
 * z}VsI
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VM_End( VM_MACHINE * core );

//--------------------------------------------------------------------------------------------
/**
 * R}hȂǂŎQƂ郏[NZbg
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	work		[Ñ|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VM_SetWork( VM_MACHINE * core, void * work );

//--------------------------------------------------------------------------------------------
/**
 * z}V䃁C
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @retval	"TRUE = s"
 * @retval	"FALSE = ~EsI"
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 VM_Control( VM_MACHINE * core );


//********************************************************************************************
//	X^bN
//********************************************************************************************

//--------------------------------------------------------------------------------------------
/**
 * z}VX^bNvbV
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	val
 *
 * @retval	"0 = "
 * @retval	"1 = G["
 */
//--------------------------------------------------------------------------------------------
GLOBAL u8 VMStackPush( VM_MACHINE * core, const VM_CODE * val );

//--------------------------------------------------------------------------------------------
/**
 * z}VX^bN|bv
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return
 */
//--------------------------------------------------------------------------------------------
GLOBAL const VM_CODE * VMStackPop( VM_MACHINE * core );


//********************************************************************************************
//	򖽗
//********************************************************************************************

//--------------------------------------------------------------------------------------------
/**
 * z}VWv
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	adrs		WvAhX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VMJump( VM_MACHINE * core, VM_CODE * adrs );

//--------------------------------------------------------------------------------------------
/**
 * z}VR[
 *
 * @param	core		z}V\̂ւ̃|C^
 * @param	adrs		ĂяoAhX
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VMCall( VM_MACHINE * core, VM_CODE * adrs );

//--------------------------------------------------------------------------------------------
/**
 * z}V^[
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
GLOBAL void VMRet( VM_MACHINE * core );


//********************************************************************************************
//	f[^擾		VMGetU8 ̓}N`
//********************************************************************************************

//--------------------------------------------------------------------------------------------
/**
 * PC̃AhX16bit(2byte)f[^擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	擾f[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL u16 VMGetU16( VM_MACHINE * core );

//--------------------------------------------------------------------------------------------
/**
 * PC̃AhX32bit(4byte)f[^擾
 *
 * @param	core		z}V\̂ւ̃|C^
 *
 * @return	擾f[^
 */
//--------------------------------------------------------------------------------------------
GLOBAL u32 VMGetU32( VM_MACHINE * core );


#undef GLOBAL
#endif	/* __VM_H */
