//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		weather_sys.c
 *@brief	VCVXe
 *@author	tomoya takahashi
 *@data		2005.04.25
 *
 *	̃VXéAOAM@tHO@BGQ@gp܂B
 *
 *	VVo^菇
 *	PFwb_̗񋓑̂ɐVV̒萔ǉ
 *	QFOtBbNiZABGjǉƂ́AVCOtBbNt@Ce[uɒǉ
 *	RFRg[^XN֐쐬AWeatherSysDatae[uɃf[^ݒ
 *	SFRg[^XN֐́AV[PXŊǗ邱Ƃ܂ɂĂ̂ŁA
 *	@@AtF[hCACAtF[hAEgAj̃V[PXɕēV쐬
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "common.h"
#include "fieldsys.h"
#include "fieldmap.h"
#include "field_glb_state.h"

#include "system/clact_util.h"
#include "system/render_oam.h"

#include "field/weather_sys.naix"

#include "system/arc_util.h"

#define __WEATHER_SYS_H_GLOBAL
#include "weather_sys.h"






//-----------------------------------------------------------------------------
/**
 *
 *					VCǗVXe
 * 
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *			萔`
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//		VCύX^XN萔
//=====================================
enum{
	WEATHER_CHENGE_NOW_FADEOUT_START,
	WEATHER_CHENGE_NOW_FADEOUT,
	WEATHER_CHENGE_NEXT_INIT_START,
	WEATHER_CHENGE_NEXT_INIT,
	WEATHER_CHENGE_NEXT_FADEIN_START,
	WEATHER_CHENGE_END,
	
	WEATHER_CHENGE_NONE,		// NGXg
};


#define WEATHER_TCB_CHG_PRI			( 0 )
#define WEATHER_TCB_DIV_LOAD_PRI	( 1 )


//-----------------------------------------------------------------------------
/**
 *			\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	VCǗVXe
//	
//=====================================
typedef struct _WEATHER_MANAGER{
	// VCVXe
	WEATHER_CONT_PTR	weather_sys;

	// Ǘf[^
	int now_play_weather;	// s̓VC

	// ύXtF[hpf[^
	int next_play_weather;	// ɎsVC
	int chenge_seq;			// VCύXV[PX
	TCB_PTR tcb;			// VCύXTCB
} WEATHER_MANAGER;

//-----------------------------------------------------------------------------
/**
 *			vg^Cv錾
 */
//-----------------------------------------------------------------------------
static void WEATHER_ChangeTcb( TCB_PTR tcb, void* work );

//-----------------------------------------------------------------------------
/**
 *		
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCǗVXe쐬
 *
 *	@param	fsys		tB[hVXe[N
 *
 *	@return	VCǗVXe
 *
 *
 */
//-----------------------------------------------------------------------------
WEATHER_MANAGER_PTR WEATHER_Init( FIELDSYS_WORK * fsys )
{
	WEATHER_MANAGER_PTR	wmp;

	// VCǗVXem
	wmp = sys_AllocMemory( HEAPID_FIELD, sizeof(WEATHER_MANAGER) );
	memset( wmp, 0, sizeof(WEATHER_MANAGER) );

	// VCVXe쐬
	wmp->weather_sys = InitWeatherSys( fsys );

	// Ǘf[^
	wmp->now_play_weather = WEATHER_SYS_SUNNY;

	// VCύX^XNf[^
	wmp->next_play_weather = WEATHER_SYS_SUNNY;
	wmp->chenge_seq = WEATHER_CHENGE_NONE;
	wmp->tcb = NULL;

	// OAM`
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );


	return wmp;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCǗVXej
 *
 *	@param	pWes	VCǗVXe
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void WEATHER_Delete( WEATHER_MANAGER_PTR pWes )
{
	// ύXTCBj
	if( pWes->tcb ){
		TCB_Delete( pWes->tcb );
	}
	
	// VCVXej
	DestWeatherSys( &pWes->weather_sys );

	memset( pWes, 0, sizeof(WEATHER_MANAGER) );
	sys_FreeMemoryEz( pWes );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCݒ@Ɏw肵VCɂȂ܂B
 *
 *	@param	pWes	VCǗVXe
 *	@param	no		VCio[
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
void WEATHER_Set( WEATHER_MANAGER_PTR pWes, int no )
{
	BOOL check;

	if( pWes->now_play_weather == no ){
		return ;
	}
	
	// ̓VCj
	check = ControlWeatherSys( pWes->weather_sys, WEATHER_SYS_DEST, pWes->now_play_weather );
	GF_ASSERT( check );	// js

	// ̓VCJn
	check = ControlWeatherSys( pWes->weather_sys, WEATHER_SYS_INIT, no );
	GF_ASSERT( check );	// s
	check = ControlWeatherSys( pWes->weather_sys, WEATHER_SYS_START_NOFADE, no );
	GF_ASSERT( check );	// Jns

	// sVCݒ
	pWes->now_play_weather = no;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCύXNGXg@܂ł̓VCtF[hAEgAXɎw肵VCɂȂ܂B
 *
 *	@param	pWes		VCǗVXe
 *	@param	no			VCio[
 *
 *	@retval	TRUE		NGXg
 *	@retval	FALSE		NGXgs	s̃NGXg
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL WEATHER_ChengeReq( WEATHER_MANAGER_PTR pWes, int no )
{

	// ̓VCꏏȂ牽Ȃ
	if( pWes->now_play_weather == no ){
		return TRUE;
	}
	
	// s̃NGXg邩`FbN
	if( pWes->chenge_seq != WEATHER_CHENGE_NONE ){
		return FALSE;
	}
	
	// ̓VC̃f[^ݒ
	pWes->next_play_weather = no;
	pWes->chenge_seq = WEATHER_CHENGE_NOW_FADEOUT_START;

	// ^XNo^
	pWes->tcb = TCB_Add( WEATHER_ChangeTcb, pWes, WEATHER_TCB_CHG_PRI );

	return TRUE;
}

//-----------------------------------------------------------------------------
/**
 *		VCǗVXe	vCx[g֐
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCύX^XN
 *
 *	@param	tcb		^XN[N
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void WEATHER_ChangeTcb( TCB_PTR tcb, void* work )
{
	WEATHER_MANAGER_PTR wmp = work;
	BOOL check;

	switch( wmp->chenge_seq ){
	// ̓VCtF[hAEg	Jn
	case WEATHER_CHENGE_NOW_FADEOUT_START:
		check = ControlWeatherSys( wmp->weather_sys, WEATHER_SYS_END, wmp->now_play_weather );
		GF_ASSERT( check );		// tF[hAEgJns
		wmp->chenge_seq++;
		break;
		
	// ̓VCtF[hAEg	I҂
	case WEATHER_CHENGE_NOW_FADEOUT:
		check = CheckMoveWeatherSys( wmp->weather_sys, wmp->now_play_weather );
		if( check != WEATHER_SYS_MOVE_DO ){
			check = ControlWeatherSys( wmp->weather_sys, WEATHER_SYS_DEST, wmp->now_play_weather );
			GF_ASSERT( check );	// js
			wmp->chenge_seq++;
		}
		break;

	// X^[g
	case WEATHER_CHENGE_NEXT_INIT_START:
		check = ControlWeatherSys( wmp->weather_sys, WEATHER_SYS_INIT_DIV, wmp->next_play_weather );
		GF_ASSERT( check );		// s
		wmp->chenge_seq++;
		break;
		
	// I҂
	case WEATHER_CHENGE_NEXT_INIT:
		check = CheckMoveWeatherSys( wmp->weather_sys, wmp->next_play_weather );
		if( check != WEATHER_SYS_MOVE_INIT ){
			wmp->chenge_seq++;
		}
		break;
		
	// ̓VCtF[hC		Jn
	case WEATHER_CHENGE_NEXT_FADEIN_START:
		check = ControlWeatherSys( wmp->weather_sys, WEATHER_SYS_START, wmp->next_play_weather );
		GF_ASSERT( check );		// tF[hCJns
		wmp->chenge_seq++;
		break;
		
	// ^XNI
	case WEATHER_CHENGE_END:
		wmp->now_play_weather = wmp->next_play_weather;
		wmp->next_play_weather = WEATHER_SYS_SUNNY;
		
		wmp->chenge_seq = WEATHER_CHENGE_NONE;	// NGXgȂԂɂ
		wmp->tcb = NULL;
		TCB_Delete( tcb );
		break;

	default:
		break;
	}
}




//-----------------------------------------------------------------------------
/**
 *
 *		VCVXe
 *
 */
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------
#define		WEATHER_RES_NUM	(4)		// Ǘ郊\[X̐
#define		WEATEHR_OBJ_MAX	(64)	// IuWFNgő吔
#define		WEATEHR_OBJDATA_MAX	(64)// IuWFNgf[^ő吔
#define		WEATHER_RENDER_X		(0)	// _
#define		WEATHER_RENDER_Y		(0)	// _c
#define		WEATHER_RENDER_WIDTH	(255<< FX32_SHIFT)	// _
#define		WEATHER_RENDER_HEIGHT	(192 << FX32_SHIFT)	// _

#define WEATHER_OBJ_MINTURN_X	(-64*FX32_ONE)
#define WEATHER_OBJ_MINTURN_Y	(-64*FX32_ONE)
#define WEATHER_OBJ_MAXTURN_X	(WEATHER_RENDER_WIDTH + 64*FX32_ONE)
#define WEATHER_OBJ_MAXTURN_Y	(WEATHER_RENDER_HEIGHT + 64*FX32_ONE)

#define		WEATHER_CONTROL_PRI	(4)		// VCǗ^XN̗Dx
#define		WEATHER_OBJ_PRI		(5)		// VCIuWF^XN̗Dx
#define		WEATHER_SYS_BG_2_DRAW_PRI	(1)	// VCVXeBG\
#define		WEATHER_GRAPHIC_NONE	(0xffffffff)	// OtBbNȂ

#define		SCREEN_SIZE (32 * 32)
#define		WEATHER_PLTT_OFS	(6)
#define		WEATHER_LIGHT		(2)		// VCpCg

#define		WEATHER_FOG_DEPTH_DEFAULT	( 0x6F6F )	// tHOftHgl
#define		WEATHER_FOG_SLOPE_DEFAULT	( 3 )

//-------------------------------------
//		ftHgV[PX
//=====================================
enum{
	WEATHER_SEQ_INIT=0,		// 
	WEATHER_SEQ_FADEIN,		// tF[hC
	WEATHER_SEQ_NO_FADE,	// tF[h̏
	WEATHER_SEQ_MAIN,		// C
	WEATHER_SEQ_FADEOUT,	// tF[hAEg
	WEATHER_SEQ_DEST,		// Sj

	WEATHER_SEQ_DEBUG,
};


//-------------------------------------
//	JǗ֐萔
//=====================================
#define	WEATHER_RAIN_TIMING_MIN		(1)							// Jo^C~Oŏ
#define WEATHER_RAIN_TIMING_MAX		(15)						// Jo^C~Oő
#define WEATHER_RAIN_TIMING_ADD		(2)							// ^C~O炷
#define WEATHER_RAIN_ADD_START		(1)							// ŏ̓ɉJo^鐔
#define WEATHER_RAIN_ADD_TIMING		(3)							// J̃^C~OύXP񑝂₷
#define WEATHER_RAIN_ADD			(4)							// o^鐔𑝂₷
#define	WEATHER_RAIN_ADD_MAIN		(20)						// CV[PXł̓o^鐔

/*== tF[hJn̎ ==*/
#define WEATHER_RAIN_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_RAIN_NOFADE_OBJ_START_DUST_NUM	( 10 )			// Pʂŕω邩
#define	WEATHER_RAIN_NOFADE_OBJ_START_DUST_MOVE	( 1 )			// 炵ē삳l

/*== tHO ==*/
#define	WEATHER_RAIN_FOG_TIMING		(1)							// ɂPtHOe[u𑀍
#define	WEATHER_RAIN_FOG_TIMING_END	(1)							// ɂPtHOe[u𑀍
#define WEATHER_RAIN_FOG_START		(0)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_RAIN_FOG_START_END	(48)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_RAIN_FOG_OFS		(0x300)

/*== JIuWFNg ==*/
#define WEATHER_RAIN_SPEED_X		(-5)						// ɐiރXs[h
#define WEATHER_RAIN_SPEED_Y		(10)						// ĂɐiރXs[hx[X
#define	WEATHER_RAIN_END_MIN		(1)							// IJE^ŏ
#define WEATHER_RAIN_END_MAX		(3)							// IJE^ő
#define	WEATHER_RAIN_START_X_BASE	(0)							// x[XɂȂXJnW
#define	WEATHER_RAIN_MUL_X			(15)						// x[XɉJ̎ޕl
#define	WEATHER_RAIN_START_X_MAX	(270)						// XJnW̍ől
#define	WEATHER_RAIN_START_Y		(-96)						// YJnW
#define	WEATHER_RAIN_SPEED_ERR		(20)						// Xs[h␳l

/*== JOtBbN\f[^ ==*/
#define WEATHER_RAIN_GRAPHIC_CELL	( 0 )
#define WEATHER_RAIN_GRAPHIC_BG		( WEATHER_GRAPHIC_NONE )

//-------------------------------------
//	Ǘ֐萔
//=====================================
#define	WEATHER_SNOW_TIMING_MIN		(8)				// o^C~Oŏ
#define WEATHER_SNOW_TIMING_MAX		(20)				// o^C~Oő
#define WEATHER_SNOW_TIMING_ADD		(2)					// ^C~O炷
#define	WEATHER_SNOW_ADD_TIMING		(4)					// Px̃IuWFo^𑝂₷^C~O
#define	WEATHER_SNOW_ADD			(0)					// IuWFo^𑫂l
#define WEATHER_SNOW_MAIN			(1)					// Cł͂ꂾo^

/*== tF[hJn̎ ==*/
#define WEATHER_SNOW_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_SNOW_NOFADE_OBJ_START_DUST_NUM	( 2 )			// 炷
#define	WEATHER_SNOW_NOFADE_OBJ_START_DUST_MOVE	( 24 )			// 炵ē삳l

/*== tHO ==*/
#define	WEATHER_SNOW_FOG_TIMING		(1)							// ɂPtHOe[u𑀍
#define	WEATHER_SNOW_FOG_TIMING_END	(2)							// ɂPtHOe[u𑀍
#define WEATHER_SNOW_FOG_START		(32)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_SNOW_FOG_START_END	(64)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_SNOW_FOG_OFS		(0x300)

/*== IuWFNg ==*/
#define	WEATHER_SNOW_ADD_TMG_X_BASE	(4)					// ̃Xs[h𑫂^C~O
#define	WEATHER_SNOW_ADD_TMG_X_RAN	(2)					// ̃Xs[h𑫂^C~Ol
#define	WEATHER_SNOW_ADD_TMG_Y_BASE	(1)					// ̃Xs[h𑫂^C~O
#define	WEATHER_SNOW_ADD_TMG_Y_RAN	(2)					// ̃Xs[h𑫂^C~Ol

#define	WEATHER_SNOW_START_X_BASE	(-32)						// x[XɂȂXJnW
#define	WEATHER_SNOW_START_X_MAX	(414)						// XJnW̍ől
#define WEATHER_SNOW_OBJ_NUM		(4)					// IuWF

/*== OtBbN\f[^ ==*/
#define WEATHER_SNOW_GRAPHIC_CELL	( 3 )
#define WEATHER_SNOW_GRAPHIC_BG		( WEATHER_GRAPHIC_NONE )


//-------------------------------------
//	Ǘ֐萔
//=====================================
#define	WEATHER_SSNOW_TIMING_MIN		(3)							// Jo^C~Oŏ
#define WEATHER_SSNOW_TIMING_MAX		(30)						// Jo^C~Oő
#define WEATHER_SSNOW_TIMING_ADD		(3)							// ^C~O炷
#define WEATHER_SSNOW_ADD_START			(1)							// ŏ̓ɉJo^鐔
#define WEATHER_SSNOW_ADD_TIMING		(4)							// J̃^C~OύXP񑝂₷
#define WEATHER_SSNOW_ADD				(1)							// o^鐔𑝂₷
#define WEATHER_SSNOW_ADD_END			(-3)							// o^鐔𑝂₷
#define	WEATHER_SSNOW_ADD_MAIN			(6)							// CV[PXł̓o^鐔

/*== tF[hJn̎ ==*/
#define WEATHER_SSNOW_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_SSNOW_NOFADE_OBJ_START_DUST_NUM		( 2 )			// 炷
#define	WEATHER_SSNOW_NOFADE_OBJ_START_DUST_MOVE	( 3 )			// 炵ē삳l

/*== tHO ==*/
#define	WEATHER_SSNOW_FOG_TIMING		(2)							// ɂPtHOe[u𑀍
#define	WEATHER_SSNOW_FOG_TIMING_END	(1)							// ɂPtHOe[u𑀍
#define WEATHER_SSNOW_FOG_START			(16)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_SSNOW_FOG_START_END		(0)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_SSNOW_FOG_OFS			(-0x200)

/*== IuWFNg ==*/
#define WEATHER_SSNOW_SPEED_X		(-1)						// ɐiރXs[h
#define	WEATHER_SSNOW_END_MIN		(4)							// IJE^ŏ
#define WEATHER_SSNOW_END_MAX		(46)						// IJE^ő
#define WEATHER_SSNOW_END_NUM		(WEATHER_SSNOW_END_MAX - WEATHER_SSNOW_END_MIN)	// JE^̒l̐
#define	WEATHER_SSNOW_END_DIV		((WEATHER_SSNOW_END_NUM / 3)+1)	// IuWFNg̎ނvZƂl
#define	WEATHER_SSNOW_START_X_BASE	(-20)						// x[XɂȂXJnW
#define	WEATHER_SSNOW_MUL_X			(20)						// x[Xɐ̎ޕl
#define	WEATHER_SSNOW_START_X_MAX	(420)						// XJnW̍ől
#define	WEATHER_SSNOW_START_Y		(-8)						// YJnW
#define	WEATHER_SSNOW_SPEED_ADD_TMG	(20)						// XW̃Xs[hグ^C~O

#define	WEATHER_SSNOW_ADD_SP_TMG_NUM (4)						// Xs[hύX^C~O̐
#define	WEATHER_SSNOW_ADD_SP_TMG_TMG (200)						// Xs[hύX^C~Õ^C~O

/*== OtBbN\f[^ ==*/
#define WEATHER_SSNOW_GRAPHIC_CELL	( 1 )
#define WEATHER_SSNOW_GRAPHIC_BG	( WEATHER_GRAPHIC_NONE )

/*== BGOtBbN\f[^ ==*/
#define WEATHER_SSNOW_BG_GRAPHIC_CELL	( 1 )
#define WEATHER_SSNOW_BG_GRAPHIC_BG	( 0 )


//-----------------------
// kC
//=======================
#define	WEATHER_SNOW_S_TIMING_MIN		(1)							// o^C~Oŏ
#define WEATHER_SNOW_S_TIMING_MAX		(15)						// o^C~Oő
#define WEATHER_SNOW_S_TIMING_ADD		(2)							// ^C~O炷
#define WEATHER_SNOW_S_ADD_START		(4)							// ŏ̓ɐo^鐔
#define WEATHER_SNOW_S_ADD_TIMING		(4)							// ̃^C~OύXP񑝂₷
#define WEATHER_SNOW_S_ADD				(3)							// o^鐔𑝂₷
#define WEATHER_SNOW_S_ADD_END			(-4)							// o^鐔𑝂₷
#define	WEATHER_SNOW_S_ADD_MAIN			(10)						// CV[PXł̓o^鐔

/*== tF[hJn̎ ==*/
#define WEATHER_SNOW_S_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_SNOW_S_NOFADE_OBJ_START_DUST_NUM	( 2 )		// P炵ē삳
#define	WEATHER_SNOW_S_NOFADE_OBJ_START_DUST_MOVE	( 2 )		// P炵ē삳

/*== tHO ==*/
#define	WEATHER_SNOW_S_FOG_TIMING		(1)							// ɂPtHOe[u𑀍
#define	WEATHER_SNOW_S_FOG_TIMING_END	(1)							// ɂPtHOe[u𑀍
#define WEATHER_SNOW_S_FOG_START		(16)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_SNOW_S_FOG_START_END	(32)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_SNOW_S_FOG_OFS	(-0x500)

/*== BG ==*/
#define WEATHER_SNOW_S_BG_ALP_TIM_S	(6)		// At@Pグ^C~O
#define WEATHER_SNOW_S_BG_ALP_TIM_E	(8)		// At@P^C~O

// IuWF 
#define	WEATHER_SNOW_S_END_MIN		(18)						// IJE^ŏ
#define WEATHER_SNOW_S_END_MAX		(24)						// IJE^ő
#define WEATHER_SNOW_S_START_X		(256)						// oƂXW
#define WEATHER_SNOW_S_START_X_RAN	(24)						// oƂXW
#define	WEATHER_SNOW_S_START_Y_BASE	(-32)							// x[XɂȂYJnW
#define	WEATHER_SNOW_S_START_Y_MAX	(168)						// XJnW̍ől

#define	WEATHER_SNOW_S_SPEED_ADD_TMG (10)						// XW̃Xs[hグ^C~O

#define	WEATHER_SNOW_S_ADD_SP_TMG_NUM (4)						// Xs[hύX^C~O̐
#define	WEATHER_SNOW_S_ADD_SP_CHG_TMG (512)						// Xs[hύX^C~Õ^C~O

#define WEATHER_SNOW_S_ADD_SP_TMG		(4)						// Xs[hύX^C~O
#define WEATHER_SNOW_S_SP_UP			(8)						// ̒lȏ̉Xs[ĥƂ͔hɂ
static int WEATHER_SSNOW_SPEED_X_SML[WEATHER_SNOW_S_ADD_SP_TMG_NUM] = {-4,-6,-8,-10};
static int WEATHER_SSNOW_SPEED_Y_SML[WEATHER_SNOW_S_ADD_SP_TMG_NUM] = {2,4,2,4};	// ĂɐiރXs[h

//#define WEATHER_SNOW_S_BG_ALPHA0	(4)
//#define WEATHER_SNOW_S_BG_ALPHA1	(8)
//#define WEATHER_SNOE_S_BG_ALPHA_DEF	(16)

/*== ҐBGOtBbN\f[^ ==*/
#define WEATHER_SNOW_S_GRAPHIC_CELL	( 3 )
#define WEATHER_SNOW_S_GRAPHIC_BG	( 0 )


//-------------------------------------
//	Ǘ֐萔
//=====================================
#define	WEATHER_STORM_TIMING_MIN		(1)							// o^C~Oŏ
#define WEATHER_STORM_TIMING_MAX		(15)						// o^C~Oő
#define WEATHER_STORM_TIMING_ADD		(2)							// ^C~O炷
#define WEATHER_STORM_TIMING_ADD_END	(1)							// ^C~O炷
#define WEATHER_STORM_ADD_START			(1)							// ŏ̓ɉJo^鐔
#define WEATHER_STORM_ADD_TIMING		(4)							// ̃^C~OύXP񑝂₷
#define WEATHER_STORM_ADD				(2)							// o^鐔𑝂₷
#define WEATHER_STORM_ADD_END			(-3)							// o^鐔𑝂₷
#define	WEATHER_STORM_ADD_MAIN			(8)							// CV[PXł̓o^鐔

/*== tF[hJn̎ ==*/
#define WEATHER_STORM_NOFADE_OBJ_START_NUM	( 24 )				// Jn̎UzIuWFNg̐
#define	WEATHER_STORM_NOFADE_OBJ_START_DUST_NUM		( 2 )			// 炵ē삳邩
#define	WEATHER_STORM_NOFADE_OBJ_START_DUST_MOVE	( 2 )			// P炵ē삳

/*== tHO ==*/
#define	WEATHER_STORM_FOG_TIMING		(1)							// ɂPtHOe[u𑀍
#define	WEATHER_STORM_FOG_TIMING_END	(1)							// ɂPtHOe[u𑀍
#define WEATHER_STORM_FOG_START			(0)							// ̃JEgĂtHOe[u𑀍
#define WEATHER_STORM_FOG_START_END		(31)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_STORM_FOG_OFS	( -0x580 )


/*== BG ==*/
#define WEATHER_STORM_BG_ALP_TIM_S	(32)		// At@Pグ^C~O
#define WEATHER_STORM_BG_ALP_TIM_E	(24)		// At@P^C~O
#define WEATHER_STORM_BG_ALP_S_END	( 3 )
#define WEATHER_STORM_BG_ALP_E_END	( 0 )
#define WEATHER_STORM_BG_ALP_DEF	( 16 )

#define WEATHER_STORM_BG_ALP_STRONG_WIND	(4)	// ̂Ƃ̃l


/*== IuWFNg ==*/
#define	WEATHER_STORM_END_MIN		(15)						// IJE^ŏ
#define WEATHER_STORM_END_MAX		(35)						// IJE^ő
#define WEATHER_STORM_END_NUM		(WEATHER_STORM_END_MAX - WEATHER_STORM_END_MIN)	// JE^̒l̐
#define	WEATHER_STORM_END_DIV		((WEATHER_STORM_END_NUM / 4)+1)	// IuWFNg̎ނvZƂl
#define	WEATHER_STORM_START_X1		(262)						// x[XɂȂXJnW	悱p
#define	WEATHER_STORM_START_X1_RAN	(24)						// x[XɂȂXJnW	悱p
#define WEATHER_STORM_START_Y1_MIN	( -64 )						//  YJnWŏ
#define	WEATHER_STORM_START_Y1_MAX	(192)						// YJnWő
#define	WEATHER_STORM_SPEED_NUM		(8)							// ̐
#define	WEATHER_STORM_SPEED_CNG_NUM	(40)						// ς^C~O
#define WEATHER_STORM_SPEED_ADD_TMG (5)						// ̐ς^C~O

#define WEATHER_STORM_STRONG_CHG	(6)						// ̒lȏɂȂ


/*== Ȃ炵OtBbN\f[^ ==*/
#define WEATHER_STORM_GRAPHIC_CELL	( 2 )
#define WEATHER_STORM_GRAPHIC_BG	( WEATHER_GRAPHIC_NONE )

#define WEATHER_STORMBG_GRAPHIC_CELL	( 2 )
#define WEATHER_STORMBG_GRAPHIC_BG	( 1 )


//-------------------------------------
//	Ǘ֐萔
//=====================================
/*== tHO ==*/
#define	WEATHER_FOG_TIMING		(2)							// ɂPtHOe[u𑀍
#define	WEATHER_FOG_TIMING_END	(2)							// ɂPtHOe[u𑀍
#define WEATHER_FOG_START		(16)						// ̃JEgĂtHOe[u𑀍
#define WEATHER_FOG_START_END	(16)						// ̃JEgĂtHOe[u𑀍

#define WEATHER_FOG0_OFS	( 0x200 )
#define WEATHER_FOG1_OFS	( -0x9E0 )	
#define WEATHER_FOG1_SLOPE	( 3 )
#define WEATHER_FOG2_OFS	( -0x800 )


//-------------------------------------
//	Xm[_Xg֌W
//====================================
#define	WEATHER_SNOW_D_TIMING_MIN		(2)							// o^C~Oŏ
#define WEATHER_SNOW_D_TIMING_MAX		(16)						// o^C~Oő
#define WEATHER_SNOW_D_TIMING_ADD		(2)							// ^C~O炷
#define WEATHER_SNOW_D_TIMING_ADD_END	(2)							// ^C~O炷
#define WEATHER_SNOW_D_ADD_START		(2)							// ŏ̓ɓo^鐔
#define WEATHER_SNOW_D_ADD_TIMING		(4)							// ^C~OύXP񑝂₷
#define WEATHER_SNOW_D_ADD				(2)							// o^鐔𑝂₷
#define WEATHER_SNOW_D_ADD_END			(4)							// o^鐔𑝂₷
#define	WEATHER_SNOW_D_ADD_MAIN			(20)						// CV[PXł̓o^鐔

/*== tF[hJn̎ ==*/
#define WEATHER_SNOW_D_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_SNOW_D_NOFADE_OBJ_START_DUST_NUM	( 10 )		// 쐔邩
#define	WEATHER_SNOW_D_NOFADE_OBJ_START_DUST_MOVE	( 1 )		// 炵ē삳l


/*== tHO ==*/
#define	WEATHER_SNOW_D_FOG_TIMING		(1)							// ɂPtHOe[u𑀍
#define	WEATHER_SNOW_D_FOG_TIMING_END	(1)							// ɂPtHOe[u𑀍
#define WEATHER_SNOW_D_FOG_START		(0)							// ̃JEgĂtHOe[u𑀍
#define WEATHER_SNOW_D_FOG_START_END	(0)							// ̃JEgĂtHOe[u𑀍
#define WEATHER_SNOW_D_FOG_OFS			(0x200)

// IuWFNg
#define WEATHER_SNOW_D_START_X_MIN		(-64)					// JnW
#define	WEATHER_SNOW_D_START_X_DIS		(384)					// ŋ߂JnW̒l
#define WEATHER_SNOW_D_START_Y			(-8)					// o
#define WEATHER_SNOW_D_START_Y_MAX		(256)					// o
#define WEATHER_SNOW_D_SPARK_NUM_MIN	(7)						// ꂾoĂŏ
#define WEATHER_SNOW_D_SPARK_NUM_RAN	(5)						// ŋ߂l
#define WEATHER_SNOW_D_SPARK_NO			(0x14)					// ̐

#define WEATHER_SNOW_D_SP_ADD_TMG_X_MIN	(3)						//@IuWFNg̃Xs[h𑫂^C~O
#define WEATHER_SNOW_D_SP_ADD_TMG_X_MAX	(6)					//@IuWFNg̃Xs[h𑫂^C~O
#define WEATHER_SNOW_D_SP_ADD_TMG_Y_MIN	(4)						// IuWFNg̃Xs[h𑫂^C~O
#define WEATHER_SNOW_D_SP_ADD_TMG_Y_MAX	(5)					// IuWFNg̃Xs[h𑫂^C~O	

/*== Xm[_XgOtBbN\f[^ ==*/
#define WEATHER_SNOW_D_GRAPHIC_CELL	( 4 )
#define WEATHER_SNOW_D_GRAPHIC_BG	( WEATHER_GRAPHIC_NONE )


//-------------------------------------
//	
//=====================================
/*== OtBbN\f[^ ==*/
#define WEATHER_RAINBOW_GRAPHIC_CELL	( WEATHER_GRAPHIC_NONE  )
#define WEATHER_RAINBOW_GRAPHIC_BG		( 2 )

/*== [NTCY ==*/
#define WEATHER_RAINBOW_WORK_SIZE		(sizeof(int)*10)


//-------------------------------------
//	J
//=====================================
#define	WEATHER_STRAIN_TIMING_MIN		(1)					// Jo^C~Oŏ
#define WEATHER_STRAIN_TIMING_MAX		(15)				// Jo^C~Oő
#define WEATHER_STRAIN_TIMING_ADD		(2)					// ^C~O炷
#define WEATHER_STRAIN_ADD_START		(1)					// ŏ̓ɉJo^鐔
#define WEATHER_STRAIN_ADD_TIMING		(3)					// J̃^C~OύXP񑝂₷
#define WEATHER_STRAIN_ADD			(4)						// o^鐔𑝂₷
#define WEATHER_STRAIN_ADD_END			(-6)				// o^鐔𑝂₷
#define	WEATHER_STRAIN_ADD_MAIN		(24)					// CV[PXł̓o^鐔

/*== tF[hJn̎ ==*/
#define WEATHER_STRAIN_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_STRAIN_NOFADE_OBJ_START_DUST_NUM	( 5 )		// 쐔ύX邩
#define	WEATHER_STRAIN_NOFADE_OBJ_START_DUST_MOVE	( 1 )		// 炷쐔̒l

/*== tHO ==*/
#define	WEATHER_STRAIN_FOG_TIMING		(1)						// ɂPtHOe[u𑀍
#define	WEATHER_STRAIN_FOG_TIMING_END	(1)						// ɂPtHOe[u𑀍
#define WEATHER_STRAIN_FOG_START		(0)					// ̃JEgĂtHOe[u𑀍
#define WEATHER_STRAIN_FOG_START_END	(0)					// ̃JEgĂtHOe[u𑀍


/*== JIuWFNg ==*/
#define WEATHER_STRAIN_SPEED_X		(-24)						// ɐiރXs[h
#define WEATHER_STRAIN_SPEED_Y		(24)							// ĂɐiރXs[hx[X
#define	WEATHER_STRAIN_END_MIN		(0)							// IJE^ŏ
#define WEATHER_STRAIN_END_MAX		(6)							// IJE^ő
#define	WEATHER_STRAIN_START_X		(0)							// x[XɂȂXJnW
#define	WEATHER_STRAIN_START_X_MAX	(512)						// XJnWl
#define	WEATHER_STRAIN_START_Y		(-64)						// YJnW
#define	WEATHER_STRAIN_START_Y_MAX	(64)						// YJnWl

#define WEATHER_STRAIN_OBJ_MUL_NUM	(5)							// IuWF̃Xs[hωl
#define WEATHER_STRAIN_OBJ_MUL_CHG	(60)						// ύX^C~O

/*== JOtBbN\f[^ ==*/
#define WEATHER_STRAIN_GRAPHIC_CELL	( 5 )
#define WEATHER_STRAIN_GRAPHIC_BG	( WEATHER_GRAPHIC_NONE )

//-------------------------------------
//	ΎRDǗ֐萔
//=====================================
#define	WEATHER_VOLCANO_TIMING_MIN	(6)		// ΎRDo^C~Oŏ
#define WEATHER_VOLCANO_TIMING_MAX	(12)		// ΎRDo^C~Oő
#define WEATHER_VOLCANO_TIMING_ADD	(1)			// ^C~O炷
#define	WEATHER_VOLCANO_ADD_TIMING	(4)			// Px̃IuWFo^𑝂₷^C~O
#define	WEATHER_VOLCANO_ADD			(0)			// IuWFo^𑫂l
#define WEATHER_VOLCANO_MAIN		(1)			// Cł͂ꂾo^

/*== tF[hJn̎ ==*/
#define WEATHER_VOLCANO_NOFADE_OBJ_START_NUM	( 20 )				// Jn̎UzIuWFNg̐
#define	WEATHER_VOLCANO_NOFADE_OBJ_START_DUST_NUM	( 2 )		// IuWF쐔ւ񂱂邩
#define	WEATHER_VOLCANO_NOFADE_OBJ_START_DUST_MOVE	( 16 )		// 炷쐔̒l

/*== tHO ==*/
#define	WEATHER_VOLCANO_FOG_TIMING		(1)		// ɂPtHOe[u𑀍
#define	WEATHER_VOLCANO_FOG_TIMING_END	(1)		// ɂPtHOe[u𑀍
#define WEATHER_VOLCANO_FOG_START		(0)	// ̃JEgĂtHOe[u𑀍
#define WEATHER_VOLCANO_FOG_START_END	(9)	// ̃JEgĂtHOe[u𑀍
#define WEATHER_VOLCANO_FOG_OFS			(-0x400)

/*== BG ==*/
#define WEATHER_VOLCANO_BG_ALP_TIM_S	(6)		// At@Pグ^C~O
#define WEATHER_VOLCANO_BG_ALP_TIM_E	(8)		// At@P^C~O
#define WEATHER_VOLCANO_BG_ALP_S_END	( 15 )
#define WEATHER_VOLCANO_BG_ALP_E_END	( 0 )
#define WEATHER_VOLCANO_BG_ALP_DEF		( 16 )

/*== ΎRDIuWFNg ==*/
#define	WEATHER_VOLCANO_ADD_TMG_Y_BASE	(1)			// ΎRD̃Xs[h𑫂^C~O
#define	WEATHER_VOLCANO_ADD_TMG_Y_RAN	(1)			// ΎRD̃Xs[h𑫂^C~Ol
#define	WEATHER_VOLCANO_START_X_BASE	(-32)		// x[XɂȂXJnW
#define	WEATHER_VOLCANO_START_X_MAX		(414)		// XJnW̍ől
#define WEATHER_VOLCANO_OBJ_NUM			(4)			// IuWF

/*== ΎRDOtBbN\f[^ ==*/
#define WEATHER_VOLCANO_GRAPHIC_CELL	( 6 )
#define WEATHER_VOLCANO_GRAPHIC_BG	( 3 )

//-------------------------------------
//	Ǘ֐萔
//=====================================
#define WEATHER_SPARK_NUM		(2)	// CgJEg
#define WEATHER_SPARK_POWER_MIN	(200)	// POWERŏ	(_vẐ߂POOl)
#define WEATHER_SPARK_POWER_RAN	(480)	// POWER	(_vẐ߂POOl)

#define WEATHER_SPARK_SPARK_MUL	(50)	// ̗܂ł̊ԊuPOWER{ԊuƂċ߁A
										//	̒lŗvft(PPʁ[POO)
#define WEATHER_SPARK_SPARK_RAN	(120)	// ̗܂ł̊Ԋu
#define WEATHER_SPARK_SPARK_RAN_HIGH	(15)	// oƂ̗̎܂ł̊Ԋu
#define	WEATHER_SPARK_FOG_TIMING		(1)		// ɂPtHOe[u𑀍
#define	WEATHER_SPARK_FOG_TIMING_END	(1)		// ɂPtHOe[u𑀍
#define WEATHER_SPARK_SUB_NUM			(36)	// l炷l
#define WEATHER_SPARK_SUB_NUM_HIGH		(200)	// At@炷

/*== OtBbN\f[^ ==*/
#define WEATHER_SPARK_GRAPHIC_CELL	( WEATHER_GRAPHIC_NONE )
#define WEATHER_SPARK_GRAPHIC_BG	( 4 )
/*== [NTCY ==*/
#define WEATHER_SPARK_WORK_SIZE		(sizeof(int)*10)

//-------------------------------------
//	CǗ֐萔
//=====================================
#define	WEATHER_SPIRIT_TIMING_MIN	(15)		// Jo^C~Oŏ
#define WEATHER_SPIRIT_TIMING_MAX	(35)		// Jo^C~Oő
#define WEATHER_SPIRIT_TIMING_ADD	(2)			// ^C~O炷
#define	WEATHER_SPIRIT_ADD_TIMING	(5)			// Px̃IuWFo^𑝂₷^C~O
#define	WEATHER_SPIRIT_ADD			(1)			// IuWFo^𑫂l
#define	WEATHER_SPIRIT_ADD_END		(-3)			// IuWFo^𑫂l
#define WEATHER_SPIRIT_MAIN			(4)			// Cł͂ꂾo^

#define WEATHER_SPIRIT_S_MOVE_NUM	(2)			// ݂ɗh鋗()
#define WEATHER_SPIRIT_S_MOVE_TMG	(1)			// ݂ɗh^C~O

#define WEATHER_SPIRIT_OBJ_NUM		(0xe)		// IuWFNg
#define WEATHER_SPIRIT_BIG_DIV		(4)			// ŊƁA傫ɂȂ
#define	WEATHER_SPIRIT_SHIFT_UP		(8)			// 傫idxł
#define WEATHER_SPIRIT_SHIFT_UP_RAN	(25)		// l
#define	WEATHER_SPIRIT_ADD_SPEED	(16)		// niXs[h͂POO{ԁj

/*== tF[hJn̎ ==*/
#define WEATHER_SPIRIT_NOFADE_OBJ_START_NUM	( 16 )				// Jn̎UzIuWFNg̐
#define	WEATHER_SPIRIT_NOFADE_OBJ_START_DUST_NUM	( 2 )		// IuWF삷鐔ύX邩
#define	WEATHER_SPIRIT_NOFADE_OBJ_START_DUST_MOVE	( 1 )		// 炵ē삳l

/*== IuWFNg ==*/
#define WEATHER_SPIRIT_MAT_X_MIN	(-128)		// XWŏl
#define WEATHER_SPIRIT_MAT_X_RAN	(512)		// XW

#define WEATHER_SPIRIT_MAT_Y_S_MIN	(8)			// YW	̂Ăꏊ(0,1)
#define WEATHER_SPIRIT_MAT_Y_S_RAN	(192)		// YW	̂Ăꏊ
#define WEATHER_SPIRIT_MAT_Y_M_MIN	(64)		// YW	炢Ăꏊ(2)
#define WEATHER_SPIRIT_MAT_Y_M_RAN	(128)		// YW	炢Ăꏊ
#define WEATHER_SPIRIT_MAT_Y_L_MIN	(160)		// YW	傫̂Ăꏊ(3)
#define WEATHER_SPIRIT_MAT_Y_L_RAN	(32)		// YW	傫̂Ăꏊ


/*== COtBbN\f[^ ==*/
#define WEATHER_SPIRIT_GRAPHIC_CELL	( 7 )
#define WEATHER_SPIRIT_GRAPHIC_BG	( WEATHER_GRAPHIC_NONE  )

//-------------------------------------
//	_
//=====================================
#define	WEATHER_MYSTIC_TIMING_MIN	(10)		// o^C~Oŏ
#define WEATHER_MYSTIC_TIMING_MAX	(40)		// o^C~Oő
#define WEATHER_MYSTIC_TIMING_ADD	(3)			// ^C~O炷
#define	WEATHER_MYSTIC_ADD_TIMING	(8)			// Px̃IuWFo^𑝂₷^C~O
#define WEATHER_MYSTIC_ADD_START	(1)
#define	WEATHER_MYSTIC_ADD			(0)			// IuWFo^𑫂l
#define	WEATHER_MYSTIC_ADD_END		(1)			// IuWFo^𑫂l
#define WEATHER_MYSTIC_ADD_MAIN		(1)			// Cł͂ꂾo^

/*== tF[hJn̎ ==*/
#define WEATHER_MYSTIC_NOFADE_OBJ_START_NUM	( 4 )				// Jn̎UzIuWFNg̐
#define	WEATHER_MYSTIC_NOFADE_OBJ_START_DUST_NUM	( 1 )		// IuWF쐔ύX邩
#define	WEATHER_MYSTIC_NOFADE_OBJ_START_DUST_MOVE	( 10 )		// 炵ē삳l

/*== tHO ==*/
#define	WEATHER_MYSTIC_FOG_TIMING		(1)		// ɂPtHOe[u𑀍
#define	WEATHER_MYSTIC_FOG_TIMING_END	(1)		// ɂPtHOe[u𑀍
#define WEATHER_MYSTIC_FOG_START		(0)		// ̃JEgĂtHOe[u𑀍
#define WEATHER_MYSTIC_FOG_START_END	(48)	// ̃JEgĂtHOe[u𑀍
#define WEATHER_MYSTIC_FOG_OFS			(0x400)

// IuWFNg
#define WEATHER_MYSTIC_M_Y			(60)		// ړl
#define WEATHER_MYSTIC_M_Y_MUL		(20)		// 傫ɂ葝₷l
#define WEATHER_MYSTIC_M_X			(0)			// ړl

#define WEATHER_MYSTIC_MH_X			(50)		// VĂ悤ɌA⏕ړl
#define WEATHER_MYSTIC_MH_Y			(50)		// VĂ悤ɌA⏕ړl
#define WEATHER_MYSTIC_MH_COUNT		(2)			// JEgl
#define WEATHER_MYSTIC_MH_COUNT_RAN	(6)			// JEgl


#define WEATHER_MYSTIC_DES_TM		(32)		// SJEg
#define WEATHER_MYSTIC_DES_RAN		(16)		// SJEg_

#define WEATHER_MYSTIC_NUM			(4)			// IuWFNg
#define WEATHER_MYSTIC_RAN			(100)		// ǂ̑傫ɂ邩߂鎞̒l
#define WEATHER_MYSTIC_RAN_0		(40)		// IuWF̊
#define WEATHER_MYSTIC_RAN_1		(30)		// IuWF̊
#define WEATHER_MYSTIC_RAN_2		(20)		// IuWF̊
#define WEATHER_MYSTIC_RAN_3		(10)		// IuWF̊

#define WEATHER_MYSTIC_MAT_X		(0)			// JnW
#define WEAHTER_MYSTIC_MAT_X_RAN	(512)		// JnWl
#define WEAHTER_MYSTIC_MAT_Y		(0)			// JnW
#define WEATHER_MYSTIC_MAT_Y_MUL	(48)		// JnW傫ɂςl
#define WEAHTER_MYSTIC_MAT_Y_RAN	(64)		// JnWl

/*== _OtBbN\f[^ ==*/
#define WEATHER_MYSTIC_GRAPHIC_CELL	( 8 )
#define WEATHER_MYSTIC_GRAPHIC_BG	( WEATHER_GRAPHIC_NONE  )

//-----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	VCOtBbNt@CpXf[^
//
//	ǂݍޓVC̃OtBbNt@C
//	܂Ƃ߂\
//=====================================

// BG
typedef struct{
	int pltt_arc;
	int char_arc;
	int screen_arc;
	/*char	pltt_path[50];	// pbgpX
	char	char_path[50];	// LN^pX
	char	screen_path[50];// XN[pX//*/
} WEATHER_BG_DATA;

//-------------------------------------
//	VCOtBbNf[^\
//-------------------------------------
// Z
typedef struct{
	CLACT_U_RES_OBJ_PTR res_obj[ WEATHER_RES_NUM ];
	CLACT_ADD add;				// ZAN^[o^f[^
	CLACT_HEADER head;			// ZAN^[wb_[f[^
} WATHER_GRAPHIC_FILE_DATA;

// BG
typedef struct{
	char*			pPlttBuff;		// pbgf[^
	char*			pCharBuff;		// LN^f[^
	char*			pScreenBuff;	// XN[f[^
	NNSG2dScreenData*		pScreen;// XN[f[^
	NNSG2dCharacterData*	pChar;	// BG̃LN^f[^
	NNSG2dPaletteData*		pPltt;	// BG̃pbgf[^

} WATHER_BG_FILE_DATA;

//-------------------------------------
//
//		X̃IuWFNg̍\
//	
//	JÃIuWFNg
//=====================================
typedef struct WAETHER_OBJ_DATA_tag{
	WEATHER_CONT_PTR	pWSysCont;	// VCf[^
	CLACT_WORK_PTR	clact_w;	// ZAN^[[N
	void*	work;					// Ɨ̈		AllocObjWork() FreeObjWork()ō쐬Aj邱

	struct WAETHER_OBJ_DATA_tag* pNext;	// 
	struct WAETHER_OBJ_DATA_tag* pPrev;	// O
} WAETHER_OBJ_DATA;

//------------------------------------
//		VCǗf[^\
//	
//	VCǗ֐ł̃[N̈\
//=====================================
typedef struct{
	WEATHER_CONT_PTR	pWSysCont;			// VCVXeRg[̃|C^
	CLACT_SET_PTR	clactSet;			// ZAN^Zbg
	
	const WATHER_GRAPHIC_FILE_DATA*	pCell;		// gpZf[^
	u8		Sequence;						// V[PX
	u8		ContFlag;						// ORg[tO		
	WAETHER_OBJ_DATA	Dummy;				// IuWFXg̃_~[f[^
	WAETHER_OBJ_DATA	ObjArray[WEATEHR_OBJDATA_MAX];// IuWFXgz
	TCB_PTR tcb;							// ̃^XN|C^
	
	VecFx32		CameraTarget;				// PÕJ^[QbgXN[p
	void*		work;						// [N̈ e쐬	
} WEATHER_SYS_WORK;

//-------------------------------------
//		VCf[^\
//
//	gpt@C֐̃f[^S
//=====================================
typedef struct{
	int		GraphicNo;					// OtBbNf[^zio[
	int		BGNo;						// BGf[^zio[
	int		WorkByte;					// [N̈̃oCgTCY
	WEATHER_SYS_WORK* pWork;			// s:VCǗ֐̃[N̈	ĂȂƂ:NULL
	WATHER_GRAPHIC_FILE_DATA*	pCell;	// gpZf[^	ĂȂƂ:NULL
	int		MoveFlag;					// 
			  /*WEATHER_SYS_MOVE_NONE,	// ĂȂ
				WEATHER_SYS_MOVE_INIT,	// 
				WEATHER_SYS_MOVE_READY,	// Jn҂
				WEATHER_SYS_MOVE_DO,*/	// s
	
	int		DivInitSeq;					// ǂݍ݃V[PX
	TCB_PTR	DivInitTcb;					// ǂݍTCB
	
	void	(*cont)(TCB_PTR tcb, void* data);		// VCǗ֐
} WEATHER_SYS_DATA;

typedef void (*objFunc)(WAETHER_OBJ_DATA*);		// IuWFNg֐^

//-------------------------------------
//	
//	QD`VXe\
//	
//=====================================
typedef struct {
	
	CLACT_U_RES_MANAGER_PTR	resMan[ WEATHER_RES_NUM ];	// \[X}l[W
	CLACT_U_RES_HEADER_PTR	resHeader;					// \[Xwb_

	// Cʗp_[f[^
	NNSG2dRendererInstance	Render;		// _
	NNSG2dRenderSurface		Surface;	// T[tF[X
	
	
} WEATHER_SYS_DRAWSYS;


//---------------------------------------------------------
//
//		VCVXeIuWF
//			VCVXẽIuWFNg
//
//=========================================================
typedef struct _WEATHER_SYS_CONTROL{
	WEATHER_SYS_DATA*		pWSD;		// VCVXef[^
	WEATHER_BG_DATA*		pWSBG;		// VCVXeBGf[^

	WEATHER_SYS_DRAWSYS		Draw;		// `VXe
		
	FIELDSYS_WORK* fsys;					// tB[hVXe|C^

	ARCHANDLE*	ArcHandle;		// A[JCut@Cnh
} WEATHER_SYS_CONTROL;

//-----------------------------------------------
//	̑Ɨp\
//==============================================
//-------------------------------------
//	IuWFNgtF[hf[^
//-------------------------------------
typedef struct{
	// [N
	WEATHER_SYS_WORK* pWork;	// [N

	// JE^
	s32 objAddNum;		// IuWFNgo^
	s32 objAddTmg;		// o^^C~OJE^
	s32 objAddTmgMax;	// o^^C~O
	s32 objAddNumSum;	// IuWFNgo^JE^
	
	// 萔
	s32	OBJ_ADD_NUM_END;		// IuWFNgP̓o^@Il
	s32	OBJ_ADD_TMG_END;		// o^^C~OJE^@Il
	s32	OBJ_ADD_TMG_SUM;		// o^^C~OJE^ύXl
	s32 OBJ_ADD_NUM_SUM_TMG;	// IuWFNgP̓o^ύX^C~O
	s32 OBJ_ADD_NUM_SUM;		// ύXl

	// ֐
	void	(*add)(WEATHER_SYS_WORK* pWork, int num);		// OBJo^
} WEATHER_SYS_OBJ_FADE;
typedef void (*OBJADD_FUNC)(WEATHER_SYS_WORK* pWork, int num);// OBJo^

//-------------------------------------
//	tHOtF[hf[^
//-------------------------------------
typedef struct{
	FOG_DATA_PTR	Fog;		// tF[htHOf[^
	char			fog_tbl[32];// tHOe[u

	// JE^
	s32	fogDepth;		// tHO[x
	s32	fogCount;		// tHOJE^

	// 萔
	s32	FOG_CHG_TMG;		// tHOe[uύX^C~O
	s32	FOG_TBL_SUM;		// ύXl
} WEATHER_SYS_FOG_FADE;


//-------------------------------------
//	VXe[Nf[^
//-------------------------------------
// Normal
typedef struct{
	WEATHER_SYS_OBJ_FADE	objFade;
	WEATHER_SYS_FOG_FADE	fogFade;
	s32	work[10];
} WEATHER_SYSW_NORMAL;

// IuWFtF[ĥ
typedef struct{
	WEATHER_SYS_OBJ_FADE	objFade;
	s32	work[10];
} WEATHER_SYSW_OBJFADE;

// tHOtF[ĥ
typedef struct{
	WEATHER_SYS_FOG_FADE	fogFade;
	s32	work[10];
} WEATHER_STSW_FOGFADE;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
//-------------------------------------
//	̑vCx[g֐
//=====================================
static void load2DGraphicFile(WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell);	// G̃f[^̓ǂݍ
static void setUpBG( WEATHER_SYS_CONTROL* cont, int BGNo );
static void destGraphicFile(WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell);	// G̃f[^̔j

static CLACT_U_RES_OBJ_PTR	loadRes(CLACT_U_RES_HEADER_PTR res_head, int res_type, int head_no, CLACT_U_RES_MANAGER_PTR resMan, ARCHANDLE* arcHandle);

static void init2DDrawSys(WEATHER_SYS_DRAWSYS* draw);
static void loadResHeader(CLACT_U_RES_HEADER_PTR head, int no, int arc_data);
static void delete2DDrawSys(WEATHER_SYS_DRAWSYS* draw);

//	VCf[^֐
static void setSysData(WEATHER_SYS_DATA* pData, int CellNo, int BGNo, int WorkSize, TCB_FUNC func);
static void setBGData(WEATHER_BG_DATA* pData, int pltt_arc, int char_arc, int screen_arc );

// Wݒp֐
static void setClactMatrix( CLACT_WORK_PTR act, VecFx32* matrix );

//-------------------------------------
//	VCǗ֐p֐
//=====================================
static void destObj(WAETHER_OBJ_DATA* pData);							// IuWF̔j
static void destObjAll(WAETHER_OBJ_DATA* pDummy);						// SIuWF̔j
static WAETHER_OBJ_DATA* addObj(WEATHER_SYS_WORK* pWork, int w_byte);	// IuWFAbh
static void getHeader(CLACT_HEADER_PTR head, WEATHER_SYS_CONTROL* cont, WATHER_GRAPHIC_FILE_DATA* pcell,int vram_trans, int priority );
static BOOL setUpCell( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys );
static void moveFuncObj(WAETHER_OBJ_DATA* pDummy, objFunc pFunc);		// SIuWFNg𓮂
static void drawObj(WEATHER_SYS_WORK* pData);							// IuWF̕`
static VecFx32 getObjMat( WAETHER_OBJ_DATA* obj );
static int getMaxOamNum(NNSG2dCellDataBank* pCell);						// Zf[^oÑZOAM̍ő吔擾
static void getScrollNum(fx32* x, fx32* y, WEATHER_SYS_WORK* pWork);		// XN[W擾
static void scrollObj(WEATHER_SYS_WORK* pWork, int* x, int* y);			// SIuWFNg̍Wscrollɂ킹
static void allocObjWork(WAETHER_OBJ_DATA* pData, int byte);			// [N̈쐬
static void freeObjWork(WAETHER_OBJ_DATA* pData);						// [N̈j
static int weatherSysObjFade(WEATHER_SYS_OBJ_FADE* data);				// IuWFNgtF[h
static int weatherSysFogFade(WEATHER_SYS_FOG_FADE* data);				// tHOtF[h
static int weatherSysFogFadeNoReflect(WEATHER_SYS_FOG_FADE* data);		// tHOtF[h@tHOe[u̔fsȂo[W
static void weatherSysFogSet(WEATHER_SYS_FOG_FADE* data);				// tHOtF[hC̃e[u쐬
static void calcWeatherFogTbl( WEATHER_SYS_FOG_FADE* data );			// tHOe[u쐬vZs
//static BOOL weatherBGFade( s32* now_alpha, const int end_alpha, const int add_alpha, s32* timing_count, const int add_timing );
static void weatherDustObj( WEATHER_SYS_WORK* pWork, OBJADD_FUNC add_func, int num, int dust_div_num, int dust_div_move, objFunc move_func );	// VC̃IuWFNgUz
static WAETHER_OBJ_DATA* getCleanObjData( WEATHER_SYS_WORK* pWork );


//-------------------------------------
//	VCǗ֐֐
//=====================================
static BOOL initWeatherSys(WEATHER_SYS_CONTROL* cont,int no);				// Ǘ֐
static BOOL divInitWeatherSysCall(WEATHER_SYS_CONTROL* cont,int no);
static BOOL startWeatherSys(WEATHER_SYS_CONTROL* cont,int no, int init_seq);// Ǘ֐X^[g
static void stopReqWeatherSys(WEATHER_SYS_CONTROL* cont,int no);				// Ǘ֐I
static void stopWeatherSys( WEATHER_SYS_CONTROL* cont,int no );				// I
static void destWeatherSys(WEATHER_SYS_CONTROL* cont,int no);				// Ǘ֐Sj
static void stopWeatherWork(WEATHER_SYS_CONTROL* cont,int no);				// Ǘf[^j

// ֐
static void divInitWeatherSysTcb( TCB_PTR tcb, void* work );
static BOOL initWeatherSysWork( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys );

static void initClactSet( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys );
static BOOL initCellDataMemory( WEATHER_SYS_DATA* w_sys );
static void loadCell_CellData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell );
static void loadCell_CellAnmData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell );
static void loadCell_CharData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell );
static void loadCell_PlttData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell );
static void initClactAddData( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys );

static void initBgPltt( WEATHER_SYS_CONTROL* cont, int BGNo );
static void initBgChar( WEATHER_SYS_CONTROL* cont, int BGNo );
static void initBgScr( WEATHER_SYS_CONTROL* cont, int BGNo );

//-------------------------------------
//	VCǗ֐
//=====================================
static void contWeatherRain(TCB_PTR tcb, void* work);		// J
static void contWeatherSnow(TCB_PTR tcb, void* work);		// 
static void contWeatherSnowStorm(TCB_PTR tcb, void* work);	// 
static void contWeatherSnowStormBG(TCB_PTR tcb, void* work);// BGgp
static void contWeatherFog00(TCB_PTR tcb, void* work);		// 
static void contWeatherFog01(TCB_PTR tcb, void* work);		// 
static void contWeatherFog02(TCB_PTR tcb, void* work);		// 
static void contWeatherStorm(TCB_PTR tcb, void* work);		// 
static void contWeatherStormBG(TCB_PTR tcb, void* work);	// BGgp
static void contWeatherSnowSML(TCB_PTR tcb, void* work);	// kC
static void contWeatherSnowD(TCB_PTR tcb, void* work);		// Xm[_Xg
static void contWeatherRainbow(TCB_PTR tcb, void* work);	// 
static void contWeatherSTRain(TCB_PTR tcb, void* work);		// J
static void contWeatherVolcano(TCB_PTR tcb, void* work);	// ΎRD
static void contWeatherSpark(TCB_PTR tcb, void* work);		// 
static void contWeatherSpirit(TCB_PTR tcb, void* work);		// C
static void contWeatherMystic(TCB_PTR tcb, void* work);		// _


//-------------------------------------
//	VCIuWFNgo^֐
//=====================================
static void addWeatherRain(WEATHER_SYS_WORK* pWork, int num);		// J
static void addWeatherSnow(WEATHER_SYS_WORK* pWork, int num);		// 
static void addWeatherSnowStorm(WEATHER_SYS_WORK* pWork, int num);	// 
static void addWeatherStorm(WEATHER_SYS_WORK* pWork, int num);		// 
static void addWeatherSnowSML(WEATHER_SYS_WORK* pWork, int num);	// kC
static void addWeatherSnowD(WEATHER_SYS_WORK* pWork, int num);		// Xm[_Xg
static void addWeatherSTRain(WEATHER_SYS_WORK* pWork, int num);		// J
static void addWeatherVolcano(WEATHER_SYS_WORK* pWork, int num);	// ΎRD
static void addWeatherSpirit(WEATHER_SYS_WORK* pWork, int num);		// C
static void addWeatherMystic(WEATHER_SYS_WORK* pWork, int num);		// _

//-------------------------------------
//	VC̃IuWF֐
//=====================================
static void objWeatherRain(WAETHER_OBJ_DATA* work);			// J̗
static void objWeatherSnow(WAETHER_OBJ_DATA* work);			// ̗
static void objWeatherSnowStorm(WAETHER_OBJ_DATA* work);	// ̗
static void objWeatherStorm(WAETHER_OBJ_DATA* work);		// 
static void objWeatherSnowSML(WAETHER_OBJ_DATA* work);		// kC
static void objWeatherSnowD(WAETHER_OBJ_DATA* work);		// Xm[_Xg
static void objWeatherSTRain(WAETHER_OBJ_DATA* work);		// J
static void objWeatherVolcano(WAETHER_OBJ_DATA* work);		// ΎRD
static void objWeatherSpirit(WAETHER_OBJ_DATA* work);		// C
static void objWeatherMystic(WAETHER_OBJ_DATA* work);		// _


//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	`VXȅ
 *
 *@param	draw	`VXe
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void init2DDrawSys(WEATHER_SYS_DRAWSYS* draw)
{
	NNSG2dViewRect rect;		// T[tF[X`
	int i;						// [vp
	int size;					// wb_TCY擾p
	
	// _
	RNDP_InitRenderer(&draw->Render, -FX32_ONE);

	// T[tF[X
	rect.posTopLeft.x	= WEATHER_RENDER_X;
	rect.posTopLeft.y	= WEATHER_RENDER_Y;
	rect.sizeView.x		= WEATHER_RENDER_WIDTH;
	rect.sizeView.y		= WEATHER_RENDER_HEIGHT;
	REND_OAM_SetSurface(&draw->Surface, &rect, NNS_G2D_SURFACETYPE_MAIN2D, &draw->Render);

	// \[X}l[W쐬
	for(i=0;i<WEATHER_RES_NUM;i++){
		draw->resMan[i] = CLACT_U_ResManagerInit(WEATHER_SYS_NUM, i, HEAPID_FIELD);
	}

	// \[X}l[Wwb_쐬
	size = CLACT_U_ResManagerGetHeaderSize();
	draw->resHeader = sys_AllocMemory(HEAPID_FIELD, size * WEATHER_RES_NUM);
	
	// \[Xwb_[ǂݍ
	loadResHeader(draw->resHeader, CLACT_U_CHAR_RES, NARC_WEATHER_SYS_WEATHER_CHAR_RESDAT );
	loadResHeader(draw->resHeader, CLACT_U_PLTT_RES, NARC_WEATHER_SYS_WEATHER_PLTT_RESDAT);
	loadResHeader(draw->resHeader, CLACT_U_CELL_RES, NARC_WEATHER_SYS_WEATHER_CELL_RESDAT);
	loadResHeader(draw->resHeader, CLACT_U_CELLANM_RES, NARC_WEATHER_SYS_WEATHER_CELLANM_RESDAT);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xwb_Pǂݍ
 *
 *@param	head		wb_f[^z
 *@param	no			ǂݍރwb_zvf
 *@param	arc_data	A[JCut@Cf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadResHeader(CLACT_U_RES_HEADER_PTR head, int no, int arc_data)
{
	CLACT_U_RES_HEADER_PTR	w_head;		// Ɨpwb_
	void* file;

	w_head = CLACT_U_ResManagerGetHeaderNoData(head, no);
//	CLACT_U_ResManagerHeaderLoad(path, w_head, HEAPID_FIELD);
	file = ArcUtil_Load( ARC_WEATHER_SYS_GRA, arc_data, FALSE, HEAPID_FIELD, ALLOC_BOTTOM );
	CLACT_U_ResManagerHeaderLoadBinary( file, w_head, HEAPID_FIELD );
	sys_FreeMemoryEz( file );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	`VXef[^j
 *
 *@param	draw	`VXef[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delete2DDrawSys(WEATHER_SYS_DRAWSYS* draw)
{
	int i;
	CLACT_U_RES_HEADER_PTR	res_head;
	

	// \[Xwb_j
	// \[X}l[Wj
	for(i=0;i < WEATHER_RES_NUM;i++){
		res_head = CLACT_U_ResManagerGetHeaderNoData(draw->resHeader, i);
		CLACT_U_ResManagerHeaderFree(res_head);		// wb_j

		CLACT_U_ResManagerDelete(draw->resMan[i]);	// }l[Wj
	}
	sys_FreeMemoryEz(draw->resHeader);
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCf[^֐
 *
 *	@param	pData		ݒ
 *	@param	CellNo		Zf[^̔zvf
 *	@param	BGNo		BGf[^̔zvf
 *	@param	WorkSize	[NTCY
 *	@param	func		Rg[֐
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setSysData(WEATHER_SYS_DATA* pData, int CellNo, int BGNo, int WorkSize, TCB_FUNC func)
{
	pData->GraphicNo	= CellNo;		// ZNo
	pData->BGNo			= BGNo;			// BGNo
	pData->WorkByte		= WorkSize;		// VCVXe[NTCY
	pData->pWork		= NULL;			// VXe[N
	pData->pCell		= NULL;			// ǂݍ񂾃Zf[^
	pData->cont			= func;			// CONTROL֐
	pData->MoveFlag		= WEATHER_SYS_MOVE_NONE;	// 
	pData->DivInitSeq	= 0;			// V[PX
	pData->DivInitTcb	= NULL;			// ǂݍTCB
}
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^ݒ֐
 *
 *	@param	pData			f[^i[
 *	@param	PlttPath		pbgpX
 *	@param	CharPath		LN^pX
 *	@param	ScreenPath		XN[f[^pX
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setBGData(WEATHER_BG_DATA* pData, int pltt_arc, int char_arc, int screen_arc )
{
	pData->pltt_arc = pltt_arc;
	pData->char_arc = char_arc;
	pData->screen_arc = screen_arc;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[ɍWݒ
 *
 *	@param	act			AN^[
 *	@param	matrix		W
 *
 *	@return	none
 *
 * T[tF[X̍WŐ܂Ԃ悤ɕ␳sĂ
 * o^Ă܂B
 *
 */
//-----------------------------------------------------------------------------
static void setClactMatrix( CLACT_WORK_PTR act, VecFx32* matrix )
{
	// ܂Ԃ
	if(matrix->x > WEATHER_OBJ_MAXTURN_X){
		matrix->x %= WEATHER_OBJ_MAXTURN_X;
	}else{

		if( matrix->x < WEATHER_OBJ_MINTURN_X ){	
			matrix->x += WEATHER_OBJ_MAXTURN_X;
		}
	}

	if(matrix->y > WEATHER_OBJ_MAXTURN_Y){
		matrix->y %= WEATHER_OBJ_MAXTURN_Y;
	}else{

		if( matrix->y < WEATHER_OBJ_MINTURN_Y ){	
			matrix->y += WEATHER_OBJ_MAXTURN_Y;
		}
	}

	
	CLACT_SetMatrix( act, matrix );
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	VCVXe
 *
 *@param	fsys		tB[hVXe[N
 *
 *@return	WEATHER_CONT_PTR	VCVXef[^
 *
 *	e
 *		VCVXe̐f[^쐬
 *		fast_cellVXeOAMobt@쐬
 *		LN^ApbgENTRYf[^ǂݍ
 *
 */
//-----------------------------------------------------------------------------
WEATHER_CONT_PTR InitWeatherSys(FIELDSYS_WORK* fsys)
{
	WEATHER_CONT_PTR pWSYSCONT;

	pWSYSCONT = sys_AllocMemory( HEAPID_FIELD, sizeof(WEATHER_SYS_CONTROL) );
	// tHOf[^i[ۑ
	pWSYSCONT->fsys = fsys;

	// `VXe
	init2DDrawSys(&pWSYSCONT->Draw);

	
	// VCVXef[^쐬
	pWSYSCONT->pWSD  = sys_AllocMemory(HEAPID_FIELD,sizeof(WEATHER_SYS_DATA)*WEATHER_SYS_NUM);
	pWSYSCONT->pWSBG = sys_AllocMemory(HEAPID_FIELD,sizeof(WEATHER_BG_DATA)*5);

	// f[^
	// VCVXef[^
	{
		// J
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_RAIN ], WEATHER_RAIN_GRAPHIC_CELL, WEATHER_RAIN_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherRain );
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SNOW ], WEATHER_SNOW_GRAPHIC_CELL, WEATHER_SNOW_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherSnow );	
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SNOW_STORM ], WEATHER_SSNOW_GRAPHIC_CELL, WEATHER_SSNOW_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherSnowStorm );	
		// BG
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SNOW_STORM_BG ], WEATHER_SSNOW_BG_GRAPHIC_CELL, WEATHER_SSNOW_BG_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherSnowStormBG );	
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_FOGS ], WEATHER_GRAPHIC_NONE, WEATHER_GRAPHIC_NONE, sizeof(WEATHER_STSW_FOGFADE), contWeatherFog00 );	
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_FOGM ], WEATHER_GRAPHIC_NONE, WEATHER_GRAPHIC_NONE, sizeof(WEATHER_STSW_FOGFADE), contWeatherFog01 );	
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_FOGL ], WEATHER_GRAPHIC_NONE, WEATHER_GRAPHIC_NONE, sizeof(WEATHER_STSW_FOGFADE), contWeatherFog02 );	
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_STORM ], WEATHER_STORM_GRAPHIC_CELL, WEATHER_STORM_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherStorm );	
		// BG
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_STORM_BG ], WEATHER_STORMBG_GRAPHIC_CELL, WEATHER_STORMBG_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherStormBG );
		// Ґ
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SNOW_SML ], WEATHER_SNOW_S_GRAPHIC_CELL, WEATHER_SNOW_S_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherSnowSML );
		// Xm[_Xg
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SNOW_D ], WEATHER_SNOW_D_GRAPHIC_CELL, WEATHER_SNOW_D_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherSnowD );
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_RAINBOW ], WEATHER_RAINBOW_GRAPHIC_CELL, WEATHER_RAINBOW_GRAPHIC_BG, WEATHER_RAINBOW_WORK_SIZE, contWeatherRainbow );
		// J
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_STRAIN ], WEATHER_STRAIN_GRAPHIC_CELL, WEATHER_STRAIN_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherSTRain );
		// ΎRD
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_VOLCANO ], WEATHER_VOLCANO_GRAPHIC_CELL, WEATHER_VOLCANO_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherVolcano );
		// 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SPARK ], WEATHER_SPARK_GRAPHIC_CELL, WEATHER_SPARK_GRAPHIC_BG, WEATHER_SPARK_WORK_SIZE, contWeatherSpark );
		// C
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_SPIRIT ], WEATHER_SPIRIT_GRAPHIC_CELL, WEATHER_SPIRIT_GRAPHIC_BG, sizeof(WEATHER_SYSW_OBJFADE), contWeatherSpirit );
		// _ 
		setSysData( &pWSYSCONT->pWSD[ WEATHER_SYS_MYSTIC ], WEATHER_MYSTIC_GRAPHIC_CELL, WEATHER_MYSTIC_GRAPHIC_BG, sizeof(WEATHER_SYSW_NORMAL), contWeatherMystic );
	}

	// BGf[^
	{
		// 
		setBGData(&pWSYSCONT->pWSBG[0], NARC_WEATHER_SYS_SNOW_NCLR, NARC_WEATHER_SYS_STORM_BG_NCGR, NARC_WEATHER_SYS_STORM_SC_NSCR);
		// 
		setBGData(&pWSYSCONT->pWSBG[1], NARC_WEATHER_SYS_STORM_BG_NCLR, NARC_WEATHER_SYS_STORM_BG_NCGR, NARC_WEATHER_SYS_STORM_SC_NSCR);
		// 
		setBGData(&pWSYSCONT->pWSBG[2], NARC_WEATHER_SYS_RAINBOW_NCLR, NARC_WEATHER_SYS_RAINBOW_NCGR, NARC_WEATHER_SYS_RAINBOW_SC_NSCR);
		// ΎRD
		setBGData(&pWSYSCONT->pWSBG[3], NARC_WEATHER_SYS_VOLCANO_NCLR, NARC_WEATHER_SYS_VOLCANO_BG_NCGR, NARC_WEATHER_SYS_VOLCANO_NSCR);
		// 
		setBGData(&pWSYSCONT->pWSBG[4], NARC_WEATHER_SYS_SPARK_NCLR, NARC_WEATHER_SYS_SPARK_NCGR, NARC_WEATHER_SYS_SPARK_NSCR);
	}

	// A[JCut@CnhI[v
	 pWSYSCONT->ArcHandle = ArchiveDataHandleOpen( ARC_WEATHER_SYS_GRA, HEAPID_FIELD );
	
	

	return pWSYSCONT;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VCVXej
 *
 *@param	pWes		VCf[^|C^
 *
 *@return	none
 *
 *	e
 *		삵ĂVCǗ֐^XN̋I---ĂIuWFNg^XNI
 *		LN^ApbgENTRYf[^j
 *
 */
//-----------------------------------------------------------------------------
void DestWeatherSys(WEATHER_CONT_PTR* pWes)
{
	int i;		// [vp
	
	if(*pWes != NULL){
		
		// 삵ĂVCǗ^XN̋I
		for(i=0;i<WEATHER_SYS_NUM;i++){
			destWeatherSys(*pWes, i);
		}
		
		SetFogData((*pWes)->fsys->fog_data, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		
		G2_SetBG0Priority(1);
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );

		// VXef[^j
		sys_FreeMemory(HEAPID_FIELD,(*pWes)->pWSD);
		sys_FreeMemory(HEAPID_FIELD,(*pWes)->pWSBG);

		// OtBbN`VXej
		delete2DDrawSys(&(*pWes)->Draw);

		// A[JCut@Cnhj
		ArchiveDataHandleClose( (*pWes)->ArcHandle );
		
		// Ǘf[^j
		sys_FreeMemory(HEAPID_FIELD,*pWes);
		*pWes = NULL;
	}
} 

//----------------------------------------------------------------------------
/**
 *
 *@brief	VCVXeRg[֐
 *
 *@param	Wes			VCf[^
 *@param	cont		Rg[io[
 *@param	no			VCio[
 *
 *@return	BOOL	:TRUE	s:FALSE
 *
 *	
 *		cont
 *			WEATHER_SYS_START=0				// Jn
 *			WEATHER_SYS_END=1				// I(tF[hďI)
 *			WEATHER_SYS_COMPULSION_END=2	// I
 *		
 *		cont̃io[ɂ肨VCǗ^XN𑀍삷
 * 
 */
//-----------------------------------------------------------------------------
BOOL ControlWeatherSys(WEATHER_CONT_PTR Wes, int cont, int no)
{
	BOOL ret = TRUE;

	// VCio[`FbN
	if( no > WEATHER_SYS_SUNNY ){
		return FALSE;
	}
	
	// ̂ƂTRUEԂ
	if( no == WEATHER_SYS_SUNNY ){
		return TRUE;
	}
	
	switch(cont){
	case WEATHER_SYS_INIT:		// VCǗ^XN
		ret = initWeatherSys(Wes, no);
		break;
	case WEATHER_SYS_INIT_DIV:	// VC^XNo^
		ret = divInitWeatherSysCall( Wes, no );
		break;
	case WEATHER_SYS_START:		// VCǗ^XNo^
		ret = startWeatherSys(Wes, no, WEATHER_SEQ_INIT);
		break;

	case WEATHER_SYS_START_NOFADE:	// tF[hC΂
		ret = startWeatherSys( Wes, no, WEATHER_SEQ_NO_FADE );
		break;

	case WEATHER_SYS_END:		// VCǗ^XNI
		stopReqWeatherSys(Wes, no);
		break;

	case WEATHER_SYS_END_NOFADE:// tF[hAEgȂI
		stopWeatherSys(Wes, no);
		break;

	case WEATHER_SYS_DEST:		// VCǗ^XNj
		destWeatherSys(Wes, no);
		break;

	default:
		break;
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCIĂԂ`FbN
 *
 *	@param	Wes			VC
 *	@param	no			VCio[
 *
 *	@retval	WEATHER_SYS_MOVE_NONE   	
 *	@retval	WEATHER_SYS_MOVE_INIT		
 *  @retval WEATHER_SYS_MOVE_READY		Jnҋ@
 *  @retval WEATHER_SYS_MOVE_DO			쒆
 */
//-----------------------------------------------------------------------------
int CheckMoveWeatherSys(WEATHER_CONT_PTR Wes, int no)
{
	WEATHER_SYS_DATA* w_sys;

	// VCio[`FbN
	if(no >= WEATHER_SYS_NUM){
		return WEATHER_SYS_MOVE_NONE;
	}
	
	w_sys = Wes->pWSD+no;

	// VĈ邩`FbN
	return w_sys->MoveFlag;
}


//-----------------------------------------------------------------------------
//	vCx[g֐
//		̑
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	OtBbNf[^ǂݍ
 *
 *@param	cont			VCRg[
 *@param	GraphicNo		ZpXf[^
 *@param	pCell			i[
 *
 *@return	none
 *
 *	e
 *		GraphicNo̊G̃f[^ǂݍ
 *		pCell̃oɊi[
 *
 */
//-----------------------------------------------------------------------------
static void load2DGraphicFile(WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell)
{
	// Zǂݍ
	loadCell_CellData( cont, GraphicNo, pCell );

	// ZAjǂݍ
	loadCell_CellAnmData( cont, GraphicNo, pCell );

	// LN^ǂݍ
	loadCell_CharData( cont, GraphicNo, pCell );

	// pbgǂݍ
	loadCell_PlttData( cont, GraphicNo, pCell );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X}l[Wɓo^
 *	
 *@param	res_head	\[Xwb_
 *@param	res_type	\[X^Cv
 *@param	head_no		wb_io[
 *@param	resMan		\[X}l[W
 *@param	arcHandle	A[JCut@Cnh
 *
 *@return	CLACT_U_RES_OBJ_PTR		ǂݍ܂ꂽ\[X
 *
 *
 */
//-----------------------------------------------------------------------------
static CLACT_U_RES_OBJ_PTR	loadRes(CLACT_U_RES_HEADER_PTR res_head, int res_type, int head_no, CLACT_U_RES_MANAGER_PTR resMan, ARCHANDLE* arcHandle)
{
	CLACT_U_RES_HEADER_PTR	w_head;	// Ɨpwb_
	CLACT_U_RES_OBJ_PTR		res_obj;
	int data_idx;
	BOOL comp_flg;
	int vram_type;
	int pltt_num;
	int data_id;

	// \[X̃wb_擾
	w_head = CLACT_U_ResManagerGetHeaderNoData(res_head, res_type);

	// wb_[f[^擾
	data_idx	= CLACT_U_ResManagerHeaderDataIdxGet( w_head, head_no );
	comp_flg	= CLACT_U_ResManagerHeaderCompFlagGet( w_head, head_no );
	vram_type	= CLACT_U_ResManagerHeaderVramTypeGet( w_head, head_no );
	pltt_num	= CLACT_U_ResManagerHeaderPlttNumGet( w_head, head_no );
	data_id		= CLACT_U_ResManagerHeaderDataIDGet( w_head, head_no );

	switch( res_type ){
	case CLACT_U_CHAR_RES:		// LN^\[XǗ
		res_obj = CLACT_U_ResManagerResAddArcChar_ArcHandle( resMan, arcHandle, data_idx, comp_flg, data_id, vram_type, HEAPID_FIELD );
		break;
		
	case CLACT_U_PLTT_RES:		// pbg\[XǗ
		res_obj = CLACT_U_ResManagerResAddArcPltt_ArcHandle( resMan, arcHandle, data_idx, comp_flg, data_id, vram_type, pltt_num, HEAPID_FIELD );
		break;
		
	case CLACT_U_CELL_RES:		// Z\[XǗ
		res_obj = CLACT_U_ResManagerResAddArcKindCell_ArcHandle( resMan, arcHandle, data_idx, comp_flg, data_id, CLACT_U_CELL_RES, HEAPID_FIELD );
		break;
		
	case CLACT_U_CELLANM_RES:	// ZAj\[XǗ
		res_obj = CLACT_U_ResManagerResAddArcKindCell_ArcHandle( resMan, arcHandle, data_idx, comp_flg, data_id, CLACT_U_CELLANM_RES, HEAPID_FIELD );
		break;
	}
	
	// \[Xǂݍ
	return res_obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	OtBbNf[^j
 *
 *@param	cont			VCRg[
 *@param	GraphicNo		OtBbNio[
 *@param	pCell			OtBbNf[^i[ʒu
 *
 *@return	none
 *
 *	e
 *		GraphicNo̊G̃f[^j
 *
 */
//-----------------------------------------------------------------------------
static void destGraphicFile(WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell)
{
	int i;	

	if(GraphicNo != WEATHER_GRAPHIC_NONE){
		// LN^f[^j
		if( pCell->res_obj[ CLACT_U_CHAR_RES ] ){
			CLACT_U_CharManagerDelete(pCell->res_obj[ CLACT_U_CHAR_RES ]);
		}

		// pbgf[^j
		if( pCell->res_obj[ CLACT_U_PLTT_RES ] ){
			CLACT_U_PlttManagerDelete(pCell->res_obj[ CLACT_U_PLTT_RES ]);
		}

		// \[Xj
		for(i=0;i<WEATHER_RES_NUM;i++){
			if( pCell->res_obj[ i ] ){
				CLACT_U_ResManagerResDelete(cont->Draw.resMan[ i ], pCell->res_obj[ i ]);
			}
		}
	}
}


//-----------------------------------------------------------------------------
//	vCx[g֐
//		VCǗ^XNO瑀삷֐S
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	VCǗ^XN
 *
 *
 *@param	cont	VCRg[
 *@param	no		VCio[
 *
 *@return	BOOL	:TRUE	s:FALSE
 *
 *	e
 *		OtBbNt@C̓ǂݍݏ
 *
 */
//-----------------------------------------------------------------------------
static BOOL initWeatherSys(WEATHER_SYS_CONTROL* cont,int no)
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;
	BOOL ret;
	
	
	// 쐬Ă邩`FbN
	if(w_sys->pWork == NULL){
		// [N̍쐬
		ret = initWeatherSysWork( cont, w_sys );
		if( ret == FALSE ){
			return FALSE;
		}
	
		// ZAN^[gpłԂɂ
		ret = setUpCell( cont, w_sys );
		if( ret == FALSE ){
			sys_FreeMemoryEz( w_sys->pWork );
			w_sys->pWork = NULL;
			return FALSE;
		}
		w_sys->pWork->pCell = w_sys->pCell;		// Zf[^Rs[

		// BGZbgAbv
		setUpBG( cont, w_sys->BGNo );

		w_sys->MoveFlag = WEATHER_SYS_MOVE_READY;	// Jnҋ@
	}


	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VCǗ^XNhh^XNR[
 *
 *
 *@param	cont	VCRg[
 *@param	no		VCio[
 *
 *@return	BOOL	:TRUE	s:FALSE
 *
 *	e
 *		OtBbNt@C̓ǂݍݏ
 *
 */
//-----------------------------------------------------------------------------
static BOOL divInitWeatherSysCall(WEATHER_SYS_CONTROL* cont,int no)
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;
	
	// 쐬ς݂`FbN
	if( w_sys->pWork ){
		return TRUE;
	}

	// [N쐬
	if( initWeatherSysWork( cont, w_sys ) == FALSE ){
		return FALSE;
	}

	// ^XNo^
	w_sys->DivInitTcb = TCB_Add( divInitWeatherSysTcb, w_sys, WEATHER_TCB_DIV_LOAD_PRI );

	// ɂ
	w_sys->MoveFlag		= WEATHER_SYS_MOVE_INIT;

	// V[PX
	w_sys->DivInitSeq	= 0;
	

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VCǗ^XNJn
 *
 *@param	cont		VCRg[
 *@param	no			VCio[
 *@param	init_seq	V[PXl
 *
 *@return	BOOL	:TRUE	s:FALSE
 *
 *	e
 *		io[̂VCǗ^XNJn܂B
 *
 */
//-----------------------------------------------------------------------------
static BOOL startWeatherSys(WEATHER_SYS_CONTROL* cont,int no, int init_seq)
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;
	
	// Gǂݍ܂Ă邩`FbN
	if(w_sys->GraphicNo != WEATHER_GRAPHIC_NONE){
		if(w_sys->pCell == NULL){
			return FALSE;
		}
	}

	// ^XN[N쐬Ă邩`FbN
	if(w_sys->pWork == NULL){
		return FALSE;
	}

	// Jn҂Ԃ`FbN
	if(w_sys->MoveFlag != WEATHER_SYS_MOVE_READY){
		return FALSE;
	}

	// ^XNo^
	w_sys->pWork->tcb = TCB_Add(w_sys->cont, w_sys->pWork, WEATHER_CONTROL_PRI);

	// ^XNo^ɐ`FbN
	if(w_sys->pWork->tcb == NULL){
		return FALSE;
	}

	// s
	w_sys->MoveFlag = WEATHER_SYS_MOVE_DO;
	
	// f[^ݒ
	w_sys->pWork->Sequence = init_seq;		// ƃV[PX
	w_sys->pWork->ContFlag = 0;				// ORg[tO
	w_sys->pWork->Dummy.pNext = &w_sys->pWork->Dummy;
	w_sys->pWork->Dummy.pPrev = &w_sys->pWork->Dummy;

	w_sys->pWork->CameraTarget = *(NNS_G3dGlbGetCameraTarget());
	if(w_sys->WorkByte > 0){
		w_sys->pWork->work = sys_AllocMemory(HEAPID_FIELD, w_sys->WorkByte);	// [N̈
	}

	// BGZbgAbv
	if(w_sys->BGNo != WEATHER_GRAPHIC_NONE){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		G2_SetBG2Priority(1);
		G2_SetBG0Priority(2);
//		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VCǗ^XNI	tF[hAEgĂI
 *
 *@param	cont	VCRg[
 *@param	no		VCio[
 *
 *@return	none
 *
 *	e
 *		io[̂VCǗ^XNtF[hAEgI܂
 *		*F񂾂J~ŏIȂ
 *
 */
//-----------------------------------------------------------------------------
static void stopReqWeatherSys(WEATHER_SYS_CONTROL* cont,int no)
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;

	// VCǗ^XNĂ邩`FbN
	if(w_sys->MoveFlag == WEATHER_SYS_MOVE_DO){
		w_sys->pWork->ContFlag = WEATHER_SYS_END;	// ItO𗧂Ă
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VCI	tF[hAEgȂ
 *
 *	@param	cont	VCRg[
 *	@param	no		VCio[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void stopWeatherSys( WEATHER_SYS_CONTROL* cont,int no )
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;
	
	if( CheckMoveWeatherSys( cont, no ) == WEATHER_SYS_MOVE_DO ){
		// VC̃V[PXWEATHER_SEQ_DESTɂăRg[֐R[
		w_sys->pWork->Sequence = WEATHER_SEQ_DEST;
	
		w_sys->cont( NULL, w_sys->pWork );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VCǗ^XNI
 *
 *@param	cont	VCRg[
 *@param	no		VCio[
 *
 *@return	none
 *
 *	e
 *		ǗĂIuWFSĔj
 *		G̃f[^j
 *		j
 *
 */
//-----------------------------------------------------------------------------
static void destWeatherSys(WEATHER_SYS_CONTROL* cont,int no)
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;
	
	// BGʂ̕\OFF
	if(w_sys->BGNo != WEATHER_GRAPHIC_NONE ){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		G2_SetBG2Priority(3);
		G2_SetBG0Priority(1);
	}
	
	// G̃f[^j
	if(w_sys->pCell != NULL){
		// G̃f[^j
		destGraphicFile(cont, w_sys->GraphicNo, w_sys->pCell);
		sys_FreeMemory(HEAPID_FIELD, w_sys->pCell);
		w_sys->pCell = NULL;
	}
	
	// VCǗ^XNĂ邩`FbN
	if(w_sys->pWork != NULL){
		// ǗĂIuWFj
		destObjAll(&w_sys->pWork->Dummy);

		// [N̈
		if(w_sys->pWork->work != NULL){
			sys_FreeMemory(HEAPID_FIELD, w_sys->pWork->work);
			w_sys->pWork->work = NULL;
		}

		// AN^[Zbgj
		if( w_sys->pWork->clactSet ){
			CLACT_DestSet(w_sys->pWork->clactSet);
		}

		// ^XNj
		if( w_sys->MoveFlag == WEATHER_SYS_MOVE_INIT ){
			
			if( w_sys->DivInitTcb ){
				TCB_Delete(w_sys->DivInitTcb);					// TCBj
			}
		}else{
			
			// ^XNj
			if(w_sys->MoveFlag == WEATHER_SYS_MOVE_DO){
				
				TCB_Delete(w_sys->pWork->tcb);					// TCBj
			}
		}
		sys_FreeMemory(HEAPID_FIELD, w_sys->pWork);	// [Nj
		w_sys->pWork = NULL;
	}
}


// VXeTu֐
//----------------------------------------------------------------------------
/**
 *
 *	@brief	no̓VC̓VCVXef[^j
 *
 *	@param	cont		VCVXe
 *	@param	no			VCno
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void stopWeatherWork(WEATHER_SYS_CONTROL* cont,int no)
{
	WEATHER_SYS_DATA* w_sys = cont->pWSD+no;
	
	// BGʂ̕\OFF
	if(w_sys->BGNo != WEATHER_GRAPHIC_NONE ){
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		G2_SetBG2Priority(3);
		G2_SetBG0Priority(1);
	}

	// VCǗ^XNĂ邩`FbN
	if(w_sys->pWork != NULL){
		// ǗĂIuWFj
		destObjAll(&w_sys->pWork->Dummy);
		
		// ^XNj
		if(w_sys->MoveFlag == WEATHER_SYS_MOVE_DO){
			
			TCB_Delete(w_sys->pWork->tcb);					// TCBj
			w_sys->MoveFlag = WEATHER_SYS_MOVE_READY;
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGf[^ZbgAbv
 *
 *	@param	cont	VCRg[f[^
 *	@param	BGNo	BGio[
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setUpBG( WEATHER_SYS_CONTROL* cont, int BGNo )
{
	// pbgǂݍ
	initBgPltt( cont, BGNo );
	
	// LN^ǂݍ
	initBgChar( cont, BGNo );

	// XN[f[^
	initBgScr( cont, BGNo );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[gpłԂɂ
 *
 *	@param	cont		Rg[f[^
 *	@param	w_sys		f[^S
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL setUpCell( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys )
{
	BOOL ret;

	// Zf[^Kv`FbN
	if( w_sys->GraphicNo  != WEATHER_GRAPHIC_NONE ){
		
		// ZAN^[Zbg
		initClactSet( cont, w_sys );

		// Zf[^쐬ς݂`FbN
		if( w_sys->pCell == NULL ){

			// Zf[^i[m
			ret = initCellDataMemory( w_sys );
			if( ret == FALSE ){
				// AN^[Zbgj
				CLACT_DestSet(w_sys->pWork->clactSet);
				return FALSE;
			}

			// ZAN^[o^f[^쐬
			// ǂݍ
			load2DGraphicFile(cont, w_sys->GraphicNo, w_sys->pCell);

			// ZAN^[o^f[^쐬
			initClactAddData( cont, w_sys );
		}
	}

	return TRUE;
}


// ֐
//----------------------------------------------------------------------------
/**
 *
 *	@brief	TCB
 *
 *	@param	tcb		^XN|C^
 *	@param	work	[N
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void divInitWeatherSysTcb( TCB_PTR tcb, void* work )
{
	WEATHER_SYS_DATA* w_sys = work;
	WEATHER_SYS_CONTROL* cont = w_sys->pWork->pWSysCont;
	BOOL check;

	switch( w_sys->DivInitSeq ){
	case 0:
		// ZAN^[Zbg
		initClactSet( cont, w_sys );

		// Zf[^i[惁m
		check = initCellDataMemory( w_sys );
		GF_ASSERT( check );
		w_sys->DivInitSeq++;
		break;

	case 1:
		// Zf[^ǂݍ
		loadCell_CellData( cont, w_sys->GraphicNo, w_sys->pCell );
		w_sys->DivInitSeq++;
		break;

	case 2:
		// pbgǂݍ
		initBgPltt( cont, w_sys->BGNo );
		w_sys->DivInitSeq++;
		break;

	case 3:
		// ZAjf[^ǂݍ
		loadCell_CellAnmData( cont, w_sys->GraphicNo, w_sys->pCell );
		w_sys->DivInitSeq++;
		break;

	case 4:
		// LN^ǂݍ
		initBgChar( cont, w_sys->BGNo );
		w_sys->DivInitSeq++;
		break;

	case 5:
		// LN^f[^ǂݍ
		loadCell_CharData( cont, w_sys->GraphicNo, w_sys->pCell );
		w_sys->DivInitSeq++;
		break;
		
	case 6:
		// XN[ǂݍ
		initBgScr( cont, w_sys->BGNo );
		w_sys->DivInitSeq++;
		break;

	case 7:
		// pbgf[^ǂݍ
		loadCell_PlttData( cont, w_sys->GraphicNo, w_sys->pCell );
		w_sys->DivInitSeq++;
		break;
	
	case 8:
		// ZAN^[ǉf[^쐬
		initClactAddData( cont, w_sys );
		w_sys->pWork->pCell = w_sys->pCell;		// Zf[^Rs[

		w_sys->MoveFlag = WEATHER_SYS_MOVE_READY;	// Jnҋ@
		w_sys->DivInitSeq = 0;
		w_sys->DivInitTcb = NULL;
		TCB_Delete( tcb );
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	[Ñm
 *
 *	@param	cont	Rg[
 *	@param	w_sys	[N̊i[
 *
 *	@retval	TRUE	
 *	@retval	FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL initWeatherSysWork( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys )
{
	if( w_sys->pWork ){
		// mۍς
		return TRUE;
	}
	
	// [N̍쐬
	w_sys->pWork = sys_AllocMemory(HEAPID_FIELD, sizeof(WEATHER_SYS_WORK));
	if(w_sys->pWork == NULL){
		return FALSE;
	}
	memset( w_sys->pWork, 0, sizeof(WEATHER_SYS_WORK) );

	// f[^ݒ
	w_sys->pWork->pWSysCont= cont;	// Rg[|Cg
	w_sys->pWork->Sequence = 0;		// ƃV[PX
	w_sys->pWork->ContFlag = 0;		// ORg[tO
	w_sys->pWork->Dummy.pNext = &w_sys->pWork->Dummy;
	w_sys->pWork->Dummy.pPrev = &w_sys->pWork->Dummy;
	w_sys->pWork->work	= NULL;		// [N̈

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[Zbg̍쐬
 *
 *	@param	cont		Rg[
 *	@param	w_sys		VCf[^i[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initClactSet( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys )
{
	CLACT_SETDATA	set;	// ZAN^[Zbg쐬f[^


	if( w_sys->GraphicNo != WEATHER_GRAPHIC_NONE){
		
		if( w_sys->pWork->clactSet ){
			// mۍς
			return;
		}

		// ZAN^[Zbg쐬
		set.WorkNum = WEATEHR_OBJ_MAX;
		set.pRender	= &cont->Draw.Render;
		set.heap	= HEAPID_FIELD;
		w_sys->pWork->clactSet = CLACT_InitSet( &set );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	Zf[^i[惁̈m
 *
 *	@param	w_sys	VCf[^i[
 *
 *	@retval TRUE	
 *	@retval FALSE	s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL initCellDataMemory( WEATHER_SYS_DATA* w_sys )
{
	if( w_sys->GraphicNo != WEATHER_GRAPHIC_NONE){
		if( w_sys->pCell ){

			return TRUE;	// mۍς
		}
		
		// OtBbNtBbNt@Cǂݍޗ̈쐬
		w_sys->pCell = sys_AllocMemory(HEAPID_FIELD, sizeof(WATHER_GRAPHIC_FILE_DATA));
		if(w_sys->pCell == NULL){
			return FALSE;
		}
		memset( w_sys->pCell, 0, sizeof(WATHER_GRAPHIC_FILE_DATA) );
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[f[^@@Zǂݍ
 *
 *	@param	cont			Rg[
 *	@param	GraphicNo		OtBbNio[
 *	@param	pCell			Zf[^i[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadCell_CellData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell )
{
	if(GraphicNo != WEATHER_GRAPHIC_NONE){
	
		// Zf[^ǂݍ
		pCell->res_obj[ CLACT_U_CELL_RES ] = loadRes(
				cont->Draw.resHeader, CLACT_U_CELL_RES, 
				GraphicNo,
				cont->Draw.resMan[ CLACT_U_CELL_RES ],
				cont->ArcHandle );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[f[^	ZAjǂݍ
 *
 *	@param	cont			Rg[
 *	@param	GraphicNo		OtBbNt@Cio[
 *	@param	pCell			Zf[^i[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadCell_CellAnmData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell )
{
	if(GraphicNo != WEATHER_GRAPHIC_NONE){
	
		// ZAjf[^ǂݍ
		pCell->res_obj[ CLACT_U_CELLANM_RES ] = loadRes(
				cont->Draw.resHeader, CLACT_U_CELLANM_RES, 
				GraphicNo,
				cont->Draw.resMan[ CLACT_U_CELLANM_RES ],
				cont->ArcHandle );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[f[^ǂݍ	LN^f[^
 *
 *	@param	cont			Rg[
 *	@param	GraphicNo		OtBbNf[^io[
 *	@param	pCell			Zf[^i[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadCell_CharData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell )
{
	if(GraphicNo != WEATHER_GRAPHIC_NONE){
	
		// LN^f[^ǂݍ
		pCell->res_obj[ CLACT_U_CHAR_RES ] = loadRes(
				cont->Draw.resHeader, CLACT_U_CHAR_RES, 
				GraphicNo,
				cont->Draw.resMan[ CLACT_U_CHAR_RES ],
				cont->ArcHandle );
		
		// Vram]
		CLACT_U_CharManagerSetAreaCont( pCell->res_obj[ CLACT_U_CHAR_RES ] );
		// LN^̓ǂݍłf[^̂ݔj
		CLACT_U_ResManagerResOnlyDelete( pCell->res_obj[ CLACT_U_CHAR_RES ] );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[f[^	pbgǂݍ
 *
 *	@param	cont			Rg[
 *	@param	GraphicNo		OtBbNt@Cio[
 *	@param	pCell			Zf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadCell_PlttData( WEATHER_SYS_CONTROL* cont, int GraphicNo, WATHER_GRAPHIC_FILE_DATA* pCell )
{
	if(GraphicNo != WEATHER_GRAPHIC_NONE){
	
		// pbgf[^ǂݍ
		pCell->res_obj[ CLACT_U_PLTT_RES ] = loadRes(
				cont->Draw.resHeader, CLACT_U_PLTT_RES, 
				GraphicNo,
				cont->Draw.resMan[ CLACT_U_PLTT_RES ],
				cont->ArcHandle );
		
		// Vram]
		CLACT_U_PlttManagerSetCleanArea( pCell->res_obj[ CLACT_U_PLTT_RES ] );
		// pbg̓ǂݍłf[^̂ݔj
		CLACT_U_ResManagerResOnlyDelete( pCell->res_obj[ CLACT_U_PLTT_RES ] );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ZAN^[o^f[^쐬
 *
 *	@param	cont		Rg[
 *	@param	w_sys		VCf[^i[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initClactAddData( WEATHER_SYS_CONTROL* cont, WEATHER_SYS_DATA* w_sys )
{
	if( w_sys->GraphicNo != WEATHER_GRAPHIC_NONE){
		// ZAN^[o^f[^쐬
		getHeader(&w_sys->pCell->head, cont, w_sys->pCell, 0, WEATHER_SYS_BG_2_DRAW_PRI);
		memset(&w_sys->pCell->add, 0, sizeof(CLACT_ADD));
		w_sys->pCell->add.ClActSet		= w_sys->pWork->clactSet;
		w_sys->pCell->add.ClActHeader	= &w_sys->pCell->head;
		w_sys->pCell->add.sca.x			= FX32_ONE;
		w_sys->pCell->add.sca.y			= FX32_ONE;
		w_sys->pCell->add.sca.z			= FX32_ONE;
		w_sys->pCell->add.DrawArea		= 1;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG	pbgǂݍ
 *
 *	@param	cont		Rg[
 *	@param	BGNo		ǂݍBGf[^io[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBgPltt( WEATHER_SYS_CONTROL* cont, int BGNo )
{
	WATHER_BG_FILE_DATA	BG;		// BGt@Cf[^ǂݍݗ̈

	if(BGNo != WEATHER_GRAPHIC_NONE){
		// pbgǂݍ
		BG.pPlttBuff = ArchiveDataLoadAllocByHandle( cont->ArcHandle, cont->pWSBG[BGNo].pltt_arc, HEAPID_FIELD );
		// ApbN
		NNS_G2dGetUnpackedPaletteData( BG.pPlttBuff, &BG.pPltt );
		// BG̓ǂݍ			
		GF_BGL_PaletteSet(FLD_MBGFRM_EFFECT2,
				BG.pPltt->pRawData,
				32,
				32 * (WEATHER_PLTT_OFS));
		sys_FreeMemoryEz( BG.pPlttBuff );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG		LN^f[^ǂݍ
 *
 *	@param	cont		Rg[
 *	@param	BGNo		BGf[^io[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBgChar( WEATHER_SYS_CONTROL* cont, int BGNo )
{
	WATHER_BG_FILE_DATA	BG;		// BGt@Cf[^ǂݍݗ̈

	if(BGNo != WEATHER_GRAPHIC_NONE){
		// t@Cǂݍ
		BG.pCharBuff = ArchiveDataLoadAllocByHandle( cont->ArcHandle, cont->pWSBG[BGNo].char_arc, HEAPID_FIELD );
		// ApbN
		NNS_G2dGetUnpackedCharacterData( BG.pCharBuff, &BG.pChar );

		GF_BGL_LoadCharacter( cont->fsys->bgl, FLD_MBGFRM_EFFECT2,
				BG.pChar->pRawData,
				BG.pChar->szByte,
				0 );
		sys_FreeMemoryEz( BG.pCharBuff );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	BG		XN[f[^ǂݍ
 *
 *	@param	cont		Rg[
 *	@param	BGNo		BGf[^io[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void initBgScr( WEATHER_SYS_CONTROL* cont, int BGNo )
{
	WATHER_BG_FILE_DATA	BG;		// BGt@Cf[^ǂݍݗ̈

	if(BGNo != WEATHER_GRAPHIC_NONE){
		// XN[f[^
		BG.pScreenBuff = ArchiveDataLoadAllocByHandle( cont->ArcHandle, cont->pWSBG[BGNo].screen_arc, HEAPID_FIELD );
		GF_ASSERT(BG.pScreenBuff);
		// ApbN
		NNS_G2dGetUnpackedScreenData( BG.pScreenBuff, &BG.pScreen );
		GF_BGL_LoadScreen(cont->fsys->bgl, FLD_MBGFRM_EFFECT2,
				(void*)BG.pScreen->rawData,
				BG.pScreen->szByte,
				0 );

		GF_BGL_ScreenBufSet(cont->fsys->bgl, FLD_MBGFRM_EFFECT2, (void*)BG.pScreen->rawData,
				BG.pScreen->szByte );
		
		GF_BGL_ScrPalChange(
				cont->fsys->bgl, FLD_MBGFRM_EFFECT2,
				0, 0,
				32, 32,
				WEATHER_PLTT_OFS
				);
		GF_BGL_LoadScreenReq( cont->fsys->bgl, FLD_MBGFRM_EFFECT2 );

		sys_FreeMemoryEz( BG.pScreenBuff );
	}
}


//-----------------------------------------------------------------------------
//	vCx[g֐
//		VCǗ^XNp֐S	
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWF̃[N̈m
 *
 *@param	pData		mۂIuWFf[^
 *@param	Byte		mۂoCgTCY
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void allocObjWork(WAETHER_OBJ_DATA* pData, int byte)
{
	if(byte > 0){
		pData->work = sys_AllocMemory(HEAPID_FIELD, byte);
	}else{
		pData->work = NULL;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWF̃[N̈j
 *
 *@param	pData		jIuWFf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void freeObjWork(WAETHER_OBJ_DATA* pData)
{
	if(pData->work != NULL){
		sys_FreeMemory(HEAPID_FIELD, pData->work);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWF^XNo^
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	w_byte		[NoCgTCY
 *
 *@return	WAETHER_OBJ_DATA*	:IuWFNg̃|C^	s:NULL
 *
 *	e
 *		Ǘ֐[NIuWF쐬ăXgo^
 *
 */
//-----------------------------------------------------------------------------
static WAETHER_OBJ_DATA* addObj(WEATHER_SYS_WORK* pWork, int w_byte)
{
	WAETHER_OBJ_DATA* p_obj;		// IuWFf[^
	WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)pWork->pWSysCont;	// Rg[
	
	// IuWFNgf[^쐬
	p_obj = getCleanObjData( pWork );
	if(p_obj == NULL){
		return NULL;
	}

	// f[^Zbg
	p_obj->pWSysCont				= cont;			// e̓VCǗf[^
	
	// Xgɓo^
	p_obj->pNext				= &pWork->Dummy;
	p_obj->pPrev				= pWork->Dummy.pPrev;
	pWork->Dummy.pPrev->pNext	= p_obj;
	pWork->Dummy.pPrev			= p_obj;

	p_obj->clact_w = CLACT_Add(&pWork->pCell->add);
	if(p_obj->clact_w == NULL){
		destObj(p_obj);
		return NULL;
	}

	// [N쐬
	allocObjWork(p_obj, w_byte);
	if(p_obj->work == NULL){
		destObj(p_obj);
		return NULL;
	}
	
	return p_obj;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ZAN^[wb_쐬
 *	
 *@param	head	wb_
 *@param	cont	VCǗf[^
 *@param	pcell	Zf[^
 *@param	vram_trans	Vram]
 *@param	priority	D揇
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void getHeader(CLACT_HEADER_PTR head, WEATHER_SYS_CONTROL* cont, WATHER_GRAPHIC_FILE_DATA* pcell,int vram_trans, int priority )
{
	int id[ WEATHER_RES_NUM ];		// \[XIDi[obt@
	int i;							// [vp

	// ID擾
	for(i=0;i<WEATHER_RES_NUM;i++){
		id[ i ] = CLACT_U_ResManagerGetResObjID( pcell->res_obj[ i ] );
	}

	// wb_쐬
	CLACT_U_MakeHeader( 
			head,
			id[ CLACT_U_CHAR_RES ], id[ CLACT_U_PLTT_RES ], 
			id[ CLACT_U_CELL_RES ], id[ CLACT_U_CELLANM_RES ],
			CLACT_U_HEADER_DATA_NONE, CLACT_U_HEADER_DATA_NONE,
			vram_trans, priority,
			cont->Draw.resMan[ CLACT_U_CHAR_RES ], cont->Draw.resMan[ CLACT_U_PLTT_RES ],
			cont->Draw.resMan[ CLACT_U_CELL_RES ], cont->Draw.resMan[ CLACT_U_CELLANM_RES ],
			NULL, NULL);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^IuWF^XNj
 *
 *@param	pData		jIuWFNgf[^
 *
 *@return	none
 *
 *	e
 *		IuWFNgf[^j
 *
 */
//-----------------------------------------------------------------------------
static void destObj(WAETHER_OBJ_DATA* pData)
{
//	WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)pData->pWSysCont;	// Rg[

	// Xgj
	pData->pPrev->pNext	= pData->pNext;
	pData->pNext->pPrev	= pData->pPrev;

	// ZAN^[j
	if(pData->clact_w){
		CLACT_Delete(pData->clact_w);
		pData->clact_w = NULL;
	}

	// [Nj
	freeObjWork(pData);	
		
	// j
	memset( pData, 0, sizeof(WAETHER_OBJ_DATA) );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^IuWF^XNSj
 *
 *@param	pDummy		jIuWFNgXg̐擪f[^
 *
 *@return	none
 *
 *	e
 *		IuWFNgf[^SĔj
 *
 */
//-----------------------------------------------------------------------------
static void destObjAll(WAETHER_OBJ_DATA* pDummy)
{
	WAETHER_OBJ_DATA* p_work;		// jƗp
	WAETHER_OBJ_DATA* p_next;		// ̃IuWFNg
	
	// Sj
	p_work = pDummy->pNext;
	while(p_work != pDummy){
		p_next = p_work->pNext;
		destObj(p_work);		// j
		p_work = p_next;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ꂽSIuWFNg𓮂
 *
 *@param	pDummy		IuWFNgXg
 *@param	pFunc		֐
 *
 *@return	none
 *
 *	e
 *		IuWFNgf[^𓮂
 *
 */
//-----------------------------------------------------------------------------
static void moveFuncObj(WAETHER_OBJ_DATA* pDummy, objFunc pFunc)
{
	WAETHER_OBJ_DATA* p_work;		// Ɨp
	WAETHER_OBJ_DATA* p_work_next;	// Ɨp

	// S
	p_work = pDummy->pNext;
	p_work_next = p_work->pNext;
	while(p_work != pDummy){
		pFunc(p_work);		// 
		
		p_work = p_work_next;
		p_work_next = p_work->pNext;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg̕`
 *
 *@param	pData		VCP̃f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void drawObj(WEATHER_SYS_WORK* pData)
{
	CLACT_Draw(pData->clactSet);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNgW擾
 *
 *@param	obj		擾IuWF
 *
 *@return	W
 *
 *
 */
//-----------------------------------------------------------------------------
static VecFx32 getObjMat( WAETHER_OBJ_DATA* obj )
{
	const VecFx32* mat = CLACT_GetMatrix(obj->clact_w);

	return *mat;
}

// XN[W擾
static void getScrollNum(fx32* x, fx32* y, WEATHER_SYS_WORK* pWork)
{
	
	VecFx32	now_mat;				// ̍W
	fx32 scl_x, scl_y;				// ScrollW
	fx32 d_x, d_y;					// 2dłP̂R̒l
	fx32 dist_x, dist_y;			// ړl
	int	mark;						// 
	fx32 aspect;					// AXyNg
	
	
	// ̃J2d1̂R̒l߂
	aspect = FX_Div(4*FX32_ONE, 3*FX32_ONE);
	GetPerspectiveScreenSize( 
			GFC_GetCameraPerspWay( pWork->pWSysCont->fsys->camera_ptr ),
			GFC_GetCameraDistance(pWork->pWSysCont->fsys->camera_ptr),
			aspect,
			&d_x, &d_y);
	d_x = FX_Div(d_x, 256*FX32_ONE);
	d_y = FX_Div(d_y, 192*FX32_ONE);
	


	// 瓮ɂODTi_̌덷ŒlςȂ߁j
	now_mat = *(NNS_G3dGlbGetCameraTarget());
	
	dist_x = (now_mat.x - pWork->CameraTarget.x);
	dist_y = (now_mat.z - pWork->CameraTarget.z);

	// vXŌvZ
	mark = FX32_ONE;
	if(dist_x < 0){		// [̎́{̒lɂ
		mark = -FX32_ONE;
		dist_x = FX_Mul( dist_x, -FX32_ONE );
	}
	scl_x = FX_Div(dist_x, d_x);	// XN[WvZ
	if( mark < 0 ){		// ̕ɖ߂
		scl_x = FX_Mul( scl_x, mark );	// ̕ɖ߂
	}

	mark = FX32_ONE;
	if(dist_y < 0){		// [̎́{̒lɂ
		mark = -FX32_ONE;
		dist_y = FX_Mul( dist_y, -FX32_ONE );
	}	
	scl_y = FX_Div(dist_y, d_y);	// XN[W߂
	if( mark < 0 ){
		scl_y = FX_Mul( scl_y, mark );	// ̕ɖ߂
	}
		
	// ̍W擾
	if((scl_x + scl_y) != 0){
		pWork->CameraTarget = now_mat;
	}

	*x = scl_x;
	*y = scl_y;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ꂽSIuWFNg̍Wscrollɂ킹
 *
 *@param	pWork		ScrollVCRg[̖{
 *@param	x, y		XN[W(ȂƂNULL)
 *
 *@return	none
 *
 *	e
 *		IuWFNg̍W̃^[ł̃J̃^[Qbg̈ړnɍ킹
 *
 */
//-----------------------------------------------------------------------------
static void scrollObj(WEATHER_SYS_WORK* pWork,int* x, int* y)
{
	WAETHER_OBJ_DATA* p_work;		// Ɨp
	fx32 scl_x, scl_y;		// XN[W	
	VecFx32 mat;			// W
	

	getScrollNum(&scl_x,&scl_y, pWork);
	
	
	// SIuWFNgɔf
	p_work = pWork->Dummy.pNext;
	while(p_work != &pWork->Dummy){
		// ̍W擾
		mat = getObjMat(p_work);
		
		mat.x -= scl_x;
		mat.y -= scl_y;

		// Wݒ
		setClactMatrix(p_work->clact_w, &mat);
		
		p_work = p_work->pNext;
	}

	if(x != NULL){
		*x = scl_x >> FX32_SHIFT;
		if( *x < 0 ){
			*x += 1;	// }CiX̂Ƃ-1̌덷o邽
		}
	}
	if(y != NULL){
		*y = scl_y >> FX32_SHIFT;
		if( *y < 0 ){
			*y += 1;	// }CiX̂Ƃ-1̌덷o邽
		}
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNgtF[h
 *
 *@param	data		IuWFNg̃tF[hf[^
 *
 *@retval	0			tF[hI
 *@retval	1			o^^C~OJE^tF[hI
 *@retval	2			o^tF[hI
 *@retval	3			SI
 *
 * eJE^̏OɂĂKv܂B
 * JE^̓|C^QƂȂ̂ŁAȂ悤ɂĂKv܂B
 * 
 * 
 */
//-----------------------------------------------------------------------------
static int weatherSysObjFade(WEATHER_SYS_OBJ_FADE* data)
{
	int fade_flag;
	int ret = 0;
	

	// tF[hI`FbN
	// ^C~O-------------------------------------------
	// lOȂ^C~OtF[hI
	if(data->OBJ_ADD_TMG_SUM == 0){
		ret |= 1;
	}else{
		// tF[hCAAEg`FbN
		if(data->OBJ_ADD_TMG_SUM > 0){
			fade_flag = 0;		// ύXlvXȂ̂ŃtF[hC
		}else{
			fade_flag = 1;		// ύXl}CiXȂ̂ŃtF[hAEg
		}
		// o^^C~OI_ɂĂȂ`FbN
		if(((data->objAddTmgMax >= data->OBJ_ADD_TMG_END)&&(fade_flag == 0)) ||
			((data->objAddTmgMax <= data->OBJ_ADD_TMG_END)&&(fade_flag == 1))){
			ret |= 1;

			data->objAddTmgMax = data->OBJ_ADD_TMG_END;
		}
	}

	// o^---------------------------------------------------
	// lOȂo^tF[hI
	if(data->OBJ_ADD_NUM_SUM == 0){
		ret |= 2;
	}else{
		
		// tF[hCAAEg`FbN
		if(data->OBJ_ADD_NUM_SUM > 0){
			fade_flag = 0;		// ύXlvXȂ̂ŃtF[hC
		}else{
			fade_flag = 1;		// ύXl}CiXȂ̂ŃtF[hAEg
		}
		// IuWFNgo^I_ɂĂȂ`FbN
		if(((data->objAddNum >= data->OBJ_ADD_NUM_END)&&(fade_flag == 0)) ||
			((data->objAddNum <= data->OBJ_ADD_NUM_END)&&(fade_flag == 1))){
		
			ret |= 2;
			data->objAddNum = data->OBJ_ADD_NUM_END;
		}
	}
	

	// ^C~OJE^ŏɂȂ܂ŃJEg
	(data->objAddTmg)--;
	if(data->objAddTmg <= 0){

		// o^
		data->add(data->pWork, data->objAddNum);

		data->objAddTmg = data->objAddTmgMax;			// o^^C~OZbg
		
		// ^C~O-------------------------------------------
		if((ret & 1) == 0){
			data->objAddTmgMax += data->OBJ_ADD_TMG_SUM;	// J^C~OvZ
		}
		
	
		// o^---------------------------------------------------
		if((ret & 2) == 0){
			(data->objAddNumSum)++;
			if(data->objAddNumSum >= data->OBJ_ADD_NUM_SUM_TMG){
				data->objAddNumSum = 0;
				data->objAddNum += data->OBJ_ADD_NUM_SUM;	// o^Abh
			}
		}
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOtF[h
 *
 *@param	data		IuWFNg̃tF[hf[^
 *
 *@retval	0			tF[hI
 *@retval	1			tF[hI
 *
 * eJE^̏OɂĂKv܂B
 * JE^̓|C^QƂȂ̂ŁAȂ悤ɂĂKv܂B
 * 
 * 
 */
//-----------------------------------------------------------------------------
static int weatherSysFogFade(WEATHER_SYS_FOG_FADE* data)
{
	int ret;		// ߂l
	
	ret = weatherSysFogFadeNoReflect( data );

	// fogCount0e[uf[^ύX^C~O
	// Ȃ̂Ŕf
	if( data->fogCount == 0 ){
		SetFogTbl(data->Fog, data->fog_tbl);	// tHOe[uZbg
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tF[hCɍ쐬ĂtHOf[^쐬
 *
 *	@param	data		tHOtF[hf[^
 *	
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void weatherSysFogSet(WEATHER_SYS_FOG_FADE* data)
{
	int i;
	int result;
	
	// tHO̐ݒ
	for(i=0;i<32;i++){						// tHOe[u
		data->fog_tbl[i] = 0;
	}
	data->fogDepth		= 127;
	data->fogCount		= 0;
	data->FOG_CHG_TMG	= 0;
	data->FOG_TBL_SUM	= 1;

	do{
		result = weatherSysFogFadeNoReflect( data );	// tHOe[u쐬
	}while( result != TRUE );
	SetFogTbl(data->Fog, data->fog_tbl);	// tHOe[uZbg
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	tHOtF[h		tHOf[^̔fsȂo[W
 *
 *@param	data		IuWFNg̃tF[hf[^
 *
 *@retval	0			tF[hI
 *@retval	1			tF[hI
 *
 * eJE^̏OɂĂKv܂B
 * JE^̓|C^QƂȂ̂ŁAȂ悤ɂĂKv܂B
 * 
 * 
 */
//-----------------------------------------------------------------------------
static int weatherSysFogFadeNoReflect(WEATHER_SYS_FOG_FADE* data)
{
	int ret = 0;		// ߂l
	
	if(data->FOG_TBL_SUM == 0){
		ret = 1;
	}else{
	
		// IĂ邩`FbN
		if(data->fogDepth <= 0){
			ret = 1;
		}else{
			
			data->fogCount++;
			if(data->fogCount >= data->FOG_CHG_TMG){
				data->fogCount = 0;

				// e[uvZ
				calcWeatherFogTbl( data );
				
				data->fogDepth--;
				if(data->fogDepth <= 0){		// I`FbN
					ret = 1;
				}
//				SetFogTbl(data->Fog, data->fog_tbl);	// tHOe[uZbg
			}
		}
	}

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	tHOe[u쐬vZ
 *
 *	@param	data	tHOtF[hf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void calcWeatherFogTbl( WEATHER_SYS_FOG_FADE* data )
{
	int i;
	int fog_num;		// tHOe[uvZp

	// tHO𓮂		(y=(x*x)/(4*x))
	fog_num = (data->fogDepth * data->fogDepth)/(4*data->fogDepth);
	for(i=31;i>fog_num;i--){
		data->fog_tbl[i] += data->FOG_TBL_SUM;
	}
}

#if 0
//----------------------------------------------------------------------------
/**
 *
 *	@brief	BGtF[hvZ֐
 *
 *	@param	now_alpha		݂̃l
 *	@param	end_alpha		tF[hIl
 *	@param	add_alpha		l
 *	@param	timing_count	^C~OJE^
 *	@param	add_timing		^C~O
 *
 *	@retval	TRUE		
 *	@retval	FALSE		tF[hI
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL weatherBGFade( s32* now_alpha, const int end_alpha, const int add_alpha, s32* timing_count, const int add_timing )
{
	BOOL ret = TRUE;
	
	// BG
	(*timing_count)++;
	if((*timing_count) > add_timing){
		(*timing_count) = 0;

		if( add_alpha > 0 ){
			if(((*now_alpha) + add_alpha) <= end_alpha){
				(*now_alpha) += add_alpha;
			}else{
				(*now_alpha) = end_alpha;
				ret = FALSE;
			}
		}else{
			if(((*now_alpha) + add_alpha) >= end_alpha){
				(*now_alpha) += add_alpha;
			}else{
				(*now_alpha) = end_alpha;
				ret = FALSE;
			}
		}
	}

	return ret;
}
#endif

//----------------------------------------------------------------------------
/**
 *
 *	@brief	VC̃IuWFNg𕪕z
 *
 *	@param	pWork			[N
 *	@param	add_func		IuWFNgo^֐|C^
 *	@param	num				o^
 *	@param	dust_div_num	IuWFNgƂɓ쐔ύX邩
 *	@param	dust_div_move	eIuWFNg̓쐔ǂ̂炢
 *	@param	move_func		֐
 *
 *	@return	none
 *
 * num̃IuWFNgo^A0Ԗڂ̃IuWFNgdust_div_move񐔕
 * IuWFNg𓮍삳
 * 0Ԗڂ̃IuWFNg@0
 * 1Ԗڂ̃IuWFNg	dust_div_move
 * 2Ԗڂ̃IuWFNg	dust_div_move * 2
 * ....
 *
 */
//-----------------------------------------------------------------------------
static void weatherDustObj( WEATHER_SYS_WORK* pWork, OBJADD_FUNC add_func, int num, int dust_div_num, int dust_div_move, objFunc move_func )

{
	int i, j;
	int move_num;
	WAETHER_OBJ_DATA* obj;
	WAETHER_OBJ_DATA* obj_next;
	
	// IuWFNgo^
	add_func( pWork, num );


	// IuWFNgi߂
	move_num = 0;
	obj = pWork->Dummy.pNext;
	obj_next = obj->pNext;
	for( i=0; i<num; i++ ){	
		
		// o^sĂƂnum̃IuWFNgo^ĂȂ
		if( obj == &pWork->Dummy ){
			break;
		}
		
		for( j=0; j<move_num; j++ ){
			move_func( obj );

			// jꂽI
			if( obj->work == NULL ){
				break;
			}
		}

		// 
		obj = obj_next;
		obj_next = obj->pNext;	// move_funcŃIuWFNgj邱Ƃ邽߁ÃIuWFNg|C^ۑĂ

		// 쐔ύXvZ
		if( i >= dust_div_num ){
			if( (i % dust_div_num) == 0 ){
				move_num += dust_div_move;
			}
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	J̃IuWFNgf[^zvf擾
 *
 *	@param	pWork	VCVXe[N
 *
 *	@return	WAETHER_OBJ_DATA	IuWFf[^
 *
 *
 */
//-----------------------------------------------------------------------------
static WAETHER_OBJ_DATA* getCleanObjData( WEATHER_SYS_WORK* pWork )
{
	int i;

	for( i=0; i<WEATEHR_OBJDATA_MAX; i++ ){

		if( pWork->ObjArray[ i ].pWSysCont == NULL ){	//(NULL`FbN͂ǂ̃ołOK)
			return &pWork->ObjArray[ i ];
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
//	vCx[g֐
//		VCǗ^XNS	
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	JǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherRain(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL*	sys_w;	// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO

	// [N|C^Zbg
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;
	
	
	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// Ɨ̈̏
		// IuWFNgtF[hp
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherRain;
		sys_w->objFade.objAddNum		= WEATHER_RAIN_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_RAIN_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_RAIN_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_RAIN_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_RAIN_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_RAIN_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_RAIN_ADD;

		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_RAIN_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_RAIN_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_RAIN_FOG_START;	// tHOp

		// At@uh
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_OBJ, GX_BLEND_PLANEMASK_BG0, 4,16);
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		
		result = weatherSysObjFade(&sys_w->objFade);	// s
	
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;

	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		// Ɨ̈̏
		// IuWFNgtF[hp
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherRain;
		sys_w->objFade.objAddNum		= WEATHER_RAIN_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_RAIN_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_RAIN_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_RAIN_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_RAIN_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_RAIN_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_RAIN_ADD;

		// tHOf[^ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		
		// At@uh
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_OBJ, GX_BLEND_PLANEMASK_BG0, 4,16);

		// JIuWFNgU΂
		weatherDustObj( sys_work, addWeatherRain, WEATHER_RAIN_NOFADE_OBJ_START_NUM, WEATHER_RAIN_NOFADE_OBJ_START_DUST_NUM, WEATHER_RAIN_NOFADE_OBJ_START_DUST_MOVE, objWeatherRain );
		
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
		
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// Jo^
			addWeatherRain(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}

		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_RAIN_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_RAIN_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= -WEATHER_RAIN_ADD;
			
			// tHO
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_RAIN_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_RAIN_FOG_START_END;	// tHOp

			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
	
		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_RAIN);
		}
		break;


	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ̓IuWFNg𓮍삳
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherRain);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JIuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		JpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherRain(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	int	err;	// ␳l
	s32* obj_w;	// IuWFNg[N
	int frame;	// `t[
	VecFx32	mat;	// ݒW
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}
		obj_w = (s32*)add_obj->work;		// IuWF[N쐬
		
		// ̈
		obj_w[0] = 0;			// JE^
		frame = gf_mtRand()%3;	// J̎
		CLACT_AnmFrameSet(add_obj->clact_w, frame);

		err = (gf_mtRand() % WEATHER_RAIN_SPEED_ERR);
		obj_w[2] = WEATHER_RAIN_SPEED_Y * (frame+1) + err;
		if(frame == 2){		// ԑỎJ̓Xs[hPiKグ
			obj_w[2] += WEATHER_RAIN_SPEED_Y;
		}
		
		err /= WEATHER_RAIN_SPEED_X;
		obj_w[4] = WEATHER_RAIN_SPEED_X * (frame+1) + err;
		if(frame == 2){		// ԑỎJ̓Xs[hPiKグ
			obj_w[4] += WEATHER_RAIN_SPEED_X;
		}
		obj_w[3] = 0;			// jAjtO
		
		// j^C~O	Sʂ͈̔͂̒l
		obj_w[1] = WEATHER_RAIN_END_MIN  + (gf_mtRand() % WEATHER_RAIN_END_MAX);
		
		// Wݒ
		mat.x = ( WEATHER_RAIN_START_X_BASE + (frame * WEATHER_RAIN_MUL_X) + (gf_mtRand() % WEATHER_RAIN_START_X_MAX) ) << FX32_SHIFT;
		mat.y = WEATHER_RAIN_START_Y << FX32_SHIFT;
		mat.z = 0;	
		setClactMatrix(add_obj->clact_w, &mat);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JIuWFNg֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherRain(WAETHER_OBJ_DATA* work)
{
	int i;
	WAETHER_OBJ_DATA* p_obj = work;
	s32*	obj_w = (s32*)p_obj->work;
	VecFx32 mat;	// W

	mat = getObjMat(p_obj);
	
	// tO`FbN
	switch(obj_w[3]){
	case 0:		// 
		// ߊԂ␳@@ƂĂPt[ɂQ񓮂APDT̕`s
		for(i=0;i<2;i++){
			// 
			mat.x += obj_w[4] << FX32_SHIFT;
			mat.y += obj_w[2] << FX32_SHIFT;
		
			// j邩`FbN
			if(obj_w[0]++ > obj_w[1]){
				// Aj[V邩`FbN
				if((gf_mtRand() % 10) < 7){		// 7/10͔j
					// j
					obj_w[3] = 2;
				}else{
				
					// jAj
					obj_w[3] = 1;		
					obj_w[0] = 4;			// jAjJE^
					CLACT_AnmFrameSet(p_obj->clact_w, 3);
				}
			}
		}
		// Wݒ
		setClactMatrix(p_obj->clact_w, &mat);

		break;
	case 1:		// jAj
		if(obj_w[0]-- <= 0){
			obj_w[3] = 2;		// j
		}
		break;

	case 2:		// j
		destObj(p_obj);
		break;
	}		
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSnow(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	int		tmp_y;		// yWۑp
	WEATHER_SYSW_NORMAL*	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;
	int		result;		// ֐
	int		fog_result;	// tHO
	

	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnow;
		sys_w->objFade.objAddNum		= 1;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SNOW_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SNOW_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SNOW_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SNOW_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_ADD;
		
		sys_w->work[1] = 0;							// ႪP񉺂܂ōs̃tO
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SNOW_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SNOW_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_SNOW_FOG_START;	// tHOp
	
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_OBJ, GX_BLEND_PLANEMASK_BG0, 8, 16);
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnow;
		sys_w->objFade.objAddNum		= WEATHER_SNOW_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SNOW_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SNOW_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SNOW_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SNOW_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_ADD;
		
		sys_w->work[1] = 0;							// ႪP񉺂܂ōs̃tO
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SNOW_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );

//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_OBJ, GX_BLEND_PLANEMASK_BG0, 8, 16);

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSnow, WEATHER_SNOW_NOFADE_OBJ_START_NUM, WEATHER_SNOW_NOFADE_OBJ_START_DUST_NUM, WEATHER_SNOW_NOFADE_OBJ_START_DUST_MOVE, objWeatherSnow );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// o^
			addWeatherSnow(sys_work, sys_w->objFade.objAddNum);
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_SNOW_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= -1;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SNOW_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_SNOW_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [NOɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SNOW);
		}	
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSnow);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		pɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherSnow(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	int rand;	// 
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	WEATHER_SYSW_NORMAL*	sys_w;	// VXe[N
	s32*	obj_w;		// IuWFNg[N
	int	frame;		// t[
	VecFx32	mat;	// W

	sys_w = (WEATHER_SYSW_NORMAL*)pWork->work;
	
	if(sys_w->work[1] == 1){
		num *= 2;
	}
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}
		obj_w = (s32*)add_obj->work;
		
		frame = gf_mtRand() % WEATHER_SNOW_OBJ_NUM;
		CLACT_AnmFrameSet(add_obj->clact_w, frame);
		
		obj_w[4] = 10;	// ̓ύXJE^	
		obj_w[5] = 0;
		obj_w[6] = 0;	// PJE^
		
		rand = gf_mtRand();
	
		// Xs[h
		if((rand % 2) == 0){
			obj_w[1] = 1;
		}else{
			obj_w[1] = -1;
		}
		obj_w[2] = WEATHER_SNOW_ADD_TMG_X_BASE + (gf_mtRand() % WEATHER_SNOW_ADD_TMG_X_RAN);
		obj_w[3] = WEATHER_SNOW_ADD_TMG_Y_BASE + (gf_mtRand() % WEATHER_SNOW_ADD_TMG_Y_RAN);

		obj_w[0] = (s32)&sys_w->work[1];		// ܂ōstO𗧂Ă|C^ۑ
		
		// Wݒ
		mat.x = ( WEATHER_SNOW_START_X_BASE + (gf_mtRand() % WEATHER_SNOW_START_X_MAX) ) << FX32_SHIFT;
		
		if((sys_w->work[1] == 1) &&
			(i >= (num /2)) ){	// o
			mat.y = ( -40 - (gf_mtRand() % 20)) << FX32_SHIFT;
		}else{
			mat.y = ( -8 - (gf_mtRand() % 20) ) <<FX32_SHIFT;
		}
		setClactMatrix(add_obj->clact_w, &mat);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ᓮ֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherSnow(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32*	obj_w = (s32*)p_obj->work;
	s32*	p_flg;	// ႪʊO֍s̃tO
	VecFx32 mat;	// W

	mat = getObjMat(p_obj);
	
	// 
	if(((obj_w[5] & 0xffff) >= obj_w[2])){
		mat.x	+= obj_w[1] << FX32_SHIFT;
		obj_w[4]++;
		obj_w[5] &= 0xffff0000;
		
		// Xs[h`FW[
		if(obj_w[4] < 10){
			obj_w[2]--;
		}else{
			obj_w[2]++;
		}

		if(obj_w[4] >= 20){
			obj_w[4] = 0;
			obj_w[1]*=-1;
		}//*/
	}
	if(((obj_w[5] >> 16) >= obj_w[3])){
		mat.y += FX32_ONE;
		obj_w[5] &= 0x0000ffff;

		
	} 

	setClactMatrix( p_obj->clact_w, &mat );

	mat.x >>= FX32_SHIFT;
	mat.y >>= FX32_SHIFT;
	
	obj_w[6] = (obj_w[6] + 1) % 100;
	obj_w[5]++;
	obj_w[5]+=0x10000;

	
	// j][ɂj  
	if(((mat.y < -284) && (mat.y > -296)) ||
		((mat.y > 212) && (mat.y < 232))){
		p_flg = (s32*)(obj_w[0]);
		*p_flg = 1;
		destObj(p_obj);
		return ;
	}
	
}


//-------------------------------------
//	
//=====================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSnowStorm(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL*	sys_w;		// VXe[N̈
	int		result;		// ֐
	int		fog_result;	// tHO	
	
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;
	

	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowStorm;
		sys_w->objFade.objAddNum		= WEATHER_SSNOW_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SSNOW_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SSNOW_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SSNOW_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SSNOW_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SSNOW_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SSNOW_ADD;

		// tHO̐ݒ		
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SSNOW_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(24,24,24), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SSNOW_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_SSNOW_FOG_START;	// tHOp
	
		
		sys_w->work[1] = 0;					// IuWFJE^
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s	
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [NOɂȂtHO𓮂
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}	
		break;

	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowStorm;
		sys_w->objFade.objAddNum		= WEATHER_SSNOW_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SSNOW_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SSNOW_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SSNOW_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SSNOW_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SSNOW_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SSNOW_ADD;

		// tHO̐ݒ		
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SSNOW_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(24,24,24), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );

		sys_w->work[1] = 0;					// IuWFJE^

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSnowStorm, WEATHER_SSNOW_NOFADE_OBJ_START_NUM, WEATHER_SSNOW_NOFADE_OBJ_START_DUST_NUM, WEATHER_SSNOW_NOFADE_OBJ_START_DUST_MOVE, objWeatherSnowStorm );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;

	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// o^
			addWeatherSnowStorm(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SSNOW_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_SSNOW_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SSNOW_ADD_END;
		
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SSNOW_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_SSNOW_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [NOɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SNOW_STORM);
		}	
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSnowStorm);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		JpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherSnowStorm(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	int tbl_num;
	WEATHER_SYSW_NORMAL* sys_w;		// VXe[N
	s32* obj_w;			// IuWFNg[N
	int WEATHER_SSNOW_ADD_SP_TMG[WEATHER_SSNOW_ADD_SP_TMG_NUM] = {16,32,16,10};
	int WEATHER_SSNOW_SPEED_Y[WEATHER_SSNOW_ADD_SP_TMG_NUM] = {2,2,2,2};	// ĂɐiރXs[h
	int frame;	// t[
	
	sys_w = (WEATHER_SYSW_NORMAL*)pWork->work;
	
	

	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		obj_w = (s32*)add_obj->work;

		// ̒l߂
		sys_w->work[1]++;
		if(sys_w->work[1] >= (WEATHER_SSNOW_ADD_SP_TMG_TMG * WEATHER_SSNOW_ADD_SP_TMG_NUM)){
			sys_w->work[1] = 0;
		}
		tbl_num = (sys_w->work[1] / WEATHER_SSNOW_ADD_SP_TMG_TMG);
		obj_w[5] = WEATHER_SSNOW_ADD_SP_TMG[ tbl_num ];
		
	
		
		// ̈
		obj_w[0] = 0;			// JE^
		obj_w[1] = WEATHER_SSNOW_END_MIN + (gf_mtRand() % (WEATHER_SSNOW_END_MAX - WEATHER_SSNOW_END_MIN));	// IJE^
		frame = (obj_w[1] - WEATHER_SSNOW_END_MIN) / WEATHER_SSNOW_END_DIV;	// ̎
		CLACT_AnmFrameSet(add_obj->clact_w, frame);
		
		obj_w[4] = WEATHER_SSNOW_SPEED_X * (frame+1);
		obj_w[2] = WEATHER_SSNOW_SPEED_Y[tbl_num] * (frame+1);	// ăXs[h
		obj_w[3] = 0;			// jAjtO
		
		// Wݒ
		{
			VecFx32	mat = getObjMat( add_obj );
			mat.x = WEATHER_SSNOW_START_X_BASE + (frame * WEATHER_SSNOW_MUL_X) + (gf_mtRand() % WEATHER_SSNOW_START_X_MAX);
			mat.y = WEATHER_SSNOW_START_Y;
			mat.z = 0;
			mat.x <<= FX32_SHIFT;
			mat.y <<= FX32_SHIFT;
			
			setClactMatrix(add_obj->clact_w, &mat);	
		}
	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherSnowStorm(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;
	VecFx32 mat = getObjMat( p_obj );
	
	// tO`FbN
	switch(obj_w[3]){
	case 0:		// 

		// 
		mat.x += obj_w[4] << FX32_SHIFT;
		mat.y += obj_w[2] << FX32_SHIFT;

		// j邩`FbN
		if(obj_w[0]++ > obj_w[1]){
			// j
			obj_w[3] = 1;
		}
		// JE^œlω
		if((obj_w[0] % obj_w[5]) == 0){
			obj_w[4]--;
			
			
			if(obj_w[2] > 1){
				obj_w[2]--;
			}//*/
		}

		setClactMatrix(p_obj->clact_w, &mat);
	
		break;
	case 1:		// j
		destObj(p_obj);
		break;
	}		
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	BGgpǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSnowStormBG(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL* sys_w;			// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
	
		
	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 0, 16);
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowStorm;
		sys_w->objFade.objAddNum		= WEATHER_SSNOW_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SSNOW_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SSNOW_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SSNOW_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SSNOW_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SSNOW_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SSNOW_ADD;
		

		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(24,24,24), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SSNOW_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_SSNOW_FOG_START;	// tHOp
	
		
		sys_w->work[1] = 0;					// IuWFJE^
		sys_w->work[2] = 0;					// BGJE^
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
			if(sys_w->work[0] == 0){
//				G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 1, 16);
			}
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
//				G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 2, 16);
			}
		}
		break;

	case WEATHER_SEQ_NO_FADE:
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 2, 16);
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowStorm;
		sys_w->objFade.objAddNum		= WEATHER_SSNOW_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SSNOW_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SSNOW_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SSNOW_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SSNOW_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SSNOW_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SSNOW_ADD;
		

		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(24,24,24), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
	
		
		sys_w->work[1] = 0;					// IuWFJE^
		sys_w->work[2] = 0;					// BGJE^

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSnowStorm, WEATHER_SSNOW_NOFADE_OBJ_START_NUM, WEATHER_SSNOW_NOFADE_OBJ_START_DUST_NUM, WEATHER_SSNOW_NOFADE_OBJ_START_DUST_MOVE, objWeatherSnowStorm );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
		
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// o^
			addWeatherSnowStorm(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SSNOW_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_SSNOW_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SSNOW_ADD_END;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SSNOW_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_SSNOW_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
			if(sys_w->work[0] == 0){
//				G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 1, 16);
			}
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
//					G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 0, 16);
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SNOW_STORM_BG);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSnowStorm);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);

		// BGʂ΂ߏɓ
		sys_w->work[2] = (sys_w->work[2] + 6) % 256;
		G2_SetBG2Offset(sys_w->work[2],-sys_w->work[2]);

	}
}



//---------------------------------------------------------
//		
//=========================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherFog00(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_STSW_FOGFADE* sys_w;	// VXe[N
	int		fog_result;	// tHO
	sys_w = (WEATHER_STSW_FOGFADE*)sys_work->work;	// [N|C^Zbg
	

	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_FOG0_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_FOG_START;	// tHOp
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}	
		break;
	case WEATHER_SEQ_NO_FADE:
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_FOG0_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
		
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1)){		// tF[hUgȂΏI
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_DEST;
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_FOGS);
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherFog01(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_STSW_FOGFADE* sys_w;	// VXe[N
	int		fog_result;	// tHO
	sys_w = (WEATHER_STSW_FOGFADE*)sys_work->work;	// [N|C^Zbg
	
		
	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG1_SLOPE, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_FOG1_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_FOG_START;	// tHOp
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG1_SLOPE, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_FOG1_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
		
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1)){		// tF[hUgȂΏI
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_DEST;
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_FOGM);
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherFog02(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_STSW_FOGFADE* sys_w;	// VXe[N
	int		fog_result;	// tHO
	sys_w = (WEATHER_STSW_FOGFADE*)sys_work->work;	// [N|C^Zbg
	

	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_FOG2_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_FOG_START;	// tHOp
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_FOG2_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
		
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1)){		// tF[hUgȂΏI
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_DEST;
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_FOGL);
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherStorm(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL* sys_w;			// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
		

	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherStorm;
		sys_w->objFade.objAddNum		= WEATHER_STORM_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_STORM_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_STORM_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STORM_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_STORM_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_STORM_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STORM_ADD;
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_STORM_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,20,5), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_STORM_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_STORM_FOG_START;	// tHOp
		sys_w->work[1] = 0;			// IuWFNgǉJE^
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherStorm;
		sys_w->objFade.objAddNum		= WEATHER_STORM_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_STORM_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_STORM_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STORM_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_STORM_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_STORM_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STORM_ADD;
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_STORM_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,20,5), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		sys_w->work[1] = 0;			// IuWFNgǉJE^

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherStorm, WEATHER_STORM_NOFADE_OBJ_START_NUM, WEATHER_STORM_NOFADE_OBJ_START_DUST_NUM, WEATHER_STORM_NOFADE_OBJ_START_DUST_MOVE, objWeatherStorm );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// o^
			addWeatherStorm(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STORM_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_STORM_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STORM_ADD_END;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_STORM_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_STORM_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_STORM);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherStorm);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		JpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherStorm(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	int	wind;	// 
	int	rand;
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	s32* obj_w;	// IuWF[N
	int frame;	// t[
	
	static int	STORM_SPEED_X_TBL[WEATHER_STORM_SPEED_NUM] = {-3,-5,-5,-4,-5,-6,-10,-6};
	static int	STORM_SPEED_Y_TBL[WEATHER_STORM_SPEED_NUM] = { 2, 2, 2, 4, 4, 2, 2, 2};
	
	sys_w = (WEATHER_SYSW_NORMAL*)pWork->work;

	
	
	// ύXJEg
	sys_w->work[1] = (sys_w->work[1]+1) % (WEATHER_STORM_SPEED_CNG_NUM*WEATHER_STORM_SPEED_NUM);
		
	// ߂
	wind = sys_w->work[1] / WEATHER_STORM_SPEED_CNG_NUM;
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		// IuWF[N
		obj_w = add_obj->work;
		
		
		// ̈
		obj_w[0] = 0;			// JE^
		obj_w[1] = WEATHER_STORM_END_MIN + (gf_mtRand() % (WEATHER_STORM_END_MAX - WEATHER_STORM_END_MIN));	// IJE^
		
		frame = 3 - ((obj_w[1] - WEATHER_STORM_END_MIN) / WEATHER_STORM_END_DIV);	// ̎
		
		obj_w[2] = (STORM_SPEED_Y_TBL[wind]) * (frame+1);
		obj_w[4] = (STORM_SPEED_X_TBL[wind]) * (frame+1);
		obj_w[3] = 0;			// jAjtO
		obj_w[5] = STORM_SPEED_X_TBL[wind];	// Xs[hグĂl

		// قƂɂ܂ɃT{e
		rand = gf_mtRand() % 1000;
		if(rand == 777){
			frame = 4;
			obj_w[2] += obj_w[2] / 2;
		}
		
		CLACT_AnmFrameSet(add_obj->clact_w, frame);
		
		{
			VecFx32 mat;
			mat = getObjMat( add_obj );
			mat.x = WEATHER_STORM_START_X1 + (gf_mtRand() % WEATHER_STORM_START_X1_RAN);
			mat.x <<= FX32_SHIFT;
			mat.y = WEATHER_STORM_START_Y1_MIN + (gf_mtRand() % WEATHER_STORM_START_Y1_MAX);
			mat.y <<= FX32_SHIFT;
			setClactMatrix(add_obj->clact_w, &mat);
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherStorm(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;		// IuWF[N
	VecFx32 mat = getObjMat( p_obj );
	
	// tO`FbN
	switch(obj_w[3]){
	case 0:		// 

		// 
		mat.x += obj_w[4] << FX32_SHIFT;
		mat.y += obj_w[2] << FX32_SHIFT;

		if((obj_w[0] % WEATHER_STORM_SPEED_ADD_TMG) == 0){
			obj_w[4] += obj_w[5];
		}

		// j邩`FbN
		if(obj_w[0]++ > obj_w[1]){
			// j
			obj_w[3] = 1;
		}

		setClactMatrix(p_obj->clact_w, &mat);
			
		break;
	case 1:		// j
		destObj(p_obj);
		break;
	}		
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN		BGgp
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherStormBG(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	int		wind;		// e[u̒l
	int		scl_x, scl_y;// XN[W
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	static int	STORM_SPEED_X_TBL[WEATHER_STORM_SPEED_NUM] = {-3,-5,-5,-3,-5,-6,-10,-6};
	static int	STORM_SPEED_Y_TBL[WEATHER_STORM_SPEED_NUM] = { 2, 2, 2, 4, 4, 2, 2, 2};	
	
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg


	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		

		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherStorm;
		sys_w->objFade.objAddNum		= WEATHER_STORM_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_STORM_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_STORM_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STORM_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_STORM_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_STORM_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STORM_ADD;
	
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_STORM_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,20,5), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_STORM_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		
		sys_w->work[0] = WEATHER_STORM_FOG_START;	// tHOp
		sys_w->work[1] = 0;		// IuWFNgǉJE^
		sys_w->work[2] = 0;		// BGJE^
		sys_w->work[3] = 0;		// ̃Xs[h
		

		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			
			// fog
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;

				// BGON
				GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		

		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherStorm;
		sys_w->objFade.objAddNum		= WEATHER_STORM_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_STORM_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_STORM_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STORM_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_STORM_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_STORM_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STORM_ADD;
	
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_STORM_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,20,5), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );

		
		sys_w->work[1] = 0;		// IuWFNgǉJE^
		sys_w->work[2] = 0;		// BGJE^
		sys_w->work[3] = 0;		// ̃Xs[h
		
		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherStorm, WEATHER_STORM_NOFADE_OBJ_START_NUM, WEATHER_STORM_NOFADE_OBJ_START_DUST_NUM, WEATHER_STORM_NOFADE_OBJ_START_DUST_MOVE, objWeatherStorm );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;

		// BGON
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// e[u擾
			wind = sys_w->work[1] / WEATHER_STORM_SPEED_CNG_NUM;
			// ݒ肷
			sys_w->work[3] = STORM_SPEED_X_TBL[wind];
			
			// lƃIuWF̏oʂ𕗂̋ŕς
			if(sys_w->work[3] <= -WEATHER_STORM_STRONG_CHG){
				// o^
				addWeatherStorm(sys_work, sys_w->objFade.objAddNum*2);
			
			}else{
				// o^
				addWeatherStorm(sys_work, sys_w->objFade.objAddNum);
			}
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STORM_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_STORM_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STORM_ADD_END;
			
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_STORM_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_STORM_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
			// BGOFF
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		}

		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_STORM_BG);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherStorm);
		scrollObj(sys_work, &scl_x, &scl_y);
		drawObj(sys_work);

		// BGʂ΂ߏɓ
		sys_w->work[2] = (sys_w->work[2] + 6) % 256;
		G2_SetBG2Offset(sys_w->work[2]*2 - scl_x,-sys_w->work[2] + scl_y);
	}
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	kCǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSnowSML(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	int		wind;		// 
	int		scl_x, scl_y;// XN[W
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
	
		

	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowSML;
		sys_w->objFade.objAddNum		= WEATHER_SSNOW_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SSNOW_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SNOW_S_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_S_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SNOW_S_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SNOW_S_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_S_ADD;
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SNOW_S_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(24,24,24), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SNOW_S_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_SNOW_S_FOG_START;	// tHOp
		
		sys_w->work[1] = 0;				// IuWFJE^
		sys_w->work[2] = 0;				// BGJE^

		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s	
	
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{

			// fog
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
				// BGON
				GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowSML;
		sys_w->objFade.objAddNum		= WEATHER_SNOW_S_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SNOW_S_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SNOW_S_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_S_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SNOW_S_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SNOW_S_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_S_ADD;
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SNOW_S_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(24,24,24), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );

		sys_w->work[1] = 0;				// IuWFJE^
		sys_w->work[2] = 0;				// BGJE^


		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSnowSML, WEATHER_SNOW_S_NOFADE_OBJ_START_NUM, WEATHER_SNOW_S_NOFADE_OBJ_START_DUST_NUM, WEATHER_SNOW_S_NOFADE_OBJ_START_DUST_MOVE, objWeatherSnowSML );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		
		// BGON
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			wind = sys_w->work[1] / WEATHER_SNOW_S_ADD_SP_CHG_TMG;
			wind = WEATHER_SSNOW_SPEED_X_SML[wind];
			
			if(wind <= -WEATHER_SNOW_S_SP_UP){
				// o^
				addWeatherSnowSML(sys_work, sys_w->objFade.objAddNum*2);
			}else{
				// o^
				addWeatherSnowSML(sys_work, sys_w->objFade.objAddNum);
			}
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_S_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_SNOW_S_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_S_ADD_END;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SNOW_S_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_SNOW_S_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
			
			// BGOFF
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
		
			// fog
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊ǗႪSĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}		
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SNOW_SML);
		}	
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSnowSML);
//		scrollObj(sys_work, &scl_x, &scl_y);
		drawObj(sys_work);

		// BGʂ΂ߏɓ
		sys_w->work[2] = (sys_w->work[2] + 12) % 256;
		G2_SetBG2Offset(sys_w->work[2]*2,-sys_w->work[2]);

	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	kCIuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		JpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherSnowSML(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	int tbl_num;
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	s32* obj_w;	// IuWFNg[N
	int		frame;		// t[
	
	sys_w = (WEATHER_SYSW_NORMAL*)pWork->work;

		
	// ̒l߂
	sys_w->work[1]++;
	if(sys_w->work[1] >= (WEATHER_SNOW_S_ADD_SP_CHG_TMG  * WEATHER_SNOW_S_ADD_SP_TMG_NUM)){
		sys_w->work[1] = 0;
	}
	tbl_num = (sys_w->work[1] / WEATHER_SNOW_S_ADD_SP_CHG_TMG );

	
	// numIuWFNgo^
	for(i=0;i<num*4;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		obj_w = (s32*)add_obj->work;
		
		// ̈
		obj_w[0] = 0;			// JE^
		obj_w[1] = WEATHER_SNOW_S_END_MIN + (gf_mtRand() % (WEATHER_SNOW_S_END_MAX - WEATHER_SNOW_S_END_MIN));	// IJE^
		frame = gf_mtRand()%4;	// ̎
		CLACT_AnmFrameSet( add_obj->clact_w, frame );
		
		obj_w[4] = WEATHER_SSNOW_SPEED_X_SML[tbl_num] * ((frame)+1);
		obj_w[2] = WEATHER_SSNOW_SPEED_Y_SML[tbl_num] * ((frame)+1);	// ăXs[h
		obj_w[3] = 0;			// jAjtO
		if(frame == 3){
			obj_w[4] += WEATHER_SSNOW_SPEED_X_SML[tbl_num];
			obj_w[2] += WEATHER_SSNOW_SPEED_Y_SML[tbl_num];
		}
		obj_w[5] = WEATHER_SSNOW_SPEED_X_SML[tbl_num];
		
		// Wݒ
		{
			VecFx32 mat = getObjMat( add_obj );
			mat.x = WEATHER_SNOW_S_START_X + (gf_mtRand() % WEATHER_SNOW_S_START_X_RAN);
			mat.y = WEATHER_SNOW_S_START_Y_BASE + (gf_mtRand() % WEATHER_SNOW_S_START_Y_MAX);
			mat.x <<= FX32_SHIFT;
			mat.y <<= FX32_SHIFT;
			mat.z = 0;

			setClactMatrix(add_obj->clact_w, &mat);
		}
	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IuWFNg֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherSnowSML(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;
	VecFx32 mat = getObjMat( p_obj );
	
	// tO`FbN
	switch(obj_w[3]){
	case 0:		// 

		// 
		mat.x += obj_w[4] << FX32_SHIFT;
		mat.y += obj_w[2] << FX32_SHIFT;

		// j邩`FbN
		if(obj_w[0]++ > obj_w[1]){
			// j
			obj_w[3] = 1;
		}
		// JE^œlω
		if((obj_w[0] % WEATHER_SNOW_S_ADD_SP_TMG) == 0){
			obj_w[4] += obj_w[5];
			
			if(obj_w[2] > 1){
				obj_w[2]--;
			}
		}
	
		setClactMatrix( p_obj->clact_w, &mat );
		break;
	case 1:		// j
		destObj(p_obj);
		break;
	}		
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Xm[_XgǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSnowD(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL* sys_w;		// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
	

		
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 

	
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowD;
		sys_w->objFade.objAddNum		= WEATHER_SNOW_D_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SNOW_D_TIMING_MAX;// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SNOW_D_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_D_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SNOW_D_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SNOW_D_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_D_ADD;
		
		// tHOݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SNOW_D_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SNOW_D_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
			
		sys_w->work[0] = WEATHER_SNOW_D_FOG_START;	// tHOp
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s	
		

		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ

	
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSnowD;
		sys_w->objFade.objAddNum		= WEATHER_SNOW_D_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SNOW_D_TIMING_MIN;// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SNOW_D_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_D_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SNOW_D_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SNOW_D_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SNOW_D_ADD;
		
		// tHOݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_SNOW_D_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSnowD, WEATHER_SNOW_D_NOFADE_OBJ_START_NUM, WEATHER_SNOW_D_NOFADE_OBJ_START_DUST_NUM, WEATHER_SNOW_D_NOFADE_OBJ_START_DUST_MOVE, objWeatherSnowD );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){
			
			
			// _Ch_Xgo^
			addWeatherSnowD(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SNOW_D_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_SNOW_D_TIMING_ADD_END;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= -WEATHER_SNOW_D_ADD_END;
			
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_SNOW_D_FOG_TIMING_END;
			sys_w->work[0] = WEATHER_SNOW_S_FOG_START_END;	// tHOp	
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		

		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SNOW_D);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSnowD);
		
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);

	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Xm[_XgIuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		JpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherSnowD(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	int	rand;
	int sum_y;	// yWvZ
	int	big_d;	// 傫_Ch_Xgɂ邩`FbN
	int frame;	// t[
	VecFx32 mat;	// W
	s32* obj_w;	// IuWFNg[N
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		obj_w = (s32*)add_obj->work;
		
		obj_w[0] = 0;		// JE^
		obj_w[1] = WEATHER_SNOW_D_SPARK_NUM_MIN + (gf_mtRand() % WEATHER_SNOW_D_SPARK_NUM_RAN);
		rand = gf_mtRand() % 1000;

		
		if((rand % 2) == 0){			// ̈ړ̃vX}CiX
			obj_w[2] = 1;
		}else{
			obj_w[2] = -1;
		}
		obj_w[3] = 1;
		

		obj_w[4] = WEATHER_SNOW_D_SP_ADD_TMG_X_MIN + (gf_mtRand() % WEATHER_SNOW_D_SP_ADD_TMG_X_MAX);
		obj_w[5] = WEATHER_SNOW_D_SP_ADD_TMG_Y_MIN + (gf_mtRand() % WEATHER_SNOW_D_SP_ADD_TMG_Y_MAX);
		
	
		// o
		frame = gf_mtRand() % WEATHER_SNOW_D_SPARK_NO;
		
		// W
		{
			mat = getObjMat( add_obj );
			mat.x = WEATHER_SNOW_D_START_X_MIN + (gf_mtRand() % WEATHER_SNOW_D_START_X_DIS);
			mat.y = WEATHER_SNOW_D_START_Y + (gf_mtRand() % WEATHER_SNOW_D_START_Y_MAX);
			mat.x <<= FX32_SHIFT;
			mat.y <<= FX32_SHIFT;
			mat.z = 0;
			setClactMatrix( add_obj->clact_w, &mat );
			mat.x >>= FX32_SHIFT;
			mat.y >>= FX32_SHIFT;
		}
		
		
		// X̒lŋ߂
		sum_y = 50 - (mat.x/3);
		rand = 206 - (mat.x/3);
		if(rand < 0){
			rand*=-1;
			big_d = sum_y - (gf_mtRand()%rand);		
		}else{
			big_d = sum_y + (gf_mtRand()%rand);		
		}
		if((sum_y <= mat.y) &&
			(big_d >= mat.y)){
			
			obj_w[1] *= 2;
//			obj_w[6] = 4;		// _
		}else{
			// ɂ
			frame = gf_mtRand() % 4;
//			obj_w[6] = 1;		// 
		}
		CLACT_AnmFrameSet( add_obj->clact_w, frame );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Xm[_XgIuWFNg֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherSnowD(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	int		rand;
	s32* obj_w = (s32*)p_obj->work;
	VecFx32 mat = getObjMat( p_obj );


	// Ԃ
	obj_w[0]++;
	
	if((obj_w[0] % obj_w[4]) == 0){
		mat.x += obj_w[2] << FX32_SHIFT;
	}
	
	if((obj_w[0] % obj_w[5]) == 0){
		mat.y += obj_w[3] << FX32_SHIFT;
	}
	
	// j邩`FbN
	if(obj_w[0] >= obj_w[1]){
		destObj(p_obj);
		return ;
	}
		
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherRainbow(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	s32* sys_w;			// VXe[N

	sys_w = (s32*)sys_work->work;	// [N|C^Zbg
	

		
	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 

		sys_w[0] = 0;	// At@JE^
		sys_w[1] = 0;	// At@l
		
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 0, 16);
		G2_SetBG2Offset(0,32);
		
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	
	case WEATHER_SEQ_FADEIN:	// tF[hC

		sys_w[0]++;
		
		if(sys_w[0] >= 10){
			sys_w[0] = 0;
			sys_w[1]++;
		
//			G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, sys_w[1], 16);
			if(sys_w[1] >= 10){
				sys_w[2] = 10 + (gf_mtRand() % 20);	// lύX^C~O
				sys_w[3] = 5 + (gf_mtRand() % 3);		// At@𗎂Ƃx
				sys_w[4] = 1;							// At@炷
				
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
			
		}
		
		
		break;

	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ

		sys_w[0] = 0;	// At@JE^
		sys_w[1] = 10;	// At@l
		G2_SetBG2Offset(0,32);
		
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, sys_w[1], 16);
		
		sys_w[2] = 10 + (gf_mtRand() % 20);	// lύX^C~O
		sys_w[3] = 5 + (gf_mtRand() % 3);		// At@𗎂Ƃx
		sys_w[4] = 1;							// At@炷
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	
	case WEATHER_SEQ_MAIN:		// C
		sys_w[0]++;
		

		if(sys_w[0] >= sys_w[2]){
			sys_w[0] = 0;

			if(sys_w[4] == 1){
				sys_w[1]--;
				if(sys_w[1] <= sys_w[3]){
					sys_w[2] = 10 + (gf_mtRand() % 15);		// lύX^C~O
					sys_w[3] = 7 + (gf_mtRand() % 3);		// At@𗎂Ƃx
					sys_w[4] = 0;							// At@炷
				}
			}else{
				sys_w[1]++;
				if(sys_w[1] >= sys_w[3]){
					sys_w[2] = 10 + (gf_mtRand() % 20);	// lύX^C~O
					sys_w[3] = 5 + (gf_mtRand() % 3);		// At@𗎂Ƃx
					sys_w[4] = 1;							// At@炷
				}
			}
		}
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, sys_w[1], 16);
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg
		sys_w[0]++;
		
		if(sys_w[0] >= 10){
			sys_w[0] = 0;
			sys_w[1]--;
		
//			G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, sys_w[1], 16);
			if(sys_w[1] <= 0){
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_DEST;
			}
			
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_RAINBOW);
		}	
		break;

	default:
		break;
	}
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	JǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSTRain(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
	

	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSTRain;
		sys_w->objFade.objAddNum		= WEATHER_STRAIN_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_STRAIN_TIMING_MAX;// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_STRAIN_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STRAIN_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_STRAIN_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_STRAIN_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STRAIN_ADD;
		

		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_STRAIN_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_STRAIN_FOG_START;	// tHOp
		sys_w->work[1] = 0;
		sys_w->work[2] = 0;							// JE^
/*
		// 𔭓
		ControlWeatherSys( sys_work->pWSysCont, WEATHER_SYS_INIT, WEATHER_SYS_SPARK );
		ControlWeatherSys( sys_work->pWSysCont, WEATHER_SYS_START_NOFADE, WEATHER_SYS_SPARK );
//*/
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s	
	
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
			
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSTRain;
		sys_w->objFade.objAddNum		= WEATHER_STRAIN_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_STRAIN_TIMING_MIN;// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_STRAIN_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STRAIN_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_STRAIN_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_STRAIN_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STRAIN_ADD;
		

		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(26,26,26), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );

		sys_w->work[1] = 0;
		sys_w->work[2] = 0;							// JE^

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSTRain, WEATHER_STRAIN_NOFADE_OBJ_START_NUM, WEATHER_STRAIN_NOFADE_OBJ_START_DUST_NUM, WEATHER_STRAIN_NOFADE_OBJ_START_DUST_MOVE, objWeatherSTRain );

		// 𔭓
/*		ControlWeatherSys( sys_work->pWSysCont, WEATHER_SYS_INIT, WEATHER_SYS_SPARK );
		ControlWeatherSys( sys_work->pWSysCont, WEATHER_SYS_START_NOFADE, WEATHER_SYS_SPARK );//*/
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		sys_w->work[2] = (sys_w->work[2] + 1) % (WEATHER_STRAIN_OBJ_MUL_CHG*WEATHER_STRAIN_OBJ_MUL_NUM);		// Jo^ύXJE^
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){
							
			// Jo^
			addWeatherSTRain(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_STRAIN_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_STRAIN_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_STRAIN_ADD_END;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_STRAIN_FOG_TIMING_END;
			sys_w->work[0] = WEATHER_STRAIN_FOG_START_END;	// tHOp

			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I


			// I
/*			ControlWeatherSys( sys_work->pWSysCont, WEATHER_SYS_END, WEATHER_SYS_SPARK );//*/
		}

		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
			
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_STRAIN);

			// I
/*			ControlWeatherSys( sys_work->pWSysCont, WEATHER_SYS_DEST, WEATHER_SYS_SPARK );//*/
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSTRain);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
		
	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JIuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		JpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherSTRain(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	int	err;	// ␳l
	s32* obj_w;	// IuWFNg[N
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	int speed_m;	// Xs[hɂle[u̗vf
	int frame;		// t[
	static int WEATHER_STRAIN_OBJ_MUL[ WEATHER_STRAIN_OBJ_MUL_NUM ] = {100, 100, 200, 100, 300};

	sys_w = (WEATHER_SYSW_NORMAL*)pWork->work;
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}
		obj_w = (s32*)add_obj->work;
		
		// ̈
		obj_w[0] = 0;			// JE^
		frame = gf_mtRand()%3;	// J̎
		CLACT_AnmFrameSet( add_obj->clact_w, frame );

		obj_w[4] = WEATHER_STRAIN_SPEED_X * (frame+1);
		obj_w[2] = WEATHER_STRAIN_SPEED_Y * (frame+1);
		obj_w[4] *= WEATHER_STRAIN_OBJ_MUL[sys_w->work[2]/WEATHER_STRAIN_OBJ_MUL_CHG];
		obj_w[2] *= WEATHER_STRAIN_OBJ_MUL[sys_w->work[2]/WEATHER_STRAIN_OBJ_MUL_CHG];
		obj_w[4] /= 100;
		obj_w[2] /= 100;
		
		obj_w[3] = 0;			// jAjtO
		
		// j^C~O	Sʂ͈̔͂̒l
		obj_w[1] = WEATHER_STRAIN_END_MIN  + (gf_mtRand() % WEATHER_STRAIN_END_MAX);
		obj_w[1] *= 100;
		obj_w[1] /= WEATHER_STRAIN_OBJ_MUL[sys_w->work[2]/WEATHER_STRAIN_OBJ_MUL_CHG];
		
		// Wݒ
		{
			VecFx32 mat = getObjMat( add_obj );
			mat.x = WEATHER_STRAIN_START_X + (gf_mtRand() % WEATHER_STRAIN_START_X_MAX);
			mat.y = WEATHER_STRAIN_START_Y + (gf_mtRand() % WEATHER_STRAIN_START_Y_MAX);
			mat.z = 0;

			mat.x <<= FX32_SHIFT;
			mat.y <<= FX32_SHIFT;
			setClactMatrix(add_obj->clact_w, &mat);
		}
		
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	JIuWFNg֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherSTRain(WAETHER_OBJ_DATA* work)
{
	int i;
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;
	VecFx32 mat = getObjMat( p_obj );
	
	// tO`FbN
	switch(obj_w[3]){
	case 0:		// 
		// ĴƂ邽1t[2̕`sAPDT̈ʒu
		for(i=0;i<2;i++){
			// 
			mat.x += obj_w[4] << FX32_SHIFT;
			mat.y += obj_w[2] << FX32_SHIFT;
		
			// j邩`FbN
			if(obj_w[0]++ > obj_w[1]){
				// Aj[V邩`FbN
				if((gf_mtRand() % 10) < 5){		// 7/10͔j
					// j
					obj_w[3] = 2;
				}else{
				
					// jAj
					obj_w[3] = 1;		
					obj_w[0] = 4;			// jAjJE^
					CLACT_AnmFrameSet(p_obj->clact_w, 3);// jAj̊G
				}
			}
			setClactMatrix(p_obj->clact_w, &mat);
		}
		break;
	case 1:		// jAj
		if(obj_w[0]-- <= 0){
			obj_w[3] = 2;		// j
		}
		break;

	case 2:		// j
		destObj(p_obj);
		break;
	}		
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ΎRDǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherVolcano(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	int		tmp_y;		// yWۑp
	int		scl_x, scl_y;	// XN[W
	short		sc_w_x, sc_w_y;	// XN[[N
	WEATHER_SYSW_NORMAL* sys_w;			// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
	


	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherVolcano;
		sys_w->objFade.objAddNum		= 1;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_VOLCANO_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_VOLCANO_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_VOLCANO_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_VOLCANO_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_VOLCANO_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_VOLCANO_ADD;
		
		sys_w->work[1] = 0;						// ΎRDP񉺂܂ōs̃tO
		sys_w->work[2] = 0;						// BGW	16bit X	16bit Y
		sys_w->work[4] = 0;						// BGJE^
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_VOLCANO_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(20,20,14), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_VOLCANO_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_VOLCANO_FOG_START;	// tHOp
		
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			// FOG
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
				// BGON
				GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherVolcano;
		sys_w->objFade.objAddNum		= WEATHER_VOLCANO_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_VOLCANO_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_VOLCANO_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_VOLCANO_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_VOLCANO_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_VOLCANO_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_VOLCANO_ADD;
		
		sys_w->work[1] = 0;						// ΎRDP񉺂܂ōs̃tO
		sys_w->work[2] = 0;						// BGW	16bit X	16bit Y
		sys_w->work[4] = 0;						// BGJE^
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_VOLCANO_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(20,20,14), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherVolcano, WEATHER_VOLCANO_NOFADE_OBJ_START_NUM, WEATHER_VOLCANO_NOFADE_OBJ_START_DUST_NUM, WEATHER_VOLCANO_NOFADE_OBJ_START_DUST_MOVE, objWeatherVolcano );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;

		// BGON
		GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_ON );
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// ΎRDo^
			addWeatherVolcano(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_VOLCANO_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_VOLCANO_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= -1;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_VOLCANO_FOG_TIMING_END;
			sys_w->work[0] = WEATHER_VOLCANO_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
			
			// BGOFF
			GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG2, VISIBLE_OFF );
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			// tHO
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_VOLCANO);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherVolcano);
		scrollObj(sys_work, &scl_x, &scl_y);
		drawObj(sys_work);


		// BGXN[
		sc_w_x = sys_w->work[2] >> 16;	// XN[Wo
		sc_w_y = sys_w->work[2] & 0xffff;
		sc_w_x += scl_x;
		sc_w_y -= scl_y*5;
		if(sc_w_x < 0){
			sc_w_x += 256;
		}else{
			if(sc_w_x >= 256){
				sc_w_x -= 256;
			}
		}
		if(sc_w_y < 0){
			sc_w_y += 2048;
		}

		// BGʂ͈̉Ԋuł炷i炿\j
		sys_w->work[4]+=2;
		if(sys_w->work[4] > 60){
			sys_w->work[4] = 0;

			sc_w_x = (sc_w_x + 32) % 256;
		}
		
		// BGʂ΂ߏɓ
		sc_w_y = (sc_w_y + 2) % 2048;
		G2_SetBG2Offset(sc_w_x, -sc_w_y/5);
		sys_w->work[2] = sc_w_x << 16;	// XN[Wi[
		sys_w->work[2] |= sc_w_y & 0xffff;
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	ΎRDIuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 *	e
 *		numIuWFNgo^
 *		ΎRDpɃ[N̈
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherVolcano(WEATHER_SYS_WORK* pWork, int num)
{
	int i;		// [vp
	int rand;	// 
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	WEATHER_SYSW_NORMAL* sys_w;	// VXe[N
	int frame;	// t[
	s32* obj_w;	// IuWFNg[N
	sys_w = pWork->work;


	if(sys_w->work[1] == 1){
		num *= 2;
	}
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		obj_w = (s32*)add_obj->work;
		
		frame = gf_mtRand() % WEATHER_VOLCANO_OBJ_NUM;
		CLACT_AnmFrameSet( add_obj->clact_w, frame );
		
		obj_w[4] = 10;	// ̓ύXJE^	
		obj_w[5] = 0;
		
		rand = gf_mtRand();
	
		// Xs[h
		if((rand % 2) == 0){
			obj_w[1] = 1;
		}else{
			obj_w[1] = -1;
		}
		obj_w[3] = WEATHER_VOLCANO_ADD_TMG_Y_BASE + (gf_mtRand() % WEATHER_VOLCANO_ADD_TMG_Y_RAN);

		obj_w[0] = (s32)&sys_w->work[1];		// ܂ōstO𗧂Ă|C^ۑ
		
		// Wݒ
		{
			VecFx32 mat = getObjMat( add_obj );
			mat.x = WEATHER_VOLCANO_START_X_BASE + (gf_mtRand() % WEATHER_VOLCANO_START_X_MAX);
		
			if((sys_w->work[1] == 1) &&
				(i >= (num /2)) ){	// o
				mat.y = -40 - (gf_mtRand() % 20);
			}else{
				mat.y = -8 - (gf_mtRand() % 20);
			}
			mat.x <<= FX32_SHIFT;
			mat.y <<= FX32_SHIFT;
			mat.z = 0;

			setClactMatrix( add_obj->clact_w, &mat );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ΎRD֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherVolcano(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;
	VecFx32 mat = getObjMat( p_obj );

	// 
	if((obj_w[5] >= obj_w[3])){
		mat.y += FX32_ONE;
		obj_w[5] = 0;

		setClactMatrix( p_obj->clact_w, &mat );
	} 
	
	obj_w[5]++;

	mat.y >>= FX32_SHIFT;

	
	// j][ɂj  
	if(((mat.y < -284) && (mat.y > -296)) ||
		((mat.y > 212) && (mat.y < 232))){
		*((s32*)obj_w[0]) = 1;
		destObj(p_obj);
		return ;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSpark(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	s32* sys_w;			// VXe[N
	int	num;
	int rand;
	
	sys_w = (s32*)sys_work->work;	// [N|C^Zbg
	

	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
	case WEATHER_SEQ_FADEIN:	// tF[hC
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		
		// Ɨ̈̏
		sys_w[0] = 0;		// CgtF[hJE^
		sys_w[4] = 0;
		sys_w[1] = 0;
//		G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, 0,31);
		

		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		if(sys_w[4] >= 0){
			sys_w[4]--;
		}else{
			switch(sys_w[1]){
			case 0:
				sys_w[1] = 1;		// CgtF[h
				sys_w[5] = 0;
				sys_w[6] = WEATHER_SPARK_POWER_MIN+(gf_mtRand() % WEATHER_SPARK_POWER_RAN);	// ̑₷l߂
				sys_w[7] = 0;		// ̃At@

				// _ł̗ɂ邩@ɂ邩`FbN
				if((gf_mtRand()%3) != 0){
					sys_w[2] = WEATHER_SPARK_SUB_NUM;
				}else{
					sys_w[2] = WEATHER_SPARK_SUB_NUM_HIGH;
				}
				break;
			case 1:
				sys_w[5]++;
				sys_w[7] += sys_w[6];	
				if(sys_w[5] >= WEATHER_SPARK_NUM){	// I`FbN
					sys_w[1] = 2;		// Â
				}
//				G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, sys_w[7]/100,31);
				break;
			case 2:
				sys_w[7] -= sys_w[2];	
				if(sys_w[7] <= 0){	// I`FbN
					sys_w[1] = 0;
					sys_w[7] = 0;

					// ̗܂ł̃JE^ݒ
					// ̂Ƃ͂xo
					if(sys_w[2] == WEATHER_SPARK_SUB_NUM_HIGH){
						sys_w[4] = (gf_mtRand() % WEATHER_SPARK_SPARK_RAN_HIGH);
					}else{
						sys_w[4] = ((sys_w[6] * WEATHER_SPARK_SPARK_MUL)/100) + (gf_mtRand()%WEATHER_SPARK_SPARK_RAN);
					}
				}
//				G2_SetBlendAlpha(GX_BLEND_PLANEMASK_BG2, GX_BLEND_PLANEMASK_BG0, sys_w[7]/100,31);
				break;
			}
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
				
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg
		
		sys_work->Sequence = WEATHER_SEQ_DEST;
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SPARK);
		}
		break;

	default:
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	CǗ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherSpirit(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_OBJFADE* sys_w;			// VXe[N
	int		result;		// ֐
	
	sys_w = (WEATHER_SYSW_OBJFADE*)sys_work->work;	// [N|C^Zbg
	

			
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSpirit;
		sys_w->objFade.objAddNum		= 1;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SPIRIT_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SPIRIT_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SPIRIT_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SPIRIT_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SPIRIT_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SPIRIT_ADD;
		
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		// ^C~OŏɂȂ烁C
		if(result == 3){		// tF[hUgȂ΃C
			// V[PXύX
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherSpirit;
		sys_w->objFade.objAddNum		= WEATHER_SPIRIT_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;	// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_SPIRIT_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;	// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_SPIRIT_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SPIRIT_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_SPIRIT_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_SPIRIT_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SPIRIT_ADD;

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherSpirit, WEATHER_SPIRIT_NOFADE_OBJ_START_NUM, WEATHER_SPIRIT_NOFADE_OBJ_START_DUST_NUM, WEATHER_SPIRIT_NOFADE_OBJ_START_DUST_MOVE, objWeatherSpirit );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// o^
			addWeatherSpirit(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_SPIRIT_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_SPIRIT_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_SPIRIT_ADD_END;
			
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}

		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s

		if(result == 3){
			// o^OɂȂI邩`FbN
			// ̊Ǘ邠߂SĔjꂽI
			if(sys_work->Dummy.pNext == &sys_work->Dummy){
				
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_DEST;
			
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_SPIRIT);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherSpirit);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	CIuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherSpirit(WEATHER_SYS_WORK* pWork, int num)
{
	int i;			// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	s32* obj_w;		// IuWFNg[N
	int obj_num;	// IuWFNg
	int frame;		// t[
	VecFx32 mat;	// W

		
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*8);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		obj_w = (s32*)add_obj->work;

		// ނ߂
		frame = gf_mtRand() % WEATHER_SPIRIT_OBJ_NUM;
		CLACT_AnmFrameSet( add_obj->clact_w, frame );

		// ނJE^Al߂
		obj_num = frame / WEATHER_SPIRIT_BIG_DIV;	// IuWF̑傫idx
		obj_num++;	// 0->1ɂ
		obj_w[0] = WEATHER_SPIRIT_SHIFT_UP+(gf_mtRand()%WEATHER_SPIRIT_SHIFT_UP_RAN);	// ͉JE^
		obj_w[0] *= obj_num;
		obj_w[1] = WEATHER_SPIRIT_ADD_SPEED / obj_num;	// l//*/
		obj_w[2] = 0;									// ̑x

		// ݂ɉɓ
		obj_w[3] = gf_mtRand() % 2;		// 0:E	1:
		obj_w[4] = WEATHER_SPIRIT_S_MOVE_TMG;	// ^C~O

		
		// W
		switch(obj_num){
		case 1:
		case 2:
				
			mat.x = WEATHER_SPIRIT_MAT_X_MIN + (gf_mtRand() % WEATHER_SPIRIT_MAT_X_RAN);
			mat.y = WEATHER_SPIRIT_MAT_Y_S_MIN + (gf_mtRand() % WEATHER_SPIRIT_MAT_Y_S_RAN);
			break;
		case 3:
			mat.x = WEATHER_SPIRIT_MAT_X_MIN + (gf_mtRand() % WEATHER_SPIRIT_MAT_X_RAN);
			mat.y = WEATHER_SPIRIT_MAT_Y_M_MIN + (gf_mtRand() % WEATHER_SPIRIT_MAT_Y_M_RAN);
			break;
		case 4:
			mat.x = WEATHER_SPIRIT_MAT_X_MIN + (gf_mtRand() % WEATHER_SPIRIT_MAT_X_RAN);
			mat.y = WEATHER_SPIRIT_MAT_Y_L_MIN + (gf_mtRand() % WEATHER_SPIRIT_MAT_Y_L_RAN);
			break;
		}
		mat.z = 0;
		mat.x <<= FX32_SHIFT;
		mat.y <<= FX32_SHIFT;
		setClactMatrix( add_obj->clact_w, &mat );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	C֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherSpirit(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;
	VecFx32 mat = getObjMat( p_obj );

	// Ȃړ
	obj_w[2] += obj_w[1];
	if(obj_w[0] > 0){
		obj_w[0]--;		// ͉JEg	0ɂȂ瑬xQ

		mat.y -= (obj_w[2]/100) << FX32_SHIFT;
	}else{
		mat.y -= (obj_w[2]/50) << FX32_SHIFT;
	}

	// ݂ɗh
	obj_w[4]--;
	if(obj_w[4] <= 0){
		obj_w[4] = WEATHER_SPIRIT_S_MOVE_TMG;

		if(obj_w[3] == 0){
			mat.x += WEATHER_SPIRIT_S_MOVE_NUM << FX32_SHIFT;
			obj_w[3] = 1;
		}else{
			mat.x -= WEATHER_SPIRIT_S_MOVE_NUM << FX32_SHIFT;
			obj_w[3] = 0;
		}
	}

	setClactMatrix( p_obj->clact_w, &mat );
	

	//@܂ōsI
	if( (mat.y >> FX32_SHIFT) <= -16){
		destObj(p_obj);
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	_Ǘ^XN
 *
 *@param	tcb		̃^XN
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void contWeatherMystic(TCB_PTR tcb, void* work)
{
	WEATHER_SYS_WORK* sys_work = (WEATHER_SYS_WORK*)work;
	int		i;			// [vp
	WEATHER_SYSW_NORMAL* sys_w;			// VXe[N
	int		result;		// ֐
	int		fog_result;	// tHO
	sys_w = (WEATHER_SYSW_NORMAL*)sys_work->work;	// [N|C^Zbg
		

		
	
	// V[PX`FbN
	switch(sys_work->Sequence){
	case WEATHER_SEQ_INIT:		// 
		
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherMystic;
		sys_w->objFade.objAddNum		= WEATHER_MYSTIC_ADD_START;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_MYSTIC_TIMING_MAX;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_MYSTIC_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_MYSTIC_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_MYSTIC_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_MYSTIC_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_MYSTIC_ADD;
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_MYSTIC_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(31,31,31), 0);	// tHOJ[
		for(i=0;i<32;i++){						// tHOe[u
			sys_w->fogFade.fog_tbl[i] = 0;
		}
		SetFogTbl(sys_w->fogFade.Fog, sys_w->fogFade.fog_tbl);				// tHOe[u
		sys_w->fogFade.fogDepth		= 127;
		sys_w->fogFade.fogCount		= 0;
		sys_w->fogFade.FOG_CHG_TMG	= WEATHER_MYSTIC_FOG_TIMING;
		sys_w->fogFade.FOG_TBL_SUM	= 1;
		sys_w->work[0] = WEATHER_MYSTIC_FOG_START;	// tHOp
		
		sys_w->work[1] = 0;			// IuWFNgǉJE^
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_FADEIN;
		break;
	case WEATHER_SEQ_FADEIN:	// tF[hC
		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
			fog_result = weatherSysFogFade(&sys_w->fogFade);
			
			// ^C~OŏɂȂ烁C
			if((fog_result == 1) && (result == 3)){		// tF[hUgȂ΃C
				// V[PXύX
				sys_work->Sequence = WEATHER_SEQ_MAIN;
			}
		}
		break;
	case WEATHER_SEQ_NO_FADE:	// tF[hCȂ
		
		
		// Ɨ̈̏
		sys_w->objFade.pWork			= sys_work;
		sys_w->objFade.add				= addWeatherMystic;
		sys_w->objFade.objAddNum		= WEATHER_MYSTIC_ADD_MAIN;	// objo^
		sys_w->objFade.objAddTmg		= 0;						// o^JE^	
		sys_w->objFade.objAddTmgMax		= WEATHER_MYSTIC_TIMING_MIN;	// o^^C~O
		sys_w->objFade.objAddNumSum		= 0;						// o^ύXJE^
		sys_w->objFade.OBJ_ADD_NUM_END	= WEATHER_MYSTIC_ADD_MAIN;
		sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_MYSTIC_TIMING_MIN;
		sys_w->objFade.OBJ_ADD_TMG_SUM	= -WEATHER_MYSTIC_TIMING_ADD;
		sys_w->objFade.OBJ_ADD_NUM_SUM_TMG = WEATHER_MYSTIC_ADD_TIMING;
		sys_w->objFade.OBJ_ADD_NUM_SUM	= WEATHER_MYSTIC_ADD;
		
		// tHO̐ݒ
		// f[^ݒ
		sys_w->fogFade.Fog = sys_work->pWSysCont->fsys->fog_data;		// tHOۑ
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_ALL, TRUE, GX_FOGBLEND_COLOR_ALPHA, WEATHER_FOG_SLOPE_DEFAULT, WEATHER_FOG_DEPTH_DEFAULT + WEATHER_MYSTIC_FOG_OFS);		// tHOf[^
		SetFogColor(sys_w->fogFade.Fog, FOG_SYS_ALL, GX_RGB(31,31,31), 0);	// tHOJ[
		// e[uf[^쐬Ĕf
		weatherSysFogSet( &sys_w->fogFade );
		
		sys_w->work[1] = 0;			// IuWFNgǉJE^

		// IuWFNgU΂
		weatherDustObj( sys_work, addWeatherMystic, WEATHER_MYSTIC_NOFADE_OBJ_START_NUM, WEATHER_MYSTIC_NOFADE_OBJ_START_DUST_NUM, WEATHER_MYSTIC_NOFADE_OBJ_START_DUST_MOVE, objWeatherMystic );
		
		// V[PXύX
		sys_work->Sequence = WEATHER_SEQ_MAIN;
		break;
	case WEATHER_SEQ_MAIN:		// C
		
		// JE^0ɂȂJo^
		if(sys_w->objFade.objAddTmg-- <= 0){

			// _o^
			addWeatherMystic(sys_work, sys_w->objFade.objAddNum);
	
			sys_w->objFade.objAddTmg = sys_w->objFade.objAddTmgMax;	// o^^C~OZbg	
		}
		// I`FbN
		if(sys_work->ContFlag == WEATHER_SYS_END){
			// obj
			sys_w->objFade.OBJ_ADD_NUM_END	= 0;
			sys_w->objFade.OBJ_ADD_TMG_END	= WEATHER_MYSTIC_TIMING_MAX;
			sys_w->objFade.OBJ_ADD_TMG_SUM	= WEATHER_MYSTIC_TIMING_ADD;
			sys_w->objFade.OBJ_ADD_NUM_SUM	= -WEATHER_MYSTIC_ADD_END;
			
			// fog
			sys_w->fogFade.fogDepth		= 127;
			sys_w->fogFade.fogCount		= 0;
			sys_w->fogFade.FOG_CHG_TMG	= WEATHER_MYSTIC_FOG_TIMING_END;
			sys_w->fogFade.FOG_TBL_SUM	= -1;
			sys_w->work[0] = WEATHER_MYSTIC_FOG_START_END;	// tHOp
			sys_work->Sequence = WEATHER_SEQ_FADEOUT;		// I
		}
		break;
	case WEATHER_SEQ_FADEOUT:	// tF[hAEg

		// IuWFNgtF[h
		result = weatherSysObjFade(&sys_w->objFade);	// s
		
		// tHO
		if(sys_w->work[0] > 0){
			sys_w->work[0]--;			// [N6OɂȂtHO𓮂
		}else{
		
			fog_result = weatherSysFogFade(&sys_w->fogFade);
		
			if((fog_result == 1) && (result == 3)){
				// o^OɂȂI邩`FbN
				// ̊Ǘ邠߂SĔjꂽI
				if(sys_work->Dummy.pNext == &sys_work->Dummy){
					
					// V[PXύX
					sys_work->Sequence = WEATHER_SEQ_DEST;
				}
			}
		}
		break;

	case WEATHER_SEQ_DEST:		// ^XNj
		SetFogData(sys_w->fogFade.Fog, FOG_SYS_FLAG, FALSE, 0,0,0);	// tHOIt
		{
			WEATHER_SYS_CONTROL* cont = (WEATHER_SYS_CONTROL*)sys_work->pWSysCont;
			stopWeatherWork(cont, WEATHER_SYS_MYSTIC);
		}
		break;

	case WEATHER_SEQ_DEBUG:
		drawObj(sys_work);

		if( sys.trg & PAD_BUTTON_L ){
			sys_work->Sequence = WEATHER_SEQ_MAIN;
		}
		return ;

	default:
		break;
	}

	// AjȊÔƂ͓֐𓮂
	if((sys_work->Sequence != WEATHER_SEQ_DEST) &&
		(sys_work->Sequence != WEATHER_SEQ_INIT) ){

		moveFuncObj(&sys_work->Dummy, objWeatherMystic);
		scrollObj(sys_work, NULL, NULL);
		drawObj(sys_work);
	}
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	_IuWFNgo^֐
 *
 *@param	pWork		o^IuWF̊Ǘ֐[N
 *@param	num			o^鐔
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void addWeatherMystic(WEATHER_SYS_WORK* pWork, int num)
{
	int i;			// [vp
	WAETHER_OBJ_DATA* add_obj;		// o^IuWF
	s32* obj_w;		// IuWFNg[N
	int obj_num;	// IuWFNg̑傫Ă悤
	int ch_num;		// IuWFNg̑傫Ă悤
	int frame;		// t[
	VecFx32 mat;	// W
	
	
	// numIuWFNgo^
	for(i=0;i<num;i++){

		add_obj = addObj(pWork, sizeof(s32)*10);		// o^
		if(add_obj == NULL){			// sI
			break;
		}

		obj_w = (s32*)add_obj->work;
		// 傫߂
		obj_num = gf_mtRand()%WEATHER_MYSTIC_RAN;
		ch_num = 0;
		for(i=0;i<WEATHER_MYSTIC_NUM;i++){
			switch(i){
			case 0:
				ch_num += WEATHER_MYSTIC_RAN_0;
				break;
			case 1:
				ch_num += WEATHER_MYSTIC_RAN_1;
				break;
			case 2:
				ch_num += WEATHER_MYSTIC_RAN_2;
				break;
			case 3:
				ch_num += WEATHER_MYSTIC_RAN_3;
				break;
			}
			
			if(obj_num < ch_num){
				frame = i;
				break;
			}	
		}
		CLACT_AnmFrameSet( add_obj->clact_w, frame );
	 	
		// jJE^
		obj_w[0] = WEATHER_MYSTIC_DES_TM+(gf_mtRand()%WEATHER_MYSTIC_DES_RAN);
		
		// Xs[h߂
		obj_w[2] = WEATHER_MYSTIC_M_Y + (WEATHER_MYSTIC_M_Y_MUL*frame);

		// tړiVRɔł悤Ɍ邽߁Asin.cosœj
		obj_w[4] = gf_mtRand() % 360;
		obj_w[5] = gf_mtRand() % 360;
		obj_w[6] = gf_mtRand() % WEATHER_MYSTIC_MH_X;
		obj_w[7] = gf_mtRand() % WEATHER_MYSTIC_MH_Y;
		obj_w[8] = WEATHER_MYSTIC_MH_COUNT + (gf_mtRand() % WEATHER_MYSTIC_MH_COUNT_RAN);
		
		// W߂
		obj_w[1] = 0;
		obj_w[3] = 0;
		mat.x = WEATHER_MYSTIC_MAT_X+(gf_mtRand()%WEAHTER_MYSTIC_MAT_X_RAN);	// XW
		mat.y = WEAHTER_MYSTIC_MAT_Y+(WEATHER_MYSTIC_MAT_Y_MUL*frame);
		mat.y += (gf_mtRand()%WEAHTER_MYSTIC_MAT_Y_RAN);
		mat.z = 0;
		mat.x <<= FX32_SHIFT;
		mat.y <<= FX32_SHIFT;

		setClactMatrix( add_obj->clact_w, &mat );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_铮֐
 *
 *@param	work	[N̈
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void objWeatherMystic(WAETHER_OBJ_DATA* work)
{
	WAETHER_OBJ_DATA* p_obj = (WAETHER_OBJ_DATA*)work;
	s32* obj_w = (s32*)p_obj->work;
	int hm_num;		// ⏕ړl
	fx32 hm_par;	// ړ␳l̒lɂl
	int sc_ch;		// XN[p
	VecFx32 mat = getObjMat( p_obj );

	mat.x >>= FX32_SHIFT;
	mat.y >>= FX32_SHIFT;

	// XN[`FbN	XN[œWeWɂ
	sc_ch = obj_w[1] % 100;
	obj_w[1] = mat.y * 100;
	obj_w[1] += sc_ch;
	sc_ch = obj_w[3] % 100;
	obj_w[3] = mat.x * 100;
	obj_w[3] += sc_ch;
	
	// ړ
	obj_w[1] -= obj_w[2];
	
	// ⏕ړ
	hm_par = FX_SinIdx(obj_w[4]*182);
	hm_num = FX_Mul(hm_par, obj_w[6]<<FX32_SHIFT) >> FX32_SHIFT;
	obj_w[3] += hm_num;		// XW␳
	hm_par = FX_SinIdx(obj_w[5]*182);
	hm_num = FX_Mul(hm_par, obj_w[7]<<FX32_SHIFT) >> FX32_SHIFT;
	obj_w[1] += hm_num;		// YW␳
	obj_w[4] = (obj_w[4]+obj_w[8]) % 360;	// pxύX
	obj_w[5] = (obj_w[5]+obj_w[8]) % 360;	// pxύX
	
	// Wݒ
	mat.y = obj_w[1]/100;
	mat.x = obj_w[3]/100;


	mat.x <<= FX32_SHIFT;
	mat.y <<= FX32_SHIFT;
	setClactMatrix( p_obj->clact_w, &mat );
	
	// j
	if(obj_w[0] <= 0){
		destObj(p_obj);
	}else{
		obj_w[0]--;
	}

}
