//=============================================================================
/**
 * @file	worldmap.c
 * @bfief	[h}bv\z
 * @author	saitou, mori GAME FREAK inc.
 *
 *
 */
//=============================================================================
// GAɃeNX`t@C؂ւ̂ŁAGAJڂۂ
// eNX`t@CGAԍ琶ēǂݍޏ̒ǉXs


#include "common.h"
#include "height_def.h"
#include "calctool.h"

#include "worldmap.h"

#include "fieldsys.h"
#include "debug_saito.h"

#include "mapdefine.h"
#include "zonedata.h"
#include "mapdefine.h"
#include "system/arc_tool.h"

#include "include/field/field_matrix.h"


//===========================================================================
// 萔
//===========================================================================
///#define	OLD_MAP_MATRIX
#define MAP_MATRIX_WIDTH_MAX	(30)
#define MAP_MATRIX_HEIGHT_MAX	(30)
#define MAP_MATRIX_MAX			(MAP_MATRIX_WIDTH_MAX*MAP_MATRIX_HEIGHT_MAX)
#define MAP_MATRIX_PREFIX_MAX	(16)

//===========================================================================
// \̒`
//===========================================================================
//------------------------------------------------------------------
///	}bv}gbNXێp[N
//------------------------------------------------------------------
typedef struct MATRIX_TABLE_tag
{
	u8	size_h;							///<}bv}gbNX̏c
	u8	size_w;							///<}bv}gbNX̉
	u16	ZoneMat[MAP_MATRIX_MAX];		///<][IDe[u
	u8	HeightBase[MAP_MATRIX_MAX];		///<we[u
	u16	ArcIndex[MAP_MATRIX_MAX];		///<A[JCuCfbNXe[u
	u8	Prefix[MAP_MATRIX_PREFIX_MAX];	///<t@C̃vtBbNX
}MATRIX_TABLE;

//------------------------------------------------------------------
///	[h}bv\
//------------------------------------------------------------------
struct _WORLD_MAP{
	u8  MatrixW,MatrixH;						///< GȀc
	u8 matrix_id;
	MATRIX_TABLE MapMatrix;
};




//============================================================================================
//============================================================================================
//------------------------------------------------------------------
//A[JCo}gbNX擾
//------------------------------------------------------------------
static void SetupMapMatrix(MATRIX_TABLE * Mmtx, const u16 matrix_id, int zone_id)
{
	u8 zone_flg,height_flg;
	u8 prefix_size;
	void *mem;
	u8 *p;

	{
		int i;
		//\̏
		Mmtx->size_w = 0;
		Mmtx->size_h = 0;
	
		for(i=0;i<MAP_MATRIX_MAX;i++){
			Mmtx->ZoneMat[i] = 0;
			Mmtx->HeightBase[i] = 0;
			Mmtx->ArcIndex[i] = 0;
		}
		for(i=0;i<MAP_MATRIX_PREFIX_MAX;i++){
			Mmtx->Prefix[i] = 0;
		}
	}
	
	mem = ArchiveDataLoadMallocLo( ARC_MAP_MATRIX, matrix_id, HEAPID_WORLD );
	p = &((u8*)(mem))[0];
	Mmtx->size_w = *p;	//TCY
	p++;
	Mmtx->size_h = *p;	//cTCY
	p++;
	zone_flg = *p;
	p++;
	height_flg = *p;
	p++;
	prefix_size = *p;					//vtBNXTCY
	p++;

	GF_ASSERT(prefix_size <= MAP_MATRIX_PREFIX_MAX);
	MI_CpuCopy8(p,Mmtx->Prefix,prefix_size);
	p+=(prefix_size);

#ifdef	DEBUG_ONLY_FOR_saitou
	OS_Printf("data=%d,%d,%d,%d\n",Mmtx->size_w,Mmtx->size_h,zone_flg,height_flg);
	OS_Printf("prefix = %s,%d\n",Mmtx->Prefix,prefix_size);
#endif
	
	if (zone_flg){
		MI_CpuCopy8(p, Mmtx->ZoneMat, Mmtx->size_w * Mmtx->size_h * 2);
		p+=(Mmtx->size_w * Mmtx->size_h * 2);
	}else{
		//][w̃}gbNX\Ȃꍇ́A][ID~l߂Đ
		MI_CpuFill16(Mmtx->ZoneMat, zone_id, Mmtx->size_w * Mmtx->size_h * sizeof(u16));
	}
	if (height_flg){
		MI_CpuCopy8(p, Mmtx->HeightBase, Mmtx->size_w * Mmtx->size_h);
		p+=(Mmtx->size_w * Mmtx->size_h);
	}

	MI_CpuCopy8(p, Mmtx->ArcIndex, Mmtx->size_w * Mmtx->size_h*2);
	
	sys_FreeMemoryEz(mem);
}

//------------------------------------------------------------------
//------------------------------------------------------------------
WORLD_MAP_PTR WorldMapInit(void)
{
	WORLD_MAP_PTR world;

	// [h}bv\̃[Nm
	world = sys_AllocMemory(HEAPID_WORLD,sizeof(WORLD_MAP));

	world->MatrixW = 0;
	world->MatrixH = 0;
	
	world->matrix_id = 0;
	
	return world;
}

//==============================================================================
/**
 * ][hcɁA}bv}gbNX쐬
 *
 * @param   matrix_id	}gbNXhc
 * @param   world	WORLD_MAP\̂̃|C^
 *
 * @retval  none		
 */
//==============================================================================
void SetUpWorldMatrix(const int zone_id, WORLD_MAP_PTR world)
{
	u16 matrix_id;

	matrix_id = ZoneData_GetMatrixID(zone_id);
	//A[JCo}gbNX擾
	SetupMapMatrix(&world->MapMatrix,matrix_id,zone_id);
	world->matrix_id = matrix_id;
	world->MatrixH = world->MapMatrix.size_h;
	world->MatrixW = world->MapMatrix.size_w;
}


//==============================================================================
/**
 * [h}bv\̂̉
 *
 * @param   world		WORLD_MAP̃|C^
 *
 * @retval  none		
 */
//==============================================================================
void WorldMapRelease(const WORLD_MAP_PTR world)
{
	sys_FreeMemoryEz(world);						// [h}bv
	
}

//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//
//
// 牺WORLD_MAP̃oQƂ邽߂̃C^[tF[X֐łB
//
//
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
//------------------------------------------------------------------------------
u16 GetArcIndexFromBlockIndex(int index, const WORLD_MAP_PTR world)
{
	GF_ASSERT((index<(world->MatrixW*world->MatrixH)) && "}bv͈̔͂𒴂Ă");
	return world->MapMatrix.ArcIndex[index];
}

//==============================================================================
/**
 * ݓǂݍł郏[h}bv̉擾
 *
 * @param   world		WORLD_MAP̃|C^
 *
 * @retval  int			
 */
//==============================================================================
int  GetWorldMapMatrixW(const WORLD_MAP_PTR world)
{
	GF_ASSERT((world!=NULL) && "worldmapm");

	return world->MatrixW;
}
//==============================================================================
/**
 * ݓǂݍł郏[h}bv̏c擾
 *
 * @param   world		WORLD_MAP̃|C^
 *
 * @retval  int			c
 */
//==============================================================================
int  GetWorldMapMatrixH(const WORLD_MAP_PTR world)
{
	GF_ASSERT((world!=NULL) && "worldmapm");

	return world->MatrixH;

}


//============================================================================================
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	ubNWƂɃ}bv}gbNX̃][ID擾
 * @param	world	WORLD_MAP̃|C^
 * @param	gx		Xʒuin`ubNPʁj
 * @param	gz		Zʒuin`ubNPʁj
 */
//------------------------------------------------------------------
u16 World_GetZoneIDFromMatrixXZ(const WORLD_MAP * world, int gx, int gz)
{
	int gw = world->MatrixW;
	int gh = world->MatrixH;
	GF_ASSERT(0 <= gx && gx < gw);
	GF_ASSERT(0 <= gz && gz < gh);
	return world->MapMatrix.ZoneMat[gx + gz * gw];
}

//------------------------------------------------------------------
/**
 * @brief	ubNCfbNXɃ}bv}gbNX̃][ID擾
 * @param	world	WORLD_MAP̃|C^
 * @param	gx		Xʒuin`ubNPʁj
 * @param	gz		Zʒuin`ubNPʁj
 */
//------------------------------------------------------------------
u16 World_GetZoneIDFromBlockIdx(const WORLD_MAP * world, const int inBlockIdx)
{
	int idx_max = world->MatrixW*world->MatrixH;
#ifdef	DEBUG_ONLY_FOR_saitou	
	OS_Printf("local_print idx=%d,%d",idx_max,inBlockIdx);
#endif	
	GF_ASSERT(0 <= inBlockIdx && inBlockIdx < idx_max);
	return world->MapMatrix.ZoneMat[inBlockIdx];
}

//==============================================================================
/**
 * }gbNXID擾
 *
 * @param   world	WORLD_MAP̃|C^
 *
 * @retval  none		
 */
//==============================================================================

u8 GetWorldMatrixID(const WORLD_MAP_PTR world)
{
	return world->matrix_id;
}

//==============================================================================
/**
 * }gNXID][ID擾
 *
 * @param   world		WORLD_MAP̃|C^
 * @param   matrix_id	}gNXID
 * @param   gx			XW(ubN)
 * @param   gz			ZW(ubN)
 * @param   gw			
 *
 * @retval  int			][ID		
 */
//==============================================================================
int GetZoneIDFromMatrixID(	const WORLD_MAP_PTR world,
							const int matrix_id,
							const int gx,
							const int gz,
							const int gw)
{
	SDK_ASSERT(gx < gw);
	return world->MapMatrix.ZoneMat[gx + gz * gw];
}

//==============================================================================
/**
 * }gNXID獂x[X擾
 *
 * @param   world		WORLD_MAP̃|C^
 * @param   matrix_id	}gNXID
 * @param   gx			XW
 * @param   gz			ZW
 * @param   gw			
 *
 * @retval  int			x[X		
 */
//==============================================================================
int GetHeightBaseFromMatrixID(	const WORLD_MAP_PTR world,
								const int matrix_id,
								const int gx,
								const int gz,
								const int gw)
{
	SDK_ASSERT(gx < gw);
	return world->MapMatrix.HeightBase[gx + gz * gw];
}

//==============================================================================
//==============================================================================
//
//		AvP[VpANZX֐
//
//==============================================================================
//==============================================================================
typedef struct FIELD_MAT_ZONE_ID_tag
{
	u16 ZoneMat[MAP_MATRIX_MAX];
}FIELD_MAT_ZONE_ID;

//==============================================================================
/**
 * tB[h}gNX\̍쐬
 *
 * @param   inHeapID	q[vID
 *
 * @retval  FMZ_PTR		\̂ւ̃|C^		
 */
//==============================================================================
FMZ_PTR InitFMZ(const u32 inHeapID)
{
	int prefix_size;
	void *mem;
	u8 *p;
	FMZ_PTR fmz_p;
	fmz_p = sys_AllocMemory(inHeapID, sizeof(FIELD_MAT_ZONE_ID));

	mem = ArchiveDataLoadMallocLo( ARC_MAP_MATRIX, MATRIX_ID_SINOU, inHeapID );
	p = &((u8*)(mem))[0];
	//TCY
	p++;
	//cTCY
	p++;
	//][tO
	p++;
	//nCgtO
	p++;
	prefix_size = *p;					//vtBNXTCY
	p++;
	p+=(prefix_size);

	MI_CpuCopy8(p,fmz_p->ZoneMat,30*30*2);
	
	sys_FreeMemoryEz(mem);
	
	return fmz_p;
}

//==============================================================================
/**
 * tB[h}gNX\̉
 *
 * @param   fmzp		\̂ւ̃|C^
 *
 * @retval  none		
 */
//==============================================================================
void FreeFMZ(FMZ_PTR fmzp)
{
	GF_ASSERT(fmzp!=NULL);
	sys_FreeMemoryEz(fmzp);
}

//==============================================================================
/**
 * ubNWA\[ID擾
 *
 * @param   fmzp		\̂ւ̃|C^
 * @param   inBlockX	ubNXW
 * @param   inBlockZ	ubNZW
 *
 * @retval  none		
 */
//==============================================================================
int GetFieldMatrixZoneID(const FMZ_CONST_PTR fmdp, const u32 inBlockX, const u32 inBlockZ)
{
	return fmdp->ZoneMat[inBlockX+inBlockZ*MAP_MATRIX_WIDTH_MAX];
}

//==============================================================================
/**
 * @brief	w肵][̍ubNW擾
 *
 * @param   matrixID	}gNXID
 * @param	zoneID		][ID
 * @param   px			擾ubNXWi[|C^
 * @param   pz			擾ubNZWi[|C^
 *
 * @retval  none		
 */
//==============================================================================
int GetBlockPosFromZoneID(int zoneID,u16* px,u16* pz)
{
	MATRIX_TABLE	mData;
	u16	x,z;
	int	matrixID;
		
	matrixID = ZoneData_GetMatrixID(zoneID);
	SetupMapMatrix(&mData,matrixID,zoneID);

	for(z = 0;z < mData.size_h;z++){
		for(x = 0;x < mData.size_w;x++){
			if(mData.ZoneMat[z*mData.size_h+x] == zoneID){
				*px = x;
				*pz = z;
				return 1;
			}
		}
	}
	//Ȃ
	*px = 0;
	*pz = 0;
	return 0;
}

//==============================================================================
/**
 * w̃ubNɑΉĂ鍂f[^A[JCuCfbNX擾
 *
 * @param   Block		ubN
 * @param   mapresource		WORLD_MAP̃|C^
 *
 * @retval  char *		ubNt@C̃|C^
 */
//==============================================================================
const u16 GetWorldMapArcIdx(const int Block, const WORLD_MAP_PTR world)
{
	u16 index;
	int ggx = Block % world->MatrixW;							//݂̓][񂪖̂ŉ\z
	int ggz = Block / world->MatrixW;
	GF_ASSERT((world!=NULL) && "worldm");

	index = GetArcIndexFromBlockIndex(Block,world);
	return index;
}

