//============================================================================================
/**
 * @file	zonedata.c
 * @brief	][ŗL̊Ǘf[^
 * @author	tamada
 * @date	2005.08.05
 */
//============================================================================================

#include "common.h"

#include "fieldsys.h"

#include "zonedata.h"

#include "mapdefine.h"
#include "maptype.h"


#include "../fielddata/script/scr_seq.naix"

#include "../msgdata/msg.naix"

#include "../data/sound/sound_data.sadl"

#include "../fielddata/eventdata/zone_event.naix"

#include "../fielddata/encountdata/enc_data.naix"

#include "msgdata/msg_place_name.h"

#include "weather_sys.h"
#include "mapdata_weather_def.h"

#include "battle/attr_def.h"

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	][Ɏf[^̍\
 */
//------------------------------------------------------------------
typedef struct{
	u8 area_id;							///<AREA_ID̎w
	u8 movemodel_id;					///<샂f̎w
	u16 matrix_id;						///<}bv}gbNX̎w
	u16 script_id;						///<XNvgt@C̃A[JCuID
	u16 sp_script_id;					///<XNvgt@C̃A[JCuID
	u16 msg_id;							///<bZ[Wt@C̃A[JCuID
	u16 bgm_id;							///<BGMwID
	u16 enc_data_id;					///<GJEgw
	u16 event_data_id;					///<Cxgf[^t@C̃A[JCuID
	u16 placename_id;					///<nbZ[Ŵhc
	u8 weather_id;						///<VwID
	u8 camera_id;						///<JwID
	u8 maptype;							///<}bv^Cv̎w(MAPTYPE`QƁj
	u8 battle_bg_type:4;				///<퓬wi̎w
	u8 bicycle_flag:1;					///<]Ԃɏ邩ǂ
	u8 dash_flag:1;						///<_bVł邩ǂ
	u8 escape_flag:1;					///<Ȃʂł邩ǂ
}ZONE_DATA;
//------------------------------------------------------------------
//------------------------------------------------------------------

enum {
	sp_scr_dummy = NARC_scr_seq_sp_dummy_bin,
	scr_dummy = NARC_scr_seq_dummy_bin,
	//sp_scr_dummy = NARC_scr_seq_sp_c01_bin,
	//scr_dummy = NARC_scr_seq_c01_bin,
	msg_dummy = NARC_msg_c01_dat,
	enc_dummy = 0xffff,
};

#include "../fielddata/maptable/maptable.dat"

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
//------------------------------------------------------------------
int ZoneData_CheckRange(int zone_id)
{
	if (zone_id >= NELEMS(ZoneData)) {
		GF_ASSERT_MSG(0, "%d/%d:zone_id error\n",zone_id,NELEMS(ZoneData)-1);
		return ZONE_ID_C01;
	}
	return zone_id;
}

//===========================================================================
//===========================================================================
//------------------------------------------------------------------
/**
 * @brief	GAID̎擾
 * @param	zone_id		][w
 * @return	u16			GAw
 */
//------------------------------------------------------------------
const u16 ZoneData_GetAreaID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].area_id;
}

//------------------------------------------------------------------
//------------------------------------------------------------------
const u16 ZoneData_GetMoveModelID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].movemodel_id;
}

//------------------------------------------------------------------
/**
 * @brief	}bv}gbNXID̎擾
 * @param	zone_id		][w
 * @return	u16			}bv}gbNXw
 */
//------------------------------------------------------------------
const u16 ZoneData_GetMatrixID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].matrix_id;
}
//------------------------------------------------------------------
/**
 * @brief	bZ[WA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			bZ[WA[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetMsgArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].msg_id;
}

//------------------------------------------------------------------
/**
 * @brief	XNvgA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			XNvgA[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetScriptArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].script_id;
}
//------------------------------------------------------------------
/**
 * @brief	XNvgA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			XNvgA[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetSpScriptArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].sp_script_id;
}


//------------------------------------------------------------------
/**
 * @brief	BGMw̎擾
 * @param	zone_id		][w
 * @return	u16			BGMw
 */
//------------------------------------------------------------------
u16 ZoneData_GetBGMID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].bgm_id;
}

//------------------------------------------------------------------
/**
 * @brief	GJEgtO̎擾
 * @param	zone_id		][w
 * @return	TRUEFGJEgf[^AFALSE:GJEgf[^Ȃ
 */
//------------------------------------------------------------------
BOOL ZoneData_GetEncountFlag (int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return (ZoneData[zone_id].enc_data_id != enc_dummy);
}

//------------------------------------------------------------------
/**
 * @brief	GJEgA[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32	A[JCuIDw
 */
//------------------------------------------------------------------
u32 ZoneData_GetEncountArchiveID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].enc_data_id;
}

//------------------------------------------------------------------
/**
 * @brief	Cxgf[^A[JCuID̎擾
 * @param	zone_id		][w
 * @return	u32			Cxgf[^A[JCuID
 */
//------------------------------------------------------------------
u32 ZoneData_GetEventID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].event_data_id;
}

//------------------------------------------------------------------
/**
 * @brief	nbZ[WwID̎擾
 * @param	zone_id		][w
 * @return	u32			nbZ[Wwhc
 */
//------------------------------------------------------------------
u32 ZoneData_GetPlaceNameID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].placename_id;
}

//------------------------------------------------------------------
/**
 * @brief	VwID̎擾
 * @param	zone_id		][w
 * @return	u32			VwID
 */
//------------------------------------------------------------------
u32 ZoneData_GetWeatherID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].weather_id;
}

//------------------------------------------------------------------
/**
 * @brief	JwID̎擾
 * @param	zone_id		][w
 * @return	u32			JwID
 */
//------------------------------------------------------------------
u32 ZoneData_GetCameraID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].camera_id;
}

//------------------------------------------------------------------
/**
 * @brief	JwID̎擾
 * @param	zone_id		][w
 * @return	u32			퓬wiwID
 */
//------------------------------------------------------------------
u32 ZoneData_GetBattleBGID(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].battle_bg_type;
}

//------------------------------------------------------------------
/**
 * @brief	}bv^Cv̎擾
 * @param	zone_id		][w
 * @return	int			}bv^CvwID
 *
 * }bv^Cvgp͕UƌX̃^CvǉȂǂ
 * ςɂȂ̂ł̊֐͊OJĂȂ
 */
//------------------------------------------------------------------
static int ZoneData_GetMapType(int zone_id)
{
	zone_id = ZoneData_CheckRange(zone_id);
	return ZoneData[zone_id].maptype;
}
//============================================================================================
//
//
//	][IDɂe픻胍WbN
//
//
//============================================================================================
//------------------------------------------------------------------
/**
 * @brief	tB[hǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂAtB[hił_WłȂj
 */
//------------------------------------------------------------------
BOOL ZoneData_IsSinouField(int zone_id)
{
	return (ZoneData_GetMatrixID(zone_id) == MATRIX_ID_FIELD);
}

//------------------------------------------------------------------
/**
 * @brief	|PZǂ̃`FbN
 * @param	zone_id		][w
 * @retval	BOOL	TRUÊƂA|PZ
 */
//------------------------------------------------------------------
BOOL ZoneData_IsPokecen(int zone_id)
{
	return (ZoneData_GetMapType(zone_id) == MAPTYPE_POKECEN);
}

//------------------------------------------------------------------
/**
 * @brief	ʐM𗘗p\̂][ǂ`FbN
 *
 * @param   zone_id		][w
 *
 * @retval  BOOL		TRUÊƂAʐM𗘗p邩
 */
//------------------------------------------------------------------
BOOL ZoneData_IsCommPlayableZone(int zone_id)
{
	if( ZoneData_IsPokecen(zone_id) )
	{
		return TRUE;
	}


	return FALSE;
}
