//============================================================================================
/**
 * @file	app_timer.c
 * @bfief	Avg^C}[
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include "common.h"

#define __APPTIMER_H_GLOBAL__
#include "gflib\apptimer.h"

#define	APP_TIMER_NUMBER	(OS_TIMER_3)
#define	APP_TIMER_IE		(OS_IE_TIMER3)
#define	APP_TIMER_CONTROL	((u16)( REG_OS_TM3CNT_H_E_MASK | REG_OS_TM3CNT_H_I_MASK | OS_TIMER_PRESCALER_64 ))

#define  APP_TIMER_TO_MILLI_SECONDS( t )	( ((t) * 64) / (OS_SYSTEM_CLOCK/1000) )
#define  APP_TIMER_TO_SECONDS( t )			( ((t) * 64) / OS_SYSTEM_CLOCK )


//==============================================================
// Prototype
//==============================================================
static void AppTimerHandler( void );
static u64 AppTimerGet( void );

//==============================================================
// Globals
//==============================================================
static vu64  AppTimerCount = 0;
static BOOL  ResetReq = 0;


//------------------------------------------------------------------
/**
 * FCPxĂ΂
 */
//------------------------------------------------------------------
void APTM_Init( void )
{
	AppTimerCount = 0;
	ResetReq = FALSE;

	OS_SetTimerControl(APP_TIMER_NUMBER, 0);
	OS_SetTimerCount(APP_TIMER_NUMBER, 0);
	OS_SetTimerControl(APP_TIMER_NUMBER, (u16)APP_TIMER_CONTROL);

	OS_SetIrqFunction( APP_TIMER_IE, AppTimerHandler );
	OS_EnableIrqMask( APP_TIMER_IE );
}

//------------------------------------------------------------------
/**
 * ^C}[荞݃nh
 */
//------------------------------------------------------------------
static void AppTimerHandler( void )
{
	AppTimerCount++;

	if( ResetReq )
	{
		OS_SetTimerControl(APP_TIMER_NUMBER, 0);
		OS_SetTimerCount(APP_TIMER_NUMBER, 0);
		OS_SetTimerControl(APP_TIMER_NUMBER, (u16)APP_TIMER_CONTROL);

		ResetReq = FALSE;
	}

	OS_SetIrqCheckFlag( APP_TIMER_IE );
//	OS_EnableIrqMask( APP_TIMER_IE );
	OS_SetIrqFunction( APP_TIMER_IE, AppTimerHandler );
}

//------------------------------------------------------------------
/**
 * Av^C}[PʒlԂ
 *
 * @retval  u64		
 */
//------------------------------------------------------------------
static u64 AppTimerGet( void )
{
    vu16 countL;
    vu64 countH;

    OSIntrMode prev = OS_DisableInterrupts();

    countL = *(REGType16 *)((u32)REG_TM0CNT_L_ADDR + APP_TIMER_NUMBER * 4);
    countH = AppTimerCount & 0xffffffffffffULL;

    //---- check if timer interrupt bit is on
    if (reg_OS_IF & APP_TIMER_IE && !(countL & 0x8000))
    {
        countH++;
    }

    (void)OS_RestoreInterrupts(prev);

    return (countH << 16) | countL;
}

//------------------------------------------------------------------
/**
 * OJFbPʎ擾
 *
 * @retval  u64		
 */
//------------------------------------------------------------------
u64 APTM_GetSec( void )
{
	u64 t = AppTimerGet();
	return APP_TIMER_TO_SECONDS( t );
}

//------------------------------------------------------------------
/**
 * OJF~bPʎ擾
 *
 * @retval  u64		
 */
//------------------------------------------------------------------
u64 APTM_GetMsec( void )
{
	u64 t = AppTimerGet();
	return APP_TIMER_TO_MILLI_SECONDS( t );
}

//------------------------------------------------------------------
/**
 * OJF̃f[^n
 *
 * @retval  u64		
 */
//------------------------------------------------------------------
u64 APTM_GetData( void )
{
	return AppTimerGet( );
}

//------------------------------------------------------------------
/**
 * OJF̃f[^Zbg
 *
 * @param   dat		
 *
 */
//------------------------------------------------------------------
void APTM_SetData( u64 dat )
{
	ResetReq = TRUE;
	AppTimerCount = (u64)(dat >> 16);

	OS_SetTimerControl(APP_TIMER_NUMBER, 0);
	OS_SetTimerCount(APP_TIMER_NUMBER, (u16)(dat & 0xffff));
	OS_SetTimerControl(APP_TIMER_NUMBER, APP_TIMER_CONTROL);

}
//------------------------------------------------------------------
/**
 * OJF^C}[Zbg
 */
//------------------------------------------------------------------
void APTM_Reset( void )
{
	APTM_SetData( 0 );
}
