//==============================================================================
/**
 *
 *@file		assert.c
 *@brief	AT[g
 *@author	taya
 *@date		2005.08.08
 *
 */
//==============================================================================
#include "common.h"
#include "gflib\assert.h"



//------------------------------------------------------------------
/**
 * AT[gbZ[W\̃L[҂[v
 */
//------------------------------------------------------------------
static void BreakAssertKeyWait(void)
{
	#define ESCAPE_KEY_MASK	(PAD_BUTTON_X|PAD_BUTTON_Y)

	while(1){
		sys_MainKeyRead();

		if((sys.cont & ESCAPE_KEY_MASK) == ESCAPE_KEY_MASK){
			break;
		}
	}
	#undef ESCAPE_KEY_MASK
}

//------------------------------------------------------------------
/**
 * AT[gsӏ̃\[Xo
 */
//------------------------------------------------------------------
static void PrintBaseMessage(const char* filename, unsigned int line_no)
{
	OS_TPrintf("  **** ASSERTION FAILED ! **** \n");
	OS_TPrintf(filename);
	OS_TPrintf("(%d) ", line_no);
}


//------------------------------------------------------------------
/**
 * AT[gsɃ}NŌĂяo֐{́iʏŁj
 *
 * @param   filename		Ăяo\[Xt@C
 * @param   line_no			Ăяo\[Xt@Csԍ
 * @param   exp				}N
 *
 */
//------------------------------------------------------------------
void GF_AssertProc(const char* filename, unsigned int line_no, const char* exp)
{
	PrintBaseMessage(filename, line_no);
	OS_TPrintf("%s\n", exp);

	BreakAssertKeyWait();
}

//------------------------------------------------------------------
/**
 * AT[gsɃ}NŌĂяo֐{́it\Łj
 *
 * @param   filename		
 * @param   line_no		
 * @param   exp			
 *
 */
//------------------------------------------------------------------
void GF_AssertMsgProc( const char* filename, unsigned int line_no, const char* fmt, ... )
{
	va_list vlist;

	PrintBaseMessage(filename, line_no);

	va_start(vlist, fmt);
	OS_TVPrintf(fmt, vlist);
	va_end(vlist);
	OS_TPrintf("\n");

	BreakAssertKeyWait();
}


