//============================================================================================
/**
 * @file	button_man.c
 * @bfief	{^ԊǗ}l[W
 * @date	2005.11.08
 * @author	taya GAME FREAK inc.
 */
//============================================================================================
#include "common.h"
#include "gflib\button_man.h"




//==============================================================================
// 萔
//==============================================================================
//-----------------------------------------------
/**
 * {^
 */
//-----------------------------------------------
enum {
	STATE_FREE = 0,
	STATE_HOLD,
};

//-----------------------------------------------
/**
 * ̂
 */
//-----------------------------------------------
enum {
	BMN_EVENT_NULL = 0xffffffff,	///< {^CxgliCxgĂȂԂj
	HOLD_TIMER_MAX = 0xffff,		///< ^C}[ől
};

//==============================================================================
// \̒`
//==============================================================================

//----------------------------------------------
/**
 * ʂ̃{^
 */
//----------------------------------------------
typedef struct {
	u8  state;				///< 
	u8  touch_flag;			///< GĂtO
	u16 timer;
}BUTTON;

//----------------------------------------------
/**
 * }l[WŜ̃[N
 */
//----------------------------------------------
struct _BUTTON_MAN {
	const TP_HIT_TBL*	hit_tbl;
	u32					btn_cnt;
	pBmnCallBackFunc	callback_func;
	void*				callback_arg;

	BUTTON *btn;
};



//==============================================================================
// Prototype
//==============================================================================
static void button_state_init( BUTTON* btn );
static u32 button_proc_free( BUTTON *btn, BOOL tp_cont, BOOL tp_trg );
static u32 button_proc_hold( BUTTON *btn, BOOL tp_cont, BOOL tp_trg );
static void button_state_change( BUTTON *btn, u32 state );


//======================================================================================================
/**
 * {^Ǘ}l[W쐬
 *
 * @param   hit_tbl			[in]  蔻e[u
 * @param   btn_cnt			[in]  hit_tbl ̗vfi=ꂪo^{^̐ƂƁj
 * @param   callback		[in]  {^CxgɌĂяoR[obN֐
 * @param   callback_arg	[in]  callback ĂяoɈƂēnCӂ̃|C^
 * @param   heapID			[in]  }l[Ẅ쐬pq[vID
 *
 * @retval  BUTTON_MAN*		}l[W|C^
 */
//======================================================================================================
BUTTON_MAN* BMN_Create( const TP_HIT_TBL *hit_tbl, u32 btn_cnt, pBmnCallBackFunc callback, void *callback_arg, u32 heapID )
{
	BUTTON_MAN *bmn;

	GF_ASSERT( btn_cnt > 0 );

	bmn = sys_AllocMemory( heapID, sizeof(BUTTON_MAN) );
	if(bmn)
	{
		bmn->hit_tbl = hit_tbl;
		bmn->btn_cnt = btn_cnt;
		bmn->callback_func = callback;
		bmn->callback_arg = callback_arg;

		bmn->btn = sys_AllocMemory( heapID, sizeof(BUTTON) * btn_cnt );
		if(bmn->btn)
		{
			u32 i;

			for(i=0; i<btn_cnt; i++)
			{
				button_state_init( &bmn->btn[i] );
			}
		}
		else
		{
			sys_FreeMemoryEz( bmn );
			bmn = NULL;
		}
	}
	return bmn;
}
//------------------------------------------------------------------
/**
 * {^[N
 *
 * @param   btn		{^[N
 *
 */
//------------------------------------------------------------------
static void button_state_init( BUTTON* btn )
{
	btn->state = STATE_FREE;
	btn->touch_flag = FALSE;
	btn->timer = 0;
}


//======================================================================================================
/**
 * {^Ǘ}l[W
 *
 * @param   bmn		}l[W|C^
 */
//======================================================================================================
void BMN_Delete( BUTTON_MAN *bmn )
{
	GF_ASSERT( bmn );
	sys_FreeMemoryEz( bmn->btn );
	sys_FreeMemoryEz( bmn );
}

//======================================================================================================
/**
 * {^Ǘ}l[WC
 *
 * e{^Ԃ̃`FbNXVACxg΃R[obNĂяosB
 *
 * @param   bmn		}l[W|C^
 *
 */
//======================================================================================================
void BMN_Main( BUTTON_MAN *bmn )
{
	static u32 (* const ButtonProc[])(BUTTON*, BOOL, BOOL ) = {
		button_proc_free,
		button_proc_hold,
	};

	BOOL tp_cont, tp_trg;
	u32 i, ev;

	tp_cont = GF_TP_GetCont();
	if( tp_cont )
	{
		tp_trg = GF_TP_GetTrg();

		for(i = 0; i < bmn->btn_cnt; i++)
		{
			if(bmn->btn[i].touch_flag){
				bmn->btn[i].touch_flag = GF_TP_SingleHitCont( &bmn->hit_tbl[i] );
			}else{
				bmn->btn[i].touch_flag = GF_TP_SingleHitTrg( &bmn->hit_tbl[i] );
			}
		}
	}
	else
	{
		tp_trg = FALSE;

		for(i = 0; i < bmn->btn_cnt; i++)
		{
			bmn->btn[i].touch_flag = FALSE;
		}
	}


	for(i=0; i<bmn->btn_cnt; i++)
	{
		ev = ButtonProc[bmn->btn[i].state]( &bmn->btn[i], tp_cont, tp_trg );
		if(ev != BMN_EVENT_NULL)
		{
			bmn->callback_func( i, ev, bmn->callback_arg );
		}
	}
/*
	for(i++ ; i < bmn->btn_cnt; i++)
	{
		ButtonProc[bmn->btn[i].state]( &bmn->btn[i], tp_cont, tp_trg );
	}
*/

}
//------------------------------------------------------------------
/**
 * {^ԁFGĂȂ
 *
 * @param   btn			{^[N
 * @param   tp_cont		^b`plConttO
 * @param   tp_trg		^b`plTrgtO
 *
 * @retval  u32		Cxg^Cv
 */
//------------------------------------------------------------------
static u32 button_proc_free( BUTTON *btn, BOOL tp_cont, BOOL tp_trg )
{
	if(btn->touch_flag){
		if(tp_trg){
			button_state_change( btn, STATE_HOLD );
			return BMN_EVENT_TOUCH;
		}
	}
	return BMN_EVENT_NULL;
}
//------------------------------------------------------------------
/**
 * {^ԁFGĂ
 *
 * @param   btn			{^[N
 * @param   tp_cont		^b`plConttO
 * @param   tp_trg		^b`plTrgtO
 *
 * @retval  u32		Cxg^Cv
 */
//------------------------------------------------------------------
static u32 button_proc_hold( BUTTON *btn, BOOL tp_cont, BOOL tp_trg )
{
	// {^
	if( btn->touch_flag )
	{
		if( btn->timer < HOLD_TIMER_MAX )
		{
			btn->timer++;
		}
		return BMN_EVENT_HOLD;
	}
	// {^ĂȂǃXN[ɂ͐GĂ
	else if(tp_cont)
	{
		button_state_change( btn, STATE_FREE );
		return BMN_EVENT_SLIDEOUT;
	}
	// XN[ɐGĂȂ
	else
	{
		button_state_change( btn, STATE_FREE );
		return BMN_EVENT_RELEASE;
	}

	return BMN_EVENT_NULL;
}
//------------------------------------------------------------------
/**
 * {^Xe[^XύX
 *
 * @param   btn			{^[N
 * @param   state		Xe[^X
 *
 */
//------------------------------------------------------------------
static void button_state_change( BUTTON *btn, u32 state )
{
	btn->state = state;
	btn->timer = 0;
}



//======================================================================================================
/**
 * {^z[hԂɂ鎞Ãz[hԁit[jԂ
 *
 * @param   bmn		}l[W[N
 * @param   idx		{^CfbNX
 *
 * @retval  u32		z[hȂz[hԁAz[hȊOȂO
 */
//======================================================================================================
u32 BMN_GetHoldFrameCount( BUTTON_MAN* bmn, u32 idx )
{
	BUTTON *btn = &bmn->btn[idx];

	if(btn->state == STATE_HOLD)
	{
		return btn->timer;
	}
	return 0;
}
