/*---------------------------------------------------------------------------*
  Project:  
  File:     calc2d.c
 *---------------------------------------------------------------------------*/
#include <nnsys.h>
#define	__CALC2D_H_GLOBAL
#include "calc2d.h"

//---------------------------------------------------------------------------------------------------------
/**
 *  OςgpĎwWwxNg̍Eǂɂ邩𔻒
 *  @param  *inS_Vec        xNgn_
 *  @param  *inE_Vec        xNgI_
 *  @param  *inT_Vec        wW
 *
 *  @retval int         1:\ixNg܂ށj@0:
*/
//---------------------------------------------------------------------------------------------------------
int BG2D_VectorSideS32( const Vec2DS32 *inS_Vec, const Vec2DS32 *inE_Vec, const Vec2DS32 *inT_Vec )
{
    s32 n;
    
    //Oς߂iVEC_CrossProductgpj
    n = ( inT_Vec->x * (inS_Vec->y - inE_Vec->y))+(inS_Vec->x * (inE_Vec->y - inT_Vec->y))+(inE_Vec->x * (inT_Vec->y - inS_Vec->y));
    if      ( n >= 0 ){
		return  1; // \()
	}
    else  return 0; // (E)
}

//---------------------------------------------------------------------------------------------------------
/**
 * m̌
 *  @param  *inS_Vec1        xNgn_
 *  @param  *inE_Vec1        xNgI_
 *  @param  *inS_Vec2        xNgn_
 *  @param  *inE_Vec2        xNgI_
 *
 *  @retval BOOL
*/
//---------------------------------------------------------------------------------------------------------
BOOL BG2D_CheckSegmentToSegmentS32( const Vec2DS32 *inS_Vec1, const Vec2DS32 *inE_Vec1, const Vec2DS32 *inS_Vec2, const Vec2DS32 *inE_Vec2 )
{

	if ( ((BG2D_VectorSideS32(inS_Vec1,inE_Vec1,inS_Vec2) ^ BG2D_VectorSideS32(inS_Vec1,inE_Vec1,inE_Vec2)) == 1) &&
		 ((BG2D_VectorSideS32(inS_Vec2,inE_Vec2,inS_Vec1) ^ BG2D_VectorSideS32(inS_Vec2,inE_Vec2,inE_Vec1)) == 1)	){
		return TRUE;
	}
	else  return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	xNgf[^쐬
 *
 *@param	u16 x1Fn_W
 *@param	u16 y1Fn_W
 *@param	u16 x2FI_W
 *@param	u16 y2FI_W
 *
 *@return	TP_VECTOR_DATA^FxNǧXX=O̎̍
 *
 */
//-----------------------------------------------------------------------------
TP_VECTOR_DATA MakeVector( u16 x1, u16 y1, u16 x2, u16 y2 )
{
	s16 height;		// _̋
	s16 width;		// _̋
	TP_VECTOR_DATA	vect;	// xNgf[^
	
	//
	// JnWƏI_WXƂO̎Y̒l߂
	//
	height = y2 - y1;
	width = x2 - x1;
	if( width != 0 ){	// O
		vect.x = FX_Div( height << FX32_SHIFT, width << FX32_SHIFT );		// X
	}else{
		vect.x = 255 << FX32_SHIFT;		// ȂYɋ߂Xl
	}
	vect.c = (y1 << FX32_SHIFT) - FX_Mul(vect.x, x1 << FX32_SHIFT);	// X=0̎̒lZbg

	return vect;		// xNgԂ
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	xNǧ_߂
 *
 *@param	Vec2DS32* vector1_sFxNgP̊Jn_
 *@param	Vec2DS32* vector1_eFxNgP̏I_
 *@param	Vec2DS32* vector2_sFxNgQ̊Jn_
 *@param	Vec2DS32* vector2_eFxNgQ̏I_
 *@param	Vec2DS32* crossF_W
 *
 *@return	u32^FOF_Ȃ		PF_
 *
 */
//-----------------------------------------------------------------------------
u32 CheckCrossMatrix( Vec2DS32* vector1_s, Vec2DS32* vector1_e, Vec2DS32* vector2_s, Vec2DS32* vector2_e, Vec2DS32* cross )
{
	fx32 cross_x;					// _^̌_
	fx32 cross_y;					// _^̌_
	fx32 half_x;					// ľܓp
	fx32 half_y;					// ľܓp	
	TP_VECTOR_DATA vector_data_1;	// _vZpxNgf[^P
	TP_VECTOR_DATA vector_data_2;	// _vZpxNgf[^Q
	Vec2DS32 vect1_max;				// xNgP̍ő ͈͓p
	Vec2DS32 vect1_min;				// xNgP̍ŏ ͈͓p
	Vec2DS32 vect2_max;				// xNgQ̍ő ͈͓p
	Vec2DS32 vect2_min;				// xNgQ̍ŏ ͈͓p
	


	//
	// _
	//
	// _Zbg
 	if( cross != NULL ){
		cross->x = 0xffff;
		cross->y = 0xffff;
	}


	// xNg͈͓Ɍ_̂`FbN
	if( BG2D_CheckSegmentToSegmentS32( vector1_s, vector1_e,
							vector2_s, vector2_e ) == FALSE ){
		// _͂܂
		return 0;
	}
	

	// _߂邽߂̃xNgf[^쐬
	vector_data_1 = MakeVector( vector1_s->x, vector1_s->y, vector1_e->x, vector1_e->y );
	vector_data_2 = MakeVector( vector2_s->x, vector2_s->y, vector2_e->x, vector2_e->y );

	
	//
	// _߂
	// xNĝQD̐̕
	// ߂
	// _邩`FbN	= s`FbN
	if( vector_data_1.x == vector_data_2.x ){
		return 0;
	}

	// słȂƂ
	// XW				
	cross_x = FX_Div( (vector_data_2.c - vector_data_1.c), vector_data_1.x - vector_data_2.x );
	
	// YW
	cross_y = FX_Mul(vector_data_2.x, cross_x) + vector_data_2.c;
	

	// XWľܓs32̍Wɂ
	if( FX_Modf( cross_x, &half_x ) >= FX32_HALF ){
		half_x += FX32_ONE;
	}
	cross->x = half_x >> FX32_SHIFT;

	// YWľܓs32̍Wɂ
	if( FX_Modf( cross_y, &half_y ) >= FX32_HALF ){
		half_y += FX32_ONE;
	}
	cross->y = half_y >> FX32_SHIFT;

	//
	// xNg͈͓̔ɂ邩`FbN
	// 
	// őŏlZbg
	// xNgP
	if( vector1_s->x >= vector1_e->x ){
		vect1_max.x = vector1_s->x;
		vect1_min.x = vector1_e->x;
	}else{
		vect1_max.x = vector1_e->x;
		vect1_min.x = vector1_s->x;
	}
	if( vector1_s->y >= vector1_e->y ){
		vect1_max.y = vector1_s->y;
		vect1_min.y = vector1_e->y;
	}else{
		vect1_max.y = vector1_e->y;
		vect1_min.y = vector1_s->y;
	}
	// xNgQ
	if( vector2_s->x >= vector2_e->x ){
		vect2_max.x = vector2_s->x;
		vect2_min.x = vector2_e->x;
	}else{
		vect2_max.x = vector2_e->x;
		vect2_min.x = vector2_s->x;
	}
	if( vector2_s->y >= vector2_e->y ){
		vect2_max.y = vector2_s->y;
		vect2_min.y = vector2_e->y;
	}else{
		vect2_max.y = vector2_e->y;
		vect2_min.y = vector2_s->y;
	}
	
	//
	// ͈͓`FbN
	//
	if( (((vect1_max.x >= cross->x) && (vect1_min.x <= cross->x)) &&
		((vect1_max.y >= cross->y) && (vect1_min.y <= cross->y))) &&
		(((vect2_max.x >= cross->x) && (vect2_min.x <= cross->x)) &&
		((vect2_max.y >= cross->y) && (vect2_min.y <= cross->y))) ){

#if 0
	OS_Printf( "_  x[%d] y[%d]\n", cross->x, cross->y );
	OS_Printf( "vect1 x[%d] y[%d] - x[%d] y[%d]\n", vect1_max.x, vect1_max.y, vect1_min.x, vect1_min.y );
	OS_Printf( "vect2 x[%d] y[%d] - x[%d] y[%d]\n", vect2_max.x, vect2_max.y, vect2_min.x, vect2_min.y );
	OS_Printf( "vect1 s_x[%d] s_y[%d] e_x[%d] e_y[%d]\n", vector1_s->x, vector1_s->y, vector1_e->x, vector1_e->y );
	OS_Printf( "vect2 s_x[%d] s_y[%d] e_x[%d] e_y[%d]\n", vector2_s->x, vector2_s->y, vector2_e->x, vector2_e->y );
	OS_Printf( "vect1 a[%d] c[%d]\n", vector_data_1.x >> FX32_SHIFT, vector_data_1.c >> FX32_SHIFT );
	OS_Printf( "vect2 a[%d] c[%d]\n\n", vector_data_2.x >> FX32_SHIFT, vector_data_2.c >> FX32_SHIFT );
#endif
		
		return 1;		// _
	}
	
	return 0;		// _͂邪A͈͓ł͂Ȃ
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	G̏񂩂O
 *
 *@param	Vec2DS32* pDataFsN`[f[^
 *@param	u32 SizeFf[^TCY
 *@param	u16 xF肷XW
 *@param	u16 yF肷YW
 *
 *@return	u32^FOFO@PF
 *
 */
//-----------------------------------------------------------------------------
u32 CheckInOut( Vec2DS32* pData, u32 Size, u16 x, u16 y )
{
	int				i;					// [vp	
	u32				check_num;			// _
	Vec2DS32		main_s;				// pxNgn_W
	Vec2DS32		main_e;				// pxNgI_W
	u8				next_way;			// ̃f[^̕
	u8				now_way;			// ̕
	u8				skip_flag;			// _ĂXLbvtO
	u32				skip_data_num;		// XLbv`FbNf[^̗vf
	s32				skip_work;			// XLbv`FbN̍Ɨp
	

	//
	// n_ƏI_쐬
	//
	main_s.x = x;					// `FbN钸_W
	main_s.y = y;					// `FbN钸_W
	main_e.x = x;					// `FbN钸_W̐^̓_
	main_e.y = CALC_IN_OUT_CECK_Y;	// `FbN钸_W̐^̓_

	// ϐ
	skip_flag = 0;			// XLbvȂ悤ɏ

	
	//
	// sN`f[^̑SxNgA_̂xNg̐
	// 𐔂
	// ̎FO
	// P̎F
	//
	check_num = 0;		// _JEg
	for( i = 0; i < Size - 1; i++ ){

		// XLbv`FbN
		if( skip_flag == 1 ){
			
			skip_flag = 0;		// XLbv
			
		}else{
			// ̓_`FbNxNg̉Eɂ邩ɂ邩`FbN 
			// O̎͐΂ɒʂ悤ɂ
			skip_work = pData[ i ].x - main_s.x;
			if( skip_work == 0 ){	
				// _Ɠ
				now_way = 2;
			}else{
				if( skip_work < 0 ){
					// 
					now_way = 0;
				}else{
					// E
					now_way = 1;
				}
			}
			
			// ̕`FbN
			skip_work = pData[ i + 1 ].x - main_s.x;
			if( skip_work == 0 ){
				// _Ɠ
				next_way = 2;
			}else{
				if( skip_work < 0 ){
					// 
					next_way = 0;
				}else{
					// E
					next_way = 1;
				}
			}

			// `FbN
			if( (now_way != next_way) ||
				((now_way == 2) || (next_way == 2)) ){
			
				// _̂
				if( BG2D_CheckSegmentToSegmentS32( &main_s, &main_e,
							&pData[ i ], &pData[ i + 1 ] ) == TRUE ){
					// XLbv`FbN̗vfZbg
					skip_data_num = i + 2;

					// obt@I[o[P̒_̈ʒuɂ
					// ȂȂŏI̒_ƂO̒_͈ꏏɂȂ悤ɍĂ邽߂ł
					if( skip_data_num >= Size ){
						skip_data_num = (skip_data_num % Size) + 1;
					}
					
					// Q̒_main_s-_eō쐬xNgYłQĂƂ́A
					// _͂PɂȂ̂ŎŁA_Ƃ̓XLbv
					if( (BG2D_VectorSideS32( &main_s, &main_e, &pData[ i ] ) ^
						BG2D_VectorSideS32( &main_s, &main_e, &pData[ skip_data_num ] )) == 1 ){
						// _XLbv
						skip_flag = 1;
					}

					// `FbN
					check_num++;
				}				
			}
		}
	}


	//
	// _PȂPԂ
	//
	return check_num % 2;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	xNg̍px߂
 *
 *@param	u16 x1Fn_W
 *@param	u16 y1Fn_W
 *@param	u16 x2FI_W
 *@param	u16 y2FI_W
 *@param	u16 x3Fn_QW
 *@param	u16 y3Fn_QW
 *@param	u16 x4FI_QW
 *@param	u16 y4FI_QW
 *
 *@return	u16^FxNgPƂQ̍鋷ق̊px
 *
 */
//-----------------------------------------------------------------------------
u16 GetVectorAngle( u16 x1, u16 y1, u16 x2, u16 y2, u16 x3, u16 y3, u16 x4, u16 y4 )
{
	u16 rota1, rota2;		// ]p
	s16	vec_x, vec_y;		// xNg
	
	//
	// 1-2@1-3̃xNg쐬AQԂ̊pxԂ 
	//
	// 1-2̊pxvZ
	vec_x = x2 - x1;
	vec_y = y2 - y1;

	// px߂
	rota1 = FX_Atan2Idx( vec_y << FX32_SHIFT, vec_x << FX32_SHIFT );

	// 1-3̊pxvZ
	vec_x = x3 - x4;
	vec_y = y3 - y4;

	// px߂
	rota2 = FX_Atan2Idx( vec_y << FX32_SHIFT, vec_x << FX32_SHIFT );
	
	
	// Ԃ̊pxɂ
	if( rota1 > rota2 ){
		rota1 -= rota2;
	}else{
		rota2 -= rota1;
		rota1 = rota2;
	}

	// Ԃ̊px180葽Ƃ͔Α̏px̒̕lɂ
	if( rota1 > (180 * 182) ){
		rota1 = (360*182) - rota1;
	}


	return rota1;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	xNg̒߂
 *
 *@param	s32 x1, s32 y1F_P
 *@param	s32 x2, s32 y2F_Q
 *
 *
 *@return	u32^F
 *
 */
//-----------------------------------------------------------------------------
u32 GetVectorDistance( s32 x1, s32 y1, s32 x2, s32 y2 )
{
	s32 dist_x, dist_y;			// e̒
	u32	dist;					// xNg̒
	
	
	//
	// xNg̒߂
	//
	dist_x = x1 - x2;
	dist_y = y1 - y2;

	// ߂
	dist = FX_Sqrt( ((dist_x * dist_x) + (dist_y * dist_y)) << FX32_SHIFT ) >> FX32_SHIFT;

	return dist;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	_̃obt@󂯎蒆S̍W߂
 *
 *@param	Vec2DS32* pBuffFobt@
 *@param	u32 SizeFTCY
 *
 *
 *@return	Vec2DS32^FS̍W
 *
 */
//-----------------------------------------------------------------------------
Vec2DS32 GetCenterMatrix( Vec2DS32* pBuff, u32 Size )
{
	Vec2DS32 max;		// ől
	Vec2DS32 min;		// ŏl
	Vec2DS32 ret;		// ߂lp
	int	i;				// [vp
	

	
	// 
	min = pBuff[ 0 ];
	max = pBuff[ 0 ];
	
	//
	//ĂƉ̍őAŏl擾 
	//
	for( i = 0; i < Size; i++ ){
		//
		// XY̍őŏ`FbN
		//
		if( min.x > pBuff[ i ].x ){
			min.x = pBuff[ i ].x;
		}else{
			if( max.x < pBuff[ i ].x ){
				max.x = pBuff[ i ].x;
			}
		}

		if( min.y > pBuff[ i ].y ){
			min.y = pBuff[ i ].y;
		}else{
			if( max.y < pBuff[ i ].y ){
				max.y = pBuff[ i ].y;
			}
		}
	}


	//
	// SW߂
	//
	ret.x = ((max.x - min.x) / 2) + min.x;
	ret.y = ((max.y - min.y) / 2) + min.y;
	

	return ret;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	sɉ]s
 *
 *@param	MtxFx33* p_matrixFs
 *@param	u16 rota_numF]p
 *
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
void SetRotaMatrix2D( MtxFx33* p_matrix, u16 rota_num )
{
	MtxFx33 work;
	//
	// ]s
	//
	MTX_RotZ33( &work, FX_SinIdx(rota_num), FX_CosIdx(rota_num) );

	// 킹
	MTX_Concat33( &work, p_matrix, p_matrix );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	sɊgks
 *			gpOMTX_Identity33ijŒPʍsɂĂĂ
 *
 *@param	MtxFx33* p_matrixFs
 *@param	fx32 xFgkl
 *@param	fx32 yFĊgkl
 *
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
void SetScaleMatrix2D( MtxFx33* p_matrix, fx32 x, fx32 y )
{
	MtxFx33 work;

	//
	// ]s
	//
	MTX_Scale33( &work, x, y, FX32_ONE );

	// 킹
	MTX_Concat33( &work, p_matrix, p_matrix );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	sɍWāA]Agk̍W߂
 *			gpOMTX_Identity33ijŒPʍsɂĂĂ
 *
 *@param	MtxFx33* p_matrixFs
 *@param	fx32 xFW
 *@param	fx32 yFčW
 *@param	fx32* p_get_xFϊ̍Wi[p
 *@param	fx32* p_get_yFϊ̍Wi[p
 *
 *
 *@return	Ȃ
 *
 */
//-----------------------------------------------------------------------------
void GetMatrix2D( MtxFx33* p_matrix, fx32 x, fx32 y, fx32* p_get_x, fx32* p_get_y )
{
	// vZ
	*p_get_x = FX_Mul( p_matrix->_00, x ) + FX_Mul( p_matrix->_01, y );
	*p_get_y = FX_Mul( p_matrix->_10, x ) + FX_Mul( p_matrix->_11, y );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	߂_߂
 *
 *@param	Vec2DS32* pBuffFobt@
 *@param	u32 SizeFTCY
 *@param	Vec2DS32 matF߂_TW
 *
 *
 *@return	u32 ^F߂W̓Y
 *
 */
//-----------------------------------------------------------------------------
u32 GetNearMatrix( Vec2DS32* pBuff, u32 Size, Vec2DS32 mat )
{
	u32		  ret;				// ߂lp
	u32		  dist;				// ŒZi[p
	int		  i;				// [vp
	u32		  dist_work;		// ŒZp
		

	//
	// obt@O̒lŏ
	// 
	ret = 0;
	dist = GetVectorDistance( pBuff[0].x, pBuff[0].y, mat.x, mat.y );
	
	//
	// ԋ߂_̃|C^Ԃ
	//
	for( i = 0; i < Size; i++ ){
		// ߂
		dist_work = GetVectorDistance( pBuff[i].x, pBuff[i].y, mat.x, mat.y );

		// ŒZ`FbN
		if( dist > dist_work  ){
			dist = dist_work;
			ret = i;
		}
	}

	return ret;
}
