/*---------------------------------------------------------------------------*
  Project:  PokemonDS
  File:     camera.c

  {JVXe

 *---------------------------------------------------------------------------*/

#include <nitro.h>
#include <nnsys.h>
# include "system.h"
#include "camera.h"
#include "calc3d.h"
#include "assert.h"

GXBufferMode	SwapBuffMode = GX_BUFFERMODE_W;		// Xbvobt@[h

/*---------------------------------------------------------------------------*
	LookAt\
 *---------------------------------------------------------------------------*/
typedef struct
{
	VecFx32		camPos;					// J̈ʒu(_)
	VecFx32		target;					// J̏œ_(_)
	VecFx32		camUp;					// J̏

} GF_CAMERA_LOOKAT;

/*---------------------------------------------------------------------------*
	Vw3Persp\
 *---------------------------------------------------------------------------*/
typedef struct
{
	fx32		fovySin;			// p/2̐Ƃl
    fx32		fovyCos;			// p/2̗]Ƃl
    fx32		aspect;				// AXyNg
    fx32		nearClip;			// _nearNbvʂ܂ł̋
    fx32		farClip;			// _farNbvʂ܂ł̋

} GF_CAMERA_PERSP;

/*---------------------------------------------------------------------------*
	Jg[X\
 *---------------------------------------------------------------------------*/
typedef struct GF_CAMERA_TRACE_tag
{
	int HistNum;
	int CamPoint;
	int TargetPoint;
	int Delay;			//x
	BOOL UpdateFlg;		//XVJntO
	BOOL ValidX;		//XxLɂ邩̃tO
	BOOL ValidY;		//YxLɂ邩̃tO
	BOOL ValidZ;		//ZxLɂ邩̃tO
	VecFx32 *HistPos;
}GF_CAMERA_TRACE;

/*---------------------------------------------------------------------------*
	J\
 *---------------------------------------------------------------------------*/
typedef struct GF_CAMERA_tag
{
	GF_CAMERA_PERSP		persp;
	GF_CAMERA_LOOKAT	lookat;

	fx32			Distance;
	CAMERA_ANGLE	Angle;
	u8				View;
	u16				PerspWay;
	VecFx32 BindTargetOld;
	const VecFx32 *BindTarget;
	BOOL XBind;
	BOOL YBind;
	BOOL ZBind;
	GF_CAMERA_TRACE *Trace;
} GF_CAMERA;

/*---------------------------------------------------------------------------*
	staticϐ
 *---------------------------------------------------------------------------*/
static GF_CAMERA_PTR 	GF_Camera = NULL;        // J\̃|C^

//---------------------------------------------------------------------------
/**
 * @brief	Jʒu𒍎_AAAOZo
 * 
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
static void SetCamPosByTarget_Dist_Ang(GF_CAMERA_PTR camera_ptr)
{
	u16 angle_x;
	//p˒nʂ̌Xɕϊ
	angle_x = -camera_ptr->Angle.x;
	/*== JW߂ ==*/
	camera_ptr->lookat.camPos.x = FX_Mul( FX_Mul( FX_SinIdx( camera_ptr->Angle.y ), camera_ptr->Distance ), FX_CosIdx( camera_ptr->Angle.x ) );
	camera_ptr->lookat.camPos.z = FX_Mul( FX_Mul( FX_CosIdx( camera_ptr->Angle.y ), camera_ptr->Distance ), FX_CosIdx( camera_ptr->Angle.x ) );
	camera_ptr->lookat.camPos.y = FX_Mul( FX_SinIdx( angle_x ), camera_ptr->Distance );

	/*== _̋ɂ ==*/
	VEC_Add(&camera_ptr->lookat.camPos,&camera_ptr->lookat.target,&camera_ptr->lookat.camPos);
	//camera_ptr->lookat.camPos.x += camera_ptr->lookat.target.x;
	//camera_ptr->lookat.camPos.y += camera_ptr->lookat.target.y;
	//camera_ptr->lookat.camPos.z += camera_ptr->lookat.target.z;
	
}

//---------------------------------------------------------------------------
/**
 * @brief	_JʒuAAAOZo
 * 
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
static void SetTargetByCamPos_Dist_Ang(GF_CAMERA_PTR camera_ptr)
{
	u16 angle_x;
	//p˒nʂ̌Xɕϊ
	angle_x = -camera_ptr->Angle.x;
	camera_ptr->lookat.target.x = -FX_Mul( FX_Mul( FX_SinIdx( camera_ptr->Angle.y ), camera_ptr->Distance ), FX_CosIdx( camera_ptr->Angle.x ) );
	camera_ptr->lookat.target.z = -FX_Mul( FX_Mul( FX_CosIdx( camera_ptr->Angle.y ), camera_ptr->Distance ), FX_CosIdx( camera_ptr->Angle.x ) );
	camera_ptr->lookat.target.y = -FX_Mul( FX_SinIdx( angle_x ), camera_ptr->Distance );
	VEC_Add(&camera_ptr->lookat.target,&camera_ptr->lookat.camPos,&camera_ptr->lookat.target);
}

//---------------------------------------------------------------------------
/**
 * @brief	Jʏ
 * 
 * @param	inPerspway	p[X
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
static void InitCameraCommon(const u16 inPerspWay,GF_CAMERA_PTR camera_ptr){
	//pZbg
	camera_ptr->PerspWay = inPerspWay;
	camera_ptr->persp.fovySin  = FX_SinIdx( inPerspWay );
	camera_ptr->persp.fovyCos  = FX_CosIdx( inPerspWay );
	//AXyNgZbg
	camera_ptr->persp.aspect   = FX32_ONE * 4 / 3;
	//jAEt@[NbvZbg
	camera_ptr->persp.nearClip = FX32_ONE * 150;
	camera_ptr->persp.farClip  = FX32_ONE * 900;

	//J̏ݒ
	camera_ptr->lookat.camUp.x =  0;
	camera_ptr->lookat.camUp.y =  FX32_ONE;
	camera_ptr->lookat.camUp.z =  0;

	//J߂炦Ώە̍Wւ̃|C^
	camera_ptr->BindTarget = NULL;
	
	camera_ptr->XBind = FALSE;
	camera_ptr->YBind = FALSE;
	camera_ptr->ZBind = FALSE;

	camera_ptr->Trace = NULL;
}

//---------------------------------------------------------------------------
/**
 * @brief	oCh
 * 
 * @param	inCamera	J|C^
 * @param	outVec		oCh
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
static void FixBindValid(GF_CAMERA_CONST_PTR inCamera, VecFx32 *outVec)
{
	if (inCamera->XBind == FALSE){
		outVec->x = 0;
	}
	if (inCamera->YBind == FALSE){
		outVec->y = 0;
	}
	if (inCamera->ZBind == FALSE){
		outVec->z = 0;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	g[Xf[^̍XV
 * 
 * @param	camera_ptr	J|C^
 * @param	inVec		obt@Ɋi[W
 * @param	outVec		KpW
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
static void UpdateTraceData(GF_CAMERA_CONST_PTR camera_ptr, const VecFx32 *inVec, VecFx32 *outVec)
{
	int *cam;
	int *target;
	if (camera_ptr->Trace==NULL){
		(*outVec) = (*inVec);
	}else{
		cam = &camera_ptr->Trace->CamPoint;
		target = &camera_ptr->Trace->TargetPoint;
		if (!camera_ptr->Trace->UpdateFlg){
			(*outVec) = (*inVec);
			if (*cam==camera_ptr->Trace->Delay){
				camera_ptr->Trace->UpdateFlg = TRUE;
			}
		}else{
			//f[^W擾
			(*outVec) = camera_ptr->Trace->HistPos[(*cam)];
		}
		//QƈʒuXV
		(*cam) = ((*cam)+1)%camera_ptr->Trace->HistNum;
		//ɐς
		camera_ptr->Trace->HistPos[(*target)] = (*inVec);
		//ʒuXV
		(*target) = ((*target)+1)%camera_ptr->Trace->HistNum;
		
		//g[Xf[^̖ẂÂ܂܌ݍW̗p
		if (!camera_ptr->Trace->ValidX){	//
			outVec->x = inVec->x;
		}
		if (!camera_ptr->Trace->ValidY){	//
			outVec->y = inVec->y;
		}
		if (!camera_ptr->Trace->ValidZ){	//
			outVec->z = inVec->z;
		}
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	g[X\̂̃AP[V@JΏەɃoChς݂ł邱
 * 
 * @param	inHistNum		obt@TCY
 * @param	inDelay			xx
 * @param	inTraceMask		g[X}XN	camera.hɒ`
 * @param	inHeapID		q[vID
 * @param	ioCamera		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_AllocTraceData(const int inHistNum, const int inDelay,
						const int inTraceMask, const int inHeapID,
						GF_CAMERA_PTR ioCamera)
{
	int i;
	GF_CAMERA_TRACE *trace;
	//oChĂȂ΁AȂ
	if (ioCamera->BindTarget == NULL){
		return;
	}
	//zTCY̐`FbN
	GF_ASSERT((inDelay+1<=inHistNum)&&"z񐔂܂");
	
	trace = sys_AllocMemory(inHeapID,sizeof(GF_CAMERA_TRACE));
	trace->HistPos = sys_AllocMemory(inHeapID,sizeof(VecFx32)*inHistNum);
	
	//g[XzNA
	for(i=0;i<inHistNum;i++){
		trace->HistPos[i].x = 0;
		trace->HistPos[i].y = 0;
		trace->HistPos[i].z = 0;
	}
	
	trace->HistNum = inHistNum;
	//OԖڂɃJQƈʒuZbg
	trace->CamPoint = 0;
	//ΏەQƈʒuZbg
	trace->TargetPoint = 0+inDelay;
	
	trace->Delay = inDelay;
	trace->UpdateFlg = FALSE;
	
	trace->ValidX = FALSE;
	trace->ValidY = FALSE;
	trace->ValidZ = FALSE;
	if (inTraceMask & CAM_TRACE_MASK_X){
		trace->ValidX = TRUE;
	}
	if (inTraceMask & CAM_TRACE_MASK_Y){
		trace->ValidY = TRUE;
	}
	if (inTraceMask & CAM_TRACE_MASK_Z){
		trace->ValidZ = TRUE;
	}
	
	ioCamera->Trace = trace;
}

//---------------------------------------------------------------------------
/**
 * @brief	g[Xf[^̉
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_FreeTraceData(GF_CAMERA_PTR camera_ptr)
{
	if (camera_ptr->Trace!=NULL){
		sys_FreeMemoryEz(camera_ptr->Trace->HistPos);
		sys_FreeMemoryEz(camera_ptr->Trace);
		camera_ptr->Trace = NULL;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	J쐬
 * 
 * @param	inHeapID		q[vID
 * 
 * @return	GF_CAMERA_PTR	J|C^
 */
//---------------------------------------------------------------------------
GF_CAMERA_PTR GFC_AllocCamera(const int inHeapID)
{
	GF_CAMERA_PTR camera_ptr;
	camera_ptr = sys_AllocMemory(inHeapID,sizeof(GF_CAMERA));
	return camera_ptr;
}

//---------------------------------------------------------------------------
/**
 * @brief	J
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_FreeCamera(GF_CAMERA_PTR camera_ptr)
{
	//J{̂̉
	sys_FreeMemoryEz( camera_ptr );
}

//---------------------------------------------------------------------------
/**
 * @brief	JRs[
 * 
 * @param	inCamera		Rs[J|C^
 * @param	outCamera		Rs[J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_CopyCamera(GF_CAMERA_CONST_PTR inCamera, GF_CAMERA_PTR outCamera)
{
	*outCamera = (*inCamera);
}

//---------------------------------------------------------------------------
/**
 * @brief	Jg[Xf[^̃|C^Rs[
 * 
 * @param	inCamera		Rs[J|C^
 * @param	outCamera		Rs[J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_CopyCameraTracePtr(GF_CAMERA_CONST_PTR inCamera, GF_CAMERA_PTR outCamera)
{
	outCamera->Trace = inCamera->Trace;
}

//---------------------------------------------------------------------------
/**
 * @brief	J̃A^b`(J̗L)
 * 
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_AttachCamera(GF_CAMERA_PTR camera_ptr)
{
	GF_Camera = camera_ptr;
}

//---------------------------------------------------------------------------
/**
 * @brief	JNULLZbgiA^b`j
 * 
 * @param	none
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_PurgeCamera(void)
{
	GF_Camera = NULL;
}

//---------------------------------------------------------------------------
/**
 * @brief	Jf֐i`掞ɌĂԁj
 * 
 * @param	none
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_CameraLookAt(void)
{
	if (GF_Camera == NULL){
		return;
	}
	
	//JoChĂȂDIɂ̍W߂炦
	if (GF_Camera->BindTarget != NULL){
		//ړvZ
		VecFx32 vec;
		VecFx32 dst_vec;
		VEC_Subtract(GF_Camera->BindTarget,&GF_Camera->BindTargetOld,&vec);

		FixBindValid(GF_Camera,&vec);
		UpdateTraceData(GF_Camera, &vec, &dst_vec);
		
		GFC_ShiftCamera(&dst_vec,GF_Camera);
		GF_Camera->BindTargetOld = *GF_Camera->BindTarget;
	}
	NNS_G3dGlbLookAt(&GF_Camera->lookat.camPos, &GF_Camera->lookat.camUp, &GF_Camera->lookat.target);
}

//---------------------------------------------------------------------------
/**
 * @brief	J̏ݒ
 * 
 * @param	inCamUp		J`xNg
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCamUp(const VecFx32 *inCamUp,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->lookat.camUp = *inCamUp;
}

//---------------------------------------------------------------------------
/**
 * @brief	JoChΏەZbg
 * 
 * @param	inTarget	oChΏۍW
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_BindCameraTarget(const VecFx32 *inTarget, GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->BindTarget = inTarget;
	camera_ptr->BindTargetOld = *inTarget;
}

//---------------------------------------------------------------------------
/**
 * @brief	JoChĂΏە؂藣
 * 
 * @param	camera_ptr	J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_PurgeCameraTarget(GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->BindTarget = NULL;
	camera_ptr->XBind = FALSE;
	camera_ptr->YBind = FALSE;
	camera_ptr->ZBind = FALSE;
}

//---------------------------------------------------------------------------
/**
 * @brief	݂̃JXbvobt@[h擾
 * 
 * @param	none
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
GXBufferMode GetBufferMode(void)
{
	if (GF_Camera!=NULL){
		if (GF_Camera->View == GF_CAMERA_PERSPECTIV){
			return GX_BUFFERMODE_W;
		}else{
			return GX_BUFFERMODE_Z;
		}
	}else{
		OS_Printf("ERROR:obt@[h擾s");
		return GX_BUFFERMODE_W;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	J̃Nbvp[^Zbg
 * 
 * @param	near			jANbvl
 * @param	far				t@[Nbvl
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCameraClip(const fx32 near,const fx32 far,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->persp.nearClip = near;
	camera_ptr->persp.farClip = far;
	GFC_SetCameraView(camera_ptr->View,camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	J\̂(_AAAOgď)
 * 
 * @param	inTarget		Ώے_
 * @param	inDistance		_܂ł̋
 * @param	inAngle			AO
 * @param	inPerspWay		p[X
 * @param	inView			ˉe[h
 * @param	inBindFlg		_Ƃ̃oChL
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_InitCameraTDA
( const VecFx32* inTarget,
  const fx32 inDistance,
  const CAMERA_ANGLE *inAngle,
  const u16 inPerspWay,
  const u8 inView,
  const BOOL inBindFlg,
  GF_CAMERA_PTR camera_ptr
)
{
	// J̐ݒ
	InitCameraCommon(inPerspWay,camera_ptr);
	
	//_Zbg
	camera_ptr->lookat.target = *inTarget;
	
	//_̃Jʒűݒ
	camera_ptr->Distance = inDistance;

	//AOZbg
	camera_ptr->Angle = *inAngle;

	// J̍WZbg
	SetCamPosByTarget_Dist_Ang(camera_ptr);

	//ˉeZbg
	GFC_SetCameraView(inView,camera_ptr);

	if (inBindFlg){
		//J̕߂炦ΏەoCh
		camera_ptr->BindTarget = inTarget;
		camera_ptr->BindTargetOld = *inTarget;
		camera_ptr->XBind = TRUE;
		camera_ptr->YBind = TRUE;
		camera_ptr->ZBind = TRUE;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	J\̂(JʒuAAAOgď)
 * 
 * @param	inCamPos		Jʒu
 * @param	inDistance		_܂ł̋
 * @param	inAngle			AO
 * @param	inPerspWay		p[X
 * @param	inView			ˉe[h
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_InitCameraCDA
( const VecFx32* inCamPos,
  const fx32 inDistance,
  const CAMERA_ANGLE *inAngle,
  const u16 inPerspWay,
  const u8 inView,
  GF_CAMERA_PTR camera_ptr
)
{
	// J̐ݒ
	InitCameraCommon(inPerspWay,camera_ptr);

	//J̍WZbg
	camera_ptr->lookat.camPos = *inCamPos;
	
	//Jʒu璍_܂ł̋ݒ
	camera_ptr->Distance = inDistance;

	//AOZbg
	camera_ptr->Angle = *inAngle;

	// _̍WZbg
	SetTargetByCamPos_Dist_Ang(camera_ptr);

	//ˉeZbg
	GFC_SetCameraView(inView,camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	J\̂(_AJʒugď@Z]Ή)
 * 
 * @param	inTarget		Ώے_
 * @param	inCamPos		Jʒu
 * @param	inPerspWay		p[X
 * @param	inView			ˉe[h
 * @param	inBindFlg		_Ƃ̃oChL
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_InitCameraTC
( const VecFx32* inTarget,
  const VecFx32* inCamPos,
  const u16 inPerspWay,
  const u8 inView,
  const BOOL inBindFlg,
  GF_CAMERA_PTR camera_ptr
)
{
	VecFx32 dst;
	// J̐ݒ
	InitCameraCommon(inPerspWay,camera_ptr);
	
	//_Zbg
	camera_ptr->lookat.target = *inTarget;

	//J̍WZbg
	camera_ptr->lookat.camPos = *inCamPos;
	
	//_̃Jʒűݒ
	VEC_Subtract(inCamPos, inTarget , &dst);
	camera_ptr->Distance = VEC_Mag(&dst); 

	//AOZbg
	{
		VecFx32 x_vec = {0,0,0};
		VecFx32 y_vec = {0,0,0};
		VecFx32 vec = {0,0,0};
		VecFx32 base_vec;
		base_vec.x = 0;
		base_vec.y = 0;
		base_vec.z = FX32_ONE;
		vec = dst;
		vec.y = 0;
		camera_ptr->Angle.y = GetRad(&base_vec, &vec );
		
		base_vec.x = FX32_ONE;
		base_vec.y = 0;
		base_vec.z = 0;
		vec.x = dst.z;
		vec.z = dst.y;
		vec.y = 0;
		camera_ptr->Angle.x = GetRad(&base_vec, &vec );

		camera_ptr->Angle.z = 0;

		OS_Printf("ANGGLE_%x,%x,%x\n",camera_ptr->Angle.x,camera_ptr->Angle.y,camera_ptr->Angle.z);
	}
	
	//ˉeZbg
	GFC_SetCameraView(inView,camera_ptr);

	if (inBindFlg){
		//J̕߂炦ΏەoCh
		camera_ptr->BindTarget = inTarget;
		camera_ptr->BindTargetOld = *inTarget;
		camera_ptr->XBind = TRUE;
		camera_ptr->YBind = TRUE;
		camera_ptr->ZBind = TRUE;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	ˉeZbg
 * 
 * @param	inView			ˉe[h
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCameraView(const u8 inView,GF_CAMERA_PTR camera_ptr)
{
	// ˉe`FbN
	if( inView == GF_CAMERA_PERSPECTIV )
	{
		// ˉe
		NNS_G3dGlbPerspective
			(camera_ptr->persp.fovySin, camera_ptr->persp.fovyCos,
			 camera_ptr->persp.aspect, camera_ptr->persp.nearClip,
			 camera_ptr->persp.farClip);
		camera_ptr->View = GF_CAMERA_PERSPECTIV;
		SwapBuffMode = GX_BUFFERMODE_Z;//GX_BUFFERMODE_W;
	}
	else	//(inVew == SIMPLE_ORTHO)
	{
		fx32	height, width;			// ƕ

		//-------- ˉe --------
		// ˉe̐ݒ肩琳ˉeZbg
		// ߂
		height = FX_Mul(FX_Div(camera_ptr->persp.fovySin, camera_ptr->persp.fovyCos), camera_ptr->Distance);
		// ߂
		width  = FX_Mul(height, camera_ptr->persp.aspect );

		NNS_G3dGlbOrtho(
			height,
			-height,
			-width,
			width,
			camera_ptr->persp.nearClip,
			camera_ptr->persp.farClip
		);
		camera_ptr->View = GF_CAMERA_ORTHO;
		SwapBuffMode = GX_BUFFERMODE_Z;
	}
}

//---------------------------------------------------------------------------
/**
 * @brief	p̃Zbg
 * 
 * @param	inPerspWay		p[X
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCameraPerspWay(const u16 inPerspWay,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->PerspWay = inPerspWay;

	/*== ˉe̊pxZbg ==*/
	camera_ptr->persp.fovySin  = FX_SinIdx( camera_ptr->PerspWay );
	camera_ptr->persp.fovyCos  = FX_CosIdx( camera_ptr->PerspWay );

	GFC_SetCameraView(camera_ptr->View,camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	p̉Z
 * 
 * @param	inPerspWay		Zp[X
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_AddCameraPerspWay(const u16 inPerspWay,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->PerspWay += inPerspWay;

	/*== ˉe̊pxZbg ==*/
	camera_ptr->persp.fovySin  = FX_SinIdx( camera_ptr->PerspWay );
	camera_ptr->persp.fovyCos  = FX_CosIdx( camera_ptr->PerspWay );

	GFC_SetCameraView(camera_ptr->View,camera_ptr);
}
#if 0
//JʒũZbg
void SetCameraPos(const VecFx32* inCamPos)
{
	camera_ptr->lookat.camPos = *inCamPos;
}

//_̃Zbg
void SetCameraTarget(const VecFx32* inTarget)
{
	camera_ptr->lookat.target = *inTarget;
}

//_ړ
void MoveTarget(const VecFx32 *inMoveVec)
{
	VEC_Add(&camera_ptr->lookat.target,&inMoveVec,&Gf_Camera.lookat.target);
}

//Jʒuړ
void MoveCameraPos(const VecFx32 *inMoveVec)
{
	VEC_Add(&camera_ptr->lookat.camPos,&inMoveVec,&camera_ptr->lookat.camPos);
}
#endif

//---------------------------------------------------------------------------
/**
 * @brief	Jƒ_𓯎ɕsړ
 * 
 * @param	inMoveVec		ړl
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_ShiftCamera(const VecFx32 *inMoveVec,GF_CAMERA_PTR camera_ptr)
{
	//Jݒ
	VEC_Add(&camera_ptr->lookat.camPos,inMoveVec,&camera_ptr->lookat.camPos);
	VEC_Add(&camera_ptr->lookat.target,inMoveVec,&camera_ptr->lookat.target);
}

//---------------------------------------------------------------------------
/**
 * @brief	JAOZbg	]
 * 
 * @param	inAngle			AO
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCameraAngleRot(const CAMERA_ANGLE *inAngle,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->Angle = *inAngle;
	SetTargetByCamPos_Dist_Ang(camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	JAOZbg	]
 * 
 * @param	inAngle			AO
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCameraAngleRev(const CAMERA_ANGLE *inAngle,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->Angle = *inAngle;
	SetCamPosByTarget_Dist_Ang(camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	JAOZ	]
 * 
 * @param	inAngle			ZAO
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_AddCameraAngleRot(const CAMERA_ANGLE *inAngle,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->Angle.x += inAngle->x;
	camera_ptr->Angle.y += inAngle->y;
	camera_ptr->Angle.z += inAngle->z;
	SetTargetByCamPos_Dist_Ang(camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	JAOZ	]
 * 
 * @param	inAngle			ZAO
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_AddCameraAngleRev(const CAMERA_ANGLE *inAngle,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->Angle.x += inAngle->x;
	camera_ptr->Angle.y += inAngle->y;
	camera_ptr->Angle.z += inAngle->z;
	SetCamPosByTarget_Dist_Ang(camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	JZbg
 * 
 * @param	inDist			
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_SetCameraDistance(const fx32 inDist,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->Distance = inDist;
	SetCamPosByTarget_Dist_Ang(camera_ptr);
}

//---------------------------------------------------------------------------
/**
 * @brief	JZ
 * 
 * @param	inDist			Z
 * @param	camera_ptr		J|C^
 * 
 * @return	none
 */
//---------------------------------------------------------------------------
void GFC_AddCameraDistance(const fx32 inDist,GF_CAMERA_PTR camera_ptr)
{
	camera_ptr->Distance += inDist;
	SetCamPosByTarget_Dist_Ang(camera_ptr);
}

//////////////////////////////////
//擾֐(܂SĂ܂)//
//////////////////////////////////

//---------------------------------------------------------------------------
/**
 * @brief	ˉe擾
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	u8				ˉe[h
 */
//---------------------------------------------------------------------------
u8 GFC_GetCameraView(GF_CAMERA_CONST_PTR camera_ptr)
{
	return camera_ptr->View;
}

//---------------------------------------------------------------------------
/**
 * @brief	p̎擾
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	u16				p[X
 */
//---------------------------------------------------------------------------
u16 GFC_GetCameraPerspWay(GF_CAMERA_CONST_PTR camera_ptr)
{
	return camera_ptr->PerspWay;
}

//---------------------------------------------------------------------------
/**
 * @brief	̎擾
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	fx32			
 */
//---------------------------------------------------------------------------
fx32 GFC_GetCameraDistance(GF_CAMERA_CONST_PTR camera_ptr)
{
	return camera_ptr->Distance;
}

//---------------------------------------------------------------------------
/**
 * @brief	AO擾
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	CAMERA_ANGLE	AO
 */
//---------------------------------------------------------------------------
CAMERA_ANGLE GFC_GetCameraAngle(GF_CAMERA_CONST_PTR camera_ptr)
{
	return camera_ptr->Angle;
}

//---------------------------------------------------------------------------
/**
 * @brief	_̎擾
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	VecFx32			_
 */
//---------------------------------------------------------------------------
VecFx32 GFC_GetLookTarget(GF_CAMERA_CONST_PTR camera_ptr)
{
	return camera_ptr->lookat.target;
}

//---------------------------------------------------------------------------
/**
 * @brief	Jʒu̎擾
 * 
 * @param	camera_ptr		J|C^
 * 
 * @return	VecFx32			Jʒu
 */
//---------------------------------------------------------------------------
VecFx32 GFC_GetCameraPos(GF_CAMERA_CONST_PTR camera_ptr)
{
	return camera_ptr->lookat.camPos;
}
