//==============================================================================
/**
 *
 *@file		heapsys.c
 *@brief	q[v̈Ǘ
 *@author	taya
 *@data		2005.08.25
 *
 */
//==============================================================================
#include "common.h"
#include "system.h"
#include "gflib\heapsys.h"

#ifdef PM_DEBUG
#include  "system\heapdefine.h"
//#define  HEAP_DEBUG_PRINT
//#define  ALLOCINFO_PRINT_HEAPID   HEAPID_XXXX		// ̃q[vhcɊւĂ̂ݏڍׂȏo
#endif

//----------------------------------------------------------------
/**
 *	萔
 */
//----------------------------------------------------------------
#define DEFAULT_ALIGN					(4)		// mێ̃ACgl
#define MEMBLOCK_FILENAME_AREASIZE		(12)	// fobOpwb_Ɋi[t@C̈TCY
#define USER_HEAP_MAX					(24)	// xɍ쐬\ȃ[U[q[v̐

//----------------------------------------------------------------
/**
 *	[N`
 */
//----------------------------------------------------------------
typedef struct {
	NNSFndHeapHandle*	handle;
	NNSFndHeapHandle*	parentHandle;
	void**              heapMemBlock;
	u16*				count;
	u8*					handleIdxTbl;

	u16     heapMax;
	u16     baseHeapMax;
	u16     usableHeapMax;
	u16     invalidHandleIdx;


}HEAP_SYS;


//----------------------------------------------------------------
/**
 *	ubNwb_`
 */
//----------------------------------------------------------------
typedef struct {
	char	filename[ MEMBLOCK_FILENAME_AREASIZE ];	///< Ăяo\[X
	u32		heapID  : 8;							///< u32
	u32		lineNum : 24;							///< Ăяo\[Xsԍ
}MEMORY_BLOCK_HEADER;


//----------------------------------------------------------------
/**
 *	O[o
 */
//----------------------------------------------------------------
static HEAP_SYS  HeapSys = { 0 };


//----------------------------------------------------------------
/**
 *	nh擾}N
 */
//----------------------------------------------------------------
#define GetHeapHandle(idx)			(HeapSys.handle[ HeapSys.handleIdxTbl[ (idx) ] ])
#define GetParentHeapHandle(idx)	(HeapSys.parentHandle[ HeapSys.handleIdxTbl[ (idx) ] ])
#define GetHeapMemBlock(idx)		(HeapSys.heapMemBlock[ HeapSys.handleIdxTbl[ (idx) ] ])

#define SetHeapHandle(idx,h)		(HeapSys.handle[ HeapSys.handleIdxTbl[ (idx) ] ] = (h))
#define SetParentHeapHandle(idx,h)	(HeapSys.parentHandle[ HeapSys.handleIdxTbl[ (idx) ] ] = (h))
#define SetHeapMemBlock(idx,m)		(HeapSys.heapMemBlock[ HeapSys.handleIdxTbl[ (idx) ] ] = (m))


//==============================================================
// Prototype
//==============================================================
static int SearchEmptyHandleIndex( void );
static void* AllocMemoryCore( NNSFndHeapHandle heapHandle, u32 size, s32 alignment, u32 heapID );
static void HeaderDebugParamSet( MEMORY_BLOCK_HEADER* header, const char* filename, u32 line_no );
static void PrintShortHeap( u32 heapID, u32 size, const char* filename, u32 line_num );
static void PrintExistMemoryBlocks( u32 heapID );
static void HeapConflictVisitorFunc(void* memBlock, NNSFndHeapHandle heapHandle, u32 param);




#ifdef PM_DEBUG
static void HeaderDebugParamSet( MEMORY_BLOCK_HEADER* header, const char* filename, u32 line_no );
static void PrintExistMemoryBlocks( u32 heapID );
static void HeapConflictVisitorFunc(void* memBlock, NNSFndHeapHandle heapHandle, u32 param);
static void CopyFileName( char* dst, const MEMORY_BLOCK_HEADER* header );
#endif

//------------------------------------------------------------------------------
/*---------------------------------------------------------------------------*
  Name:         sys_InitMemory

  Description:  VXeq[vƃAvP[Vq[v쐬܂Bq[v
  				ɂNITRO-System̊gq[vgpĂ܂B
  				
  				VXeq[vp̃ƂāASYSTEM_HEAP_SIZECA
  				[imۂACA[i̎cSăAvP[V
  				q[vp̃ɊmۂĂ܂B
  				
  				VXeq[v́AQ[VXẽVXevOŎgp
  				邱Ƃz肵Ă܂BAvP[Vq[vɂ́AQ[
  				Ŏgpf[^[hׂɎgp܂B

  Arguments:    ȂB
  Returns:      ȂB
 *---------------------------------------------------------------------------*/
//------------------------------------------------------------------------------
void sys_InitMemory(const HEAP_INIT_HEADER* header, u32 baseHeapMax, u32 totalHeapMax)
{
	void *mem;
	u32  usableHeapMax, i;

	usableHeapMax = baseHeapMax + USER_HEAP_MAX;
	if( totalHeapMax < usableHeapMax )
	{
		totalHeapMax = usableHeapMax;
	}

	/*
	 * q[vnḧ́A쐬\q[v{P@쐬B
	 * Ō̂P͖lĂāA쐬q[ṽCfbNXe[u͂w悤ɂB
	 */
	HeapSys.handle = OS_AllocFromMainArenaLo(
									sizeof(NNSFndHeapHandle) * (usableHeapMax + 1)
								+	sizeof(NNSFndHeapHandle) * (usableHeapMax)
								+	sizeof(void*) * (usableHeapMax)
								+   sizeof(u16) * (totalHeapMax)
								+	totalHeapMax, DEFAULT_ALIGN);

	HeapSys.parentHandle = HeapSys.handle + (usableHeapMax + 1);
	HeapSys.heapMemBlock = (void**)((u8*)(HeapSys.parentHandle) + (sizeof(NNSFndHeapHandle) * usableHeapMax));
	HeapSys.count = (u16*)((u8*)(HeapSys.heapMemBlock) + (sizeof(void*) * usableHeapMax));
	HeapSys.handleIdxTbl = (u8*)(HeapSys.count) + (sizeof(u16) * (totalHeapMax));

	HeapSys.heapMax = totalHeapMax;
	HeapSys.baseHeapMax = baseHeapMax;
	HeapSys.invalidHandleIdx = usableHeapMax;
	HeapSys.usableHeapMax = usableHeapMax;


	// {q[vCfbNX쐬
	for(i = 0; i < baseHeapMax; i++)
	{
		switch( header[i].arenaID ){
		case OS_ARENA_MAIN:
		default:
			mem = OS_AllocFromMainArenaLo( header[i].size, DEFAULT_ALIGN );
			break;
		case OS_ARENA_MAINEX:
			mem = OS_AllocFromMainExArenaHi( header[i].size, DEFAULT_ALIGN );
			break;
		}

		if( mem != NULL )
		{
			HeapSys.handle[i] = NNS_FndCreateExpHeap( mem, header[i].size );
			HeapSys.handleIdxTbl[i] = i;
		}
		else
		{
			GF_ASSERT(0);
		}
	}

	// [U[q[v͖̈lŃNAĂ
	for(i = baseHeapMax; i < (usableHeapMax + 1); i++ )
	{
		HeapSys.handle[i] = NNS_FND_HEAP_INVALID_HANDLE;
		HeapSys.handleIdxTbl[i] = HeapSys.invalidHandleIdx;
	}
	while( i < totalHeapMax )
	{
		HeapSys.handleIdxTbl[i++] = HeapSys.invalidHandleIdx;
	}

	// AllocJE^NA
	for(i = 0; i < totalHeapMax; i++)
	{
		HeapSys.count[i] = 0;
	}


}


//------------------------------------------------------------------
/**
 * nḧ̋󂫂
 *
 * @retval  int		󂫂΃CfbNXio[^Ȃ-1
 */
//------------------------------------------------------------------
static int SearchEmptyHandleIndex( void )
{
	int i;

	// {q[v͉ȂnYȂ̂Łc
	for( i = HeapSys.baseHeapMax; i < HeapSys.usableHeapMax; i++ )
	{
		if(HeapSys.handle[i] == NNS_FND_HEAP_INVALID_HANDLE)
		{
			return i;
		}
	}
	return -1;
}

//------------------------------------------------------------------
/**
 * q[v쐬
 *
 * @param   parentHeapID		̈mۗpq[vhciɗLłKvj
 * @param   childHeapID			VKɍ쐬q[vhc
 * @param   size				q[vTCY
 *
 * @retval	BOOL				TRUEō쐬^FALSEŎs
 */
//------------------------------------------------------------------
BOOL sys_CreateHeap( u32 parentHeapID, u32 childHeapID, u32 size )
{
	if( HeapSys.handleIdxTbl[childHeapID] == HeapSys.invalidHandleIdx )
	{
		NNSFndHeapHandle  parentHeap = GetHeapHandle(parentHeapID);
		if( parentHeap != NNS_FND_HEAP_INVALID_HANDLE )
		{
			void* mem = NNS_FndAllocFromExpHeapEx( parentHeap, size, DEFAULT_ALIGN );
			if( mem != NULL )
			{
				int i = SearchEmptyHandleIndex();
				if( i >= 0 )
				{
					HeapSys.handle[i] = NNS_FndCreateExpHeap( mem, size );
					if( HeapSys.handle[i] != NNS_FND_HEAP_INVALID_HANDLE )
					{
						HeapSys.parentHandle[i] = parentHeap;
						HeapSys.heapMemBlock[i] = mem;
						HeapSys.handleIdxTbl[childHeapID] = i;
						#ifdef HEAP_DEBUG_PRINT
						{
							u32 allocatableSize = NNS_FndGetTotalFreeSizeForExpHeap( HeapSys.handle[i] );
							OS_TPrintf("HEAP%02d Created in HEAP%02d\n", childHeapID, parentHeapID );
							OS_TPrintf("HEAP%02d size = 0x%xbytes,  allocatable area = 0x%xbytes\n", childHeapID, size, allocatableSize );
							OS_TPrintf("HEAP%02d rest = 0x%xbytes\n", parentHeapID, NNS_FndGetTotalFreeSizeForExpHeap( parentHeap ) );
						}
						#endif
						return TRUE;
					}
					else
					{
						GF_ASSERT(0 && "q[v쐬Ɏs");
					}

				}
				else
				{
					GF_ASSERT(0 && "q[vǗe[uɋ󂫂");
				}
			}
			else
			{
				TPRINTF("*** 0x%xbytes ̃q[v쐬łȂ*** \n", size);
				OS_Printf("*** ID:%d ̎cTCY=0x%xbytes\n", parentHeapID, NNS_FndGetTotalFreeSizeForExpHeap( parentHeap ) );
				GF_ASSERT(0 && "쐬q[v̎c胁TCYs");
			}
		}
		else
		{
			GF_ASSERT(0 && "쐬q[vhc");
		}
	}
	else
	{
		GF_ASSERT(0 && "q[vQdɍ悤Ƃ");
	}
	return FALSE;
}

//------------------------------------------------------------------
/**
 * q[vj
 *
 * @param   heapID		q[vID
 *
 */
//------------------------------------------------------------------
void sys_DeleteHeap( u32 heapID )
{
	NNSFndHeapHandle  handle, parentHandle;

	handle = GetHeapHandle(heapID);


	if(handle != NNS_FND_HEAP_INVALID_HANDLE)
	{
		NNSFndHeapHandle  parentHandle;
		void* heapMemBlock;

	// fobȌ͖o
		#ifdef PM_DEBUG
		if( HeapSys.count[heapID] )
		{
			TPRINTF("HeapID:%d  restcnt = %d .....\n", heapID, HeapSys.count[heapID]);
			#ifdef PM_DEBUG
			{
				u32  siz = NNS_FndGetTotalFreeSizeForExpHeap( handle );
				OS_TPrintf(" ID %d  freesize = 0x%x bytes \n", heapID, siz );
			}
			#endif
			PrintExistMemoryBlocks( heapID );
			GF_ASSERT_MSG(0, ".......... L̖ubNcĂ܂\n");
		}
		#endif

		NNS_FndDestroyExpHeap( handle );

		parentHandle = GetParentHeapHandle(heapID);
		heapMemBlock = GetHeapMemBlock(heapID);
		if(	(parentHandle != NNS_FND_HEAP_INVALID_HANDLE)
		&&	(heapMemBlock != NULL)
		){
			NNS_FndFreeToExpHeap( parentHandle, heapMemBlock );
		}else{
			GF_ASSERT(0);
		}

		SetHeapHandle(heapID, NNS_FND_HEAP_INVALID_HANDLE);
		SetParentHeapHandle(heapID, NNS_FND_HEAP_INVALID_HANDLE);
		SetHeapMemBlock(heapID, NULL);
		HeapSys.handleIdxTbl[ heapID ] = HeapSys.invalidHandleIdx;

		#ifdef HEAP_DEBUG_PRINT
		TPRINTF("*** ID:%d ̃q[vꂽ ***\n", heapID);
		OS_TPrintf("*** eq[v̎cTCY=0x%xbytes\n", NNS_FndGetTotalFreeSizeForExpHeap( parentHandle ));
		#endif
	}
}

//------------------------------------------------------------------
/**
 * AP[g{́ifobOŁAiłƂRCcĂяoj
 *
 * @param   heapHandle		gq[vnh
 * @param   size			AP[gTCY
 * @param   alignment		ACg
 * @param   heapID			wb_ɕۑq[vID
 *
 * @retval  void*			mۂiwb_͔΂Ăj
 */
//------------------------------------------------------------------
static void* AllocMemoryCore( NNSFndHeapHandle heapHandle, u32 size, s32 alignment, u32 heapID )
{
	void* mem;

	GF_ASSERT(heapHandle != NNS_FND_HEAP_INVALID_HANDLE);
	mem = NNS_FndAllocFromExpHeapEx( heapHandle, size + sizeof(MEMORY_BLOCK_HEADER), alignment );

	if( mem != NULL )
	{
		((MEMORY_BLOCK_HEADER*)mem)->heapID = heapID;
		(u8*)mem += sizeof(MEMORY_BLOCK_HEADER);
	}
	return mem;
}



#ifndef PM_DEBUG
//------------------------------------------------------------------
/**
 * q[v烁mۂ
 *
 * @param   heapID		q[vhc
 * @param   size		mۃTCY
 *
 * @retval  void*		mۂ̈AhXisȂNULLj
 */
//------------------------------------------------------------------
void* sys_AllocMemory( u32 heapID, u32 size )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle  h = GetHeapHandle( heapID );
		return AllocMemoryCore( h, size, DEFAULT_ALIGN, heapID );
	}
	else
	{
		GF_ASSERT(0);
		return NULL;
	}
}
//------------------------------------------------------------------
/**
 * q[v烁mۂie|̈pj
 *
 * @param   heapID		q[vhc
 * @param   size		mۃTCY
 *
 * @retval  void*		mۂ̈AhXisȂNULLj
 */
//------------------------------------------------------------------
void* sys_AllocMemoryLo( u32 heapID, u32 size )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle  h = GetHeapHandle( heapID );
		return AllocMemoryCore( h, size, -DEFAULT_ALIGN, heapID );
	}
	else
	{
		GF_ASSERT(0);
		return NULL;
	}
}
#else	// #ifndef PM_DEBUG

//------------------------------------------------------------------
/**
 * mێ̏ڍ׏\
 *
 * @param   header		ubNwb_
 * @param   handle		ubN܂܂q[ṽnh
 * @param   size		mۃTCYiNGXgꂽTCYj
 *
 */
//------------------------------------------------------------------
static void PrintAllocInfo( const MEMORY_BLOCK_HEADER* header, NNSFndHeapHandle handle, u32 size )
{
	char filename[MEMBLOCK_FILENAME_AREASIZE+1];

	CopyFileName( filename, header );

	OS_TPrintf("ALLOC count=%3d, rest=0x%08x, %s(%d) alloc 0x%08x bytes\n",
				HeapSys.count[header->heapID], NNS_FndGetTotalFreeSizeForExpHeap(handle), 
				filename, header->lineNum, size+sizeof(MEMORY_BLOCK_HEADER) );
}

//------------------------------------------------------------------
/**
 * ̏ڍ׏\
 *
 * @param   heapID			q[vID
 * @param   size			mۂTCY
 * @param   handle			q[vnh
 * @param   filename		Ăяo\[Xt@C
 * @param   line			Ăяo\[Xt@Csԍ
 *
 */
//------------------------------------------------------------------
static void PrintFreeInfo( const MEMORY_BLOCK_HEADER* header, NNSFndHeapHandle handle)
{
	char filename[MEMBLOCK_FILENAME_AREASIZE+1];

	CopyFileName( filename, header );

	OS_TPrintf("FREE  count=%3d, rest=0x%08x, %s(%d)\n",
				HeapSys.count[header->heapID], NNS_FndGetTotalFreeSizeForExpHeap(handle), 
				filename, header->lineNum );
}



//------------------------------------------------------------------
/**
 * sys_AllocMemorỹfobOpbp[֐
 *
 * @param   heapID			q[vID
 * @param   size			mۃTCY
 * @param   filename		Ăяo\[X̃t@C
 * @param   line_num		Ăяo\[X̍sԍ
 *
 * @retval  void*			mۂ̈AhXisȂNULLj
 */
//------------------------------------------------------------------
void* sys_AllocMemoryDebug( u32 heapID, u32 size, const char* filename, u32 line_num )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle  h = GetHeapHandle( heapID );
		void* mem = AllocMemoryCore( h, size, DEFAULT_ALIGN, heapID );
		if( mem != NULL )
		{
			HeaderDebugParamSet((MEMORY_BLOCK_HEADER*)( (u8*)mem - sizeof(MEMORY_BLOCK_HEADER) ),
									filename, line_num);
			HeapSys.count[heapID]++;

			#ifdef ALLOCINFO_PRINT_HEAPID
			if( ALLOCINFO_PRINT_HEAPID == heapID )
			{
				const MEMORY_BLOCK_HEADER* mh = (const MEMORY_BLOCK_HEADER*)((u8*)mem - sizeof(MEMORY_BLOCK_HEADER));
				PrintAllocInfo( mh, h, size );
				GF_ASSERT( sys_CheckHeapSafe( heapID ) );
			}
			#endif
		}
		else
		{
			PrintShortHeap( heapID, size, filename, line_num );
			GF_ASSERT(0);
		}

		return mem;
	}
	else
	{
		GF_ASSERT_MSG(0, "heapID = %d\n", heapID);
		return NULL;
	}
}
//------------------------------------------------------------------
/**
 * sys_AllocMemoryLõfobOpbp[֐
 *
 * @param   heapID			q[vID
 * @param   size			mۃTCY
 * @param   filename		Ăяo\[X̃t@C
 * @param   line_num		Ăяo\[X̍sԍ
 *
 * @retval  void*			mۂ̈AhXisȂNULLj
 */
//------------------------------------------------------------------
void* sys_AllocMemoryLoDebug( u32 heapID, u32 size, const char* filename, u32 line_num )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle  h = GetHeapHandle( heapID );
		void* mem = AllocMemoryCore( h, size, -DEFAULT_ALIGN, heapID );
		if( mem != NULL )
		{
			HeaderDebugParamSet((MEMORY_BLOCK_HEADER*)( (u8*)mem - sizeof(MEMORY_BLOCK_HEADER) ),
									filename, line_num);
			HeapSys.count[heapID]++;

			#ifdef ALLOCINFO_PRINT_HEAPID
			if( ALLOCINFO_PRINT_HEAPID == heapID )
			{
				const MEMORY_BLOCK_HEADER* mh = (const MEMORY_BLOCK_HEADER*)((u8*)mem - sizeof(MEMORY_BLOCK_HEADER));
				PrintAllocInfo( mh, h, size );
				GF_ASSERT( sys_CheckHeapSafe( heapID ) );
			}
			#endif
		}
		else
		{
			PrintShortHeap( heapID, size, filename, line_num );
			GF_ASSERT(0);
		}
		return mem;
	}
	else
	{
		GF_ASSERT(0);
		return NULL;
	}
}
//------------------------------------------------------------------
/**
 * ubNwb_ɃfobO
 *
 * @param   header		wb_AhX
 * @param   filename	t@C
 * @param   line_no		sԍ
 *
 */
//------------------------------------------------------------------
static void HeaderDebugParamSet( MEMORY_BLOCK_HEADER* header, const char* filename, u32 line_no )
{
	int i;
	for(i = 0; i < MEMBLOCK_FILENAME_AREASIZE; i++)
	{
		header->filename[i] = filename[i];
		if( filename[i] == '\0' ){ break; }
	}
	header->lineNum = line_no;
}

//------------------------------------------------------------------
/**
 * c胁sĊmۂłȂbZ[W擾
 *
 * @param   heapID		q[vhc
 * @param   size		mۂ悤ƂTCY
 *
 */
//------------------------------------------------------------------
static void PrintShortHeap( u32 heapID, u32 size, const char* filename, u32 line_num )
{
	NNSFndHeapHandle h;
	u32 freeAreaSize, allocatableMaxSize;

	h = GetHeapHandle(heapID);
	freeAreaSize = NNS_FndGetTotalFreeSizeForExpHeap( h );
	allocatableMaxSize = NNS_FndGetAllocatableSizeForExpHeapEx( h, DEFAULT_ALIGN );

	OS_TPrintf("Can't alloc %ldbytes memory from Heap(ID:%d)\n", size, heapID);
	OS_TPrintf("This Heap have %ldbytes Free Area\n", freeAreaSize );
	OS_TPrintf("and %ldbytes Allocatable Area\n", allocatableMaxSize );
	OS_TPrintf("%s(%d)\n", filename, line_num);
}
#endif	// #ifndef PM_DEBUG #else


//------------------------------------------------------------------
/**
 * q[vmۂ
 *
 * @param   memory		mۂAhX
 *
 */
//------------------------------------------------------------------
void sys_FreeMemoryEz( void* memory )
{
	u32 heapID;

	(u8*)memory -= sizeof(MEMORY_BLOCK_HEADER);
	heapID = ((MEMORY_BLOCK_HEADER*)memory)->heapID;

	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle  h = HeapSys.handle[ HeapSys.handleIdxTbl[ heapID ] ];
		GF_ASSERT(h != NNS_FND_HEAP_INVALID_HANDLE);

		GF_ASSERT( HeapSys.count[ heapID ] );
		HeapSys.count[ heapID ]--;

		#ifdef ALLOCINFO_PRINT_HEAPID
		if( ALLOCINFO_PRINT_HEAPID == heapID )
		{
			GF_ASSERT( sys_CheckHeapSafe( heapID ) );
			PrintFreeInfo( (const MEMORY_BLOCK_HEADER*)memory, h );
		}
		#endif

		NNS_FndFreeToExpHeap( h, memory );

	}
	else
	{
		GF_ASSERT_MSG(0, "heapID = %d\n", heapID);
	}
}
//------------------------------------------------------------------
/**
 * q[vmۂiq[vIDwŁj
 *
 * q[vIDw肷鍇IȗR邩Ȃ̂
 *   cĂBʂ FreeMemoryEz gΖȂ͂B
 *
 * @param   heapID		q[vID
 * @param   memory		mۂ|C^
 *
 */
//------------------------------------------------------------------
void sys_FreeMemory( u32 heapID, void* memory )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle h = GetHeapHandle(heapID);

		GF_ASSERT(h != NNS_FND_HEAP_INVALID_HANDLE);

		(u8*)memory -= sizeof(MEMORY_BLOCK_HEADER);
		if( ((MEMORY_BLOCK_HEADER*)memory)->heapID != heapID )
		{
			GF_ASSERT_MSG(0, "mێƈႤq[vIDŉ悤ƂĂ\n");
		}
		NNS_FndFreeToExpHeap( h, memory );

		GF_ASSERT( HeapSys.count[ heapID ] );
		HeapSys.count[ heapID ]--;

		#ifdef ALLOCINFO_PRINT_HEAPID
		if( ALLOCINFO_PRINT_HEAPID == heapID )
		{
			GF_ASSERT( sys_CheckHeapSafe( heapID ) );
			PrintFreeInfo( (const MEMORY_BLOCK_HEADER*)memory, h );
		}
		#endif

	}
	else
	{
		GF_ASSERT(0);
	}
}
//------------------------------------------------------------------
/**
 * q[v̋󂫗̈TCYԂ
 *
 * @param   heapID	q[vID
 *
 * @retval  u32		󂫗̈TCYioCgPʁj
 */
//------------------------------------------------------------------
u32 sys_GetHeapFreeSize( u32 heapID )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle h = GetHeapHandle(heapID);
		return NNS_FndGetTotalFreeSizeForExpHeap( h );
	}
	GF_ASSERT(0);
	return 0;
}
//------------------------------------------------------------------
/**
 * NitroSystem Cun֐vAP[^쐬
 *
 * @param   pAllocator		NNSFndAllocator\̂̃AhX
 * @param   heapID			q[vID
 * @param   alignment		mۂ郁ubNɓKpACg
 *
 */
//------------------------------------------------------------------
void sys_InitAllocator( NNSFndAllocator* pAllocator, u32 heapID, int alignment)
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle h = GetHeapHandle(heapID);
		NNS_FndInitAllocatorForExpHeap( pAllocator, h, alignment );
	}
	else
	{
		GF_ASSERT(0);
	}
}

//------------------------------------------------------------------
/**
 * mۂubÑTCYkB
 *
 * @param   memBlock		ubN|C^
 * @param   newSize			k̃TCYioCgPʁj
 *
 *
 * ḱAubŇ烁邱ƂōsB
 * ꂽ̓VXeɕԊ҂AVȃAP[g̈ƂĎgpłB
 *
 * Ⴆ΁ywb_{́ẑ悤Ȍ`̃OtBbNoCiq`lɓǂݍ݁A
 * ̕VRAMɓ]Awb_݂̂cƂP[XȂǂŎgp邱Ƃ
 * z肵ĂBgp͐TdɁB
 *
 */
//------------------------------------------------------------------
void sys_CutMemoryBlockSize( void* memBlock, u32 newSize )
{
	u32 oldSize;

	(u8*)memBlock -= sizeof(MEMORY_BLOCK_HEADER);
	oldSize = NNS_FndGetSizeForMBlockExpHeap( memBlock );
	newSize += sizeof(MEMORY_BLOCK_HEADER);	// Ăяo̓wb_ӎĂȂ̂

	if( oldSize >= newSize )
	{
		u32 heapID;
		NNSFndHeapHandle handle;

		heapID = ((MEMORY_BLOCK_HEADER*)memBlock)->heapID;
		handle = GetHeapHandle(heapID);

		NNS_FndResizeForMBlockExpHeap( handle, memBlock, newSize );
	}
	else
	{
		GF_ASSERT(0);
	}
}


#ifdef PM_DEBUG
//------------------------------------------------------------------
/**
 * q[v̈悪j󂳂ĂȂ`FbNifobOpj
 *
 * @param   heapID		q[vID
 *
 * @retval  BOOL		j󂳂ĂȂTRUEԂ
 */
//------------------------------------------------------------------
BOOL sys_CheckHeapSafe( u32 heapID )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle h = GetHeapHandle(heapID);
		return NNS_FndCheckExpHeap( h, NNS_FND_HEAP_ERROR_PRINT );
	}
	GF_ASSERT(0);
	return TRUE;
}
//------------------------------------------------------------------
/**
 * q[vmۂubN̎TCY擾ifobOpj
 *
 * @param   memBlock		
 *
 * @retval  u32		ubNTCY
 */
//------------------------------------------------------------------
u32 sys_GetMemoryBlockSize( const void* memBlock )
{
	((u8*)memBlock) -= sizeof(MEMORY_BLOCK_HEADER);
	return NNS_FndGetSizeForMBlockExpHeap( memBlock );
}

//------------------------------------------------------------------
/**
 * wq[ṽAP[g񐔁󂫗̈TCY64bitɃpbNĕԂ
 *iq[vjƂ͕ʂɃ[N`FbNs߁j
 *
 * @param   heapID		q[vID
 *
 * @retval  u64		
 */
//------------------------------------------------------------------
u64 sys_GetHeapState( u32 heapID )
{
	if( heapID < HeapSys.heapMax )
	{
		u64  ret;
		NNSFndHeapHandle h;

		h = GetHeapHandle(heapID);
		ret = (HeapSys.count[heapID] << 32) | NNS_FndGetTotalFreeSizeForExpHeap(h);
		return ret;
	}
	GF_ASSERT(0);
	return 0;
}

/*---------------------------------------------------------------------------*
 * @brief	fobOp󋵕\
*---------------------------------------------------------------------------*/

//------------------------------------------------------------------
/**
 * q[ṽ󂫗eʍv\
 *
 * @param   heapID		
 *
 */
//------------------------------------------------------------------
void sys_PrintHeapFreeSize( u32 heapID )
{
	if( heapID < HeapSys.heapMax )
	{
		NNSFndHeapHandle h = GetHeapHandle(heapID);
		OS_TPrintf("HEAP(ID :%d) FreeArea = %ld bytes\n", heapID, NNS_FndGetTotalFreeSizeForExpHeap(h) );
	}
}
//------------------------------------------------------------------
/**
 * q[v̑SubN\
 *
 * @param   heapID				q[vID
 *
 */
//------------------------------------------------------------------
static void PrintExistMemoryBlocks( u32 heapID )
{
	NNSFndHeapHandle h = GetHeapHandle(heapID);
	NNS_FndVisitAllocatedForExpHeap( h, HeapConflictVisitorFunc, 0 );
}
//------------------------------------------------------------------
/**
 * sys_PrintHeapConflict̃`FbNʂG[ȂA
 * SubNɂĂ̊֐Ă΂
 *
 * @param   memBlock		
 * @param   heapHandle		
 * @param   param		
 *
 */
//------------------------------------------------------------------
static void HeapConflictVisitorFunc(void* memBlock, NNSFndHeapHandle heapHandle, u32 param)
{
	char  filename[MEMBLOCK_FILENAME_AREASIZE + 1];
	int i;

	MEMORY_BLOCK_HEADER* head = (MEMORY_BLOCK_HEADER*)memBlock;

	CopyFileName( filename, head );

	OS_TPrintf(filename);
	OS_TPrintf(" (%d)", head->lineNum );
	OS_TPrintf(" adr:%08x", (u8*)memBlock + sizeof(MEMORY_BLOCK_HEADER));
	OS_TPrintf(" siz:%05x\n", NNS_FndGetSizeForMBlockExpHeap(head));
}

//------------------------------------------------------------------
/**
 * ubNwb_ɕۑĂt@Cobt@ɃRs[
 *
 * @param   dst			Rs[obt@
 * @param   header		ubNwb_
 *
 */
//------------------------------------------------------------------
static void CopyFileName( char* dst, const MEMORY_BLOCK_HEADER* header )
{
	int i;

	// I[R[hiVŗ̈߂ςt@CɎgĂ邽
	// Kv...
	for(i = 0; i < MEMBLOCK_FILENAME_AREASIZE; i++)
	{
		if( header->filename[i] == '\0' ){ break; }
		dst[i] = header->filename[i];
	}
	dst[i] = '\0';

}

#endif	// PM_DEBUG


