//=============================================================================================
/**
 * @file	itask.c
 * @brief	荞ݒɓ^XNVXeB
 * @author	taya(GAME FREAK Inc.)
 * @date	2005.10.06
 */
//=============================================================================================

#include <nitro.h>
#include "itask.h"


//=============================================================================================
//	`
//=============================================================================================

//------------------------------------------------------------------
/** @brief	ITASK\̂̒`
 *
 * ITASK\̂́AD揇ʂɏ]ăNB
 * ̂ߑoN\悤ɑOւ̃|C^B
 *
 * ܂Aꂼ̎ۂ̏ɕKvȃ[NGA͎A
 * ITASKo^Ɏgp郏[NGAƂēnB
 *
 * [U[xł͎QƂKv̂Ȃoւ̃ANZX𐧌邽߁A
 * ̍\̂̓W[炵ANZXłȂB
 * Kvȕ̓ANZX֐oR悤ɂȂĂB
 */
//------------------------------------------------------------------
typedef struct _ITASK {
	ITASK_PTR prev;				///<OITASKւ̃|C^
	ITASK_PTR next;				///<ITASKւ̃|C^
	u32 pri;					///<vCIeB
	void * work;				///<[NGAւ̃|C^
	ITASK_FUNC func;				///<s֐ւ̃|C^
}ITASK;

//------------------------------------------------------------------
//------------------------------------------------------------------
typedef enum _E_ITASKNUM{
	/// ITASK\̂̏`
	ITASK_MAX	= 32,
}ITASKNUM;

//=============================================================================================
//	[Jϐ
//=============================================================================================
//------------------------------------------------------------------
/**
 * ITASK\̂mۂz
 */
//------------------------------------------------------------------

static ITASK ITASKTable[ITASK_MAX] = {};

//------------------------------------------------------------------
/**
 * @brief	gpITASKւ̃|C^i[X^bN
 *
 * ITASK\̂mۂ郏[N͔z񂾂A󂫂TƂɔz擪
 * T[`̂ł͂ȂAOɂׂẴ[ÑAhXX^bNɂłA
 * o悤ɂĂBsvɂȂ[ŃA܂X^bNɂ݂ȂB
 * 邱ƂŃ[N擾ɂ鎞ԂɈɂȂA҂łB
 */
//------------------------------------------------------------------

static ITASK_PTR ITASKStack[ITASK_MAX] = {};

//------------------------------------------------------------------
/**
 * @brief	ITASKX^bÑX^bN|C^
 *
 * ITASKStackŁAgbv̈ʒuւ̃ItZbgێĂ
 */
//------------------------------------------------------------------

static u16 ITASKstackPtr = 0;

//------------------------------------------------------------------
/**
 * @brief	ITASKNXg̐擪w|C^
 *
 * ݁AƂD揇ʂ̍ITASKւ̃|C^ێĂ
 */
//------------------------------------------------------------------

static ITASK ITASKFirst = {
 NULL,
 NULL,
 0,
 NULL,
 NULL,
};	//ԏ

//=============================================================================================
//
//	[J֐
//
//=============================================================================================
//------------------------------------------------------------------
/**
 * @brief	ITASK\̂̏
 *
 * ITASK̃oϐ
 * ֐łƃ}Nł܂
 *
 * @param	itask	ITASKւ̃|C^
 * @return	none	
 */
//------------------------------------------------------------------
#define ITASKWorkClear(pitask)		\
{								\
	(pitask)->prev = 				\
	(pitask)->next = &ITASKFirst;	\
								\
	(pitask)->pri = 0;			\
	(pitask)->work = NULL;		\
	(pitask)->func = NULL;		\
}

void ITASK_WorkClear(ITASK_PTR itask)
{
	itask->prev = 
	itask->next = &ITASKFirst;

	itask->pri = 0;
	itask->work = NULL;
	itask->func = NULL;
}
//------------------------------------------------------------------
/**
 * @brief	ITASKX^bN
 *
 * gpITASKێX^bN
 */
//------------------------------------------------------------------
static void InitITASKStack(void)
{
	int i;

	for (i=0; i<ITASK_MAX; i++) {
		ITASKWorkClear(&(ITASKTable[i]));
		ITASKStack[i] = ITASKTable + i;
	}
	ITASKstackPtr = 0;
}

//------------------------------------------------------------------
/**
 * @brief	ITASKX^bN̎o
 *
 * @retval	NULLȊO	ITASKւ̃|C^
 * @retval	NULL		oɎsiX^bN󂾂ꍇj
 */
//------------------------------------------------------------------
static ITASK * PopITASK(void)
{
	ITASK_PTR itask;
	if (ITASKstackPtr == ITASK_MAX) {
		return NULL;
	}
	itask = ITASKStack[ITASKstackPtr];
	ITASKstackPtr ++;
	return itask;
}

//------------------------------------------------------------------
/**
	@brief	ITASKX^bNւ̃vbV

	@param	itask		vbVITASK̃|C^
	@retval	TRUE	
	@retval	FALSE	siX^bNς̏ꍇj
*/
//------------------------------------------------------------------
static int PushITASK(ITASK * itask)
{
	if (ITASKstackPtr == 0) {
		return FALSE;
	}
	ITASKWorkClear(itask);	//lNAĂX^bNɐς
	ITASKstackPtr --;
	ITASKStack[ITASKstackPtr] = itask;
	return TRUE;
}


//=============================================================================================
//
//	J֐
//
//=============================================================================================
//------------------------------------------------------------------
/**
 *	VXegpȌ
 */
//------------------------------------------------------------------
void ITASK_Init(void)
{
	//X^bN̏
	InitITASKStack();
	//擪ubN̏
	ITASKWorkClear(&ITASKFirst);
}

//------------------------------------------------------------------
//	ITASKC
//------------------------------------------------------------------
void ITASK_Main(void)
{
	ITASK_PTR now,temp;

	now = ITASKFirst.next;	//s̎n߂̏ꏊ
	while (now != (&ITASKFirst)) {
		temp = now->next;	//s֐ŃubN폜ꂽpɃAhXm
		if(now->func != NULL){
			now->func(now, now->work);
		}
		now = temp;
	}
}

/**
	@brief	ITASKǉ
	@param	func	ITASK_FUNC:֘Ats֐|C^
	@param	work	void*:֘At郏[NGAւvoid^|C^
	@param	pri		u32:^XNvCIeB

	@return	ITASK_PTR	ǉITASK|C^
*/
ITASK_PTR ITASK_Add(ITASK_FUNC func, void* work, u32 pri)
{
	ITASK_PTR get;
	ITASK_PTR find;

	get = PopITASK();	//󂢂ĂITASKE
	if(get == NULL){
		//o^悤Ƃ^XNȂ
		OS_Printf("ERR : ITASK wasn't get!");
		return NULL;
	}

	//p[^Zbg
	get->pri = pri;
	get->work = work;
	get->func = func;

	//sXgɐڑ(vCIeB̎ɂ́Aɓo^ق)
	for(find = ITASKFirst.next;find != &(ITASKFirst);find = find->next){
		if(find->pri > get->pri){	//find̑OgetȂ
			get->prev = find->prev;
			get->next = find;
			find->prev->next = get;
			find->prev = get;
			return get;
		}
	}
	//Ō܂ŌqƂ낪Ȃ΍ŌɌq
	get->prev = ITASKFirst.prev;	//܂ł̍Ō
	get->next = &(ITASKFirst);	//Ō
	ITASKFirst.prev->next = get;	//܂ōŌゾubN͎̎
	ITASKFirst.prev = get;		//Xg̍ŌXV
	return get;
}

//------------------------------------------------------------------
//	ITASK
//------------------------------------------------------------------
void ITASK_Delete(ITASK_PTR itask)
{
	//Xg폜
	itask->prev->next = itask->next;
	itask->next->prev = itask->prev;

	PushITASK(itask);
}

//==================================================================
//	ITASKANZX֐
//==================================================================

//------------------------------------------------------------------
//ITASK̓֐؂ւ
//------------------------------------------------------------------
void ITASK_ChangeFunc(ITASK_PTR itask, ITASK_FUNC func)
{
	itask->func = func;
}

//------------------------------------------------------------------
//ITASK̃[NAhX擾
//------------------------------------------------------------------
void * ITASK_GetWork(ITASK_PTR itask)
{
	return itask->work;
}

//------------------------------------------------------------------
//ITASKvCIeB̎擾
//------------------------------------------------------------------
u32 ITASK_GetPriority(ITASK_PTR itask)
{
	return itask->pri;
}

