/**
 *	@file	mdlanm.c
 *	@brief	ėp3DfAj[V\[XǗ⏕Cu
 *	@author	Miyuki Iwasawa
 *	@date	05.11.09
 */

#include "common.h"
#include "gflib/heapsys.h"
#include "gflib/mdlanm.h"

//vg^Cv
static void* SMAnm_LoadAnmFile(MDLANM_DATA* pData,const char* path,int heapID);

/**
 *	@brief	fAj}l[W
 *
 *	@param	num	s16:mۂAjf[^\̂̐
 *	@param	heapID	int:gpq[vID
 
 *	@return	MDLANM_MAN*:mۂMDLANM_MAN\̃f[^ւ̃|C^
 */
MDLANM_MAN* MAnm_Init(s16 num,int heapID) 
{
	MDLANM_MAN* wk = NULL;
	u16	i;

	wk = sys_AllocMemory(heapID,sizeof(MDLANM_MAN));
	if(wk == NULL){
		return NULL;
	}
	memset(wk,0,sizeof(MDLANM_MAN));

	wk->dat_num = num;
	wk->heapID = heapID;
	wk->pData = sys_AllocMemory(heapID,sizeof(MDLANM_DATA)*wk->dat_num);
	if(wk->pData == NULL){
		sys_FreeMemoryEz(wk);
		return NULL;
	}

	//f[^̈揉
	for(i = 0;i < wk->dat_num;i++){
		MAnm_ClearData(&wk->pData[i]);
	}
	
	//AP[^
	sys_InitAllocator(&wk->allocator,heapID,4);

	return wk;
}

/**
 *	@brief	fAj}l[WGA
 *	@param	wk	MDLANM_MAN*:eW[ŗpӂMDLANM_MAN\̃f[^ւ̃|C^
 */
void MAnm_End(MDLANM_MAN* wk) 
{
	s16	i;

	for(i = 0;i < wk->dat_num;i++){
		if(!wk->pData[i].valid){
			continue;
		}
		MAnm_ReleaseAnmData(&(wk->pData[i]),&(wk->allocator));
	}
	sys_FreeMemoryEz(wk->pData);
	sys_FreeMemoryEz(wk);
}

/**
 *	@brief	3DfAj@CRg[
 *
 *	@param	wk	MDLANM_MAN*@}l[Wւ̃|C^
 *
 *	CV[PXŌĂяoĂ	
 */
void MAnm_AnimeMain(MDLANM_MAN* wk)
{
	s16	i = 0;
	MDLANM_DATA* wp;
	if(wk == NULL){
		return;
	}

	for(i = 0;i < wk->dat_num;i++){
		wp = &wk->pData[i];
		if(wp->valid == 0 || wp->end_f == 1 || wp->stop_f == 1){
			continue;
		}
		if(wp->type == AMTYPE_SELF){
			continue;
		}
		wp->pAnmObj->frame = FX32_CONST(wp->frame++);

		if(wp->frame < wp->frm_max){
			continue;
		}
		if(wp->roop_f){
			wp->frame = 0;
		}else{
			wp->end_f = 1;
		}
	}
}

/**
 *	@brief	fAjz񂩂󂫃f[^NOԂ
 *	@param	wk	MDLANM_MAN*:eW[ŗpӂMDLANM_MAN\̃f[^ւ̃|C^
 *
 *	@retval	MDLANM_DATA_NULL:-1	󂫂Ȃ
 *	@retval	ȊO:z̃CfbNXNO
 *
 */
s16	MAnm_SearchNullDataNo(MDLANM_MAN* wk)
{
	s16	i;

	if(wk->pData == NULL){
		return MDLANM_DATA_NULL;
	}
	for(i = 0;i < wk->dat_num;i++){
		if(!wk->pData[i].valid){
			return i;
		}
	}
	return MDLANM_DATA_NULL;
}
/**
 *	@brief	IDz̃AhXԂ
 *	@param	wk	MDLANM_MAN*:eW[ŗpӂMDLANM_MAN\̃f[^ւ̃|C^
 *
 *	@retval	NULL	Ȃ
 *	@retval	MDLANM_DATA* \̃AhX
 *
 */
MDLANM_DATA* MAnm_SearchDataByID(MDLANM_MAN* wk,s16 no)
{
	s16	i;

	if(wk == NULL || wk->pData == NULL){
		return NULL;
	}
	if(no >= wk->dat_num){
		return NULL;
	}
	for(i = 0;i < wk->dat_num;i++){
		if(wk->pData[i].no == no){
			return &(wk->pData[i]);
		}
	}
	return NULL;
}

/**
 *	@brief	fAjf[^\̃NA
 *
 *	@param	pData	NAMDLANM_DATA^\̃f[^ւ̃|C^
 */
void MAnm_ClearData(MDLANM_DATA* pData)
{
	pData->no = -1;
	pData->type = 0;
	pData->frame = 0;
	pData->connect = 0;
	pData->valid = 0;
	pData->stop_f = 0;
	pData->end_f = 0;
	pData->pAnmObj = NULL;
	pData->pFile = NULL;
}

/**
 *	@brief	fAjǉ
 *	@param	wk	MDLANM_MAN*:eW[ŗpӂMDLANM_MAN\̃f[^ւ̃|C^
 *	@param	inName	Ajf[^t@C
 *	@param	inType	Aj[V^Cv
 *	@param	pModel	֘At郂f\[X
 */
MDLANM_DATA* MAnm_AddAnime(MDLANM_MAN* wk,const char* inName,const u8 inType,
		NNSG3dResMdl* pModel,NNSG3dResTex* pTex)
{
	s16 ret = 0;
	void*	anmRes = NULL;
	MDLANM_DATA* wp = NULL;
	
	ret = MAnm_SearchNullDataNo(wk);
	if(ret == MDLANM_DATA_NULL){
		return NULL;	//󂫂Ȃ̂ŒǉłȂ
	}
	
	wp = &wk->pData[ret];	//|C^擾
	MAnm_ClearData(wp);	//UNA

	//t@C[h
	anmRes = SMAnm_LoadAnmFile(wp,inName,wk->heapID);
	GF_ASSERT((anmRes != NULL) && "model anime file load failed");

	// Kvʂ̃AP[gBCjVCY͕ʓrKvɂȂB
    wp->pAnmObj = NNS_G3dAllocAnmObj(&(wk->allocator),	// gpAP[^w
                                     wp->pAnmRes,	// Aj[V\[Xw
                                     pModel);		// f\[Xw
	SDK_NULL_ASSERT(wp->pAnmObj);

	// AnmObj BWCgAj[VȊOl
	//
	NNS_G3dAnmObjInit(	wp->pAnmObj, // Aj[VIuWFNgւ̃|C^
						wp->pAnmRes, // Aj\[Xւ̃|C^
						pModel,  // NNSG3dResMdlւ̃|C^
                        pTex);  // NNSG3dResTexւ̃|C^(eNX`p^[AjȊOȂNULLł悢)

	wp->frm_max =  (NNS_G3dAnmObjGetNumFrame(wp->pAnmObj) >> FX32_SHIFT);
	wp->type = inType;
	if(wp->type == AMTYPE_AUTOLOOP){
		wp->roop_f = 1;
	}
	//Lɂ
	wp->valid = 1;
	wp->no = ret;
	return wp;
}

/**
 *	@brief	MDLANM_DATA\̂̃\[X
 *	@param	pData	MDLANM_DATA*@Ajf[^\̂ւ̃|C^
 *	@param	allocator	NNSFncAllocator*@}l[W̃AP[^
 *
 *	@retval	TRUE	
 *	@retval FLASE	s
 */
BOOL MAnm_ReleaseAnmData(MDLANM_DATA* pData,NNSFndAllocator* allocator)
{
	if(pData->connect  != 0){
		//̃AjRlNgĂIuWF̂ŉׂł͂Ȃ
		GF_ASSERT("3DfAj[VRlNgꂽ܂܂ł\n");
//		return FALSE;
	}
	
	//AjIuWF\[X
	NNS_G3dFreeAnmObj(allocator,pData->pAnmObj);
	//t@C\[X
	sys_FreeMemoryEz(pData->pFile);

	//f[^GANA
	MAnm_ClearData(pData);

	return TRUE;
}

/**
 *	@brief	fAj(IndexNo ver) 
 *	@param	wk	MDLANM_MAN*:eW[ŗpӂMDLANM_MAN\̃f[^ւ̃|C^
 *	@param	no	Ajf[^IndexNo
 *
 *	@retval	1	
 *	@retval 0	s(ׂ̂Ȃ)
 */
BOOL MAnm_ReleaseAnimeByID(MDLANM_MAN* wk,s16 no)
{
	MDLANM_DATA* wp;
	
	wp = MAnm_SearchDataByID(wk,no);
	if(wp == NULL){
		return FALSE;	//Ȃ
	}
	return MAnm_ReleaseAnmData(wp,&(wk->allocator));
}

/**
 *	@brief	Ajf[^RlNg(AhXVer)
 *
 *	@param	pData	MDLANM_DATA*
 *	@param	render	NNSG3dRenderObjւ̃|C^
 *
 *	@retval	TRUE	
 *	@retval FALSE	s
 */
BOOL MAnm_ConnectAnimeByAdrs(MDLANM_DATA* pData,NNSG3dRenderObj* render)
{
	if(pData == NULL || render == NULL){
		return FALSE;
	}
	if(pData->valid == 0){
		return FALSE;
	}
	NNS_G3dRenderObjAddAnmObj(render,pData->pAnmObj);
	pData->connect++;
	return TRUE;
}

/**
 *	@brief	Ajf[^fBXRlNg(AhXVer)
 *
 *	@param	pData	MDLANM_DATA*
 *	@param	render	NNSG3dRenderObjւ̃|C^
 *
 *	@retval	TRUE	
 *	@retval FALSE	s
 */
BOOL MAnm_DisconnectAnimeByAdrs(MDLANM_DATA* pData,NNSG3dRenderObj* render)
{
	if(pData == NULL || render == NULL){
		return FALSE;
	}
	if(pData->valid == 0){
		return FALSE;
	}
	NNS_G3dRenderObjRemoveAnmObj(render,pData->pAnmObj);
	pData->connect--;
	return TRUE;
}

/**
 *	@brief	Ajf[^ t[NoZbg(AhXVer)
 *
 *	@param	pData	MDLANM_DATA*
 *	@param	no		Ajt[No	
 *
 *	@retval	TRUE	
 *	@retval FALSE	s
 */
BOOL MAnm_SetAnimeFrameByAdrs(MDLANM_DATA* pData,u16 no)
{
	if(no > pData->frm_max){
		no = 0;
	}
	pData->frame = no;
	pData->pAnmObj->frame = FX32_CONST(pData->frame);

	return TRUE;
}

/**
 *	@brief	fAj@t@C[h
 *
 *	@param	MDLANM_DATA*	pData	Ajo^\̃AhX
 *	@param	const char*		path	t@CpX
 *	@param	NNSFndAllocator*	allocator	AP[^|C^
 *	@param	heapID	gpq[vID
 *
 *	@return 擾Aj\[Xւ̃|C^
 */
static void* SMAnm_LoadAnmFile(MDLANM_DATA* pData,const char* path,int heapID)
{
	void* pAnmRes = NULL;

	if(path == NULL){
		return NULL;
	}

	pData->pFile = sys_LoadFile(heapID,path);	
	if(pData->pFile == NULL){
		return NULL;
	}

	//\[X擾
	pData->pAnmRes = NNS_G3dGetAnmByIdx(pData->pFile,0);
	if(pData->pAnmRes == NULL){
		return NULL;
	}
	
	return pData->pAnmRes;
}
