//=============================================================================================
/**
 * @file	msg_print.c
 * @brief	rbg}bv\pVXe
 * @author	tetsu
 * @date	2003.03.17
 *
 * @data	2004.11.04 AGB -> NDS
 * @author	Hiroyuki Nakamura
 */
//=============================================================================================
#include <nitro.h>
#include "gflib/assert.h"
#include "system.h"
#include "bg_system.h"
#include "tcb.h"

#define	__MSG_PRINT_H_GLOBAL
#include "msg_print.h"

#include "system\fontproc.h"
#include "system/arc_util.h"
#include "system/font_arc.h"

#include "system/clact_util.h"
#include "system/render_oam.h"
#include "gflib/display.h"
#include "gflib/char_manager.h"
#include "gflib/pltt_manager.h"


typedef struct {
	CLACT_SET_PTR	cas;
	CLACT_U_EASYRENDER_DATA	renddata;	// ȈՃ_[f[^
	CLACT_HEADER_TBL_PTR	clh;		// wb_[
	CLACT_U_RES_MANAGER_PTR	resMan[4];	// \[X}l[W
	CLACT_U_RES_OBJ_TBL * resObjTbl[2];	// \[XIuWFe[u
	int resObjNum[4];					// ꂼ̃\[XIuWF
	CLACT_WORK_PTR	cwp;
}TRG_CURSOR;

static TRG_CURSOR * TrgCursorSet(void);
static void TrgCursorExit( TRG_CURSOR * wk );

static int loadOneData(
			CLACT_U_RES_MANAGER_PTR resMan, CLACT_U_RES_OBJ_TBL** resObjTbl, const char* path );
static void load2DResFile( TRG_CURSOR * wk );
static CLACT_WORK_PTR addCellAct( TRG_CURSOR * wk );


//==================================================================
//	ϐ  ֐錾
//==================================================================
static PRINT_RESULT	MSG_PrintDataSet( GF_BGL_INI * ini, MSG_DATA_HEADER * mdh_p );
static PRINT_RESULT GF_MSG_PrintDataSet( MSG_DATA_HEADER * mdh_p );
static void GF_MSG_PrintMain( TCB_PTR tcb, void *work );
static u8 SetNewPrintTask(TCB_FUNC func, void* work, u32 task_pri);
static void DeletePrintTask( u8 index );


static void DispIconInit( MSG_DATA_HEADER* mdh );
static void DispIconExit( MSG_DATA_HEADER* mdh );
static u8*  DispIconCreate(void);


static const MSG_FONT_HEADER*	font_header = NULL;

static u8				msg_main_pause = 0;
//static MSG_DATA_HEADER	mdh_buf = {0};



//---------------------------------------------------------------------------------------------
/**
 *	\VXe֐
 *
 * @param	tHg֐Qwb_
 *
 * @retval	Ȃ
 */
//---------------------------------------------------------------------------------------------
void MSG_PrintSysInit( const MSG_FONT_HEADER * header )
{
	font_header = header;
}







//==============================================================================================
//
// o̓^XNǗ邽߂̎dg
//
//==============================================================================================


enum {
	PRINTTASK_MAX = 8	// o̓^XNo^ł鑍
};
static TCB_PTR			PrintTaskTable[PRINTTASK_MAX] = {0};


//------------------------------------------------------------------
/**
 * V\^XNZbg
 *
 * @retval  u8		Zbg^XÑCfbNXl
 */
//------------------------------------------------------------------
static u8 SetNewPrintTask(TCB_FUNC func, void* work, u32 task_pri)
{
	int i;

	for( i=0; i<PRINTTASK_MAX; i++ ){
		if( PrintTaskTable[i] == NULL )
		{
			PrintTaskTable[i] = PrintTCB_Add(func, work, task_pri);
			if( PrintTaskTable[i] == NULL )
			{
				i = PRINTTASK_MAX;
			}
			break;
		}
	}
	return i;
}

//------------------------------------------------------------------
/**
 * \^XN~E폜
 *
 * @param   index		^XNCfbNXl
 *
 */
//------------------------------------------------------------------
static void DeletePrintTask( u8 index )
{
	GF_ASSERT(index < PRINTTASK_MAX);
	GF_ASSERT(PrintTaskTable[index]!=NULL);

	if( index < PRINTTASK_MAX && PrintTaskTable[index] != NULL )
	{
//		void *work = TCB_GetWork(PrintTaskTable[index]);
		MSG_DATA_HEADER * work = TCB_GetWork(PrintTaskTable[index]);
		if(work)
		{
			TrgCursorExit(work->trg_wk);
			DispIconExit( work );
			sys_FreeMemoryEz(work);
		}
		TCB_Delete(PrintTaskTable[index]);
		PrintTaskTable[index] = NULL;
	}
}

//------------------------------------------------------------------
/**
 * wCfbNX̕\^XNIĂ邩`FbN
 *
 * @param   index		CfbNXl
 *
 * @retval  BOOL		TRUEŏIĂ^FALSEœ쒆
 */
//------------------------------------------------------------------
static BOOL CheckPrintTaskWorking( u8 index )
{
	return PrintTaskTable[index] != NULL;
}

//-------------------------------------------------------------------------------------
/**
 *	\֐
 *
 * @param	Ȃ
 *
 * @retval	Ȃ
 */
//-------------------------------------------------------------------------------------
void MSG_PrintInit(void)
{
	int i;

	for(i=0; i<PRINTTASK_MAX; i++)
	{
		PrintTaskTable[i] = NULL;
	}
}
//---------------------------------------------------------------------------------------------
/*
 * \I`FbN֐
 *
 * @param	msg_index	bZ[WCfbNX
 *
 * @retval	0	I
 * @retval	1	
 */
//---------------------------------------------------------------------------------------------
u8 GF_MSG_PrintEndCheck( u8 msg_index )
{
	return CheckPrintTaskWorking(msg_index);
}

//------------------------------------------------------------------
/**
 * \̃^XN~
 *
 * @param   msg_index		bZ[WCfbNX
 *
 */
//------------------------------------------------------------------
void GF_STR_PrintForceStop( u8 msg_index )
{
	DeletePrintTask( msg_index );
}



#include "gflib/strbuf_family.h"


//------------------------------------------------------------------------------
/**
 * BitmapWindow ̓CGẌɕ`悷iȈՔŁj
 *
 * @param   win			[out] BitmapWindow
 * @param   fontID		tHghc
 * @param   msg			[in]  `敶񂪊i[Ă镶obt@
 * @param   xofs		`Jn_wWihbgPʁj
 * @param   yofs		`Jn_xWihbgPʁj
 * @param   wait		P`悲Ƃ̃EFCgt[ij
 * @param   callback	P`悲Ƃ̃R[obN֐AhXisvȂNULLj
 *
 * @retval  u8			镶`惋[`̃CfbNX
 *
 *  wait  MSG_NO_PUT w肵ꍇAL̈ɑ΂`݂̂s
 *            MSG_ALLPUT w肵ꍇAL̈`{BitmapWindowXN[쐬{VRam]s
 *            ȊO̒lw肵ꍇA
 *
 */
//------------------------------------------------------------------------------
u8 GF_STR_PrintSimple( GF_BGL_BMPWIN* win, u32 fontID, const STRBUF* msg, u32 xofs, u32 yofs, u32 wait, pStrPrintCallBack call_back )
{
	MSG_PRINT_HEADER	mph;

	mph.strbuf		= msg;
	mph.bmpwin		= win;
	mph.fnt_index	= fontID;		//gptHgINDEX
	mph.start_x		= xofs;			//EChE\JnXItZbg
	mph.start_y		= yofs;			//EChE\JnYItZbg
	mph.write_x		= xofs;			//EChE`XItZbg
	mph.write_y		= yofs;			//EChE`YItZbg
	mph.space_x		= font_header[fontID].space_x;	//ԊuX
	mph.space_y		= font_header[fontID].space_y;	//ԊuY
	mph.style		= font_header[fontID].style;		//tHgX^C
	mph.f_col		= font_header[fontID].f_col;		//Fio[
	mph.b_col		= font_header[fontID].b_col;		//wiFio[
	mph.s_col		= font_header[fontID].s_col;		//eF@io[
	mph.dot_tbl		= 0;			//gphbge[u
	mph.dot_wy		= 0;			//g厞YW̕`␳l

	return GF_STR_Print( &mph, wait, call_back );
}

//------------------------------------------------------------------------------
/**
 * BitmapWindow ̓CGẌɕ`悷iJ[wŁj
 *
 * @param   win			[out] BitmapWindow
 * @param   fontID		tHghc
 * @param   msg			[in]  `敶񂪊i[Ă镶obt@
 * @param   xofs		`Jn_wWihbgPʁj
 * @param   yofs		`Jn_xWihbgPʁj
 * @param   wait		P`悲Ƃ̃EFCgt[ij
 * @param   col			`ɎgFԍiGF_PRINTCOLOR_MAKE}Ngp邱Ɓj
 * @param   callback	P`悲Ƃ̃R[obN֐AhXisvȂNULLj
 *
 * @retval  u8			镶`惋[`̃CfbNX
 *
 *  wait  MSG_NO_PUT w肵ꍇAL̈ɑ΂`݂̂s
 *            MSG_ALLPUT w肵ꍇAL̈`{BitmapWindowXN[쐬{VRam]s
 *            ȊO̒lw肵ꍇA
 *
 */
//------------------------------------------------------------------------------
u8 GF_STR_PrintColor(
		GF_BGL_BMPWIN * win, u32 fontID, const STRBUF* msg, u32 xofs, u32 yofs, u32 wait,
		GF_PRINTCOLOR col, pStrPrintCallBack call_back )
{
	MSG_PRINT_HEADER	mph;

	mph.strbuf		= msg;
	mph.bmpwin		= win;
	mph.fnt_index	= fontID;		//gptHgINDEX
	mph.start_x		= xofs;			//EChE\JnXItZbg
	mph.start_y		= yofs;			//EChE\JnYItZbg
	mph.write_x		= xofs;			//EChE`XItZbg
	mph.write_y		= yofs;			//EChE`YItZbg
	mph.space_x		= font_header[fontID].space_x;	//ԊuX
	mph.space_y		= font_header[fontID].space_y;	//ԊuY
	mph.style		= font_header[fontID].style;		//tHgX^C
	mph.f_col		= GF_PRINTCOLOR_GET_LETTER(col);
	mph.s_col		= GF_PRINTCOLOR_GET_SHADOW(col);
	mph.b_col		= GF_PRINTCOLOR_GET_GROUND(col);
	mph.dot_tbl		= 0;			//gphbge[u
	mph.dot_wy		= 0;			//g厞YW̕`␳l

	return GF_STR_Print( &mph, wait, call_back );
}

//------------------------------------------------------------------------------
/**
 * BitmapWindow ̓CGẌɕ`悷iJ[ԁEsԎwŁj
 *
 * @param   win			[out] BitmapWindow
 * @param   fontID		tHghc
 * @param   msg			[in]  `敶񂪊i[Ă镶obt@
 * @param   xofs		`Jn_wWihbgPʁj
 * @param   yofs		`Jn_xWihbgPʁj
 * @param   wait		P`悲Ƃ̃EFCgt[ij
 * @param   col			`ɎgFԍiGF_PRINTCOLOR_MAKE}Ngp邱Ɓj
 * @param   xspc		Ƃ̊ԊuihbgPʁj
 * @param   yspc		sƂ̊ԊuihbgPʁj
 * @param   callback	P`悲Ƃ̃R[obN֐AhXisvȂNULLj
 *
 * @retval  u8			镶`惋[`̃CfbNX
 *
 *  wait  MSG_NO_PUT w肵ꍇAL̈ɑ΂`݂̂s
 *            MSG_ALLPUT w肵ꍇAL̈`{BitmapWindowXN[쐬{VRam]s
 *            ȊO̒lw肵ꍇA
 *
 */
//------------------------------------------------------------------------------
u8 GF_STR_PrintExpand(
		GF_BGL_BMPWIN * win, u32 fontID, const STRBUF* msg, u32 xofs, u32 yofs, u32 wait,
		GF_PRINTCOLOR col, u32 xspc, u32 yspc, pStrPrintCallBack  call_back )
{
	MSG_PRINT_HEADER	mph;

	mph.strbuf		= msg;
	mph.bmpwin		= win;
	mph.fnt_index	= fontID;	//gptHgINDEX
	mph.start_x		= xofs;		//EChE\JnXItZbg
	mph.start_y		= yofs;		//EChE\JnYItZbg
	mph.write_x		= xofs;		//EChE`XItZbg
	mph.write_y		= yofs;		//EChE`YItZbg
	mph.space_x		= xspc;		//ԊuX
	mph.space_y		= yspc;		//ԊuY
	mph.style		= font_header[fontID].style;		//tHgX^C
	mph.f_col		= GF_PRINTCOLOR_GET_LETTER(col);
	mph.s_col		= GF_PRINTCOLOR_GET_SHADOW(col);
	mph.b_col		= GF_PRINTCOLOR_GET_GROUND(col);
	mph.dot_tbl		= 0;			//gphbge[u
	mph.dot_wy		= 0;			//g厞YW̕`␳l

	return GF_STR_Print( &mph, wait, call_back );

}

//------------------------------------------------------------------
/**
 * BitmapWindow ̓CGẌɕ`悷
 *
 * @param   mph_p			
 * @param   wait			
 * @param   call_back		
 *
 * @retval  u8			镶`惋[`̃CfbNX
 */
//------------------------------------------------------------------
u8 GF_STR_Print( const MSG_PRINT_HEADER* mph_p, u32 wait, pStrPrintCallBack call_back )
{
	MSG_DATA_HEADER * mdh_p;
	int i;

	if(font_header == NULL){
		return 0xff;		//tHgf[^擾vOݒ肳ĂȂ
	}

	mdh_p = sys_AllocMemory( HEAPID_BASE_SYSTEM, sizeof(MSG_DATA_HEADER) );

	//\f[^ݒ
	mdh_p->sw				= 1;
	mdh_p->seq				= 0;
	mdh_p->wait				= wait;
	mdh_p->waitwork			= 0;
	mdh_p->scrwork			= 0;
	for( i=0; i<MDH_WORKSIZE; i++){
		mdh_p->userwork[i]	= 0;
	}
	mdh_p->mph				= *mph_p;
	mdh_p->mph.msg = STRBUF_GetStringCodePointer(mdh_p->mph.strbuf);
	mdh_p->call_back		= call_back;
	msg_main_pause = 0;

	DispIconInit( mdh_p );

	// PƂɃEFCg`i^XNj
	if((wait != MSG_NO_PUT)&&(wait != MSG_ALLPUT))
	{
		mdh_p->trg_wk	 = TrgCursorSet();
		mdh_p->wait--;			//waitl␳(0`)
		mdh_p->wait_flg = 1;
		mdh_p->msg_index = SetNewPrintTask(GF_MSG_PrintMain, mdh_p, 1);
		return mdh_p->msg_index;
	}
	// ꊇ`
	else
	{
		u32 error_check;

		mdh_p->wait= 0;
		mdh_p->wait_flg = 0;
		error_check = 0;	//Ƃ肠Cxߒx
		FntDataColorSet(mph_p->f_col, mph_p->b_col, mph_p->s_col);

		while(error_check < 1024){
			//`(ꊇ)
			if(GF_MSG_PrintDataSet( mdh_p ) == PRINT_RESULT_END){
				break;
			}
			error_check++;
		}

		if(wait != MSG_NO_PUT){
			//fBXvC](LN^ꊇ)
			GF_BGL_BmpWinOn( mdh_p->mph.bmpwin );
		}

		DispIconExit( mdh_p );
		sys_FreeMemoryEz( mdh_p );
		return PRINTTASK_MAX;
	}
}



//---------------------------------------------------------------------------------------------
/**
 * \֐(ʏ)
 *
 * @param	win			BMPEBhEf[^
 * @param	fnt_index	gpwb_INDEX(msg_print.h Q)
 * @param	x			EChE\JnXItZbg
 * @param	y			EChE\JnYItZbg
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back ݒɊւāÅ֐̈ 
 *   MSG_PRINT_HEADER \(msg_print.h Q)|C^
 * ƂȂ
 *
 * wait ݒ
 *   MSG_NOTRANS	fBXvC]Ȃ
 *@ MSG_ALL		fBXvCꊇ]
 *   1 `			PƂ̓]EFCgl
 * Ŏw(msg_print.h `)
 *
 * J[sԐݒheadero^̂̂gp
 */
//---------------------------------------------------------------------------------------------
u8 GF_MSG_Print(
		GF_BGL_BMPWIN * win, u8 fnt_index,
		const void * msg, u8 x, u8 y, u8 wait, void * call_back )
{
	MSG_PRINT_HEADER	mph;

	mph.msg			= msg;
	mph.bmpwin		= win;
	mph.fnt_index	= fnt_index;	//gptHgINDEX
	mph.start_x		= x;			//EChE\JnXItZbg
	mph.start_y		= y;			//EChE\JnYItZbg
	mph.write_x		= x;			//EChE`XItZbg
	mph.write_y		= y;			//EChE`YItZbg
	mph.space_x		= font_header[fnt_index].space_x;	//ԊuX
	mph.space_y		= font_header[fnt_index].space_y;	//ԊuY
	mph.style		= font_header[fnt_index].style;		//tHgX^C
	mph.f_col		= font_header[fnt_index].f_col;		//Fio[
	mph.b_col		= font_header[fnt_index].b_col;		//wiFio[
	mph.s_col		= font_header[fnt_index].s_col;		//eF@io[
	mph.dot_tbl		= 0;			//gphbge[u
	mph.dot_wy		= 0;			//g厞YW̕`␳l

	return GF_MSG_PrintExpand( &mph, wait, call_back );
}

//---------------------------------------------------------------------------------------------
/**
 * \֐(Fw)
 *
 * @param	win			BMPEBhEf[^
 * @param	fnt_index	gpwb_INDEX(msg_print.h Q)
 * @param	x			EChE\JnXItZbg
 * @param	y			EChE\JnYItZbg
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back ݒɊւāÅ֐̈ 
 *   MSG_PRINT_HEADER \(msg_print.h Q)|C^
 * ƂȂ
 *
 * wait ݒ
 *   MSG_NOTRANS	fBXvC]Ȃ
 *@ MSG_ALL		fBXvCꊇ]
 *   1 `			PƂ̓]EFCgl
 * Ŏw(msg_print.h `)
 *
 * J[sԐݒheadero^̂̂gp
 */
//---------------------------------------------------------------------------------------------
u8 GF_MSG_PrintColor(
		GF_BGL_BMPWIN * win, u8 fnt_index,
		const void * msg, u8 x, u8 y, u8 wait, GF_PRINTCOLOR col, void * call_back )
{
	MSG_PRINT_HEADER	mph;

	mph.msg			= msg;
	mph.bmpwin		= win;
//	mph.win_index	= win_index;	//\EChEINDEX
	mph.fnt_index	= fnt_index;	//gptHgINDEX
	mph.start_x		= x;			//EChE\JnXItZbg
	mph.start_y		= y;			//EChE\JnYItZbg
	mph.write_x		= x;			//EChE`XItZbg
	mph.write_y		= y;			//EChE`YItZbg
	mph.space_x		= font_header[fnt_index].space_x;	//ԊuX
	mph.space_y		= font_header[fnt_index].space_y;	//ԊuY
	mph.style		= font_header[fnt_index].style;		//tHgX^C
	mph.f_col		= GF_PRINTCOLOR_GET_LETTER(col);
	mph.s_col		= GF_PRINTCOLOR_GET_SHADOW(col);
	mph.b_col		= GF_PRINTCOLOR_GET_GROUND(col);
	mph.dot_tbl		= 0;			//gphbge[u
	mph.dot_wy		= 0;			//g厞YW̕`␳l

	return GF_MSG_PrintExpand( &mph, wait, call_back );
}

//---------------------------------------------------------------------------------------------
/**
 * \֐(g)
 *
 * @param	mph_p		bZ[W\p\̃|C^
 * @param	wait		`EFCg
 * @param	call_back	`悲Ƃ̃R[obN֐
 *
 * @return	bZ[WCfbNX
 *
 * call_back,wait ݒ́AʏłƓl̒`
 *
 * mph_p bZ[W\p\̂̏ڍׂ msg_print.h QƂ邱
 * ׂw肪oB
 */
//---------------------------------------------------------------------------------------------
u8 GF_MSG_PrintExpand( MSG_PRINT_HEADER * mph_p, u8 wait, void * call_back )
{
	int i;
	MSG_DATA_HEADER * mdh_p;
	u16	error_check;

	if(font_header == NULL){
		return 0xff;		//tHgf[^擾vOݒ肳ĂȂ
	}

	mdh_p = sys_AllocMemory( HEAPID_BASE_SYSTEM, sizeof(MSG_DATA_HEADER) );

	//\f[^ݒ
	mdh_p->sw				= 1;
	mdh_p->seq				= 0;
	mdh_p->wait				= wait;
	mdh_p->waitwork			= 0;
	mdh_p->scrwork			= 0;
	for( i=0; i<MDH_WORKSIZE; i++){
		mdh_p->userwork[i]	= 0;
	}
	mdh_p->mph				= *mph_p;
	mdh_p->call_back		= call_back;
	msg_main_pause = 0;

	DispIconInit( mdh_p );

	// PƂɃEFCg`i^XNj
	if((wait != MSG_NO_PUT)&&(wait != MSG_ALLPUT))
	{
		mdh_p->trg_wk	 = TrgCursorSet();
		mdh_p->wait--;		//waitl␳(0`)
		mdh_p->msg_index = SetNewPrintTask(GF_MSG_PrintMain, mdh_p, 1);
		return mdh_p->msg_index;
	}
	// ꊇ`
	else
	{
		mdh_p->wait= 0;
		error_check = 0;	//Ƃ肠Cxߒx

		FntDataColorSet(mph_p->f_col, mph_p->b_col, mph_p->s_col);

		while(error_check < 1024){
			//`(ꊇ)
			if(GF_MSG_PrintDataSet( mdh_p ) == PRINT_RESULT_END){
				break;
			}
			error_check++;
		}

		if(wait != MSG_NO_PUT){
			//fBXvC](LN^ꊇ)
			GF_BGL_BmpWinOn( mdh_p->mph.bmpwin );
		}

		DispIconExit( mdh_p );
		sys_FreeMemoryEz( mdh_p );
		return  PRINTTASK_MAX;
	}
}

//---------------------------------------------------------------------------------------------
/**
 *	\C֐
 *
 * @param	Ȃ
 *
 * @retval	Ȃ
 */
//---------------------------------------------------------------------------------------------
static void GF_MSG_PrintMain( TCB_PTR tcb, void *work )
{
	MSG_DATA_HEADER * mdh_p;
	PRINT_RESULT	result;

	if(msg_main_pause){	return; }		// Cf

	mdh_p = (MSG_DATA_HEADER *)work;

	FntDataColorSet(mdh_p->mph.f_col, mdh_p->mph.b_col, mdh_p->mph.s_col);

	//tHgf[^擾
	result = GF_MSG_PrintDataSet( mdh_p );

	//tHgf[^擾֐Ԃlɂ鏈
	switch( result ){
	case PRINT_RESULT_WRITE:
		GF_BGL_BmpWinOn( mdh_p->mph.bmpwin );

	case PRINT_RESULT_COMMAND:
		//`悲Ƃ̃R[obN֐Ăяo
		if(mdh_p->call_back != NULL){
			(mdh_p->call_back)( &(mdh_p->mph), result );
		}
		break;

	case PRINT_RESULT_END:
		DeletePrintTask( mdh_p->msg_index );
		break;
	}
}

//---------------------------------------------------------------------------------------------
/*
 *	f[^擾
 */
//---------------------------------------------------------------------------------------------
static PRINT_RESULT GF_MSG_PrintDataSet( MSG_DATA_HEADER * mdh_p )
{
	PRINT_RESULT  res;

	//etHgVXevǑĂяo(R[h)
	do{
		res = FontDataPrint( mdh_p->mph.fnt_index, mdh_p );

	}while(res == PRINT_RESULT_LOOP);

	return res;
}





















//---------------------------------------------------------------------------------------------
/*
 *	FntDataSet8x8_2bit ĂԑOɁAFԍZbgĂî߁j
 *
 * @param	col_f	Fԍ
 * @param	col_b	wiFԍ
 * @param	col_s	eFԍ
 */
//---------------------------------------------------------------------------------------------
#define DOTTBL_USE

#ifdef DOTTBL_USE
static u16 DotTbl[256];
#else
static u16 Col_b4, Col_b8, Col_b12;
static u16 Col_f4, Col_f8, Col_f12;
static u16 Col_s4, Col_s8, Col_s12;
#endif
static u16 Col_b, Col_f, Col_s;

void FntDataColorSet(u8 col_f, u8 col_b, u8 col_s)
{
#ifdef DOTTBL_USE
	int d1,d2,d3,d4,n;
	u32 col[4];

	col[0] = 0;
	col[1] = col_f;
	col[2] = col_s;
	col[3] = col_b;

	Col_b = col_b;
	Col_f = col_f;
	Col_s = col_s;

	n = 0;
	for(d1=0; d1<4; d1++){
		for(d2=0; d2<4; d2++){
			for(d3=0; d3<4; d3++){
				for(d4=0; d4<4; d4++){
					DotTbl[n++] =	(col[d4]<<12) | 
									(col[d3]<<8) |
									(col[d2]<<4) |
									(col[d1]);
				}
			}
		}
	}

#else
	Col_b = col_b;
	Col_f = col_f;
	Col_s = col_s;

	Col_b4 = col_b << 4;
	Col_b8 = col_b << 8;
	Col_b12 = col_b << 12;

	Col_f4 = col_f << 4;
	Col_f8 = col_f << 8;
	Col_f12 = col_f << 12;

	Col_s4 = col_s << 4;
	Col_s8 = col_s << 8;
	Col_s12 = col_s << 12;
#endif
}

void FntDataColorBackUp(u8* col_f, u8* col_b, u8* col_s)
{
	*col_b = Col_b; 
	*col_f = Col_f;
	*col_s = Col_s;
}

void FntDataColorRecover(u8* col_f, u8* col_b, u8* col_s)
{
	FntDataColorSet(*col_f,*col_b,*col_s);
}

//---------------------------------------------------------------------------------------------
/*
 *	f[^ݒ
 *
 * @param	radrs		ǂݍ݃f[^JnAhX
 * @param	wadrs		݃f[^obt@AhX
 *
 * @retval	x_size		wTCY(lߗp)
 */
//---------------------------------------------------------------------------------------------
#include "gflib\apptimer.h"
void FntDataSet8x8_2bit(u32 radrs,u32 wadrs)
{
	u32 dat;
	u16 *src;
	u16 *dst;

	src = (u16*)radrs;
	dst = (u16*)wadrs;


	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src++) << 24) >> 24;
	*dst++ = DotTbl[ dat ];

	dat = (u32)(*src) >> 8;
	*dst++ = DotTbl[ dat ];
	dat = (u32)((*src) << 24) >> 24;
	*dst = DotTbl[ dat ];

}
//---------------------------------------------------------------------------------------------
/*
 *	FntDataColorSet Őݒ肵Fԍ擾
 *
 * @param	mode	[hienum COLOR_GET_MODE : msg_print.hj
 *
 * @retval	Fԍ
 */
//---------------------------------------------------------------------------------------------
u8 FntDataColorGet(u8 mode)
{
	switch(mode){
	case  COLOR_F: return Col_f;
	case  COLOR_B: return Col_b;
	case  COLOR_S: return Col_s;
	}
	return 0;
}

//---------------------------------------------------------------------------------------------
/*
 *	XN[ɔfȂ`ŕ`悵A`悵L̈̃AhXԂ
 *
 * @param[in]	win		rbg}bvEBhEݒ\̂̃|C^
 * @param[in]	msg		`悷郁bZ[Wf[^̃AhX
 * @param[in]	font	`tHgio[
 * @param[in]	col		Fw
 * @param[in]	space_x	ԊuXw
 *
 * @retval	`悵L̈̐擪AhX
 */
//---------------------------------------------------------------------------------------------

void	*GF_MSG_PrintCGXOnly(GF_BGL_BMPWIN *win, const u16 *msg, u8 font,
	GF_PRINTCOLOR col, int space_x)
{
	MSG_PRINT_HEADER	mph;

	mph.msg			= msg;
	mph.bmpwin		= win;
	mph.fnt_index	= font;					//gptHgINDEX
	mph.start_x		= 0;					//EChE\JnwItZbg
	mph.start_y		= 0;					//EChE\JnxItZbg
	mph.write_x		= 0;					//EChE`wItZbg(lstart_xƓ)
	mph.write_y		= 0;					//EChE`xItZbg(lstart_yƓ)
	mph.space_x		= space_x;				//Ԋuw
	mph.space_y		= 0;					//Ԋux
	mph.style		= 0;					//tHgX^C
	mph.f_col		= GF_PRINTCOLOR_GET_LETTER(col);
	mph.s_col		= GF_PRINTCOLOR_GET_SHADOW(col);
	mph.b_col		= GF_PRINTCOLOR_GET_GROUND(col);
	mph.dot_tbl		= 0;					//gphbge[u
	mph.dot_wy		= 0;					//g厞YW̕`␳l

	GF_MSG_PrintExpand(&mph,MSG_NO_PUT,NULL);

	return win->chrbuf;
}










static void DispIconInit(MSG_DATA_HEADER* mdh)
{
	mdh->disp_icon = NULL;
}

static u8 * DispIconCreate(void)
{
	NNSG2dCharacterData * dat;
	void * arc;
	u8 * icon;

	icon = sys_AllocMemory( HEAPID_BASE_SYSTEM, 3*4 * 4 * 0x20 );
	arc  = ArcUtil_CharDataGet( ARC_FONT, NARC_font_dis_change_ncgr, 0, &dat, HEAPID_BASE_SYSTEM );
	MI_CpuCopy32( dat->pRawData, icon, 3*4 * 4 * 0x20 );
	sys_FreeMemoryEz( arc );

	return icon;
}

void GF_MSG_PrintDispIcon( MSG_DATA_HEADER * mdh, u16 px, u16 py, u16 pat )
{
	GF_BGL_BMPWIN * win = mdh->mph.bmpwin;
	u8 * iconcgx;

	if(mdh->disp_icon == NULL)
	{
		mdh->disp_icon = DispIconCreate();
	}

	iconcgx = mdh->disp_icon;
	iconcgx = &iconcgx[pat*12*0x20];

	GF_BGL_BmpWinPrint( win, iconcgx, 0, 0, 24, 32, px, py, 24, 32 );
}

static void DispIconExit( MSG_DATA_HEADER* mdh )
{
	if( mdh->disp_icon )
	{
		sys_FreeMemoryEz( mdh->disp_icon );
		mdh->disp_icon = NULL;
	}
}



//============================================================================================
static TRG_CURSOR * TrgCursorSet(void)
{
/*
	TRG_CURSOR * wk = sys_AllocMemory( HEAPID_BASE_SYSTEM, sizeof(TRG_CURSOR) );

	wk->cas = CLACT_U_SetEasyInit( 1, &wk->renddata, HEAPID_BASE_SYSTEM );
	load2DResFile(wk);
	wk->cwp = addCellAct( wk );

	GF_Disp_GX_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );
	GF_Disp_GXS_VisibleControl( GX_PLANEMASK_OBJ, VISIBLE_ON );

	return wk;
*/
	return NULL;
}

static void TrgCursorExit( TRG_CURSOR * wk )
{
/*
	u32	i;

	CLACT_Delete( wk->cwp );
	CLACT_DestSet( wk->cas );						// Zbg̔j
	CLACT_U_CLACT_HeaderTblDelete( wk->clh );		// ZAN^[wb_[j
	CLACT_U_CharManagerDeletes( wk->resObjTbl[0] );	// LN^f[^j
	CLACT_U_PlttManagerDeletes( wk->resObjTbl[1] );	// pbgf[^j

	// LN^ƃpbg̃\[XIuWFe[uj
	for( i=0; i<2; i++ ){
		CLACT_U_ResManagerResObjTblDelete( wk->resObjTbl[i] );
	}
	// \[X}l[Wj
	for( i=0; i<4; i++ ){
		CLACT_U_ResManagerDelete( wk->resMan[i] );
	}

	sys_FreeMemoryEz( wk );
*/
}


static void load2DResFile( TRG_CURSOR * wk )
{
	int i;
	void * buff;
	
	// \[X}l[W쐬
	for( i=0; i<4; i++ ){
		wk->resMan[i] = CLACT_U_ResManagerInit( 1, i, HEAPID_BASE_SYSTEM );
	}

	// \[Xǂݍ
	// LN^
	wk->resObjNum[0] = loadOneData(
							wk->resMan[0], &wk->resObjTbl[0], "data/win_cursor_res_chr.txt" );
	// pbg
	wk->resObjNum[1] = loadOneData(
							wk->resMan[1], &wk->resObjTbl[1], "data/win_cursor_res_pal.txt" );
	// Z
	wk->resObjNum[2] = loadOneData(
							wk->resMan[2], NULL, "data/win_cursor_res_cell.txt" );
	// ZAj
	wk->resObjNum[3] = loadOneData(
							wk->resMan[3], NULL, "data/win_cursor_res_canm.txt" );

	// ǂݍ݈ʒu
	CharLoadStartAll();
	PlttLoadStartAll();

	// LN^}l[Wɓo^
	// Vramɔzu܂B
	CLACT_U_CharManagerSets( wk->resObjTbl[0] );

	// pbg}l[Wɓo^
	// Vramɔzu܂B
	CLACT_U_PlttManagerSets( wk->resObjTbl[1] );

	// ZAN^[wb_ǂݍ
/*
	buff = sys_LoadFile( HEAPID_BASE_SYSTEM, "data/win_cursor_celact.txt" );
	wk->clh = CLACT_U_MakeHeaderBinary(
				buff, HEAPID_BASE_SYSTEM,
				wk->resMan[0], wk->resMan[1],
				wk->resMan[2], wk->resMan[3], NULL, NULL );
	sys_FreeMemoryEz( buff );
*/
	wk->clh = CLACT_U_LoadHeaderTbl(
				"data/win_cursor_celact.txt", HEAPID_BASE_SYSTEM,
				wk->resMan[0], wk->resMan[1],
				wk->resMan[2], wk->resMan[3], NULL, NULL );
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X^Cṽ\[Xwb_[f[^ǂݍ
 *
 *@param	resMan		\[X}l[W(쐬ς)
 *@param	resObjTbl	\[XIuWFe[u󂯎
 *@param	path		wb_pX
 *
 *@return	int		e[u
 *
 *
 */
//-----------------------------------------------------------------------------
static int loadOneData(
			CLACT_U_RES_MANAGER_PTR resMan, CLACT_U_RES_OBJ_TBL** resObjTbl, const char* path )
{
	CLACT_U_RES_HEADER_PTR res_head;		// \[Xwb_
	CLACT_U_RES_OBJ_TBL* work;
	int	tbl_num;							// wb_e[u
	void* buff;

	res_head = sys_AllocMemoryLo( HEAPID_BASE_SYSTEM, CLACT_U_ResManagerGetHeaderSize() );

	// wb_ǂݍ
	CLACT_U_ResManagerHeaderLoad( path, res_head, HEAPID_BASE_SYSTEM );
//	buff = sys_LoadFile( HEAPID_BASE_SYSTEM, path );
//	CLACT_U_ResManagerHeaderLoadBinary( buff, res_head, HEAPID_BASE_SYSTEM );
//	sys_FreeMemoryEz( buff );

	// wb_̃\[XIuWFe[u쐬
	if(resObjTbl != NULL){
		tbl_num		= CLACT_U_ResManagerHeaderSetDataNum(res_head);
		*resObjTbl	= CLACT_U_ResManagerResObjTblMake(tbl_num, HEAPID_BASE_SYSTEM);
		work = *resObjTbl;
	}else{
		work = NULL;
	}

	// \[Xǂݍ
	// LN^f[^ǂݍ
	tbl_num = CLACT_U_ResManagerResAddsHd(
				resMan,
				res_head,
				work,
				HEAPID_BASE_SYSTEM);

	// wb_j
	CLACT_U_ResManagerHeaderFree(res_head);

	// wb_Ŋmۂ[Nj
	sys_FreeMemoryEz(res_head);

	return tbl_num;
}


static CLACT_WORK_PTR addCellAct( TRG_CURSOR * wk )
{
	CLACT_ADD ca;
	CLACT_WORK_PTR obj;
	VecFx32 pos = {244*FX32_ONE, 180*FX32_ONE, FX32_ONE};
	VecFx32 sca = {FX32_ONE, FX32_ONE, FX32_ONE};
	
//	memset(&ca,0,sizeof(CLACT_ADD));
	ca.ClActSet		= wk->cas;
	ca.ClActHeader	= &wk->clh->tbl[0];
	ca.mat			= pos;
	ca.sca			= sca;
	ca.pri			= 0;
	ca.DrawArea		= NNS_G2D_VRAM_TYPE_2DMAIN;
	ca.heap			= HEAPID_BASE_SYSTEM;
	
	obj = CLACT_Add(&ca);
	GF_ASSERT(obj&&("ZAN^[o^s\n"));

	CLACT_AnmChg( obj, 0 );

	return obj;
}



void MsgPrintTrgCoursorInit( MSG_DATA_HEADER * mdh )
{
//	TRG_CURSOR * wk = mdh->trg_wk;
//	CLACT_AnmChg( wk->cwp, 0 );
}
void MsgPrintTrgCoursorDraw( MSG_DATA_HEADER * mdh )
{
//	TRG_CURSOR * wk = mdh->trg_wk;
//	CLACT_AnmFrameChg( wk->cwp, FX32_ONE );
//	CLACT_Draw( wk->cas );
}
