//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	@file		pltt_manager.c
 *	@brief		pbg}l[W[̎ԕ
 *	@author		tomoya takahashi
 *	@data		2004.11.22
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]*/

#include "system.h"
#define PLTT_MANAGER_H_GLOBAL
#include "pltt_manager.h"
#include "gflib_os_print.h"
#include "assert.h"
#include "vram_transfer_manager.h"


//-----------------------------------------------------------------------------
/**
 *					萔錾
 */
//-----------------------------------------------------------------------------

#define		PLTT_ONE_SIZE	(32)			// PUFpbgP̃TCY
#define		PLTT_AREA_NONE	(0xffffffff)	// pbgpGAȂ

#define		PLTT_EX_SIZE	(32*16*16)		// gpbgTCY
#define		PLTT_NORMAL_SIZE (32*16)		// WpbgTCY

#define		PLT_DATA_ID_NONE	(0xffffffff)

//----------------------------------------------------------------------------
/**
 *					\̐錾
 */
//----------------------------------------------------------------------------
//-------------------------------------
///	pbgf[^e[u
//
typedef struct
{
	NNSG2dPaletteData*	pPlttData;			// pbgf[^\({f[^̕ێ)
	NNS_G2D_VRAM_TYPE	type;				// VramType
											// mainɓo^FNNS_G2D_VRAM_TYPE_2DMAIN = 1
											// subɓo^ FNNS_G2D_VRAM_TYPE_2DSUB = 2
											// ɓo^FNNS_G2D_VRAM_TYPE_2DMAX = 3
	u32			load_size;					// ǂݍ݃TCY
	u32			act_num;					// o^@ID
	NNSG2dImagePaletteProxy	PaletteProxy;	// C[WvNV	
	u32			offset;						// ̃x[XAhX
	u32			sub_offset;					// ̃x[XAhX
	u8			flag;						// gpĂ邩̃tO
} PLTT_DATA_TBL;


//-------------------------------------
//
//	pbg}l[W[\	
//
//=====================================
typedef struct{
	PLTT_DATA_TBL*	plttDataTbl;					// pbgf[^e[u
	int				plttDataNum;					// pbgf[^
	int				plttDataNow;					// ̃pbgǂݍݐ
	u32				Offset;							// ǂݍݎ̃ItZbg
	u32				SubOffset;						// TuVram̃ItZbg
	u32				OffsetEx;						// gpbgItZbg
	u32				SubOffsetEx;					// TůgpbgItZbg
	u32				MainExPlttVramSize;				// C̊gpbgVramTCY
	u32				SubExPlttVramSize;				// TůgpbgVramTCY
	u16				main16VramArea;					// ĈPUFVramGA
	u16				sub16VramArea;					// TûPUFVramGA
}PLTT_MANAGER_DATA;


//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
static void cleanPlttData(PLTT_DATA_TBL* data);						// pbgf[^
static BOOL TransPlttData(const PLTT_MANAGER_HEADER* pPlttData, PLTT_DATA_TBL* tbl);							// pbgf[^]
static BOOL TransPlttDataCleanVram(const PLTT_MANAGER_HEADER* pPlttData, PLTT_DATA_TBL* tbl);							// pbgf[^]
static BOOL LoadPlttData(const PLTT_MANAGER_HEADER* pPlttData, PLTT_DATA_TBL* tbl);		// pbgf[^ǂݍ
static void setTransPltt( PLTT_DATA_TBL* pPlttData );
static void transVramPltt( void* p_data );		// pbg
static void setVramPlttSize( void );			// Vram̃TCYZbg
static void dellPlttData( PLTT_DATA_TBL* pPlttData );	// pbgf[^j
static PLTT_DATA_TBL* getPlttDataPtr( int id );	// ID̃pbgf[^擾
static PLTT_DATA_TBL* getPlttDataClean( void );	// 󂢂Ăpbgf[^擾

// ]GA̐ݒ
static void transAreaSet( u16* data, int num, int start );
static void transAreaClean( u16* data, int num, int start );
static int transAreaCheck( u16 data, int num );
static void transAreaInit( PLTT_MANAGER_DATA* data );
static void transAreaSetTbl( PLTT_DATA_TBL* data );
static void transAreaCleanTbl( PLTT_DATA_TBL* data );

// ItZbgړ̎̓]GA擾
static BOOL transAreaCheckOffset( PLTT_DATA_TBL* data, u32 m_offs, u32 s_offs, u32 m_limit, u32 s_limit );
static void transAreaSetOffset( PLTT_DATA_TBL* data, u32* m_offs, u32* s_offs );



// O[oϐ
static PLTT_MANAGER_DATA* PlttManagerData = NULL;
// XS֐͂̃f[^̃|C^ɂ悤ɕύXs
// ͂̃f[^ǂŕێ΂悢̂킩Ȃ߁A
// Ŏ



//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}l[W[
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void InitPlttManager(int PlttDataNum, int heap)
	{
	int i;
	
	// pbg}l[W[VXẽf[^쐬
	if(PlttManagerData == NULL){
		PlttManagerData = sys_AllocMemory(heap, sizeof(PLTT_MANAGER_DATA));
		MI_CpuClear32(PlttManagerData, sizeof(PLTT_MANAGER_DATA));
		
		PlttManagerData->plttDataNum = PlttDataNum;	// Ǘpbg

		// pbgǗ̊Ǘ̈쐬
		PlttManagerData->plttDataTbl = sys_AllocMemory(heap, sizeof(PLTT_DATA_TBL)*PlttDataNum);
		
		for(i=0;i<PlttDataNum;i++){	
			cleanPlttData(PlttManagerData->plttDataTbl + i);
		}
		
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbg}l[W[j
 *
 *@param	none
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void DeletePlttManager(void)
{
	if(PlttManagerData != NULL){
		DelPlttAll();		// Spbgf[^j
		sys_FreeMemoryEz(PlttManagerData->plttDataTbl);	// pbgǗ̈j
		sys_FreeMemoryEz(PlttManagerData);				// pbg}l[W[VXëj
		PlttManagerData = NULL;
	}
}

/*-----------------------------------------------------------------------------
 *
 *					
 *
 *	
 *		
 *
 *	߂l
 *		
 *					
 *
 ----------------------------------------------------------------------------*/
static void now_debug_draw( void )
{
#ifdef PLTT_MANAGER_OS_PRINTF_ON
	OS_Printf( "̃ItZbg\n" );
	OS_Printf( "C[%d] Tu[%d]\n", PlttManagerData->Offset, PlttManagerData->SubOffset );
	OS_Printf( "gC[%d] gTu[%d]\n", PlttManagerData->OffsetEx, PlttManagerData->SubOffsetEx );
#endif
}
//----------------------------------------------------------------------------
/**
 *
 *@brief	[hJn֐
 *
 *@param	start_offsetFǂݍ݊Jnoffset
 *
 *@return	none
 *	(Ǘ̃ItZbg)
 */
//-----------------------------------------------------------------------------
/// Cʁ@Wpbg
void PlttLoadStart( u32 start_offset )
{
	PlttManagerData->Offset = start_offset;
	setVramPlttSize();

	transAreaInit( PlttManagerData );
}
/// Tuʁ@Wpbg
void PlttLoadStartSub( u32 start_offset )
{
	PlttManagerData->SubOffset = start_offset;
	setVramPlttSize();
	transAreaInit( PlttManagerData );
}

/// Cʁ@gpbg
void PlttLoadStartEx( u32 start_offset )
{
	PlttManagerData->OffsetEx = start_offset;
	setVramPlttSize();
	transAreaInit( PlttManagerData );
}

/// Tuʁ@gpbg
void PlttLoadStartSubEx( u32 start_offset )
{
	PlttManagerData->SubOffsetEx = start_offset;
	setVramPlttSize();
	transAreaInit( PlttManagerData );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgǗĂItZbgl擾
 *
 *	@param	none 
 *
 *	@return	int		ItZbgl
 *
 *
 */
//-----------------------------------------------------------------------------
/// Cʁ@Wpbg
int PlttLoadOffsetGetMain( void )
{
	return PlttManagerData->Offset;
}
/// Tuʁ@Wpbg
int PlttLoadOffsetGetSub( void )
{
	return PlttManagerData->SubOffset;
}

/// Cʁ@gpbg
int PlttLoadOffsetGetMainEx( void )
{
	return PlttManagerData->OffsetEx;
}

/// Tuʁ@gpbg
int PlttLoadOffsetGetSubEx( void )
{
	return PlttManagerData->SubOffsetEx;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	[hJn֐
 *							SĂOŏ
 *
 *@param	none	
 *
 *@return	none
 *					(Ǘ̃ItZbg)
 *
 */
//-----------------------------------------------------------------------------
void PlttLoadStartAll( void )
{
	PlttManagerData->Offset			= 0;					// ǂݍݎ̃ItZbg
	PlttManagerData->SubOffset		= 0;					// TuVram̃ItZbg
	PlttManagerData->OffsetEx		= 0;					// gpbgItZbg
	PlttManagerData->SubOffsetEx	= 0;					// TůgpbgItZbg
	setVramPlttSize();										// VramBank̊蓖ĂVramgpłʂvZ
	transAreaInit( PlttManagerData );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^P̂Zbgă[h
 *
 *@param	pPlttDataFpbgf[^
 *
 *@retval	TRUE FZbgł
 *@retval	FALSEFZbgłȂ
 *
 */
//-----------------------------------------------------------------------------
BOOL PlttSet( const PLTT_MANAGER_HEADER* pPlttData )
{
	PLTT_DATA_TBL* tbl;

	// 󂢂Ăe[u擾
	tbl = getPlttDataClean();

	// e[u肽`FbN
	if( tbl == NULL ){
		GF_ASSERT(0&&("e[utœo^ł܂"))
		return FALSE;		// o^s\
	}
	
	// pbgf[^ǂݍ
	if(LoadPlttData(pPlttData, tbl) == FALSE){
		return FALSE;
	}
		

	// pbgf[^]
	if( TransPlttData(pPlttData, tbl) == FALSE ){
		//sƂ͔j
		//sƂVramɂ܂̃TCYȂ
		DelPltt( pPlttData->id );
		return FALSE;
	}

	// VramGAݒ
	transAreaSetTbl( tbl );

	return TRUE;
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^𕡐Zbg
 *
 *@param	pPlttDataFpbgf[^
 *@param	num			Zbg
 *
 *@return	o^
 *
 */
//-----------------------------------------------------------------------------
u16 PlttSets( const PLTT_MANAGER_HEADER* pPlttData, int num )
{
	int i;			// [vp
	
	//
	// PLTT_END܂œǂݍ
	//
	for(i=0;i<num;i++){
		// ǂݍ݁Zbg
		if( PlttSet( pPlttData + i ) == FALSE ){
			// s
			break;
		}
	}

	return i;
}


// rbg`FbN
// 󂢂Ăꏊɓ]܂B
// OFFSETw肵ē]Ƃ͏̓]֐gpĂ
//----------------------------------------------------------------------------
/**
 *@brief	pbgf[^P̂Zbgă[h
 *
 *@param	pPlttDataFpbgf[^
 *
 *@retval	TRUE FZbgł
 *			FALSEFZbgłȂ
 */
//-----------------------------------------------------------------------------
BOOL PlttSetCleanArea( const PLTT_MANAGER_HEADER* pPlttData )
{
	PLTT_DATA_TBL* tbl;

	// 󂢂Ăe[u擾
	tbl = getPlttDataClean();

	// e[u肽`FbN
	if( tbl == NULL ){
		GF_ASSERT(0&&("e[utœo^ł܂"))
		return FALSE;		// o^s\
	}
	
	// pbgf[^ǂݍ
	if(LoadPlttData(pPlttData, tbl) == FALSE){
		return FALSE;
	}
		

	// pbgf[^]
	if( TransPlttDataCleanVram(pPlttData, tbl) == FALSE ){
		//sƂ͔j
		//sƂVramɂ܂̃TCYȂ
		DelPltt( pPlttData->id );
		return FALSE;
	}

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^𕡐Zbg
 *
 *@param	pPlttData	pbgf[^
 *@param	num			Zbg鐔
 *
 *@return	o^
 */
//-----------------------------------------------------------------------------
u16 PlttSetsCleanArea( const PLTT_MANAGER_HEADER* pPlttData, int num )
{
	int i;			// [vp
	
	//
	// PLTT_END܂œǂݍ
	//
	for(i=0;i<num;i++){
		// ǂݍ݁Zbg
		if( PlttSetCleanArea( pPlttData + i ) == FALSE ){
			// s
			break;
		}
	}

	return i;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgf[^]
 *
 *	@param	id			]̃pbgID
 *	@param	pPlttData	pbgf[^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void PlttDataChg( int id, NNSG2dPaletteData* pPlttData )
{
	PLTT_DATA_TBL* tbl;
	
	GF_ASSERT( pPlttData );

	// id̃f[^擾
	tbl = getPlttDataPtr(id);
	GF_ASSERT( tbl );
	
	
	tbl->pPlttData = pPlttData;
	
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		// Vram
		// ]}l[Wœ]
		AddVramTransferManager(
			NNS_GFD_DST_2D_OBJ_PLTT_MAIN,
			tbl->offset,
			pPlttData->pRawData,
			tbl->load_size * PLTT_ONE_SIZE
			);
	}
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		// Vram
		// ]}l[Wœ]
		AddVramTransferManager(
			NNS_GFD_DST_2D_OBJ_PLTT_SUB,
			tbl->sub_offset,
			pPlttData->pRawData,
			tbl->load_size * PLTT_ONE_SIZE
			);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	id̃pbgf[^o^Ă邩`FbN
 *
 *@param	id		`FbNid
 *
 *@retval	TRUE	o^Ă
 *@retval	FALSE	o^ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL CheckPlttID(int id)
{
	PLTT_DATA_TBL* tbl;

	tbl = getPlttDataPtr(id);
	if(tbl){		// o^ς
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Ƃo^ł̂Ԃ
 *
 *@param	none
 *
 *@return	int		co^\
 *
 *
 */
//-----------------------------------------------------------------------------
int CheckPlttRest(void)
{
	return PlttManagerData->plttDataNum - PlttManagerData->plttDataNow;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^j
 *
 *@param	p_strFpbgt@C
 *	
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DelPltt( int id )
{
	PLTT_DATA_TBL* tbl;			// vf擾p

	// vf擾
	tbl = getPlttDataPtr(id);
	
	// ő吔`FbN
	GF_ASSERT(tbl);
	
	// LN^f[^j
	// ғ`FbN
	if( tbl->flag == 1 ){
		// VramGAj
		transAreaCleanTbl( tbl );
		// f[^j
		dellPlttData( tbl );	
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Spbgf[^j
 *
 *@param	none
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
void DelPlttAll( void )
{
	int i;

	//
	// Spbgf[^j
	//
	// pbgID̃e[uT
	for( i = 0; i < PlttManagerData->plttDataNum; i++ ){
		// ғ`FbN
		if( PlttManagerData->plttDataTbl[ i ].flag == 1 ){
			// VramGAj
			transAreaCleanTbl( &PlttManagerData->plttDataTbl[ i ] );
			// f[^j
			dellPlttData( &PlttManagerData->plttDataTbl[ i ] );

		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	ID̃pbgvNV擾
 *
 *@param	id		pbgID
 *
 *@return	ID̃vNV
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImagePaletteProxy* GetPlttIDProxy( int id )
{
	PLTT_DATA_TBL* tbl;			// vff[^

	// vf擾
	tbl = getPlttDataPtr(id);
	if( tbl == NULL ){
		GF_ASSERT(tbl);
		return NULL;
	}

	// ғȂԂ
	if(tbl->flag == 1){
		return &tbl->PaletteProxy;
	}
	
	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgvNV̎擾
 *			pbg̃[higpbgjɃC[WvNVœK
 *					pbgvNV擾֐
 *
 *@param	id		pbgID
 *@param	pImageFC[WvNV
 *
 *@return	pbgvNV
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImagePaletteProxy* GetPlttIDProxyJoin( int id, NNSG2dImageProxy* pImage )
{
	PLTT_DATA_TBL* tbl;			// vff[^

	// vf擾
	tbl = getPlttDataPtr(id);
	if( tbl == NULL ){
		GF_ASSERT(tbl);
		return NULL;
	}
	// ғ`FbN
	if( tbl->flag != 1 ){
		return NULL;
	}

	// gpbg`FbN
	if( tbl->pPlttData->bExtendedPlt ){
		// C[WvNVɊgpbg悤悤ɐݒ
		NNS_G2dSetImageExtPaletteFlag( pImage, TRUE );
	}
	
	return &tbl->PaletteProxy;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgvNV̂pbgio[擾
 *
 *@param	pPlttFpbgio[擾pbgvNV
 *@param	vramTypeFCʂTuʂ
 *
 *@return	pbgio[
 *
 */
//-----------------------------------------------------------------------------
u32 GetPlttProxyOffset( const NNSG2dImagePaletteProxy* pPltt, u32 vramType )
{
	u32 size;			// PpbgTCY
	u32 pltt_offset;	// pbgio[vZp
	
	// gpbg`FbN
	if( pPltt->bExtendedPlt ){
		size = PLTT_ONE_SIZE * 16;
	}else{
		// W256łȂ`FbN
		if( pPltt->fmt == GX_TEXFMT_PLTT256 ){
			// 256̎̓TCYOɂČvZȂ
			size = 0;
		}else{
			size = PLTT_ONE_SIZE;
		}
	}

	// WQTUFȊO`FbN
	if( size != 0 ){
		// 炷l擾
		pltt_offset = NNS_G2dGetImagePaletteLocation( pPltt, vramType );
		pltt_offset /= size;			// 炷lɂ(pbg炷)
	}else{
		pltt_offset = 0;
	}

	return pltt_offset;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgio[̃vNV擾
 *
 *@param	pltt_offsetF̃pbgio[̃vNVԂ
 *@param	typeFPUFAgpbg̃tO()
 *@param	vramTypeFpbgio[킹Vram̃^Cv		PFC@QFTu
 *
 *@return	vNV
 *@retval	ȂƂNULL
 *
 */
//-----------------------------------------------------------------------------
NNSG2dImagePaletteProxy* GetPlttNumProxy( u32 pltt_offset, u32 type, u32 vramType )
{
	int i;			// [vp
	u32	now_idx;	// ̃pbgio[
	u32 end_idx;	// Ipbgio[
	
	
	//
	// o^ĂApbgpltt_offset̃pbg
	// o^ĂpbgvNVԂ
	//
	for( i = 0; i < PlttManagerData->plttDataNum; i++ ){
		// ғ`FbN
		if( PlttManagerData->plttDataTbl[ i ].flag == 1 ){
			// Typeꏏ`FbN
			if( ((type == 1) && (PlttManagerData->plttDataTbl[ i ].pPlttData->bExtendedPlt > 0 )) ||
				((type == 0) && (PlttManagerData->plttDataTbl[ i ].pPlttData->bExtendedPlt == 0 )) ){
				
				// VramItZbg擾
				now_idx = NNS_G2dGetImagePaletteLocation( &PlttManagerData->plttDataTbl[ i ].PaletteProxy, vramType );

				// TCYIItZbgvZ
				end_idx = now_idx + (PlttManagerData->plttDataTbl[ i ].load_size * PLTT_ONE_SIZE);
		
				// eNX`TypẽTCYŊ
				if(type == 1){
					now_idx /= PLTT_ONE_SIZE * 16;		// g
					end_idx /= PLTT_ONE_SIZE * 16;		// g
				}else{	
					now_idx /= PLTT_ONE_SIZE;			// W PUF
					end_idx /= PLTT_ONE_SIZE;			// W PUF
				}

				// now_idxend_idx̒pltt_offset邩`FbN
				if( (now_idx <= pltt_offset) && (end_idx >= pltt_offset) ){
					break;		// ̃pbgvNṼf[^ɂ
				}

				// now_idxpltt_offsetȂ
				// ̈ʒuɑΉpbgf[^͂ȂƂɂȂ
				if( now_idx > pltt_offset ){
					return NULL;
				}
			}
		}
	}

	// Ō܂ōsNULLԂ
	if(i == PlttManagerData->plttDataNum){
		return NULL;
	}

	return &PlttManagerData->plttDataTbl[ i ].PaletteProxy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	삳ĂpbgvNV̒Ɉ̃vNV邩
 *
 *@param	pPltt	vNV
 *
 *@return	BOOL	TRUE		FALSE	Ȃ
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL SearchPlttProxy( const  NNSG2dImagePaletteProxy* pPltt)
{
	int i;
	BOOL ret = FALSE;

	for(i=0;i<PlttManagerData->plttDataNum;i++){
		// ғ`FbN
		if( PlttManagerData->plttDataTbl[ i ].flag == 1 ){
			// ID`FbN
			if( &PlttManagerData->plttDataTbl[ i ].PaletteProxy == pPltt ){
				ret = TRUE;
				break;
			}	
		}
	}

	return ret;
}

//
// vCx[g֐
//
//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^j
 *
 *@param	pPlttDataFjpbgf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void dellPlttData( PLTT_DATA_TBL* pPlttData )
{
	// j
	cleanPlttData(pPlttData);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^̓ǂݍ
 *
 *@param	pPlttData	pbgENTRYf[^
 *@param	tbl			ǂݍރe[u|C^
 *
 *@return	BOOL	ǂݍݐ:TRUE	ǂݍݎs:FALSE
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL LoadPlttData(const PLTT_MANAGER_HEADER* pPlttData, PLTT_DATA_TBL* tbl)
{
	// pbgf[^ݒ
	tbl->pPlttData = pPlttData->res_file;
	
	// IDdȂ`FbN
	if(CheckPlttID(pPlttData->id) == TRUE){
		GF_ASSERT(0);
		return FALSE;
	}
	
	// IDt@C擾
	tbl->act_num = pPlttData->id;
	
	// e[uZbg
	tbl->type	= pPlttData->type;			// Vramtype
	tbl->flag			= 1;						// gp
	tbl->load_size = pPlttData->pltt_num;	// ǂݍރpbg	

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^
 *
 *@param	data		pbgf[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanPlttData(PLTT_DATA_TBL* data)
{
	data->pPlttData = NULL;
	data->type		= 0;
	data->load_size	= 0;
	data->act_num	= PLT_DATA_ID_NONE;
	NNS_G2dInitImagePaletteProxy( &data->PaletteProxy );
	data->offset	= 0;
	data->sub_offset= 0;
	data->flag		= 0;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^̓]
 *
 *@param	tbl	]pbgf[^
 *
 *@return	BOOL	]:TRUE	]s:FALSE
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL TransPlttData(const PLTT_MANAGER_HEADER* pPlttData, PLTT_DATA_TBL* tbl)
{
	u32* p_offset;
	u32* p_offset_sub;
	BOOL dell_flag = TRUE;		// ̈I[o[̂ƂFALSEɂȂtO
	u32 vram_limit;				// CVram̈limit
	u32 vram_limit_sub;			// TuVram̈limit
	
	// gpbg`FbN
	if( tbl->pPlttData->bExtendedPlt ){
		// ItZbgl̃|C^Zbg
		p_offset		= &PlttManagerData->OffsetEx;
		p_offset_sub	= &PlttManagerData->SubOffsetEx; 
		vram_limit = PlttManagerData->MainExPlttVramSize;			// Vram̗̈̃TCY
		vram_limit_sub = PlttManagerData->SubExPlttVramSize;			// Vram̗̈̃TCY
	}else{	
		// ItZbgl̃|C^Zbg
		p_offset		= &PlttManagerData->Offset;
		p_offset_sub	= &PlttManagerData->SubOffset;
		vram_limit = PLTT_NORMAL_SIZE;		// Vram̗̈̃TCY
		vram_limit_sub = PLTT_NORMAL_SIZE;	// Vram̗̈̃TCY
	}
	
	// ]ݒ
	transAreaCheckOffset( tbl, *p_offset, *p_offset_sub, vram_limit, vram_limit_sub );

	// offsetʒuɃ[h
	setTransPltt( tbl );

	// ItZbg炷
	transAreaSetOffset( tbl, p_offset, p_offset_sub );

	return dell_flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	󂢂Ă̈Tăpbgf[^]
 *
 *	@param	pPlttData		pbgENTRYf[^
 *	@param	tbl				e[u
 *
 *	@return
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL TransPlttDataCleanVram(const PLTT_MANAGER_HEADER* pPlttData, PLTT_DATA_TBL* tbl)
{
	int offset_m, offset_s;		// CƃTũItZbg
	
	// gpbg`FbN
	if( tbl->pPlttData->bExtendedPlt ){
		// gpbg͖ł
		GF_ASSERT(0);
	}

	// GAT
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		offset_m = transAreaCheck( PlttManagerData->main16VramArea, tbl->load_size );

		if(offset_m == PLTT_AREA_NONE){
			return FALSE;
		}
	}
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		offset_s = transAreaCheck( PlttManagerData->sub16VramArea, tbl->load_size );
		
		if(offset_s == PLTT_AREA_NONE){
			return FALSE;
		}
	}

	// ItZbgݒ
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		tbl->offset = offset_m;
	}
	if( tbl->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		tbl->sub_offset = offset_s;
	}

	// pbgTCYݒ
	tbl->pPlttData->szByte = tbl->load_size * PLTT_ONE_SIZE;
	
	// ]
	transVramPltt( tbl );

	// VramGAݒ
	transAreaSetTbl( tbl );
	

	return TRUE;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pX̃pbgf[^̗vf擾
 *
 *@param	id		pbgID
 *
 *@return	PLTT_DATA_TBL*	pbgf[^e[u|C^
 *
 */
//-----------------------------------------------------------------------------
static PLTT_DATA_TBL*	getPlttDataPtr( int id )
{
	int i;			// [vp

	
	
	// ID̃f[^ăvNVԂ
	for( i = 0; i < PlttManagerData->plttDataNum; i++ ){
		// ID`FbN
		if( PlttManagerData->plttDataTbl[ i ].act_num == id ){
			return PlttManagerData->plttDataTbl + i;
		}	
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	󂢂Ăe[u擾
 *
 *@param	none
 *
 *@return	PLTT_DATA_TBL* 󂢂Ăe[u
 *
 *
 */
//-----------------------------------------------------------------------------
static PLTT_DATA_TBL* getPlttDataClean( void )
{
	int i;
	
	// pbgf[^e[uɃZbg
	for( i = 0; i < PlttManagerData->plttDataNum; i++ ){
		// ĂƂT[`
		if( PlttManagerData->plttDataTbl[ i ].flag == 0 ){
			return PlttManagerData->plttDataTbl + i;
		}
	}
	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgVramTCYZbg
 *
 *@param	none
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void setVramPlttSize( void )
{
	GXVRamOBJExtPltt	vram_bank;		// CVramoN擾p
	GXVRamSubOBJExtPltt	sub_vram_bank;	// TuVramoN擾p
	
	
	//
	// Vram̃pbgTCYZbg
	//
	// C
	vram_bank = GX_GetBankForOBJExtPltt();
	switch( vram_bank ){
	case GX_VRAM_OBJEXTPLTT_0_F:	// Cʊgpbggp
	case GX_VRAM_OBJEXTPLTT_0_G:	// Cʊgpbggp
		PlttManagerData->MainExPlttVramSize = PLTT_EX_SIZE;
		break;

	default:
		PlttManagerData->MainExPlttVramSize = 0;	
		break;
	}

	// Tu
	sub_vram_bank = GX_GetBankForSubOBJExtPltt();
	switch( sub_vram_bank ){
	case GX_VRAM_SUB_OBJEXTPLTT_0_I:	// Cʊgpbggp
		PlttManagerData->SubExPlttVramSize = PLTT_EX_SIZE;
		break;

	default:
		PlttManagerData->SubExPlttVramSize = 0;	
		break;
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^]VuN^XNɃZbg
 *
 *@param	pPlttDataFpbgf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void setTransPltt( PLTT_DATA_TBL* pPlttData )
{

	// \[X̃TCYύX
	pPlttData->pPlttData->szByte = pPlttData->load_size * PLTT_ONE_SIZE;
	
	transVramPltt( pPlttData);

}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Vblankōspbgf[^Vramւ̓]
 *
 *@param	p_dataF]pbgf[^
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void transVramPltt( void* p_data )
{
	PLTT_DATA_TBL* p_pltt_data = (PLTT_DATA_TBL*)p_data;		// LXgăf[^擾

	NNS_G2dInitImagePaletteProxy(&p_pltt_data->PaletteProxy);
	
	// Vram֓ǂݍ
	if(p_pltt_data->type & NNS_G2D_VRAM_TYPE_2DMAIN){
		// ɓo^
		NNS_G2dLoadPalette(
				p_pltt_data->pPlttData,// LN^f[^
				p_pltt_data->offset,			// LN^x[XAhX
				NNS_G2D_VRAM_TYPE_2DMAIN,		// VramType
				&p_pltt_data->PaletteProxy );	// C[WvNV
	}

	if(p_pltt_data->type & NNS_G2D_VRAM_TYPE_2DSUB){
		NNS_G2dLoadPalette(
				p_pltt_data->pPlttData,// LN^f[^
				p_pltt_data->sub_offset,		// LN^x[XAhX
				NNS_G2D_VRAM_TYPE_2DSUB,		// VramType
				&p_pltt_data->PaletteProxy );	// C[WvNV
	}
}



// ]GA̐ݒ
static void transAreaSet( u16* data, int num, int start )
{
	int i;		// [vp
	
	for(i=0;i<num;i++){

		*data |= 1 << (start + i);
	}
}

static void transAreaClean( u16* data, int num, int start )
{
	int i;		// [vp
	
	for(i=0;i<num;i++){

		*data &= ~( 1 << (start + i) );
	}
}

static int transAreaCheck( u16 data, int num )
{
	int i, j;		// [vp
	
	for(i = 0; i < 16; i++ ){
		
		j = 0;
		// rbgĂȂā@JE^num菬Ƃ
		while( ( (data & (1 << ( i + j))) == 0 ) && (j < num) ){

			// TCYI[o[I
			if( (i + j) >= 16 ){
				break;
			}

			j++;
		}
	
		// TCŸ̗悪`FbN
		if(j >= num){
			break;
		}

		i += j;		// ߂Ԃ΂
	}

	// Ō܂forĂȂ̂errԂ
	if( i >= 16 )
	{
		return PLTT_AREA_NONE;
	}

	return i * PLTT_ONE_SIZE;
}

static void transAreaInit( PLTT_MANAGER_DATA* data )
{
	data->main16VramArea = 0;
	data->sub16VramArea = 0;
}

static void transAreaSetTbl( PLTT_DATA_TBL* data )
{
	if( data->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		transAreaSet( &PlttManagerData->main16VramArea, data->load_size, data->offset / PLTT_ONE_SIZE );
	}
	if( data->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		transAreaSet( &PlttManagerData->sub16VramArea, data->load_size, data->sub_offset / PLTT_ONE_SIZE );
	}
}

static void transAreaCleanTbl( PLTT_DATA_TBL* data )
{
	if( data->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		transAreaClean( &PlttManagerData->main16VramArea, data->load_size, data->offset / PLTT_ONE_SIZE );
	}
	if( data->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		transAreaClean( &PlttManagerData->sub16VramArea, data->load_size, data->sub_offset / PLTT_ONE_SIZE );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ItZbg[h̓]GA
 *
 *	@param	data	pbgf[^
 *	@param	m_offs	̃ItZbgʒu
 *	@param	s_offs	̃ItZbgʒu
 *
 *	@retval	TRUE		擾
 *	@retval	FALSE		擾s
 *
 *
 */
//-----------------------------------------------------------------------------
static BOOL transAreaCheckOffset( PLTT_DATA_TBL* data, u32 m_offs, u32 s_offs, u32 m_limit, u32 s_limit )
{
	BOOL dell_flag = TRUE;
	
	// Cʂɓǂݍނ`FbN
	if( data->type & NNS_G2D_VRAM_TYPE_2DMAIN ){

		// TCYI[o[`FbN
		if( (m_offs + (data->load_size * PLTT_ONE_SIZE) > m_limit) ){

			// o^Ȃ
			GF_ASSERT(0&&("TCYI[o["));
			now_debug_draw();		// ̏󋵂`
			dell_flag = FALSE;
		}else{
			data->offset = m_offs;	
		}
		
	}

	// Tuʂɓǂݍނ`FbN
	if( data->type & NNS_G2D_VRAM_TYPE_2DSUB ){

		// TCYI[o[`FbN
		if( (s_offs + (data->load_size * PLTT_ONE_SIZE) > s_limit) ){

			// o^Ȃ
			GF_ASSERT(0&&("TCYI[o["));
			now_debug_draw();		// ̏󋵂`
			dell_flag = FALSE;
		}else{
			data->sub_offset = s_offs;
		}
	}

	return dell_flag;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	ItZbgړ
 *
 *	@param	data		pbgf[^
 *	@param	m_offs		CItZbg̃|C^
 *	@param	s_offs		TuItZbg̃|C^
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void transAreaSetOffset( PLTT_DATA_TBL* data, u32* m_offs, u32* s_offs )
{
	// 炷
	if( data->type & NNS_G2D_VRAM_TYPE_2DMAIN ){
		*m_offs		+= data->load_size * PLTT_ONE_SIZE;
	}

	if( data->type & NNS_G2D_VRAM_TYPE_2DSUB ){
		*s_offs		+= data->load_size * PLTT_ONE_SIZE;
	}
}
