//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		renderer_pack.c
 *@brief	_[pbN֐
 *@author	tomoya takahashi
 *@data		2005.09.01
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#define __RENDERER_PACK_H_GLOBAL
#include "renderer_pack.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------


//----------------------------------------------------------------------------
/**
 *
 *@brief	_[gps܂B
 *
 *@param	p_renderer	_[̎̂̃|C^
 *@param	Zoffs		ZItZbg̑
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_InitRenderer(NNSG2dRendererInstance* p_renderer, fx32 Zoffs)
{
	NNS_G2dInitRenderer( p_renderer );
	// Z ItZbgw
	NNS_G2dSetRendererSpriteZoffset( p_renderer, Zoffs );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[X
 *
 *@param	pSurface		T[tF[X̎̂̃|C^
 *@param	pRect			T[tF[X̋`
 *@param	OamSetFunc		OAMݒR[obN֐
 *@param	AffineSetFunc	AtBsݒR[obN֐
 *@param	cullFunc		JOR[obN֐
 *@param	type			T[tF[X^Cv
 *@param	pSetRenderer	̃T[tF[Xݒ肷郌_[iݒ肵ȂƂ́@NULLj
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_InitSurface(NNSG2dRenderSurface* pSurface,
		NNSG2dViewRect* pRect,
		NNSG2dOamRegisterFunction OamSetFunc,
		NNSG2dAffineRegisterFunction AffineSetFunc,
		NNSG2dRndCellCullingFunction cullFunc,
		NNSG2dSurfaceType type,
		NNSG2dRendererInstance* pSetRenderer )
{
	NNS_G2dInitRenderSurface(pSurface);
	
	// `ݒ
	pSurface->viewRect = *pRect;

	// R[obN֐
	pSurface->pFuncOamRegister          = OamSetFunc;
	pSurface->pFuncOamAffineRegister    = AffineSetFunc;
	pSurface->pFuncVisibilityCulling    = cullFunc;

	// \
	pSurface->type                      = type;
	
	// _[ɐݒ
	if(pSetRenderer){
	    NNS_G2dAddRendererTargetSurface( pSetRenderer, pSurface );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[Xɋ`f[^ݒ肷
 *
 *@param	pSurface		T[tF[X
 *@param	pRect			ݒ肷`f[^	
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_SetSurfaceRect(NNSG2dRenderSurface* pSurface, NNSG2dViewRect* pRect)
{
	pSurface->viewRect = *pRect;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[XOAM̐ݒ֐ݒ
 *
 *@param	pSurface		T[tF[X
 *@param	OamSetFunc		OAMݒ֐
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_SetSurfaceOamSetFunc(NNSG2dRenderSurface* pSurface, NNSG2dOamRegisterFunction OamSetFunc)
{
	pSurface->pFuncOamRegister          = OamSetFunc;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[XɃAtBs̐ݒ֐ݒ
 *
 *@param	pSurface		T[tF[X
 *@param	AffineSetFunc		AtBsݒ֐
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_SetSurfaceAffineSetFunc(NNSG2dRenderSurface* pSurface, NNSG2dAffineRegisterFunction AffineSetFunc)
{
	pSurface->pFuncOamAffineRegister    = AffineSetFunc;
}
	
//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[XɃJO֐ݒ
 *
 *@param	pSurface		T[tF[X
 *@param	CullFunc		JO֐
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_SetSurfaceCullingFunc(NNSG2dRenderSurface* pSurface, NNSG2dRndCellCullingFunction CullFunc)
{
	pSurface->pFuncVisibilityCulling    = CullFunc;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[X^Cvݒ
 *
 *@param	pSurface		T[tF[X
 *@param	type			T[tF[X^Cv
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_SetSurfaceType(NNSG2dRenderSurface* pSurface, NNSG2dSurfaceType type)
{
	pSurface->type = type;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	T[tF[X_[ɐݒ
 *
 *@param	pSurface		T[tF[X
 *@param	pSetRenderer	ݒ肷郌_[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RNDP_SetSurfaceRenderer(NNSG2dRenderSurface* pSurface, NNSG2dRendererInstance* pSetRenderer)
{
	NNS_G2dAddRendererTargetSurface( pSetRenderer, pSurface );
}

//-----------------------------------------------------------------------------
/**
 *@brief	T[tFCXɃZ邩`FbNAJO
 *			JO͋ʂOKȂ̂ō쐬
 *
 *@param	pCellFΏۂ̃Zւ̃|C^
 *@param	pMtxFΏۂ̃ZɓKpWϊs
 *@param	pViewRectFo͐T[tFCX̕\`
 *
 *@retval	ΏۃZ\FTRUE
 *@retval	ΏۃZ\ȂFFALSE
 *
 */
 //----------------------------------------------------------------------------
BOOL RNDP_CallBackCulling( const NNSG2dCellData* pCell, const MtxFx32* pMtx, const NNSG2dViewRect* pViewRect )
{
	// Ro[^ɂvZꂽEa擾
    const fx32  R = NNSi_G2dGetCellBoundingSphereR( pCell ) * FX32_ONE / 2;

    // Z̕\ʒu_߂
    const fx32  px = pMtx->_20 - pViewRect->posTopLeft.x;
    const fx32  py = pMtx->_21 - pViewRect->posTopLeft.y;



	// Z̋E`߂
	// Z`ʒu𒆐SʒuɂƂ
    fx32  minY = -R;
    fx32  maxY = R;
    fx32  minX = -R;
    fx32  maxX = R;
	fx32  work;			// ւ悤*/

	
	// WvZōsvZ̍Wɕϊ
	minY = FX_Mul(minY, pMtx->_01) + FX_Mul(minY, pMtx->_11) + py;
	maxY = FX_Mul(maxY, pMtx->_01) + FX_Mul(maxY, pMtx->_11) + py;
	
	minX = FX_Mul(minX, pMtx->_00) + FX_Mul(minX, pMtx->_10) + px;
	maxX = FX_Mul(maxX, pMtx->_00) + FX_Mul(maxX, pMtx->_10) + px;

	// Wt]Ă\̂Ń`FbN
	if( maxY < minY ){
		work = maxY;
		maxY = minY;
		minY = work;
	}

	if( maxX < minX ){
		work = maxX;
		maxX = minX;
		minX = work;
	}

    if( (maxY > 0) && (minY < pViewRect->sizeView.y) ){
        if( (maxX > 0) && (minX < pViewRect->sizeView.x) ){
			return TRUE;
        }
    }
	
	return FALSE;
}
