//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *@file		res_manager.c
 *@brief	\[XǗ}l[W[
 *@author	tomoya takahashi
 *@data		2005.08.29
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]

#include "nnsys.h"
#include "system.h"
#include "assert.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"

#define __RES_MANAGER_H_GLOBAL
#include "res_manager.h"

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	\[Xwb_[X̃f[^
//
//	o^f[^܂Ƃ߂f[^ł
//	
//=====================================
typedef struct _RES_HEADER_SUB{
	int		id;				// ǗID
	char	file_path[64];	// t@CpX
} RES_HEADER_SUB;

//-------------------------------------
//	
//	\[Xwb_[̃f[^
//
//	X̃f[^܂Ƃ߂f[^
//	
//=====================================
typedef struct _RES_HEADER{
	RES_HEADER_SUB* tbl;	// X̃f[^e[u
	int				num;	// e[u
} RES_HEADER;


//-------------------------------------
//	
//	ǂݍ܂ꂽ\[X̃f[^
//	
//=====================================
typedef struct _RES_OBJ{
	int		id;		// ǗID
	void*	p_res;	// \[X|C^
} RES_OBJ;

//-------------------------------------
//	
//	\[XǗ}l[W[
//	Ǘf[^\
//	
//=====================================
typedef struct _RES_MANAGER{
	RES_OBJ*	p_work;		// \[Xi[e[u
	int			max;		// \i[
	int			now;		// ݊i[
} RES_MANAGER;





//-----------------------------------------------------------------------------
/**
*		eNX`\[X}l[W
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	
//	eNX`\[XIuWF
//	
//=====================================
typedef struct _TEXRES_OBJ{
	RES_OBJ*		resobj;		// \[XIuWF
	NNSGfdTexKey	texKey;		// eNX`L[
	NNSGfdTexKey	tex4x4Key;	// 4x4eNX`L[
	NNSGfdPlttKey	plttKey;	// pbgL[
	BOOL			cut_flag;	// eNX`f[^j
} TEXRES_OBJ;

//-------------------------------------
//	
//	eNX`\[X}l[W
//	
//=====================================
typedef struct _TEXRES_MANAGER{
	RES_MANAGER*	resm;	// \[X}l[W
	TEXRES_OBJ*		tobj;	// eNX`IuWFf[^
} TEXRES_MANAGER;





//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------
static RES_OBJ_PTR getCleanRES_OBJ(RES_MANAGER_PTR resm);
static void clean_RES_OBJ(RES_OBJ* data);
static int getHeaderNum(char* buff);
static void getHeaderData(char* buff, RES_HEADER_SUB* data, int num);
static void getOneData(char* buff, char** file_path, char** id);
static void setOneData(char* file_path, char* id, RES_HEADER_SUB* data);
static char* makeCopyStr(const char* buff, int heap);
static void delCopyStr(char* copy);


//-----------------------------------------------------------------------------
/**
*	eNX`}l[W
*/
//-----------------------------------------------------------------------------
static TEXRES_OBJ_PTR getCleanTEXRES_OBJ(CONST_TEXRES_MANAGER_PTR resm);
static void cleanTEXRES_OBJ(TEXRES_OBJ_PTR obj);
static void getVramkey( const NNSG3dResTex* res, NNSGfdTexKey* tex, NNSGfdTexKey* tex4x4, NNSGfdPlttKey* pltt );
static NNSG3dResTex* getTexRes( CONST_TEXRES_OBJ_PTR r_obj );
static void loadTexRes( NNSG3dResTex* res, TEXRES_OBJ_PTR r_obj );

// eNX`\[X폜NNSG3dResTex쐬֐S
static void MakeCutTexData( void* p_cuttex );
static u32 GetCutTexDataSize( const void* p_cuttex );

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XǗ}l[W[ԕ쐬
 *
 *@param	num		f[^Ǘe[u
 *
 *@return	RES_MANAGER_PTR		Ǘf[^|C^
 *
 * Ǘe[ü̊m
 * Ǘe[ü̏
 *
 */
//-----------------------------------------------------------------------------
RES_MANAGER_PTR RESM_Init(int num, int heap)
{
	RES_MANAGER_PTR resm;
	int i;		// [vp

	// \[XǗ}l[W[쐬
	resm = sys_AllocMemory(heap, sizeof(RES_MANAGER));
	GF_ASSERT(resm);
	
	// Ǘe[u쐬
	resm->p_work = sys_AllocMemory(heap, sizeof(RES_OBJ)*num);
	GF_ASSERT(resm->p_work);
	for(i=0;i<num;i++){
		clean_RES_OBJ( (resm->p_work + i) );
	}


	resm->max	= num;		// ő吔
	resm->now	= 0;		// ݓo^

	return resm;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XǗf[^j
 *
 *@param	resm	\[XǗf[^
 *
 *@return	none
 *
 *	ǂݍ񂾃\[Xj
 *	Ǘe[üj
 */
//-----------------------------------------------------------------------------
void RESM_Delete(RES_MANAGER_PTR resm)
{
	GF_ASSERT(resm);
	
	// o^Ă郊\[XSĔj
	RESM_DeleteAllRes(resm);

	// j
	sys_FreeMemoryEz(resm->p_work);
	sys_FreeMemoryEz(resm);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	co^\擾
 *
 *@param	resm	擾郊\[XǗf[^
 *
 *@return	int		co^\
 *
 *
 */
//-----------------------------------------------------------------------------
int RESM_GetRest(RES_MANAGER_PTR resm)
{
	GF_ASSERT(resm);

	return ( resm->max - resm->now );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IDdȂ擾
 *
 *@param	resm	擾郊\[XǗf[^
 *@param	id		`FbNID
 *
 *@retval	TRUE	dȂ
 *@retval	FALSE	d
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL RESM_CheckID(RES_MANAGER_PTR resm, int id)
{
	int i;		// [vp
	
	GF_ASSERT(resm);

	// IDe[u邩`FbN
	if( RESM_GetResObj(resm, id) == NULL ){
		// e[û,dȂ
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	\[X̓o^
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	res		\[X
 *@param	id		o^ID	idӁj
 *
 *@retval	RES_OBJ_PTR	o^
 *@retval	NULL		o^s	o^e[ut
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 *
 */
//-----------------------------------------------------------------------------
RES_OBJ_PTR RESM_AddResNormal(RES_MANAGER_PTR resm, void* res, int id)
{
	RES_OBJ_PTR r_obj;
	
	GF_ASSERT(resm);

	// 󂢂Ăe[u擾
	r_obj = getCleanRES_OBJ(resm);
	GF_ASSERT(r_obj && ("e[uɋ󂫂"));

	// IDdȂ`FbN
	GF_ASSERT( (RESM_CheckID(resm, id) == TRUE) );

	// \[Xǂݍ
	r_obj->p_res = res;

	r_obj->id = id;	// o^ID

	resm->now++;	// e[uo^ǉ

	return r_obj;
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	\[X̓o^
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	p_path	\[X̃pX
 *@param	id		o^ID	idӁj
 *@param	heap	\[Xǂݍ݂Ɏgpq[v
 *
 *@retval	RES_OBJ_PTR	o^
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 *
 */
//-----------------------------------------------------------------------------
RES_OBJ_PTR RESM_AddRes(RES_MANAGER_PTR resm, const char* p_path, int id, int heap)
{
	RES_OBJ_PTR r_obj;
	
	GF_ASSERT(resm);
	GF_ASSERT(p_path);

	// 󂢂Ăe[u擾
	r_obj = getCleanRES_OBJ(resm);
	GF_ASSERT(r_obj && ("e[uɋ󂫂"));

	// IDdȂ`FbN
	GF_ASSERT( (RESM_CheckID(resm, id) == TRUE) );

	// \[Xǂݍ
	r_obj->p_res = sys_LoadFile(heap, p_path);
	GF_ASSERT(r_obj->p_res && ("pXԈĂ܂"));

	r_obj->id = id;	// o^ID

	resm->now++;	// e[uo^ǉ

	return r_obj;
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	wb_[gp\[X̓o^iPj
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	header	\[Xwb_[|C^
 *@param	no		Ԗڂo^邩
 *@param	heap	\[Xǂݍ݂Ɏgpq[v
 *
 *@retval	RES_OBJ_PTR	o^
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 *
 */
//-----------------------------------------------------------------------------
RES_OBJ_PTR RESM_AddResHd(RES_MANAGER_PTR resm, const RES_HEADER_PTR header, int no, int heap)
{
	GF_ASSERT(resm);
	GF_ASSERT(header);

	// vfȉ`FbN
	GF_ASSERT(header->num > no);
	
	return RESM_AddRes(resm, header->tbl[no].file_path, header->tbl[no].id, heap);
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	wb_[gp\[X̓o^ij
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	header	\[Xwb_[|C^
 *@param	heap	\[Xǂݍ݂Ɏgpq[v
 *
 *@return	none
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 *
 */
//-----------------------------------------------------------------------------
void RESM_AddResHds(RES_MANAGER_PTR resm, const RES_HEADER_PTR header, int heap)
{
	GF_ASSERT(resm);
	GF_ASSERT(header);
	
	RESM_AddResHdsEx(resm, header, 0, header->num, heap);
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	wb_[gp\[X̓o^ij
 *			wb_[̊JnvfAIvfw
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	header	\[Xwb_[|C^
 *@param	start	Jnvf
 *@param	num		o^vf
 *@param	heap	\[Xǂݍ݂Ɏgpq[v
 *
 *@return	noen
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 *
 */
//-----------------------------------------------------------------------------
void RESM_AddResHdsEx(RES_MANAGER_PTR resm, const RES_HEADER_PTR header, int start, int num, int heap)
{
	int i;
	
	GF_ASSERT(resm);
	GF_ASSERT(header);

	// vfI[o[Ȃ`FbN
	GF_ASSERT((start+num) <= header->num)

	for(i=start;i<(start+num);i++){
		RESM_AddResHd(resm, header, i, heap);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X̔j
 *
 *@param	resm	j郊\[Xo^ĂǗf[^|C^
 *@param	r_obj	j郊\[XIuWF
 *
 * ǂݍ񂾃\[XjAǗf[^
 */
//-----------------------------------------------------------------------------
void RESM_DeleteRes(RES_MANAGER_PTR resm, RES_OBJ_PTR r_obj)
{
	GF_ASSERT(resm);
	GF_ASSERT(r_obj);

	if( r_obj->p_res ){
		sys_FreeMemoryEz(r_obj->p_res);
		r_obj->p_res = NULL;
	}
	r_obj->id = RES_MANAGER_ID_NONE;

	resm->now--;	// e[uo^Z
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IDŃ\[X̔j
 *
 *@param	resm	j郊\[Xo^ĂǗf[^|C^
 *@param	id		j郊\[XID
 *
 * ǂݍ񂾃\[XjAǗf[^
 */
//-----------------------------------------------------------------------------
void RESM_DeleteResID(RES_MANAGER_PTR resm, int id)
{
	RES_OBJ_PTR	data;

	GF_ASSERT(resm);
	data = RESM_GetResObj(resm, id);
	GF_ASSERT( data && ("ID̃f[^͂܂B"));

	// j
	RESM_DeleteRes(resm, data);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	S\[X̔j
 *
 *@param	resm	j郊\[Xo^ĂǗf[^|C^
 *
 * ǂݍ񂾃\[XjAǗf[^
 */
//-----------------------------------------------------------------------------
void RESM_DeleteAllRes(RES_MANAGER_PTR resm)
{
	int i;	// [vp
	
	GF_ASSERT(resm);
	GF_ASSERT(resm->p_work);
	
	for(i=0; i<resm->max;i++){
		if( resm->p_work[i].id != RES_MANAGER_ID_NONE ){
			RESM_DeleteRes(resm, (resm->p_work + i));
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFNgf[^|C^擾
 *
 *@param	resm		\[XǗf[^
 *@param	id			\[XID
 *
 *@retval	NULL		o^ĂȂ
 *@retval	RES_OBJ_PTR	o^Ă郊\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
RES_OBJ_PTR RESM_GetResObj(RES_MANAGER_PTR resm, int id)
{
	int i;	// [vp
	GF_ASSERT(resm);

	for(i = 0;i < resm->max; i++){
		if(resm->p_work[i].id == id){
			return (resm->p_work + i);
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^Ă郊\[Xf[^擾
 *
 *@param	r_obj		\[XIuWF
 *
 *@retval	NULL		o^ĂȂ
 *@retval	NULLȊO	o^Ă郊\[X|C^
 *
 *
 */
//-----------------------------------------------------------------------------
void* RESM_GetRes(RES_OBJ_PTR r_obj)
{
	GF_ASSERT(r_obj);

	return r_obj->p_res;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^Ă郊\[Xf[^ύX
 *
 *@param	r_obj		\[XIuWF
 *
 *@param	o^Ă郊\[Xf[^ύX
 *
 */
//-----------------------------------------------------------------------------
void RESM_SetRes(RES_OBJ_PTR r_obj, void* res)
{
	GF_ASSERT(r_obj);

	if( r_obj->p_res ){
		sys_FreeMemoryEz(r_obj->p_res);
	}
	r_obj->p_res = res;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ĂID擾
 *
 *@param	r_obj		\[XIuWF
 *
 *@retval	int			ID
 *
 *
 */
//-----------------------------------------------------------------------------
int RESM_GetID(RES_OBJ_PTR r_obj)
{
	GF_ASSERT(r_obj);

	return r_obj->id;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ĂIDݒ
 *
 *@param	r_obj		\[XIuWF
 *@param	id			ݒ肷ID
 *
 *@retval	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RESM_SetID(RES_MANAGER_PTR resm, RES_OBJ_PTR r_obj, int id)
{
	GF_ASSERT(resm);
	GF_ASSERT(r_obj);
	GF_ASSERT( RESM_CheckID(resm, id) );	// dȂ`FbN

	r_obj->id = id;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	󂢂ĂIuWF擾
 *	
 *@param	none
 *
 *@retval	RES_OBJ_PTR	󂢂ĂIuWF
 *@retval	NULL		󂢂ĂȂ
 *
 *
 */
//-----------------------------------------------------------------------------
static RES_OBJ_PTR getCleanRES_OBJ(RES_MANAGER_PTR resm)
{
	int i;
	GF_ASSERT(resm);

	for(i=0;i<resm->max;i++){
		if(resm->p_work[i].id == RES_MANAGER_ID_NONE){
			return resm->p_work + i;
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWF̏
 *
 *@param	data	f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void clean_RES_OBJ(RES_OBJ* data)
{
	GF_ASSERT(data);
	data->id	= RES_MANAGER_ID_NONE;
	data->p_res = NULL;
}

//-----------------------------------------------------------------------------
//
//		*********** wb_[p֐ **************
//
//=============================================================================
//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[TCY擾
 *
 *@param	none	
 *
 *@return	int		wb_[̃oCgTCY
 *
 *
 */
//-----------------------------------------------------------------------------
int RESM_GetHeaderSize(void)
{
	return sizeof(RES_HEADER);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	wb_[z񂩂vf̃f[^Ԃ
 *
 *@param	tbl		zɂȂĂwb_[
 *@param	no		vf
 *
 *@return	RES_HEADER_PTR data[no] ̃AhX
 *
 *
 */
//-----------------------------------------------------------------------------
RES_HEADER_PTR RESM_GetTbl(RES_HEADER_PTR tbl, int no)
{
	GF_ASSERT(tbl);
	return ( tbl + no );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xwb_[̓ǂݍ
 *
 *@param	header			wb_[f[^i[
 *@param	rom_path		wb_[t@CpX
 *@param	heap			Ё[ID 
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RESM_HeaderLoad(RES_HEADER_PTR header, const char* rom_path, int heap)
{
	char* tmp;				// p
	char* buff;				// t@Cf[^
	int	i;					// [vp

	GF_ASSERT(header);		// wb_[̈mۂĂ
	GF_ASSERT(rom_path);


	// t@CI[v
	tmp = sys_LoadFile(heap, rom_path);
	GF_ASSERT(tmp&&("wb_[ǂݍݎs"))

	// [Nobt@
	buff = makeCopyStr(tmp, heap);
	
	// t@C擾
	header->num = getHeaderNum(buff);

	// m
	header->tbl = sys_AllocMemory(heap, sizeof(RES_HEADER_SUB)*header->num);
	GF_ASSERT(header->tbl);

	// [Nobt@ɑ
	delCopyStr(buff);	// j
	buff = makeCopyStr(tmp, heap);

	// f[^ǂݍ
	getHeaderData(buff, header->tbl, header->num);

	// ǂݍ݃t@Cj
	delCopyStr(buff);
	sys_FreeMemoryEz(tmp);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[Xwb_[̔j
 *
 *@param	header			wb_[f[^f[^
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void RESM_HeaderFree(RES_HEADER_PTR header)
{
	GF_ASSERT(header);
	GF_ASSERT(header->tbl);
	
	sys_FreeMemoryEz(header->tbl);
	header->tbl = NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^f[^擾
 *
 *@param	buff	obt@
 *
 *@return	int		f[^
 *
 *
 */
//-----------------------------------------------------------------------------
static int getHeaderNum(char* buff)
{
	int count;			// f[^JEg
	char* file_path;	// t@CpX
	char* id;			// t@CpX


	count = 0;
	getOneData(buff, &file_path, &id);	// P̃f[^i[
	// pX'0'̃f[^I[
	while(file_path[0] != '0'){
		count++;

		getOneData(NULL, &file_path, &id);	// Pڈȍ~NULLOK

		if(file_path == NULL){
			GF_ASSERT(0);		// I[R[h
		}
	}

	return count;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	f[^i[
 *
 *@param	buff	݂̃t@C|C^
 *@param	data	f[^i[
 *@param	num		
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void getHeaderData(char* buff, RES_HEADER_SUB* data, int num)
{
	int i;		// [vp
	char* file_path;	// t@CpX
	char* id;			// t@CpX

	getOneData(buff, &file_path, &id);	// P̃f[^i[
	setOneData(file_path, id, &data[0]);
	for(i=1;i<num;i++){
		getOneData(NULL, &file_path, &id);	// P̃f[^i[
		setOneData(file_path, id, &data[i]);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	P̃f[^擾
 *
 *@param	buff		ŏȊONULL
 *@param	file_path	t@CpX
 *@param	id			ID
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void getOneData(char* buff, char** file_path, char** id)
{
	*file_path	= strtok(buff, ", \n");
	*id			= strtok(NULL, ", \n");
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	P̃f[^ݒ
 *
 *@param	fiel_path	t@CpX
 *@param	id			id
 *@param	data		i[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void setOneData(char* file_path, char* id, RES_HEADER_SUB* data)
{
	data->id		= atoi(id);
	strcpy(data->file_path, file_path);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	obt@̃Rs[쐬
 *
 *@param	buff	Rs[obt@
 *@param	heap	gpq[v
 *
 *@return
 *
 *
 */
//-----------------------------------------------------------------------------
static char* makeCopyStr(const char* buff, int heap)
{
	int size;
	char* copy;

	size = strlen(buff);
	size++;

	copy = sys_AllocMemoryLo(heap, size);
	strcpy(copy, buff);

	return copy;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	Rs[j
 *
 *@param	copy	Rs[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void delCopyStr(char* copy)
{
	sys_FreeMemoryEz(copy);
}






//-----------------------------------------------------------------------------
/**
*
*	eNX`Ǘ\[X}l[W
* 
*/
//-----------------------------------------------------------------------------

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XǗ}l[W[ԕ쐬
 *
 *@param	num		f[^Ǘe[u
 *
 *@return	TEXRES_MANAGER_PTR		Ǘf[^|C^
 *
 * Ǘe[ü̊m
 * Ǘe[ü̏
 *
 */
	//-----------------------------------------------------------------------------
TEXRES_MANAGER_PTR TEXRESM_Init(int num, int heap)
{
	TEXRES_MANAGER_PTR resm;
	int i;
	
	resm		= sys_AllocMemory( heap, sizeof(TEXRES_MANAGER) );
	
	resm->resm	= RESM_Init( num, heap );

	resm->tobj	= sys_AllocMemory( heap, sizeof(TEXRES_OBJ) * num );

	for(i=0;i<num;i++){
		cleanTEXRES_OBJ( resm->tobj + i );
	}

	return resm;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XǗf[^j
 *
 *@param	resm	\[XǗf[^
 *
 *@return	none
 *
 *	ǂݍ񂾃\[Xj
 *	Ǘe[üj
 */
//-----------------------------------------------------------------------------
void TEXRESM_Delete(TEXRES_MANAGER_PTR resm)
{
	GF_ASSERT(resm);
	
	// o^Ă郊\[Xj
	TEXRESM_DeleteAllRes( resm );
	
	// gpĂ\[X}l[Wj
	RESM_Delete( resm->resm );
	
	sys_FreeMemoryEz( resm->tobj );
	sys_FreeMemoryEz( resm );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	co^\擾
 *
 *@param	resm	擾郊\[XǗf[^
 *
 *@return	int		co^\
 *
 *
 */
//-----------------------------------------------------------------------------
int TEXRESM_GetRest(CONST_TEXRES_MANAGER_PTR resm)
{
	GF_ASSERT(resm);

	return RESM_GetRest( resm->resm );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IDdȂ擾
 *
 *@param	resm	擾郊\[XǗf[^
 *@param	id		`FbNID
 *
 *@retval	TRUE	dȂ
 *@retval	FALSE	d
 *
 *
 */
//-----------------------------------------------------------------------------
BOOL TEXRESM_CheckID(CONST_TEXRES_MANAGER_PTR resm, int id)
{
	GF_ASSERT(resm);

	return RESM_CheckID( resm->resm, id );
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	\[X̓o^
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	res		\[X
 *@param	id		o^ID	idӁj
 *
 *@retval	TEXRES_OBJ_PTR	o^
 *@retval	NULL		o^s	o^e[ut
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 *
 */
//-----------------------------------------------------------------------------
TEXRES_OBJ_PTR TEXRESM_AddResNormal(CONST_TEXRES_MANAGER_PTR resm, void* res, int id)
{
	TEXRES_OBJ_PTR tobj;

	GF_ASSERT(resm);	
	tobj = getCleanTEXRES_OBJ( resm );
	tobj->resobj = RESM_AddResNormal( resm->resm, res, id );

	return tobj;
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	\[X̓o^
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	p_path	\[X̃pX
 *@param	id		o^ID	idӁj
 *@param	heap	\[Xǂݍ݂Ɏgpq[v
 *
 *@retval	TEXRES_OBJ_PTR	o^
 *@retval	NULL		o^s	o^e[utorpXȂ
 *
 * pX̃\[XǂݍŁAǗf[^ɐݒ
 * 
 */
//-----------------------------------------------------------------------------
TEXRES_OBJ_PTR TEXRESM_AddRes(TEXRES_MANAGER_PTR resm, const char* p_path, int id, int heap)
{
	TEXRES_OBJ_PTR tobj;
	GF_ASSERT(resm);	
	tobj = getCleanTEXRES_OBJ( resm );
	tobj->resobj = RESM_AddRes( resm->resm, p_path, id, heap );

	return tobj;
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	\[X̓o^VramKey̎擾s
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	res		\[X
 *@param	id		o^ID	idӁj
 *
 *@retval	TEXRES_OBJ_PTR	o^
 *@retval	NULL		o^s	o^e[ut
 *
 * ̗
 *	PFpX̃\[Xǂݍ
 *	QFVramKey擾
 */
//-----------------------------------------------------------------------------
TEXRES_OBJ_PTR TEXRESM_AddAndAllocVramKeyResNormal(TEXRES_MANAGER_PTR resm, void* res, int id)
{
	TEXRES_OBJ_PTR tobj;

	// \[X}l[Wɓo^
	tobj = TEXRESM_AddResNormal( resm, res, id );

	// VramKey̎擾
	TEXRESM_AllocVramKeyPTR( tobj );
	
	return tobj;
}

//----------------------------------------------------------------------------
/**
 *	
 *@brief	\[X̓o^Vram]		pXw
 *
 *@param	resm	o^郊\[XǗf[^|C^
 *@param	p_path	\[X̃pX
 *@param	id		o^ID	idӁj
 *@param	heap	\[Xǂݍ݂Ɏgpq[v
 *
 *@retval	TEXRES_OBJ_PTR	o^
 *@retval	NULL		o^s	o^e[utorpXȂ
 *
 * ̗
 *	PFpX̃\[Xǂݍ
 *	QFVramKey擾
 *
 */
//-----------------------------------------------------------------------------
TEXRES_OBJ_PTR TEXRESM_AddAndAllocVramKeyRes(TEXRES_MANAGER_PTR resm, const char* p_path, int id, int heap)
{
	TEXRES_OBJ_PTR tobj;

	// \[X}l[Wɓo^
	tobj = TEXRESM_AddRes( resm, p_path, id, heap );

	// VramKey̎擾
	TEXRESM_AllocVramKeyPTR( tobj );

	return tobj;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	\[X̔j
 *
 *@param	resm	j郊\[Xo^ĂǗf[^|C^
 *@param	r_obj	j郊\[XIuWF
 *
 * ǂݍ񂾃\[XjAǗf[^
 */
//-----------------------------------------------------------------------------
void TEXRESM_DeleteRes(TEXRES_MANAGER_PTR resm, TEXRES_OBJ_PTR r_obj)
{
	int check;
	
	GF_ASSERT(resm);	
	GF_ASSERT(r_obj);
	
	if(r_obj->resobj){
		RESM_DeleteRes( resm->resm, r_obj->resobj );
	}

	// eNX`L[Ƃ͔j
	if(r_obj->texKey != NNS_GFD_ALLOC_ERROR_TEXKEY){
		check = NNS_GfdFreeTexVram( r_obj->texKey );
		GF_ASSERT_MSG(check == 0, "eNX`L[js");
	}
	if(r_obj->tex4x4Key != NNS_GFD_ALLOC_ERROR_TEXKEY){
		check = NNS_GfdFreeTexVram( r_obj->tex4x4Key );
		GF_ASSERT_MSG(check == 0, "eNX`L[js");
	}
	// pbgL[j
	if(r_obj->plttKey != NNS_GFD_ALLOC_ERROR_PLTTKEY){
		check = NNS_GfdFreePlttVram( r_obj->plttKey );
		GF_ASSERT_MSG(check == 0, "pbgL[js");
	}

	cleanTEXRES_OBJ( r_obj );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	IDŃ\[X̔j
 *
 *@param	resm	j郊\[Xo^ĂǗf[^|C^
 *@param	id		j郊\[XID	(ǗID)
 *
 * ǂݍ񂾃\[XjAǗf[^
 */
//-----------------------------------------------------------------------------
void TEXRESM_DeleteResID(TEXRES_MANAGER_PTR resm, int id)
{
	TEXRES_OBJ_PTR tobj;
	GF_ASSERT( resm );

	tobj = TEXRESM_GetResObj( resm, id );

	TEXRESM_DeleteRes( resm, tobj );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	S\[X̔j
 *
 *@param	resm	j郊\[Xo^ĂǗf[^|C^
 *
 * ǂݍ񂾃\[XjAǗf[^
 */
//-----------------------------------------------------------------------------
void TEXRESM_DeleteAllRes(TEXRES_MANAGER_PTR resm)
{
	int i;		// [vp
	GF_ASSERT(resm);
	GF_ASSERT(resm->tobj);
	
	for( i = 0; i < resm->resm->max; i++ ){
		if(resm->tobj[ i ].resobj){
			TEXRESM_DeleteRes( resm, resm->tobj + i );
		}
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	\[XIuWFNgf[^|C^擾
 *
 *@param	resm		\[XǗf[^
 *@param	id			\[XID	(ǗID)
 *
 *@retval	NULL		o^ĂȂ
 *@retval	TEXRES_OBJ_PTR	o^Ă郊\[XIuWF|C^
 *
 *
 */
//-----------------------------------------------------------------------------
TEXRES_OBJ_PTR TEXRESM_GetResObj(CONST_TEXRES_MANAGER_PTR resm, int id)
{
	int i;
	int res_id;
	
	GF_ASSERT( resm );

	for(i=0;i<resm->resm->max;i++){
		
		if( resm->tobj[ i ].resobj ){
			res_id = TEXRESM_GetID( resm->tobj + i );
			if( res_id == id ){
				return resm->tobj + i;
			}
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ĂID擾
 *
 *@param	r_obj		\[XIuWF
 *
 *@retval	int			ǗID
 *
 *
 */
//-----------------------------------------------------------------------------
int TEXRESM_GetID(CONST_TEXRES_OBJ_PTR r_obj)
{
	GF_ASSERT( r_obj );

	return RESM_GetID( r_obj->resobj );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ĂIDݒ
 *
 *@param	resm		\[X}l[W
 *@param	r_obj		\[XIuWF
 *@param	id			ݒ肷ID
 *
 *@retval	none
 *
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_SetID(TEXRES_MANAGER_PTR resm, TEXRES_OBJ_PTR r_obj, int id)
{
	GF_ASSERT( resm );
	GF_ASSERT( r_obj );

	RESM_SetID( resm->resm, r_obj->resobj, id );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	o^ĂeNX`\[Xf[^擾
 *
 *@param	r_obj		eNX`\[XIuWF
 *
 *@retval	NULL		o^ĂȂ
 *@retval	NULLȊO	o^ĂeNX`\[X|C^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG3dResTex* TEXRESM_GetResPTR(CONST_TEXRES_OBJ_PTR r_obj)
{
	GF_ASSERT( r_obj );

	return getTexRes( r_obj );
}

//----------------------------------------------------------------------------
/**
 * IDŎ擾
 *
 *@brief	o^ĂeNX`\[Xf[^擾
 *
 *@param	resm		eNX`\[X}l[W
 *@param	id			o^ID
 *
 *@retval	NULL		o^ĂȂ
 *@retval	NULLȊO	o^ĂeNX`\[X|C^
 *
 *
 */
//-----------------------------------------------------------------------------
NNSG3dResTex* TEXRESM_GetResID(CONST_TEXRES_MANAGER_PTR resm, int id)
{
	TEXRES_OBJ_PTR resobj;
	resobj = TEXRESM_GetResObj( resm, id );

	return getTexRes( resobj );
}

//----------------------------------------------------------------------------
/**
 * IuWFNg|C^
 *
 *	@brief	eNX`\[XVramɓ]
 *
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	none
 *
 * ̊֐ĂԂVramKey쐬܂B
 * mۂVramKeyTEXRESM_DeleteResn֐Ń\[Xƈꏏɔj܂
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_TexLoadPTR( TEXRES_OBJ_PTR r_obj )
{
	NNSG3dResTex* tex_res;
	
	GF_ASSERT(r_obj);
	GF_ASSERT_MSG( r_obj->cut_flag == FALSE, "eNX`f[^jς݂Ȃ̂œ]͂ł܂B" );
	
	// VramKey擾f[^`FbN
	if( r_obj->plttKey == NNS_GFD_ALLOC_ERROR_PLTTKEY ){
		GF_ASSERT_MSG(0, "VramKey擾ĂȂ̂ɓ]悤ƂĂ܂BTEXRESM_AllocVramKey֐sĂTEXRESM_TexLoad֐sĂB");
		return ;
	}

	// eNX`\[X̎擾
	tex_res = getTexRes( r_obj );
	
	// Vram̈ɓ]
	loadTexRes( tex_res, r_obj );
}

//----------------------------------------------------------------------------
/**
 * ID
 *
 *	@brief	eNX`\[XVramɓ]
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return	none
 *
 * ̊֐ĂԂVramKey쐬܂B
 * mۂVramKeyTEXRESM_DeleteResn֐Ń\[Xƈꏏɔj܂
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_TexLoadID( TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );


	TEXRESM_TexLoadPTR( resobj );
}

//----------------------------------------------------------------------------
/**
 * IuWFNg|C^
 *
 *	@brief	eNX`\[X̎f[^j
 *
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_CutTexPTR( TEXRES_OBJ_PTR r_obj )
{
	void* buff;
	
	GF_ASSERT(r_obj);
	
	//  jς݂łȂ`FbN
	if( r_obj->cut_flag ){
		GF_ASSERT_MSG(0, "jς݂ł");
		return ;
	}


	// eNX`̃\[X擾
	buff = RESM_GetRes( r_obj->resobj );
	GF_ASSERT_MSG(buff, "\[Xݒ肳Ă܂B");
	
	// eNX`f[^̔j
	MakeCutTexData( buff );

	// eNX`f[^j
	r_obj->cut_flag = TRUE;
}

//----------------------------------------------------------------------------
/**
 * ID
 *
 *	@brief	eNX`\[X̎f[^j
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_CutTexID( TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );

	TEXRESM_CutTexPTR( resobj );
}

//----------------------------------------------------------------------------
/**
 * IuWFNg|C^Ŋm
 *
 *	@brief	eNX`L[VramManagermۂ܂
 *
 *	@param	r_obj		\[XIuWF
 *
 *	@return none
 *
 * mۂVramKeyieNX`L[@pbgL[j
 * TEXRESM_Delete`֐Ŕj܂B
 *
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_AllocVramKeyPTR( TEXRES_OBJ_PTR r_obj )
{
	NNSG3dResTex* tex_res;

	GF_ASSERT( r_obj );
	GF_ASSERT_MSG( r_obj->cut_flag == FALSE, "eNX`f[^jς݂Ȃ̂VramKeymۂł܂B" );
	
	// VramKey擾ς݂łȂ`FbN
	if( r_obj->plttKey != NNS_GFD_ALLOC_ERROR_PLTTKEY ){
		GF_ASSERT_MSG(0, "VramKey擾ς݂ł");
		return ;
	}

	// eNX`\[X̎擾
	tex_res = getTexRes( r_obj );
	
	// Vramkey̎擾
	getVramkey( tex_res, &r_obj->texKey, &r_obj->tex4x4Key, &r_obj->plttKey );
}	

//----------------------------------------------------------------------------
/**
 * IDŊm
 *
 *	@brief	eNX`L[VramManagermۂ܂
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return none
 *
 * mۂVramKeyieNX`L[@pbgL[j
 * TEXRESM_Delete`֐Ŕj܂B
 *
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_AllocVramKeyID( CONST_TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );


	TEXRESM_AllocVramKeyPTR( resobj );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`\[XVramɓ]
 *
 *	@param	r_obj		eNX`\[XIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_TexLoadAndCutTexPTR( TEXRES_OBJ_PTR r_obj )
{
	TEXRESM_TexLoadPTR( r_obj );
	TEXRESM_CutTexPTR( r_obj );
}

//----------------------------------------------------------------------------
/**
 * IDŎ擾
 *
 *	@brief	eNX`\[XVramɓ]
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return	none
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_TexLoadAndCutTexID( TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );

	TEXRESM_TexLoadAndCutTexPTR( resobj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`L[̎擾
 *
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	eNX`L[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdTexKey TEXRESM_GetTexKeyPTR( CONST_TEXRES_OBJ_PTR r_obj )
{
	GF_ASSERT(r_obj);

	return r_obj->texKey;
}

//----------------------------------------------------------------------------
/**
 * IDŎ擾
 *
 *	@brief	eNX`L[̎擾
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return	eNX`L[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdTexKey TEXRESM_GetTexKeyID( CONST_TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );

	return TEXRESM_GetTexKeyPTR( resobj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`4x4L[̎擾
 *
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	eNX`L[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdTexKey TEXRESM_GetTex4x4KeyPTR( CONST_TEXRES_OBJ_PTR r_obj )
{
	GF_ASSERT(r_obj);

	return r_obj->tex4x4Key;
}

//----------------------------------------------------------------------------
/**
 * IDŎ擾
 *
 *	@brief	eNX`4x4L[̎擾
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return	eNX`L[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdTexKey TEXRESM_GetTex4x4KeyID( CONST_TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );

	return TEXRESM_GetTex4x4KeyPTR( resobj );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	pbgL[̎擾
 *
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	pbgL[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdPlttKey TEXRESM_GetPlttKeyPTR( CONST_TEXRES_OBJ_PTR r_obj )
{
	GF_ASSERT(r_obj);

	return r_obj->plttKey;
}

//----------------------------------------------------------------------------
/**
 * IDŎ擾
 *
 *	@brief	pbgL[̎擾
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *
 *	@return	pbgL[
 *
 *
 */
//-----------------------------------------------------------------------------
NNSGfdPlttKey TEXRESM_GetPlttKeyID( CONST_TEXRES_MANAGER_PTR resm, int id )
{
	TEXRES_OBJ_PTR resobj;
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );

	return TEXRESM_GetPlttKeyPTR( resobj );
}

//----------------------------------------------------------------------------
/**
 * IuWFNg|C^
 *
 *	@brief	w肳ꂽVramKeyʒuɃeNX`]܂B
 *
 *	@param	r_obj		eNX`\[XIuWF
 *	@param	texkey		eNX`L[
 *	@param	tex4x4key	eNX`4x4L[
 *	@param	plttkey		pbgL[
 *
 *	@return	none
 *
 * texkeyEplttkeyf[^̓eNX`\[X}l[Wł
 * Ǘ܂̂ŁAemہAjĂB
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_TexLoadOfKeyPTR( TEXRES_OBJ_PTR r_obj, NNSGfdTexKey texkey, NNSGfdTexKey tex4x4key, NNSGfdPlttKey plttkey )
{
	NNSG3dResTex* res;
	
	GF_ASSERT( r_obj );
	GF_ASSERT_MSG( r_obj->cut_flag == FALSE, "eNX`f[^폜Ă̂œ]ł܂B" );

	res = getTexRes( r_obj );
	
	NNS_G3dTexSetTexKey(res, texkey, tex4x4key);
	NNS_G3dPlttSetPlttKey(res, plttkey);


	DC_FlushRange( res, res->header.size );
	// VRAMւ̃[h
	NNS_G3dTexLoad(res, TRUE);
	NNS_G3dPlttLoad(res, TRUE);
}

//----------------------------------------------------------------------------
/**
 *	ID
 * 
 *	@brief	w肳ꂽVramKeyʒuɃeNX`]܂B
 *
 *	@param	resm		eNX`\[X}l[W
 *	@param	id			o^ID
 *	@param	texkey		eNX`L[
 *	@param	tex4x4key	eNX`4x4L[
 *	@param	plttkey		pbgL[
 *
 *	@return	none
 *
 * texkeyEplttkeyf[^̓eNX`\[X}l[Wł
 * Ǘ܂̂ŁAemہAjĂB
 *
 */
//-----------------------------------------------------------------------------
void TEXRESM_TexLoadOfKeyID( TEXRES_MANAGER_PTR resm, int id, NNSGfdTexKey texkey, NNSGfdTexKey tex4x4key, NNSGfdPlttKey plttkey )
{
	TEXRES_OBJ_PTR resobj;
	GF_ASSERT( resm );
	resobj = TEXRESM_GetResObj( resm, id );

	TEXRESM_TexLoadOfKeyPTR( resobj, texkey, tex4x4key, plttkey );
}


//----------------------------------------------------------------------------
/**
 *
 *	@brief	󂢂ĂeNX`\[XIuWF̎擾
 *
 *	@param	resm	\[X}l[W
 *
*	@return	󂢂ĂeNX`\[XIuWF
 *
 *
 */
//-----------------------------------------------------------------------------
static TEXRES_OBJ_PTR getCleanTEXRES_OBJ(CONST_TEXRES_MANAGER_PTR resm)
{
	int i;

	for(i=0;i<resm->resm->max;i++){
		if(resm->tobj[i].resobj == NULL){
			return resm->tobj + i;
		}
	}

	return NULL;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`\[XIuWF
 *
 *	@param	obj		eNX`\[XIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void cleanTEXRES_OBJ(TEXRES_OBJ_PTR obj)
{
	obj->resobj		= NULL;
	obj->texKey		= NNS_GFD_ALLOC_ERROR_TEXKEY;
	obj->tex4x4Key	= NNS_GFD_ALLOC_ERROR_TEXKEY;
	obj->plttKey	= NNS_GFD_ALLOC_ERROR_PLTTKEY;
	obj->cut_flag	= FALSE;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`\[X̎擾
 *
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	eNX`\[X
 *
 *
 */
//-----------------------------------------------------------------------------
static NNSG3dResTex* getTexRes( CONST_TEXRES_OBJ_PTR r_obj )
{
	void* buff;
	NNSG3dResTex* o_tex;

	buff = RESM_GetRes( r_obj->resobj );

	o_tex = NNS_G3dGetTex(buff);


	return o_tex;
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`\[Xf[^pVramkey擾
 *
 *	@param	res		eNX`\[X
 *	@param	tex		eNX`L[
 *	@param	tex4x4	4x4keNX`
 *	@param	pltt	pbgL[
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void getVramkey( const NNSG3dResTex* res, NNSGfdTexKey* tex, NNSGfdTexKey* tex4x4, NNSGfdPlttKey* pltt )
{
	u32 tex_size;
	u32 tex_4x4_size;
	u32 pltt_size;

	tex_size = NNS_G3dTexGetRequiredSize( res );
	tex_4x4_size = NNS_G3dTex4x4GetRequiredSize(res);
	pltt_size = NNS_G3dPlttGetRequiredSize( res );


	if(tex_size != 0){
		*tex = NNS_GfdAllocTexVram( tex_size, FALSE, 0 );
		// eNX`L[mێs
//		GF_ASSERT(*tex != NNS_GFD_ALLOC_ERROR_TEXKEY );
	}
	if(tex_4x4_size != 0){
		*tex4x4 = NNS_GfdAllocTexVram( tex_4x4_size, TRUE, 0 );
		// eNX`L[mێs
//		GF_ASSERT(*tex4x4 != NNS_GFD_ALLOC_ERROR_TEXKEY );
	}
	if(pltt_size != 0){
		*pltt = NNS_GfdAllocPlttVram( pltt_size, 
			res->tex4x4Info.flag & NNS_G3D_RESPLTT_USEPLTT4, 0 );
		// pbgL[mێs
//		GF_ASSERT(*pltt != NNS_GFD_ALLOC_ERROR_PLTTKEY );
	}
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`\[Xǂݍ
 *
 *	@param	res		eNX`\[X
 *	@param	r_obj	eNX`\[XIuWF
 *
 *	@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void loadTexRes( NNSG3dResTex* res, TEXRES_OBJ_PTR r_obj )
{
	NNS_G3dTexSetTexKey(res, r_obj->texKey, r_obj->tex4x4Key);
	NNS_G3dPlttSetPlttKey(res, r_obj->plttKey);

	DC_FlushRange( res, res->header.size );
	// VRAMւ̃[h
	NNS_G3dTexLoad(res, TRUE);
	NNS_G3dPlttLoad(res, TRUE);
}

// eNX`\[X폜NNSG3dResTex쐬֐S
//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`f[^jNNSG3dResTex쐬
 *
 *	@param	p_cuttex	eNX`f[^jeNX`\[X
 *
 *	@return	none	
 *
 *
 */
//-----------------------------------------------------------------------------
static void MakeCutTexData( void* p_cuttex )
{
	u32	data_size;		// eNX`f[^ȂeNX`\[XTCY
	// eNX`f[^ȂeNX`\[XTCY擾
	data_size = GetCutTexDataSize( p_cuttex );
	
	// [̃TCYJbg
	sys_CutMemoryBlockSize( p_cuttex, data_size );
}

//----------------------------------------------------------------------------
/**
 *
 *	@brief	eNX`f[^ȂeNX`\[XTCY̌vZ
 *
 *	@param	p_cuttex	vZeNX`\[Xf[^
 *
 *	@return	eNX`f[^ȂeNX`\[X̃TCY
 *
 *
 */
//-----------------------------------------------------------------------------
static u32 GetCutTexDataSize( const void* p_cuttex )
{
	NNSG3dResTex* p_tex;
	u8* tex_top;		// eNX`f[^擪f[^
	u32 new_size;		// Vf[^TCY

	p_tex = NNS_G3dGetTex( p_cuttex );
	GF_ASSERT_MSG( p_tex, "̃\[Xɂ̓eNX`f[^܂B" );

	// eNX`̐擪AhXvZ
	tex_top = (u8*)p_tex + p_tex->texInfo.ofsTex;

	// q[v̐擪eNX`C[W܂ł̃TCY
    new_size = (u32)(tex_top - (u8*)p_cuttex);

	return new_size;
}
