/*---------------------------------------------------------------------------*
  Project:  PokemonDS
  File:     simple_3dgraphics.c

  {RcOtBbNVXe

 *---------------------------------------------------------------------------*/
#include <nitro.h>
#include <nnsys.h>
#include <nnsys/g3d/binres/res_print.h>

#include "system.h"
#include "display.h"
#include "bg_system.h"
#define	__SIMPLE_3DGRAPHICS_H_GLOBAL
#include "simple_3dgraphics.h"

#include "tcb.h"

#include "gflib_os_print.h"
#include "gflib/assert.h"
#include "assert.h"

#define PLTT_BLOCK_SIZE	(256)
#define TEX_BLOCK_SIZE	(256)


#ifdef DEBUG_3DDRAW_COUNT

typedef struct VRAM_MANAGER_MEM_tag
{
	void *PalMem;
	void *TexMem;
}VRAM_MANAGER_MEM;

//----- |S`̉񐔂𒲂ׂ邽߂DEBUG
typedef struct{
	int NNS_AddVertexNum;
	int NNS_AddPolygonNum;
	int NNS_AddDrawNum;
	int VertexNum;
	int PolygonNum;
	int DrawNum;

	NNSiGfdLnkVramBlock *texture_p;
	NNSiGfdLnkVramBlock *pal_p;
}DEBUG_DRAW_COUNT;

DEBUG_DRAW_COUNT DebugDrawCount;

	
#endif

static VRAM_MANAGER_MEM_PTR AllocVramManegerMem(const int inPalSize,
												const int inTexSize,
												const int inHeapID);
static void FreeVramManegerMem(VRAM_MANAGER_MEM_PTR *ptr);

//------------------------------------------------------------------
//                      fǂݍ݊֐
//------------------------------------------------------------------

void simple_LoadG3DModel(const u8 mode, const char* path, NNSG3dResMdl** model, NNSG3dResFileHeader** resFile)
{
    NNSG3dResTex*        texture = NULL;
    BOOL status;

    *resFile = sys_LoadFile(mode,path);
    NNS_G3D_NULL_ASSERT(*resFile);

	// eNX`VramɓWJĂȂ`FbN
	texture = NNS_G3dGetTex(*resFile);	// eNX`\[X擾
	if(texture != NULL){
		if(TexKeyLive(texture) == FALSE){	// eNX`VramɓWJĂȂ`FbN
			///OS_Printf("eNX`VRAMɓWJĂȂ̂ŁAœWJ\n");
			//DMA]̂ŃtbV
			DC_FlushRange(*resFile,(*resFile)->fileSize);
			// ftHg̏֐R[ăZbgAbv
			status = NNS_G3dResDefaultSetup(*resFile);
			NNS_G3D_ASSERTMSG(status, "NNS_G3dResDefaultSetup failed");
		}
	}
    
    // G3D: f̎擾
    // nsbmd̓f𕡐܂ނƂł̂ŁACfbNX(fP̏ꍇ0)
    // w肵ĂP̃fւ̃|C^擾B
    // --------------------------------------------------------------------
    *model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(*resFile), 0);
}

//\[Xmۍςݗp
void simple_LoadG3DModelAlrady(NNSG3dResMdl** model, NNSG3dResFileHeader** resFile)
{
    NNSG3dResTex*        texture = NULL;
    BOOL status;

	// eNX`VramɓWJĂȂ`FbN
	texture = NNS_G3dGetTex(*resFile);	// eNX`\[X擾
	if(texture != NULL){
		if(TexKeyLive(texture) == FALSE){	// eNX`VramɓWJĂȂ`FbN
			OS_Printf("OɃeNX`WJĂ̂ŁAeNX`uq`lɓWJ܂\n");
			//DMA]̂ŃtbV
			DC_FlushRange(*resFile,(*resFile)->fileSize);
			// ftHg̏֐R[ăZbgAbv
			status = NNS_G3dResDefaultSetup(*resFile);
			NNS_G3D_ASSERTMSG(status, "NNS_G3dResDefaultSetup failed");
		}
	}
    
    // G3D: f̎擾
    // nsbmd̓f𕡐܂ނƂł̂ŁACfbNX(fP̏ꍇ0)
    // w肵ĂP̃fւ̃|C^擾B
    // --------------------------------------------------------------------
    *model = NNS_G3dGetMdlByIdx(NNS_G3dGetMdlSet(*resFile), 0);
}

//------------------------------------------------------------------
//                      RcIuWFNgZbg֐
//------------------------------------------------------------------

void simple_3DModelSet
	(const u8 mode,
	 const char* path,NNSG3dRenderObj* object_p,
	 NNSG3dResMdl** model, NNSG3dResFileHeader** resFile) 
{
	simple_LoadG3DModel(mode,path,model,resFile);
	SDK_ASSERTMSG(model, "load failed");
	NNS_G3dRenderObjInit(object_p, *model);
}


void simple_3DModelSetResFileAlready
	(NNSG3dRenderObj* object_p,
	 NNSG3dResMdl** model, NNSG3dResFileHeader** resFile) 
{
	simple_LoadG3DModelAlrady(model,resFile);
	GF_ASSERT(model&&"load failed");
	SDK_ASSERTMSG(model, "load failed");
	NNS_G3dRenderObjInit(object_p, *model);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`L[UĂ邩`FbN
 *
 *@param	pTex		eNX`\[X|C^
 *	
 *@return	bool		true	UĂ
 *						false	UĂȂ
 *
 */
//-----------------------------------------------------------------------------
BOOL TexKeyLive( NNSG3dResTex* pTex )
{
	// ʂ̃eNX`4*4eNZkeNX`
	// VramɓWJĂ邩`FbN
	if((pTex->texInfo.flag & NNS_G3D_RESTEX_LOADED) ||
	   (pTex->tex4x4Info.flag & NNS_G3D_RESTEX4x4_LOADED)){
		return TRUE;
	}
	
	return FALSE;
}

//------------------------------------------------------------------
//                      Rcaf`֐
//------------------------------------------------------------------
void simple_3DModelDraw
(NNSG3dRenderObj* object_p,VecFx32* trans_p,MtxFx33* rot_p,VecFx32* scale_p)
{
#ifdef DEBUG_3DDRAW_COUNT

	DebugDrawCount.VertexNum  += object_p->resMdl->info.numVertex;		//fOf[^\[X璸_擾đ
	DebugDrawCount.PolygonNum += object_p->resMdl->info.numPolygon;		//							  |S
	DebugDrawCount.DrawNum++;											//̊֐Ăяo񐔂𑫂

#endif// DEBUG_3DDRAW_COUNT

	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(trans_p);
	// pxݒ
	NNS_G3dGlbSetBaseRot(rot_p);
	// XP[ݒ
	NNS_G3dGlbSetBaseScale(scale_p);

	NNS_G3dGlbFlush();
	NNS_G3dDraw(object_p);
    
    NNS_G3dGeFlushBuffer();
}

//------------------------------------------------------------------
//                      Rcaf`֐
//------------------------------------------------------------------
void simple_3DModelDraw_1mat1shape
(NNSG3dRenderObj* object_p,VecFx32* trans_p,MtxFx33* rot_p,VecFx32* scale_p)
{
#ifdef DEBUG_3DDRAW_COUNT

	DebugDrawCount.VertexNum  += object_p->resMdl->info.numVertex;		//fOf[^\[X璸_擾đ
	DebugDrawCount.PolygonNum += object_p->resMdl->info.numPolygon;		//							  |S
	DebugDrawCount.DrawNum++;											//̊֐Ăяo񐔂𑫂

#endif// DEBUG_3DDRAW_COUNT

	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(trans_p);
	// pxݒ
	NNS_G3dGlbSetBaseRot(rot_p);
	// XP[ݒ
	NNS_G3dGlbSetBaseScale(scale_p);

	NNS_G3dGlbFlush();
    
    NNS_G3dDraw1Mat1Shp(object_p->resMdl,0,0,TRUE);
    
    NNS_G3dGeFlushBuffer();
}

//------------------------------------------------------------------
//                      Rcaf`֐(gX[ĝݔf)
//------------------------------------------------------------------
void simple_3DModelDrawOnlyTrans
(NNSG3dRenderObj* object_p,VecFx32* trans_p)
{
#ifdef DEBUG_3DDRAW_COUNT

	DebugDrawCount.VertexNum  += object_p->resMdl->info.numVertex;		//fOf[^\[X璸_擾đ
	DebugDrawCount.PolygonNum += object_p->resMdl->info.numPolygon;		//							  |S
	DebugDrawCount.DrawNum++;											//̊֐Ăяo񐔂𑫂

#endif// DEBUG_3DDRAW_COUNT

	// ʒuݒ
	NNS_G3dGlbSetBaseTrans(trans_p);

	NNS_G3dGlbFlush();
	NNS_G3dDraw(object_p);
	//NNS_G3dGeFlushBuffer();
}
#ifdef DEBUG_3DDRAW_COUNT

//------------------------------------------------------------------
//                  3D`̂߂ɒׂlޔ
//------------------------------------------------------------------
void simple_3DDrawPolygonCountUp(void)
{
	DebugDrawCount.NNS_AddVertexNum  = DebugDrawCount.VertexNum;
	DebugDrawCount.NNS_AddPolygonNum = DebugDrawCount.PolygonNum;
	DebugDrawCount.NNS_AddDrawNum       = DebugDrawCount.DrawNum;

	DebugDrawCount.VertexNum  = 0;
	DebugDrawCount.PolygonNum = 0;
	DebugDrawCount.DrawNum    = 0;
}

//---------NITROSYSTEMɓn|S̐Ԃ-----------
int simple_3DDrawPolygonGet(void)
{
	return DebugDrawCount.NNS_AddPolygonNum;
}
//---------NITROSYSTEMɓn_̐Ԃ-----------
int simple_3DDrawVertexGet(void)
{
	return DebugDrawCount.NNS_AddVertexNum;
} 
//---------NITROSYSTEM|S`悵񐔂Ԃ-----------
int simple_3DDrawNumGet(void)
{
	return DebugDrawCount.NNS_AddDrawNum;
} 

//==============================================================================
/**
 * Nhuq`l}l[W[ƃpbg}l[W[̃|C^ۑ
 *
 * @param   texp		Nhuq`l}l[W[
 * @param   palp		pbg}l[W[
 *
 * @retval  none		
 */
//==============================================================================
void simple_3DVramManPSet(NNSiGfdLnkVramBlock *texp, NNSiGfdLnkVramBlock *palp)
{
	DebugDrawCount.texture_p = texp;
	DebugDrawCount.pal_p     = palp;
}


//==============================================================================
/**
 * VRAMւ̃eNX`]Ԃ擾
 *
 * @param   none		
 *
 * @retval  int		gpĂuq`le
 */
//==============================================================================
int  simple_3DVramTexSizeGet(void)
{
	int size = 0;
	int i;
	
	NNSiGfdLnkVramBlock *tex = DebugDrawCount.texture_p;
	
	
	for(i=0;i<TEX_BLOCK_SIZE;i++){
		//NhVRAM}l[W[̐擪T
		if((tex->pBlkPrev==0 && tex->pBlkNext!=0) || (tex->pBlkPrev==0 && tex->pBlkNext==0)){		
			break;
		}
		tex++;
	}

	while(tex->pBlkNext!=0){	// N葫Ď֓nĂ
		size += tex->szByte;
		tex = (NNSiGfdLnkVramBlock *)tex->pBlkNext;
	}
	size += tex->szByte;		//Ō̃NVRAM]

	// VRAM}l[W[ۑĂ̂́ugpĂȂʁvȂ̂őʂĕԂ
	return (TEX_BLOCK_SIZE*1024)-size;	
}


//==============================================================================
/**
 * NhPAL}l[W[̓]Ԃ擾
 *
 * @param   none		
 *
 * @retval  int		NhPAL}l[W[̓]oCg
 */
//==============================================================================
int  simple_3DVramPalSizeGet(void)
{
	int size = 0;
	int i;
	
	NNSiGfdLnkVramBlock *tex = DebugDrawCount.pal_p;
	
	
	for(i=0;i<PLTT_BLOCK_SIZE;i++){
		//NhPALL}l[W[̐擪T
		if((tex->pBlkPrev==0 && tex->pBlkNext!=0) || (tex->pBlkPrev==0 && tex->pBlkNext==0)){		
			break;
		}
		tex++;
	}

	while(tex->pBlkNext!=0){	// N葫Ď֓nĂ
		size += tex->szByte;
		tex = (NNSiGfdLnkVramBlock *)tex->pBlkNext;
	}
	size += tex->szByte;		//Ō̃NVRAM]

	// PAL}l[W[ۑĂ̂́ugpĂȂʁvȂ̂őʂĕԂ
	return 0x8000-size;	
}
#endif //DEBUG_3DDRAW_COUNT

//------------------------------------------------------------------
//                      Rcaf֐
//------------------------------------------------------------------
static void * pal_mem = NULL;
static void * tex_mem = NULL;



void simple_3DBGInit(const u8 inMode)
{
	// NitroSystem:RcGW̏
	NNS_G3dInit();
	// }gNXX^bN̏
    G3X_InitMtxStack();

	// Rcgpʂ̐ݒ(\vCIeB[)
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
    G2_SetBG0Priority(1);

	// e`惂[h̐ݒ(VF[hA`GCAX)
    G3X_SetShading(GX_SHADING_TOON);
    G3X_AntiAlias(TRUE);
    //G2_BlendNone(); 
	G3X_AlphaTest(FALSE, 0);	// At@eXg@@It
	G3X_AlphaBlend(TRUE);		// At@uh@I

	// NAJ[̐ݒ
    G3X_SetClearColor(GX_RGB(0, 0, 0),	// clear color
                      0,				// clear alpha
                      0x7fff,			// clear depth
                      63,				// clear polygon ID
                      FALSE				// fog
                      );

	// WIgGWNKĂ΂Ȃ΂ȂȂ
    G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_W);

	// r[|[g̐ݒ
    G3_ViewPort(0, 0, 255, 191);
#ifdef LINK_VRAM_MANAGER
	{
		int	pal_size;
		int	tex_size;

		pal_size = NNS_GfdGetLnkPlttVramManagerWorkSize( PLTT_BLOCK_SIZE );
#ifdef LINKED_VRAM_MANAGER_SIZE_PRINT_ON		
		OS_Printf("LINKED_VRAM_MNG_PlttWorkSize:%x\n",pal_size);
#endif
		pal_mem = sys_AllocMemory( inMode, pal_size );

		tex_size = NNS_GfdGetLnkTexVramManagerWorkSize( TEX_BLOCK_SIZE );
#ifdef LINKED_VRAM_MANAGER_SIZE_PRINT_ON
		OS_Printf("LINKED_VRAM_MNG_TexWorkSize:%x\n",tex_size);
#endif		
		tex_mem = sys_AllocMemory( inMode, tex_size );
		
		// }l[WeNX`C[WXbgwXbgǗł悤ɂ
		// ftHg}l[WɂB
		NNS_GfdInitLnkTexVramManager(0x40000,0,tex_mem,tex_size,TRUE);
		
		// }l[Wpbg32KBǗł悤ɂ
		// ftHg}l[WɂB
		NNS_GfdInitLnkPlttVramManager(0x8000,pal_mem,pal_size,TRUE);

#ifdef DEBUG_3DDRAW_COUNT
		simple_3DVramManPSet(tex_mem, pal_mem);
#endif
	}
#else
	// }l[WeNX`C[WXbgwXbgǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmTexVramManager(2, TRUE);
		
	// }l[Wpbg32KBǗł悤ɂ
	// ftHg}l[WɂB
	NNS_GfdInitFrmPlttVramManager(0x8000, TRUE);
#endif
}

void simple_3DBGExit(void)
{
	sys_FreeMemoryEz( pal_mem );
	sys_FreeMemoryEz( tex_mem );
}

BOOL BindTexture(void* pResData, NNSG3dResTex* pTex)
{
	//oCh
	NNSG3dResMdlSet* mdlSet = NNS_G3dGetMdlSet((NNSG3dResFileHeader*) pResData);
	NNS_G3D_NULL_ASSERT(mdlSet);
	if (pTex){
		BOOL rc;
		// fZbg̃oCh
		rc = NNS_G3dBindMdlSet(mdlSet, pTex);
#ifdef PN_DEBUG		
		if (!rc){
			OS_Printf("eNX`oChɎs\n");
		}
#endif	
#ifdef TEXTURE_BIND_PRINT_ON		
		OS_Printf("TextureBind!!\n");
#endif		
		return TRUE;
	}
	return FALSE;
}

//eNX`VRAMւ̃[h
BOOL LoadVRAMTexture(NNSG3dResTex* tex)
{
	if(tex == NULL){
		return FALSE;
	}
	
	tex->texInfo.vramKey = 0;
	{
        u32 szTex, szTex4x4, szPltt;
        BOOL sucTex    = TRUE;
        BOOL sucTex4x4 = TRUE;
        BOOL sucPltt   = TRUE;
        NNSG3dTexKey keyTex;
        NNSG3dTexKey keyTex4x4;
        NNSG3dPlttKey keyPltt;

		if (tex){
			// KvȃTCY擾
            szTex    = NNS_G3dTexGetRequiredSize(tex);
            szTex4x4 = NNS_G3dTex4x4GetRequiredSize(tex);
            szPltt   = NNS_G3dPlttGetRequiredSize(tex);

            if (szTex > 0){
				// ݂΃eNX`C[WXbgɊm
                keyTex = NNS_GfdAllocTexVram(szTex, FALSE, 0);
                if (keyTex == NNS_GFD_ALLOC_ERROR_TEXKEY){
                    sucTex = FALSE;
                }
            }
            else{
				keyTex = 0;
            }

			if (szTex4x4 > 0){
				// ݂΃eNX`C[WXbgɊm
                keyTex4x4 = NNS_GfdAllocTexVram(szTex4x4, TRUE, 0);
                if (keyTex4x4 == NNS_GFD_ALLOC_ERROR_TEXKEY){
					sucTex4x4 = FALSE;
                }
            }
            else{
				keyTex4x4 = 0;
            }

            if (szPltt > 0){
                // ݂΃eNX`pbgXbgɊm
                keyPltt = 
                    NNS_GfdAllocPlttVram(szPltt,
                                        tex->tex4x4Info.flag & NNS_G3D_RESPLTT_USEPLTT4,
                                        0);
                if (keyPltt == NNS_GFD_ALLOC_ERROR_PLTTKEY){
                    sucPltt = FALSE;
                }
            }
            else{
			     keyPltt = 0;
            }

            if (!sucTex){
                // s̃[obN
                int status;

				OS_Printf("eNX`擾s%d/%d\n",szTex,simple_3DVramTexSizeGet());

				status = NNS_GfdFreeTexVram(keyTex);
                NNS_G3D_ASSERTMSG(!status, "NNS_GfdFreeTexVram failed");
				GF_ASSERT(!status&&"NNS_GfdFreeTexVram failed");
				
                return FALSE;
            }
			if (!sucTex4x4){
                // s̃[obN
                int status;

                status = NNS_GfdFreeTexVram(keyTex4x4);
                NNS_G3D_ASSERTMSG(!status, "NNS_GfdFreeTexVram failed");
				GF_ASSERT(!status&&"NNS_GfdFree4x4TexVram failed");
				
                return FALSE;
            }
			if (!sucPltt){
                // s̃[obN
                int status;

                status = NNS_GfdFreePlttVram(keyPltt);
                NNS_G3D_ASSERTMSG(!status, "NNS_GfdFreePlttVram failed");
				GF_ASSERT(!status&&"NNS_GfdFreePlttVram failed");

                return FALSE;
            }

            // L[̃ATC
            NNS_G3dTexSetTexKey(tex, keyTex, keyTex4x4);
            NNS_G3dPlttSetPlttKey(tex, keyPltt);

			//DMA]̂ŃtbV
			DC_FlushRange( tex, tex->header.size );
            // VRAMւ̃[h
            NNS_G3dTexLoad(tex, TRUE);
            NNS_G3dPlttLoad(tex, TRUE);
        }
		
    }
    return TRUE;
}

//==============================================================================
/**
 * 3D֘Ap[^̐ݒ
 *
 * @param   inParam		ZbgAbvp[^		
 *
 * @retval  none		
 */
//==============================================================================
void simple_Setup3DParams(const G3D_SETUP_PARAM *inParam)
{
	// NitroSystem:RcGW̏
	NNS_G3dInit();
	// }gNXX^bN̏
    G3X_InitMtxStack();

	// Rcgpʂ̐ݒ(\vCIeB[)
	GF_Disp_GX_VisibleControl( GX_PLANEMASK_BG0, VISIBLE_ON );
	GF_ASSERT(inParam->Priority<=3&&"ls");
    G2_SetBG0Priority(inParam->Priority);

	// e`惂[h̐ݒ(VF[hA`GCAX)
    G3X_SetShading(inParam->ShadeMode);					//VF[fBO
    G3X_AntiAlias(inParam->AntiAlias);					//A`GCAX
    //G2_BlendNone(); 
	G3X_AlphaTest(inParam->AlphaTest, inParam->Ref);	// At@eXg
	G3X_AlphaBlend(inParam->AlphaBlend);				// At@uh

	{
		const G3D_CLEAR_COLOR *col;
		col = &(inParam->ClearColor);
		// NAJ[̐ݒ
		G3X_SetClearColor(col->RGB,	// clear color
			              col->Alpha,				// clear alpha
				          col->Depth,			// clear depth
					      col->PolygonID,				// clear polygon ID
						  col->Fog				// fog
						 );
	}

	// WIgGWNKĂ΂Ȃ΂ȂȂ
    G3_SwapBuffers(GX_SORTMODE_AUTO, GX_BUFFERMODE_W);

	// r[|[g̐ݒ
    G3_ViewPort(0, 0, 255, 191);
}

//==============================================================================
/**
 * VRAM}l[W[̐ݒ
 *
 * @param   inParam		ZbgAbvp[^		
 *
 * @retval  none		
 */
//==============================================================================
VRAM_MANAGER_MEM_PTR simple_SetupVRAMManager(const VRAM_MAN_PARAM *inManagerParam, const int inHeapID)
{
	VRAM_MANAGER_MEM_PTR ptr;
	if (inManagerParam->Type == LINKED_VRAM_MANAGER){
		int	pal_size;
		int	tex_size;

		pal_size = NNS_GfdGetLnkPlttVramManagerWorkSize( PLTT_BLOCK_SIZE );
#ifdef LINKED_VRAM_MANAGER_SIZE_PRINT_ON		
		OS_Printf("LINKED_VRAM_MNG_PlttWorkSize:%x\n",pal_size);
#endif

		tex_size = NNS_GfdGetLnkTexVramManagerWorkSize( TEX_BLOCK_SIZE );
#ifdef LINKED_VRAM_MANAGER_SIZE_PRINT_ON
		OS_Printf("LINKED_VRAM_MNG_TexWorkSize:%x\n",tex_size);
#endif		
		
		ptr = AllocVramManegerMem(	pal_size,
									tex_size,
									inHeapID	);
		
		// }l[WeNX`C[WXbgwXbgǗł悤ɂ
		// ftHg}l[WɂB
		NNS_GfdInitLnkTexVramManager(inManagerParam->TexSzByte,inManagerParam->TexSzByteFor4x4,
										ptr->TexMem,tex_size,TRUE);
		
		// }l[Wpbg32KBǗł悤ɂ
		// ftHg}l[WɂB
		NNS_GfdInitLnkPlttVramManager(inManagerParam->PalSzByte,ptr->PalMem,pal_size,TRUE);

#ifdef DEBUG_3DDRAW_COUNT
		simple_3DVramManPSet(ptr->TexMem, ptr->PalMem);
#endif
	}else if (inManagerParam->Type == FRM_VRAM_MANAGER){
		// }l[WeNX`C[WXbgwXbgǗł悤ɂ
		// ftHg}l[WɂB
		NNS_GfdInitFrmTexVramManager(inManagerParam->TexSlot, TRUE);
		
		// }l[Wpbg32KBǗł悤ɂ
		// ftHg}l[WɂB
		NNS_GfdInitFrmPlttVramManager(inManagerParam->PalSzByte, TRUE);
		ptr = NULL;
	}else{
		GF_ASSERT(0&&"YVRAM}l[W܂");
	}

	return ptr;
}

//==============================================================================
/**
 * VRAM}l[W[̉
 *
 * @param   inParam		ZbgAbvp[^		
 *
 * @retval  none		
 */
//==============================================================================
void simple_FreeVRAMManager(VRAM_MANAGER_MEM_PTR *ptr)
{
	if ((*ptr) != NULL){
		FreeVramManegerMem(ptr);
	}
}

//==============================================================================
/**
 * VRAM}l[W[̐ݒ
 *
 * @param   inPalSize		pbgTCY
 * @param   inTexSize		eNX`TCY
 * @param   inHeapID		q[vID
 *
 * @retval  VRAM_MANAGER_MEM_PTR	mۂ|C^
 */
//==============================================================================
static VRAM_MANAGER_MEM_PTR AllocVramManegerMem(const int inPalSize,
												const int inTexSize,
												const int inHeapID)
{
	VRAM_MANAGER_MEM_PTR ptr;

	ptr = sys_AllocMemory( inHeapID, sizeof(VRAM_MANAGER_MEM) );
	ptr->PalMem = sys_AllocMemory( inHeapID, inPalSize );
	ptr->TexMem = sys_AllocMemory( inHeapID, inTexSize );

	return ptr;
}

//==============================================================================
/**
 * VRAM}l[W[̐ݒ
 *
 * @param   inPalSize		pbgTCY
 * @param   inTexSize		eNX`TCY
 * @param   inHeapID		q[vID
 *
 * @retval  VRAM_MANAGER_MEM_PTR	mۂ|C^
 */
//==============================================================================
static void FreeVramManegerMem(VRAM_MANAGER_MEM_PTR *ptr)
{
	sys_FreeMemoryEz((*ptr)->PalMem);
	sys_FreeMemoryEz((*ptr)->TexMem);
	sys_FreeMemoryEz(*ptr);
	*ptr = NULL;
}
