//============================================================================================
/**
 * @file	sleep.c
 * @brief	X[v[hݒ
 * @author	Hiroyuki Nakamura
 * @date	2005.02.28
 */
//============================================================================================
#define	SLEEP_H_GLOBAL

#include "system.h"
#include "standard.h"
#include "tcb.h"
#include "gflib_os_print.h"

#include "sleep.h"


//============================================================================================
//	V{`
//============================================================================================


//============================================================================================
//	vg^Cv錾
//============================================================================================
static void CoverCloseCheckTask( TCB_PTR _tcb, void * work );


//============================================================================================
//	ݒ
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * X[vf[^̈mہA
 *
 * @param	heap	q[vID
 *
 * @return	X[vf[^̈
 */
//--------------------------------------------------------------------------------------------
GF_SLEEP_SYS * GF_SleepSystemInit( u32 heap )
{
	GF_SLEEP_SYS * dat = (GF_SLEEP_SYS *)sys_AllocMemory( heap, sizeof(GF_SLEEP_SYS) );

#ifdef	OSP_ERR_SLEEPBUF_GET	// X[vp̃obt@mێs
	if( dat == NULL ){
		OS_Printf( "ERROR : GF_SleepSystemInit\n" );
		return;
	}
#endif	// OSP_ERR_SLEEPBUF_GET	// X[vp̃obt@mێs

	memset( dat, 0, sizeof(GF_SLEEP_SYS) );
	dat->heap = (u16)heap;

	return dat;
}

//--------------------------------------------------------------------------------------------
/**
 * VXe
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_SleepSystemDelete( GF_SLEEP_SYS * dat )
{
#ifdef	OSP_ERR_SLEEP_DEL		// X[vp̃obt@mۂĂȂ
	if( dat == NULL ){
		OS_Printf( "ERROR : GF_SleepSystemDelete\n" );
		return;
	}
#endif	// OSP_ERR_SLEEP_DEL

	GF_SleepCallBackDel( dat, GF_SLEEP_CB_BEFORE );
	GF_SleepCallBackDel( dat, GF_SLEEP_CB_AFTER );
	sys_FreeMemory( dat->heap, dat );
}

//--------------------------------------------------------------------------------------------
/**
 * X[ṽgK[ݒ
 *
 * @param	dat		X[vf[^
 * @param	trg		X[vԂ̕Av
 * @param	logic	L[݂ŕAꍇ̃L[̑gݍ킹_
 * @param	pat		L[݂ŕAꍇ̃L[
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_SleepTriggerSet( GF_SLEEP_SYS * dat, PMWakeUpTrigger trg, PMLogic logic, u16 pat )
{
	dat->trigger = trg;
	dat->logic = logic;
	dat->keyPattern = pat;
}

//--------------------------------------------------------------------------------------------
/**
 * X[vf[^ݒ
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 *
 * @li	dat->hold : GF_SLEEP_MODE = X[v
 * @li	X[vsɂɂGF_SleepModeSet(GF_SLEEP_HOLD)ĂԂ
 */
//--------------------------------------------------------------------------------------------
void GF_SleepSystemSetAll( GF_SLEEP_SYS * dat )
{
	u16	init;

#ifdef	OSP_ERR_SLEEP_SET		// X[vݒ莸s
	if( dat == NULL ){
		OS_Printf( "ERROR : GF_SleepSystemSetAll\n" );
		return;
	}
#endif	// SP_ERR_SLEEP_SET

	init = dat->hold;
	dat->hold = GF_SLEEP_MODE;

	if( dat->b_info.callback != NULL ){
		GF_SleepCallBackAdd( dat, &dat->b_info, GF_SLEEP_CB_BEFORE, GF_SLEEP_CB_BEFORE );
	}
	if( dat->a_info.callback != NULL ){
		GF_SleepCallBackAdd( dat, &dat->a_info, GF_SLEEP_CB_AFTER, GF_SLEEP_CB_BEFORE );
	}

	if( init == GF_SLEEP_MODE ){
		GF_GoSleepMode( dat );
	}
}

//--------------------------------------------------------------------------------------------
/**
 * ؂ւ
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_GoSleepMode( GF_SLEEP_SYS * dat )
{
	if( dat->hold == GF_SLEEP_HOLD ){ return; }
	PM_GoSleepMode( dat->trigger, dat->logic, dat->keyPattern );
}

//--------------------------------------------------------------------------------------------
/**
 * ؂ւ
 *
 * @param	dat		X[vf[^
 * @param	flg		GF_SLEEP_MODE = , GF_SLEEP_HOLD = s
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_SleepModeSet( GF_SLEEP_SYS * dat, u8 flg )
{
	dat->hold = flg;
}


//============================================================================================
//	R[obN
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * R[obNZbg
 *
 * @param	dat		X[vf[^
 * @param	info	R[obN
 * @param	type	ǉ^Cv ( GF_SLEEP_CB_BEFORE = ڍs, GF_SLEEP_CB_AFTER = A )
 * @param	mode	ǉ[h ( GF_SLEEP_CB_BEFORE = 擪, GF_SLEEP_CB_AFTER =  )
 *
 * @return	none
 *
 * @li	ł͕o^͏o܂
 */
//--------------------------------------------------------------------------------------------
void GF_SleepCallBackAdd( GF_SLEEP_SYS * dat, PMSleepCallbackInfo * info, u8 type, u8 mode )
{
	u8	i;

	if( type == GF_SLEEP_CB_BEFORE ){
#ifdef	OSP_ERR_SLEEP_CALLBACK_SET		// R[obNݒ莸s
		if( dat->b_info.callback != NULL ){
			OS_Printf( "ERROR : GF_SleepCallBackAdd( GF_SLEEP_CB_BEFORE )\n" );
			return;
		}
#endif	// OSP_ERR_SLEEP_CALLBACK_SET
		dat->b_info = *info;

		if( mode == GF_SLEEP_CB_BEFORE ){
			PM_PrependPreSleepCallback( &dat->b_info );
		}else{
			PM_AppendPreSleepCallback( &dat->b_info );
		}
	}else{
#ifdef	OSP_ERR_SLEEP_CALLBACK_SET		// R[obNݒ莸s
		if( dat->a_info.callback != NULL ){
			OS_Printf( "ERROR : GF_SleepCallBackAdd( GF_SLEEP_CB_AFTER )\n" );
			return;
		}
#endif	// OSP_ERR_SLEEP_CALLBACK_SET
		dat->a_info = *info;

		if( mode == GF_SLEEP_CB_BEFORE ){
			PM_PrependPostSleepCallback( &dat->a_info );
		}else{
			PM_AppendPostSleepCallback( &dat->a_info );
		}
	}
}

//--------------------------------------------------------------------------------------------
/**
 * R[obN폜
 *
 * @param	dat		X[vf[^
 * @param	id		폜^Cv ( GF_SLEEP_CB_BEFORE = ڍs, GF_SLEEP_CB_AFTER = A )
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_SleepCallBackDel( GF_SLEEP_SYS * dat, u8 id )
{
	if( id == GF_SLEEP_CB_BEFORE ){
		if( dat->b_info.callback == NULL ){ return; }
		PM_DeletePreSleepCallback( &dat->b_info );
	}else{
		if( dat->a_info.callback == NULL ){ return; }
		PM_DeletePostSleepCallback( &dat->a_info );
	}
}


//============================================================================================
//	{̂̊JŃX[v
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * {̂̊JŃX[v^XNZbg
 *
 * @param	dat		X[vf[^
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void GF_SleepCoverCloseAdd( GF_SLEEP_SYS * dat )
{
/*
	GF_SLEEP_SYS	dat = {
		{NULL,NULL,NULL}, {NULL,NULL,NULL}, PM_TRIGGER_COVER_OPEN, 0, 0, 1
	};

	GF_SleepSystemSetAll( &dat );
*/
	GF_SleepTriggerSet( dat, PM_TRIGGER_COVER_OPEN, 0, 0 );
	TCB_Add( CoverCloseCheckTask, dat, 0 );
}

//--------------------------------------------------------------------------------------------
/**
 * {̂̊JŃX[v^XN
 *
 * @param	none
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
static void CoverCloseCheckTask( TCB_PTR _tcb, void * work )
{
	if( PAD_DetectFold() == FALSE ){ return; }

	{
		GF_SLEEP_SYS * dat = (GF_SLEEP_SYS *)work;
		GF_GoSleepMode( dat );
	}
}
