//============================================================================================
/**
 * @file	strbuf.c
 * @brief	ėpobt@^IuWFNg
 * @author	taya
 * @date	2005.11.02
 */
//============================================================================================
#include <stdlib.h>
#include <string.h>
#include "gflib/assert.h"
#include "gflib/msg_print.h"
#include "gflib/strcode.h"
#include "gflib/heapsys.h"

#include "gflib/strbuf_family.h"


//--------------------------------------------------------------
/**
 * 萔                                                      
 */
//--------------------------------------------------------------
#define STRBUF_MAGIC_NUMBER		(0xb6f8d2ec)
#define STRBUF_MAX_SIZE			(1024)

//--------------------------------------------------------------
/**
 * obt@IuWFNg^`
 */
//--------------------------------------------------------------
struct _STRBUF {
	u16  size;			///< zTCY
	u16  strlen;		///< 񒷁iEOM܂܂Ȃj
	u32  magicNumber;	///< ɏς݂ł邱Ƃ`FbN邽߂̃io[

	STRCODE  buffer[1];	///< z{
};

/** wb_TCY */
#define STRBUF_HEADER_SIZE	(sizeof(STRBUF) - sizeof(STRCODE))

//--------------------------------------------------------------
/**
 * Ԉُ`FbN}N
 */
//--------------------------------------------------------------
#define  STRBUF_CHECK_STATE(pbuf)	{\
	GF_ASSERT((pbuf)!=NULL)	\
	GF_ASSERT((pbuf)->magicNumber == STRBUF_MAGIC_NUMBER);	\
}



//==============================================================================================
//==============================================================================================

//------------------------------------------------------------------
/**
 * obt@IuWFNg쐬
 *
 * @param   size		i[ł镶iEOM܂ށj
 * @param   heapID		쐬q[vID
 *
 * @retval  STRBUF*		IuWFNgւ̃|C^
 */
//------------------------------------------------------------------
STRBUF* STRBUF_Create( u32 size, u32 heapID )
{
	STRBUF* strbuf;

	strbuf = sys_AllocMemory( heapID, STRBUF_HEADER_SIZE + sizeof(STRCODE)*size );

	if( strbuf )
	{
		strbuf->magicNumber = STRBUF_MAGIC_NUMBER;
		strbuf->size = size;
		strbuf->strlen = 0;
		strbuf->buffer[0] = EOM_;
	}

	return strbuf;
}
//------------------------------------------------------------------
/**
 * obt@IuWFNg폜
 *
 * @param   strbuf		IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
void STRBUF_Delete( STRBUF* strbuf )
{
	STRBUF_CHECK_STATE(strbuf);

	// Free ɓAhXŌĂяoMagicNumber̂܂܎cĂ肷̂
	strbuf->magicNumber = STRBUF_MAGIC_NUMBER+1;

	sys_FreeMemoryEz( strbuf );
}
//------------------------------------------------------------------
/**
 * eNAċ󕶎ɂ
 * iCreate ̓NAĂ̂ŌĂԕKv͖j
 *
 * @param   strbuf		IuWFNgւ̃|C^
 *
 */
//------------------------------------------------------------------
void STRBUF_Clear( STRBUF* strbuf )
{
	STRBUF_CHECK_STATE(strbuf);

	strbuf->strlen = 0;
	strbuf->buffer[0] = EOM_;
}

//------------------------------------------------------------------
/**
 * obt@Ԃ̕Rs[
 *
 * @param   dst		Rs[obt@IuWFNg
 * @param   src		Rs[obt@IuWFNg
 *
 */
//------------------------------------------------------------------
void STRBUF_Copy( STRBUF* dst, const STRBUF* src )
{
	STRBUF_CHECK_STATE( dst );
	STRBUF_CHECK_STATE( src );

	if( dst->size > src->strlen )
	{
		memcpy( dst->buffer, src->buffer, (src->strlen+1)*sizeof(STRCODE) );
		dst->strlen = src->strlen;
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow : dstsize=%d,  srclen=%d", dst->size, src->strlen);
}

//------------------------------------------------------------------
/**
 * ẽobt@𕡐
 *
 * @param   strbuf		̃obt@IuWFNg
 *
 * @retval  STRBUF*		ꂽobt@IuWFNg
 */
//------------------------------------------------------------------
STRBUF* STRBUF_CreateBufferCopy( const STRBUF* origin, u32 heapID )
{
	STRBUF* copy;

	STRBUF_CHECK_STATE( origin );

	copy = STRBUF_Create( origin->strlen+1, heapID );
	if( copy )
	{
		STRBUF_Copy( copy, origin );
	}

	return copy;
}


//------------------------------------------------------------------
/**
 * obt@ɐZbg
 *
 * @param   dst			[out] obt@IuWFNgւ̃|C^
 * @param   number		l
 * @param   keta		ő包
 * @param   dispType	\^Cv
 * @param   codeType	R[h^Cv
 *
 */
//------------------------------------------------------------------
void STRBUF_SetNumber( STRBUF* dst, int number, u32 keta, NUMBER_DISPTYPE dispType, NUMBER_CODETYPE codeType )
{
	static const u32 n_max[] = 
	{
		1,
		10,
		100,
		1000,
		10000,
		100000,
		1000000,
		10000000,
		100000000,
		1000000000,
	};
	static const STRCODE sc_zen[] = {n0_,n1_,n2_,n3_,n4_,n5_,n6_,n7_,n8_,n9_};
	static const STRCODE sc_han[] = {h_n0_,h_n1_,h_n2_,h_n3_,h_n4_,h_n5_,h_n6_,h_n7_,h_n8_,h_n9_};
	int minus;

	STRBUF_CHECK_STATE( dst );

	minus = (number < 0);

	if( dst->size > (keta+minus) )
	{
		u32  num_f, num_i, i;
		const STRCODE* sctbl = (codeType==NUMBER_CODETYPE_ZENKAKU)? sc_zen : sc_han;

		STRBUF_Clear(dst);

		if(minus)
		{
			number *= -1;
			dst->buffer[dst->strlen++] = (codeType==NUMBER_CODETYPE_ZENKAKU)? bou_ : h_bou_;
		}


		for(i=n_max[keta-1]; i>0; i/=10)
		{
			num_i = (u16)( number / i );
			num_f = (u32)( number - ( i * num_i ) );

			if( dispType == NUMBER_DISPTYPE_ZERO )
			{
				dst->buffer[dst->strlen++] = (num_i<10)? sctbl[num_i] : hate_;
			}
			else if( num_i != 0 || i==1 )
			{
				dispType = NUMBER_DISPTYPE_ZERO;
				dst->buffer[dst->strlen++] = (num_i<10)? sctbl[num_i] : hate_;
			}
			else if( dispType == NUMBER_DISPTYPE_SPACE )
			{
				dst->buffer[dst->strlen++] = spc_;
			}

			number = num_f;
		}

		dst->buffer[dst->strlen] = EOM_;
		return;
	}

//	GF_ASSERT_MSG(0, "STRBUF overflow!");
	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, keta=%d", dst->size, keta);
}

//------------------------------------------------------------------
/**
 * r
 *
 * @param   str1		P
 * @param   str2		Q
 *
 * @retval  int			"0 = v"
 * @retval  int			"1 = sv"
 */
//------------------------------------------------------------------
int STRBUF_Compare( const STRBUF* str1, const STRBUF* str2 )
{
	int i;

	for(i=0; str1->buffer[i] == str2->buffer[i]; i++)
	{
		if( str1->buffer[i] == EOM_ )
		{
			return 0;
		}
	}

	return 1;
}

//==============================================================================================
// ̕z舵֐Q
// 𗘗pł郂W[͏o肷
//==============================================================================================

//------------------------------------------------------------------
/**
 * ̕iEOMI[jobt@IuWFNgɃZbg
 *
 * @param   strbuf		[out] obt@IuWFNgւ̃|C^
 * @param   sz			[in]  EOM ŏI镶z
 *
 */
//------------------------------------------------------------------
void STRBUF_SetStringCode( STRBUF* strbuf, const STRCODE* sz )
{
	STRBUF_CHECK_STATE(strbuf);

	strbuf->strlen = 0;
	while( *sz != EOM_ )
	{
		if( strbuf->strlen >= (strbuf->size-1) )
		{
			GF_ASSERT_MSG( 0, "STRBUF overflow: busize=%d", strbuf->size);
			break;
		}
		strbuf->buffer[ strbuf->strlen++ ] = *sz++;
	}

	strbuf->buffer[strbuf->strlen] = EOM_;
}
//------------------------------------------------------------------
/**
 * ̕iwjobt@IuWFNgɃZbg
 *
 * @param   strbuf		[out] obt@IuWFNgւ̃|C^
 * @param   str			[in]  z̐擪|C^
 * @param   len			[in]  Zbg镶iEOM܂ށj
 *
 */
//------------------------------------------------------------------
void STRBUF_SetStringCodeOrderLength( STRBUF* strbuf, const STRCODE* str, u32 len )
{
	STRBUF_CHECK_STATE(strbuf);

	if( len <= strbuf->size )
	{
		u32 i;

		memcpy( strbuf->buffer, str, len*sizeof(STRCODE) );

		for(i=0; i<len; i++)
		{
			if(strbuf->buffer[i] == EOM_)
			{
				break;
			}
		}
		strbuf->strlen = i;

		// EOMtȂ񂾂tĂ
		if( i==len )
		{
			strbuf->buffer[len-1] = EOM_;
		}
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, strlen=%d", strbuf->size, len);
}

//------------------------------------------------------------------
/**
 * obt@琶̕zRs[
 *
 * @param   strbuf		[in]  obt@IuWFNgւ̃|C^
 * @param   ary			[out] Rs[z
 * @param   arysize		[in]  Rs[z̗vf
 *
 */
//------------------------------------------------------------------
void STRBUF_GetStringCode( const STRBUF* strbuf, STRCODE* ary, u32 arysize )
{
	STRBUF_CHECK_STATE(strbuf);

	if( (strbuf->strlen+1) <= arysize )
	{
		memcpy( ary, strbuf->buffer, (strbuf->strlen+1)*sizeof(STRCODE) );
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: strlen=%d, arysize=%d", strbuf->strlen, arysize);
}
//------------------------------------------------------------------
/**
 * obt@IuWFNg镶z̃AhXԂ
 * ̊֐Ăяoӏ͒BԂ񕶎o͌n̂݁B
 *
 * @param   strbuf				[in] obt@IuWFNgւ̃|C^
 *
 * @retval  const STRCODE*		z̃AhX
 */
//------------------------------------------------------------------
const STRCODE* STRBUF_GetStringCodePointer( const STRBUF* strbuf )
{
	STRBUF_CHECK_STATE(strbuf);

	return strbuf->buffer;
}


//==============================================================================================
// ̘As֐Byy gp֎~ zz
// gėǂ̂̓[JCYl񏈗W[̂݁B
//==============================================================================================

//------------------------------------------------------------------
/**
 * A
 *
 * @param   dst		Aobt@IuWFNg
 * @param   src		A镶obt@IuWFNg
 *
 */
//------------------------------------------------------------------
void STRBUF_AddStr( STRBUF* dst, const STRBUF* src )
{
	STRBUF_CHECK_STATE(dst);
	STRBUF_CHECK_STATE(src);

	if( (dst->strlen + src->strlen + 1) <= dst->size )
	{
		memcpy( &(dst->buffer[dst->strlen]), src->buffer, (src->strlen+1)*sizeof(STRCODE) );
		dst->strlen += src->strlen;
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: bufsize=%d, src_len=%d, dst_len=%d", dst->size, src->strlen, dst->strlen);
}

//------------------------------------------------------------------
/**
 * PA
 *
 * @param   dst			Aobt@IuWFNg
 * @param   code		A镶R[h
 *
 */
//------------------------------------------------------------------
void STRBUF_AddChar( STRBUF* dst, STRCODE code )
{
	STRBUF_CHECK_STATE( dst );

	if( (dst->strlen + 1) < dst->size )
	{
		dst->buffer[dst->strlen++] = code;
		dst->buffer[dst->strlen] = EOM_;
		return;
	}

	GF_ASSERT_MSG(0, "STRBUF overflow: busize=%d", dst->size);
}







//==============================================================================================
// fobOp
//==============================================================================================
#ifdef PM_DEBUG

//------------------------------------------------------------------
/**
 * w肳ꂽ|C^STRBUFƂėLȂ̂ł邩`FbN
 *
 * @param   ptr		|C^
 *
 * @retval  BOOL	TRUEŗLł
 */
//------------------------------------------------------------------
BOOL STRBUF_CheckValid(const void* ptr)
{
	return ( (ptr!=NULL) && (((const STRBUF*)ptr)->magicNumber == STRBUF_MAGIC_NUMBER) );
}


#endif
