//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *@file		vram_transfer_anm.c
 *@brief	eNX`p^[Aj[VVram]Aj[Vōs
 *																VXe
 *@author	tomoya takahashi
 *@data		2004.11.08
 *
 *	
 *
 *	pƂ̒
 *	̃VXeVram]}l[W[gpĂ̂ŁA
 *	̃VXegpOVram]}l[W[ĂĂB
 *
 *	
 *	XgɃZbgf[^ɂ
 *		NNSG3dAnmObjFAj[Vf[^Ƃ̃Aj[VgeNX`\[XZbg
 *					@ŃZbg܂BieNX`Vramɓ]Ȃ悤Ɂj
 *					@TexKeyɂ0x00ZbgĂ܂B
 *
 *		NNSG3dResTexFftHg̃r{[hɃZbgĂP̊G̃\[XłB
 *					@VramɊG̃f[^]ĂTexKeyi[ĂĂB
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]
#include "vram_transfer_anm.h"
#include "vram_transfer_manager.h"
#include "system.h"
#include "str_tool.h"
#include "gflib_os_print.h"



//-------------------------------------
//
///@VramAj[VXg\
//
//-------------------------------------
typedef struct _ITP_VRAM_ANM
{
	const TEXANM_DATATBL* cp_anmtbl;// Aj[Vf[^e[u
	const NNSG3dResTex*	cp_tex;		// ]eNX`f[^
	NNSGfdTexKey  texKey;			// eNX`VramKey
	NNSGfdPlttKey plttKey;			// pbgVramKey
	
	u8			  oldTexNum;		// POɓ]eNX`io[
	u8			  oldPlttNum;		// POɓ]pbgio[
	
} ITP_VRAM_ANM;


//-------------------------------------
//
//	VramAj[VVXe\
//
//=====================================
typedef struct _ITP_VRAM_SYS{
	ITP_VRAM_ANM*	pWork;		// VramAj[VXg
	int				WorkNum;	// Xg
} ITP_VRAM_SYS;

//----------------------------------------------------------------------------
/**
 *					vg^Cv錾
 */
//-----------------------------------------------------------------------------
// CŌĂ΂eXg̃f[^ۂɊG]֐
static void ItpVramAnmMainApp( ITP_VRAM_ANM* pItpData, const u16 c_frame );
// ]G̃f[^擾
static void* getGraphicData( ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata );
// ]pbg̃f[^擾
static void* getPalletData( ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata );
// Aj[Vf[^擾
// [N̏
static void cleanItpWork(ITP_VRAM_ANM* work);
// eNX`f[^]
static void trans_tex(ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata);
// pbgf[^]
static void trans_pltt(ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata);

//----------------------------------------------------------------------------
/**
 *					O[oϐ錾
 */
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *
 *@brief	VramAj[VVXeIuWFNg̍쐬
 *
 *@param	WorkNum		쐬[N
 *@param	heap		gpq[v
 *
 *@return	ITP_VRAM_SYS_PTR		VramAj[Vf[^
 */
//-----------------------------------------------------------------------------
ITP_VRAM_SYS_PTR initItpVramAnm(int WorkNum, int heap)
{
	ITP_VRAM_SYS_PTR vl_sys;
	int i;

	// VramAj[VVXef[^쐬
	vl_sys = sys_AllocMemory(heap, sizeof(ITP_VRAM_SYS));

	// [N쐬
	vl_sys->pWork = sys_AllocMemory(heap, sizeof(ITP_VRAM_ANM)*WorkNum);
	vl_sys->WorkNum = WorkNum;
	for(i=0;i<vl_sys->WorkNum;i++){
		cleanItpWork(&vl_sys->pWork[i]);
	}

	return vl_sys;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VramAj[VVXeIuWFNg̔j
 *
 *@param	pDat		VramAj[Vf[^
 *
 *@return	none
 */
//-----------------------------------------------------------------------------
void destItpVramAnm(ITP_VRAM_SYS_PTR pDat)
{
	// Sj
	remItpVramAnmAll(pDat);

	sys_FreeMemoryEz(pDat->pWork);
	sys_FreeMemoryEz(pDat);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VramAj[Vǉ
 *
 *@param	pDat		VramAj[Vf[^
 *@param	cp_anmtbl	Aj[Ve[u
 *@param	cp_tex		]eNX`f[^
 *@param	texKey		eNX`L[
 *@param	plttKey		pbgL[
 *@param	c_frame		݃t[l
 *
 *@return	ITP_VRAM_ANM_PTR	VramAjIuWF
 */
//-----------------------------------------------------------------------------
ITP_VRAM_ANM_PTR addItpVramAnm( ITP_VRAM_SYS_PTR pDat, const TEXANM_DATATBL* cp_anmtbl, const NNSG3dResTex* cp_tex, NNSGfdTexKey texKey, NNSGfdPlttKey plttKey, const fx32 c_frame )
{
	ITP_VRAM_ANM_PTR	p_itp_anm;			// Aj[Vf[^
	u32					pltt_size;			// pbg]s̃`FbN
	int					i;					// [vp
	p_itp_anm = NULL;
	//
	// f[^ݗ̈T
	//
	for(i=0;i<pDat->WorkNum;i++){
		if(pDat->pWork[i].cp_anmtbl == NULL){
			p_itp_anm = &pDat->pWork[i];
			break;
		}
	}

	if(p_itp_anm == NULL){
		return NULL;
	}
	
	// ef[^Zbg
	p_itp_anm->cp_anmtbl= cp_anmtbl;		// Aj[Vf[^
	p_itp_anm->cp_tex	= cp_tex;			// ]eNX`f[^
	p_itp_anm->texKey	= texKey;			// Vram]ŒgeNX`L[
	p_itp_anm->plttKey	= plttKey;			// Vram]ŒgpbgL[
	p_itp_anm->oldTexNum  = -1;				// POɓ]eNX`io[
	p_itp_anm->oldPlttNum = -1;				// POɓ]pbgio[
	// P]
	// (ł́ApbgƃeNX`])
	ItpVramAnmMainApp(p_itp_anm, c_frame >> FX32_SHIFT );

	return p_itp_anm;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	VramAj[V폜
 *
 *@param	pDat	VramAj[Vf[^
 *@param	pAnmObj	폜Aj[ṼAj[VIuWF
 *	
 *@return	none	
 */
//-----------------------------------------------------------------------------
void remItpVramAnm( ITP_VRAM_ANM_PTR pAnmObj )
{
	// ̈폜
	cleanItpWork(pAnmObj);
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	SVramAj[V폜
 *
 *@param	pDat	VramAj[Vf[^
 *	
 *@return	none
 *	
 */
//-----------------------------------------------------------------------------
void remItpVramAnmAll( ITP_VRAM_SYS_PTR pDat )
{
	int i;	

	// SVramAj[Vj
	for(i=0;i<pDat->WorkNum;i++){
		cleanItpWork( (pDat->pWork + i) );
	}
}
	
//----------------------------------------------------------------------------
/**
 *
 *@brief	]s
 *
 *@param	obj		]f[^
 *@param	c_frame	݃t[
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
void transItpVramAnm( ITP_VRAM_ANM_PTR obj, const fx32 c_frame )
{
	u16	frame_16;		// u16^ɂƂ̃t[

	// _ȉ؂̂Ă
	// u16^̃t[l擾
	frame_16 = c_frame >> FX32_SHIFT;	
		
	// ]
	ItpVramAnmMainApp( obj, frame_16 );
}

/*-----------------------------------------------------------------------------
 *			vCx[g֐̎ԕ
 ----------------------------------------------------------------------------*/
// [N̏
static void cleanItpWork(ITP_VRAM_ANM* work)
{
	work->cp_anmtbl		= NULL;
	work->cp_tex		= NULL;
	work->texKey		= 0;
	work->plttKey		= 0;
	work->oldTexNum		= 0;
	work->oldPlttNum	= 0;
}


//----------------------------------------------------------------------------
/**
 *
 *@brief		ۂɓ]s
 *			VramKeÿʒuɍ̊G̃f[^]
 *		@	AnmObj獡̊G̃io[擾
 *		@	Vram]^XNo^
 *
 *@param	pItpDataFVram]Aj[VsAjf[^
 *@param	c_frame	݃t[
 *
 *@return	none
 *
 */
//-----------------------------------------------------------------------------
static void ItpVramAnmMainApp( ITP_VRAM_ANM* pItpData, const u16 c_frame )
{	
	TEXANM_DATA	texdata;	// ̃t[̃eNX`IDƃpbgID


	// ̃Aj[Vf[^擾
	texdata = TEXANM_GetFrameData( pItpData->cp_anmtbl, c_frame );
	
	// ЂƂOɓ]eNX`io[ƈႤ`FbN
	if( pItpData->oldTexNum != texdata.tex_idx )
	{
		trans_tex(pItpData, &texdata);
	}

	// POɓ]pbgio[ƈႤ`FbN
	if( pItpData->oldPlttNum != texdata.pltt_idx )
	{
		trans_pltt(pItpData, &texdata);
	}
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`f[^]
 *
 *@param	pItpData	]f[^
 *@param	cp_texdata	̃eNX`no
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void trans_tex(ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata)
{
	void*		p_buff;				// G̃f[^̃obt@
	//
	// ̊G̃io[AG̃TCY擾
	//
	p_buff = getGraphicData( pItpData, cp_texdata );


	//
	// ]^XNZbg
	//
	AddVramTransferManager(
			NNS_GFD_DST_3D_TEX_VRAM,					// eNX`]
			NNS_GfdGetTexKeyAddr( pItpData->texKey ),	// ]
			p_buff,										// ]f[^
			NNS_GfdGetTexKeySize( pItpData->texKey )	// ]TCY
			);

	// ]eNX`io[ۑ
	pItpData->oldTexNum = cp_texdata->tex_idx;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	pbgf[^]
 *
 *@param	pItpData	]f[^
 *@param	cp_texdata	̃pbgno
 *
 *@return	none
 *
 *
 */
//-----------------------------------------------------------------------------
static void trans_pltt(ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata)
{
	void*		p_buff;				// G̃f[^̃obt@
	
	// ̃pbgf[^擾
	p_buff = getPalletData( pItpData, cp_texdata );

	// ]^XNZbg
	AddVramTransferManager(
			NNS_GFD_DST_3D_TEX_PLTT,					// pbg]
			NNS_GfdGetPlttKeyAddr( pItpData->plttKey ),	// ]
			p_buff,										// ]f[^
			NNS_GfdGetPlttKeySize( pItpData->plttKey )	// ]TCY
			);

	// ]pbgio[ۑ
	pItpData->oldPlttNum = cp_texdata->pltt_idx;
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃t[̊G̃f[^擾
 *
 *@param	pItpDataFAj[Vf[^
 *@param	cp_texdata	̃t[̃eNX`IDƃpbgID
 *
 *@return	]f[^̃obt@
 *
 */
//-----------------------------------------------------------------------------
static void* getGraphicData( ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata )
{
	//
	// ̃t[̊GԖڂ擾AG̑傫
	// G̃f[^̐擪̃ItZbgvZobt@
	// ̃|C^Zbg
	//
	
	//
	// ̃t[̊G̃io[ƊG̃TCY擾
	//
	// ̃eNX`ID̊G̃f[^擾
	const NNSG3dResDictTexData* pData = NNS_G3dGetTexDataByIdx( pItpData->cp_tex, cp_texdata->tex_idx );

	// ItZbgl
	u32 offset = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK);
//	u32 offset = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK) + pItpData->pAnmObj->resTex->texInfo.vramKey;
		
	
	// ރf[^̃|C^
	return (void*)((u8*)pItpData->cp_tex + pItpData->cp_tex->texInfo.ofsTex + (offset << 3) );
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	̃t[̃pbgf[^擾
 *
 *@param	pItpDataFAj[Vf[^
 *@param	cp_texdata	̃t[̃eNX`IDƃpbgID
 *
 *@return	ރf[^̃|C^
 *
 */
//-----------------------------------------------------------------------------
static void* getPalletData( ITP_VRAM_ANM* pItpData, const TEXANM_DATA* cp_texdata )
{
	//
	// ̃t[̃pbgԖڂ擾Apbg̑傫
	// pbg̃f[^̐擪̃ItZbgvZobt@
	// ̃|C^Zbg
	//
	
	//
	// ̃t[̃pbg̃io[擾
	//
	const NNSG3dResDictPlttData* pPlttData = NNS_G3dGetPlttDataByIdx( pItpData->cp_tex, cp_texdata->pltt_idx );
	
	
	//
	// ItZbgl̈ʒũf[^]
	//
	return (void*)((u8*)pItpData->cp_tex + pItpData->cp_tex->plttInfo.ofsPlttData + (pPlttData->offset << 3));
}

//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`\[XƃeNX`hceNZJnAhXm肷
 *
 *@param	inResTexFeNX`\[X
 *@param	inIndex FeNX`hc
 *
 *@return	void*	: AhX
 *
 */
//-----------------------------------------------------------------------------
void* GetTexStartAdr(NNSG3dResTex *inResTex, const u8 inIndex)
{
	u32 offset;
	const NNSG3dResDictTexData* pData = NNS_G3dGetTexDataByIdx( inResTex, inIndex );
	
	if (pData == NULL){
		return NULL;
	}

	// ItZbgl
	offset = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK) + inResTex->texInfo.vramKey;

	return (void*)((u8*)inResTex + inResTex->texInfo.ofsTex + (offset << 3) );
}


//------------------------------------------------------------------
/**
 * eNZJnVRAMAhXm肷邽߂̎Zo֐
 *
 * @param   pData		eNX`AhX̂߂̏
 *
 * @retval  void*		eNX`AhX
 */
//------------------------------------------------------------------
static void* GetTexStartVRAMAdrSub(NNSG3dResTex *inResTex,const NNSG3dResDictTexData* pData)
{
	// ItZbgl
	u32 offset = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEX_ADDR_MASK)<<3;
	offset += NNS_GfdGetTexKeyAddr( inResTex->texInfo.vramKey );
	return (void*)(offset);

}
//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`\[XƃeNX`eNZJnVRAMAhXm肷
 *
 *@param	inResTexFeNX`\[X
 *@param	name    FeNX`
 *
 *@return	void*	: AhX
 *
 */
//-----------------------------------------------------------------------------
void* GetTexStartVRAMAdrByName(NNSG3dResTex *inResTex, const char *name)
{
	NNSG3dResName tmpResName;
	const NNSG3dResDictTexData* pData;

	//eNX`̎̂T[`
	SetResName(&tmpResName,name);	//NNSG3dResNameɕϊ
	pData = NNS_G3dGetTexDataByName( inResTex, &tmpResName );

	if (pData == NULL){
		return NULL;
	}

	//AhXZo
	return GetTexStartVRAMAdrSub(inResTex, pData);
}


//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`\[XƃeNX`hceNZJnVRAMAhXm肷
 *
 *@param	inResTexFeNX`\[X
 *@param	inIndex FeNX`hc
 *
 *@return	void*	: AhX
 *
 */
//-----------------------------------------------------------------------------
void* GetTexStartVRAMAdr(NNSG3dResTex *inResTex, const u8 inIndex)
{
	//eNX`̎̂T[`
	const NNSG3dResDictTexData* pData = NNS_G3dGetTexDataByIdx( inResTex, inIndex );
	if (pData == NULL){
		return NULL;
	}
	//AhXZo
	return GetTexStartVRAMAdrSub(inResTex, pData);
}



//----------------------------------------------------------------------------
/**
 *
 *@brief	eNX`TCYm肷Zo֐
 *
 *@param	inResTexFeNX`\[X
 *@param	inIndex FGetTexByteSize & GetTexByteSizeByNamen|C^
 *
 *@return	int	: eNX`TCY
 *
 */
//-----------------------------------------------------------------------------
static int GetTexByteSizeSub(NNSG3dResTex *inResTex, const NNSG3dResDictTexData* pData)
{
	u32 byte_size;
	u32 format;
	u32 t_size,s_size;
	u32 texel_size;
	
	//tH[}bg𒲂ׂ
	format = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_TEXFMT_MASK)>>NNS_G3D_TEXIMAGE_PARAM_TEXFMT_SHIFT;
#ifdef VRAM_TRANSFER_ANM_OS_PRINT_ON
	OS_Printf("TEX_FORMAT_IS:%d\n",format);	
#endif
	
	//tH[}bgɏ]A1eNZ̃f[^ʂ
	switch(format){
	case GX_TEXFMT_PLTT4:
		//4eNZ1oCg
		texel_size = 4;
		break;
	case GX_TEXFMT_PLTT16:
		//2eNZ1oCg
		texel_size = 2;
		break;
	case GX_TEXFMT_PLTT256:
		//1eNZ1oCg
		texel_size = 1;
		break;
	default:
#ifdef VRAM_TRANSFER_ANM_OS_PRINT_ON
		OS_Printf("ERROR:NO_SUPPORT_TEX_FORMAT\n");
#endif
		return 0;
	}
	
	//eNX`̉TCY擾
	s_size = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_S_SIZE_MASK)>>NNS_G3D_TEXIMAGE_PARAM_S_SIZE_SHIFT;
	s_size <<= 4;
#ifdef VRAM_TRANSFER_ANM_OS_PRINT_ON
	OS_Printf("TEX_S_SIZE_IS:%d\n",s_size);
#endif
	//eNX`̏cTCY擾
	t_size = (pData->texImageParam & NNS_G3D_TEXIMAGE_PARAM_T_SIZE_MASK)>>NNS_G3D_TEXIMAGE_PARAM_T_SIZE_SHIFT;
	t_size <<= 4;
#ifdef VRAM_TRANSFER_ANM_OS_PRINT_ON
	OS_Printf("TEX_T_SIZE_IS:%d\n",t_size);
#endif
	//oCgTCYvZ
	byte_size = (s_size*t_size)/texel_size;
#ifdef VRAM_TRANSFER_ANM_OS_PRINT_ON
	OS_Printf("TEX_BYTE_SIZE_IS:%d\n",byte_size);
#endif
	
	return byte_size;
}




//==============================================================================
/**
 * eNX`\[XƃeNX`hcm肷
 *
 * @param   inResTex	eNX`\[X
 * @param   inIndex		eNX`hc
 *
 * @retval  int			eNX`TCY
 */
//==============================================================================
int GetTexByteSize(NNSG3dResTex *inResTex, const u8 inIndex)
{
	
	//eNX`̎̂T[`
	const NNSG3dResDictTexData* pData = NNS_G3dGetTexDataByIdx( inResTex, inIndex );

	//TCYZo
	return GetTexByteSizeSub(inResTex, pData);

}

//==============================================================================
/**
 * eNX`\[XƃeNX`m肷
 *
 * @param   inResTex	eNX`\[X	
 * @param   name		eNX`
 *
 * @retval  int			eNX`TCY
 */
//==============================================================================
int GetTexByteSizeByName(NNSG3dResTex *inResTex, const char *name)
{
	const NNSG3dResDictTexData* pData;
	NNSG3dResName tmpResName;		
	
	SetResName(&tmpResName,name);		//NNSG3dResNameɕϊ

	//eNX`̎̂T[`
	pData = NNS_G3dGetTexDataByName( inResTex, &tmpResName );

	//TCYZo
	return GetTexByteSizeSub(inResTex, pData);

}
