//============================================================================================
/**
 * @file	itemicon.c
 * @bfief	ACeACR
 * @author	Hiroyuki Nakamura
 * @date	05.09.16
 */
//============================================================================================
#include "common.h"
#include "system/arc_tool.h"
#include "system/clact_util.h"
#include "system/clact_tool.h"

#define	ITEMICON_H_GLOBAL
#include "itemtool/item.h"
#include "itemtool/itemicon.h"
#include "item_icon.naix"



//============================================================================================
//============================================================================================
//	ACeACR
//============================================================================================
//============================================================================================

//--------------------------------------------------------------------------------------------
/**
 * ZAN^[쐬
 *
 * @param	csp
 * @param	crp
 * @param	item	ACeԍ
 * @param	trans	][h
 * @param	id		ǗID
 *
 * @return	none
 */
//--------------------------------------------------------------------------------------------
void ItemIconCellActMake( CATS_SYS_PTR csp, CATS_RES_PTR crp, u16 item, u8 trans, u16 id )
{
	TCATS_RESOURCE_NUM_LIST	crnl = { 1, 1, 1, 1, 0, 0 };

	CATS_ResourceManagerInit( csp, crp, &crnl );

	CATS_LoadResourceCharArcModeAdjust(
		csp, crp, ARC_ITEMICON, GetItemIndex(item,ITEM_GET_ICON_CGX), 0, trans, id );

	CATS_LoadResourcePlttArc(
		csp, crp, ARC_ITEMICON, GetItemIndex(item,ITEM_GET_ICON_PAL), 0, 1, trans, id );
	CATS_LoadResourceCellArc(
		csp, crp, ARC_ITEMICON, NARC_item_icon_itemicon_NCER, 0, id );
	CATS_LoadResourceCellAnmArc(
		csp, crp, ARC_ITEMICON, NARC_item_icon_itemicon_NANR, 0, id );
}
