//============================================================================================
/**
 * @file	boxdata.c
 * @brief	|P{bNXf[^舵
 * @author	taya
 * @date	2005.09.05
 */
//============================================================================================
#include "common.h"
#include "gflib\strbuf_family.h"
#include "poketool\poke_tool.h"
#include "system\pm_str.h"
#include "system\msgdata.h"

#include "system\arc_tool.h"
#include "msgdata\msg.naix"
#include "msgdata\msg_boxmenu.h"
#include "poketool\boxdata.h"
#include "..\poke_tool_def.h"


struct _BOX_DATA{
	u32					currentTrayNumber;
	POKEMON_PASO_PARAM  ppp[BOX_MAX_TRAY][BOX_MAX_POS];
	STRCODE				trayName[BOX_MAX_TRAY][BOX_TRAYNAME_BUFSIZE];
	u8					wallPaper[BOX_MAX_TRAY];
};


//==============================================================
// Prototype
//==============================================================
static void boxdata_init( BOX_DATA* boxdat );


//------------------------------------------------------------------
/**
 * {bNXf[^
 */
//------------------------------------------------------------------
void BOXDAT_Init( BOX_DATA* boxdat )
{
	boxdata_init(boxdat);
}
//------------------------------------------------------------------
/**
 * {bNXf[^̑TCYԂ
 *
 * @retval  u32		{bNXf[^TCY
 */
//------------------------------------------------------------------
u32 BOXDAT_GetTotalSize( void )
{
	return sizeof( BOX_DATA );
}


//------------------------------------------------------------------
/**
 * {bNXf[^̈揉
 *
 * @param   boxdat		
 *
 */
//------------------------------------------------------------------
static void boxdata_init( BOX_DATA* boxdat )
{
	u32 i, p;
	MSGDATA_MANAGER*  msgman;

	for(i = 0; i < BOX_MAX_TRAY; i++)
	{
		for(p = 0; p < BOX_MAX_POS; p++)
		{
			PokePasoParaInit( &(boxdat->ppp[i][p]) );
		}
	}

	for(i = 0, p = 0; i < BOX_MAX_TRAY; i++)
	{
		boxdat->wallPaper[i] = p++;
		if(p >= BOX_MAX_WALLPAPERTYPE){
			p = 0;
		}
	}

	// ftHg{bNXZbg
	msgman = MSGMAN_Create( MSGMAN_TYPE_DIRECT, ARC_MSG, NARC_msg_boxmenu_dat, HEAPID_BASE_APP );
	if( msgman )
	{
		for(i = 0 ; i < BOX_MAX_TRAY; i++)
		{
			MSGMAN_GetStr( msgman, mes_boxmenu_02_02+i, boxdat->trayName[i] );
		}
		MSGMAN_Delete( msgman );
	}

	boxdat->currentTrayNumber = 0;

#ifdef PM_DEBUG
	{
		#include "poketool\monsno.h"
		static const u16 monsno[] = {
			MONSNO_GONBE,
			MONSNO_USOHATI,
			MONSNO_MANENE,
			MONSNO_MANYUURA,
			MONSNO_RUKARIO,
			MONSNO_TAMANTA,
			MONSNO_BUIZERU,
			MONSNO_PERAPPU,
			MONSNO_MIMITTO,
//			MONSNO_ROZEMASUKU,
			MONSNO_MOZYANBO,
//			MONSNO_MADOROOMU,
			MONSNO_MANMUU,
//			MONSNO_YUKIONNA,
			MONSNO_RIZUMHI,
		};

		POKEMON_PASO_PARAM* ppp = sys_AllocMemory(HEAPID_BASE_DEBUG, PokemonPasoParamSizeGet() );
		if( ppp )
		{
			int i;
			for(i=0; i<NELEMS(monsno); i++)
			{
				PokePasoParaSet(ppp, monsno[i], 50, POW_RND, RND_NO_SET, 0, ID_NO_SET, 0);
				BOXDAT_PutPokemonPos( boxdat, 0, i, ppp );
			}
			sys_FreeMemoryEz(ppp);
		}
	}
#endif

}

//------------------------------------------------------------------
/**
 * {bNXŜ炩󂫗̈Tă|Pf[^i[
 *
 * @param   box			{bNXf[^|C^
 * @param   poke		|Pf[^
 *
 * @retval  BOOL		TRUE=i[ꂽ^FALSE=󂫂
 */
//------------------------------------------------------------------
BOOL BOXDAT_PutPokemon( BOX_DATA* box, POKEMON_PASO_PARAM* poke )
{
	u32 b;

	b = box->currentTrayNumber;
	do
	{
		if( BOXDAT_PutPokemonBox( box, b, poke ) )
		{
			return TRUE;
		}

		if( ++b >= BOX_MAX_TRAY )
		{
			b = 0;
		}

	}while( b != box->currentTrayNumber );

	return FALSE;
}

//------------------------------------------------------------------
/**
 * {bNXw肵ă|Pf[^i[
 *
 * @param   box			{bNXf[^|C^
 * @param   trayNum		Ԗڂ̃{bNXɊi[邩
 * @param   poke		|Pf[^
 *
 * @retval  BOOL		TRUE=i[ꂽ^FALSE=󂫂
 */
//------------------------------------------------------------------
BOOL BOXDAT_PutPokemonBox( BOX_DATA* box, u32 trayNum, POKEMON_PASO_PARAM* poke )
{
	u32 i;

	if( trayNum == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNum = box->currentTrayNumber;
	}

	for(i = 0; i < BOX_MAX_POS; i++)
	{
		if( PokePasoParaGet( &(box->ppp[trayNum][i]), ID_PARA_monsno, NULL  ) == 0 )
		{
			box->ppp[trayNum][i] = *poke;
			return TRUE;
		}
	}

	return FALSE;
}
//------------------------------------------------------------------
/**
 * {bNXAʒuw肵ă|Pf[^i[
 *
 * @param   box			{bNXf[^|C^
 * @param   trayNum		Ԗڂ̃{bNXɊi[邩
 * @param   pos			{bNẌʒu
 * @param   poke		|Pf[^
 *
 * @retval  BOOL		TRUE=i[ꂽ^FALSE=󂫂
 */
//------------------------------------------------------------------
BOOL BOXDAT_PutPokemonPos( BOX_DATA* box, u32 trayNum, u32 pos, const POKEMON_PASO_PARAM* poke )
{
	if( trayNum == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNum = box->currentTrayNumber;
	}

	if(	(trayNum < BOX_MAX_TRAY)
	&&	(pos < BOX_MAX_POS)
	){
		box->ppp[trayNum][pos] = *poke;
		return TRUE;
	}
	else
	{
		GF_ASSERT(0);
	}
	return FALSE;
}
//------------------------------------------------------------------
/**
 * ʒuw肵ă{bNX̃|Pf[^NA
 *
 * @param   box			{bNXf[^|C^
 * @param   trayNum		Ԗڂ̃{bNX
 * @param   pos			{bNẌʒu
 *
 */
//------------------------------------------------------------------
void BOXDAT_ClearPokemon( BOX_DATA* box, u32 trayNum, u32 pos )
{
	if( trayNum == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNum = box->currentTrayNumber;
	}

	if(	pos < BOX_MAX_POS )
	{
		PokePasoParaInit( &(box->ppp[box->currentTrayNumber][pos]) );
	}
}

//------------------------------------------------------------------
/**
 * Jg̃gCio[Ԃ
 *
 * @param   box		{bNXf[^|C^
 *
 * @retval  u32		JggCio[
 */
//------------------------------------------------------------------
u32 BOXDAT_GetCureentTrayNumber( const BOX_DATA* box )
{
	return box->currentTrayNumber;
}
//------------------------------------------------------------------
/**
 * Jg̃gCio[Zbg
 *
 * @param   box		{bNXf[^|C^
 * @param   num		JggCio[
 */
//------------------------------------------------------------------
void BOXDAT_SetCureentTrayNumber( BOX_DATA* box, u32 num )
{
	if( num < BOX_MAX_TRAY )
	{
		box->currentTrayNumber = num;
	}
	else
	{
		GF_ASSERT(0);
		box->currentTrayNumber = 0;
	}
}
//------------------------------------------------------------------
/**
 * wgC̕ǎio[Ԃ
 *
 * @param   box				{bNXf[^|C^
 * @param   trayNumber		gCio[
 *
 * @retval  u32		ǎio[
 */
//------------------------------------------------------------------
u32 BOXDAT_GetWallPaperNumber( const BOX_DATA* box, u32 trayNum )
{
	if( trayNum < BOX_MAX_TRAY )
	{
		return box->wallPaper[trayNum];
	}
	else
	{
		GF_ASSERT(0);
		return 0;
	}
}
//------------------------------------------------------------------
/**
 * wgC̕ǎio[Zbg
 *
 * @param   box				{bNXf[^|C^
 * @param   trayNum			gCio[
 * @param   wallPaperNumber	ǎio[
 *
 */
//------------------------------------------------------------------
void BOXDAT_SetWallPaperNumber( BOX_DATA* box, u32 trayNum, u32 wallPaperNumber )
{
	if( trayNum == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNum = box->currentTrayNumber;
	}

	if(	(trayNum < BOX_MAX_TRAY )
	&&	(wallPaperNumber < BOX_MAX_WALLPAPERTYPE )
	)
	{
		box->wallPaper[trayNum] = wallPaperNumber;
	}
	else
	{
		GF_ASSERT(0);
	}
}

//------------------------------------------------------------------
/**
 * wgC̖O擾
 *
 * @param   box				{bNXf[^|C^
 * @param   trayNumber		gCio[
 * @param   buf				Rs[obt@
 *
 */
//------------------------------------------------------------------
void BOXDAT_GetBoxName( const BOX_DATA* box, u32 trayNumber, STRBUF* buf )
{
	if( trayNumber == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNumber = box->currentTrayNumber;
	}

	if( trayNumber < BOX_MAX_TRAY )
	{
		STRBUF_SetStringCode( buf, box->trayName[trayNumber] );
	}
	else
	{
		GF_ASSERT(0);
	}
}

//------------------------------------------------------------------
/**
 * wgC̖Oݒ
 *
 * @param   box				{bNXf[^|C^
 * @param   trayNumber		gCio[
 * @param   src				O
 *
 */
//------------------------------------------------------------------
void BOXDAT_SetBoxName( BOX_DATA* box, u32 trayNumber, const STRBUF* src )
{
	if( trayNumber == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNumber = box->currentTrayNumber;
	}

	if( trayNumber < BOX_MAX_TRAY )
	{
		STRBUF_GetStringCode( src, box->trayName[trayNumber], BOX_TRAYNAME_BUFSIZE );
	}
}

//------------------------------------------------------------------
/**
 * wgCɊi[Ă|PԂ
 *
 * @param   box				{bNXf[^|C^
 * @param   trayNumber		gCio[
 *
 */
//------------------------------------------------------------------
u32 BOXDAT_GetPokeExistCount( const BOX_DATA* box, u32 trayNum )
{
	if( trayNum == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNum = box->currentTrayNumber;
	}

	if( trayNum < BOX_MAX_TRAY )
	{
		int i;
		u32 cnt = 0;
		for(i=0; i<BOX_MAX_POS; i++)
		{
			if(PokePasoParaGet( (POKEMON_PASO_PARAM*)(&(box->ppp[trayNum][i])), ID_PARA_poke_exist, NULL ))
			{
				cnt++;
			}
		}
		return cnt;
	}
	else
	{
		GF_ASSERT(0);
	}
	return 0;
}

//------------------------------------------------------------------
/**
 * 
 *
 * @param   box			{bNXf[^|C^
 * @param   boxNum		{bNXio[
 * @param   pos			
 *
 * @retval  POKEMON_PASO_PARAM*		
 */
//------------------------------------------------------------------
POKEMON_PASO_PARAM* BOXDAT_GetPokeDataAddress( const BOX_DATA* box, u32 trayNum, u32 pos )
{
	GF_ASSERT_RETURN( ((trayNum<BOX_MAX_TRAY)||(trayNum == BOXDAT_TRAYNUM_CURRENT)), NULL );
	GF_ASSERT_RETURN( (pos<BOX_MAX_POS), NULL );

	if( trayNum == BOXDAT_TRAYNUM_CURRENT )
	{
		trayNum = box->currentTrayNumber;
	}

	return (POKEMON_PASO_PARAM*) &(box->ppp[trayNum][pos]);
}















