//============================================================================================
/**
 * @file	pokeicon.c
 * @bfief	|PACR֘A
 * @author	Hiroyuki Nakamura
 * @date	05.09.16
 */
//============================================================================================
#include "common.h"
#include "system/arc_tool.h"

#define POKEICON_H_GLOBAL
#include "poketool/pokeicon.h"
#include "poketool/monsno.h"
#include "icongra/poke_icon.naix"


//============================================================================================
//	O[oϐ
//============================================================================================
#include "pokeicon.dat"


//--------------------------------------------------------------------------------------------
/**
 * L̃A[JCuCfbNX擾 ( POKEMON_PASO_PARAM  )
 *
 * @param	ppp			POKEMON_PASO_PARAM
 *
 * @return	A[JCuCfbNX
 *
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconCgxArcIndexGet( const POKEMON_PASO_PARAM* ppp )
{
	u32 monsno;
	u16	pat = 0;

	monsno = PokePasoParaGet( (POKEMON_PASO_PARAM*)ppp, ID_PARA_monsno_egg, NULL );

	/* Am[fILVX̃tH͂Ŏ舵 */
	if( monsno == MONSNO_ANNOON ){
		pat = PokemonPasoUnknownFormGet( (POKEMON_PASO_PARAM *)ppp ) + 1;
	}

	if( monsno > MONSNO_END && monsno != MONSNO_TAMAGO ){ monsno = 0; }
//	if( monsno > MONSNO_DEOKISISU ){ monsno = 0; }

	return PokeIconCgxArcIndexGetByMonsNo( monsno, pat );
}

//--------------------------------------------------------------------------------------------
/**
 * L̃A[JCuCfbNX擾 ( POKEMON_PARAM  )
 *
 * @param	pp			POKEMON_PARAM
 *
 * @return	A[JCuCfbNX
 *
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconCgxArcIndexGetByPP( POKEMON_PARAM * pp )
{
	return PokeIconCgxArcIndexGet( (const POKEMON_PASO_PARAM *)PPPPointerGet( pp ) );
}

//--------------------------------------------------------------------------------------------
/**
 * L̃A[JCuCfbNX擾
 *
 * @param	mons		|Pԍ
 * @param	pat			gp^[
 *
 * @return	A[JCuCfbNX
 *
 *	pat̓fILVXAm[Ɏgp
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconCgxArcIndexGetByMonsNo( u16 mons, u16 pat )
{
	if( mons == MONSNO_TAMAGO ){
		return NARC_poke_icon_poke_icon_tam_NCGR;
	}

	if( pat != 0 ){
		if( mons == MONSNO_DEOKISISU ){
			return ( NARC_poke_icon_poke_icon_d01_NCGR + pat - 1 );
		}
		if( mons == MONSNO_ANNOON ){
			return ( NARC_poke_icon_poke_icon_u01_NCGR + pat - 1 );
		}
	}

	if( mons > MONSNO_END ){ mons = 0; }
//	if( mons > MONSNO_DEOKISISU ){ mons = 0; }

	return ( NARC_poke_icon_poke_icon_000_NCGR + mons );
}

//--------------------------------------------------------------------------------------------
/**
 * pbgԍ擾
 *
 * @param	mons		|Pԍ
 *
 * @return	pbgԍ
 */
//--------------------------------------------------------------------------------------------
const u8 PokeIconPaletteIDGet( u16 mons )
{
	if( mons > MONSNO_END && mons != MONSNO_TAMAGO  ){ mons = 0; }
//	if( mons > MONSNO_DEOKISISU ){ mons = 0; }
	return IconPalAtr[mons];
}

//--------------------------------------------------------------------------------------------
/**
 * pbg̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconPalArcIndexGet(void)
{
	return NARC_poke_icon_poke_icon_NCLR;
}

//--------------------------------------------------------------------------------------------
/**
 * Z̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconCellArcIndexGet(void)
{
	return NARC_poke_icon_poke_icon01_NCER;
}

//--------------------------------------------------------------------------------------------
/**
 * Z̃A[JCuCfbNX擾iAjj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconAnmCellArcIndexGet(void)
{
	return NARC_poke_icon_poke_icon_anm_NCER;
}

//--------------------------------------------------------------------------------------------
/**
 * ZAj̃A[JCuCfbNX擾
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconCellAnmArcIndexGet(void)
{
	return NARC_poke_icon_poke_icon01_NANR;
}

//--------------------------------------------------------------------------------------------
/**
 * ZAj̃A[JCuCfbNX擾iAjj
 *
 * @param	none
 *
 * @return	A[JCuCfbNX
 */
//--------------------------------------------------------------------------------------------
u32 PokeIconAnmCellAnmArcIndexGet(void)
{
	return NARC_poke_icon_poke_icon_anm_NANR;
}
