
//============================================================================================
/**
 * @file	tr_tool.c
 * @bfief	g[i[f[^c[S
 * @author	HisashiSogabe
 * @date	05.12.14
 */
//============================================================================================

#include	"common.h"

#include	"battle/battle_common.h"
#include	"poketool/poke_tool.h"
#include	"poketool/pokeparty.h"
#include	"poketool/tr_tool.h"
#include	"system/arc_tool.h"
#include	"system/msgdata.h"

#include	"msgdata/msg.naix"

//============================================================================================
/**
 * 萔錾
 */
//============================================================================================

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================

void	TT_EncountTrainerDataMake(BATTLE_PARAM *bp,int heapID);
u32		TT_TrainerDataParaGet(int tr_id,int id);
BOOL	TT_TrainerMessageCheck(int tr_id,int kindID,int heapID);
void	TT_TrainerMessageGet(int tr_id,int msgID,STRBUF *msg,int heapID);

void	TT_TrainerDataGet(int tr_id,TRAINER_DATA *td);
void	TT_TrainerPokeDataGet(int tr_id,void *tpd);

static	void	TT_EncountTrainerPokeDataMake(BATTLE_PARAM *bp,int num,int heapID);

//============================================================================================
/**
 *	GJEgg[i[f[^𐶐
 *
 * @param[in/out]	bp		퓬VXeɈn\̂̃|C^
 * @param[in]		heapID	mۂ邽߂̃q[vID
 */
//============================================================================================
void	TT_EncountTrainerDataMake(BATTLE_PARAM *bp,int heapID)
{
	TRAINER_DATA	td;
	int				num;

	num=0;

	do{
		TT_TrainerDataGet(bp->trainer_id[num],&td);
		bp->trainer_data[num]=td;
		TT_EncountTrainerPokeDataMake(bp,num,heapID);
		num++;
	}while((bp->fight_type&FIGHT_TYPE_TAG)&&(num<2));

	bp->fight_type|=td.fight_type;
}

//============================================================================================
/**
 *	g[i[f[^擾
 *
 * @param[in]	waza_no		擾Zio[
 * @param[in]	id			擾l̎
 *
 *	@retval	vZʂ̃_[W
 */
//============================================================================================
u32	TT_TrainerDataParaGet(int tr_id,int id)
{
	u32	ret;
	TRAINER_DATA td;

	TT_TrainerDataGet(tr_id,&td);

	switch(id){
	case ID_TD_data_type:		//f[^^Cv
		ret=td.data_type;
		break;
	case ID_TD_tr_type:			//g[i[
		ret=td.tr_type;
		break;
	case ID_TD_tr_gra:			//g[i[OtBbN
		ret=td.tr_gra;
		break;
	case ID_TD_poke_count:		//|P
		ret=td.poke_count;
		break;
	case ID_TD_use_item1:		//gp1
	case ID_TD_use_item2:		//gp2
	case ID_TD_use_item3:		//gp3
	case ID_TD_use_item4:		//gp4
		ret=td.use_item[id-ID_TD_use_item1];
		break;
	case ID_TD_aibit:			//AIp^[
		ret=td.aibit;
		break;
	case ID_TD_fight_type:		//퓬^Cvi1vs1or2vs2j
		ret=td.fight_type;
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	g[i[bZ[Wf[^݂邩`FbN
 *
 * @param[in]	tr_id		`FbNg[i[ID
 * @param[in]	kindID		`FbNbZ[W̎
 * @param[in]	heapID		e|̈̐q[vID
 *
 * @retval	TRUE:݂@FALSE:݂Ȃ
 */
//============================================================================================
BOOL	TT_TrainerMessageCheck(int tr_id,int kindID,int heapID)
{
	ARCHANDLE	*handle;
	int	size;
	int	ofs;
	u16	data[2];

	size=ArchiveDataSizeGet(ARC_TRTBL,0);
	ofs=0;
	handle=ArchiveDataHandleOpen(ARC_TRTBL,heapID);

	while(ofs!=size){
		ArchiveDataLoadOfsByHandle(handle,0,ofs,4,&data[0]);
		if((data[0]==tr_id)&&(data[1]==kindID)){
			break;
		}
		ofs+=4;
	}
	ArchiveDataHandleClose(handle);

	return (ofs!=size);
}

//============================================================================================
/**
 *	g[i[bZ[Wf[^擾
 *
 * @param[in]	tr_id		擾g[i[ID
 * @param[in]	kindID		擾bZ[W̎
 * @param[out]	msg			擾bZ[W̊i[ւ̃|C^
 * @param[in]	heapID		e|̈̐q[vID
 */
//============================================================================================
void	TT_TrainerMessageGet(int tr_id,int kindID,STRBUF *msg,int heapID)
{
	ARCHANDLE	*handle;
	int	size;
	int	ofs;
	u16	data[2];

	size=ArchiveDataSizeGet(ARC_TRTBL,0);
	ofs=0;
	handle=ArchiveDataHandleOpen(ARC_TRTBL,heapID);

	while(ofs!=size){
		ArchiveDataLoadOfsByHandle(handle,0,ofs,4,&data[0]);
		if((data[0]==tr_id)&&(data[1]==kindID)){
			MSGDAT_GetStrDirect(ARC_MSG,NARC_msg_trmsg_dat,ofs/4,heapID,msg);
			break;
		}
		ofs+=4;
	}
	ArchiveDataHandleClose(handle);

//	GF_ASSERT_MSG(ofs!=size,"TrainerMessage Not Found");
	//bZ[WȂASTRBUFNAĕԂib菈j
	if(ofs==size){
		OS_TPrintf("TrainerMessage Not Found");
		STRBUF_Clear(msg);
	}
}

//============================================================================================
/**
 *	g[i[\̃f[^擾
 *
 * @param[in]	tr_id		擾g[i[ID
 * @param[in]	td			擾g[i[f[^̊i[w
 */
//============================================================================================
void	TT_TrainerDataGet(int tr_id,TRAINER_DATA *td)
{
	ArchiveDataLoad(td,ARC_TRDATA,tr_id);
}

//============================================================================================
/**
 *	g[i[|P\̃f[^擾
 *
 * @param[in]	tr_id		擾g[i[ID
 * @param[in]	td			擾g[i[|Pf[^̊i[w
 */
//============================================================================================
void	TT_TrainerPokeDataGet(int tr_id,void *tpd)
{
	ArchiveDataLoad(tpd,ARC_TRPOKE,tr_id);
}

//============================================================================================
/**
 *							OJȂ֐S
 */
//============================================================================================
//============================================================================================
/**
 *	GJEgg[i[|Pf[^𐶐
 *
 * @param[in/out]	bp		퓬VXeɈn\̂̃|C^
 * @param[in]		num		Ԗڂ̃g[i[IDHi^bO̎̂߁j
 * @param[in]		heapID	mۂ邽߂̃q[vID
 */
//============================================================================================
static	void	TT_EncountTrainerPokeDataMake(BATTLE_PARAM *bp,int num,int heapID)
{
	void			*buf;
	int				i,j;
	u32				rnd_tmp,rnd;
	u8				pow;
	POKEMON_PARAM	*pp;

	PokeParty_Init(bp->poke_party[POKEPARTY_ENEMY+num*2],POKEMON_TEMOTI_MAX);

	buf=sys_AllocMemory(heapID,sizeof(POKEDATA_TYPE_MULTI));
	pp=PokemonParam_AllocWork(heapID);

	TT_TrainerPokeDataGet(bp->trainer_id[num],buf);

#warning TRTYPE_SEX undefined
#if 0
		if(TT_TrainerSexGet(bp->trainer_data[num].tr_type)==TR_FEMALE){
			rnd_tmp=120;
		}
		else{
			rnd_tmp=136;
		}
#else
		rnd_tmp=128;
#endif

	switch(bp->trainer_data[num].data_type){
	case DATATYPE_NORMAL:
		{
			POKEDATA_TYPE_NORMAL	*ptn;

			ptn=(POKEDATA_TYPE_NORMAL *)buf;
			for(i=0;i<bp->trainer_data[num].poke_count;i++){
				//|Pf[^̃p[^gpāA|P̌𐶐
				rnd=ptn[i].pow+ptn[i].level+ptn[i].monsno+bp->trainer_id[num];
				gf_srand(rnd);
				for(j=0;j<bp->trainer_data[num].tr_type;j++){
					rnd=gf_rand();
				}
				rnd=(rnd<<8)+rnd_tmp;
				pow=ptn[i].pow*31/255;
				PokeParaSet(pp,ptn[i].monsno,ptn[i].level,pow,RND_SET,rnd,ID_NO_RARE,0);
				PokeParty_Add(bp->poke_party[POKEPARTY_ENEMY+num*2],pp);
			}
		}
		break;
	case DATATYPE_WAZA:
		{
			POKEDATA_TYPE_WAZA	*ptw;

			ptw=(POKEDATA_TYPE_WAZA *)buf;
			for(i=0;i<bp->trainer_data[num].poke_count;i++){
				//|Pf[^̃p[^gpāA|P̌𐶐
				rnd=ptw[i].pow+ptw[i].level+ptw[i].monsno+bp->trainer_id[num];
				gf_srand(rnd);
				for(j=0;j<bp->trainer_data[num].tr_type;j++){
					rnd=gf_rand();
				}
				rnd=(rnd<<8)+rnd_tmp;
				pow=ptw[i].pow*31/255;
				PokeParaSet(pp,ptw[i].monsno,ptw[i].level,pow,RND_SET,rnd,ID_NO_RARE,0);
				for(j=0;j<4;j++){
					PokeWazaSetPos(pp,ptw[i].waza[j],j);
				}
				PokeParty_Add(bp->poke_party[POKEPARTY_ENEMY+num*2],pp);
			}
		}
		break;
	case DATATYPE_ITEM:
		{
			POKEDATA_TYPE_ITEM	*pti;

			pti=(POKEDATA_TYPE_ITEM *)buf;
			for(i=0;i<bp->trainer_data[num].poke_count;i++){
				//|Pf[^̃p[^gpāA|P̌𐶐
				rnd=pti[i].pow+pti[i].level+pti[i].monsno+bp->trainer_id[num];
				gf_srand(rnd);
				for(j=0;j<bp->trainer_data[num].tr_type;j++){
					rnd=gf_rand();
				}
				rnd=(rnd<<8)+rnd_tmp;
				pow=pti[i].pow*31/255;
				PokeParaSet(pp,pti[i].monsno,pti[i].level,pow,RND_SET,rnd,ID_NO_RARE,0);
				PokeParaPut(pp,ID_PARA_item,(u8 *)&pti[i].itemno);
				PokeParty_Add(bp->poke_party[POKEPARTY_ENEMY+num*2],pp);
			}
		}
		break;
	case DATATYPE_MULTI:
		{
			POKEDATA_TYPE_MULTI	*ptm;

			ptm=(POKEDATA_TYPE_MULTI *)buf;
			for(i=0;i<bp->trainer_data[num].poke_count;i++){
				//|Pf[^̃p[^gpāA|P̌𐶐
				rnd=ptm[i].pow+ptm[i].level+ptm[i].monsno+bp->trainer_id[num];
				gf_srand(rnd);
				for(j=0;j<bp->trainer_data[num].tr_type;j++){
					rnd=gf_rand();
				}
				rnd=(rnd<<8)+rnd_tmp;
				pow=ptm[i].pow*31/255;
				PokeParaSet(pp,ptm[i].monsno,ptm[i].level,pow,RND_SET,rnd,ID_NO_RARE,0);
				PokeParaPut(pp,ID_PARA_item,(u8 *)&ptm[i].itemno);
				for(j=0;j<4;j++){
					PokeWazaSetPos(pp,ptm[i].waza[j],j);
				}
				PokeParty_Add(bp->poke_party[POKEPARTY_ENEMY+num*2],pp);
			}
		}
		break;
	}
	sys_FreeMemoryEz(buf);
}
			
