
//============================================================================================
/**
 * @file	waza_tool.c
 * @bfief	Zp[^c[S
 * @author	HisashiSogabe
 * @date	05.07.28
 */
//============================================================================================

#include	"common.h"

#include	"battle/battle_common.h"
#include	"battle/battle_server.h"
#include	"battle/fight_tool.h"
#include	"battle/server.h"
#include	"battle/server_tool.h"
#include	"battle/tokusyu_def.h"
#include	"battle/wazano_def.h"
#include	"poketool/monsno.h"
#include	"poketool/poke_tool.h"
#include	"poketool/waza_tool.h"
#include	"system/arc_tool.h"

#include	"itemtool/item.h"
#include	"itemtool/itemequip.h"
#include	"itemtool/itemsym.h"

#include	"waza_tool_def.h"

//============================================================================================
/**
 * 萔錾
 */
//============================================================================================

typedef struct{
	u16	monsno;
	s16 hp;
	u16	hpmax;
	u8	eqp;
	u8	atc;
	u32 condition;
	u8	speabino;
	u8	sex;
}WAZA_DAMAGE_CALC_PARAM;

//============================================================================================
/**
 * vg^Cv錾
 */
//============================================================================================

int		WT_WazaDamageCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,int wazano,u32 side_cond,u32 field_cond,u16 pow,u8 type,u8 attack,u8 defence,u8 critical);
int		WT_DamageLossCalc(int damage);
u32		WT_WazaDataParaGet(int waza_no,int id);
int		WT_CriticalCheck(SERVER_PARAM *sp,int attack,int defence,int critical_count);
u8		WT_PPMaxGet(u16 wazano,u8 maxupcnt);
BOOL	WT_MonomaneNGCheck(u16 waza_no);
BOOL	WT_YubiwohuruNGCheck(u16 waza_no);
BOOL	WT_OumuEncoreNGCheck(u16 waza_no);

static	void	WT_WazaDataGet(int waza_no,WAZA_TABLE_DATA *wtd);

//============================================================================================
/**
 *	ʂɂZ^CvU̓Abve[u
 */
//============================================================================================
static	const u8 SoubiItemWazaTypePowUpTbl[][2]={
	{SOUBI_MUSIIRYOKUUP,MUSHI_TYPE},
	{SOUBI_HAGANEIRYOKUUP,METAL_TYPE},
	{SOUBI_ZIMENUP,JIMEN_TYPE},
	{SOUBI_IWAUP,IWA_TYPE},
	{SOUBI_KUSAUP,KUSA_TYPE},
	{SOUBI_AKUUP,AKU_TYPE},
	{SOUBI_KAKUTOUUP,BATTLE_TYPE},
	{SOUBI_DENKIUP,ELECTRIC_TYPE},
	{SOUBI_MIZUUP,WATER_TYPE},
	{SOUBI_TORIUP,HIKOU_TYPE},
	{SOUBI_DOKUBARIUP,POISON_TYPE},
	{SOUBI_KOORIUP,KOORI_TYPE},
	{SOUBI_GOOSUTOUP,GHOST_TYPE},
	{SOUBI_ESUPAAUP,SP_TYPE},
	{SOUBI_HONOOUP,FIRE_TYPE},
	{SOUBI_DORAGONUP,DRAGON_TYPE},
	{SOUBI_NOOMARUUP,NORMAL_TYPE},
};

//============================================================================================
/**
 *	abiritycntɂp[^e[u
 */
//============================================================================================
const	u8	CondChgTable[][2]={
		{10,40},
		{10,35},
		{10,30},
		{10,25},
		{10,20},
		{10,15},
		{10,10},
		{15,10},
		{20,10},
		{25,10},
		{30,10},
		{35,10},
		{40,10},
};

//============================================================================================
/**
 *	Ă̂Ԃpe[u
 */
//============================================================================================
static	const	u16	TetsunoKobushiTable[]={
	WAZANO_REITOUPANTI,		//ꂢƂp`
	WAZANO_HONOONOPANTI,	//ق̂̃p`
	WAZANO_KAMINARIPANTI,	//݂Ȃp`
	WAZANO_MAHHAPANTI,		//}bnp`
	WAZANO_KIAIPANTI,		//p`
	WAZANO_PIYOPIYOPANTI,	//ssp`
	WAZANO_BAKURETUPANTI,	//΂p`
	WAZANO_HANMAAPANTI,		//n}[p`
	WAZANO_MEGATONPANTI,	//Kgp`
	WAZANO_RENZOKUPANTI,	//񂼂p`
	WAZANO_KOMETTOPANTI,	//Rbgp`
	WAZANO_SYADOOPANTI,		//Vh[p`
	WAZANO_DOREINPANTI,		//hCp`
	WAZANO_BARETTOPANTI,	//obgp`
};

//============================================================================================
/**
 *	Z̃_[WvZB
 *
 * @param[in]	pspa		Zo|P̍\̂̃|C^
 * @param[in]	pspd		Z󂯂|P̍\̂̃|C^
 * @param[in]	wazano		vZZio[
 * @param[in]	side_cond	ɂĂ
 * @param[in]	pow			Z̈З(0:e[uQƁ@0ȊO:̒lQ)
 * @param[in]	type		Z̃^Cv(0:e[uQƁ@0ȊO:̒lQ)
 * @param[in]	attack		ŨNCAgio[
 * @param[in]	defence		h䑤̃NCAgio[
 * @param[in]	critical	}ɓǂ(1:ʏ@2ȏ:NeBJj
 *
 *	@retval	vZʂ̃_[W
 */
//============================================================================================
int	WT_WazaDamageCalc(BATTLE_WORK *bw,SERVER_PARAM *sp,
					  int wazano,u32 side_cond,u32 field_cond,u16 pow,u8 type,u8 attack,u8 defence,u8 critical)
{

	int	i;
	s32	damage=0;
	s32	damage2=0;
	u8	wazatype;
	u8	wazakind;
	u16	pokepow;
	u16	pokedef;
	u16	pokespepow;
	u16	pokespedef;
	s8	condpow;
	s8	conddef;
	s8	condspepow;
	s8	condspedef;
	u8	level;
	u16	wazapow;
	u16	item;
	u32	fight_type;
	WAZA_TABLE_DATA wtd;
	WAZA_DAMAGE_CALC_PARAM	wdcp_a;
	WAZA_DAMAGE_CALC_PARAM	wdcp_d;

	GF_ASSERT(((critical==1)||(critical>1))&&"WT_WazaDamageCalc:critical != 1 or 2\n");

	WT_WazaDataGet(wazano,&wtd);

	pokepow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_pow,				NULL);
	pokedef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_def,				NULL);
	pokespepow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_spepow,				NULL);
	pokespedef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_spedef,			NULL);
	condpow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_abiritycnt_pow,		NULL)-6;
	conddef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_abiritycnt_def,	NULL)-6;
	condspepow=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_abiritycnt_spepow,	NULL)-6;
	condspedef=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_abiritycnt_spedef,	NULL)-6;
	level=				ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_level,				NULL);
	wdcp_a.monsno=		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_monsno,				NULL);
	wdcp_d.monsno=		ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_monsno,			NULL);
	wdcp_a.hp=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_hp,					NULL);
	wdcp_d.hp=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_hp,				NULL);
	wdcp_a.hpmax=		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_hpmax,				NULL);
	wdcp_d.hpmax=		ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_hpmax,				NULL);
	wdcp_a.condition=	ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_condition,			NULL);
	wdcp_d.condition=	ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_condition,			NULL);
	wdcp_a.speabino=	ST_ServerTokuseiGet(sp,attack);
	wdcp_d.speabino=	ST_ServerTokuseiGet(sp,defence);
	wdcp_a.sex=			ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_sex,				NULL);
	wdcp_d.sex=			ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_sex,				NULL);

	item=ST_ServerSoubiItemNoGet(sp,attack);
	wdcp_a.eqp=ItemParamGet(item,ITEM_PRM_EQUIP,HEAPID_BATTLE);
	wdcp_a.atc=ItemParamGet(item,ITEM_PRM_ATTACK,HEAPID_BATTLE);
	item=ST_ServerSoubiItemNoGet(sp,defence);
	wdcp_d.eqp=ItemParamGet(item,ITEM_PRM_EQUIP,HEAPID_BATTLE);
	wdcp_d.atc=ItemParamGet(item,ITEM_PRM_ATTACK,HEAPID_BATTLE);

	fight_type=BattleWorkFightTypeGet(bw);

	if(pow==0){
		wazapow=wtd.damage;
		//eNjV́AЗ50ȉ̋Z1.5{ɂ
		if((wdcp_a.speabino==TOKUSYU_TEKUNISYAN)&&(wazapow<=50)){
			wazapow=wazapow*15/10;
		}
	}
	else{
		wazapow=pow;
	}

	if(type==0){
		wazatype=wtd.wazatype;
	}
	else{
		wazatype=type&0x3f;
	}

	wazakind=wtd.kind;

	//́AKp[́AU͂{
	if((wdcp_a.speabino==TOKUSYU_TIKARAMOTI)||(wdcp_a.speabino==TOKUSYU_YOGAPAWAA)){
		pokepow=pokepow*2;
	}

	//X[X^[ǵAɂłĂ5^[ȓ́AU͂𔼕ɂ
	if((wdcp_a.speabino==TOKUSYU_SUROOSUTAATO)&&
	  ((ST_ServerParamDataGet(bw,sp,ID_SP_total_turn,NULL)-
		ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_wkw_nekodamashi_count,NULL))<5)){
		pokepow/=2;
	}

#warning Batch undefined
#if 0
	//Xg[obWĂƂ́AU͂POAbv
	if(BatchKoukaCheck(SYS_BATCH01_GET,attack)){
		pokepow=pokepow*110/100;
	}

	//oXobWĂƂ́Ah͂POAbv
	if(BatchKoukaCheck(SYS_BATCH05_GET,defence)){
		pokedef=pokedef*110/100;
	}

	//}ChobWĂƂ́AUPOAbv
	if(BatchKoukaCheck(SYS_BATCH07_GET,attack)){
		pokespepow=pokespepow*110/100;
	}

	//}ChobWĂƂ́AhPOAbv
	if(BatchKoukaCheck(SYS_BATCH07_GET,defence)){
		pokespedef=pokespedef*110/100;
	}
#endif

	//ACeŋZ^CvɂЗ̓Abv̑ʂ̂Ƃ́AЗ́U̓Abv
	for(i=0;i<NELEMS(SoubiItemWazaTypePowUpTbl);i++){
		if((wdcp_a.eqp==SoubiItemWazaTypePowUpTbl[i][0])&&(wazatype==SoubiItemWazaTypePowUpTbl[i][1])){
			if(wazatype<HATE_TYPE){		//U
				pokepow=pokepow*(100+wdcp_a.atc)/100;
			}
			else{
				pokespepow=pokespepow*(100+wdcp_a.atc)/100;
			}
			break;
		}
	}

	//ACeœZȂ̑ʂ̂Ƃ́AU1.5{Abv
	if(wdcp_a.eqp==SOUBI_ONAZIWAZAONLY){
		pokepow=pokepow*150/100;
	}
	//ACeœZȂ̑ʂ̂Ƃ́AU1.5{Abv
	if(wdcp_a.eqp==SOUBI_ONAZIAWZAONLYTOKUSYUUP){
		pokespepow=pokespepow*150/100;
	}

#warning SOUBI_ITEM FightType Check Undefine
	//ACeœUh1.5{̑ʂ̂Ƃ́AUh1.5{Abv
	if((wdcp_a.eqp==SOUBI_TOKUKOUTOKUBOUUP)&&
//	  ((fight_type&FIGHT_TYPE_FRONTIER)==0)&&
	  ((wdcp_a.monsno==MONSNO_RATHIOSU)||(wdcp_a.monsno==MONSNO_RATHIASU))){
		pokespepow=pokespepow*150/100;
	}

	//ACeœUh1.5{̑ʂ̂Ƃ́AUh1.5{Abv
	if((wdcp_d.eqp==SOUBI_TOKUKOUTOKUBOUUP)&&
//	  ((fight_type&FIGHT_TYPE_FRONTIER)==0)&&
	  ((wdcp_d.monsno==MONSNO_RATHIOSU)||(wdcp_d.monsno==MONSNO_RATHIASU))){
		pokespedef=pokespedef*150/100;
	}

	//ACeŃp[ƓU2{̑ʂ̂Ƃ́AU2{Abv
	if((wdcp_a.eqp==SOUBI_PAARURUTOKUKOUNIBAI)&&
	   (wdcp_a.monsno==MONSNO_PAARURU)){
		pokespepow*=2;
	}

	//ACeŃp[Ɠh2{̑ʂ̂Ƃ́Ah2{Abv
	if((wdcp_d.eqp==SOUBI_PAARURUTOKUBOUNIBAI)&&
	   (wdcp_d.monsno==MONSNO_PAARURU)){
		pokespedef*=2;
	}

	//ACeŃsJ`EƓU2{̑ʂ̂Ƃ́AU2{Abv
	if((wdcp_a.eqp==SOUBI_PIKATYUUTOKUKOUNIBAI)&&
	   (wdcp_a.monsno==MONSNO_PIKATYUU)){
		pokespepow*=2;
	}

	//ACeŃ^Ɩh͂2{̑ʂ̂Ƃ́Ah2{Abv
	if((wdcp_d.eqp==SOUBI_METAMONDATOBOUGYORYOKUUP)&&
	   (wdcp_d.monsno==MONSNO_METAMON)){
		pokedef*=2;
	}

	//ACeŃJJAKKƍU͂2{̑ʂ̂Ƃ́AU2{Abv
	if((wdcp_a.eqp==SOUBI_KARAGARADATOKOUGEKINIBAI)&&
	  ((wdcp_a.monsno==MONSNO_KARAKARA)||
	   (wdcp_a.monsno==MONSNO_GARAGARA))){
		pokepow*=2;
	}

	//ACeŁAm[}Z̈З͂𔼌̎́AЗ͂𔼌
	if((wdcp_d.eqp==SOUBI_NOOMARUHANGEN)&&
	   (wazatype==NORMAL_TYPE)){
		wazapow=wazapow/2;
		ST_ServerOSTFStatusFlagSet(sp,attack,OSTF_STATUS_FLAG_EQPITEM_POWDOWN);
	}

	//ACeŁAÜЗ͂Abv̎́AЗ͂Abv
	if((wdcp_a.eqp==SOUBI_BUTURIIRYOKUUP)&&(wazakind==KIND_BUTSURI)){
		wazapow=wazapow*(100+wdcp_a.atc)/100;
	}

	//ACeŁAÜЗ͂Abv̎́AЗ͂Abv
	if((wdcp_a.eqp==SOUBI_TOKUSYUIRYOKUUP)&&(wazakind==KIND_TOKUSYU)){
		wazapow=wazapow*(100+wdcp_a.atc)/100;
	}

	//\͂ڂ́Aق̂Aɂ悢
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_ATUISIBOU)==TRUE)&&
	  ((wazatype==FIRE_TYPE)||(wazatype==KOORI_TYPE))){
		pokespepow/=2;
	}

	//\͂͂肫́AU1.5{Abv
	if(wdcp_a.speabino==TOKUSYU_HARIKIRI){
		pokepow=pokepow*150/100;
	}

	//\͂񂶂傤́AԈُ̂ƂɍU1.5{Abv
	if((wdcp_a.speabino==TOKUSYU_KONZYOU)&&(wdcp_a.condition)){
		pokepow=pokepow*150/100;
	}

	//\͂ӂȂ낱́AԈُ̂Ƃɖh1.5{Abv
	if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_HUSIGINAUROKO)==TRUE)&&(wdcp_d.condition)){
		pokedef=pokedef*150/100;
	}

	//\̓vXA}CiX݂͂ɂƓU͂1.5{Abv
	if((wdcp_a.speabino==TOKUSYU_PURASU)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_MAINASU))){
		pokespepow=pokespepow*150/100;
	}
	if((wdcp_a.speabino==TOKUSYU_MAINASU)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_PURASU))){
		pokespepow=pokespepow*150/100;
	}

	//Zʂǂ날т́AdCn̋Z̈З͂𔼌
	if((wazatype==ELECTRIC_TYPE)&&(ST_ServerWazaKoukaCheck(bw,sp,WAZAKOUKA_DOROASOBI))){
		wazapow/=2;
	}

	//Zʂ݂т́An̋Z̈З͂𔼌
	if((wazatype==FIRE_TYPE)&&(ST_ServerWazaKoukaCheck(bw,sp,WAZAKOUKA_MIZUASOBI))){
		wazapow/=2;
	}

	//\͂傭HP1/3ȉő^Cv̈З͂1.5{ɂ
	if((wazatype==KUSA_TYPE)&&(wdcp_a.speabino==TOKUSYU_SINRYOKU)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}

	//\͂HP1/3ȉŉ^Cv̈З͂1.5{ɂ
	if((wazatype==FIRE_TYPE)&&(wdcp_a.speabino==TOKUSYU_MOUKA)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}

	//\͂イHP1/3ȉŐ^Cv̈З͂1.5{ɂ
	if((wazatype==WATER_TYPE)&&(wdcp_a.speabino==TOKUSYU_GEKIRYUU)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}
	//\͂ނ̂点HP1/3ȉŒ^Cv̈З͂1.5{ɂ
	if((wazatype==MUSHI_TYPE)&&(wdcp_a.speabino==TOKUSYU_MUSINOSIRASE)&&(wdcp_a.hp<=(wdcp_a.hpmax/3))){
		wazapow=wazapow*150/100;
	}
	//˂́An̋Z̈З͂𔼌
	if((wazatype==FIRE_TYPE)&&(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TAINETU)==TRUE)){
		wazapow/=2;
	}
	//񂻂͂́An̋Z̈З͂25%
	if((wazatype==FIRE_TYPE)&&(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_KANSOUHADA)==TRUE)){
		wazapow=wazapow*125/100;
	}
	//񂶂́A\͕ωl{
	if(wdcp_a.speabino==TOKUSYU_TANZYUN){
		condpow*=2;
		if(condpow<-6){
			condpow=-6;
		}
		if(condpow>6){
			condpow=6;
		}
		condspepow*=2;
		if(condspepow<-6){
			condspepow=-6;
		}
		if(condspepow>6){
			condspepow=6;
		}
	}
	//񂶂́A\͕ωl{
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TANZYUN)==TRUE){
		conddef*=2;
		if(conddef<-6){
			conddef=-6;
		}
		if(conddef>6){
			conddef=6;
		}
		condspedef*=2;
		if(condspedef<-6){
			condspedef=-6;
		}
		if(condspedef>6){
			condspedef=6;
		}
	}

	OS_TPrintf("1st condpow:%d conddef:%d\n",condpow,conddef);

	//Ă˂́A\͕ωltbg
	if(ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_TENNEN)==TRUE){
		condpow=0;
		condspepow=0;
	}
	//Ă˂́A\͕ωltbg
	if(wdcp_a.speabino==TOKUSYU_TENNEN){
		conddef=0;
		condspedef=0;
	}

	OS_TPrintf("2nd condpow:%d conddef:%d\n",condpow,conddef);

	condpow+=6;
	conddef+=6;
	condspepow+=6;
	condspedef+=6;

	//Ƃ́Aʂꏏ1.5{ɂ
	if((wdcp_a.speabino==TOKUSYU_TOUSOUSIN)&&
	   (wdcp_a.sex==wdcp_d.sex)&&(wdcp_a.sex!=PARA_UNK)&&(wdcp_d.sex!=PARA_UNK)){
		wazapow=wazapow*15/10;
	}

	//Ă̂Ԃ́Ap`n̋Z̈З͂1.2{ɂ
	for(i=0;i<NELEMS(TetsunoKobushiTable);i++){
		if((TetsunoKobushiTable[i]==wazano)&&(wdcp_a.speabino==TOKUSYU_TETUNOKOBUSI)){
			wazapow=wazapow*12/10;
			break;
		}
	}

	//V`FbNîĂ񂫂̃|P퓬ɏoĂꍇ͓V`FbNȂj
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		//Tp[́A͂̎AU͂1.5{ɂ
		if((field_cond&FIELD_CONDITION_HARE_ALL)&&(wdcp_a.speabino==TOKUSYU_SANPAWAA)){
			pokepow=pokepow*15/10;
		}
	}

	//u΂vu΂͂v́Ah͂𔼕ɂČvZ
	if(wtd.battleeffect==7){
		pokedef=pokedef/2;
	}

	if(wazakind==KIND_BUTSURI){	//U
		if(critical>1){
			if(condpow>6){
				damage=pokepow*CondChgTable[condpow][0];
				damage/=CondChgTable[condpow][1];
			}
			else{
				damage=pokepow;
			}
		}
		else{
			damage=pokepow*CondChgTable[condpow][0];
			damage/=CondChgTable[condpow][1];
		}

		damage*=wazapow;
		damage*=(level*2/5+2);

		if(critical>1){
			if(conddef<6){
				damage2=pokedef*CondChgTable[conddef][0];
				damage2/=CondChgTable[conddef][1];
			}
			else{
				damage2=pokedef;
			}
		}
		else{
			damage2=pokedef*CondChgTable[conddef][0];
			damage2/=CondChgTable[conddef][1];
		}

		damage/=damage2;
		damage/=50;

		//\͂񂶂傤́AԈُōU͂̂ł͖̔
		if((wdcp_a.condition&CONDITION_YAKEDO)&&(wdcp_a.speabino!=TOKUSYU_KONZYOU)){
			damage/=2;
		}

		//퓬186̓K[h̉e󂯂Ȃ
		if(((side_cond&SIDE_CONDITION_BUTSURIGUARD)!=0)&&(critical==1)&&(wtd.battleeffect!=186)){
			if((fight_type&FIGHT_TYPE_2vs2)&&(ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
				damage=damage/3*2;
			}
			else{
				damage/=2;
			}
		}

		if((fight_type&FIGHT_TYPE_2vs2)&&
		   (WT_WazaDataParaGet(wazano,ID_WTD_attackrange)==RANGE_DOUBLE)&&
		   (ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
			damage/=2;
		}
		if(damage==0){
			damage=1;
		}
	}
	else if(wazakind==KIND_TOKUSYU){			//U
		if(critical>1){
			if(condspepow>6){
				damage=pokespepow*CondChgTable[condspepow][0];
				damage/=CondChgTable[condspepow][1];
			}
			else{
				damage=pokespepow;
			}
		}
		else{
			damage=pokespepow*CondChgTable[condspepow][0];
			damage/=CondChgTable[condspepow][1];
		}

		damage*=wazapow;
		damage*=(level*2/5+2);

		if(critical>1){
			if(condspedef<6){
				damage2=pokespedef*CondChgTable[condspedef][0];
				damage2/=CondChgTable[condspedef][1];
			}
			else{
				damage2=pokespedef;
			}
		}
		else{
			damage2=pokespedef*CondChgTable[condspedef][0];
			damage2/=CondChgTable[condspedef][1];
		}

		damage/=damage2;
		damage/=50;

		//퓬186̓K[h̉e󂯂Ȃ
		if(((side_cond&SIDE_CONDITION_TOKUSYUGUARD)!=0)&&(critical==1)&&(wtd.battleeffect!=186)){
			if((fight_type&FIGHT_TYPE_2vs2)&&(ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
				damage=damage/3*2;
			}
			else{
				damage/=2;
			}
		}

		if((fight_type&FIGHT_TYPE_2vs2)&&
		   (WT_WazaDataParaGet(wazano,ID_WTD_attackrange)==RANGE_DOUBLE)&&
		   (ST_ServerHitCountCheck(bw,sp,SHCC_SIDE,defence)==2)){
			damage/=2;
		}

	}
	//V`FbNîĂ񂫂̃|P퓬ɏoĂꍇ͓V`FbNȂj
	if((ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_NOOTENKI)==0)&&
	   (ST_ServerTokuseiCheck(bw,sp,STC_HAVE_ALL_HP,0,TOKUSYU_EAROKKU)==0)){
		if(field_cond&FIELD_CONDITION_AME_ALL){
			switch(wazatype){
				case FIRE_TYPE:
					damage/=2;
					break;
				case WATER_TYPE:
					damage=damage*15/10;
					break;
			}
		}

		if((field_cond&FIELD_CONDITION_NO_SOLAR)&&(wazano==WAZANO_SOORAABIIMU)){
			damage/=2;
		}
		if(field_cond&FIELD_CONDITION_HARE_ALL){
			switch(wazatype){
				case FIRE_TYPE:
					damage=damage*15/10;
					break;
				case WATER_TYPE:
					damage/=2;
					break;
			}
		}
	}

	//\͂炢у`FbN
	if((ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_wkw_moraibi_flag,NULL))&&(wazatype==FIRE_TYPE)){
		damage=damage*15/10;
	}
	return	damage+2;
}

// =================================================================
// void	WS_DAMAGE_LOSS
// Tv  : _[WvZŋ߂l85%`100%͈̔͂Œ
//   : none
// ߂l: none
// =================================================================
int		WT_DamageLossCalc(int damage)
{
//	u16		work;
//	u8		eqp;
//	u8		atc;

	if(damage){
		damage*=(100-(gf_rand()%16));
		damage/=100;
		if(damage==0){
			damage=1;
		}
	}

#warning DAMAGE_LOSS NoItemCheck
#if 0
	if(PSP[DefenceClient].item==ITEM_NAZONOMI){
//		eqp=fld->RamSeed.item_equip;
//		atc=fld->RamSeed.item_power;
		eqp=FRS[DefenceClient].item_equip;
		atc=FRS[DefenceClient].item_power;
	}
	else{
		eqp=ItemEquipGet(PSP[DefenceClient].item);
		atc=ItemAttackGet(PSP[DefenceClient].item);
	}

	ItemClient=DefenceClient;

	if((eqp==SOUBI_HPITIDETAERU)&&
	  ((pp_rand()%100)<atc)){
		SoubiItemSet(DefenceClient,eqp);
		OSTF[DefenceClient].itemkoraeruflag=1;
	}

	if((PSP[DefenceClient].condition2&CONDITION2_MIGAWARI)==0){	//g肪ꍇ̓`FbNȂ
		if((WTD[WazaNo].battleeffect==101)||		//݂˂
		   (OTF[DefenceClient].koraeruflag)||		//炦
		   //ACeHP1őς̑ʂHP1őς
		   (OSTF[DefenceClient].itemkoraeruflag)){
			if(PSP[DefenceClient].hp<=WazaDamage){
				WazaDamage=PSP[DefenceClient].hp-1;
				if(OTF[DefenceClient].koraeruflag)	//炦
					WazaStatusFlag|=WAZASTATUSFLAG_KORAETA;
				else if(OSTF[DefenceClient].itemkoraeruflag){
					WazaStatusFlag|=WAZASTATUSFLAG_ITEM_KORAETA;
					ItemNo=PSP[DefenceClient].item;
				}
			}
		}
	}
#endif
	return damage;
}

#if 0 
// =================================================================
// void	WS_DAMAGE_LOSS_ONLY
// Tv  : _[WvZŋ߂l85%`100%͈̔͂Œi݂˂`FbNȂj
//   : none
// ߂l: none
// =================================================================
void	WS_DAMAGE_LOSS_ONLY(void)
{
	u16		work;
	u8		eqp;
	u8		atc;

	work=100-(pp_rand()%16);
	if(WazaDamage!=0){
		WazaDamage*=work;
		WazaDamage/=100;
		if(WazaDamage==0) WazaDamage=1;
	}

	if(PSP[DefenceClient].item==ITEM_NAZONOMI){
//		eqp=fld->RamSeed.item_equip;
//		atc=fld->RamSeed.item_power;
		eqp=FRS[DefenceClient].item_equip;
		atc=FRS[DefenceClient].item_power;
	}
	else{
		eqp=ItemEquipGet(PSP[DefenceClient].item);
		atc=ItemAttackGet(PSP[DefenceClient].item);
	}

	ItemClient=DefenceClient;

	if((eqp==SOUBI_HPITIDETAERU)&&
	  ((pp_rand()%100)<atc)){
		SoubiItemSet(DefenceClient,eqp);
		OSTF[DefenceClient].itemkoraeruflag=1;
	}

	if((PSP[DefenceClient].condition2&CONDITION2_MIGAWARI)==0){	//g肪ꍇ̓`FbNȂ
		if((OTF[DefenceClient].koraeruflag)||		//炦
		   //ACeHP1őς̑ʂHP1őς
		   (OSTF[DefenceClient].itemkoraeruflag)){
			if(PSP[DefenceClient].hp<=WazaDamage){
				WazaDamage=PSP[DefenceClient].hp-1;
				if(OTF[DefenceClient].koraeruflag)	//炦
					WazaStatusFlag|=WAZASTATUSFLAG_KORAETA;
				else if(OSTF[DefenceClient].itemkoraeruflag){
					WazaStatusFlag|=WAZASTATUSFLAG_ITEM_KORAETA;
					ItemNo=PSP[DefenceClient].item;
				}
			}
		}
	}
	WazaSeqAdrs++;
}
#endif

//============================================================================================
/**
 *	Zf[^e[ul擾
 *
 * @param[in]	waza_no		擾Zio[
 * @param[in]	id			擾l̎
 */
//============================================================================================
u32	WT_WazaDataParaGet(int waza_no,int id)
{
	u32	ret;
	WAZA_TABLE_DATA wtd;

	WT_WazaDataGet(waza_no,&wtd);

	switch(id){
	case ID_WTD_battleeffect:
		ret=wtd.battleeffect;
		break;
	case ID_WTD_kind:
		ret=wtd.kind;
		break;
	case ID_WTD_damage:
		ret=wtd.damage;
		break;
	case ID_WTD_wazatype:
		ret=wtd.wazatype;
		break;
	case ID_WTD_hitprobability:
		ret=wtd.hitprobability;
		break;
	case ID_WTD_pp:
		ret=wtd.pp;
		break;
	case ID_WTD_addeffect:
		ret=wtd.addeffect;
		break;
	case ID_WTD_attackrange:
		ret=wtd.attackrange;
		break;
	case ID_WTD_attackpri:
		ret=wtd.attackpri;
		break;
	case ID_WTD_flag:
		ret=wtd.flag;
		break;
	case ID_WTD_ap_no:				//ReXgpp[^@As[No
		ret=wtd.condata.ap_no;
		break;
	case ID_WTD_contype:			//ReXgpp[^@ReXgZ^Cv
		ret=wtd.condata.contype;
		break;
	}
	return ret;
}

//============================================================================================
/**
 *	NeBJqbgłme[u
 */
//============================================================================================
static	const	u8	CriticalTable[]={
	16,8,4,3,2
};

//============================================================================================
/**
 *	}ɓ邩ǂ̃`FbN
 *
 * @param[in]	sp				T[op[^\̂̃|C^
 * @param[in]	attack			UClientNo
 * @param[in]	defence			h䑤ClientNo
 * @param[in]	critical_count	NeBJqbg̔{ϓ郏[N
 *
 * @retval	1:_[W{1{	2:_[W{2{
 */
//============================================================================================
int		WT_CriticalCheck(SERVER_PARAM *sp,int attack,int defence,int critical_count)
{
	u16		work;
	u16		item;
	u8		eqp;
	u16		monsno;
	u32		condition2;
	u32		waza_kouka;
	int		ret=1;
	int		speabi;

	item=ST_ServerSoubiItemNoGet(sp,attack);
	eqp=ItemParamGet(item,ITEM_PRM_EQUIP,HEAPID_BATTLE);

	monsno=ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_monsno,NULL);
	condition2=ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_condition2,NULL);
	waza_kouka=ST_ServerPokemonServerParamGet(sp,defence,ID_PSP_waza_kouka,NULL);
	speabi=ST_ServerPokemonServerParamGet(sp,attack,ID_PSP_speabino,NULL);

	work=(((condition2&CONDITION2_KIAIDAME)!=0)*2)+
		 (eqp==SOUBI_KYUUSYONIATARIYASUI)+
		 critical_count+
		 //傤́A}qbgiKPAbv
		 (speabi==TOKUSYU_KYOUUN)+
		 (2*((eqp==SOUBI_RAKKIIDATOKYUUSYONIATARIYASUI)&&(monsno==MONSNO_RAKKII)))+
		 (2*((eqp==SOUBI_KAMONEGIKYUUSYOATARIYASUI)&&(monsno==MONSNO_KAMONEGI)));

	if(work>4){
		work=4;
	}

	if(gf_rand()%CriticalTable[work]==0){
		//JugA[}[AVFA[}[Ƃ͋}ɂȂ
		if((ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_KABUTOAAMAA)==FALSE)&&
		   (ST_ServerKatayaburiTokuseiCheck(sp,attack,defence,TOKUSYU_SHERUAAMAA)==FALSE)&&
		  ((waza_kouka&WAZAKOUKA_NOCRITICAL)==0)){
			ret=2;
		}
	}

	//XiCp[́A}{3{ɂ
	if((ret==2)&&(ST_ServerTokuseiGet(sp,attack)==TOKUSYU_SUNAIPAA)){
		ret=3;
	}

	return ret;
}

//============================================================================================
/**
 *	PPMax擾
 *
 * @param[in]	wazano		擾Zio[
 * @param[in]	maxupcnt	}bNXAbvgp
 *
 * @retval	PPMAX
 */
//============================================================================================
u8	WT_PPMaxGet(u16 wazano,u8 maxupcnt)
{
	u8	ppmax;

	ppmax=WT_WazaDataParaGet(wazano,ID_WTD_pp);
	ppmax+=(ppmax*20*maxupcnt)/100;

	return	ppmax;
}

//============================================================================================
/**
 * ȋZe[u
 */
//============================================================================================
#define	MONOMANE_NG_TBL_END	(0xfffe)
#define	WAZA_OUT_NG_TBL_END	(0xffff)

static	const u16 WazaOutNGTbl[]={
	WAZANO_YUBIWOHURU,			// тӂ
	WAZANO_WARUAGAKI,			// 邠
	WAZANO_SUKETTI,				// XPb`
	WAZANO_MONOMANE,			// ̂܂
	MONOMANE_NG_TBL_END,		// ̂܂˂łȂe[ũGh
	WAZANO_KAUNTAA,				// JE^[
	WAZANO_MIRAAKOOTO,			// ~[R[g
	WAZANO_MAMORU,				// ܂
	WAZANO_MIKIRI,				// ݂
	WAZANO_KORAERU,				// 炦
	WAZANO_MITIDURE,			// ݂Â
	WAZANO_NEGOTO,				// ˂
	WAZANO_DOROBOU,				// ǂڂ
	WAZANO_KONOYUBITOMARE,		// ̂тƂ܂
	WAZANO_YOKODORI,			// 悱ǂ
	WAZANO_TEDASUKE,			// Ă
	WAZANO_HOSIGARU,			// ق
	WAZANO_TORIKKU,				// gbN
	WAZANO_KIAIPANTI,			// p`
	WAZA_OUT_NG_TBL_END
};

//============================================================================================
/**
 *	̂܂˂łZ`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:łȂ@TRUE:ł
 */
//============================================================================================
BOOL	WT_MonomaneNGCheck(u16 waza_no)
{
	int	i;

	i=0;

	while(WazaOutNGTbl[i]!=MONOMANE_NG_TBL_END){
		if(WazaOutNGTbl[i]==waza_no){
			break;
		}
		i++;
	}
	return (WazaOutNGTbl[i]==MONOMANE_NG_TBL_END);
}

//============================================================================================
/**
 *	тӂłZ`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:oȂ@TRUE:o
 */
//============================================================================================
BOOL	WT_YubiwohuruNGCheck(u16 waza_no)
{
	int	i;

	i=0;

	while(WazaOutNGTbl[i]!=WAZA_OUT_NG_TBL_END){
		if(WazaOutNGTbl[i]==waza_no){
			break;
		}
		i++;
	}
	return (WazaOutNGTbl[i]==WAZA_OUT_NG_TBL_END);
}

//============================================================================================
/**
 *	IEŕԂ邩AAR[oZ`FbNpZio[e[u
 */
//============================================================================================

static	const	u16		WazaOumuEncoreNGCheckTable[]={
	WAZANO_HENSIN,
	WAZANO_MONOMANE,
	WAZANO_SUKETTI,
	WAZANO_OUMUGAESI,
	WAZANO_ANKOORU,
	WAZANO_WARUAGAKI,
};

//============================================================================================
/**
 *	IEŕԂ邩AAR[oZ`FbN
 *
 * @param[in]	waza_no		`FbNZio[
 *
 * @retval	FALSE:oȂ@TRUE:o
 */
//============================================================================================
BOOL	WT_OumuEncoreNGCheck(u16 waza_no)
{
	int	i;

	i=0;

	while(i<NELEMS(WazaOumuEncoreNGCheckTable)){
		if(WT_WazaDataParaGet(WazaOumuEncoreNGCheckTable[i],ID_WTD_battleeffect)==
		   WT_WazaDataParaGet(waza_no,ID_WTD_battleeffect)){
			break;
		}
		i++;
	}

	return (i==NELEMS(WazaOumuEncoreNGCheckTable));
}

//============================================================================================
/**
 *							OJȂ֐S
 */
//============================================================================================
//============================================================================================
/**
 *	Ze[u\̃f[^擾
 *
 * @param[in]	waza_no		擾Zio[
 * @param[out]	wtd			擾Zf[^̊i[w
 */
//============================================================================================
static	void	WT_WazaDataGet(int waza_no,WAZA_TABLE_DATA *wtd)
{
	ArchiveDataLoad(wtd,ARC_WAZA_TBL,waza_no);
}

