//============================================================================================
/**
 * @file	friendlist.c
 * @brief	ԃf[^ANZXp\[X
 * @author	tamada GAME FREAK inc.
 * @date	2005.10.27
 */
//============================================================================================

#include "savedata/savedata_def.h"	//SAVEDATAQƂ̂

#include "common.h"

#include "system/gamedata.h"
#include "savedata/savedata.h"


#include "savedata/friendlist.h"
#include "friendlist_local.h"

#include "system/pm_str.h"

#include "gflib/strbuf_family.h"

//============================================================================================
//============================================================================================


//============================================================================================
//
//	Z[uf[^VXeˑ֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԕێ[ÑTCY擾
 * @return	int		TCYioCgPʁj
 */
//----------------------------------------------------------
int FriendList_GetWorkSize(void)
{
	return sizeof(FRIEND_LIST)*FRIENDLIST_MAX;
}

//----------------------------------------------------------
/**
 * @brief	ԕێ[N̊m
 * @param	heapID		mۂȂq[vw
 * @return	FRIEND_LIST	擾[Nւ̃|C^
 */
//----------------------------------------------------------
FRIEND_LIST * FriendList_AllocWork(u32 heapID)
{
	int i;
	FRIEND_LIST * flist;
	flist = sys_AllocMemory(heapID, sizeof(FRIEND_LIST)*FRIENDLIST_MAX);
	
	for(i=0;i<FRIENDLIST_MAX;i++){
		FriendList_Init( flist );
	}
	return flist;
}

//----------------------------------------------------------
/**
 * @brief	FRIEND_LIST̃Rs[
 * @param	from	Rs[FRIEND_LISTւ̃|C^
 * @param	to		Rs[FRIEND_LISTւ̃|C^
 */
//----------------------------------------------------------
void FriendList_Copy(const FRIEND_LIST * from, FRIEND_LIST * to)
{
	MI_CpuCopy8(from, to, sizeof(FRIEND_LIST));
}

//============================================================================================
//
//	FRIEND_LIST̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief		ԃf[^̏
 * @param	my		ԕێ[Nւ̃|C^
 */
//----------------------------------------------------------
extern void FriendList_Init(FRIEND_LIST * flist)
{
	memset(flist, 0, sizeof(FRIEND_LIST));

	flist->name[0] = EOM_;
}

//----------------------------------------------------------
/**
 * @brief	̖OZbg
 * @param	flist		ԕێ[Nւ̃|C^
 * @param	name	Oւ̃|C^
 */
//----------------------------------------------------------
extern void FriendList_SetName(FRIEND_LIST * flist, const STRCODE * name)
{
	int len;

	len = PM_strlen(name);
	GF_ASSERT(len < PERSON_NAME_SIZE + EOM_SIZE);
	PM_strcpy(flist->name, name);
}

//----------------------------------------------------------
/**
 * @brief	̖O擾
 * @param	my		ԕێ[Nւ̃|C^
 * @return	STRCODE		Oւ̃|C^
 */
//----------------------------------------------------------
const STRCODE * FriendList_GetName(const FRIEND_LIST * flist)
{
	return flist->name;
}


//----------------------------------------------------------
/**
 * @brief	̂hcZbg
 * @param	my		ԕێ[Nւ̃|C^
 * @param	id		hcw	
 */
//----------------------------------------------------------
extern void FriendList_SetID(FRIEND_LIST * flist, u32 id)
{
	flist->id = id;
}
//----------------------------------------------------------
/**
 * @brief	̂hc擾
 * @param	my		ԕێ[Nւ̃|C^
 * @return	int		̂hc	
 */
//----------------------------------------------------------
u32 FriendList_GetID(const FRIEND_LIST * flist)
{
	return flist->id;
}


//==============================================================================
/**
 * $brief   qnlo[WR[hԂ
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @retval  u8		0:_C 1:p[
 */
//==============================================================================
u8  FriendList_GetRomCode( const FRIEND_LIST * flist )
{
	return flist->rom_code;
}
//==============================================================================
/**
 * $brief   qnlo[WR[hԂ
 *
 * @param   my		ԕێ[Nւ̃|C^
 *
 * @retval  u8		0:_C 1:p[
 */
//==============================================================================
void  FriendList_SetRomCode( FRIEND_LIST * flist, u8 rom )
{
	flist->rom_code = rom;
}



//==============================================================================
/**
 * $brief   O[vXgIDZbg
 *
 * @param   flist		
 * @param   no		
 * @param   id		
 *
 * @retval  none		
 */
//==============================================================================
void  FriendList_SetGroupListId( FRIEND_LIST * flist , int no, u32 id )
{
	flist->group_id[no] = id;
}

//==============================================================================
/**
 * $brief   O[vXgIDQbg
 *
 * @param   flist		
 * @param   no		
 *
 * @retval  u8		
 */
//==============================================================================
u8  FriendList_GetGroupListId( const FRIEND_LIST * flist , int no )
{
	return flist->group_id[no];
}

//==============================================================================
/**
 * $brief   
 *
 * @param   flist		
 * @param   no		
 * @param   rom		
 *
 * @retval  none		
 */
//==============================================================================
void  FriendList_SetGroupListRomCode( FRIEND_LIST * flist , int no, u8 rom )
{
	flist->group_romcode[no] = rom;
}

//==============================================================================
/**
 * $brief   
 *
 * @param   flist		
 * @param   no		
 *
 * @retval  u8		
 */
//==============================================================================
u8  FriendList_GetGroupListRomCode( const FRIEND_LIST * flist , int no )
{
	return flist->group_romcode[no];
}

//==============================================================================
/**
 * $brief   
 *
 * @param   flist		
 * @param   no		
 * @param   code		
 *
 * @retval  none		
 */
//==============================================================================
void  FriendList_SetGroupListRegion( FRIEND_LIST * flist , int no, u8 code )
{
	flist->group_region[no] = code;
}

//==============================================================================
/**
 * $brief   
 *
 * @param   flist		
 * @param   no		
 *
 * @retval  u8		
 */
//==============================================================================
u8  FriendList_GetGroupListRegion( const FRIEND_LIST * flist , int no )
{
	return flist->group_region[no];
}


//--------------------------------------------------------------------------
/**
 * w̃f[^͂肠O[vɓo^Ă邩
 *
 * @param   id		g[i[hc
 * @param   name	Oi|P)
 *
 * @retval  int		1:v	0:Ȃi͑ł؂j
 *
 *
 */
//--------------------------------------------------------------------------
int FriendList_Check( FRIEND_LIST * list, u32 id, STRCODE *name)
{
	int i;
	for(i=0;i<FRIENDLIST_MAX;i++){
	    if(0 == PM_strcmp(list->name, name) && (list->id == id)){
			return 1;
		}
	}
	return 0;
}


//----------------------------------------------------------
/**
 * @brief	FriendListm̂ǂ𒲂ׂ
 * @param	my		ԕێ[Nւ̃|C^
 * @param	target	̎ԕێ[Nւ̃|C^
 * @return	vTRUE
 */
//----------------------------------------------------------
BOOL FriendList_Compare(const FRIEND_LIST * src, const FRIEND_LIST * des)
{
    if(0 == PM_strcmp(src->name, des->name)){
        if(src->id == des->id){
            return TRUE;
        }
    }
    return FALSE;
}




//--------------------------------------------------------------------------
/**
 * ݐڑ̃o[肠O[vɓo^
 *
 * @param  none
 *
 * @retval  none	
 *
 *
 */
//--------------------------------------------------------------------------
void FriendList_Update( FRIEND_LIST *mylist, FRIEND_LIST *friends, int num, int heapID)
{
	int i,r,count;
	int search[5];
	FRIEND_LIST *tmp;
	
	// e|mہ	
	tmp = sys_AllocMemory(heapID, sizeof(FRIEND_LIST)*FRIENDLIST_MAX);
	for(i=0;i<FRIENDLIST_MAX;i++){
		FriendList_Init(&tmp[i]);
	}

	//̃o[͊ɓo^݂H
	for(i=0;i<num;i++){
		search[i] = -1;
		for(r=0;r<FRIENDLIST_MAX;r++){		//zsearchɎ̂肠O[vƔrʂi[(-1F,0`:L)
			if(FriendList_Compare(&mylist[r], &friends[i])){
				search[i] = r;
			}
		}
	}
	
	//ʐMĂ郁o[o^
	count=0;
	for(i=0;i<num;i++){
		tmp[count] = friends[i];
		if(search[i]>=0){
			mylist[search[i]].name[0] = EOM_;			//o^ς݂̏ꍇ͌̃e[u疼OĂ܂
		}
		count++;
	}
	
	//o[XV
	for(i=0;i<FRIENDLIST_MAX;i++){
		if(mylist[i].name[0]!=EOM_){			//ږȂ΍XV
			tmp[count] = mylist[i];
			count++;
			if(count>=FRIENDLIST_MAX) break;				//MAX𒴂o^I
		}
	}
	memcpy(mylist,tmp,sizeof(FRIEND_LIST)*FRIENDLIST_MAX);		//e|猳̏ꏊɍXV
	
	
	sys_FreeMemoryEz(tmp);		//e|
}



//==============================================================================
/**
 * $brief   wID͒m荇ID`FbN
 *
 * @param   mylist		
 * @param   id		
 *
 * @retval  int		
 */
//==============================================================================
int FriendList_IdFullCheck( FRIEND_LIST *mylist, u32 id )
{
	int i,r;
	for(i=0;i<FRIENDLIST_MAX;i++){
		// ڂ̒m荇H
		if(mylist[i].id==id){
			return DIRECT_FRIEND;
		}
		
		// ԐړIȒm荇H
		for(r=0;r<FRIENDLIST_FRIEND_MAX;r++){
			if(mylist[i].group_id[r]==id){
				return INDIRECT_FRIEND;
			}
		}
	}
	return 0;	// m荇Ȃ
}


//============================================================================================
//	fobOp
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	fobOpFԃZbg
 * @param	my		ԕێ[Nւ̃|C^
 * @param	name	Oւ̃|C^
 * @param	id		IDw
 */
//----------------------------------------------------------
void Debug_FriendList_Make(FRIEND_LIST * flist, const STRCODE * name, int id )
{
	FriendList_SetName( flist, name);
	FriendList_SetID( flist, id);
}

