//============================================================================================
/**
 * @file	gimmickwork.c
 * @brief	}bvŗL̎d|p[N߂̃\[X
 * @author	tamada
 * @date	2006.02.01
 *
 */
//============================================================================================

#include "gflib/assert.h"
#include "gflib/system.h"
#include "gimmickwork_local.h"
#include "savedata/gimmickwork.h"

//============================================================================================
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	d|p[ÑTCY擾
 * @return	int		TCY
 */
//---------------------------------------------------------------------------
int GIMMICKWORK_GetWorkSize(void)
{
	return sizeof(GIMMICKWORK);
}

//---------------------------------------------------------------------------
/**
 * @brief	d|p[N̏
 * @param	gimmick		d|[Nւ̃|C^
 */
//---------------------------------------------------------------------------
void GIMMICKWORK_Init(GIMMICKWORK * gimmick)
{
	MI_CpuClear8(gimmick, sizeof(GIMMICKWORK));
}

//---------------------------------------------------------------------------
/**
 * @brief	d|p[N̍ŏ̔F؏
 * @param	gimmick		d|[Nւ̃|C^
 * @param	gimmick_id		d|ID
 */
//---------------------------------------------------------------------------
void * GIMMICKWORK_Assign(GIMMICKWORK * gimmick, int gimmick_id)
{
	GIMMICKWORK_Init(gimmick);
	gimmick->id = gimmick_id;
	return gimmick->work;
}

//---------------------------------------------------------------------------
/**
 * @brief	d|p[N̎擾
 * @param	gimmick		d|[Nւ̃|C^
 * @param	gimmick_id		gpTCY
 */
//---------------------------------------------------------------------------
void * GIMMICKWORK_Get(GIMMICKWORK * gimmick, int gimmick_id)
{
	GF_ASSERT(gimmick->id == gimmick_id);
	return gimmick->work;
}

//---------------------------------------------------------------------------
/**
 * @brief	d|p[NID擾
 * @param	gimmick		d|[Nւ̃|C^
 * @return	int			ID
 */
//---------------------------------------------------------------------------
int GIMMICKWORK_GetAssignID(const GIMMICKWORK * gimmick)
{
	return gimmick->id;
}

