//=============================================================================
/**
 * @file	honeytree_data.c
 * @bfief	hGJEgpZ[uf[^ANZX֘A
 * @author	Nozomu Saito
 *
 *
 */
//=============================================================================
#include "common.h"
#include "savedata/savedata.h"
#include "savedata/honeytree_data.h"

typedef struct HONEY_TREE_tag
{
	u8 TreeNo;			//OGJEg؂̃io[
	HONEY_DATA HoneyData[HONEY_TREE_MAX];
}HONEY_TREE;

//==============================================================================
/**
 * Z[uf[^TCY擾
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
int HTSave_GetSaveDataSize(void)
{
	return sizeof(HONEY_TREE);
}

//==============================================================================
/**
 * Z[uf[^
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_InitSaveData(HT_PTR outHoneyTree)
{
	int i;
	memset( outHoneyTree, 0, sizeof(HONEY_TREE) );
	outHoneyTree->TreeNo = HONEY_TREE_MAX;
	for(i=0;i<HONEY_TREE_MAX;i++){
		outHoneyTree->HoneyData[i].Time = 0;
		//outHoneyTree->HoneyData[i].State = HONEY_SPREAD_OK;
		outHoneyTree->HoneyData[i].TblMonsNo = 0;
		outHoneyTree->HoneyData[i].TblNo = 0;
		outHoneyTree->HoneyData[i].RareLv = 0;
		outHoneyTree->HoneyData[i].SwayLv = 0;
	}
}

//==============================================================================
/**
 * Z[uf[^擪|C^擾
 *
 * @param	fsys		tB[hVXe|C^
 *
 * @return	none
 */
//==============================================================================
HT_PTR HTSave_GetHoneyTree(SAVEDATA * sv)
{
	return SaveData_Get(sv, GMDATA_ID_HONEYTREE);
}

//==============================================================================
/**
 * ؂̎Ԏ擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
const int HTSave_GetTime(HT_PTR inPtr,  const u8 inTreeNo)
{
	return inPtr->HoneyData[inTreeNo].Time;
}

//==============================================================================
/**
 * e[uX^[ԍ擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
const u8 HTSave_GetTblMonsNo(HT_PTR inPtr, const u8 inTreeNo)
{
	return inPtr->HoneyData[inTreeNo].TblMonsNo;
}

//==============================================================================
/**
 * e[uԍ擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
const u8 HTSave_GetTblNo(HT_PTR inPtr, const u8 inTreeNo)
{
	return inPtr->HoneyData[inTreeNo].TblNo;
}

//==============================================================================
/**
 * e[uAx̎擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
const u8 HTSave_GetRareLv(HT_PTR inPtr, const u8 inTreeNo)
{
	return inPtr->HoneyData[inTreeNo].RareLv;
}

//==============================================================================
/**
 * hx擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
const u8 HTSave_GetSwayLv(HT_PTR inPtr, const u8 inTreeNo)
{
	return inPtr->HoneyData[inTreeNo].SwayLv;
}

//==============================================================================
/**
 * OGJEg؂̃io[擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
const int HTSave_GetBeforeTreeNo(HT_PTR inPtr)
{
	return inPtr->TreeNo;
}


//==============================================================================
/**
 * ؂̎Ԏ擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_SetTime(const u8 inTime, const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->HoneyData[inTreeNo].Time = inTime;
}

//==============================================================================
/**
 * e[uX^[ԍ擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_SetTblMonsNo(const u8 inTblMonsNo, const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->HoneyData[inTreeNo].TblMonsNo = inTblMonsNo;
}

//==============================================================================
/**
 * e[uԍ擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_SetTblNo(const u8 inTblNo, const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->HoneyData[inTreeNo].TblNo = inTblNo;
}

//==============================================================================
/**
 * e[uAx̎擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_SetRareLv(const u8 inRareLv, const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->HoneyData[inTreeNo].RareLv = inRareLv;
}

//==============================================================================
/**
 * hx擾
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void  HTSave_SetSwayLv(const u8 inSwayLv, const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->HoneyData[inTreeNo].SwayLv = inSwayLv;
}

//==============================================================================
/**
 * OGJEg؂̃io[Zbg
 *
 * @param	inPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
void HTSave_SetBeforeTreeNo(const u8 inTreeNo, HT_PTR outPtr)
{
	outPtr->TreeNo = inTreeNo;
}

//==============================================================================
/**
 * ؃f[^|C^̎擾
 *
 * @param	outPtr		hGJEgf[^|C^
 *
 * @return	none
 */
//==============================================================================
HONEY_DATA *HTSave_GetHoneyDataPtr(const u8 inTreeNo, HT_PTR outPtr)
{
	HONEY_DATA *data;
	data = &outPtr->HoneyData[inTreeNo];

	return data;
}
