//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *
 *	@file		imageclip_data.c
 *	@brief		C[WNbvZ[uf[^
 *	@author		tomoya takahashi
 *	@data		2006.02.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "include/savedata/savedata_def.h"	//SAVEDATAQƂ̂
#include "include/savedata/savedata.h"
#include "include/gflib/system.h"
#include "include/gflib/assert.h"
#include <string.h>

#define	__IMAGECLIP_DATA_H_GLOBAL
#include "include/savedata/imageclip_data.h"


#include "include/gflib/strbuf_family.h"

//-----------------------------------------------------------------------------
/**
 *					R[fBOK
 *		֐
 *				Pڂ͑啶ȍ~͏ɂ
 *		ϐ
 *				Eϐ
 *						constɂ c_ t
 *						staticɂ s_ t
 *						|C^ɂ p_ t
 *						Sč킳 csp_ ƂȂ
 *				EO[oϐ
 *						Pڂ͑啶
 *				E֐ϐ
 *						ƁhQhƐgp ֐̈Ɠ
*/
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					\̐錾
*/
//-----------------------------------------------------------------------------
//-------------------------------------
//	zZ[uf[^[N
//=====================================
typedef struct _IMC_ONE_SAVEDATA{
	u16	monsno;						///<X^[io[
	u16 nickname[ IMC_SAVEDATA_NICKNAME_STR_NUM ];	///<jbNl[
	u16 oyaname[ IMC_SAVEDATA_OYANAME_STR_NUM ];	///<jbNl[
	u32 personal_rnd;				///<|P̌
	u32 idno;						///<IDNo
	s8 poke_pri;					///<|PD揇
	u8 poke_x;						///<|PW
	u8 poke_y;						///<|PW

	u8 accessory_no[ IMC_RBOX_OBJ_MAX ];	///<ANZTio[
	u8 accessory_x[ IMC_RBOX_OBJ_MAX ];		///<ANZTW
	u8 accessory_y[ IMC_RBOX_OBJ_MAX ];		///<ANZTW
	s8 accessory_pri[ IMC_RBOX_OBJ_MAX ];	///<ANZT\D
	u32 accessory_set_msk;					///<i[ANZT[}XN
	u8 bg_id;								///<bgio[	
} ;

//-------------------------------------
//	Z[uf[^
//=====================================
struct _IMC_SAVEDATA{
	IMC_ONE_SAVEDATA imc_savedata[ IMC_SAVEDATA_SAVENUM ];	///<savef[^
	u32 imc_save_set_msk;			///<Z[u}XN
};


//-----------------------------------------------------------------------------
/**
 *					vg^Cv錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static inline void clean_one_savedata( IMC_ONE_SAVEDATA* wk )
{
	memset( wk, 0, sizeof(IMC_ONE_SAVEDATA) );
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
static inline void get_poke_mat( IMC_POKE* ip, u8* x, u8* y, s8* pri )
{
	int gx, gy;
	int gpri;

	IMC_POKE_MatrixGet( ip, &gx, &gy );
	gpri = IMC_POKE_DrawPriorityGet( ip );
	GF_ASSERT( gx < 256 );
	GF_ASSERT( gy < 256 );
	GF_ASSERT( gpri > -128 );

	*x = gx;
	*y = gy;
	*pri = gpri;
}

//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbv[N̏
 *
 *	@param	iw	C[WNbv[N
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_Init(IMC_SAVEDATA * iw)
{
	memset( iw, 0, sizeof(IMC_SAVEDATA) );
}


//----------------------------------------------------------
//	Z[uf[^VXeˑ֐
//----------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvZ[uf[^[NTCY̎擾
 *
 *	@param	none
 *
 *	@return	[NTCY
 */
//-----------------------------------------------------------------------------
int ImcSaveData_GetWorkSize(void)
{
	return sizeof(IMC_SAVEDATA);
}

//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvp[N̐
 *
 *	@param	heapID		q[vID
 *
 *	@return	C[WNbv[Ñ|C^
 */
//-----------------------------------------------------------------------------
IMC_SAVEDATA * ImcSaveData_AllocWork(u32 heapID)
{
	IMC_SAVEDATA * iw;
	iw = sys_AllocMemory(heapID, sizeof(IMC_SAVEDATA));
	ImcSaveData_Init(iw);
	return iw;
}



//-----------------------------------------------------------------------------
//	[Nf[^ǂݏ
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief	C[WNbvf[^1擾
 *
 *	@param	iw		C[WNbv[N
 *	@param	no		擾CfbNX
 *
 *	@return	1̃f[^
 */
//-----------------------------------------------------------------------------
IMC_ONE_SAVEDATA* ImcSaveData_GetOneSaveData(IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_SAVENUM );		///<ző吔`FbN

	return &iw->imc_savedata[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃Z[uf[^̈ɃZ[uĂ邩
 *
 *	@param	iw	C[WNbv[N
 *	@param	no	`FbNCfbNX
 *
 *	@retval	TRUE	Z[uς
 *	@retval	FALSE	Z[
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckOneSaveData(const IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_SAVENUM );		///<ző吔`FbN

	// Z[u`FbN
	if( iw->imc_save_set_msk & (1<<no) ){
		return TRUE;
	}

	return FALSE;
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[utOݒ肷
 *
 *	@param	iw	C[WNbv[N
 *	@param	no	CfbNX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetComplateFlagOneSaveData(IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_SAVENUM );		///<ző吔`FbN
	GF_ASSERT( (iw->imc_save_set_msk & (1<<no)) == FALSE );	///<Z[uݒ`FbN

	iw->imc_save_set_msk |= (1<<no);
}

//----------------------------------------------------------------------------
/**
 *	@brief	Z[uf[^
 *
 *	@param	iw		C[WNbv[N
 *	@param	no		CfbNX
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_ClaenOneSaveData(IMC_SAVEDATA* iw, int no)
{
	GF_ASSERT( no < IMC_SAVEDATA_SAVENUM );		///<ző吔`FbN

	// }XN̏
	iw->imc_save_set_msk &= !(1<<no);

	// [N̏
	clean_one_savedata( &iw->imc_savedata[no] );
}
	


//----------------------------------------------------------------------------
/**
 *	@brief	|Pf[^o^
 *
 *	@param	iow		C[WNbv[N
 *	@param	pp		|Pp[^
 *	@param	ip		C[WNbv|Pf[^
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetPokeData(IMC_ONE_SAVEDATA* iow, POKEMON_PARAM* pp, IMC_POKE* ip)
{
	iow->monsno   = PokeParaGet(pp, ID_PARA_monsno, NULL);
	PokeParaGet(pp, ID_PARA_nickname, iow->nickname);
	PokeParaGet(pp, ID_PARA_oyaname, iow->oyaname);
	iow->personal_rnd = PokeParaGet(pp, ID_PARA_power_rnd, NULL );
	iow->idno = PokeParaGet(pp, ID_PARA_id_no, NULL);
	get_poke_mat( ip, &iow->poke_x, &iow->poke_y, &iow->poke_pri );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTf[^ݒ
 *
 *	@param	iow		C[WNbv[N	
 *	@param	ao		ANZT[f[^
 *	@param	no		ANZT[io[
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetAcceData(IMC_ONE_SAVEDATA* iow, const IMC_ACCESSORIE_OBJ* ao, int no)
{
	NNSG2dSVec2 mat = SWSP_GetSpritePos( ao->drawObj );
	int pri = SWSP_GetSpritePriority( ao->drawObj );
	
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<ző吔`FbN
	GF_ASSERT( mat.x < 256 );		// u8ɓ悤
	GF_ASSERT( mat.y < 256 );		// u8ɓ悤
	GF_ASSERT( pri > -128 );		// u8ɓ悤
	GF_ASSERT( !(iow->accessory_set_msk & (1 << no)) );	///<do^`FbN

	
	iow->accessory_no[ no ] = ao->accessorie_no;
	iow->accessory_x[ no ] = mat.x;
	iow->accessory_y[ no ] = mat.y;
	iow->accessory_pri[ no ] = pri;

	// }XNݒ
	iow->accessory_set_msk |= 1 << no;
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGID̐ݒ
 *
 *	@param	iow		C[WNbv[N
 *	@param	bg		BGID
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_SetBgId(IMC_ONE_SAVEDATA* iow, u8 bg)
{
	iow->bg_id = bg;
}

//----------------------------------------------------------------------------
/**
 *	@brief	̃CfbNX̃ANZTo^Ă邩`FbN
 *
 *	@param	iow		PZ[uf[^
 *	@param	no		ANZTi[zCfbNX
 *
 *	@retval	TRUE	o^ς
 *	@retval	FALSE	o^
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckAcceDataSet(IMC_ONE_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<ző吔`FbN

	return iow->accessory_set_msk & (1 << no);
}



//----------------------------------------------------------------------------
/**
 *	@brief	X^[io[擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	X^[io[
 */
//-----------------------------------------------------------------------------
u16 ImcSaveData_GetPokeMonsNo(const IMC_ONE_SAVEDATA* iow)
{
	return iow->monsno;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PjbNl[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	i[obt@@vf@IMC_SAVEDATA_STRBUF_NUMKv
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetPokeNickName(const IMC_ONE_SAVEDATA* iow, STRBUF* pbuff)
{
	STRBUF_SetStringCode(pbuff, iow->nickname);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P̐el[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	pbuff	i[obt@@vf@IMC_SAVEDATA_STRBUF_NUMKv
 *
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetPokeOyaName(const IMC_ONE_SAVEDATA* iow, STRBUF* pbuff)
{
	STRBUF_SetStringCode(pbuff, iow->oyaname);
}

//----------------------------------------------------------------------------
/**
 *	@brief	|P擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetPokeRnd(const IMC_ONE_SAVEDATA* iow)
{
	return iow->personal_rnd;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|PIDio[擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	IDNo
 */
//-----------------------------------------------------------------------------
u32 ImcSaveData_GetPokeIDNo(const IMC_ONE_SAVEDATA* iow)
{
	return iow->idno;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbND揇ʎ擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetPokePri(const IMC_ONE_SAVEDATA* iow)
{
	return iow->poke_pri;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbN\W擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	XW
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetPokeX(const IMC_ONE_SAVEDATA* iow)
{
	return iow->poke_x;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|POtBbNW擾
 *
 *	@param	iow		C[WNbv[N
 *
 *	@return	W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetPokeY(const IMC_ONE_SAVEDATA* iow)
{
	return iow->poke_y;
}

//----------------------------------------------------------------------------
/**
 *	@brief	|Pp[^擾
 *
 *	@param	iow		C[WNbvZ[uf[^
 *	@param	pp		|Pp[^
 *	
 *	@return	none
 */
//-----------------------------------------------------------------------------
void ImcSaveData_GetPokePara(const IMC_ONE_SAVEDATA* iow, POKEMON_PARAM* pp)
{
	PokeParaSet( pp, iow->monsno, 0, 0, RND_SET, iow->personal_rnd, ID_SET, iow->idno );
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTf[^ݒ肳Ă邩`FbN
 *
 *	@param	iow		ANZTZ[uf[^
 *	@param	no		ANZTzCfbNX
 *
 *	@retval	TRUE	ݒ肳Ă
 *	@retval	FALSE	ݒ肳ĂȂ
 */
//-----------------------------------------------------------------------------
BOOL ImcSaveData_CheckAcceSet(const IMC_ONE_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<1f[^ANZTő吔`FbN
	return iow->accessory_set_msk & (1 << no);
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTio[擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *	
 *	@return	ANZTio[
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetAcceNo(const IMC_ONE_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN

	return iow->accessory_no[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTXW擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *	
 *	@return	ANZT\W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetAcceMatX(const IMC_ONE_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN

	return iow->accessory_x[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZTW擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	ANZT\W
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetAcceMatY(const IMC_ONE_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN

	return iow->accessory_y[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	ANZT\D揇ʎ擾
 *
 *	@param	iow		C[WNbv[N
 *	@param	no		ANZTCfbNX
 *
 *	@return	ANZT\D揇
 */
//-----------------------------------------------------------------------------
s8 ImcSaveData_GetAccePri(const IMC_ONE_SAVEDATA* iow, int no)
{
	GF_ASSERT( no < IMC_RBOX_OBJ_MAX );		///<1f[^ANZTő吔`FbN
	GF_ASSERT( iow->accessory_set_msk & (1 << no) );	///<ANZTf[^i[ς݃`FbN

	return iow->accessory_pri[ no ];
}

//----------------------------------------------------------------------------
/**
 *	@brief	BGID擾
 *	
 *	@param	iow		C[WNbv[N
 *
 *	@return	BGID
 */
//-----------------------------------------------------------------------------
u8 ImcSaveData_GetBgId(const IMC_ONE_SAVEDATA* iow)
{
	return iow->bg_id;
}
	


//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//----------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	C[WNbv[Nւ̃|C^
 */
//----------------------------------------------------------
IMC_SAVEDATA * SaveData_GetImcSaveData(SAVEDATA * sv)
{
	IMC_SAVEDATA * is = NULL;
	is = SaveData_Get(sv, GMDATA_ID_IMAGECLIPDATA);
	return is;
}

//----------------------------------------------------------
//	fobOp
//----------------------------------------------------------
void Debug_ImcSaveData_Make(IMC_SAVEDATA * iw, int option)
{
}



