//============================================================================================
/**
 * @file	misc.c
 * @brief	ރZ[uf[^̃ANZX
 * @author	tamada	GAME FREAK Inc.
 * @date	2006.01.26
 *
 * ނĂȂZ[uf[^͂Ƃ肠ɒǉB
 * AvP[VxAZ[uf[^ANZX֐x
 * MISC\̂oƂ͂łȂB
 * MISC\̂̓oɎ\̂ւ̃ANZX񋟂邾
 * C^[tFCXƂċ@\ĂB
 *
 * Z[uf[^ƂĂ̐ƒ`ł悤ɂȂ_ŁA
 * ̃Z[u\̂͂ƕʃ\[Xɐ؂蕪邱ƂɂȂB
 */
//============================================================================================

#include "common.h"
#include "gflib/system.h"

#include "system/gamedata.h"

#include "savedata/savedata.h"

#include "misc_local.h"

#include "config_local.h"
#include "savedata/config.h"
#include "mystatus_local.h"
#include "savedata/mystatus.h"
#include "seedbed_local.h"
#include "savedata/seedbed.h"
#include "gimmickwork_local.h"
#include "savedata/gimmickwork.h"
#include "coin_local.h"
#include "savedata/coin.h"



//============================================================================================
//============================================================================================

//---------------------------------------------------------------------------
/**
 * @brief	MISC\̂̒`
 *
 * L̂悤ȃZ[uf[^ubŃAMISC̃o[ƂĊmۂB
 * -ǂɕނׂAfɖ́B͕ނۗĂ
 * -K͂Â߂ɃZ[uubNmۂ̂Ȃ
 */
//---------------------------------------------------------------------------
struct _MISC {
	CONFIG config;
	MYSTATUS mystatus;
	SEEDBED seedbed[SEEDBED_MAX];
	GIMMICKWORK gimmick;
	COIN mycoin;
};

//============================================================================================
//============================================================================================

//---------------------------------------------------------------------------
/**
 * @brief	MISC\̂̃TCY擾
 * @return	int		MISC\̂̃TCY
 */
//---------------------------------------------------------------------------
int MISC_GetWorkSize(void)
{
	return sizeof(MISC);
}

//---------------------------------------------------------------------------
/**
 * @brief	MISCp[N̊m
 * @param	heapID		mۂq[vID
 * @return	MISC^̊mۂւ̃|C^
 */
//---------------------------------------------------------------------------
MISC * MISC_AllocWork(u32 heapID)
{
	MISC * m;
	m = sys_AllocMemory(heapID, sizeof(MISC));
	MISC_Init(m);
	return m;
}

//---------------------------------------------------------------------------
/**
 */
//---------------------------------------------------------------------------
void MISC_Copy(const MISC * from, MISC * to)
{
	MI_CpuCopy8(from ,to, sizeof(MISC));
}

//============================================================================================
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	FXZ[uf[^ێ[N̏
 * @param	misc	FXZ[uf[^ێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
void MISC_Init(MISC * misc)
{
	memset(misc, 0, sizeof(MISC));
	/* ȉɌʕ̏ */
	CONFIG_Init(&misc->config);
	MyStatus_Init(&misc->mystatus);
	SEEDBED_Init(misc->seedbed);
	GIMMICKWORK_Init(&misc->gimmick);
	COIN_Init(&misc->mycoin);
}

//============================================================================================
//
//	Z[uf[^擾̂߂̊֐
//
//============================================================================================
//---------------------------------------------------------------------------
/**
 * @brief	ԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	MYSTATUS	ԕێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
MYSTATUS * SaveData_GetMyStatus(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return &misc->mystatus;
}

//---------------------------------------------------------------------------
/**
 * @brief	ݒf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	CONFIG		ݒێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
CONFIG * SaveData_GetConfig(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return &misc->config;
}

//---------------------------------------------------------------------------
/**
 * @brief	̂ݏԃf[^ւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	CONFIG		ݒێ[Nւ̃|C^
 */
//---------------------------------------------------------------------------
SEEDBED * SaveData_GetSeedBed(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return misc->seedbed;
}

//---------------------------------------------------------------------------
/**
 * @brief	}bvŗL̎d|[Nւ̃|C^擾
 * @param	sv			Z[uf[^ێ[Nւ̃|C^
 * @return	GIMMICKWORK	d|p[Nւ̃|C^
 */
//---------------------------------------------------------------------------
GIMMICKWORK * SaveData_GetGimmickWork(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return &misc->gimmick;
}

//---------------------------------------------------------------------------
//---------------------------------------------------------------------------
COIN * SaveData_GetMyCoin(SAVEDATA * sv)
{
	MISC * misc;
	misc = SaveData_Get(sv, GMDATA_ID_MISC);
	return &misc->mycoin;
}

