/**
 *	@file	poruto.c
 *	@brief	|gZ[uf[^ 
 *	@author	Miyuki Iwasawa
 *	@date	06.2.28
 */

#include "common.h"
#include "savedata/savedata.h"
#include "savedata/poruto.h"
#include "savedata/poruto_util.h"
#include "savedata/poruto_local.h"

/**
 *	@brief	|gf[^TCY擾
 */
int PorutoData_GetWorkSize(void)
{
	return sizeof(PORUTO_DATA);
}

/**
 *	@brief	̃|gf[^LǂԂ
 */
BOOL PorutoData_IsEnable(PORUTO_DATA* dat)
{
	if(dat->flavor == PORUTO_FLAVOR_NULL){
		return FALSE;
	}
	return TRUE;
}

/**
 *	@brief	|gf[^NA
 */
void PorutoData_Clear(PORUTO_DATA* dat)
{
	dat->flavor = PORUTO_FLAVOR_NULL;
	dat->spicy = 0;
	dat->astringent = 0;
	dat->sweet = 0;
	dat->bitter = 0;
	dat->sour = 0;
	dat->taste = 0;
	dat->pad_dmy = 0;
}

/**
 *	@brief	|gf[^[N쐬
 */
PORUTO_DATA* PorutoData_AllocWork(int heapID)
{
	PORUTO_DATA* dat;

	dat = sys_AllocMemoryLo(heapID,sizeof(PORUTO_DATA));
	PorutoData_Clear(dat);
	return dat;
}

/**
 *	@brief	|gf[^Rs[
 */
void PorutoData_Copy(PORUTO_DATA* src,PORUTO_DATA* dest)
{
	dest->flavor = src->flavor;
	dest->spicy = src->spicy;
	dest->astringent = src->astringent;
	dest->sweet = src->sweet;
	dest->bitter = src->bitter;
	dest->sour = src->sour;
	dest->taste = src->taste;
	dest->pad_dmy = src->pad_dmy;
}

/**
 *	@brief	|g̃p[^擾
 *
 *	@param	dat
 *	@param	id	enum PORUTO_PARAID^(poruto_def.hQ)
 *
 *	@return	u8:擾p[^
 */
u8 PorutoData_GetParam(PORUTO_DATA* dat,PORUTO_PARAID id)
{
	switch(id){
	case PORUTO_PARAID_FLAVOR:
		return dat->flavor;
	case PORUTO_PARAID_SPICY:
		return dat->spicy;
	case PORUTO_PARAID_ASTR:
		return dat->astringent;
	case PORUTO_PARAID_SWEET:
		return dat->sweet;
	case PORUTO_PARAID_BITTER:
		return dat->bitter;
	case PORUTO_PARAID_SOUR:
		return dat->sour;
	case PORUTO_PARAID_TASTE:
	default:
		return dat->taste;
	}
}
	
/**
 *	@brief	|g̃p[^Zbg
 *
 *	@param	dat
 *	@param	value	Zbgf[^
 *	@param	id	enum PORUTO_PARAID^(poruto_def.hQ)
 *
 */
void PorutoData_SetParam(PORUTO_DATA* dat,u8 valid,PORUTO_PARAID id)
{
	if(id == PORUTO_PARAID_FLAVOR){
		if(valid < PORUTO_FLAVOR_MAX){
			dat->flavor = valid;
		}
		return;	
	}
	if(valid >= PORUTO_PARAM_MAX){
		return;
	}
	switch(id){
	case PORUTO_PARAID_SPICY:
		dat->spicy = valid;
		break;
	case PORUTO_PARAID_ASTR:
		dat->astringent = valid;
		break;
	case PORUTO_PARAID_SWEET:
		dat->sweet = valid;
		break;
	case PORUTO_PARAID_BITTER:
		dat->bitter = valid;
		break;
	case PORUTO_PARAID_SOUR:
		dat->sour = valid;
		break;
	case PORUTO_PARAID_TASTE:
		dat->taste = valid;
		break;
	default:
		break;
	}
	return;
}

/**
 *	@brief	|gp[^擾(z)
 *
 *	ĂяoŃf[^̎擾ꏊpӂo[W
 *	@u8[PORUTO_PARAID_NUM] ̃GAKv
 */
void PorutoData_GetParamArray(PORUTO_DATA* dat,u8* array)
{
	array[PORUTO_PARAID_FLAVOR] = dat->flavor;
	array[PORUTO_PARAID_SPICY] = dat->spicy;
	array[PORUTO_PARAID_ASTR] = dat->astringent;
	array[PORUTO_PARAID_SWEET] = dat->sweet;
	array[PORUTO_PARAID_BITTER] = dat->bitter;
	array[PORUTO_PARAID_SOUR] = dat->sour;
	array[PORUTO_PARAID_TASTE] = dat->taste;
}

/**
 *	@brief	|gp[^擾(z,m۔)
 *
 *	֐ŕKvȃobt@擾ĕԂo[W
 *	@ĂяoŖIȃKv
 */
u8* PorutoData_GetParamArrayMem(PORUTO_DATA* dat,int heapID)
{
	u8* array;

	array = sys_AllocMemory(heapID,PORUTO_PARAID_NUM);
	array[PORUTO_PARAID_FLAVOR] = dat->flavor;
	array[PORUTO_PARAID_SPICY] = dat->spicy;
	array[PORUTO_PARAID_ASTR] = dat->astringent;
	array[PORUTO_PARAID_SWEET] = dat->sweet;
	array[PORUTO_PARAID_BITTER] = dat->bitter;
	array[PORUTO_PARAID_SOUR] = dat->sour;
	array[PORUTO_PARAID_TASTE] = dat->taste;
	return array;
}

/**
 *	@brief	|g̃x擾
 */
u8 PorutoData_GetLevel(PORUTO_DATA* dat)
{
	u8	type = 0;
	u8	level = 0;

	type = dat->flavor / PORUTO_FTYPE_NUM;
	switch(type){
	case PORUTO_FTYPE_SPICY:
		level = dat->spicy;
		break;
	case PORUTO_FTYPE_ASTR:
		level = dat->astringent;
		break;
	case PORUTO_FTYPE_SWEET:
		level = dat->sweet;
		break;
	case PORUTO_FTYPE_BITTER:
		level = dat->bitter;
		break;
	case PORUTO_FTYPE_SOUR:
		level = dat->sour;
		break;
	case PORUTO_FTYPE_MIX:
	default:
		//~bNXn͈ԍp[^T
		level = dat->spicy;
		if(level < dat->astringent){
			level = dat->astringent;
		}
		if(level < dat->sweet){
			level = dat->sweet;
		}
		if(level < dat->bitter){
			level = dat->bitter;
		}
		if(level < dat->sour){
			level = dat->sour;
		}
		break;
	}
	if(level > PORUTO_PARAM_VMAX){
		return PORUTO_PARAM_VMAX;
	}
	return level;
}

//=================================================================
// |gZ[uf[^ubNANZXn
//=================================================================

/**
 *	@brief	Z[uf[^ubNւ̃|C^擾
 */
PORUTO_BLOCK* SaveData_GetPorutoBlock(SAVEDATA* sv)
{
	return SaveData_Get(sv,GMDATA_ID_PORUTODATA);
}

/**
 *	@brief	|gZ[uf[^TCY擾
 */
int PORUTO_GetSaveWorkSize(void)
{
	return sizeof(PORUTO_DATA)*PORUTO_STOCK_MAX;
}

/**
 *	@brief	|gf[^z񏉊
 */
void PORUTO_Init(PORUTO_BLOCK* block)
{
	int i = 0;
	for(i = 0;i < PORUTO_STOCK_MAX;i++){
		PorutoData_Clear(&block->poruto[i]);
	}
}

/**
 *	@brief	|gZ[uf[^̋󂫗̈T
 *
 *	@retval	PORUTO_DATA_NULL	󂫗̈悪Ȃ
 *	@retval "̑"			󂫗̈IndexNo
 */
u16 PORUTO_SearchNullData(PORUTO_BLOCK* block)
{
	u16 i;

	for(i = 0;i < PORUTO_STOCK_MAX;i++){
		if(block->poruto[i].flavor != PORUTO_FLAVOR_NULL){
			return i;
		}
	}
	return PORUTO_DATA_NULL;
}

/**
 *	@brief	|gf[^Z[uf[^󂫗̈ɒǉ
 *
 *	@retval	PORUTO_DATA_NULL	󂫗̈悪ȂĒǉłȂ
 *	@retval "̑"			ǉ̈index
 */
u16 PORUTO_AddData(PORUTO_BLOCK* block,PORUTO_DATA* dat) 
{
	u16	idx = PORUTO_SearchNullData(block);

	if(idx == PORUTO_DATA_NULL){
		return idx;
	}
	//ǉ
	PorutoData_Copy(dat,&block->poruto[idx]);
	return idx;
}

/**
 *	@brief	|gf[^Z[uf[^폜(indexw)
 *
 */
BOOL PORUTO_DelData(PORUTO_BLOCK* block,u16 idx) 
{
	if(idx >= PORUTO_STOCK_MAX){
		return FALSE;
	}
	//폜
	PorutoData_Clear(&block->poruto[idx]);
	return TRUE;
}

/**
 *	@brief	|gf[^Z[uf[^擾(indexw)
 *
 *	nꂽPORUTO_DATA\̌^̈ցAZ[uf[^Rs[ĕԂ
 */
void PORUTO_GetData(PORUTO_BLOCK* block,u16 idx,PORUTO_DATA* dest)
{
	if(idx >= PORUTO_STOCK_MAX){
		PorutoData_Clear(dest);
		return;
	}
	//擾
	PorutoData_Copy(&block->poruto[idx],dest);
	return ;
}

/**
 *	@brief	|gf[^Z[uf[^擾(indexw/m۔)
 *
 *	PORUTO_DATA\̌^̈mۂAZ[uf[^Rs[ĕԂ
 *	@ĂяoIɉ邱ƁI
 */
PORUTO_DATA* PORUTO_GetDataAlloc(PORUTO_BLOCK* block,u16 idx,int heapID)
{
	PORUTO_DATA* dest;
	
	dest = PorutoData_AllocWork(heapID);
	
	if(idx >= PORUTO_STOCK_MAX){
		PorutoData_Clear(dest);
		return NULL;
	}
	
	//擾
	PorutoData_Copy(&block->poruto[idx],dest);
	return dest;
}

/**
 *	@brief	Z[uf[^̈ɂLȃ|gf[^Ԃ
 */
u16	PORUTO_GetDataNum(PORUTO_BLOCK* block)
{
	u16	num = 0,i;

	for(i = 0;i < PORUTO_STOCK_MAX;i++){
		if(PorutoData_IsEnable(&block->poruto[i])){
			++num;
		}
	}
	return num;
}

#ifdef PM_DEBUG
/**
 *	@brief	|gfobO@f[^S
 */
void PorutoDebug_AllDataDelete(PORUTO_BLOCK* block)
{
	u16	i = 0;

	for(i = 0;i < PORUTO_STOCK_MAX;i++){
		PorutoData_Clear(&block->poruto[i]);
	}
}

/**
 *	Kȃp[^_
 */
#define PARA_DMYMAX	(99)
#define PARA_DMYNMAX	(48)
static void porudeb_CreateRndParam(PORUTO_DATA* dat)
{
	u8	main,sub;
	u8	param[PORUTO_PARAID_NUM];

	MI_CpuClear8(param,PORUTO_PARAID_NUM);

	//C̖߂
	main = gf_rand()%PORUTO_FTYPE_MAX;

	//~bNX閡߂
	sub = gf_rand()%PORUTO_FTYPE_NUM;

	if(main == PORUTO_FTYPE_MIX){
		u8 i,j,ct;
		switch(sub){
		case 0:	//܂
			for(ct = 0;ct < 3;ct++){
				j = gf_rand()%PORUTO_FTYPE_NUM;
				for(i = 0;i < PORUTO_FTYPE_NUM;i++){
					if(param[j] == 0){
						break;
					}
					j = (j+1)%PORUTO_FTYPE_NUM;	
				}
				param[j] = 2;
			}
			dat->flavor = PORUTO_FLAVOR_NGOOD;
			break;
		case 1:	//܂₩
			i = gf_rand()%PORUTO_FTYPE_NUM;
			j = gf_rand()%PORUTO_FTYPE_NUM;
			param[i] = gf_rand()%(PARA_DMYMAX-PORUTO_MILD_VALUE)+PORUTO_MILD_VALUE;
			param[j] = gf_rand()%(PARA_DMYMAX-PORUTO_MILD_VALUE)+PORUTO_MILD_VALUE;
			dat->flavor = PORUTO_FLAVOR_MILD;
			break;
		default:
			for(ct = 0;ct < (sub+1);ct++){
				j = gf_rand()%PORUTO_FTYPE_NUM;
				for(i = 0;i < PORUTO_FTYPE_NUM;i++){
					if(param[j] == 0){
						break;
					}
					j = (j+1)%PORUTO_FTYPE_NUM;	
				}
				param[j] = gf_rand()%(PARA_DMYMAX-1)+1;
			}
			if(sub == 2){
				dat->flavor = PORUTO_FLAVOR_HEAVY;
			}else{
				dat->flavor = PORUTO_FLAVOR_THICK;
			}
			break;
		}
	}else{
		//C
		param[main] = gf_rand()%(PARA_DMYNMAX)+2;
		//Tu
		if(sub != main){	//Cȉ̒lݒ
			param[sub] = gf_rand()%(param[main]-1)+1;
		}
		dat->flavor = main*PORUTO_FTYPE_NUM+sub;	//
	}
	//|
	dat->taste = gf_rand()%PARA_DMYMAX;

	//̃p[^o
	dat->spicy = param[0];
	dat->astringent = param[1];
	dat->sweet = param[2];
	dat->bitter = param[3];
	dat->sour = param[4];
}

/**
 *	@brief	|gfobO@eLg[ȃ|gw肵ǉ
 */
u16 PorutoDebug_AddRndData(PORUTO_BLOCK* block,u16 num)
{
	u16	ret = 0,i;
	
	for(i = 0;i < PORUTO_STOCK_MAX;i++){
		if(PorutoData_IsEnable(&block->poruto[i])){
			continue;
		}
		//_ȃp[^
		porudeb_CreateRndParam(&block->poruto[i]);
		if(++ret >= num){
			return ret;
		}
	}
	return ret;
}

#endif	//PM_DEBUG
